﻿
'Copyright © 2016 Jean-Jacques STACINO
' author mail : jj.stac @ aliceadsl.fr


'This program is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    This program is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with this program.  If not, see <http://www.gnu.org/licenses/>.


' This file is part of VBHector.

'    VBHector is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    Foobar is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with VBHector.  If not, see <http://www.gnu.org/licenses/>.

' Several part such as modZ80, modAY8912 are from GPL project (VBSpec)
'   Tranlation from VB6 to VBNet and much more had been made.
'   Thanks' to them authors (Chris Cowley, Xavier) 
'   Note that the original files from Chris Cowley are joined to this project (Directory "Sources Licences" . 
' Emulation of the MEA8000 is from A.Mine, that I want to thank here for him's agreement.


Imports System.IO

Public Class Bin2K7

    'Data générale d'un bloc !
    Dim Type_Bloc As String
    Dim K7() As Byte
    Dim PointeurK7 As Integer
    Dim Taille As Integer = 0

    'pour la mise en place d'un bloc
    Dim Buff() As Byte
    Dim Adr_Charg As UInt16
    Dim Adr_Lanc As UInt16
    Dim Adr_Pile As UInt16
    Dim F_Long As UInt16
    Dim Octet As Byte

    Public Resol_EC As String = "HR"
    Public Page_EC As String = "Prg"


    Private Sub Button1_Click(sender As Object, e As EventArgs) Handles Button1.Click
        Me.Visible = False
    End Sub


    'Aller chercher le fichier binaire source
    Private Sub File_Binary_Click(sender As Object, e As EventArgs)
        OpenFileDialogBinairy.ShowDialog()
        TextBox_Binary.Text = OpenFileDialogBinairy.FileName
        If Not (File.Exists(TextBox_Binary.Text)) Then
            TextBox_Binary.Text = "error..."
        End If
    End Sub

    Private Sub ComboBoxTypeBloc_SelectedIndexChanged(sender As Object, e As EventArgs) Handles ComboBoxTypeBloc.SelectedIndexChanged
        Type_Bloc = Microsoft.VisualBasic.Left(ComboBoxTypeBloc.Text, 2)
    
        Select Case Type_Bloc

            Case "FF"
                ' Cas du Bloc de données en page programme 
                Label_Adr_Charg.Visible = True
                Label_Long.Visible = False
                Label_Adr_Lanc.Visible = False
                Label_Adr_Pile.Visible = False
                Label_Binary.Visible = True
                Label_Octet.Visible = False
                TextBox_Adr_Charg.Visible = True
                TextBox_Long.Visible = False
                TextBox_Adr_Lanc.Visible = False
                TextBox_Adr_Pile.Visible = False
                TextBox_Binary.Visible = True
                TextBox_Octet.Visible = False
                ButtonHelper.Visible = False
                Buttonopen.Visible = True
                Exit Select
            Case "FE"
                ' Cas du remplisage avec 1 donnée
                Label_Adr_Charg.Visible = True
                Label_Long.Visible = True
                Label_Adr_Lanc.Visible = False
                Label_Adr_Pile.Visible = False
                Label_Binary.Visible = False
                Label_Octet.Visible = True
                TextBox_Adr_Charg.Visible = True
                TextBox_Long.Visible = True
                TextBox_Adr_Lanc.Visible = False
                TextBox_Adr_Pile.Visible = False
                TextBox_Binary.Visible = False
                TextBox_Octet.Visible = True
                ButtonHelper.Visible = True
                Buttonopen.Visible = False
                Exit Select

            Case "FD"
                ' Fin de bande
                Label_Adr_Charg.Visible = False
                Label_Long.Visible = False
                Label_Adr_Lanc.Visible = True
                Label_Adr_Pile.Visible = True
                Label_Binary.Visible = False
                Label_Octet.Visible = False
                TextBox_Adr_Charg.Visible = False
                TextBox_Long.Visible = False
                TextBox_Adr_Lanc.Visible = True
                TextBox_Adr_Pile.Visible = True
                TextBox_Binary.Visible = False
                TextBox_Octet.Visible = False
                ButtonHelper.Visible = False
                Buttonopen.Visible = False

        End Select
    End Sub

    Private Sub Bin2K7_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        PointeurK7 = 0
        ReDim K7(0)
        Resol_EC = "HR"
        Page_EC = "Prg"

    End Sub

    Private Sub Lecture_Binary()
        'Controle fichier binaire !

        ' Un objet pour ouvrir le fichier
        Dim AA As New FileInfo(TextBox_Binary.Text)

        F_Long = CType(AA.Length, Integer)

        'Test si cohérent !
        If F_Long > &HFFFF - &H4000 Then
            MsgBox("Taille de fichier trop importante ! sortie !", MsgBoxStyle.Exclamation, "Pas possible, trop gros")
            Exit Sub
        End If

        'Suffisament de place pour y mettre le fichier !
        ReDim Buff(F_Long - 1)

        'Recup des données....
        Buff = My.Computer.FileSystem.ReadAllBytes(TextBox_Binary.Text)



    End Sub

    Private Sub PushOctet(ByVal Octet As Byte)
        K7(PointeurK7) = Octet
        PointeurK7 += 1
    End Sub
    Private Sub PushWord(ByVal Word As UInt16)
        PushOctet(Word And &HFF)
        PushOctet((Word >> 8) And &HFF)
    End Sub

    Private Sub ButtonAjout_Click(sender As Object, e As EventArgs) Handles ButtonAjout.Click

        Dim L As UInt16 = 0
        Dim NB_sector_Plein As UInt16 = 0
        Dim NB_Octet_Restant As UInt16 = 0

        If IsNothing(Type_Bloc) Then
            MsgBox("Selectionnez d'abord un type de bloc !", MsgBoxStyle.OkOnly, "Error")
            Exit Sub
        End If

        Adr_Charg = MainForm.Conv_Strg_To_Int(TextBox_Adr_Charg.Text)
        Adr_Lanc = MainForm.Conv_Strg_To_Int(TextBox_Adr_Lanc.Text)
        Adr_Pile = MainForm.Conv_Strg_To_Int(TextBox_Adr_Pile.Text)
        Octet = MainForm.Conv_Strg_To_Int(TextBox_Octet.Text)
        F_Long = MainForm.Conv_Strg_To_Int(TextBox_Long.Text) 'sera réécrit si c'est un fichier dans lecture binary!

        '********************************
        'Controle des differentes valeurs
        '********************************
        ' On dimensionne la variable avec la taille du fichier
        If Type_Bloc = "FF" Then
            'Que si c'est un bloc avec des fichiers...
            If Not (File.Exists(TextBox_Binary.Text)) Then
                MsgBox("Pas de fichier trouvé !!" & vbCrLf & "désolé...", MsgBoxStyle.Exclamation, "Pas possible, pas trouvé")
                TextBox_Binary.Text = "error..."
                Exit Sub
            End If
        End If

        Select Case Type_Bloc
            Case "FF"
                Lecture_Binary()

                '********************************
                'Controle des differentes valeurs
                '********************************

                Historik.AppendText("Bloc FF, @charg=" + MainForm.Caractere_hex4(Adr_Charg) + " Longueur=" + MainForm.Caractere_hex4(F_Long))

                'Calcul de la longueur nécessaire au bloc
                NB_sector_Plein = (F_Long >> 8)
                NB_Octet_Restant = F_Long - (NB_sector_Plein * 256)

                If NB_Octet_Restant <> 0 Then
                    L = 1 + 5 + NB_sector_Plein * (256 + 1) + NB_Octet_Restant + 1
                Else
                    L = 1 + 5 + NB_sector_Plein * (256 + 1)
                End If

                'Calcul de la taille du buffer
                Taille += L
                ReDim Preserve K7(Taille)

                'Création du bloc de commande
                PushOctet(5) ' Longueur
                PushWord(Adr_Charg)
                PushWord(F_Long)
                PushOctet(&HFF)

                For i = 0 To (F_Long - 1)
                    'Pour chaque octet du fichier binaire
                    If (i And &HFF) = 0 Then
                        'Ajout de la taille si on est modulo 256
                        If (F_Long - i) >= 256 Then
                            PushOctet(0)
                        Else
                            PushOctet(F_Long - i)
                        End If
                    End If

                    'Dans tous les cas on met l'octet !
                    PushOctet(Buff(i))
                Next i
                K7(0) = K7(0)
                Exit Select
            Case "FD"
                Historik.AppendText("Bloc FD, @pile=" + MainForm.Caractere_hex4(Adr_Pile) + " @lancement=" + MainForm.Caractere_hex4(Adr_Lanc))

                'Calcul de la taille du buffer
                Taille += 6
                ReDim Preserve K7(Taille)


                'Création du bloc de commande
                PushOctet(5) ' Longueur
                PushWord(Adr_Lanc)
                PushWord(Adr_Pile)
                PushOctet(&HFD)
                ' PushOctet(0) 'Suppression de l'octet final pour MESS en format K7 !
                Exit Select
            Case "FE"
                Historik.AppendText("Bloc FE, @Chargement=" + MainForm.Caractere_hex4(Adr_Charg) + " Nombre de duplication=" + F_Long.ToString + "(dec)")

                '             Programmation :  FE, adresse, longueur,valeur 
                '                    exemple : FE,6000,1000,0055 : Remplir la zone 6000 - 6FFF avec la constante 55

                'Calcul de la taille du buffer
                Taille += 8
                ReDim Preserve K7(Taille)


                'Création du bloc de commande
                PushOctet(5) ' Longueur
                PushWord(Adr_Charg)
                PushWord(F_Long)
                PushOctet(&HFE)
                PushOctet(1) ' Le bloc de données fait 1 de longueur
                PushOctet(Octet) ' L'octet à écrire
                Exit Select
        End Select

        Historik.AppendText(vbCrLf + "     => Page : " + Page_EC + ", Résolution en cours :" + Resol_EC + " (si changements créés avec HELP!)" + vbCrLf)
        Historik.AppendText(vbCrLf + "     => Taille =" + Taille.ToString + vbCrLf)

    End Sub

    Private Sub ButtonClear_Click(sender As Object, e As EventArgs) Handles ButtonClear.Click
        ReDim K7(0)
        PointeurK7 = 0
        Resol_EC = "HR"
        Page_EC = "Prg"
        Historik.Text = "Recommencez !" + vbCrLf
    End Sub

    Private Sub ButtonSave_Click(sender As Object, e As EventArgs) Handles ButtonSave.Click
        If PointeurK7 < 1 Then
            MsgBox("Créez d'abord des blocs !", MsgBoxStyle.OkOnly, "Erreur !")
            Exit Sub
        End If
        Dim F As New SaveFileDialog
        Dim Res As Microsoft.VisualBasic.MsgBoxResult

        F.Filter = "Fichier à sauvegarder (*.K7)|*.K7"
        F.Title = "Choisir un nom de fichier pour enregistrer le fichier K7"
        Res = F.ShowDialog()
        If (Res = vbCancel) Then
            Exit Sub
        End If

        If (File.Exists(F.FileName)) Then
            File.Delete(F.FileName)
        End If

        'Sauvegarde du fichier
        My.Computer.FileSystem.WriteAllBytes(F.FileName, K7, False)

        ReDim K7(0)
        PointeurK7 = 0
        Historik.Text = "Vous pouvez recommencez !" + vbCrLf

    End Sub

    Private Sub ButtonHelper_Click(sender As Object, e As EventArgs) Handles ButtonHelper.Click
        Dim F As New Bin2K7_Helper

        If F.ShowDialog() = Windows.Forms.DialogResult.OK Then
            'Mise en place du paramétrage demandé !
            TextBox_Adr_Charg.Text = F.Adr_Ch
            TextBox_Octet.Text = F.Oct
            TextBox_Long.Text = F.Nb

            Select Case F.Adr_Ch
                Case "0800"
                    '  0x800 => video page, HR
                    Resol_EC = "HR"
                    Page_EC = "Vidéo"
                    Exit Select
                Case "0808"
                    '0x808 => base page, HR
                    Resol_EC = "HR"
                    Page_EC = "Prg"
                    Exit Select
                Case "080C"
                    '0x80c => base page, BR
                    Resol_EC = "BR"
                    Page_EC = "Prg"
                    Exit Select
                Case "0808"
                    ' 0x804 => video page, BR
                    Resol_EC = "BR"
                    Page_EC = "Vidéo"
                    Exit Select
                Case Else
                    Exit Select
            End Select
        End If
    End Sub

    Private Sub Buttonopen_Click(sender As Object, e As EventArgs) Handles Buttonopen.Click
        OpenFileDialogBinairy.ShowDialog()
        TextBox_Binary.Text = OpenFileDialogBinairy.FileName
        If Not (File.Exists(TextBox_Binary.Text)) Then
            TextBox_Binary.Text = "error..."
        End If
    End Sub
End Class