﻿
'Copyright © 2016 Jean-Jacques STACINO
' author mail : jj.stac @ aliceadsl.fr


'This program is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    This program is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with this program.  If not, see <http://www.gnu.org/licenses/>.


' This file is part of VBHector.

'    VBHector is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    Foobar is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with VBHector.  If not, see <http://www.gnu.org/licenses/>.

' Several part such as modZ80, modAY8912 are from GPL project (VBSpec)
'   Tranlation from VB6 to VBNet and much more had been made.
'   Thanks' to them authors (Chris Cowley, Xavier) 
'   Note that the original files from Chris Cowley are joined to this project (Directory "Sources Licences" . 
' Emulation of the MEA8000 is from A.Mine, that I want to thank here for him's agreement.



Option Explicit On
Option Strict On
' Yo_fr (jj.stac @ aliceadsl.fr)
' Le 20/12/2012 !
' Ce code est libre d'utilisation et de diffusion (sous licence GPL V3), néanmoins si vous utilisez mon code,
' merci de m'envoyer un petit mail !
' Si vous améliorez / corrigez des bug, merci de me le renvoyer la correction !

' This code is free to use and distribute (under GPL V3 licence), however if you use my code thank you send me a mail!
' If you improve / correct the bug, thank you for returning it to me!


Imports System
Imports System.Runtime.InteropServices

Public Module Disc2  ' La class ne permet pas d'échange des data entre le thread principal et la class. passage en module 19/11/2012
    ' Début le 15/11 
    ' Mise en place du Z80 en thread séparé, RAM/ROM, échange avec Hector : 25/11/2012
    ' Début de prog du uPD765 : 25/11 !
    ' La fin on peu la mettre au 20/12/12 (à Buenos Aires)
    ' Suite à la relecture.
    ' Il ne manque à ce jour que 2 choses : l'enregistrement d"'une disquette dans un fichiier
    ' => c'est fait ! 
    ' aisni que la fonction de formatage du uPD765...

    ' Mémoire du Disc 2
    Public MemRAM(65536) As Byte
    Public MemROM(4096) As Byte
    Public BST As Boolean = False   ' Flag hard selection ROM/RAM

    'Mémoire intermédiaire Hector, Disc2 :
    Public Disc2_data_r_ready As Boolean
    Public Disc2_data_read As Byte ' Octet Hector => Disc

    Public Disc2_data_w_ready As Boolean ' Octet Disc => Hector dispo
    Public Disc2_data_write As Byte ' data send by Disc2, to Hector

    ' Déclaration du controleur

    Public Disc2_RNMI As Boolean ' Autorisation NMI donnée par le Z80.
    Public Disc2_INT As Boolean  ' Demande d'INT  sur le Z80 du disc2
    Public Disc2_NMI As Boolean  ' Demande d'NMI  sur le Z80 du disc2
    Public Wait_Time_NMI As Long ' Temps d'attente avant NMI
    Public Ask_for_debug As Boolean = False
    Dim Mem_RNMI As Boolean = False

    ' Ici on effectue les demandes en mémoire et de port du
    ' Z80 du Disc2.

    Public Function MemR(ByRef Addr As Integer) As Byte
        'Si la mémoire n'est pas dans la bonne fourchette...
        If Addr > &H10000 Then Addr = Addr And &HFFFF

        If Not (BST) And (Addr < 4096) Then
            'Lecture de la memoire ROM
            MemR = (MemROM(Addr)) 'And &HFF
        Else
            ' Lecture de la RAM dans les autres cas
            MemR = MemRAM(Addr) 'And &HFF
        End If
        '    If Addr = &HFF6B Then MemR = 1 ' Mode Verbose du Disc2
    End Function

    Public Sub MemW(ByRef Addr As Integer, ByVal val As Byte)
        If Not (BST) And (Addr < 4096) Then
            'Pas d'écriture en ROM ! 
            '      MemROM(Addr) = val
        Else
            MemRAM(Addr) = val
        End If
    End Sub

    Sub outb(ByVal Port As Integer, ByVal outbyte As Byte, Optional ByVal tstates As Integer = 0)
        'On masque le port, qui de toutes façon est en 8 bits...
        Port = Port And &HFF

        Select Case Port
            Case &H0
                ' ecriture Port 00 : Passage ROM => RAM 
                BST = True
                Exit Select
                'Case &h20 :  You can implemente the 8251 chip communication here !
            Case &H30
                ' Rien ici !
                Exit Select
            Case &H40
                ' écriture Port 40 :
                Disc2_data_write = outbyte
                Disc2_data_w_ready = True
                Exit Select
            Case &H50
                ' écriture Port 50 : Stuff lecteur Disc2.

                '  FDC Motor Control - Bit 0/1 defines the state of the FDD 0/1 motor */
                '	floppy_mon_w(floppy_get_device(space->machine(), 0), BIT(data, 0));	// Moteur floppy A:
                '	floppy_mon_w(floppy_get_device(space->machine(), 1), BIT(data, 1));	// Moteur floppy B:
                ' Okay, si le moteur ne tourne pas je ne devrais pas réussir à lire quoi que ce soit ... 
                ' J'ai pris bonne note !

                ' Write bit TC uPD765 on D4 of port I/O 50 */
                '	upd765_tc_w(fdc, BIT(data, 4));  // Seems not used...


                ' Authorization interrupt and NMI with RNMI signal
                Disc2_RNMI = (outbyte And &H20) <> 0  ' état du RNMI


                If Disc2_RNMI <> Mem_RNMI Then
                    ' Pour la trace à l'écran du changement d'état du RNMI !
                    If Disc2_RNMI Then
                        If Demande_Trace_fd Then Strg_FdC765 += "Change RNMI à TRUE !" + vbCrLf
                    Else
                        If Demande_Trace_FD Then Strg_FdC765 += "Change RNMI à FALSE! " + vbCrLf
                    End If
                    Mem_RNMI = Disc2_RNMI
                End If

                Exit Select
            Case &H60
                ' écriture Port 60 : uPD765

                ' On ne peut écrire un status ! 
                ' => out !
                Exit Select
            Case &H61
                ' écriture Port 61 : uPD765
                uPD765.Ecrit_Registre(outbyte)
                Exit Select

            Case &H70
                ' écriture Port 70 : lecture DMA uPD765
                Ecriture_DMA(outbyte)
                Exit Select

            Case Else
                Exit Select
        End Select
    End Sub

    Function inb(ByVal port As Integer) As Integer
        Dim Val As Byte = 0

        port = port And &HFF

        Select Case port
            Case &H0
                ' Lecture Port 00 : Passage ROM => RAM 
                BST = True
                Exit Select
            Case &H30
                ' Lecture Port 30 :
                If (Disc2_data_r_ready) Then
                    Val = &H8 ' Bit 3
                End If
                Exit Select
            Case &H40
                ' Lecture Port 40 :
                Val = Disc2_data_read
                Disc2_data_r_ready = False
                Exit Select
            Case &H50
                ' Lecture Port 50 :  lecteur Disc2
                If (Disc2_data_w_ready) Then
                    Val = &H80 ' bit 7
                End If
                Exit Select
            Case &H60
                ' Lecture Port 60 : Lecture du status du uPD765
                Val = uPD765.Lecture_Status()
                Exit Select
            Case &H61
                ' Lecture Port 61 : Lecture du registre du uPD765
                Val = uPD765.Lecture_Registre()
                Exit Select
            Case &H70
                ' Lecture type DMA sur le uPD
                Val = uPD765.Lecture_DMA
            Case Else
                Exit Select
        End Select

        inb = Val
    End Function

End Module
