﻿
'Copyright © 2016 Jean-Jacques STACINO
' author mail : jj.stac @ aliceadsl.fr


'This program is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    This program is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with this program.  If not, see <http://www.gnu.org/licenses/>.


' This file is part of VBHector.

'    VBHector is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    Foobar is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with VBHector.  If not, see <http://www.gnu.org/licenses/>.

' Several part such as modZ80, modAY8912 are from GPL project (VBSpec)
'   Tranlation from VB6 to VBNet and much more had been made.
'   Thanks' to them authors (Chris Cowley, Xavier) 
'   Note that the original files from Chris Cowley are joined to this project (Directory "Sources Licences" . 
' Emulation of the MEA8000 is from A.Mine, that I want to thank here for him's agreement.

Option Explicit On
Imports System.Drawing


Public Class Keyboard

    Dim H(5) As Integer
    Dim L_pair(13) As Integer
    Dim L_impair(13) As Integer

    'Coordonnées de la touche courante
    Dim Trouve As Boolean = False
    Dim ToucheX, ToucheY As Integer


    'Saisie au vol des appuies de touches !
    Private Sub Form1_KeyUp(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles MyBase.KeyUp
        Clavier(e)
    End Sub
    Private Sub Clavier(e As KeyEventArgs)

        Dim keyName As String = [Enum].GetName(GetType(System.Windows.Forms.Keys), CType(e.KeyValue, System.Windows.Forms.Keys))

        'Affichage du code et du caractere saisi
        CodePC_New.Text = e.KeyValue
        Code_Pc_New.Text = keyName
        Me.ActiveControl = Nothing

    End Sub
  
    Private Sub Keyboard_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        'Mise en place des ascenseurs
        Me.AutoScroll = MainForm.AscenseurSurFrameToolStripMenuItem.Checked

        'Définition des positions, des textes etc.. associés aux touches, joystick et aux actions possible dans l'émulateur
        H(0) = 133
        H(1) = 183
        H(2) = 233
        H(3) = 283
        H(4) = 333
        H(5) = 383

        L_impair(0) = 55
        L_impair(1) = 133
        L_impair(2) = 182
        L_impair(3) = 234
        L_impair(4) = 281
        L_impair(5) = 331
        L_impair(6) = 379
        L_impair(7) = 428
        L_impair(8) = 481
        L_impair(9) = 527
        L_impair(10) = 577
        L_impair(11) = 628
        L_impair(12) = 678

        L_pair(0) = 55
        L_pair(1) = 108
        L_pair(2) = 160
        L_pair(3) = 210
        L_pair(4) = 259
        L_pair(5) = 310
        L_pair(6) = 359
        L_pair(7) = 409
        L_pair(8) = 458
        L_pair(9) = 507
        L_pair(10) = 555
        L_pair(11) = 602
        L_pair(12) = 678

        For Y = 1 To 5
            For X = 1 To 12

                'Definition des positions en Y (simple)
                MainForm.Key(X, Y).Haut = H(Y - 1)
                MainForm.Key(X, Y).bas = H(Y)

                'Definition des positions en X (...)
                If (Y Mod 2) = 0 Then
                    ' Lignes Paires
                    MainForm.Key(X, Y).Gauche = L_pair(X - 1)
                    MainForm.Key(X, Y).Droit = L_pair(X)

                Else
                    ' Lignes Impaires
                    MainForm.Key(X, Y).Gauche = L_impair(X - 1)
                    MainForm.Key(X, Y).Droit = L_impair(X)

                End If
            Next X
        Next Y

        For x = 3 To 10
            MainForm.Key(x, 5).Gauche = L_impair(2)
            MainForm.Key(x, 5).Droit = L_impair(10)
        Next x

        'Reset
        MainForm.Key(12, 6).Haut = 42
        MainForm.Key(12, 6).bas = 84
        MainForm.Key(12, 6).Gauche = 622
        MainForm.Key(12, 6).Droit = 674

        ' Les codes spéciaux !
        MainForm.Key(1, 6).Haut = 555 ' "<- Joy"
        MainForm.Key(1, 6).Gauche = 205

        MainForm.Key(2, 6).Haut = 555 ' "Joy ->"
        MainForm.Key(2, 6).Gauche = 360

        MainForm.Key(3, 6).Haut = 539 ' "Joy ^"
        MainForm.Key(3, 6).Gauche = 270

        MainForm.Key(4, 6).Haut = 617 ' "Joy v"
        MainForm.Key(4, 6).Gauche = 270

        MainForm.Key(5, 6).Haut = 490 ' "Joy Fire"
        MainForm.Key(5, 6).Gauche = 328

        MainForm.Key(6, 6).Haut = 435 ' "Joy Pot+"
        MainForm.Key(6, 6).Gauche = 665

        MainForm.Key(7, 6).Haut = 514 ' "Joy Pot-"
        MainForm.Key(7, 6).Gauche = 665


        'Copie écran
        MainForm.Key(8, 6).Haut = 485 '400
        MainForm.Key(8, 6).Gauche = 92 '180
        'Debuggage
        MainForm.Key(9, 6).Haut = 485 '400
        MainForm.Key(9, 6).Gauche = 192 '180


        'Ligne 1
        MainForm.Key(1, 1).Touche_Hector = "1"
        MainForm.Key(2, 1).Touche_Hector = "2"
        MainForm.Key(3, 1).Touche_Hector = "3"
        MainForm.Key(4, 1).Touche_Hector = "4"
        MainForm.Key(5, 1).Touche_Hector = "5"
        MainForm.Key(6, 1).Touche_Hector = "6"
        MainForm.Key(7, 1).Touche_Hector = "7"
        MainForm.Key(8, 1).Touche_Hector = "8"
        MainForm.Key(9, 1).Touche_Hector = "9"
        MainForm.Key(10, 1).Touche_Hector = "0"
        MainForm.Key(11, 1).Touche_Hector = "-"
        MainForm.Key(12, 1).Touche_Hector = "+"

        'Ligne 2
        MainForm.Key(1, 2).Touche_Hector = "Q"
        MainForm.Key(2, 2).Touche_Hector = "W"
        MainForm.Key(3, 2).Touche_Hector = "E"
        MainForm.Key(4, 2).Touche_Hector = "R"
        MainForm.Key(5, 2).Touche_Hector = "T"
        MainForm.Key(6, 2).Touche_Hector = "Y"
        MainForm.Key(7, 2).Touche_Hector = "U"
        MainForm.Key(8, 2).Touche_Hector = "I"
        MainForm.Key(9, 2).Touche_Hector = "O"
        MainForm.Key(10, 2).Touche_Hector = "P"
        MainForm.Key(11, 2).Touche_Hector = "="
        MainForm.Key(12, 2).Touche_Hector = "ret"

        'Ligne 3
        MainForm.Key(1, 3).Touche_Hector = "A"
        MainForm.Key(2, 3).Touche_Hector = "S"
        MainForm.Key(3, 3).Touche_Hector = "D"
        MainForm.Key(4, 3).Touche_Hector = "F"
        MainForm.Key(5, 3).Touche_Hector = "G"
        MainForm.Key(6, 3).Touche_Hector = "H"
        MainForm.Key(7, 3).Touche_Hector = "J"
        MainForm.Key(8, 3).Touche_Hector = "K"
        MainForm.Key(9, 3).Touche_Hector = "L"
        MainForm.Key(10, 3).Touche_Hector = ";"
        MainForm.Key(11, 3).Touche_Hector = "*"
        MainForm.Key(12, 3).Touche_Hector = "/"

        'Ligne 4
        MainForm.Key(1, 4).Touche_Hector = "Shift"
        MainForm.Key(2, 4).Touche_Hector = "Z"
        MainForm.Key(3, 4).Touche_Hector = "X"
        MainForm.Key(4, 4).Touche_Hector = "C"
        MainForm.Key(5, 4).Touche_Hector = "V"
        MainForm.Key(6, 4).Touche_Hector = "B"
        MainForm.Key(7, 4).Touche_Hector = "N"
        MainForm.Key(8, 4).Touche_Hector = "M"
        MainForm.Key(9, 4).Touche_Hector = ","
        MainForm.Key(10, 4).Touche_Hector = "."
        MainForm.Key(11, 4).Touche_Hector = "?"
        MainForm.Key(12, 4).Touche_Hector = "Shift"

        'Ligne 5
        MainForm.Key(1, 5).Touche_Hector = "Lock"
        MainForm.Key(2, 5).Touche_Hector = "Tab"
        MainForm.Key(3, 5).Touche_Hector = "Space"
        MainForm.Key(4, 5).Touche_Hector = "Space"
        MainForm.Key(5, 5).Touche_Hector = "Space"
        MainForm.Key(6, 5).Touche_Hector = "Space"
        MainForm.Key(7, 5).Touche_Hector = "Space"
        MainForm.Key(8, 5).Touche_Hector = "Space"
        MainForm.Key(9, 5).Touche_Hector = "Space"
        MainForm.Key(10, 5).Touche_Hector = "Space"
        MainForm.Key(11, 5).Touche_Hector = "Bck Spc"
        MainForm.Key(12, 5).Touche_Hector = "Ctrl"

        ' Les codes spéciaux !
        MainForm.Key(1, 6).Touche_Hector = "<- Joy"
        MainForm.Key(2, 6).Touche_Hector = "Joy ->"
        MainForm.Key(3, 6).Touche_Hector = "Joy ^"
        MainForm.Key(4, 6).Touche_Hector = "Joy v"
        MainForm.Key(5, 6).Touche_Hector = "Joy Fire"
        MainForm.Key(6, 6).Touche_Hector = "Joy Pot+"
        MainForm.Key(7, 6).Touche_Hector = "Joy Pot-"
        MainForm.Key(8, 6).Touche_Hector = "Imprm écran"
        MainForm.Key(9, 6).Touche_Hector = "Start debug"
        MainForm.Key(12, 6).Touche_Hector = "Reset"

        Affiche_PC()
        PictureKeybd.Invalidate()

    End Sub

    Private Sub PictureKeybd_MouseDown(sender As Object, e As MouseEventArgs) Handles PictureKeybd.MouseDown
        ' on a cliqué sur l'image : on regarde ù et on agit !
        Trouve = False

        'Detection de la touche
        ' N° de ligne
        ToucheX = 0
        ToucheY = 0

        For LY = 1 To 5  ' Les lignes du clavier
            If e.Y > H(LY - 1) And e.Y < H(LY) Then
                ToucheY = LY
            End If
        Next

        For LX = 1 To 12
            If (ToucheY Mod 2) = 0 Then 'Ligne Paires
                If e.X > L_pair(LX - 1) And e.X < L_pair(LX) Then
                    ToucheX = LX
                End If
            Else '                       Ligne Impaires
                If e.X > L_impair(LX - 1) And e.X < L_impair(LX) Then
                    ToucheX = LX
                End If
            End If
        Next

        'pour le reset
        If e.X > 622 And e.X < 674 And e.Y > 42 And e.Y < 84 Then
            ToucheX = 12
            ToucheY = 6
        End If
        'pour la touche space
        If ToucheY = 5 And ToucheX > 2 And ToucheX < 11 Then
            ToucheX = 3
        End If

        Info_Touche.Text = MainForm.Key(ToucheX, ToucheY).Touche_Hector

        If ToucheX <> 0 And ToucheY <> 0 Then
            Trouve = True
            PictureKeybd.Invalidate()
            Dim Vval As Integer
            Vval = MainForm.Key(ToucheX, ToucheY).Code_PC
            ' Affichage 
            Dim keyName As String = [Enum].GetName(GetType(System.Windows.Forms.Keys), CType(Vval, System.Windows.Forms.Keys))

            CodePC.Text = Vval  '  e.keycode.tostring ' GetKeyNameText(55) ' 
            Code_PC.Text = keyName ' Chr(e.KeyValue)
            Affiche_PC()

        End If
    End Sub

    Private Sub PictureKeybd_Paint(sender As Object, e As PaintEventArgs) Handles PictureKeybd.Paint

        ' on a demandé le redessin 
        If Trouve Then
            ' Dessin du carre rouge 

            ' Create pen.
            Dim redPen As New Pen(Color.Red, 4)

            ' Create points that define line.
            Dim point1 As New Point(100, 100)
            Dim point2 As New Point(500, 100)

            ' Draw line to screen.
            Dim g As Graphics = Me.CreateGraphics()

            If ToucheY <> 6 Or (ToucheY = 6 And ToucheX = 12) Then
                e.Graphics.DrawLine(redPen, MainForm.Key(ToucheX, ToucheY).Gauche, MainForm.Key(ToucheX, ToucheY).Haut, MainForm.Key(ToucheX, ToucheY).Gauche, MainForm.Key(ToucheX, ToucheY).bas)
                e.Graphics.DrawLine(redPen, MainForm.Key(ToucheX, ToucheY).Gauche, MainForm.Key(ToucheX, ToucheY).Haut, MainForm.Key(ToucheX, ToucheY).Droit, MainForm.Key(ToucheX, ToucheY).Haut)
                e.Graphics.DrawLine(redPen, MainForm.Key(ToucheX, ToucheY).Droit, MainForm.Key(ToucheX, ToucheY).Haut, MainForm.Key(ToucheX, ToucheY).Droit, MainForm.Key(ToucheX, ToucheY).bas)
                e.Graphics.DrawLine(redPen, MainForm.Key(ToucheX, ToucheY).Droit, MainForm.Key(ToucheX, ToucheY).bas, MainForm.Key(ToucheX, ToucheY).Gauche, MainForm.Key(ToucheX, ToucheY).bas)
            End If
            redPen.Dispose()
        End If

        Dim KeyName As String
        Dim X, Y, PosX, PosY As Integer
        Dim YUp As Integer = 0
        Dim Longueur As Integer

        Dim drawFont As New System.Drawing.Font("Arial", 10)
        Dim drawBrush As New System.Drawing.SolidBrush(System.Drawing.Color.Beige)


        Dim drawFormat As New System.Drawing.StringFormat

        ' mise en place des textes
        For Y = 1 To 6
            Longueur = 0
            YUp = 0
            For X = 1 To 12
                KeyName = [Enum].GetName(GetType(System.Windows.Forms.Keys), CType(MainForm.Key(X, Y).Code_PC, System.Windows.Forms.Keys)) & vbCrLf
                PosX = MainForm.Key(X, Y).Gauche
                PosY = MainForm.Key(X, Y).Haut
                If Longueur > 5 And Y <> 6 Then
                    If YUp = PosY And (X <> 3 And Y <> 5) Then
                        PosY += 13
                    End If
                End If
                YUp = PosY

                'Definition de la couleur du texte - ligne 6 : joystick et système
                If (Y = 6 And X <> 12) Then
                    drawBrush.Color = System.Drawing.Color.Black
                Else
                    drawBrush.Color = System.Drawing.Color.Beige
                End If

                'On dessine le texte à l'endroit défini
                e.Graphics.DrawString(KeyName, drawFont, drawBrush, PosX, PosY, drawFormat)

                ' on saute les espaces...
                If Y = 5 And X = 3 Then
                    X = 10
                End If
                If Y = 6 And X = 9 Then ' ...et les trous des accéssoires !
                    X = 11
                End If
                'pour le prochain coup
                Longueur = KeyName.Length
            Next X
        Next Y

        ' On rend tout 
        drawFont.Dispose()
        drawBrush.Dispose()

    End Sub

    Private Sub ButtonOK_Click(sender As Object, e As EventArgs) Handles ButtonOK.Click
        Me.Close()
    End Sub

 
    Private Sub ButtonAssocier_Click(sender As Object, e As EventArgs) Handles ButtonAssocier.Click
        ' mise en place du choix
        If Val(CodePC_New.Text) = 0 Then Exit Sub

        'on recupére le code si tout va bien 
        MainForm.Key(ToucheX, ToucheY).Code_PC = Val(CodePC_New.Text)
        Info_Ok.Visible = True
        TimerDisplay.Enabled = True
        Affiche_PC()

        Dim Vval As Integer
        Vval = Val(CodePC.Text)
        ' Affichage 
        Dim keyName As String = [Enum].GetName(GetType(System.Windows.Forms.Keys), CType(Vval, System.Windows.Forms.Keys))

        CodePC.Text = Vval  '  e.keycode.tostring ' GetKeyNameText(55) ' 
        Code_PC.Text = keyName ' Chr(e.KeyValue)

    End Sub

    Private Sub ButtonCopie_Click(sender As Object, e As EventArgs) Handles ButtonCopie.Click
        ToucheX = 8
        ToucheY = 6
        Affiche_PC()
        ButtonCopie.BackColor = Color.Red
    End Sub


    Private Sub Affiche_PC()
        Dim Vval As Integer
        Vval = MainForm.Key(ToucheX, ToucheY).Code_PC
        ' Affichage 
        Dim keyName As String = [Enum].GetName(GetType(System.Windows.Forms.Keys), CType(Vval, System.Windows.Forms.Keys))

        CodePC.Text = Vval
        Code_PC.Text = keyName

        ' on grise les boutons
        Info_Touche.Text = MainForm.Key(ToucheX, ToucheY).Touche_Hector
        BJoyG.BackColor = Color.Gainsboro
        BJoyD.BackColor = Color.Gainsboro
        BJoyH.BackColor = Color.Gainsboro
        BJoyB.BackColor = Color.Gainsboro

        BFire.BackColor = Color.Gainsboro

        BPotP.BackColor = Color.Gainsboro
        BPotM.BackColor = Color.Gainsboro

        ButtonCopie.BackColor = Color.Gainsboro
        BDebug.BackColor = Color.Gainsboro

        'on lance le redraw
        PictureKeybd.Invalidate()

    End Sub

    Private Sub BJoyG_Click(sender As Object, e As EventArgs) Handles BJoyG.Click
        ToucheX = 1
        ToucheY = 6
        Affiche_PC()
        BJoyG.BackColor = Color.Red
    End Sub
    Private Sub BJoyD_Click(sender As Object, e As EventArgs) Handles BJoyD.Click
        ToucheX = 2
        ToucheY = 6
        Affiche_PC()
        BJoyD.BackColor = Color.Red
    End Sub
    Private Sub BJoyH_Click(sender As Object, e As EventArgs) Handles BJoyH.Click
        ToucheX = 3
        ToucheY = 6
        Affiche_PC()
        BJoyH.BackColor = Color.Red
    End Sub
    Private Sub BJoyB_Click(sender As Object, e As EventArgs) Handles BJoyB.Click
        ToucheX = 4
        ToucheY = 6
        Affiche_PC()
        BJoyB.BackColor = Color.Red
    End Sub

    Private Sub BFire_Click(sender As Object, e As EventArgs) Handles BFire.Click
        ToucheX = 5
        ToucheY = 6
        Affiche_PC()
        BFire.BackColor = Color.Red
    End Sub

    Private Sub BPotP_Click(sender As Object, e As EventArgs) Handles BPotP.Click
        ToucheX = 6
        ToucheY = 6
        Affiche_PC()
        BPotP.BackColor = Color.Red
    End Sub
    Private Sub BPotM_Click(sender As Object, e As EventArgs) Handles BPotM.Click
        ToucheX = 7
        ToucheY = 6
        Affiche_PC()
        BPotM.BackColor = Color.Red
    End Sub

    Private Sub TimerDisplay_Tick(sender As Object, e As EventArgs) Handles TimerDisplay.Tick
        Info_Ok.Visible = False
        TimerDisplay.Enabled = False
    End Sub

    Private Sub BDebug_Click(sender As Object, e As EventArgs) Handles BDebug.Click
        ToucheX = 9
        ToucheY = 6
        Affiche_PC()
        BDebug.BackColor = Color.Red

    End Sub
End Class