﻿
'Copyright © 2016 Jean-Jacques STACINO
' author mail : jj.stac @ aliceadsl.fr


'This program is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    This program is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with this program.  If not, see <http://www.gnu.org/licenses/>.


' This file is part of VBHector.

'    VBHector is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    Foobar is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with VBHector.  If not, see <http://www.gnu.org/licenses/>.

' Several part such as modZ80, modAY8912 are from GPL project (VBSpec)
'   Tranlation from VB6 to VBNet and much more had been made.
'   Thanks' to them authors (Chris Cowley, Xavier) 
'   Note that the original files from Chris Cowley are joined to this project (Directory "Sources Licences" . 
' Emulation of the MEA8000 is from A.Mine, that I want to thank here for him's agreement.

Option Explicit On
'Option Strict On

Imports sharpdx
Imports SharpDX.DirectSound
Imports System.Threading
Imports System.IO


Public Class MainForm
    ' Projet débuté le 02 septembre 2012
    ' Yo_fr (jj.stac @ aliceadsl.fr)

    ' Le 10/11/2012 
    ' HRX/MX/HRP, K7, BR/HR/80c, color, Bright : OK!  
    ' Gestion du magnétophone :
    ' Réalisé à Tanger (septembre 2012) et à Bursa 26/10/2012
    ' Mise en place du Disc2 en novembre 2012. 
    ' 1er lancement du CP/M le 5/12/12.
    ' Peaufinage de l'écriture fait Buenos Aires le 20/12/12
    ' (je prends l'avions durant la fin du monde à 2h20 le 21/12/12 !)
    ' Mise en place du son à Cordoba (Argentine) Janvier 2013.
    ' Mise en place du WD1793 pour le minidisque : Octobre 2013 (St Désirat, ligne3)
    ' Novembre 2013 : Nouvelle version de gestion de fichier plus moderne avec les My.Computer.FileSystem
    ' Necessaire pour la sauvegarde des fichiers de disquette !
    ' Fin Write Sector / Write Track 3/11/2013
    ' Janvier / Mars 2014 : Ajout de saisie automatique et clipboard sur impulsion de 6502man
    ' MEA8000 Transformed in VBnet by yo_fr Started the 27/03/2014
    ' Ajout de l'émulation (simulation) de l'HectorDuino faite le 20/11/2015 et terminé en Decmebre 2015 à Cordoba
    ' Reprise des fonctions DirectX sound (SharpDX) pour obtenir de meilleur résultats (chose faite !)
    ' Ajout de l'utilitaire de création de vidéo et sons directement ua sein de VBHector et 
    ' Ajout le 30 et 31/12/2015 de mes utilitaires de 2009 et 2011 pour les gestions des WAV depuis des K7 et l'utilitaire pour les disquette MD.
    ' re à Cordoba mais en 2015 !
    ' Janvier 2016 : Ajout d'un filtre audio avec paramétrage de la coupure et presets!
    ' Mars 2016 : Mise au propre de l'émulation de SN76477 : le paramétrage et les frequences sont maintenant correctes !
    ' Juin 2016 : Mise en place d'une émuation du AY8912, qui aurait été nécessaire à Hector plutot que du SN76477...
    '             Utilisation des ports 2 (N° de registre à accéder) et 0 (data pour le registre). 
    ' Juillet 2016 : Ajout d'un utilitaire pour la création de fichier K7 depuis des fichiers binaires.
    '                l'aide permet de facilement faire bien !
    '                Pour aider à créer des fichiers avec de belles images, Mise en place des sauvegarder
    '                des binaires pour les copies d'écrans en Haute et Basse Résolution. 

    ' ****************************************
    ' Aout 2016 : Passage à la licence GPL V3. 
    ' ****************************************

    ' Ce code est libre d'utilisation et de diffusion, néanmoins si vous utilisez mon code,
    ' merci de m'envoyer un petit mail ! [01/08/2016] Ce code est maintenant régit par la licence GNU V3.
    ' Si vous améliorez / corrigez des bug, merci de me le renvoyer la correction !

    ' This code is free to use and distribute, however if you use my code thank you send me a mail!
    ' If you improve / correct the bug, thank you for returning it to me! [01/08/2016] this code is now under GNU V3 licence.


    'Pour Hector 
    Public Proc As New Z80
    Public Magneto As New K7
    Dim Nom_K7 As String = ""

    'Pour le Disc2
    Public Proc_Disc2 As New Z80
    '  Dim Application As Object
    Dim Quitting As Boolean = False

    Public Declare Function timeGetTime Lib "winmm.dll" () As Integer
    Declare Sub Sleep Lib "kernel32.dll" (ByVal dwMilliseconds As Integer)
    Declare Function GetAsyncKeyState Lib "User32.dll" (ByVal vKey As Int32) As Short

    ' Gestion des timing du Z80 D'hector
    Public TstatesPerInterrupt As Long
    Public InterruptTimer As Long
    Public lsleep As Long
    Public local_tstates As Long

    'Variables permettant la gestion du mode Debug du Z80
    Public Debuggage As Boolean = False 'Debbugage en cours ?
    Public ModeTrace As Boolean = False 'Mode trace en cours ?
    Public Adr_Break_Hector As Integer = &H30000 ' flag non initialisé ! (&H2FE pour lecture octet K7)

    Public Adr_Break_Disc2 As Integer = &H30000 'Adresse du breakpoint pour Disc2.

    Dim Z80_Lance_Disc2 As Boolean = False
    Dim Z80_Lance_Hector As Boolean = False

    Public Const HRP As Integer = 0
    Public Const HRX As Integer = 1
    Public Const MX40 As Integer = 2
    Public Const MX80 As Integer = 3
    Public Const MD As Integer = 4
    Public Const ARD As Integer = 5

    Dim SpeedBR As Integer = 45000  ' Vitesse d'exécution du Z80 
    Dim SpeedHR As Integer = 100000 '  selon résolution (nb cycle / 20 ms)

    Dim Grande_Fenetre_H As Integer = 855 ' 840
    Dim Grande_Fenetre_W As Integer = 1550 ' 1280
    Dim Grande_Fenetre_H_ay As Integer = 855 ' 840
    Dim Grande_Fenetre_W_ay As Integer = 1550 ' 1280
    Dim Petite_Fenetre_H As Integer = 855 ' 630
    Dim Petite_Fenetre_W As Integer = 765 ' 527
    Public Taille As Integer = 2

    Public Choix As Integer = ARD
    Public m_Action As Integer = 0 'Etat des commandes joystick fire/pot
    Public Joy_Select As Integer = 0 ' choix de l'émulation joy(0) ou joy(1)  non implanté !

    ' Spécifique Disc 2 !!! 
    ' Gestion des timing du Z80 Du disc2
    Public TstatesPerInterruptDisc As Long
    Public InterruptTimerDisc As Long
    Dim local_tstatesDisc As Long

    ' Stuff pour les interruptions INT
    Dim Tstate_for_int As Long
    Dim Armed_INT As Boolean = False
    Dim Need_Loop_INT As Boolean
    Dim Interrupt_Decale As Boolean = False
    Public Valeur As Integer

    ' Stuff pour les interruptions NMI
    Dim Tstate_for_nmi As Long
    Dim Armed_NMI As Boolean = False
    Dim Need_Loop_NMI As Boolean
    Dim NMI_Decale As Boolean = False

    'Pour le Son 1 bit
    Public Bit_Son As Boolean = False
    Public Old_Execution_Time As Integer

    Dim Had_Focus As Boolean = True     ' Permet de bloquer la capture des touches sous conditions...

    Dim Strg_Dump As String      ' Contient le dump de la mémoire demandée
    Dim AdresseBaseDump As Integer = 0

    ' pour la gestion de l'affichage des pertes de vitesse dans l'exécution du buufer son 
    Dim T1, T2, ERROR_ATT_SON, ERROR_BUFF_NR As Long
    Dim Compteur_T1T2 As Long

    ' La gestion du son a été faite à Coudekerque Village nouvel an 2013
    ' pour la conversion du prog sn76477
    ' et à Cordoba Argentine en janvier 2013.
    ' Réalisé à l'aide de la bibliothéque : SFML
    ' puis modifié en SharpDX pour des probléme de qualité sonore
    ' (beaucoup d'artefact sonore)septembre 2013
    ' Fevrier 2014 : Ajout de beaucoup de petites fonction sous l'impulsion de 6502man
    ' qui commence à développer sous Hector !
    ' Sauvegarde de B: coller texte dans Hector, 
    ' Mars 2014 : correction du VCO du sn76477 ! 
    ' Mars 2014 : Ajout du MEA8000 !
    ' Avril 2014 (Tanger, Formation bouclier 18/4/14) : Ajout du chargement depuis fichier
    ' pour préparer le développement du RAYCASTING! et mise au propre divers.
    ' Decembre 2015-Buenos Aires Modification du cycle des Z80 entre 0 et 20ms et plus en négatif
    '        Et reprise du son pour passer en 176.4 khz le son produit en interne 
    '         pour être compatible avec le player HectorDuino
    '         reprise des notifications maintenant le son produit est pur !

    'Déclarations DirectX
    Private _dev As SharpDX.DirectSound.DirectSound
    Private SoundBufferDescription As SoundBufferDescription
    Dim Notification_Sound As AutoResetEvent
    ' Buffer primaire et secondaire
    Dim _primaryBuffer As PrimarySoundBuffer
    Dim _secondaryBuffer As SecondarySoundBuffer
    Public SampleRate As Integer = 44100 * 4 ' = nombre de cycles de son en 1 seconde (ech/s)


    'Pour la saisie automatique (V1.66)
    Dim Saisie(0) As Byte
    Dim Pointeur_Saisie As Integer
    Dim Taille_Saisie As Integer
    Dim Saisie_EC As Boolean = False
    'Definition des touches
    Structure Touche
        Dim Haut As Integer
        Dim Gauche As Integer
        Dim Droit As Integer
        Dim bas As Integer
        Dim Touche_Hector As String
        Dim Code_PC As Integer
    End Structure

    Public Key(12, 6) As Touche


    Public Taille_Microcode As Integer = 0

    ' Coefficient pour le filtrage numérique :
    Public Filtre_Prof As Integer = 9
    Public h(Filtre_Prof) As Integer
    Dim Echant_Fltr(Filtre_Prof) As Integer
    Dim Filtre_Index As Integer
    Public Filtre_KhMoyen As Integer

    Public Debug_SN As Boolean = False
    Public Debug_AY As Boolean = False

    Dim Old_Status_Play As Boolean = False

    'Helper fonctions : pour affichage Hexa et inverse
    Private Function Caractere_char(ByRef A As Byte) As String
        If A > 32 And A < Asc("z") Then
            Caractere_char = Chr(A)
        Else
            Caractere_char = "."
        End If
    End Function
    Public Function Caractere_hex(ByRef A As Integer) As String
        Caractere_hex = Microsoft.VisualBasic.Right("00" + Hex(A), 2)
    End Function
    Public Function Caractere_hex4(ByRef A As Integer) As String
        Caractere_hex4 = Microsoft.VisualBasic.Right("0000" + Hex(A), 4)
    End Function
    Function ASCII_to_HEX(ByVal C As String) As Integer
        Dim ADR As Integer
        If C > " 0" And C <= "9" Then
            'Caractére
            ADR = CType(Val(C), Integer)
        ElseIf C = "A" Then
            ADR = &HA
        ElseIf C = "B" Then
            ADR = &HB
        ElseIf C = "C" Then
            ADR = &HC
        ElseIf C = "D" Then
            ADR = &HD
        ElseIf C = "E" Then
            ADR = &HE
        ElseIf C = "F" Then
            ADR = &HF
        End If
        ASCII_to_HEX = ADR
    End Function
    Public Function Caractere_Dec(ByRef A As Integer) As String
        Caractere_Dec = Microsoft.VisualBasic.Right("00" + Convert.ToString(A), 2)
    End Function
    Public Function Conv_Strg_To_Int(ByVal Conv As String) As Integer
        Dim L, Val_Reg As Integer
        'Conversion saisie HEXA => numérique : Adresse PC
        Conv = UCase("0000" + Conv)
        L = Conv.Length

        Val_Reg = 0
        Val_Reg = Val_Reg + ASCII_to_HEX(Mid(Conv, L - 3, 1)) * &H1000
        Val_Reg = Val_Reg + ASCII_to_HEX(Mid(Conv, L - 2, 1)) * &H100
        Val_Reg = Val_Reg + ASCII_to_HEX(Mid(Conv, L - 1, 1)) * &H10
        Val_Reg = Val_Reg + ASCII_to_HEX(Mid(Conv, L - 0, 1)) * &H1

        Conv_Strg_To_Int = Val_Reg
    End Function

    Private Sub Param_Filtre()
        '10
            h(0) = 1738
            h(1) = 636
            h(2) = 711
            h(3) = 769
            h(4) = 798
            h(5) = 798
            h(6) = 769
            h(7) = 711
            h(8) = 636
            h(9) = 1738

            'Calcul de la somme des coef 
            Filtre_KhMoyen = 0
            For i = 0 To Filtre_Prof
                Filtre_KhMoyen += h(i)
            Next
     
    End Sub

    'Chargement de la ROM sélectionnée
    Private Sub LoadROM()
        Dim iCounter As Integer              ' Pour lister tous les octets des ROMs
        Dim bRom() As Byte                   'Tampon de lecture des ROMs
        Dim Fic1, Fic2, Fic3, Fic4 As String ' Nom des fichiers de ROMs
        Dim Disquette As String              ' Pour le chargement eventuel des disquettes
        Dim Taill As Integer

        Select Case Choix
            Case HRP
                Fic1 = "hector2hrp.rom"
                Fic2 = Fic1
                Fic3 = Fic1
                LabelRAM.Visible = False
                LabelROM.Visible = False
                Label15.Visible = False
                Label19.Visible = False
                Exit Select
            Case HRX
                Fic1 = "hector2hrx.rom"  ' nouvelle rom : Irios  !
                Fic2 = Fic1
                Fic3 = Fic1
                LabelRAM.Visible = False
                Label19.Visible = False
                Exit Select
            Case MX40
                Fic1 = "mx40c_page0.rom"
                Fic2 = "mx40c_page1.rom"
                Fic3 = "mx40c_page2.rom"
                Exit Select
            Case MX80
                Fic1 = "mx80c_page0.rom"
                Fic2 = "mx80c_page1.rom"
                Fic3 = "mx80c_page2.rom"
                Exit Select
            Case MD
                Fic1 = "rommd1.bin"
                Fic2 = "rommd2.bin"
                Fic3 = Fic1
                Exit Select
            Case ARD
                Fic1 = "mx40c_page0.rom"
                Fic2 = "mx40c_page1.rom"
                Fic3 = "mx40c_page2.rom"
                Exit Select
            Case Else
                Fic1 = "mx80c_page0.rom"
                Fic2 = "mx80c_page1.rom"
                Fic3 = "mx80c_page2.rom"
                Exit Select
        End Select

        If Choix <> ARD Then
            'pour le Disc 2
            Fic4 = "D800K.BIN"
        Else
            Fic4 = "micro.bin"  '.bin"       ' Patched version en 3 avec le player !
        End If
        '  Fic4 = "hector disk ii  bios v2.bin"

        'Chargement page initiale de ROM : page1.
        If Dir$(Fic1) = "" Or Dir$(Fic2) = "" Or Dir$(Fic3) = "" Or Dir$(Fic4) = "" Then
            MsgBox("Error: Could not find required ROM image in '" & CurDir$() & "\" & "'.", vbOKOnly Or vbCritical, "Hector")
            End
        End If

        Taill = CInt(My.Computer.FileSystem.GetFileInfo(Fic1).Length)
        ReDim bRom(Taill)
        bRom = My.Computer.FileSystem.ReadAllBytes(Fic1)
        For iCounter = 0 To Taill - 1
            Hector.mem_P0(iCounter) = bRom(iCounter) 'Asc(Mid$(sROM, iCounter, 1)) 'bRom(iCounter) '
        Next iCounter

        Taill = CInt(My.Computer.FileSystem.GetFileInfo(Fic2).Length)
        ReDim bRom(Taill)
        bRom = My.Computer.FileSystem.ReadAllBytes(Fic2)
        For iCounter = 0 To Taill - 1
            Hector.mem_P1(iCounter) = bRom(iCounter)  ' Asc(Mid$(sROM, iCounter, 1))
        Next iCounter

        Taill = CInt(My.Computer.FileSystem.GetFileInfo(Fic3).Length)
        ReDim bRom(Taill)
        bRom = My.Computer.FileSystem.ReadAllBytes(Fic3)
        For iCounter = 0 To Taill - 1
            Hector.mem_P2(iCounter) = bRom(iCounter) ' Asc(Mid$(sROM, iCounter, 1))
        Next iCounter


        Taill = CInt(My.Computer.FileSystem.GetFileInfo(Fic4).Length)
        ReDim bRom(Taill)
        bRom = My.Computer.FileSystem.ReadAllBytes(Fic4)
        For iCounter = 0 To Taill - 1
            If Choix <> ARD Then
                Disc2.MemROM(iCounter) = bRom(iCounter)  'Asc(Mid$(sROM, iCounter, 1))
            Else
                Arduino.MemROM(iCounter) = bRom(iCounter)
            End If
        Next iCounter

        'Pour l'Arduino on mémorise la taille du microcode à envoyer à Hector !
        Taille_Microcode = Taill

        '        If Choix <> MD And Choix <> ARD Then


        Select Case Choix
            Case HRP
                ' Choix HrP
                ToolStripMenuD7_A.Enabled = False
                ToolStripMenuD7_B.Enabled = False
                SauvegardeDisquetteAToolStripMenuItem.Enabled = False
                SauvegardeDisquetteBToolStripMenuItem.Enabled = False
                ToolStripMenuItem7.Enabled = False
                ToolStripStatus_A.Text = ""
                ToolStripStatus_B.Text = ""

            Case HRX, MX40, MX80
                ' Choix HRX/ MX
                ToolStripMenuD7_A.Enabled = True
                ToolStripMenuD7_B.Enabled = True
                SauvegardeDisquetteAToolStripMenuItem.Enabled = True
                SauvegardeDisquetteBToolStripMenuItem.Enabled = True
                ToolStripMenuItem7.Enabled = False

                ' on charge les disquettes
                If File.Exists(My.Settings.File_A) Then
                    Disquette = My.Settings.File_A
                    ToolStripStatus_A.Text = "A:  " + Microsoft.VisualBasic.Right(Disquette, Disquette.Length - InStrRev(Disquette, "\"))
                Else
                    Disquette = "mea_F1_2.IMG"
                End If

                Ouvre_Disquette(Disquette, 0, uPD765.DiskA_type)

                If File.Exists(My.Settings.File_B) Then
                    Disquette = My.Settings.File_B
                    ToolStripStatus_B.Text = "B:  " + Microsoft.VisualBasic.Right(Disquette, Disquette.Length - InStrRev(Disquette, "\"))
                Else
                    Disquette = "SYSTEMMX.IMG"
                End If

                Ouvre_Disquette(Disquette, 1, uPD765.DiskB_type)

                '   voir forth

            Case MD
                ' choix MD
                ToolStripMenuD7_A.Enabled = True
                ToolStripMenuD7_B.Enabled = False
                SauvegardeDisquetteAToolStripMenuItem.Enabled = True
                SauvegardeDisquetteBToolStripMenuItem.Enabled = False
                ToolStripMenuItem7.Enabled = False
                ToolStripStatus_A.TextAlign = ContentAlignment.TopLeft
                ToolStripStatus_A.TextImageRelation = TextImageRelation.Overlay

                If File.Exists(My.Settings.File_A) Then
                    Disquette = My.Settings.File_A
                    ToolStripStatus_A.Text = "A:  " + Microsoft.VisualBasic.Right(Disquette, Disquette.Length - InStrRev(Disquette, "\"))
                Else
                    Disquette = "vb.img"
                End If

                Ouvre_Disquette(Disquette, 2, uPD765.DiskA_type) ' specifique pour le minidisque
                ToolStripStatus_B.Text = ""

            Case ARD
                ' Choix HectorDuino
                ToolStripMenuD7_A.Enabled = False
                ToolStripMenuD7_B.Enabled = False
                SauvegardeDisquetteAToolStripMenuItem.Enabled = False
                SauvegardeDisquetteBToolStripMenuItem.Enabled = False
                ToolStripMenuItem7.Enabled = True

                ToolStripStatus_A.Text = "SD :" & Arduino.Directory
                ToolStripStatus_B.Text = ""

        End Select

    End Sub

    'Gestion des paraetres
    Private Sub Lect_Param()
        'Choix de la machine au départ 
        Choix = My.Settings.Choix_Machine

        'Les fichiers disquettes A: uPD765 - Disc2
        If File.Exists(My.Settings.File_A) Then
            ToolStripStatus_A.Text = "A:  " + Microsoft.VisualBasic.Right(My.Settings.File_A, My.Settings.File_A.Length - InStrRev(My.Settings.File_A, "\"))
        End If
        If File.Exists(My.Settings.File_B) Then
            ToolStripStatus_B.Text = "B:  " + Microsoft.VisualBasic.Right(My.Settings.File_B, My.Settings.File_B.Length - InStrRev(My.Settings.File_B, "\"))
        End If

        If File.Exists(My.Settings.File_K7) Then
            ToolStripStatus_K7.Text = "K7:  " + Microsoft.VisualBasic.Right(My.Settings.File_K7, My.Settings.File_K7.Length - InStrRev(My.Settings.File_K7, "\")) + " "
            Nom_K7 = My.Settings.File_K7
            'et on ouvre le fichier selectionné
            Magneto.Init_Cassette(My.Settings.File_K7)
        Else
            ToolStripStatus_K7.Text = "K7: --- "
        End If
        My.Application.DoEvents()

        ' Sauvegarde dans un fichier de l'état de la machine (registres, mémoires, type de machine, 
        Dim No As Integer
        Dim F As New Microsoft.VisualBasic.FileIO.FileSystem
     
        No = FreeFile()

        FileOpen(No, "keyboard.ini", OpenMode.Binary)
        FileGet(No, Key)
        FileClose(No)
        'Mise en place de la taille de l'écran 
        ' On change la taille demandée !
        TailleAffichageÉcranToolStripMenuItem.Checked = My.Settings.Taille_Ecran

        Changement_Taille()
    End Sub

    Private Sub Save_Param()

        'Choix de la machine au départ 
        My.Settings.Choix_Machine = Choix

        ' Sauvegarde de la taille de l'écran usuelle
        My.Settings.Taille_Ecran = TailleAffichageÉcranToolStripMenuItem.Checked
        'Les fichiers disquettes A: uPD765 - Disc2 sont fait au fur et à mesure !

        'Sauvegarde de l'ensemble
        My.Settings.Save()

        ' Sauvegarde dans un fichier de paramétrage du clavier 
        Dim No As Integer
        Dim F As New Microsoft.VisualBasic.FileIO.FileSystem

        __Son(False)
        No = FreeFile()

        If File.Exists("keyboard.ini") Then

        End If
        FileOpen(No, "Keyboard.ini", OpenMode.Binary)
        FilePut(No, Key)
        FileClose(No)
    End Sub
    ' Gestion des fenêtres 
    Private Sub MainForm_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        ' Arrêt de l'affichage !
        Hector.Screen = Nothing
        ' sauve les pramétres
        Save_Param()

        'Arret du son lorsque l'on sort
        If Not IsNothing(_dev) Then
            __Son(False) '   _secondaryBuffer.Stop()
            _secondaryBuffer.Dispose()
            _primaryBuffer.Dispose()
            _dev.Dispose()
        End If
        'Necessaire pour arrêter tous les threads.
        Quitting = True
        'End
    End Sub
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Hard_Reset()
    End Sub

    Private Sub Hard_Reset()
        Dim mi As System.Reflection.MethodInfo = hectorDisplay.GetType().GetMethod("SetStyle", Reflection.BindingFlags.NonPublic Or Reflection.BindingFlags.Instance)

        ' Permet d'éviter les scintillements lors de l'affichage de l'écran
        mi.Invoke(hectorDisplay, New Object() {ControlStyles.AllPaintingInWmPaint Or ControlStyles.DoubleBuffer Or ControlStyles.ResizeRedraw Or ControlStyles.UserPaint, True})

        Dim ToolTip = New System.Windows.Forms.ToolTip
        ToolTip.SetToolTip(Num_Buff, "Nombre de buffer DirectSound :" & vbCrLf & "Si vous avez des plop plop sur le son lors de l'exécution, augmentez le nombre de buffers." _
                             & vbCrLf & "Hélas cela augmente la latence du son." & vbCrLf & "Valeur idéale : 1, les valeurs supérieurs feront un son moins bon" _
                             & vbCrLf & " chaque buffer fait 20ms")

        ToolTip.SetToolTip(CheckBoxFiltre, "Filtrage du son" & vbCrLf & "Si vous avez trop de souffle lors de l'exécution, notament lors de vidéo" & vbCrLf & "et audio de l'émulation HectorDuino, mettez en place le filtre.")
        'Mise à la taille de base d'abord !
        Changement_Taille() ' pour passer en grande taille

        'Forcer pour avoir le Z80 D'Hector
        ComboZ80.Text = "Z80 Hector"
        'Et au dump de la mémoire
        ComboTrace.Text = "Dump Mémoire"

        ' // Initialise l'ensemble des tables Hector
        Proc.Init_Processeur(True) ' C'est pour Hector
        Proc.Z80Reset(0, 0)
        Dim adr As Integer
        'RAZ des mémoires !
        For adr = 0 To &HFFFF
            Hector.mem_H(adr) = 0
            Hector.mem_P0(adr) = 0
            If adr < 16384 Then
                Hector.mem_P1(adr) = 0
                Hector.mem_P2(adr) = 0
            End If
        Next
        Arduino.Reset()

        'Ajouter les RESET des autres équipement d'Hector !
        'Gestion des page mémoire
        Hector.ActivRomPage = 0
        Hector.ActivVideoPage = 0

        'Vidéo
        Hector.Resolution = 1 'HR de basse !

        ' // Initialise l'ensemble des tables Disc 2
        Proc_Disc2.Init_Processeur(False) ' Pour le Disc2 
        Proc_Disc2.Z80Reset(0, 0)

        ' INIT WD1793
        WD1793.Init_WD()



        ' Hector HRX tourne à 5MHz
        ' Les interruptions ont lieu tous les 20ms soit 50 * par seconde (20 ms * 50 = 1000 ms soit 1s)
        ' 5 MHz = 5 000 000 de clock soit 5 000 000 / 50 = 100 000 cycles d'horloge avant une interruption !

        TstatesPerInterrupt = SpeedHR ' on met en place la valeur !

        'Pour Disc2
        TstatesPerInterruptDisc = 80000 ' 4Mhz pour le Disc2...

        'Lecture des parametres de l'application !
        Lect_Param()

        'Affichage des controles 
        Mise_a_jour_controles()

        'Initalisations diverses
        Hector.Init_Machine()

        If Choix = MD Then
            RadioButtonMD.Checked = True
            RadioButtonMX80.Checked = False
            RadioButtonMX40.Checked = False
            RadioButtonHRX.Checked = False
            RadioButtonHRP.Checked = False
            RadioButtonArd.Checked = False
        ElseIf Choix = MX80 Then
            RadioButtonMD.Checked = False
            RadioButtonMX80.Checked = True
            RadioButtonMX40.Checked = False
            RadioButtonHRX.Checked = False
            RadioButtonHRP.Checked = False
            RadioButtonArd.Checked = False
        ElseIf Choix = MX40 Then
            RadioButtonMD.Checked = False
            RadioButtonMX80.Checked = False
            RadioButtonMX40.Checked = True
            RadioButtonHRX.Checked = False
            RadioButtonHRP.Checked = False
            RadioButtonArd.Checked = False
        ElseIf Choix = HRX Then
            RadioButtonMD.Checked = False
            RadioButtonMX80.Checked = False
            RadioButtonMX40.Checked = False
            RadioButtonHRX.Checked = True
            RadioButtonHRP.Checked = False
            RadioButtonArd.Checked = False
        ElseIf Choix = HRP Then
            RadioButtonMD.Checked = False
            RadioButtonMX80.Checked = False
            RadioButtonMX40.Checked = False
            RadioButtonHRX.Checked = False
            RadioButtonHRP.Checked = True
            RadioButtonArd.Checked = False
        ElseIf Choix = ARD Then
            RadioButtonMD.Checked = False
            RadioButtonMX80.Checked = False
            RadioButtonMX40.Checked = False
            RadioButtonHRX.Checked = False
            RadioButtonHRP.Checked = False
            RadioButtonArd.Checked = True
        End If

        'init des filtres
        Param_Filtre()

        ' Pas plus loin pour être portable !
        Exit Sub

        'Charge une K7 de base
        If Dir$("G:\ASupport\Cassette\Formule 1\formule1-hector2.k7") <> "" Then
            Magneto.Init_Cassette("G:\ASupport\Cassette\Formule 1\formule1-hector2.k7")
        End If

    End Sub
    'Gestion du Focus application
    Private Sub MainForm_Activate(sender As Object, e As EventArgs) Handles Me.Activated
        Had_Focus = True
    End Sub
    Private Sub MainForm_Desactivate(sender As Object, e As EventArgs) Handles Me.Deactivate
        Had_Focus = False
    End Sub

    Private Sub Mise_a_jour_controles()
        ' selon l'état du simulateur on met en place les controles nécessaire 

        ' 2 grandes classes : La fenêtre est dépliée ou pas.
        ' Si elle est repliée, pas de debug !
        If Me.Width < 1100 Then
            ButtonContinu.Enabled = False
            ButtonContinu.Text = "Debug"
            ButtonTrace.Enabled = False
            ButtonTrace.Text = "Trace ON"
            ButtonStep.Enabled = False
            InterBar.Visible = False
            CheckTrace.Visible = False
            Label14.Visible = False
            DéplierLaPageToolStripMenuItem.Text = "Déplier la page -->"

        Else
            DéplierLaPageToolStripMenuItem.Text = "Replier la page (et continuer) <--"

            ' Dans le cas contraire, il faut jouer avec les différents états :
            ButtonTrace.Enabled = True
            ButtonStep.Enabled = True
            ButtonContinu.Enabled = True

            If Debuggage Then
                'On est en cours de débuggage 
                ButtonContinu.Text = "Continuer"
                If ModeTrace Then
                    'Mode trace activé 
                    ButtonTrace.Text = "Trace OFF"
                    InterBar.Visible = True
                    CheckTrace.Visible = True
                    Label14.Visible = True
                Else
                    'Mode  trace non actif
                    ButtonTrace.Text = "Trace ON"
                    InterBar.Visible = False
                    CheckTrace.Visible = False
                    Label14.Visible = False
                End If
            Else
                ' On est pas en debuggage 

                'On est en cours de débuggage 
                ButtonContinu.Text = "Debug"
                ButtonTrace.Text = "Trace ON"
                InterBar.Visible = False
                CheckTrace.Visible = False
                Label14.Visible = False
            End If
        End If

        'Mise à jour du joystick selectionné
        If Joy_Select = 0 Then
            EmulationJOY0ToolStripMenuItem.Checked = True
            EmulationJOY1ToolStripMenuItem.Checked = False
        Else
            EmulationJOY0ToolStripMenuItem.Checked = False
            EmulationJOY1ToolStripMenuItem.Checked = True
        End If

        'Mise à jour du flag de debug du uPD
        TraceDesCommandesUPD765ToolStripMenuItem.Checked = Demande_Trace_FD
        ToolStripMenuMEA.Checked = Demande_Trace_MEA
    End Sub


    'Gestion des Affichages 


    Private Sub hectorDisplay_Paint(sender As Object, e As PaintEventArgs) Handles hectorDisplay.Paint

        ' Si le bitmap n'est pas initialisé => out !
        ' le bit map   "Hector.Screen" a été préparé dans le module modHector
        If Hector.Screen Is Nothing Then Exit Sub

        Dim g As Drawing.Graphics = e.Graphics
        'Choix des méthodes de traitement
        e.Graphics.SmoothingMode = Drawing2D.SmoothingMode.HighSpeed
        e.Graphics.InterpolationMode = Drawing2D.InterpolationMode.NearestNeighbor
        ' et on met en place dans le bitmap préparé

        ' Selon la taille actuelle de la fenetre 
        '        If Me.Width = Grande_Fenetre Then  ' 480; 450   240 * 225
        e.Graphics.DrawImage(Hector.Screen, 0, 0, 240 * Taille, 225 * Taille)
        ' Else
        '   e.Graphics.DrawImage(Hector.Screen, 0, 0, 480, 450)
        ' End If
    End Sub

    Public Sub Affichage_Debug(ByVal Update_Register As Boolean)
        Dim Sauv_regPC, i, j, Adr_Deb, Limite As Integer
        Dim Instruction, OPCode As String
        Dim C1, C2 As Char
        Dim offset As Integer
        Dim Start_Bold As Integer = 0
        Dim Stop_Bold As Integer = 0
        Dim Contenu_Desa As String
        C1 = " "
        C2 = " "
        Dim Ligne As String
        Dim Processeur As Z80



        ' Mise référence le processeur qui a été selectionné pour l'affichage
        ' Toutes modif (REG_PC par exemple) devront être annuler
        ' Ici on pourrait valider des saisies des données de modifiacation de registre
        If ComboZ80.Text = "Z80 Hector" Then
            Processeur = Proc
        Else
            Processeur = Proc_Disc2
        End If

        If Update_Register Then
            ' Affichage des registres
            TextPC.Text = Caractere_hex4(CInt(Processeur.regPC.ToString))
            TextAF.Text = Caractere_hex(CInt(Processeur.regA.ToString))
            TextBC.Text = Caractere_hex(CInt(Processeur.regB.ToString)) & Caractere_hex(CInt(Processeur.regC.ToString))
            TextDE.Text = Caractere_hex4(CInt(Processeur.regDE.ToString))
            TextHL.Text = Caractere_hex4(CInt(Processeur.regHL.ToString))
            TextIX.Text = Caractere_hex4(CInt(Processeur.regIX.ToString))
            TextIY.Text = Caractere_hex4(CInt(Processeur.regIY.ToString))
            TextSP.Text = Caractere_hex4(CInt(Processeur.regSP.ToString))

            ' prime
            TextAFp.Text = Caractere_hex4(CInt(Processeur.regAF_.ToString))
            TextBCp.Text = Caractere_hex4(CInt(Processeur.regBC_.ToString))
            TextDEp.Text = Caractere_hex4(CInt(Processeur.regDE_.ToString))
            TextHLp.Text = Caractere_hex4(CInt(Processeur.regHL_.ToString))
            ' Flag (les communs)
            CheckC.Checked = CBool(Processeur.fC)  ' Carry
            CheckN.Checked = CBool(Processeur.fN) ' Soustraction effectuée
            CheckZ.Checked = CBool(Processeur.fZ) ' Zero
            CheckP.Checked = CBool(Processeur.fPV) ' Parity overflow
            CheckH.Checked = CBool(Processeur.fH) ' Half Carry
            CheckS.Checked = CBool(Processeur.fS)  ' Signe


            ' Affichage des pages mémoires !

            'Affichage de la page ROM
            If Choix = MX80 Or Choix = MX40 Or Choix = MD Then
                LabelROM.Text = ActivRomPage.ToString
            End If

            ' Affichage page ram au dela de 0C000h
            If Choix <> HRP Then
                If ActivVideoPage = 0 Then
                    LabelRAM.Text = "P"
                Else
                    LabelRAM.Text = "V"
                End If
            End If
        End If

        'Pas d'affichage du dessassemblage en cas de trace rapide.
        If CheckTrace.Checked And ModeTrace Then
            Exit Sub
        End If
        ' Lors d'un dessassemblage, j'utilise le REG_PC comme pointeur
        ' C'est pas terrible mais c'est mieux que rien !

        ' Donc => On sauve le registre PC 
        Sauv_regPC = Processeur.regPC
        Desass.Text = ""

        ' Desssassemblage (Pas la peine de faire plus de ligne que l'affichage le permet en mode TRACE !)
        If ModeTrace Then
            Limite = 31
        Else
            Limite = 128
        End If

        offset = 0

        Do
            'For offset = 0 To 3 'des fois que l'on ne tombe pas du 1er coup sur l'instruction à cause de celles à 4 octets !
            Processeur.regPC = Sauv_regPC
            Processeur.regPC -= 12 - offset
            Processeur.regPC = Processeur.regPC And &HFFFF
            Contenu_Desa = ""
            C1 = " "
            C2 = " "
            Stop_Bold = -1
            Start_Bold = -1

            For i = 1 To Limite
                Adr_Deb = Processeur.regPC
                Instruction = Processeur.desa_Z80()
                OPCode = ""
                'Mise en place des valeurs mémoires
                For j = Adr_Deb To Adr_Deb + 3
                    If j <= Processeur.regPC - 1 Then
                        OPCode = OPCode + Caractere_hex(Processeur.peekb(j)) ' Constitution de la partie affichage mémoire
                    Else
                        OPCode = OPCode + "  "
                    End If
                Next

                'Affichage de la ligne dessassemblée

                Ligne = Caractere_hex4(Adr_Deb) + " " + OPCode + C1 + Instruction + C2 + vbCrLf

                'La prochaine instruction est celle demandée (ou en cours par le Z80) ?
                If Adr_Deb = Sauv_regPC Then
                    C1 = ">"
                    C2 = "<"
                    ' on reecrit la ligne !
                    Ligne = Caractere_hex4(Adr_Deb) + " " + OPCode + C1 + Instruction + C2 + vbCrLf

                    offset = 44 'on pourra sortir de la boucle, on a trouvé notre ligne avec ce décalage !
                    If i <> 1 Then
                        Start_Bold = Contenu_Desa.Length - i 'les crlf ne sont pas compté dans les richtext - Ligne.Lengt
                    Else
                        Start_Bold = 0
                    End If
                    Stop_Bold = Ligne.Length - 1
                    C1 = " "
                    C2 = " "
                End If

                Contenu_Desa += Ligne

                If Processeur.regPC >= &HFFFF Then 'Si on est au bout de la mémoire => Fin !
                    Exit For
                End If

            Next i

            'On remet le registre PC à sa vrai valeur !
            Processeur.regPC = Sauv_regPC
            offset += 1

        Loop Until offset > 13

        ' Mise en place du code dessassemblé !
        Desass.Font = New Font("Courier New", Desass.SelectionFont.Size, FontStyle.Regular)
        Desass.Text = Contenu_Desa
        Desass.Font = New Font("Courier New", Desass.SelectionFont.Size, FontStyle.Regular Or FontStyle.Italic)
        If Start_Bold >= 0 Then
            Desass.SelectionStart = Start_Bold
            Desass.SelectionLength = Stop_Bold
            Desass.SelectionFont = New Font("Courier New", Desass.SelectionFont.Size, Desass.SelectionFont.Style Or FontStyle.Bold Or FontStyle.Underline)
        End If

        'On remet le registre PC à sa vrai valeur !
        Processeur.regPC = Sauv_regPC

        ' Affichage des info échangées entre Hector et Disc2
        If Choix <> ARD Then
            Label_R_Ready.Text = Disc2.Disc2_data_r_ready.ToString
            Label_W_ready.Text = Disc2.Disc2_data_w_ready.ToString
            Label_Data_Read.Text = Caractere_hex(CInt(Disc2.Disc2_data_read))
            Label_Data_Write.Text = Caractere_hex(CInt(Disc2.Disc2_data_write))
        Else
            Label_R_Ready.Text = Arduino.Disc2_data_r_ready.ToString
            Label_W_ready.Text = Arduino.Disc2_data_w_ready.ToString
            Label_Data_Read.Text = Caractere_hex(CInt(Arduino.Disc2_data_read))
            Label_Data_Write.Text = Caractere_hex(CInt(Arduino.Disc2_data_write))
        End If
        'On affiche l'état de la cassette uniquement en mode debug !
        If Me.Width > 1100 Then
            Select Case ComboTrace.Text
                Case "Trace uPD765"
                    'Pour le uPD765 
                    TraceK7.Text += uPD765.Strg_FdC765
                    Strg_FdC765 = ""
                Case "Trace WD1793"
                    'Pour le WD1793
                    TraceK7.Text += WD1793.Strg_FdC1793
                    Strg_FdC1793 = ""
                Case "Trace sn76477"
                    TraceK7.Text += Strg_SN
                    Strg_SN = ""
                Case "Trace MEA8000"
                    TraceK7.Text += Strg_MEA
                    Strg_MEA = ""
                Case "Trace cassette"
                    'Pour la K7
                    TraceK7.Text += Magneto.Liste_Bloc
                    Magneto.Liste_Bloc = ""
                Case "Trace Arduino"
                    TraceK7.Text += Arduino.Strg_ARD
                    Arduino.Strg_ARD = ""
                Case Else
                    Dump()
                    TraceK7.Text = Strg_Dump
            End Select
        End If

    End Sub

    'Gestion du clavier

    ' Les deux procedure ci dessous sont une altérnative aux nombreux appels
    ' à GetAsyncKeyState... 
    ' Néanmoins l'appel à GetAsyncKeyState permet de gérer plusieurs touches 
    ' appuyées simultanément et donc moins élégante mais plus performante...
    Public Sub ClavierOFF00(ByVal e As System.Windows.Forms.KeyEventArgs)
        Dim val As Integer
        val = &HFF

        Hector.keyboard(&H0) = &HFF
        Hector.keyboard(&H1) = val
        Hector.keyboard(&H2) = val
        Hector.keyboard(&H3) = val
        Hector.keyboard(&H4) = val
        Hector.keyboard(&H5) = val
        Hector.keyboard(&H6) = val
        Hector.keyboard(&H7) = &HFF

        If e.KeyValue = 17 Then
            m_Action = 0 ' Etat joy / pot
        End If

    End Sub
    Private Sub ClavierON00(ByVal e As System.Windows.Forms.KeyEventArgs)
        Dim Value, Adr As Integer

        Select Case e.KeyValue
            Case 32 'Z
                Value = 2
                Adr = 0
            Case 48 ' 0
                Value = 4
                Adr = 1
            Case 49 ' 1
                Value = 2
                Adr = 1
            Case 50 ' 2
                Value = 1
                Adr = 1
            Case 51 ' 3
                Value = 128
                Adr = 2
            Case 52 ' 4
                Value = 64
                Adr = 2
            Case 53 ' 5
                Value = 32
                Adr = 2
            Case 54 ' 6
                Value = 16
                Adr = 2
            Case 55 ' 7
                Value = 8
                Adr = 2
            Case 56 ' 8
                Value = 4
                Adr = 2
            Case 57 ' 9
                Value = 2
                Adr = 2
            Case 13 ' <cr>
            Case 96  'Ok, c'est une simulation du CR sur le 0 du pavé num...
                Value = 4
                Adr = 0
            Case 16 ' <SHIFT>
                Value = 128
                Adr = 0
            Case 27 ' ESC !
                Proc.Z80Reset(local_tstates, TstatesPerInterrupt)
                'Ajouter les RESET des autres équipement d'Hector !
                'Gestion des page mémoire
                Hector.ActivRomPage = 0
                Hector.ActivVideoPage = 0
                'Vidéo
                Hector.Resolution = 1 'HR de basse !
                'Arduino
                Arduino.Reset()
            Case 8 ' Backspace
                Value = 16
                Adr = 0
            Case 187 '=
                Value = 32
                Adr = 3

            Case 65 ' A
                Value = 2
                Adr = 3
            Case 66 'B
                Value = 1
                Adr = 3
            Case 67 ' C
                Value = 128
                Adr = 4
            Case 68 'D
                Value = 64
                Adr = 4
            Case 69 'E
                Value = 32
                Adr = 4
            Case 70 'F
                Value = 16
                Adr = 4
            Case 71 'G
                Value = 8
                Adr = 4
            Case 72 'H
                Value = 4
                Adr = 4


            Case 73 'I
                Value = 2
                Adr = 4
            Case 74 'J
                Value = 1
                Adr = 4
            Case 75 'K
                Value = 128
                Adr = 5
            Case 76 'L
                Value = 64
                Adr = 5
            Case 77 'M
                Value = 32
                Adr = 5
            Case 78 'N
                Value = 16
                Adr = 5
            Case 79 'O
                Value = 8
                Adr = 5
            Case 80 'P
                Value = 4
                Adr = 5
            Case 81 'Q
                Value = 2
                Adr = 5
            Case 82 'R
                Value = 1
                Adr = 5
            Case 83 'S
                Value = 128
                Adr = 6
            Case 84 'T
                Value = 64
                Adr = 6
            Case 85 'U
                Value = 32
                Adr = 6
            Case 86 'V
                Value = 16
                Adr = 6
            Case 87 'W
                Value = 8
                Adr = 6
            Case 88 'X
                Value = 4
                Adr = 6
            Case 89 'Y
                Value = 2
                Adr = 6
            Case 90 'Z
                Value = 1
                Adr = 6


            Case 188 ' virgule ,
                Value = 64
                Adr = 1

            Case 190 ' point-virgule ;
                Value = 128
                Adr = 3
            Case 9 ' TAB
                Value = 8
                Adr = 0
            Case 223 ' !
                Value = 16
                Adr = 1
            Case 20 ' lock
                Value = 32
                Adr = 0
            Case 220 ' *
                Value = 1
                Adr = 0
            Case 186 ' $  => !
                Value = 8
                Adr = 3
            Case 219 ' )  => +
                Value = 128
                Adr = 1
            Case 107 ' + du num lock
                Value = 128
                Adr = 1

                'Gestion Joystick
            Case 37 ' <-
                If Joy_Select = 0 Then
                    Value = 1
                    Adr = 7
                Else
                    Value = 16
                    Adr = 7
                End If
            Case 38 ' ^
                If Joy_Select = 0 Then
                    Value = 4
                    Adr = 7
                Else
                    Value = 64
                    Adr = 7
                End If
            Case 39 ' ->
                If Joy_Select = 0 Then
                    Value = 2
                    Adr = 7
                Else
                    Value = 32
                    Adr = 7
                End If
            Case 40 ' v
                If Joy_Select = 0 Then
                    Value = 8
                    Adr = 7
                Else
                    Value = 128
                    Adr = 7
                End If
            Case 17 ' Controle droite pour FIRE(n)
                If Joy_Select = 0 Then
                    m_Action = 1
                Else
                    m_Action = 8
                End If
                Exit Sub
            Case Else
                Value = 0
                Adr = 0
                ' Exit Sub
        End Select

        Hector.keyboard(Adr) = Not (Value) ' Inversion de l'état des enfoncement des touches (&hFF quand aucune touche enfoncée)

        If e.Modifiers = Keys.Control Then
            'Ctrl enfoncée avec !
            Hector.keyboard(&H0) = Not (64) And Hector.keyboard(&H0)
        End If

        If e.Modifiers = Keys.Shift Then
            'Shift 
            Hector.keyboard(&H0) = Not (128) And Hector.keyboard(&H0)
        End If
    End Sub

    'Nouvelle gestion clavier


    'Appel de l'analyse du clavier (ou saisie automatique)
    Private Sub Clavier2()
        'Mapping des touches // Adresses (www.hectorvictor.free.fr)

        'Adresse/Bit	7   	6   	5   	4   	3   	2   	1   	0
        ' Poids decimal 128     64      32      16      8       4       2       1

        '0x3800	        Shift	Control Rep	    Back	Tab	    Return	Espace	*
        '0x3801	        +	    ,   	-   	.   	/   	0   	1   	2
        '0x3802	        3	    4	    5	    6	    7	    8	    9	
        '0x3803	        ;   		    =	        	?		        A	    B
        '0x3804	        C	    D   	E   	F   	G   	H   	I   	J
        '0x3805	        K	    L	    M	    N	    O	    P	    Q	    R
        '0x3806	        S	    T	    U	    V	    W	    X	    Y	    Z
        Dim Clav(256) As Byte

        Dim Ktemp(8) As Integer  'Buffer clavier
        Dim SHIFT As Boolean = False    ' Pour saisie automatique avec <Shift>
        Dim CONTROL As Boolean = False  ' Pour saisie automatique avec <Control>
        Static Saisie_Timer As Integer = 0 ' Pour cadencer la saisie automatique

        m_Action = 0
    
        If Had_Focus And GetAsyncKeyState(Key(8, 6).Code_PC) <> 0 Then ' F10 : copie d'écran
            Save_Copie_Ecran()
        End If

        If Had_Focus And GetAsyncKeyState(Key(3, 5).Code_PC) <> 0 Then 'Espace
                Ktemp(0) += 2
            End If
            If Saisie_EC And Saisie(Pointeur_Saisie) = 32 Then
                Ktemp(0) += 2
            End If

            If Had_Focus And GetAsyncKeyState(Key(10, 1).Code_PC) <> 0 Then ' 0
                Ktemp(1) += 4
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 48 Or Saisie(Pointeur_Saisie) = Asc("<") Or Saisie(Pointeur_Saisie) = Asc("µ")) Then

                Ktemp(1) += 4
                If Saisie(Pointeur_Saisie) = Asc("<") Then SHIFT = True
                If Saisie(Pointeur_Saisie) = Asc("µ") Then CONTROL = True
            End If

        If Had_Focus And GetAsyncKeyState(Key(1, 1).Code_PC) <> 0 Then ' 1
            Ktemp(1) += 2
        End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 49 Or Saisie(Pointeur_Saisie) = Asc(">") Or Saisie(Pointeur_Saisie) = Asc("à")) Then

                Ktemp(1) += 2
                If Saisie(Pointeur_Saisie) = Asc(">") Then SHIFT = True
                If Saisie(Pointeur_Saisie) = Asc("à") Then CONTROL = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(2, 1).Code_PC) <> 0 Then ' 2
                Ktemp(1) += 1
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 50 Or Saisie(Pointeur_Saisie) = Asc("""") Or Saisie(Pointeur_Saisie) = Asc("ç")) Then

                Ktemp(1) += 1
                If Saisie(Pointeur_Saisie) = Asc("""") Then SHIFT = True
                If Saisie(Pointeur_Saisie) = Asc("ç") Then CONTROL = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(3, 1).Code_PC) <> 0 Then ' 3
                Ktemp(2) += 128
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 51 Or Saisie(Pointeur_Saisie) = Asc("'") Or Saisie(Pointeur_Saisie) = Asc("é")) Then
                Ktemp(2) += 128
                If Saisie(Pointeur_Saisie) = Asc("'") Then SHIFT = True
                If Saisie(Pointeur_Saisie) = Asc("é") Then CONTROL = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(4, 1).Code_PC) <> 0 Then ' 4
                Ktemp(2) += 64
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 52 Or Saisie(Pointeur_Saisie) = Asc("$") Or Saisie(Pointeur_Saisie) = Asc("ê")) Then
                Ktemp(2) += 64
                If Saisie(Pointeur_Saisie) = Asc("$") Then SHIFT = True
                If Saisie(Pointeur_Saisie) = Asc("ê") Then CONTROL = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(5, 1).Code_PC) <> 0 Then ' 5
                Ktemp(2) += 32
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 53 Or Saisie(Pointeur_Saisie) = Asc("%") Or Saisie(Pointeur_Saisie) = Asc("è")) Then
                Ktemp(2) += 32
                If Saisie(Pointeur_Saisie) = Asc("%") Then SHIFT = True
                If Saisie(Pointeur_Saisie) = Asc("è") Then CONTROL = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(6, 1).Code_PC) <> 0 Then ' 6
                Ktemp(2) += 16
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 54 Or Saisie(Pointeur_Saisie) = Asc("!") Or Saisie(Pointeur_Saisie) = Asc("ù")) Then
                Ktemp(2) += 16
                If Saisie(Pointeur_Saisie) = Asc("!") Then SHIFT = True
                If Saisie(Pointeur_Saisie) = Asc("ù") Then CONTROL = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(7, 1).Code_PC) <> 0 Then ' 7
                Ktemp(2) += 8
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 55 Or Saisie(Pointeur_Saisie) = Asc(":")) Then
                Ktemp(2) += 8
                If Saisie(Pointeur_Saisie) = Asc(":") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(8, 1).Code_PC) <> 0 Then ' 8
                Ktemp(2) += 4
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 56 Or Saisie(Pointeur_Saisie) = Asc("(") Or Saisie(Pointeur_Saisie) = Asc("[")) Then

                Ktemp(2) += 4
                If Saisie(Pointeur_Saisie) = Asc("(") Then SHIFT = True
                If Saisie(Pointeur_Saisie) = Asc("[") Then CONTROL = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(9, 1).Code_PC) <> 0 Then ' 9
                Ktemp(2) += 2
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 57 Or Saisie(Pointeur_Saisie) = Asc(")") Or Saisie(Pointeur_Saisie) = Asc("]")) Then
                Ktemp(2) += 2
                If Saisie(Pointeur_Saisie) = Asc(")") Then SHIFT = True
                If Saisie(Pointeur_Saisie) = Asc("]") Then CONTROL = True
            End If


            If Had_Focus And GetAsyncKeyState(Key(12, 2).Code_PC) <> 0 Then ' <cr> 
                Ktemp(0) += 4
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 13) Then
                Ktemp(0) += 4


            End If

            If Had_Focus And GetAsyncKeyState(Key(12, 6).Code_PC) <> 0 Then ' ESC ! 

                'Ici on va simuler le bouton physique du RESET d'Hector
                Proc.Z80Reset(local_tstates, TstatesPerInterrupt)
                Reset_Hector()

                'Maintenant l'ensemble des Circuits d'Hector sont initialisés !
            End If
            If Had_Focus And GetAsyncKeyState(Key(11, 5).Code_PC) <> 0 Then ' Backspace
                Ktemp(0) += 16
            End If
            If Had_Focus And GetAsyncKeyState(Key(11, 2).Code_PC) <> 0 Then '=
                Ktemp(3) += 32
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = Asc("=")) Then

                Ktemp(3) += 32
            End If

            If Had_Focus And GetAsyncKeyState(Key(1, 3).Code_PC) <> 0 Then ' A
                Ktemp(3) += 2
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 65 Or Saisie(Pointeur_Saisie) = Asc("a")) Then
                Ktemp(3) += 2
                If Saisie(Pointeur_Saisie) = Asc("A") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(6, 4).Code_PC) <> 0 Then 'B
                Ktemp(3) += 1
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 66 Or Saisie(Pointeur_Saisie) = Asc("b")) Then
                Ktemp(3) += 1
                If Saisie(Pointeur_Saisie) = Asc("B") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(4, 4).Code_PC) <> 0 Then ' C
                Ktemp(4) += 128
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 67 Or Saisie(Pointeur_Saisie) = Asc("c")) Then

                Ktemp(4) += 128
                If Saisie(Pointeur_Saisie) = Asc("C") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(3, 3).Code_PC) <> 0 Then 'D
                Ktemp(4) += 64
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 68 Or Saisie(Pointeur_Saisie) = Asc("d")) Then
                Ktemp(4) += 64
                If Saisie(Pointeur_Saisie) = Asc("D") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(3, 2).Code_PC) <> 0 Then 'E
                Ktemp(4) += 32
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 69 Or Saisie(Pointeur_Saisie) = Asc("e")) Then
                Ktemp(4) += 32
                If Saisie(Pointeur_Saisie) = Asc("E") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(4, 3).Code_PC) <> 0 Then 'F
                Ktemp(4) += 16
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 70 Or Saisie(Pointeur_Saisie) = Asc("f")) Then

                Ktemp(4) += 16
                If Saisie(Pointeur_Saisie) = Asc("F") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(5, 3).Code_PC) <> 0 Then 'G
                Ktemp(4) += 8
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 71 Or Saisie(Pointeur_Saisie) = Asc("g")) Then
                Ktemp(4) += 8
                If Saisie(Pointeur_Saisie) = Asc("G") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(6, 3).Code_PC) <> 0 Then 'H
                Ktemp(4) += 4
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 72 Or Saisie(Pointeur_Saisie) = Asc("h")) Then
                Ktemp(4) += 4
                If Saisie(Pointeur_Saisie) = Asc("H") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(8, 2).Code_PC) <> 0 Then 'I
                Ktemp(4) += 2
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 73 Or Saisie(Pointeur_Saisie) = Asc("i")) Then
                Ktemp(4) += 2
                If Saisie(Pointeur_Saisie) = Asc("I") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(7, 3).Code_PC) <> 0 Then 'J
                Ktemp(4) += 1
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 74 Or Saisie(Pointeur_Saisie) = Asc("j")) Then

                Ktemp(4) += 1
                If Saisie(Pointeur_Saisie) = Asc("J") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(8, 3).Code_PC) <> 0 Then 'K
                Ktemp(5) += 128
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 75 Or Saisie(Pointeur_Saisie) = Asc("k")) Then
                Ktemp(5) += 128
                If Saisie(Pointeur_Saisie) = Asc("K") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(9, 3).Code_PC) <> 0 Then 'L
                Ktemp(5) += 64
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 76 Or Saisie(Pointeur_Saisie) = Asc("l")) Then
                Ktemp(5) += 64
                If Saisie(Pointeur_Saisie) = Asc("L") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(8, 4).Code_PC) <> 0 Then 'M
                Ktemp(5) += 32
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 77 Or Saisie(Pointeur_Saisie) = Asc("m")) Then
                Ktemp(5) += 32
                If Saisie(Pointeur_Saisie) = Asc("M") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(7, 4).Code_PC) <> 0 Then 'N
                Ktemp(5) += 16
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 78 Or Saisie(Pointeur_Saisie) = Asc("n")) Then

                Ktemp(5) += 16
                If Saisie(Pointeur_Saisie) = Asc("N") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(9, 2).Code_PC) <> 0 Then 'O
                Ktemp(5) += 8
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 79 Or Saisie(Pointeur_Saisie) = Asc("o")) Then

                Ktemp(5) += 8
                If Saisie(Pointeur_Saisie) = Asc("O") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(10, 2).Code_PC) <> 0 Then 'P
                Ktemp(5) += 4
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 80 Or Saisie(Pointeur_Saisie) = Asc("p")) Then
                Ktemp(5) += 4
                If Saisie(Pointeur_Saisie) = Asc("P") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(1, 2).Code_PC) <> 0 Then 'Q
                Ktemp(5) += 2
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 81 Or Saisie(Pointeur_Saisie) = Asc("q")) Then
                Ktemp(5) += 2
                If Saisie(Pointeur_Saisie) = Asc("Q") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(4, 2).Code_PC) <> 0 Then 'R
                Ktemp(5) += 1
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 82 Or Saisie(Pointeur_Saisie) = Asc("r")) Then

                Ktemp(5) += 1
                If Saisie(Pointeur_Saisie) = Asc("R") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(2, 3).Code_PC) <> 0 Then 'S
                Ktemp(6) += 128
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 83 Or Saisie(Pointeur_Saisie) = Asc("s")) Then
                Ktemp(6) += 128
                If Saisie(Pointeur_Saisie) = Asc("S") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(5, 2).Code_PC) <> 0 Then 'T
                Ktemp(6) += 64
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 84 Or Saisie(Pointeur_Saisie) = Asc("t")) Then
                Ktemp(6) += 64
                If Saisie(Pointeur_Saisie) = Asc("T") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(7, 2).Code_PC) <> 0 Then 'U
                Ktemp(6) += 32
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 85 Or Saisie(Pointeur_Saisie) = Asc("u")) Then

                Ktemp(6) += 32
                If Saisie(Pointeur_Saisie) = Asc("U") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(5, 4).Code_PC) <> 0 Then 'V
                Ktemp(6) += 16
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 86 Or Saisie(Pointeur_Saisie) = Asc("v")) Then

                Ktemp(6) += 16
                If Saisie(Pointeur_Saisie) = Asc("V") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(2, 2).Code_PC) <> 0 Then 'W
                Ktemp(6) += 8
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 87 Or Saisie(Pointeur_Saisie) = Asc("w")) Then
                Ktemp(6) += 8
                If Saisie(Pointeur_Saisie) = Asc("W") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(3, 4).Code_PC) <> 0 Then 'X
                Ktemp(6) += 4
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 88 Or Saisie(Pointeur_Saisie) = Asc("x")) Then
                Ktemp(6) += 4
                If Saisie(Pointeur_Saisie) = Asc("X") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(6, 2).Code_PC) <> 0 Then 'Y
                Ktemp(6) += 2
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 89 Or Saisie(Pointeur_Saisie) = Asc("y")) Then

                Ktemp(6) += 2
                If Saisie(Pointeur_Saisie) = Asc("Y") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(2, 4).Code_PC) <> 0 Then 'Z
                Ktemp(6) += 1
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 90 Or Saisie(Pointeur_Saisie) = Asc("z")) Then
                Ktemp(6) += 1
                If Saisie(Pointeur_Saisie) = Asc("Z") Then SHIFT = True
            End If


            '  If Had_Focus and GetAsyncKeyState(&H72) <> 0 Then ' F3 ------------------------> BIZARRE !
            ' Ktemp(1) += 32
            ' End If
            If Had_Focus And GetAsyncKeyState(Key(12, 3).Code_PC) <> 0 Then ' /
                Ktemp(1) += 8

            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = Asc("/") Or Saisie(Pointeur_Saisie) = Asc("@")) Then

                Ktemp(1) += 8
                If Saisie(Pointeur_Saisie) = Asc("@") Then SHIFT = True
            End If


            If Had_Focus And GetAsyncKeyState(Key(9, 4).Code_PC) <> 0 Then ' virgule ,
                Ktemp(1) += 64
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = Asc(",")) Then

                Ktemp(1) += 64
            End If

            If Had_Focus And GetAsyncKeyState(Key(10, 3).Code_PC) <> 0 Then ' point-virgule ;
                Ktemp(3) += 128
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = Asc(";")) Then
                Ktemp(3) += 128
            End If


            If Had_Focus And GetAsyncKeyState(Key(2, 5).Code_PC) <> 0 Then ' TAB
                Ktemp(0) += 8
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = 9) Then

                Ktemp(0) += 8
            End If

            If Had_Focus And GetAsyncKeyState(Key(10, 4).Code_PC) <> 0 Then ' .
                Ktemp(1) += 16
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = Asc(".") Or Saisie(Pointeur_Saisie) = Asc("&")) Then

                Ktemp(1) += 16
                If Saisie(Pointeur_Saisie) = Asc("&") Then SHIFT = True
            End If

            If Had_Focus And GetAsyncKeyState(Key(1, 5).Code_PC) <> 0 Then ' lock
                Ktemp(0) += 32
            End If
            If Had_Focus And GetAsyncKeyState(Key(11, 3).Code_PC) <> 0 Then ' *
                Ktemp(0) += 1
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = Asc("*")) Then
                Ktemp(0) += 1
            End If

            If Had_Focus And GetAsyncKeyState(Key(11, 4).Code_PC) <> 0 Then ' $  => !
                Ktemp(3) += 8
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = Asc("?")) Then  '"?"
                Ktemp(3) += 8
            End If


            If Had_Focus And GetAsyncKeyState(Key(12, 1).Code_PC) <> 0 Then ' )  => +
                Ktemp(1) += 128
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = Asc("+")) Then

                Ktemp(1) += 128
            End If


            If Had_Focus And GetAsyncKeyState(Key(11, 1).Code_PC) <> 0 Then ' -  => _
                Ktemp(1) += 32
            End If
            If Saisie_EC And (Saisie(Pointeur_Saisie) = Asc("-") Or Saisie(Pointeur_Saisie) = Asc("_")) Then
                Ktemp(1) += 32
                If Saisie(Pointeur_Saisie) = Asc("_") Then SHIFT = True
            End If

            ' Gestion du SHIFT en dernier
            If Had_Focus And (GetAsyncKeyState(Key(1, 4).Code_PC) <> 0 Or GetAsyncKeyState(Key(12, 4).Code_PC) <> 0) Or (Saisie_EC And SHIFT) Then ' <SHIFT>
                Ktemp(0) += 128
            End If

            'Gestion Joystick
            If Had_Focus And GetAsyncKeyState(Key(1, 6).Code_PC) <> 0 Then ' <-
                If Joy_Select = 0 Then
                    Ktemp(7) += 1
                Else
                    Ktemp(7) += 16
                End If

            End If
            If Had_Focus And GetAsyncKeyState(Key(3, 6).Code_PC) <> 0 Then ' ^  Fléches pour direction joy(n)
                If Joy_Select = 0 Then
                    Ktemp(7) += 4
                Else
                    Ktemp(7) += 64
                End If
            End If
            If Had_Focus And GetAsyncKeyState(Key(2, 6).Code_PC) <> 0 Then ' ->
                If Joy_Select = 0 Then
                    Ktemp(7) += 2
                Else
                    Ktemp(7) += 32
                End If
            End If
            If Had_Focus And GetAsyncKeyState(Key(4, 6).Code_PC) <> 0 Then ' v
                If Joy_Select = 0 Then
                    Ktemp(7) += 8
                Else
                    Ktemp(7) += 128
                End If
            End If
            If Had_Focus And GetAsyncKeyState(Key(5, 6).Code_PC) <> 0 Then ' Controle droite pour FIRE(n)
                If Joy_Select = 0 Then
                    m_Action += 1
                Else
                    m_Action += 2
                End If
            End If

            ' Joystick !!!
            If Had_Focus And GetAsyncKeyState(Key(6, 6).Code_PC) <> 0 Then ' Pot +
                If Joy_Select = 0 Then
                    If m_Pot0 < 127 Then
                        m_Pot0 += 3
                    End If
                Else
                    If Joy_Select = 0 Then
                        If m_Pot1 < 127 Then
                            m_Pot1 += 3
                        End If
                    End If
                End If
            End If
            If Had_Focus And GetAsyncKeyState(Key(7, 6).Code_PC) <> 0 Then ' Pot -
                If Joy_Select = 0 Then
                    If m_Pot0 > 3 Then
                        m_Pot0 -= 3
                    End If
                Else
                    If m_Pot1 > 3 Then
                        m_Pot1 -= 3
                    End If
                End If
            End If


            ' Touches spéciales
            If Had_Focus And GetAsyncKeyState(Key(12, 5).Code_PC) <> 0 Or CONTROL Then ' Control (Les 2) 
                Ktemp(0) += 64
            End If

            ' Touches spéciales : Debuggage !
            If Had_Focus And GetAsyncKeyState(Key(9, 6).Code_PC) <> 0 Then ' F5 classiquement
                Debuggage = True
                ModeTrace = False
                'Mise à la taille agrandie !
                Me.Width = Grande_Fenetre_W
                Me.Height = Grande_Fenetre_H
                Mise_a_jour_controles()
            End If




            ' Automate de gestion de la saisie automatique 

            If Saisie_EC Then
                ' On est en cours de saisie automatique
                Saisie_Timer += 1
                If Saisie_Timer > 2 Then
                    'Mi temps, on raz la saisie en cours
                    Saisie(Pointeur_Saisie) = 0
                End If
                If Saisie_Timer > 4 Then
                    ' On est au bout du temps de saisie du caractére courant
                    ' RAZ du timer
                    Saisie_Timer = 0
                    ' Caractere suivant
                    Pointeur_Saisie += 1
                    If Pointeur_Saisie >= (Taille_Saisie) Then
                        'On est au bout de la saisie !
                        Saisie_EC = False
                        Pointeur_Saisie = 0
                    End If
                End If
            End If
            'Mise en place dans les données générales !
            For i = 0 To 7
                Hector.keyboard(i) = Not (Ktemp(i)) ' Avec inversion de l'état des enfoncement des touches (&hFF quand aucune touche enfoncée)
            Next i
    End Sub
    Private Sub Reset_Hector()
        'Gestion des page mémoire
        Hector.ActivRomPage = 0
        Hector.ActivVideoPage = 0

        'Vidéo
        Hector.Resolution = 1 'HR de basse !

        'Reset du disc 2
        Reset_Disc2()

        'Arduino
        Arduino.Reset()
        ' INIT WD1793
        WD1793.Init_WD()

    End Sub

    ' Procedure principale de l'émulation 
    Public Sub Run_Hector()

        Static Wait_20ms_Disc As Boolean
        Static Idx_Tour_Son As Integer
        Dim Idx_Buffer_Son As Integer

        Static Flag_AY As Boolean = False ' AY initialisé ?

        Dim SampleRate_20ms As Integer = SampleRate \ 50   ' plus simple our les calculs : nb sample par période de 20ms (interruption)

        Dim Exact_Cycle As Double = 0 ' Nb de cycle Z80 à 5MHz pour 1 échantillon en double pour être précis !
        Dim Cycle_Son As Double = 0   ' Cumulatif entre 2 interruptions 

        Dim Tstate_For_MEA As Long ' Timer pour le MEA à 64khz
        Dim Step_Tstate_MEA As Long

        'ici on defini le fonctionnement de l'émulation son :
        ' on peut choisir le nombre de buffer de 20ms que l'on rempli
        ' avant de le lancer à DXSound.
        ' 1 buffer signifie que l'on rempli 1 buffer de 20 ms et on l'envoi à DXSound au bout de 20 ms
        ' Cela n'a rien à voir avec les notifications qui ont lieu de toutes façons 2 fois
        ' par buffer joué (milieu et fin), quelque soit la taille de ce dit buffer (qui fera en 20 et 180ms => 1-9 buffer)

        Dim Taille_Buffer As Integer = Num_Buff.Value       ' soit gnéralement 1 tour (20ms) avant que l'on ne joue le buffer en cours. Modifiable avant lancement
        Dim Taille_DX_Buffer As Integer = Taille_Buffer * 2 ' Taille du buffer physique utilisé par DX Sound en nombre de buffer VBHector de 20ms. Effectivement si on demande 3 on a alors 3*2 (6) de buffer de 20ms à créer

        Dim Nb_Sound_Sample As Integer = SampleRate_20ms * Taille_Buffer ' (    44100 / 50 interrupt par secondes )  = 882  ! * taille buffer => à 4 = 3528
        '                                                                  ( 4* 44100 / 50 interrupt par secondes )  = 3528 ! * taille buffer => à 2 = 7056, 4 14112
        Dim Nb_Sound_Bytes As Integer = Nb_Sound_Sample * 2  ' 16 bits en stéréo => 4 bytes par échantillons, en mono 2bytes ->28224 bytes

        Dim Nb_MEA_Sample As Short = 0

        'Direct sound décripteurs
        Dim primaryDescription As SoundBufferDescription
        Dim secondaryDescription As SoundBufferDescription

        If PanelLancement.Visible Then '1er chargement ?
            ' Chargement de la ROM
            LoadROM()
        End If
        ' On interdit un nouveau lancement 
        '    StartHectorToolStripMenuItem.Enabled = False
        Quitting = False
        PanelLancement.Visible = False

        ' Plus possible de changer...
        GroupChoix.Visible = False

        ' et on affiche les timers
        Label18.Text = "Indicateur non attente son (buffer:" + Taille_Buffer.ToString + ") :"
        PanelSon.Visible = True

        Dim Status_Motor_K7 As Integer ' pour reprensatation moteur cassette !

        ' 20 ms = 1/50eme de seconde,
        ' 44100 / 50 = 882  échantillons toutes les 20ms
        '176400 / 50 = 3528 échantillons toutes les 20ms
        ' que l'on multiplie par le nombre de tour  que l'on attend avant d'envoyé le buffer son à DirectX.

        ' Attention toutefois : TailleBuffer c'est des paquets de 20ms... pas 10 !
        Dim buffe(Nb_Sound_Sample - 1) As Short ' définition du buffer son que l'on remplira au cours de l'exécution du Z80, SN76477, AY et MEA
        ' D'abord initialisation divers, si pas déjà fait
        If Not (Z80_Lance_Hector) Then

            'Création du device pour le son
            _dev = New DirectSound
            _dev.SetCooperativeLevel(Me.Handle, CooperativeLevel.Priority)

            'Creation du format utilisé
            Dim waveFormat As New Multimedia.WaveFormat(SampleRate, 16, 1) ' passage en mono ! (2* moins de données)

            ' Buffer primaire : carte son
            primaryDescription = New SoundBufferDescription

            primaryDescription.AlgorithmFor3D = Guid.Empty
            primaryDescription.Flags = BufferFlags.PrimaryBuffer


            ' Buffer secondaire : buffer joué par DXsound ici c'est sa description
            secondaryDescription = New SoundBufferDescription
            secondaryDescription.BufferBytes = Taille_DX_Buffer * Nb_Sound_Bytes ' Taille du buffer DirectSound : 4 fois (Taille_DX_Buffer) le nombre d'échantillons par paquet de 20ms. (4 rien à voir avec 16b stéréo)

            secondaryDescription.AlgorithmFor3D = Guid.Empty
            secondaryDescription.Flags = BufferFlags.Software Or BufferFlags.ControlPositionNotify Or BufferFlags.StickyFocus 'Sticky focus permet de continuer sans focus active sur la fenetre

            secondaryDescription.Format = waveFormat

            ' Creation buffer primaire
            _primaryBuffer = New PrimarySoundBuffer(_dev, primaryDescription)
            _primaryBuffer.Format = waveFormat

            ' Creation buffer secondaire à l'aide de la description réalisée
            _secondaryBuffer = New SecondarySoundBuffer(_dev, secondaryDescription)

            ' Lock le buffer pour permettre au programme utilisateur (nous) d'écrire dedans!
            Dim dataPart1 As DataStream
            Dim dataPart2 As New DataStream(10, True, True) ' pour eviter warning, déclaration d'un objet
            dataPart2.Close() ' pour éviter les fuites de mémoire !

            ' Ici on récupere le buffer son en 2 parties : 
            ' part1: buffer de base et si on en en train de tourner le buffer, alors la suite du buffer se trouve dans part2 !!!
            ' en managed le stream posséde la longueur du buffer. Attention donc à enregistrer les données
            ' sur part1 puis part2 si on depasse part1.lenght !

            dataPart1 = _secondaryBuffer.Lock(0, Nb_Sound_Bytes, LockFlags.EntireBuffer, dataPart2)

            'Remplissage buffer avec du vide pour le 1er tour
            Dim I As Integer
            Dim value1 As Short
            value1 = 0
            'Pas de débordemennt du datapart1 car on est en EntireBuffer ! 
            For I = 0 To CInt(dataPart1.Length - 2) Step 2
                dataPart1.Write(value1)
            Next


            ' Pour bien comprendre les différents paramétres des notifications : 
            ' Les notifications ont lieu avant la fin du buffer de Taille_Buffer * 20 ms !
            '
            '
            '                       (1st Notify)                            (2nd Notify)                 (3th Notify)                            (4th Notify)
            '0                                 20ms                                      40mS                       60ms                                      80mS
            '|                            | eps.|                                  |eps.  |                    |     |                                  |      |
            '-------------------------------------------------------------------------------------------------------------------------------------------------
            '|                            |     |                                  |      |                    |     |                                  |      |
            '------------------------------------------------------------------------------------------------------------------------------------------------


            '                       (1st Notify)                            (2nd Notify)                  Et on reboucle !
            '0                                 20ms*nb buffer                            40mS*nb buffer
            '|                            | eps.|                                  |eps.  |            
            '----------------------------------------------------------------------------------------
            '|                            |     |                                  |      |            
            '----------------------------------------------------------------------------------------

            ' on calcul la notification à chaque fois que le buffer à joué 20ms  * nb de buffer de 20ms de son (moins Epsilon) 
            ' Cet epsilon me permet de documenter la suite du buffer le temps que DXSound continu à le jouer.

            '  Déclaration de la notification AutoResetEvent
            Notification_Sound = New AutoResetEvent(False)

            ' Création strucuture de notification pour Direct Sound
            Dim Notify(Taille_DX_Buffer - 1) As NotificationPosition
            Dim Epsilon As Integer
            Epsilon = 6

            For I = 0 To Taille_DX_Buffer - 1  ' Nombre de bloc dans le _secondary_buffer !
                'Définition des notifications : En Milieu de buffer
                Notify(I) = New NotificationPosition

                Notify(I).Offset = (I + 1) * Nb_Sound_Bytes - Epsilon  ' 4 Positions de mileu : attention 16bits et mono = buffer*2 !
                Notify(I).WaitHandle = Notification_Sound         ' mise en place type de Notification
            Next I

            'Mise en place notification dans le Buffer
            _secondaryBuffer.SetNotificationPositions(Notify)

            ' Unlock the buffer
            _secondaryBuffer.Unlock(dataPart1, dataPart2)


            ' Calcul du nombre de cycle que devra faire le Z80 avant de mémoriser un état danns le buffer son
            Exact_Cycle = TstatesPerInterrupt / SampleRate_20ms
            Step_Tstate_MEA = TstatesPerInterrupt \ 1280 ' 50 / 64khz = 1/1280 

            local_tstates = 0 '-TstatesPerInterrupt
            local_tstatesDisc = 0 '  -TstatesPerInterruptDisc

            ' Mise en place definitive des textes du combo d'affichage des traces
            Me.ComboTrace.Items.Clear()
            If Choix = MD Then
                Me.ComboTrace.Items.AddRange(New Object() {"Dump Mémoire Programme", "Dump Mémoire Vidéo", "Trace WD1793", "Trace cassette", "Trace sn76477", "Trace MEA8000"})
            ElseIf Choix = ARD Then
                Me.ComboTrace.Items.AddRange(New Object() {"Dump Mémoire Programme", "Dump Mémoire Vidéo", "Trace Arduino", "Trace cassette", "Trace sn76477", "Trace MEA8000"})
            Else
                Me.ComboTrace.Items.AddRange(New Object() {"Dump Mémoire Programme", "Dump Mémoire Vidéo", "Trace uPD765", "Trace cassette", "Trace sn76477", "Trace MEA8000"})
            End If
            ComboTrace.Text = "Dump Mémoire Programme"

            'Init du AY8912
            AY8912_init(1500000, SampleRate, 8) ' Frequence / Samplerate et nombre diviseur pour calcul sample 1.5Mhz=Oric

            __Son(True)
        End If

        'Il faut lancer le uPD765 et on initalise l'ensemble dès le départ !
        If Not (Z80_Lance_Disc2) Then
            uPD765.Init_uPD()
            Z80_Lance_Disc2 = True
        End If

        ' Autres initialisations pour le son
        Cycle_Son = Cycle_Son + Exact_Cycle  'prochaine interruption pour mémorisation du son

        Tstate_For_MEA = local_tstates + Step_Tstate_MEA 'prochaine interruption pour mémorisation du son produit par le MEA8000

        Idx_Buffer_Son = 0 'index dans le buffer son 
        InterruptTimer = timeGetTime

        ' Boucle de réalisation du cycle des Z80
        Do
            ' Exécution d'une seule instruction Z80 d'Hector 
            Proc.execute_OneShot(local_tstates)

            'Gestion du MEA8000 : Calcul de l'échantillon à 64KHz
            If Math.Abs(local_tstates - Tstate_For_MEA) < 200 And local_tstates > Tstate_For_MEA Then ' ATTENTION AU REBOUCLAGE !!!! si Tstate for mea = 20 et localstate juste sous le tmaxi => ça passe et ça doit pas!
                'On calcul le Sample du MEA au rythme de 64KHZ
                Nb_MEA_Sample = mea8000_echantillon()
                ' On calcul le timer pour les interruptions son MEA8000 pour le prochain coup !
                Tstate_For_MEA = local_tstates + Step_Tstate_MEA
                If Tstate_For_MEA > TstatesPerInterrupt Then
                    Tstate_For_MEA -= TstatesPerInterrupt
                End If
            End If

            ' Gestion du Son à 4* 44,100 KHz !
            If local_tstates > Cycle_Son Then
                ' On est au moment ou on enregistre une donnée du son
                ' => Mise en place dans le buffer son des sons en cours

                ' Bit_Son : c'est l'état du 1 bit son généré par Hector (mis dans Btson pour le signal),
                ' à cela on ajout le calcul courant du signal sortant du SN76477 et du AY
                ' puis on ajoute le son courant sortant du MEA8000
                ' Le MEA8000 est calculé à une fréquence différente (64Khz) mais
                ' sa valeur courante est prise à la fréquence du son écoutée (176,4Khz)
                Dim Btson As Short = 20000 ' 10900

                If Bit_Son Then
                    Btson = 0
                End If

                'remplissage du buffer son !
                If Magneto.MotorON Then
                    Btson = Son_K7 * 40  ' Ici on mets le son de la cassette lorsque la cassette est en marche !
                Else
                    Dim AY As Short
                    AY = RenderByte()
                    Btson = Btson + Son_Sn76477() + Nb_MEA_Sample - AY ' Ici on a bien les calculs à frequences différentes!
                End If

                'Filtre
                Echant_Fltr(Filtre_Index) = Btson
                Dim v As Integer = 0
                For I = 0 To Filtre_Prof - 1
                    v = v + Echant_Fltr((Filtre_Index + I) Mod Filtre_Prof) * h(I)
                Next
                v = v / (Filtre_KhMoyen) 'val somme des h() pour pondérer
                '  var v = 0
                '  For I = 1 To N
                '     v = v+ tab[(index+i) mod N]*coef[i]:
                '  Next
                '  Index = (Index + 1) Mod N
                ' echantillon_filtré = v
                ' sortir(echantillon_filtré)
                ' Selon que l'on est en filtré ou non, utilisation de la valeur adéquate

                If Idx_Buffer_Son < Nb_Sound_Sample - 1 Then 'Si buffer pas plein !
                    If CheckBoxFiltre.Checked Then
                        buffe(Idx_Buffer_Son) = v     ' Valeur filtrée
                    Else
                        buffe(Idx_Buffer_Son) = Btson ' Valeur brute
                    End If
                    'on avance l'index du filtre dans le chenillard
                    Filtre_Index = (Filtre_Index + 1) Mod Filtre_Prof

                    ' incrementation de l'index dans le buffer pour le prochain coup !
                    Idx_Buffer_Son += 1 ' quitte à ce que l'index soit plus grand que le tableau, cela indiquera que c'est plein !

                End If

                ' et calcul du moment de la prochaine exécution de la prise en compte du son. 
                Cycle_Son = Cycle_Son + Exact_Cycle

                If Cycle_Son > TstatesPerInterrupt Then
                    'cas du rebouclage
                    Cycle_Son -= TstatesPerInterrupt
                End If

            End If

            ' **********************************************
            ' Exécution d'une seule instruction Z80 du Disc2 
            ' **********************************************
            If (local_tstatesDisc < TstatesPerInterruptDisc) And Choix <> ARD And Choix <> MD Then  ' Le Z80 du Disc2 est plus lent que celui de l'Hector
                Run_Disc2()
            End If

            ' ****************************
            ' Execution d'un cycle ARDUINO
            ' ****************************
            If Choix = ARD Then
                Arduino.OneCycle()
            End If

            ' ***************************************************************************
            ' ************'********* GESTION DES TIMING HECTOR  **************************
            ' ***************************************************************************

            'Test si necessité interruption, auquel cas on a débordé du temps imparti !
            If (local_tstates >= TstatesPerInterrupt) Then
                ' ***************************************************************************************
                ' Lancement d'une interruption et calcul du prochain temps pour la prochaine interuption.
                ' ***************************************************************************************
                local_tstates = local_tstates - TstatesPerInterrupt + Proc.interrupt()   'Interruption !!!!

                'Debug
                If Debug_SN Then
                    'Affichage de la valeur de tension du A/D
                    Dim aa As Single
                    aa = Valeur / 100
                    Labeldeb.Text = Format(aa, "0.00")
                End If
                'Affichage specifique du Debuggage pour le sn76477
                If DBG <> DBG_NONE And (ComboTrace.Text = "Trace sn76477") Then

                    TraceK7.Text += Strg_SN
                    Strg_SN = ""
                End If
                ' Stuff pour Windows : affichage des info et on laisse respirer windows...
                Hector.ScreenPaint()
                My.Application.DoEvents()
                If Quitting Then
                    ' En cas de fin de programme, il faut sortir de cette boucle infernale (Do...Loop)
                    Exit Sub
                End If
                'Recup état clavier version 2
                Clavier2()

                'Selon la résolution choix de la vitesse du Z80 !
                'Comme ce calcul est fait à la prochaine interruption (celle dans laquelle on se trouve !)
                ' Il n'est pas nécessaire de recalculer les timer pour le son et le MEA !
                If Hector.Resolution = 0 And Arduino.Fonction = 0 Then ' Ici je triche, sur Hector ça marchera pas !
                    TstatesPerInterrupt = SpeedBR   ' 45000 théorie
                Else
                    TstatesPerInterrupt = SpeedHR   '100000
                End If

                'on a effectué 20ms de son, on recalcul les pointeurs pour le AY
                AY8912Update_8()
                Flag_AY = True
                'Timing du son selon vitesse Z80.
                ' 5 000 000 / 4*44100 = très peut : 28,34467120 
                ' 1 770 000 / 4*44100 = encore moins !
                ' Toutes les 38.34 période de l'horloge je dois calculer un échantillon de son !

                ' Nb echant par 20ms c'est ce que DOIT calculer Hector entre 2 interruptions !
                ' Version 2 : Maintenant le calcul des cycles se fait sur un double
                '             de façon à limiter les erreurs de cycles 
                '             qui s'entendait plus que serieusement lorsque je suis passé de 44,1Khz à 176,4Khz du son joué
                '             car, forcement, l'écart entre 2 cycles son s'est reduit et donc l'errueur est monté en fléche
                '             ce n'était plus acceptable (le TONE 300,999 était encore plus mauvais et le son avec l'HectorDuino aussi !
                Exact_Cycle = TstatesPerInterrupt / SampleRate_20ms

                'Gestion du son en synchro avec le Z80 pour 20 ms

                ' Les interruptions ont lieu toutes les 20 ms.
                ' s'il nous reste du temps, il faut ralentir un peu l'exécution
                ' pour avoir un comportement cohérent.
                ' évidement si c'est trop lent on peut rien faire !
                ' Condition d'attente :
                '  Si Idx_Tour_Son < Nombre de buffer son demandés => timer 
                '  Si Idx_Tour_Son = Nombre de buffer son demandés => Sur fin du son

                ' incrémentation nombre de tour réalisés
                Idx_Tour_Son += 1

                ' Calcul de la ligne temporelle réelle
                Dim Temp As Long
                Temp = timeGetTime()
                '             (Temps mis pour 20ms  )
                lsleep = 20 - (Temp - InterruptTimer)    ' Temps que l'on aurait du mettre pour faire les 20 ms d'émulation

                'Pour le prochain coup dans 20 ms...
                InterruptTimer = Temp

                ' Gestion de l'affichage du taux d'avance
                If Compteur_T1T2 > 50 Then 'Soit toutes les secondes avec un Taille_Buffer= 1
                    Compteur_T1T2 = 0
                    Label9.Text = ERROR_ATT_SON.ToString & "  under buffer :" & ERROR_BUFF_NR
                    ERROR_ATT_SON = 0
                    ERROR_BUFF_NR = 0

                    ' On en profite pour mettre le focus sur un label 
                    Label10.Select()

                    ' Dessin de la cassette en marche
                    Dim Dessin_K7 As Char
                    If Magneto.MotorON Then
                        Select Case Status_Motor_K7
                            'Création de l'animation du l'avance de la K7 !
                            Case 0
                                Dessin_K7 = "|"
                            Case 1
                                Dessin_K7 = "/"
                            Case 2
                                Dessin_K7 = "-"
                            Case Else
                                Dessin_K7 = "\"
                                Status_Motor_K7 = -1
                        End Select
                        Status_Motor_K7 += 1
                    Else
                        Dessin_K7 = "*"
                    End If
                    'Mise en place
                    ToolStripStatus_K7.Text = Microsoft.VisualBasic.Left(ToolStripStatus_K7.Text, ToolStripStatus_K7.Text.Length - 1) & Dessin_K7

                End If

                ' Et enfin contrôle du nombre de tour réalisés :
                ' Deux cas sont distingués : 
                '      Soit on a réalisé le nombre de buffer de 20ms que l'on souhaitait faire (1 ou 2 généralement, mais de 1 à 9)
                '             => on attends la fin du buffer son pour faire la synchro !
                '      Sot on est en cours de remplissage de ce buffer 
                '              => donc on va réaliser une synchro intermédiaire par timer

                ' Grace à la qualité et la finesse de DirectX Sound et des notifications
                ' Le buffer que l'on envoi à la carte son est de 20ms !

                ' On ne pas plus JAMAIS dans la partie temporelle avec le Sleep !
                '                         puisque taille_buffer est paramétré à 1!!!
                '   maintenant que l'on peut paramétrer la taille du buffer,
                '  c'est maintenant re-utile !
                ' 27/12/2015 avec rara & cie à la maison !

                If Idx_Tour_Son < Taille_Buffer Then
                    ' on est dans le nombre de tour avant le dernier, l'attente sera donc temporelle
                    ' pour tricher un peu... de toutes façon le son, lui, sera à l'heure !
                    lsleep -= 2  ' on garde un peu d'avance !
                    If lsleep > 1 Then
                        'Uniquement si beaucoup trop rapide !
                        System.Threading.Thread.Sleep(CType(lsleep, Integer))
                    End If

                    If Quitting Then
                        Exit Sub
                    End If
                Else
                    ' Dans le cas ou on a fait le nombre de tour demandés, c'est le moment d'attendre la fin du buffer son joué !

                    ' On a documenté n tours de 20ms (soit ...Taille buffer * 20ms)  => 20ms si le nombre de buffer est selectionné  à 1 !
                    ' Au cas ou on a pas bien calculé le coup, on prolonge la note pour éviter tout soucis !

                    'Là aussi en passant via un double, cela n'arrive presque plus !
                    If Idx_Buffer_Son < Nb_Sound_Sample - 1 Then
                        Dim Dernier_Etat_Son As Short
                        If Idx_Buffer_Son > 1 Then
                            Dernier_Etat_Son = buffe(Idx_Buffer_Son - 1)
                        Else
                            Dernier_Etat_Son = buffe(Nb_Sound_Sample - 1)
                        End If
                        Do Until Idx_Buffer_Son >= (Nb_Sound_Sample - 1)
                            buffe(Idx_Buffer_Son) = Dernier_Etat_Son
                            Idx_Buffer_Son += 1
                            ERROR_BUFF_NR += 1 'on indique le nb d'échantillon manquant
                        Loop
                        '   ERROR_BUFF_NR += 1 'on indique le nb fois qu'il manquait un échantillon
                    End If

                    'On memorise l'heure avant et après et si c'est moins d'une milli sec
                    ' c'est que le timing est un peu court et on l'indiique.
                    T1 = timeGetTime
                    '********************************************************************************************************************************************
                    'Maintenant on est taqué pour attendre la fin du son joué...
                    ' Attente notification
                    If Not (Debuggage) Then
                        Notification_Sound.WaitOne(1000, True) 'avec time out des fois que..!
                    End If
                    '********************************************************************************************************************************************
                    'C'est OK, on est à la fin du sample
                    ' Mise à jour du buffer son plus simple qu'avec le UNLOCK/LOCK secondary buffer
                    _secondaryBuffer.Write(buffe, 0, LockFlags.FromWriteCursor)
                    '********************************************************************************************************************************************

                    'Calcul des temps d'attentes aux points de notifications !
                    T2 = timeGetTime
                    If (T2 - T1) = 0 Then
                        ' compteur de non attente (au moins de moins de 1ms)
                        ERROR_ATT_SON += 1
                    End If
                    Compteur_T1T2 += 1


                    ' Ensuite on raz l'index et le timer pour le buffer son
                    ' rebouclage du compteur 
                    Idx_Tour_Son = 0
                    Idx_Buffer_Son = 0

                End If  ' du 20ms * nb buffer 


                'Pour l'attente de 20ms par lot d'instruction sur le Z80 du Disc 2 
                Wait_20ms_Disc = False
            End If


            ' ***************************************************************************
            ' ********************* GESTION DES TIMING DISC2 ****************************
            ' ***************************************************************************
            If Choix <> ARD Then
                If local_tstatesDisc >= TstatesPerInterruptDisc And Not Wait_20ms_Disc Then 'On ne peut reboucler le Z80 du disc2 que si les 20ms ont été vues !
                    local_tstatesDisc = local_tstatesDisc - TstatesPerInterruptDisc 'on relance la machine

                    ' on set le flag d'attente du rebouclage de 20 ms d'Hector
                    Wait_20ms_Disc = True
                    'On raz le flag de controle rebouclage pour INT et NMI
                    Need_Loop_INT = False
                    Need_Loop_NMI = False
                End If
            End If


            ' ******************************************************************************
            ' ******************  Gestion du debug Z80 HECTOR ******************************
            ' ******************************************************************************
            If Proc.regPC = Adr_Break_Hector Then  'Breakpoint !!
                Debuggage = True
                'Gestion des boutons...
                Mise_a_jour_controles()
            End If


            ' ********************************************************************
            ' ******************** Gestion du debug Z80 Disc2 ********************
            ' ********************************************************************

            If Proc_Disc2.regPC = Adr_Break_Disc2 Then  'Breakpoint !!
                Debuggage = True
                'Gestion des boutons...
                Mise_a_jour_controles()
            End If


            ' **************************************************************
            ' ******************** Gestion du debug Z80 ********************
            ' **************************************************************

            If Debuggage Then
                __Son(False)
                Affichage_Debug(True)
                If Not (ModeTrace) Then
                    ' Sortie de la procédure en cas de breakpoint
                    ' Pas forcément besoin de gérer le son qui s'arrêtra tout seul...
                    ' On sera relancé via la procédure Continuer() qui relance la procédure Run_Hector.
                    Exit Sub
                Else
                    'on est en mode trace, on affiche la barre de progression

                    InterBar.Maximum = CInt(TstatesPerInterrupt + 100) 'on triche un peu car les cycles Z80 ne sont pas par pas fixe
                    InterBar.Value = CInt(50 + local_tstates)
                    'Si on est en mode trace, il faut laissez Windows respirer entre 2 instructions Z80 !

                    Hector.ScreenPaint()
                    My.Application.DoEvents()
                    If Quitting Then
                        ' En cas de fin de programme, il faut sortir de cette boucle infernale (Do...Loop)
                        Exit Sub
                    End If
                End If
            Else
                __Son(True)
            End If


            'Gestion du Z80 activée
            Z80_Lance_Hector = True 'Indique que le Z80 a déjà été lancé !
        Loop

    End Sub

    'Disc 2 !
    Private Sub Run_Disc2()
        'execution d'une seule instruction Z80 du lecteur Disc2 + stuff !
        Proc_Disc2.execute_OneShot(local_tstatesDisc) 'Un instruction Z80 du Disc2

        ' *************************************************
        ' ****** Gestion des interruptions du lecteur *****
        ' *************************************************
        If Disc2_INT And Not (Armed_INT) And Disc2_RNMI Then
            ' Une demande d'intérruption a été réalisée 
            ' Sur l'échange entre le Disc2 et le uPD il y a un petit
            ' Bug qui fait que cela ne fonctionne pas si l'interruption
            ' Arrive juste après l'autorisation...
            ' Ce bug est valable pour l'interruption NMI, mais n'étant pas
            ' à 15 cycle de Z80 pour recevoir l'interruption, je l'ai appliqué" à l'INT aussi
            ' On temporise alors un peu ici entre la demande et la réalisation

            Tstate_for_int = local_tstatesDisc + 15 ' tempo 15 cycles : Permet de laisser respirer

            If Tstate_for_int >= TstatesPerInterruptDisc Then
                ' 
                Tstate_for_int -= TstatesPerInterruptDisc
                Need_Loop_INT = True
            Else
                Need_Loop_INT = False
                '
            End If
            ' On armed
            Armed_INT = True
            Disc2_INT = False
        End If

        If (Armed_INT And (local_tstatesDisc > Tstate_for_int) And Not (Need_Loop_INT)) Or Interrupt_Decale Then
            'On raz le flag de demande d'int !
            Armed_INT = False

            'on lance l'interruption
            local_tstatesDisc = local_tstatesDisc + Proc_Disc2.interrupt()   'Interruption !!!!
            If Proc_Disc2.regPC = 56 Then
                'Tout va bien l'interruption est lancée !
                Interrupt_Decale = False
            Else
                ' On est dans le cas ou les interruptions sont masquées,
                ' on attend donc qu'elles ne le soient plus !
                Interrupt_Decale = True
            End If
        End If

        ' *************************************************
        ' ****************** Gestion NMI ******************
        ' *************************************************

        If Disc2_NMI And (Not (Armed_NMI)) And Disc2_RNMI Then
            ' Une demande d'intérruption a été réalisée 
            ' Sur l'échange entre le Disc2 et le uPD il y a un petit
            ' Bug qui fait que cela ne fonctionne pas si l'interruption
            ' Arrive juste après l'autorisation...
            ' On temporise alors un peu ici entre la demande et la réalisation

            Tstate_for_nmi = local_tstatesDisc + Wait_Time_NMI  ' tempo

            If Tstate_for_nmi >= TstatesPerInterruptDisc Then
                ' On a dépassé le temps de rebouclage de 20ms
                ' il faudra donc attentre le rebouclage avant de tester la valeur
                Tstate_for_nmi -= TstatesPerInterruptDisc
                Need_Loop_NMI = True
            Else
                Need_Loop_NMI = False
            End If
            ' On arme
            Armed_NMI = True
            Disc2_NMI = False
        End If

        If (Armed_NMI And (local_tstatesDisc > Tstate_for_nmi) And (Not (Need_Loop_NMI))) Then
            'On raz le flag d'int !
            Armed_NMI = False

            'on lance l'interruption NMI
            local_tstatesDisc = local_tstatesDisc + Proc_Disc2.NMI()   'Interruption NMI !!!!
        End If

    End Sub
    Sub Reset_Disc2()
        'Remise à 0 du CPU
        local_tstatesDisc = 0

        Proc_Disc2.Z80Reset(local_tstatesDisc, TstatesPerInterruptDisc)
        'Flag RAM/ROM
        BST = False
        ' Flage d'échange avec Hector
        Disc2.Disc2_data_r_ready = False
        Disc2.Disc2_data_w_ready = False
        ' Init du controleur de disquette
        Init_uPD()
    End Sub


    'Gestion du menu FICHIER


    Private Sub StartHectorToolStripMenuItem_Click(sender As Object, e As EventArgs)
        'plus d'entrée start dans le menu !
        'Et on relance la machine !
        '     If Not (Z80_Lance_Hector) Then
        '         Run_Hector()
        '     End If
    End Sub
    Private Sub FichierOuvrirK7ToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles FichierOuvrirK7ToolStripMenuItem.Click
        __Son(False)
        Enregistre_WAV = False
        Enregistre_K7 = False
        ToolStripEnregistrerMenuItem.Checked = Enregistre_WAV
        ToolStripEnregistrerK7MenuItem.Checked = Enregistre_K7
        New_cassette()
        __Son(True)
    End Sub
    Private Sub RembobinerK7ToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles RembobinerK7ToolStripMenuItem.Click
        'On quitte le mode enregistrement
        __Son(False)
        Enregistre_WAV = False
        Enregistre_K7 = False
        ToolStripEnregistrerMenuItem.Checked = Enregistre_WAV
        ToolStripEnregistrerK7MenuItem.Checked = Enregistre_K7
        'et on rembobine !
        '      Magneto.Rembobine()
        If Len(Nom_K7) = 0 Then Exit Sub 'aucun choix
        'et on ouvre le fichier selectionné
        Magneto.Init_Cassette(Nom_K7)
        ToolStripStatus_K7.Text = "K7 : " + Microsoft.VisualBasic.Right(Nom_K7, Nom_K7.Length - InStrRev(Nom_K7, "\")) + " "
        __Son(True)

    End Sub

    Private Sub New_cassette()
        Dim F As New OpenFileDialog

        ' ouvre une boite de dialogue
        F.Filter = "Cassette Image Files (*.K7, *.FOR)|*.K7;*.FOR"
        F.Title = "Choisir un fichier K7 classique ou FORTH"
        F.ShowDialog()
        Nom_K7 = F.FileName

        If Len(Nom_K7) = 0 Then Exit Sub 'aucun choix
        'et on ouvre le fichier selectionné
        Magneto.Init_Cassette(Nom_K7)
        ToolStripStatus_K7.Text = "K7 : " + Microsoft.VisualBasic.Right(F.FileName, F.FileName.Length - InStrRev(Nom_K7, "\")) + " "
        My.Settings.File_K7 = Nom_K7
    End Sub

    Private Sub ToolStripEnregistrerMenuItem_Click(sender As Object, e As EventArgs) Handles ToolStripEnregistrerMenuItem.Click
        If Enregistre_WAV Then
            Enregistre_WAV = False
        Else
            Enregistre_WAV = True
        End If
        Enregistre_K7 = False

        ToolStripEnregistrerMenuItem.Checked = Enregistre_WAV
        ToolStripEnregistrerK7MenuItem.Checked = Enregistre_K7

        If Enregistre_WAV Then
            ToolStripStatus_K7.Text = "...enregistrement WAV..."
        Else
            ToolStripStatus_K7.Text = "......"
        End If
    End Sub
    Private Sub ToolStripEnregistrerK7MenuItem_Click(sender As Object, e As EventArgs) Handles ToolStripEnregistrerK7MenuItem.Click
        If Enregistre_K7 Then
            Enregistre_K7 = False
        Else
            Enregistre_K7 = True
        End If
        Enregistre_WAV = False

        ToolStripEnregistrerMenuItem.Checked = Enregistre_WAV
        ToolStripEnregistrerK7MenuItem.Checked = Enregistre_K7

        If Enregistre_K7 Then
            ToolStripStatus_K7.Text = "...enregistrement K7..."
        Else
            ToolStripStatus_K7.Text = "......"
        End If

    End Sub
    Private Sub ToolStripMenuD7_A_Click(sender As Object, e As EventArgs) Handles ToolStripMenuD7_A.Click
        Dim F As New OpenFileDialog
        'on arrete le son
        __Son(False)

        ' ouvre une boite de dialogue
        If Choix <> MD Then
            ' pour le Disc 2
            F.Filter = "Disquette Image Files (*.IMG, *.HE2, *.HE7, *.HE8)|*.IMG;*.HE2;*.HE7;*.HE8"
        Else
            'Pour le Mini disque
            F.Filter = "Disquette Image Files (*.IMG, *.HMD, *.ANA)|*.IMG;*.HMD;*.ANA"
        End If
        F.Title = "Choisir un fichier disquette pour lecteur A:"
        F.ShowDialog()
        If Len(F.FileName) = 0 Then
            __Son(True)
            Exit Sub 'aucun choix
        End If
        ' on ouvre le fichier selectionné
        If Choix <> MD Then
            Ouvre_Disquette(F.FileName, 0, uPD765.DiskA_type)  'Type_Disk.HE2
        Else
            Ouvre_Disquette(F.FileName, 2, 0)  'Type minidisque !
        End If

        ' Mise en place du nom dans la status bar
        ToolStripStatus_A.Text = "A:  " + Microsoft.VisualBasic.Right(F.FileName, F.FileName.Length - InStrRev(F.FileName, "\"))

        __Son(True)
    End Sub
    Private Sub ToolStripMenuD7_B_Click(sender As Object, e As EventArgs) Handles ToolStripMenuD7_B.Click
        Dim F As New OpenFileDialog

        __Son(False)
        ' ouvre une boite de dialogue

        If Choix <> MD Then
            ' pour le Disc 2
            F.Filter = "Disquette Image Files (*.IMG, *.HE2, *.HE7, *.HE8)|*.IMG;*.HE2;*.HE7;*.HE8"
            F.Title = "Choisir un fichier disquette pour lecteur A:"
            F.ShowDialog()
            If Len(F.FileName) = 0 Then
                __Son(True)
                Exit Sub 'aucun choix
            End If
            ' on ouvre le fichier selectionné
            Ouvre_Disquette(F.FileName, 1, uPD765.DiskB_type)
            ' Mise en place du nom dans la status bar
            ToolStripStatus_B.Text = "B:  " + Microsoft.VisualBasic.Right(F.FileName, F.FileName.Length - InStrRev(F.FileName, "\"))
        Else
            MsgBox("Désolé, 1 seul lecteur sur le mini disque !", vbOKOnly, "Erreur !")
        End If
        __Son(True)
    End Sub

    Sub Ouvre_Disquette(ByRef Nom_Disquette As String, ByVal Lecteur As Byte, ByRef Type As uPD765.Type_Disk)
        Dim iCounter As Integer
        Dim sFile() As Byte
        Dim Taille As Integer


        Dim Fi As FileInfo      'On déclare un FileInfo

        Fi = New FileInfo(Nom_Disquette)
        If Not (Fi.Exists) Then Exit Sub

        If Fi.Length = 204800 Then
            Type = Type_Disk.HE2
        ElseIf Fi.Length = 204800 * 4 Then
            Type = Type_Disk.HE8
        ElseIf Fi.Length = 737280 Then
            Type = Type_Disk.HE7
        Else
            If Lecteur <> 2 Or Fi.Length <> 645120 Then
                MsgBox("Aie, ce ne semble pas être un fichier disquette au format RAW, je tente quand même le chargement !!", MsgBoxStyle.OkOnly, "Oups...")
                '   Exit Sub
            End If
        End If

        Taille = CInt(Fi.Length) - 1
        ReDim sFile(Taille)

        sFile = My.Computer.FileSystem.ReadAllBytes(Nom_Disquette)

        If Lecteur = 0 Then
            ' Lecteur A:
            For iCounter = 0 To Taille
                Fd0(iCounter) = sFile(iCounter)  ' mise en place dans le fichier de disquette
            Next iCounter

            ' Mise en place du repertoire complet du nom de fichier 
            My.Settings.File_A = Nom_Disquette

        ElseIf Lecteur = 1 Then
            ' Lecteur B:
            For iCounter = 0 To Taille
                Fd1(iCounter) = sFile(iCounter)  ' mise en place dans le fichier de disquette
            Next iCounter

            ' Mise en place du repertoire complet du nom de fichier 
            My.Settings.File_B = Nom_Disquette

        ElseIf Lecteur = 2 Then
            ' Lecteur MINIDISQUE
            For iCounter = 0 To Taille
                Fd(iCounter) = sFile(iCounter)  ' mise en place dans le fichier de disquette
            Next iCounter

            ' Mise en place du repertoire complet du nom de fichier 
            My.Settings.File_A = Nom_Disquette

        End If

    End Sub

    Private Sub SauvegardeDisquetteAToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles SauvegardeDisquetteAToolStripMenuItem.Click
        Dim F As New SaveFileDialog
        Dim Res As Result
        __Son(False)

        F.AddExtension = False
        ' ouvre une boite de dialogue
        If Choix <> MD Then
            ' pour le Disc 2
            F.Filter = "Disquette Image Files (*.IMG, *.HE2, *.HE7, *.HE8)|*.IMG;*.HE2;*.HE7;*.HE8"
        Else
            'Pour le Mini disque
            F.Filter = "Disquette Image Files (*.HMD, *.IMG, *.ANA)|*.HMD;*.IMG;*.ANA"
        End If
        F.Title = "Choisir un nom de fichier pour enregistrer le lecteur A:"
        Res = F.ShowDialog()
        If ((Len(F.FileName) = 0) Or (Res = vbCancel)) Then
            __Son(True)
            Exit Sub
        End If

        ' on ouvre le fichier selectionné
        If Choix <> MD Then
            Sauve_disquette(F.FileName, 0, uPD765.DiskA_type)  'Type_Disk.HE2
        Else
            Sauve_disquette(F.FileName, 2, Type_Disk.HMD)  'Type minidisque !
        End If
        __Son(True)
    End Sub
    Private Sub SauvegardeDisquetteBToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles SauvegardeDisquetteBToolStripMenuItem.Click
        Dim F As New SaveFileDialog
        Dim Res As Result
        __Son(False)

        F.AddExtension = False
        ' ouvre une boite de dialogue
        If Choix <> MD Then
            ' pour le Disc 2
            F.Filter = "Disquette Image Files (*.IMG, *.HE2, *.HE7, *.HE8)|*.IMG;*.HE2;*.HE7;*.HE8"
        Else
            'Pour le Mini disque
            MsgBox("Pas de disquette B: sur le mini disque", vbOKOnly, "Erreur !")
            __Son(True)
            Exit Sub
        End If
        F.Title = "Choisir un nom de fichier pour enregistrer le lecteur A:"
        Res = F.ShowDialog()
        If ((Len(F.FileName) = 0) Or (Res = vbCancel)) Then Exit Sub 'aucun choix
        'et on ouvre le fichier selectionné
        Sauve_disquette(F.FileName, 1, uPD765.DiskB_type)  'Type_Disk.HE2

        __Son(True)
    End Sub

    Private Sub Sauve_disquette(ByRef Nom_Disquette As String, ByVal Lecteur As Byte, ByRef Type As uPD765.Type_Disk)
        Dim iCounter As Integer
        Dim sFile() As Byte
        Dim Taille As Integer
        Dim Fi As FileInfo      'On déclare un FileInfo

        Fi = New FileInfo(Nom_Disquette)

        If Type = Type_Disk.HE2 Then
            Taille = 204800
        ElseIf Type = Type_Disk.HE8 Then
            Taille = 204800 * 4
        ElseIf Type = Type_Disk.HE7 Then
            Taille = 737280
        ElseIf Type = Type_Disk.HMD Then
            Taille = 645120
        End If

        'On raz d'abord le fichier!
        If File.Exists(Fi.Name) Then
            File.Delete(Fi.Name)
        End If

        ' On dimensionne la variable avec le sFile 
        ReDim sFile(Taille - 1)

        ' ensuite on positionne les données dans la variable
        If Lecteur = 0 Then
            ' Lecteur A:
            For iCounter = 0 To Taille - 1
                sFile(iCounter) = Fd0(iCounter)
            Next iCounter

        ElseIf Lecteur = 1 Then
            ' Lecteur B:
            For iCounter = 0 To Taille - 1
                sFile(iCounter) = Fd1(iCounter)
            Next iCounter
        ElseIf Lecteur = 2 Then
            ' Lecteur MINIDISQUE
            For iCounter = 0 To Taille - 1
                sFile(iCounter) = Fd(iCounter)
            Next iCounter
        End If

        'Sauvegarde du fichier
        My.Computer.FileSystem.WriteAllBytes(Nom_Disquette, sFile, False)

        ' Mise en place du nom dans la status bar
        If Choix <> ARD Then
            If Lecteur = 0 Then
                ToolStripStatus_A.Text = "A:  " + Microsoft.VisualBasic.Right(Nom_Disquette, Nom_Disquette.Length - InStrRev(Nom_Disquette, "\"))
            ElseIf Lecteur = 1 Then
                ToolStripStatus_B.Text = "B:  " + Microsoft.VisualBasic.Right(Nom_Disquette, Nom_Disquette.Length - InStrRev(Nom_Disquette, "\"))
            ElseIf Lecteur = 2 Then
                ToolStripStatus_A.Text = "A:  " + Microsoft.VisualBasic.Right(Nom_Disquette, Nom_Disquette.Length - InStrRev(Nom_Disquette, "\"))
                ToolStripStatus_B.Text = "---"
            End If
        Else
            ToolStripStatus_A.Text = "SD :" & Arduino.Directory
            ToolStripStatus_B.Text = ""
        End If
    End Sub

    Private Sub CopieÉcranToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles CopieÉcranToolStripMenuItem.Click
        Save_Copie_Ecran()
    End Sub

    Sub Save_Copie_Ecran()

        Dim F As New SaveFileDialog
        Dim Name_File As String
        Static Num_File As Integer = 0
        Dim Copie_Image As Bitmap

        __Son(False)

        Num_File += 1
        Name_File = Num_File.ToString
        Name_File = "img" + Microsoft.VisualBasic.Right("000" + Name_File, 3) + ".bmp"

        F.FileName = Name_File

        F.Filter = "Copie d'écran (*.bmp)|*.bmp"
        ' F.InitialDirectory = "C:\"
        F.Title = "Choisir un nom pour votre copie d'écran"
        F.ShowDialog()

        If Len(F.FileName) = 0 Then Exit Sub 'aucun choix

        Copie_Image = Hector.Screen
        Copie_Image.Save(F.FileName)
        '    Hector.Screen.Dispose()

        __Son(True)
    End Sub
    Private Sub EmulationJOY0ToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles EmulationJOY0ToolStripMenuItem.Click
        Joy_Select = 0
        Mise_a_jour_controles()
    End Sub
    Private Sub EmulationJOY1ToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles EmulationJOY1ToolStripMenuItem.Click
        Joy_Select = 1
        Mise_a_jour_controles()
    End Sub
    Private Sub QuitterToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles QuitterToolStripMenuItem.Click
        End
    End Sub


    'Menu 

    Private Sub ToolStripMenuSauveDump_Click(sender As Object, e As EventArgs) Handles ToolStripMenuSauveDump.Click
        ' Sauvegarde dans un fichier de l'état de la machine (registres, mémoires, type de machine, 
        Dim No As Integer
        Dim F As New Microsoft.VisualBasic.FileIO.FileSystem
        Dim G As New SaveFileDialog

        __Son(False)

        ' ouvre une boite de dialogue
        G.Filter = "Snap shot Image Files (*.hec)|*.hec"
        G.Title = "Choisir un fichier de sauvegarde"
        G.ShowDialog()
        If Len(G.FileName) = 0 Then
            __Son(True)
            Exit Sub
        End If

        No = FreeFile()

        FileOpen(No, G.FileName, OpenMode.Binary)
        '  sSnapShot = New String(" "c, 65536 * 10)        'Créer une chaîne avec suffisament d'espaces
        ' FileGet(No, sSnapShot)
        FilePut(No, Hector.mem_P0)
        FilePut(No, Hector.mem_P1)
        FilePut(No, Hector.mem_P2)
        FilePut(No, Hector.mem_H)

        'Sauvegarde des registres
        FilePut(No, Proc.regA)
        FilePut(No, Proc.regAF_)
        FilePut(No, Proc.regB)
        FilePut(No, Proc.regBC_)
        FilePut(No, Proc.regC)
        FilePut(No, Proc.regDE)
        FilePut(No, Proc.regDE_)
        FilePut(No, Proc.regHL)
        FilePut(No, Proc.regHL_)
        FilePut(No, Proc.regIX)
        FilePut(No, Proc.regIY)
        FilePut(No, Proc.regPC)
        FilePut(No, Proc.regSP)

        'Sauvegarde des Flag Z80
        FilePut(No, Proc.fS)
        FilePut(No, Proc.fZ)
        FilePut(No, Proc.f5)
        FilePut(No, Proc.fH)
        FilePut(No, Proc.f3)
        FilePut(No, Proc.fPV)
        FilePut(No, Proc.fN)
        FilePut(No, Proc.fC)

        'Sauvegarde de l'état du Z80
        FilePut(No, Proc.intI)
        FilePut(No, Proc.intR)
        FilePut(No, Proc.intRTemp)
        FilePut(No, Proc.intIFF1)
        FilePut(No, Proc.intIFF2)
        FilePut(No, Proc.intIM)

        'Stuff d'Hector
        FilePut(No, Hector.Resolution)
        ' on laisse 1 integer pour de la place futur
        Dim Test As Integer
        Test = &H15

        ' Sauvegarde des couleurs courante
        FilePut(No, Test)
        FilePut(No, Hector.colors(0))
        FilePut(No, Hector.colors(1))
        FilePut(No, Hector.colors(2))
        FilePut(No, Hector.colors(3))
        FilePut(No, Hector.Half_Tone)
        FilePut(No, Choix)

        FilePut(No, Hector.colors_0_2)

        FileClose(No)
        __Son(True)

    End Sub
    Private Sub RestitutionDumpMémoireToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles RestitutionDumpMémoireToolStripMenuItem.Click
        __Son(False)

        ' Sauvegarde dans un fichier de l'état de la machine (registres, mémoires, type de machine, 
        Dim No As Integer
        Dim F As New Microsoft.VisualBasic.FileIO.FileSystem
        Dim G As New OpenFileDialog
        'Verifie que la machine est déjà lancée
        If Not (Z80_Lance_Hector) Then
            MsgBox("Il est préférable qu'Hector soit déjà lancé avant de charger un fichier dump....désolé !", vbOKOnly, "Attention...")
            __Son(True)
            Exit Sub
        End If

        ' ouvre une boite de dialogue
        G.Filter = "Snap shot Image Files (*.hec)|*.hec"
        G.Title = "Choisir un fichier de sauvegarde"
        G.ShowDialog()
        If Len(G.FileName) = 0 Then
            __Son(True)
            Exit Sub 'aucun choix
        End If

        No = FreeFile()

        FileOpen(No, G.FileName, OpenMode.Binary)
        'FileGet(No, sSnapShot, )
        FileGet(No, Hector.mem_P0) '  CType(Hector.mem_P0, System.Array)) 
        FileGet(No, Hector.mem_P1) '  CType(Hector.mem_P1, System.Array))
        FileGet(No, Hector.mem_P2) '  CType(Hector.mem_P2, System.Array))
        FileGet(No, Hector.mem_H) '   CType(Hector.mem_H, System.Array))

        'Sauvegarde des registres
        FileGet(No, Proc.regA)
        FileGet(No, Proc.regAF_)
        FileGet(No, Proc.regB)
        FileGet(No, Proc.regBC_)
        FileGet(No, Proc.regC)
        FileGet(No, Proc.regDE)
        FileGet(No, Proc.regDE_)
        FileGet(No, Proc.regHL)
        FileGet(No, Proc.regHL_)
        FileGet(No, Proc.regIX)
        FileGet(No, Proc.regIY)
        FileGet(No, Proc.regPC)
        FileGet(No, Proc.regSP)

        'Sauvegarde des Flag Z80
        FileGet(No, Proc.fS)
        FileGet(No, Proc.fZ)
        FileGet(No, Proc.f5)
        FileGet(No, Proc.fH)
        FileGet(No, Proc.f3)
        FileGet(No, Proc.fPV)
        FileGet(No, Proc.fN)
        FileGet(No, Proc.fC)

        'Sauvegarde de l'état du Z80
        FileGet(No, Proc.intI)
        FileGet(No, Proc.intR)
        FileGet(No, Proc.intRTemp)
        FileGet(No, Proc.intIFF1)
        FileGet(No, Proc.intIFF2)
        FileGet(No, Proc.intIM)

        'Stuff d'Hector
        FileGet(No, Hector.Resolution)

        ' on laisse 2 integer pour de la place futur
        Dim Test As Integer
        FileGet(No, Test)
        ' couleurs courante
        FileGet(No, Hector.colors(0)) ' CType(Hector.colors(0), System.ValueType))
        FileGet(No, Hector.colors(1)) ' CType(Hector.colors(1), System.ValueType))
        FileGet(No, Hector.colors(2)) 'CType(Hector.colors(2), System.ValueType))
        FileGet(No, Hector.colors(3)) 'CType(Hector.colors(3), System.ValueType))
        FileGet(No, Hector.Half_Tone)
        FileGet(No, Choix)
        '     FileGet(No, Test)
        FileGet(No, Hector.colors_0_2)
        FileClose(No)
        __Son(True)

    End Sub
    Private Sub HelpPASMOToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles HelpPASMOToolStripMenuItem.Click
        System.Diagnostics.Process.Start("pasmodoc.html")
    End Sub
    Private Sub CompilationZ80ToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles CompilationZ80ToolStripMenuItem.Click
        ' Lancement de la compilation d'un fichier Z80
        ' permet 
        Dim Ligne_Cmde As String
        Dim Ligne_Param As String

        Dim a As New OpenFileDialog
        '   Dim iCounter As Integer

        __Son(False)

        ' ouvre une boite de dialogue
        a.Filter = "Fichier à COMPILER (*.Z80, *.ASM)|*.Z80;*.ASM"
        a.Title = "Selectionnez le fichier à compiler"

        a.ShowDialog()

        Dim Option_Pasmo As String
        Option_Pasmo = InputBox("Chaine d'option (par exemple --alocal pour variable locales) ", "Paramétres PASMO ", "--alocal")
        'On raz d'abord le fichier!
        If Not (File.Exists(a.FileName)) Then
            __Son(True)
            Exit Sub
        End If

        ' Fichier de sortie : à coté du source !
        Dim Fiche_sortie, Compte_Rendu As String
        Dim Retour As Integer

        Fiche_sortie = Microsoft.VisualBasic.Left(a.FileName, a.FileName.Length - 3) + "bin"

        Ligne_Cmde = CurDir$() & "\" & "pasmo"
        Ligne_Param = " " + Option_Pasmo + " """ + a.FileName & """ """ & Fiche_sortie & """"

        Dim myProcess As New Process()
        myProcess.StartInfo.FileName = Ligne_Cmde  'l'application
        myProcess.StartInfo.Arguments = Ligne_Param   'les paramètres passés à l'application
        myProcess.StartInfo.RedirectStandardOutput = True ' on redirige le flux de la console
        myProcess.StartInfo.RedirectStandardError = True
        myProcess.StartInfo.UseShellExecute = False ' pour que le flux arrive vers notre variable

        myProcess.StartInfo.CreateNoWindow = True

        myProcess.StartInfo.WindowStyle = ProcessWindowStyle.Hidden
        myProcess.Start() 'lance le process

        myProcess.WaitForExit() 'attend qu'il soit terminé avant d'aller plus loin

        Compte_Rendu = myProcess.StandardOutput.ReadToEnd ' on récupére le compte rendu
        Compte_Rendu = Compte_Rendu & myProcess.StandardError.ReadToEnd
        myProcess.Close() 'ferme le process

        ' un ch'ti message pour afficher le resultat de la compilation et pour savoir si on continu...

        If Compte_Rendu = "" Then
            Compte_Rendu = " OK !"
        Else
            If Compte_Rendu.Length > 300 Then
                Compte_Rendu = Microsoft.VisualBasic.Left(Compte_Rendu, 300)
            End If
        End If
        Retour = MsgBox("Résultat de la compilation :                                    . " & vbCrLf & Compte_Rendu & vbCrLf & " On charge le fichier produit dans Hector ?", MsgBoxStyle.YesNo, "Compte rendu de compilation, On continu ?")
        If Retour = vbYes Then
            Charge_bin(Fiche_sortie)
        End If
        __Son(True)
    End Sub
    Private Sub ChargementBinaireToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles ChargementBinaireToolStripMenuItem.Click
        Dim a As New OpenFileDialog

        __Son(False)
        ' ouvre une boite de dialogue
        a.Filter = "Fichier de binaire (*.BIN, *.Z80)|*.BIN;*.Z80"
        a.Title = "Selectionnez le fichier binaire"

        If a.ShowDialog() <> System.Windows.Forms.DialogResult.OK Then
            __Son(True)
            Exit Sub
        End If

        'On raz d'abord le fichier!
        If Not (File.Exists(a.FileName)) Then
            __Son(True)
            Exit Sub
        End If

        Charge_bin(a.FileName)
        __Son(True)
    End Sub

    Private Sub Charge_bin(ByRef Filename As String)
        'Chargement d'un binaire,
        ' Soit issu d'une compilation,
        ' Soit issu d'un fichier binaire existant ! 
        Dim B As New Adr_Lancement

        Dim iCounter As Integer
        Dim Adr_Chgmt As Integer
        Dim Adr_PC As Integer
        Dim Adr_SP As Integer
        Dim Lon As Integer
        Dim Buff(5) As Byte

        __Son(True)

        ' Un objet pour ouvrir le fichier
        Dim AA As New FileInfo(Filename)

        ' On dimensionne la variable avec la taille du fichier
        If Not (File.Exists(Filename)) Then
            MsgBox("Pas de fichier trouvé !!" & vbCrLf & "désolé...", MsgBoxStyle.Exclamation, "Pas possible, pas trouvé")
            __Son(True)
            Exit Sub
        End If
        Lon = CType(AA.Length, Integer)

        'Test si cohérent !
        If Lon > &HFFFF - &H4000 Then
            MsgBox("Taille de fichier trop importante ! sortie !", MsgBoxStyle.Exclamation, "Pas possible, trop gros")
            __Son(True)
            Exit Sub
        End If

        'Suffisament de place pour y mettre le fichier !
        ReDim Buff(Lon - 1)

        'Recup des données....
        Buff = My.Computer.FileSystem.ReadAllBytes(Filename)
        Dim Lancement As System.Windows.Forms.DialogResult

        ' Affichage de la page demandant l'adresse de rangement et du PC 
        Lancement = B.ShowDialog()

        'Conversion saisie HEXA => numérique : Adresse de chargement
        Adr_Chgmt = Conv_Strg_To_Int(B.TextAdr_Chgmt.Text)

        'Conversion saisie HEXA => numérique : Adresse PC
        Adr_PC = Conv_Strg_To_Int(B.TextAdr_PC.Text)

        'Conversion saisie HEXA => numérique : Adresse SP
        Adr_SP = Conv_Strg_To_Int(B.TextAdr_SP.Text)

        ' Controle de l'adresse
        If Adr_Chgmt < &H4000 Then
            MsgBox("Vous êtes dans la ROM d'Hector ! sortie !", MsgBoxStyle.Exclamation, "Pas possible, trop gros")
            __Son(True)
            Exit Sub
        End If

        'Mise en place dans la mémoire d'hector !
        For iCounter = 0 To Lon - 1
            Hector.mem_P0(Adr_Chgmt + iCounter) = Buff(iCounter)
        Next

        'Sortie si pas de lancement demandé (bouton annuler)
        If Lancement <> System.Windows.Forms.DialogResult.OK Then
            __Son(True)
            Exit Sub
        End If

        ' routage du Z80 d'Hector sur l'adresse mémoire demandée !

        ' On commence par annuler l'interruption qui était en cours !
        Proc.intIFF1 = Proc.intIFF2

        ' Registre SP facultatif
        If B.CheckSP.Checked Then
            Proc.regSP = Adr_SP
        End If

        'Et on lance le processeur à l'adresse saisie !
        Proc.regPC = Adr_PC
        __Son(True)

    End Sub

    Private Sub ToolStripMenuSaisie_Click(sender As Object, e As EventArgs) Handles ToolStripMenuSaisie.Click

        Dim a As New OpenFileDialog
        '   Dim iCounter As Integer
        __Son(False)

        ' ouvre une boite de dialogue
        a.Filter = "Fichier de saisie (*.BAS, *.TXT)|*.BAS;*.TXT"
        a.Title = "Selectionnez le fichier de saisie"

        a.ShowDialog()

        'On raz d'abord le fichier!
        If Not (File.Exists(a.FileName)) Then
            __Son(True)
            Exit Sub
        End If
        Dim AA As New FileInfo(a.FileName)

        ' On dimensionne la variable avec la taille du fichier

        Taille_Saisie = CType(AA.Length, Integer)
        ReDim Saisie(Taille_Saisie - 1)

        'Recup des données....
        Saisie = My.Computer.FileSystem.ReadAllBytes(a.FileName)

        'On met le pointeur à 0
        Pointeur_Saisie = 0

        'Et on autorise le déroulé de la saisie !
        Saisie_EC = True
        __Son(True)
    End Sub
    Private Sub CollerTexteAutomatiqueToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles ToolStripMenuCollerTexte.Click
        ' Recupération d'un texte du copier / coller !

        __Son(False)

        ' Objet pour récupérer le clipboard
        Dim iData As IDataObject

        ' On prend le clipboard
        iData = Clipboard.GetDataObject()

        'Vérification
        If Not (iData.GetDataPresent(DataFormats.Text)) Then ' Contrôle si c'est biendu texte !
            'Aie, pas de texte => on sort !
            MsgBox("Il me faut du texte pour coller quelque chose !", MsgBoxStyle.Information, "Attention !")
            __Son(True)
            Exit Sub
        End If

        'Tampon pour le texte 
        Dim Str_Collée As String
        Str_Collée = iData.GetData(DataFormats.Text).ToString

        Taille_Saisie = Str_Collée.Length
        ReDim Saisie(Taille_Saisie - 1)

        'Mise en place dans le tableau
        For i = 0 To Taille_Saisie - 1
            Saisie(i) = CType(Asc(Mid(Str_Collée, i + 1, 1)), Byte)
        Next

        Saisie_EC = True
        Pointeur_Saisie = 0
        Taille_Saisie = Taille_Saisie
        __Son(True)

    End Sub
    Private Sub ToolStripMenuResetHec_Click(sender As Object, e As EventArgs) Handles ToolStripMenuResetHec.Click
        ' Raz du PC
        Proc.regPC = 0
        ActivRomPage = 0
        ActivVideoPage = 0
    End Sub
    Private Sub ToolStripMenuResetD2_Click(sender As Object, e As EventArgs) Handles ToolStripMenuResetD2.Click
        Reset_Disc2()
    End Sub


    ' Menu DEBUG


    Private Sub StartDebugToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles StartDebugToolStripMenuItem.Click
        Debuggage = True
        ModeTrace = False
        'Mise à la taille agrandie !
        Me.Width = Grande_Fenetre_W
        Me.Height = Grande_Fenetre_H
        Mise_a_jour_controles()

    End Sub
    Private Sub TraceDesCommandesUPD765ToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles TraceDesCommandesUPD765ToolStripMenuItem.Click
        'Inverse l'état de demande de trace
        Demande_Trace_FD = Not (Demande_Trace_FD)
        'Et on met à jour le menu
        Mise_a_jour_controles()
    End Sub

    Private Sub ToolStripMenuMEA_Click(sender As Object, e As EventArgs) Handles ToolStripMenuMEA.Click
        Demande_Trace_MEA = Not (Demande_Trace_MEA)
        Mise_a_jour_controles()

    End Sub
    Private Sub DebugAvancéToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles DebugAvancéToolStripMenuItem.Click
        Dim F As New AdvDebug
        'On lance simplement la fenetre préparée !
        F.ShowDialog()
    End Sub
    Private Sub ContinuerToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ContinuerToolStripMenuItem.Click
        ModeTrace = False
        Debuggage = False
        Continuer()
    End Sub
    Private Sub SetBreakpointToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles SetBreakpointToolStripMenuItem.Click
        SetBreakpoint()
    End Sub

    Private Sub SetBreakpoint()
        '  Mie en place d'un point d'arrêt
        Dim Breakpoint As String

        If Adr_Break_Hector = &H30000 Then 'Breakpoint non encore initialisé ! 
            Adr_Break_Hector = 0
        End If
        Breakpoint = InputBox("Adresse de Breakpoint pour le " & ComboZ80.Text & " :" & vbCr & vbCr & "Saisie en Hexadécimal, svp." & vbCrLf & " ou -1 pour suppression breakpoint", "Adresse Breakpoint...", Caractere_hex4(Adr_Break_Hector), )
        If Breakpoint <> "-1" Then
            'Ce n'est pas une suppression de breakpoint !
            Breakpoint = UCase("0000" + Breakpoint)
            Adr_Break_Hector = Conv_Strg_To_Int(Breakpoint)
        Else
            'C'est une suppression de breakpoint !
            Adr_Break_Hector = &H30000
        End If
    End Sub

    Private Sub NouvelleAdresseDessassemblageToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles NouvelleAdresseDessassemblageToolStripMenuItem.Click
        SetDessass()
    End Sub
    Private Sub DéplierLaPageToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles DéplierLaPageToolStripMenuItem.Click

        If Me.Width < 1100 Then
            Me.Width = Grande_Fenetre_W
            Mise_a_jour_controles()
        Else
            Reduire_et_Continuer()
        End If

    End Sub



    'Lancement par clik sur Picture Box !
    Private Sub PictureBoxLancement_Click(sender As Object, e As EventArgs) Handles PictureBoxLancement.Click
        PictureBoxLancement.Enabled = False
        PictureBoxLancement.Visible = False

        'Et on lance Hector !
        Run_Hector()

    End Sub



    'Gestion des boutons (lors du débug)


    Private Sub ButtonBreakpoint_Click(sender As Object, e As EventArgs) Handles ButtonBreakpoint.Click
        SetBreakpoint()
    End Sub
    Private Sub ButtonDessass_Click(sender As Object, e As EventArgs) Handles ButtonDessass.Click
        SetDessass()
    End Sub

    Private Sub SetDessass()
        Dim Adr, Adr_PC As Integer
        Dim Saisie As String
        Saisie = InputBox("Adresse pour le Dessassemblage du " & ComboZ80.Text & " :" & vbCrLf & vbCrLf & "  Saisie en Hexadécimal, svp.", "Adresse de dessassemblage...", Caractere_hex4(Adr_Break_Hector), )
        If Saisie <> "-1" Then
            Saisie = UCase("0000" + Saisie)
            Adr = Conv_Strg_To_Int(Saisie)

            'Sauvegarde de l'adresse courante du registre PC
            If ComboZ80.Text = "Z80 Hector" Then
                Adr_PC = Proc.regPC
                Proc.regPC = Adr
            Else
                Adr_PC = Proc_Disc2.regPC
                Proc_Disc2.regPC = Adr
            End If

            'Mise en place de l'affichage demandé
            Affichage_Debug(False)
            'Remise en place de la valeur du registre PC
            If ComboZ80.Text = "Z80 Hector" Then
                Proc.regPC = Adr_PC
            Else
                Proc_Disc2.regPC = Adr_PC
            End If
        Else
        End If
    End Sub

    Private Sub ButtonStep_Click(ByVal sender As Object, ByVal e As EventArgs) Handles ButtonStep.Click
        ' Step by step
        Dim Status_Debug_Avant As Boolean

        ' On arrête le son
        __Son(False)

        'On mémorise l'état du debug
        Status_Debug_Avant = Debuggage

        'Variable Debuggage toujours à true !
        Debuggage = True
        ModeTrace = False ' des fois que l'on veuille arreter la trace !
        ' update état des boutons
        Mise_a_jour_controles()

        ' Si on etait déja en debug c'est que l'on souhaite avancer d'un pas => RUN !
        If Status_Debug_Avant Then
            Run_Hector()
        End If
    End Sub

    Private Sub Continuer()
        ' Permet d'afficher correctement les controles
        Mise_a_jour_controles()
        'Et on relance la machine !
        Run_Hector()

    End Sub

    Private Sub ButtonContinu_Click(ByVal sender As Object, ByVal e As EventArgs) Handles ButtonContinu.Click
        Debuggage = Not (Debuggage) 'Inversion de la demande de debuggage
        ModeTrace = False

        If Not (Debuggage) Then
            'uniquement si on est pas en débug pour me pas avancer d'une instruction Z80
            Continuer()
        Else
            Mise_a_jour_controles()
        End If
    End Sub
    Private Sub ButtonTrace_Click(ByVal sender As Object, ByVal e As EventArgs) Handles ButtonTrace.Click
        __Son(False)
        ModeTrace = Not (ModeTrace)
        Debuggage = True ' on lance le débuggage si la trace est activée ...
        ' Permet d'afficher correctement les controles
        Mise_a_jour_controles()
        '       If Not (Debuggage) Then
        Continuer()
        ' End If
    End Sub
    Private Sub Reduire_et_Continuer()
        Dim Temp As Boolean

        'Remet la fenetre à sa taille normale et relance la machine si arrêtée !
        Temp = Debuggage
        ModeTrace = False
        Debuggage = False
        Me.Width = Petite_Fenetre_W

        If Temp = True Then
            'uniquement si la machine était à l'arrêt !
            Continuer()
        End If

    End Sub
    Private Sub ButtonReduit_Click(ByVal sender As Object, ByVal e As EventArgs) Handles ButtonReduit.Click
        Reduire_et_Continuer()
    End Sub
    Private Sub ButtonDump_Click(sender As Object, e As EventArgs) Handles ButtonDump.Click
        Dim Adr_Dump As String
        Adr_Dump = InputBox("Adresse de DUMP pour le " & ComboZ80.Text & " :" & vbCr & vbCr & "Saisie en Hexadécimal, svp." & vbCrLf & " (Mémoire dans la page courante)", "Adresse DUMP...", "0000", )
        'Ce n'est pas une suppression de breakpoint !
        Adr_Dump = UCase("0000" + Adr_Dump)
        ' Et on lance le dump
        AdresseBaseDump = Conv_Strg_To_Int(Adr_Dump)
        Dump()
        Affichage_Debug(False)

    End Sub
    Private Sub ButtonModifMem_Click(sender As Object, e As EventArgs) Handles ButtonModifMem.Click
        Modif_Mem(AdresseBaseDump)
    End Sub
    ' Gestion de la fenetre de DUMP
    Private Sub TraceK7_MouseDown(sender As Object, e As MouseEventArgs) Handles TraceK7.MouseDown
        Dim Ligne, Colonne As Integer
        Dim Adr_Modif As Integer


        'On sort immédiatement si Hector n'est pas à l'arrêt !
        'Sortie si pas en cours de dump !
        If Not (Debuggage) Or Microsoft.VisualBasic.Left(ComboTrace.Text, 12) <> "Dump Mémoire" Then Exit Sub



        ' Calcul des coordonnées du click en ligne / colonne 
        Colonne = CInt(((e.X)) / 5.8) ' 4,86
        Ligne = CInt((e.Y) / 11.8) '12,2

        If Colonne > 5 And Colonne < 31 Then
            'on est bien dans la zone d'édition HEXA
            Colonne = CInt((Colonne - 4) / 3)
            If Colonne > 8 Then Colonne = 8 ' Un de plus pour la 8eme colonne

            '  TraceK7.Text = TraceK7.Text & "Coordonnnée Ligne=" & Ligne & " Colonne=" & Colonne & vbCrLf

            ' Ici on a trouvé la ligne et colonne de l'adresse cliquée !
            Adr_Modif = AdresseBaseDump + (Ligne - 1) * 8 + (Colonne - 1)

            Modif_Mem(Adr_Modif)
        End If
    End Sub
    Private Sub TraceK7_MouseMove(sender As Object, e As MouseEventArgs) Handles TraceK7.MouseMove
        Dim Colonne As Integer

        'Sortie si pas en cours de dump !
        If ComboTrace.Text = "Dump Mémoire" Then

            ' si nous sommes dans la colonne des données HEXA d'un dump => + sinon souris normale
            Colonne = CInt(((e.X)) / 5.8)

            If Colonne > 5 And Colonne < 31 Then
                TraceK7.Cursor = System.Windows.Forms.Cursors.Cross
            Else
                TraceK7.Cursor = System.Windows.Forms.Cursors.Arrow
            End If

        Else
            TraceK7.Cursor = System.Windows.Forms.Cursors.Arrow
        End If

    End Sub

    Private Sub Dump()
        'creation du dump mémoire

        Dim I As Integer
        Dim Ligne As Integer
        Dim Dump_Hex, Dump_ASCII As String
        Dim Octet, Adr As Integer
        Dim IsHector, IsVideo As Boolean

        'on efface le buffer
        Strg_Dump = ""
        If ComboZ80.Text = "Z80 Hector" Then
            IsHector = True
        Else
            IsHector = False
        End If
        ' Memoire vidéo ?
        If ComboTrace.Text = "Dump Mémoire Vidéo" Then
            IsVideo = True
        Else
            IsVideo = False
        End If

        If False Then
            'pour debug du clic dans le dump !
            For Ligne = 1 To 20
                Octet = 1
                Strg_Dump = Strg_Dump & Microsoft.VisualBasic.Right("00" & Ligne.ToString, 2) & "xx-"
                For I = 0 To 7
                    Strg_Dump = Strg_Dump & Octet & Octet & " "
                    Octet = Octet + 1
                    If Octet = 10 Then Octet = 0
                Next
                Strg_Dump = Strg_Dump & " <-> ABCDEFGH" & vbCrLf
            Next

            Exit Sub
        End If
        For Ligne = 0 To 31 '26*2
            Dump_ASCII = ""
            Dump_Hex = ""

            ' Calcul de l'adresse
            Adr = Ligne * 8 + AdresseBaseDump
            If Adr > &HFFFF Then GoTo Fin

            Strg_Dump = Strg_Dump & Caractere_hex4(Adr) & "-"

            For I = 0 To 7
                Adr = Ligne * 8 + I + AdresseBaseDump
                If IsHector Then
                    'Dump sur la mémoire d'Hector !
                    If (Adr < &HC000) Or Not (IsVideo) Then
                        Octet = Hector.mem_P0(Adr)
                    Else
                        Octet = Hector.mem_H(Adr)
                    End If
                Else
                    'Dump sur la mémoire du disc 2 !
                    Octet = Disc2.MemR(Adr)
                End If
                Dump_Hex = Dump_Hex & " " & Caractere_hex(Octet)
                If Octet > 32 And Octet < 123 Then
                    Dump_ASCII = Dump_ASCII & Convert.ToChar(Octet)
                Else
                    Dump_ASCII = Dump_ASCII & "."
                End If
            Next
            Strg_Dump = Strg_Dump & Dump_Hex & " <-> " & Dump_ASCII & vbCrLf
        Next
fin:

    End Sub
    Private Sub Modif_Mem(ByRef Adr_Modif As Integer)
        Dim A As New Modif_Mem
        Dim Octet As Integer
        Dim Activ_Rom_Page_EnCours As Integer
        Dim Activ_Video_Page_EnCours As Integer
        Dim IsVideo As Boolean

        ' Memoire vidéo ?
        If ComboTrace.Text = "Dump Mémoire Vidéo" Then
            IsVideo = True
        Else
            IsVideo = False
        End If

        If ComboZ80.SelectedIndex = 0 Then
            'Dump sur la mémoire d'Hector !
            If (Adr_Modif < &HC000) Or Not (IsVideo) Then
                Octet = Hector.mem_P0(Adr_Modif)
            Else
                Octet = Hector.mem_H(Adr_Modif)
            End If
        Else
            Octet = Disc2.MemR(Adr_Modif)
            A.ComboBoxROM.Visible = False
            A.ComboBoxRAM.Visible = False
        End If

        'Mise en place des adresse courantes dans les différents
        ' champs de la boite de dialogue avantle lancement de celle-ci.
        A.TextBoxAdress.Text = Caractere_hex4(Adr_Modif)
        A.ComboBoxROM.SelectedIndex = ActivRomPage
        A.ComboBoxRAM.SelectedIndex = ActivVideoPage
        A.TextBoxValueH.Text = Caractere_hex(Octet)
        A.TextBoxValueD.Text = CStr(Octet)
        A.LabelNom.Text = ComboZ80.Text

        'Lancement boite de dialogue
        A.ShowDialog()

        ' Pas plus loin si annulation
        If Not (A.Validation_Status) Then Exit Sub
        ' Récupértion des info pour mise en place dans la Ram / Rom !

        'Sauvegarde du context de la machine en cours d'exécution
        Activ_Rom_Page_EnCours = ActivRomPage
        Activ_Video_Page_EnCours = ActivVideoPage

        'Récupération de la demande de modification
        ActivRomPage = A.ComboBoxROM.SelectedIndex
        ActivVideoPage = A.ComboBoxRAM.SelectedIndex

        Adr_Modif = Conv_Strg_To_Int(A.TextBoxAdress.ToString)

        'Mise en place valeur selon la machine en cours de debug sur l'écran
        Octet = CByte(CInt(A.TextBoxValueD.Text))
        If ComboZ80.SelectedIndex = 0 Then
            Hector.MemW(Adr_Modif, CByte(Octet))
        Else
            Disc2.MemW(Adr_Modif, CByte(Octet))
        End If

        'Remise en place du context !
        ActivRomPage = Activ_Rom_Page_EnCours
        ActivVideoPage = Activ_Video_Page_EnCours

        'Pour le prochain Dump 
        Adr_Modif = Adr_Modif And &HFFF0

        'Pour montrer la modif on réaffiche
        Affichage_Debug(False)

        'On affichae aussi l'écran (mise à jour si modif mémoire écran)
        If A.ComboBoxRAM.SelectedIndex = 1 And Adr_Modif >= &HC000 Then
            Hector.ScreenPaint()
        End If


    End Sub


    ' Changement des valeurs de registres dans le mode débug !


    Private Sub TextPC_Click(sender As Object, e As EventArgs) Handles TextPC.Click
        Dim A As New Modif_Reg

        A.LabelNomReg.Text = "PC"
        A.LabelValueReg.Text = TextPC.Text
        A.TextValReg.Text = A.LabelValueReg.Text
        A.LabelNom.Text = ComboZ80.Text

        'Affichage de la boite de dialogue !
        If A.ShowDialog <> vbOK Then
            'Annulation !
            Exit Sub
        End If

        'Mise en place nouvelle valeur !
        If ComboZ80.Text = "Z80 Hector" Then
            Proc.regPC = Conv_Strg_To_Int(A.TextValReg.Text)
        Else
            Proc_Disc2.regPC = Conv_Strg_To_Int(A.TextValReg.Text)
        End If

        ' affichage debug
        Affichage_Debug(True)

    End Sub
    Private Sub TextAF_Click(sender As Object, e As EventArgs) Handles TextAF.Click
        Dim A As New Modif_Reg

        A.LabelNomReg.Text = "A"
        A.LabelValueReg.Text = TextAF.Text
        A.TextValReg.Text = A.LabelValueReg.Text
        A.LabelNom.Text = ComboZ80.Text

        'Affichage de la boite de dialogue !
        If A.ShowDialog <> vbOK Then
            'Annulation !
            Exit Sub
        End If

        'Mise en place nouvelle valeur !
        If ComboZ80.Text = "Z80 Hector" Then
            Proc.regA = Conv_Strg_To_Int(A.TextValReg.Text)
        Else
            Proc_Disc2.regA = Conv_Strg_To_Int(A.TextValReg.Text)
        End If

        ' affichage debug
        Affichage_Debug(True)

    End Sub
    Private Sub TextAFp_Click(sender As Object, e As EventArgs) Handles TextAFp.Click
        Dim A As New Modif_Reg

        A.LabelNomReg.Text = "AF'"
        A.LabelValueReg.Text = TextAFp.Text
        A.TextValReg.Text = A.LabelValueReg.Text
        A.LabelNom.Text = ComboZ80.Text

        'Affichage de la boite de dialogue !
        If A.ShowDialog <> vbOK Then
            'Annulation !
            Exit Sub
        End If

        'Mise en place nouvelle valeur !
        If ComboZ80.Text = "Z80 Hector" Then
            Proc.regAF_ = Conv_Strg_To_Int(A.TextValReg.Text)
        Else
            Proc_Disc2.regAF_ = Conv_Strg_To_Int(A.TextValReg.Text)
        End If

        ' affichage debug
        Affichage_Debug(True)

    End Sub
    Private Sub TextBC_Click(sender As Object, e As EventArgs) Handles TextBC.Click
        Dim A As New Modif_Reg

        A.LabelNomReg.Text = "BC"
        A.LabelValueReg.Text = TextBC.Text
        A.TextValReg.Text = A.LabelValueReg.Text
        A.LabelNom.Text = ComboZ80.Text

        'Affichage de la boite de dialogue !
        If A.ShowDialog <> vbOK Then
            'Annulation !
            Exit Sub
        End If

        'Mise en place nouvelle valeur !
        If ComboZ80.Text = "Z80 Hector" Then
            Proc.regC = Conv_Strg_To_Int(A.TextValReg.Text) And 255
            Proc.regB = CInt((Conv_Strg_To_Int(A.TextValReg.Text) And &HFF00) / 256)

        Else
            Proc_Disc2.regC = Conv_Strg_To_Int(A.TextValReg.Text) And 255
            Proc_Disc2.regB = CInt((Conv_Strg_To_Int(A.TextValReg.Text) And &HFF00) / 256)
        End If

        ' affichage debug
        Affichage_Debug(True)

    End Sub
    Private Sub TextBCp_Click(sender As Object, e As EventArgs) Handles TextBCp.Click
        Dim A As New Modif_Reg

        A.LabelNomReg.Text = "BC'"
        A.LabelValueReg.Text = TextBCp.Text
        A.TextValReg.Text = A.LabelValueReg.Text
        A.LabelNom.Text = ComboZ80.Text

        'Affichage de la boite de dialogue !
        If A.ShowDialog <> vbOK Then
            'Annulation !
            Exit Sub
        End If

        'Mise en place nouvelle valeur !
        If ComboZ80.Text = "Z80 Hector" Then
            Proc.regBC_ = Conv_Strg_To_Int(A.TextValReg.Text)
        Else
            Proc_Disc2.regBC_ = Conv_Strg_To_Int(A.TextValReg.Text)
        End If

        ' affichage debug
        Affichage_Debug(True)

    End Sub
    Private Sub TextHL_Click(sender As Object, e As EventArgs) Handles TextHL.Click
        Dim A As New Modif_Reg

        A.LabelNomReg.Text = "HL"
        A.LabelValueReg.Text = TextHL.Text
        A.TextValReg.Text = A.LabelValueReg.Text
        A.LabelNom.Text = ComboZ80.Text

        'Affichage de la boite de dialogue !
        If A.ShowDialog <> vbOK Then
            'Annulation !
            Exit Sub
        End If

        'Mise en place nouvelle valeur !
        If ComboZ80.Text = "Z80 Hector" Then
            Proc.regHL = Conv_Strg_To_Int(A.TextValReg.Text)
        Else
            Proc_Disc2.regHL = Conv_Strg_To_Int(A.TextValReg.Text)
        End If

        ' affichage debug
        Affichage_Debug(True)

    End Sub
    Private Sub TextHLp_Click(sender As Object, e As EventArgs) Handles TextHLp.Click
        Dim A As New Modif_Reg

        A.LabelNomReg.Text = "HL'"
        A.LabelValueReg.Text = TextHLp.Text
        A.TextValReg.Text = A.LabelValueReg.Text
        A.LabelNom.Text = ComboZ80.Text

        'Affichage de la boite de dialogue !
        If A.ShowDialog <> vbOK Then
            'Annulation !
            Exit Sub
        End If

        'Mise en place nouvelle valeur !
        If ComboZ80.Text = "Z80 Hector" Then
            Proc.regHL_ = Conv_Strg_To_Int(A.TextValReg.Text)
        Else
            Proc_Disc2.regHL_ = Conv_Strg_To_Int(A.TextValReg.Text)
        End If

        ' affichage debug
        Affichage_Debug(True)

    End Sub
    Private Sub TextDE_Click(sender As Object, e As EventArgs) Handles TextDE.Click
        Dim A As New Modif_Reg

        A.LabelNomReg.Text = "DE"
        A.LabelValueReg.Text = TextDE.Text
        A.TextValReg.Text = A.LabelValueReg.Text
        A.LabelNom.Text = ComboZ80.Text

        'Affichage de la boite de dialogue !
        If A.ShowDialog <> vbOK Then
            'Annulation !
            Exit Sub
        End If

        'Mise en place nouvelle valeur !
        If ComboZ80.Text = "Z80 Hector" Then
            Proc.regDE = Conv_Strg_To_Int(A.TextValReg.Text)
        Else
            Proc_Disc2.regDE = Conv_Strg_To_Int(A.TextValReg.Text)
        End If

        ' affichage debug
        Affichage_Debug(True)

    End Sub
    Private Sub TextDEp_Click(sender As Object, e As EventArgs) Handles TextDEp.Click
        Dim A As New Modif_Reg

        A.LabelNomReg.Text = "DE'"
        A.LabelValueReg.Text = TextDEp.Text
        A.TextValReg.Text = A.LabelValueReg.Text
        A.LabelNom.Text = ComboZ80.Text

        'Affichage de la boite de dialogue !
        If A.ShowDialog <> vbOK Then
            'Annulation !
            Exit Sub
        End If

        'Mise en place nouvelle valeur !
        If ComboZ80.Text = "Z80 Hector" Then
            Proc.regDE_ = Conv_Strg_To_Int(A.TextValReg.Text)
        Else
            Proc_Disc2.regDE_ = Conv_Strg_To_Int(A.TextValReg.Text)
        End If

        ' affichage debug
        Affichage_Debug(True)
    End Sub
    Private Sub TextIX_Click(sender As Object, e As EventArgs) Handles TextIX.Click
        Dim A As New Modif_Reg

        A.LabelNomReg.Text = "IX"
        A.LabelValueReg.Text = TextIX.Text
        A.TextValReg.Text = A.LabelValueReg.Text
        A.LabelNom.Text = ComboZ80.Text

        'Affichage de la boite de dialogue !
        If A.ShowDialog <> vbOK Then
            'Annulation !
            Exit Sub
        End If

        'Mise en place nouvelle valeur !
        If ComboZ80.Text = "Z80 Hector" Then
            Proc.regIX = Conv_Strg_To_Int(A.TextValReg.Text)
        Else
            Proc_Disc2.regIX = Conv_Strg_To_Int(A.TextValReg.Text)
        End If

        ' affichage debug
        Affichage_Debug(True)

    End Sub
    Private Sub TextIY_Click(sender As Object, e As EventArgs) Handles TextIY.Click
        Dim A As New Modif_Reg

        A.LabelNomReg.Text = "IY"
        A.LabelValueReg.Text = TextIY.Text
        A.TextValReg.Text = A.LabelValueReg.Text
        A.LabelNom.Text = ComboZ80.Text

        'Affichage de la boite de dialogue !
        If A.ShowDialog <> vbOK Then
            'Annulation !
            Exit Sub
        End If

        'Mise en place nouvelle valeur !
        If ComboZ80.Text = "Z80 Hector" Then
            Proc.regIY = Conv_Strg_To_Int(A.TextValReg.Text)
        Else
            Proc_Disc2.regIY = Conv_Strg_To_Int(A.TextValReg.Text)
        End If

        ' affichage debug
        Affichage_Debug(True)
    End Sub
    Private Sub TextSP_Click(sender As Object, e As EventArgs) Handles TextSP.Click
        Dim A As New Modif_Reg

        A.LabelNomReg.Text = "SP"
        A.LabelValueReg.Text = TextSP.Text
        A.TextValReg.Text = A.LabelValueReg.Text
        A.LabelNom.Text = ComboZ80.Text

        'Affichage de la boite de dialogue !
        If A.ShowDialog <> vbOK Then
            'Annulation !
            Exit Sub
        End If

        'Mise en place nouvelle valeur !
        If ComboZ80.Text = "Z80 Hector" Then
            Proc.regSP = Conv_Strg_To_Int(A.TextValReg.Text)
        Else
            Proc_Disc2.regSP = Conv_Strg_To_Int(A.TextValReg.Text)
        End If

        ' affichage debug
        Affichage_Debug(True)
    End Sub


    ' Changement des bits du registre F dans le mode DEBUG


    Private Sub CheckC_Click(sender As Object, e As EventArgs) Handles CheckC.Click
        Dim State As String
        Dim Name As String

        Name = "CARRY"
        If CBool(CheckC.Checked) Then
            'Bit à false transformé en true par notre clic => demande à True !
            State = "True"
        Else
            State = "False"
        End If

        If MsgBox("Garder le changement du bit " & Name & " en " & State & " ? ", MsgBoxStyle.OkCancel, " Changer le bit " & Name & "  ?") = vbOK Then
            'Mise en place nouvelle valeur !
            If ComboZ80.Text = "Z80 Hector" Then
                Proc.fC = Not (Proc.fC)
            Else
                Proc_Disc2.fC = Not (Proc_Disc2.fC)
            End If
        End If
        'on met à jour l'affichage dans tous les cas !
        Affichage_Debug(True)
    End Sub
    Private Sub CheckH_Click(sender As Object, e As EventArgs) Handles CheckH.Click
        Dim State As String
        Dim Name As String

        Name = "HALF-CARRY"
        If CBool(CheckH.Checked) Then
            'Bit à false transformé en true par notre clic => demande à True !
            State = "True"
        Else
            State = "False"
        End If

        If MsgBox("Garder le changement du bit " & Name & " en " & State & " ? ", MsgBoxStyle.OkCancel, " Changer le bit " & Name & "  ?") = vbOK Then
            'Mise en place nouvelle valeur !
            If ComboZ80.Text = "Z80 Hector" Then
                Proc.fH = Not (Proc.fH)
            Else
                Proc_Disc2.fH = Not (Proc_Disc2.fH)
            End If
        End If
        'on met à jour l'affichage dans tous les cas !
        Affichage_Debug(True)

    End Sub
    Private Sub CheckZ_Click(sender As Object, e As EventArgs) Handles CheckZ.Click
        Dim State As String
        Dim Name As String

        Name = "ZERO"
        If CBool(CheckZ.Checked) Then
            'Bit à false transformé en true par notre clic => demande à True !
            State = "True"
        Else
            State = "False"
        End If

        If MsgBox("Garder le changement du bit " & Name & " en " & State & " ? ", MsgBoxStyle.OkCancel, " Changer le bit " & Name & "  ?") = vbOK Then
            'Mise en place nouvelle valeur !
            If ComboZ80.Text = "Z80 Hector" Then
                Proc.fZ = Not (Proc.fZ)
            Else
                Proc_Disc2.fZ = Not (Proc_Disc2.fZ)
            End If
        End If
        'on met à jour l'affichage dans tous les cas !
        Affichage_Debug(True)

    End Sub
    Private Sub CheckS_Click(sender As Object, e As EventArgs) Handles CheckS.Click
        Dim State As String
        Dim Name As String

        Name = "Signe"
        If CBool(CheckS.Checked) Then
            'Bit à false transformé en true par notre clic => demande à True !
            State = "True"
        Else
            State = "False"
        End If

        If MsgBox("Garder le changement du bit " & Name & " en " & State & " ? ", MsgBoxStyle.OkCancel, " Changer le bit " & Name & "  ?") = vbOK Then
            'Mise en place nouvelle valeur !
            If ComboZ80.Text = "Z80 Hector" Then
                Proc.fS = Not (Proc.fS)
            Else
                Proc_Disc2.fS = Not (Proc_Disc2.fS)
            End If
        End If
        'on met à jour l'affichage dans tous les cas !
        Affichage_Debug(True)

    End Sub
    Private Sub CheckP_Click(sender As Object, e As EventArgs) Handles CheckP.Click
        Dim State As String
        Dim Name As String

        Name = "PARITY / OVERFLOW"
        If CBool(CheckP.Checked) Then
            'Bit à false transformé en true par notre clic => demande à True !
            State = "True"
        Else
            State = "False"
        End If

        If MsgBox("Garder le changement du bit " & Name & " en " & State & " ? ", MsgBoxStyle.OkCancel, " Changer le bit " & Name & "  ?") = vbOK Then
            'Mise en place nouvelle valeur !
            If ComboZ80.Text = "Z80 Hector" Then
                Proc.fPV = Not (Proc.fPV)
            Else
                Proc_Disc2.fPV = Not (Proc_Disc2.fPV)
            End If
        End If
        'on met à jour l'affichage dans tous les cas !
        Affichage_Debug(True)
    End Sub
    Private Sub CheckN_Click(sender As Object, e As EventArgs) Handles CheckN.Click
        Dim State As String
        Dim Name As String

        Name = "NEGATIVE"
        If CBool(CheckN.Checked) Then
            'Bit à false transformé en true par notre clic => demande à True !
            State = "True"
        Else
            State = "False"
        End If

        If MsgBox("Garder le changement du bit " & Name & " en " & State & " ? ", MsgBoxStyle.OkCancel, " Changer le bit " & Name & "  ?") = vbOK Then
            'Mise en place nouvelle valeur !
            If ComboZ80.Text = "Z80 Hector" Then
                Proc.fN = Not (Proc.fN)
            Else
                Proc_Disc2.fN = Not (Proc_Disc2.fN)
            End If
        End If
        'on met à jour l'affichage dans tous les cas !
        Affichage_Debug(True)
    End Sub

    ' Gestion du Combobox dans le mode DEBUG
    Private Sub ComboZ80_SelectedIndexChanged(sender As Object, e As EventArgs) Handles ComboZ80.SelectedIndexChanged, ComboTrace.SelectedIndexChanged
        TraceK7.Text = ""
        Affichage_Debug(True)
    End Sub

    ' Radio bouton de choix de machine au départ
    Private Sub RadioButtonHRX_CheckedChanged(ByVal sender As Object, ByVal e As EventArgs) Handles RadioButtonHRX.CheckedChanged
        If RadioButtonHRX.Checked Then
            Choix = HRX
        End If
    End Sub
    Private Sub RadioButtonHRP_CheckedChanged(ByVal sender As Object, ByVal e As EventArgs) Handles RadioButtonHRP.CheckedChanged
        If RadioButtonHRP.Checked Then
            Choix = HRP
        End If
    End Sub
    Private Sub RadioButtonMX40_CheckedChanged(ByVal sender As Object, ByVal e As EventArgs) Handles RadioButtonMX40.CheckedChanged
        If RadioButtonMX40.Checked Then
            Choix = MX40
        End If
    End Sub
    Private Sub RadioButtonMX80_CheckedChanged(ByVal sender As Object, ByVal e As EventArgs) Handles RadioButtonMX80.CheckedChanged
        If RadioButtonMX80.Checked Then
            Choix = MX80
        End If
    End Sub
    Private Sub RadioButtonMD_CheckedChanged(sender As Object, e As EventArgs) Handles RadioButtonMD.CheckedChanged
        Choix = MD
    End Sub


    Private Sub ToolStripMenuItem7_Click(sender As Object, e As EventArgs) Handles ToolStripMenuItem7.Click
        Dim F As New System.Windows.Forms.FolderBrowserDialog
        __Son(False)
        If F.ShowDialog() = System.Windows.Forms.DialogResult.OK Then
            Arduino.Directory = F.SelectedPath
        End If
        ToolStripStatus_A.Text = "SD :" & Arduino.Directory
        ToolStripStatus_B.Text = ""

        __Son(True)

    End Sub

    Private Sub RadioButtonArd_CheckedChanged(sender As Object, e As EventArgs) Handles RadioButtonArd.CheckedChanged
        If RadioButtonArd.Checked Then
            Choix = ARD
        End If

    End Sub

    ' Menu INFO
    Private Sub InfoToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles InfoToolStripMenuItem.Click
        Dim F As New AboutBox
        F.Show()
    End Sub

    ' Lancement des utilitaires
    Private Sub ConvertisseurAudioVidéoToolStripMenuItem1_Click(sender As Object, e As EventArgs) Handles ConvertisseurAudioVidéoMenu.Click
        Dim B As New Convertisseur
        __Son(False)
        ' Ouverture de la boite de dialogue pour le convertisseur
        B.ShowDialog()
        __Son(True)

    End Sub
    Private Sub UtilitaireHMD312ToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles UtilitaireHMD312ToolStripMenuItem.Click
        Dim B As New hmd_Main

        __Son(False)

        ' Ouverture fenetre de l'utilitaire pour les disquette 3 1/2 !
        B.ShowDialog()

        __Son(True)
    End Sub
    Private Sub ToolStripMenuItem8_Click(sender As Object, e As EventArgs) Handles ToolStripMenuItem8.Click
        Dim B As New Transfert

        __Son(False)

        ' Ouverture fenetre de l'utilitaire pour K7 !
        B.ShowDialog()

        __Son(True)

    End Sub

    'Filtrage
    Private Sub ParamétrageFiltreSonToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles ParamétrageFiltreSonToolStripMenuItem.Click
        Dim f As New Filtre

        'Mets en pause le son
        '     __Son(False)

        '        f.ShowDialog(Me)
        f.Show(Me)
        ' Mise à jour de la somme des coef 
        Filtre_KhMoyen = 0
        For i = 0 To Filtre_Prof
            Filtre_KhMoyen += h(i)
        Next

        'sort de la pause le son
        ' __Son(True)

    End Sub

    'Procédure pour suspendre / reprendre le son
    Private Sub __Son(ByVal Start As Boolean)

        If Old_Status_Play <> Start Then
            ' Seulement sur changement d'état de play/stop
            If Not IsNothing(_dev) Then
                ' et si le son est défini
                If Start Then
                    ' Play !!
                    _secondaryBuffer.Play(0, PlayFlags.Looping) 'on le joue à l'infini !
                Else
                    'Stop !!
                    _secondaryBuffer.Stop()
                End If
            End If
        End If
        Old_Status_Play = Start
    End Sub

    'Effacement du textbox de debuggage
    Private Sub ButtonClear_Click(sender As Object, e As EventArgs) Handles ButtonClear.Click
        'On efface tous les champs de suivi !
        Strg_ARD = ""
        Strg_FdC1793 = ""
        Strg_FdC765 = ""
        Strg_MEA = ""
        Strg_SN = ""
        'Et on efface l'afficheur
        TraceK7.Text = ""
    End Sub

    ' Debug du sn76477
    Private Sub CheckAU8_Click(sender As Object, e As EventArgs) Handles CheckAU8.Click
        m_AU(8) = Not (m_AU(8))
    End Sub
    Private Sub CheckAU0_Click(sender As Object, e As EventArgs) Handles CheckAU0.Click
        m_AU(0) = Not (m_AU(0))
    End Sub
    Private Sub CheckAU1_Click(sender As Object, e As EventArgs) Handles CheckAU1.Click
        m_AU(1) = Not (m_AU(1))
    End Sub
    Private Sub CheckAU9_Click(sender As Object, e As EventArgs) Handles CheckAU9.Click
        m_AU(9) = Not (m_AU(9))
    End Sub
    Private Sub CheckAU2_Click(sender As Object, e As EventArgs) Handles CheckAU2.Click
        m_AU(2) = Not (m_AU(2))
    End Sub
    Private Sub CheckAU10_Click(sender As Object, e As EventArgs) Handles CheckAU10.Click
        m_AU(10) = Not (m_AU(10))
    End Sub
    Private Sub CheckAU3_Click(sender As Object, e As EventArgs) Handles CheckAU3.Click
        m_AU(3) = Not (m_AU(3))
    End Sub
    Private Sub CheckAU11_Click(sender As Object, e As EventArgs) Handles CheckAU11.Click
        m_AU(11) = Not (m_AU(11))
    End Sub
    Private Sub CheckAU4_Click(sender As Object, e As EventArgs) Handles CheckAU4.Click
        m_AU(4) = Not (m_AU(4))
    End Sub
    Private Sub CheckAU12_Click(sender As Object, e As EventArgs) Handles CheckAU12.Click
        m_AU(12) = Not (m_AU(12))
    End Sub
    Private Sub CheckAU5_Click(sender As Object, e As EventArgs) Handles CheckAU5.Click
        m_AU(5) = Not (m_AU(5))
    End Sub
    Private Sub CheckAU13_Click(sender As Object, e As EventArgs) Handles CheckAU13.Click
        m_AU(13) = Not (m_AU(13))
    End Sub
    Private Sub CheckAU6_Click(sender As Object, e As EventArgs) Handles CheckAU6.Click
        m_AU(6) = Not (m_AU(6))
    End Sub
    Private Sub CheckAU14_Click(sender As Object, e As EventArgs) Handles CheckAU14.Click
        m_AU(14) = Not (m_AU(14))
    End Sub
    Private Sub CheckAU7_Click(sender As Object, e As EventArgs) Handles CheckAU7.Click
        m_AU(7) = Not (m_AU(7))
    End Sub
    Private Sub CheckAU15_Click(sender As Object, e As EventArgs) Handles CheckAU15.Click
        m_AU(15) = Not (m_AU(15))
    End Sub

    Private Sub ToolStripMenuHelpSN_Click(sender As Object, e As EventArgs) Handles ToolStripMenuHelpSN.Click
        HLP_SN()
    End Sub

    Private Sub HLP_SN()
        ToolStripMenuHelpSN.Checked = Not (ToolStripMenuHelpSN.Checked)
        Debug_SN = ToolStripMenuHelpSN.Checked
        If ToolStripMenuHelpSN.Checked Then
            Me.Height = Grande_Fenetre_H_ay
            Me.Width = Grande_Fenetre_W_ay
            DBG = DBG_OUT
            Affiche_Debug_SN()
        Else
            Me.Height = Grande_Fenetre_H
            Me.Width = Grande_Fenetre_W
        End If

    End Sub

    ' Debug du Mixer
    Private Sub CheckForceMixer_CheckedChanged(sender As Object, e As EventArgs) Handles CheckForceMixer.CheckedChanged
        ButtonA_Mixer.Visible = CheckForceMixer.Checked
        ButtonB_Mixer.Visible = CheckForceMixer.Checked
        ButtonC_Mixer.Visible = CheckForceMixer.Checked
    End Sub
    Private Sub ButtonA_Mixer_Click(sender As Object, e As EventArgs) Handles ButtonA_Mixer.Click
        Dim Tmp As Integer
        Tmp = Hector.m_ValMixer And &H1
        If Tmp = 0 Then
            Tmp = 1
        Else
            Tmp = 0
        End If
        Hector.m_ValMixer = (Hector.m_ValMixer And &HFE) + Tmp
    End Sub
    Private Sub ButtonB_Mixer_Click(sender As Object, e As EventArgs) Handles ButtonB_Mixer.Click
        Dim Tmp As Integer
        Tmp = Hector.m_ValMixer And &H2
        If Tmp = 0 Then
            Tmp = 2
        Else
            Tmp = 0
        End If
        Hector.m_ValMixer = (Hector.m_ValMixer And &HFD) + Tmp
    End Sub
    Private Sub ButtonC_Mixer_Click(sender As Object, e As EventArgs) Handles ButtonC_Mixer.Click
        Dim Tmp As Integer
        Tmp = Hector.m_ValMixer And &H4
        If Tmp = 0 Then
            Tmp = 4
        Else
            Tmp = 0
        End If
        Hector.m_ValMixer = (Hector.m_ValMixer And &HFB) + Tmp

    End Sub

    'Status du Débugge du SN76477
    Private Sub Affiche_Debug_SN()
        'Affichage de l'état du débuggage SN76477

        VCOToolStripMenuItem.Checked = (SN76477.DBG And SN76477.DBG_VCO) <> 0
        SLFToolStripMenuItem.Checked = (SN76477.DBG And SN76477.DBG_SLF) <> 0
        OneShotToolStripMenuItem.Checked = (SN76477.DBG And SN76477.DBG_ONES) <> 0
        NoiseToolStripMenuItem.Checked = (SN76477.DBG And SN76477.DBG_NOISE) <> 0
        OutputToolStripMenuItem.Checked = (SN76477.DBG And SN76477.DBG_OUT) <> 0
        AttackDecayToolStripMenuItem.Checked = (SN76477.DBG And SN76477.DBG_A_D) <> 0
        EnvellopToolStripMenuItem.Checked = (SN76477.DBG And SN76477.DBG_ENV) <> 0
        MixerToolStripMenuItem.Checked = (SN76477.DBG And SN76477.DBG_MIX) <> 0

        ' Menu général des traces SN
        TraceToolStripMenuSN.Checked = SN76477.DBG <> SN76477.DBG_NONE

        Mise_a_jour_controles()

    End Sub

    Private Sub TousToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles TousToolStripMenuItem.Click
        SN76477.DBG = SN76477.DBG_ALL
        Affiche_Debug_SN()
    End Sub
    Private Sub RienToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles RienToolStripMenuItem.Click
        SN76477.DBG = SN76477.DBG_NONE
        Affiche_Debug_SN()
    End Sub

    Private Sub VCOToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles VCOToolStripMenuItem.Click
        'on inverse la selection demandée
        VCOToolStripMenuItem.Checked = Not (VCOToolStripMenuItem.Checked)
        'Masquage du flag
        SN76477.DBG = SN76477.DBG And Not (SN76477.DBG_VCO)
        'et on le set si necessaire
        If VCOToolStripMenuItem.Checked Then
            SN76477.DBG = SN76477.DBG + SN76477.DBG_VCO
        End If
        'on affiche le tout
        Affiche_Debug_SN()
    End Sub
    Private Sub EnvellopToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles EnvellopToolStripMenuItem.Click
        'on inverse la selection demandée
        EnvellopToolStripMenuItem.Checked = Not (EnvellopToolStripMenuItem.Checked)
        'Masquage du flag
        SN76477.DBG = SN76477.DBG And Not (SN76477.DBG_ENV)
        'et on le set si necessaire
        If EnvellopToolStripMenuItem.Checked Then
            SN76477.DBG = SN76477.DBG + SN76477.DBG_ENV
        End If
        'on affiche le tout
        Affiche_Debug_SN()
    End Sub
    Private Sub SLFToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles SLFToolStripMenuItem.Click
        'on inverse la selection demandée
        SLFToolStripMenuItem.Checked = Not (SLFToolStripMenuItem.Checked)
        'Masquage du flag
        SN76477.DBG = SN76477.DBG And Not (SN76477.DBG_SLF)
        'et on le set si necessaire
        If SLFToolStripMenuItem.Checked Then
            SN76477.DBG = SN76477.DBG + SN76477.DBG_SLF
        End If
        'on affiche le tout
        Affiche_Debug_SN()
    End Sub
    Private Sub NoiseToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles NoiseToolStripMenuItem.Click
        'on inverse la selection demandée
        NoiseToolStripMenuItem.Checked = Not (NoiseToolStripMenuItem.Checked)
        'Masquage du flag
        SN76477.DBG = SN76477.DBG And Not (SN76477.DBG_NOISE)
        'et on le set si necessaire
        If NoiseToolStripMenuItem.Checked Then
            SN76477.DBG = SN76477.DBG + SN76477.DBG_NOISE
        End If
        'on affiche le tout
        Affiche_Debug_SN()
    End Sub
    Private Sub OneShotToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles OneShotToolStripMenuItem.Click
        'on inverse la selection demandée
        OneShotToolStripMenuItem.Checked = Not (OneShotToolStripMenuItem.Checked)
        'Masquage du flag
        SN76477.DBG = SN76477.DBG And Not (SN76477.DBG_ONES)
        'et on le set si necessaire
        If OneShotToolStripMenuItem.Checked Then
            SN76477.DBG = SN76477.DBG + SN76477.DBG_ONES
        End If
        'on affiche le tout
        Affiche_Debug_SN()
    End Sub
    Private Sub OutputToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles OutputToolStripMenuItem.Click
        'on inverse la selection demandée
        OutputToolStripMenuItem.Checked = Not (OutputToolStripMenuItem.Checked)
        'Masquage du flag
        SN76477.DBG = SN76477.DBG And Not (SN76477.DBG_OUT)
        'et on le set si necessaire
        If OutputToolStripMenuItem.Checked Then
            SN76477.DBG = SN76477.DBG + SN76477.DBG_OUT
        End If
        'on affiche le tout
        Affiche_Debug_SN()
    End Sub
    Private Sub AttackDecayToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles AttackDecayToolStripMenuItem.Click
        'on inverse la selection demandée
        AttackDecayToolStripMenuItem.Checked = Not (AttackDecayToolStripMenuItem.Checked)
        'Masquage du flag
        SN76477.DBG = SN76477.DBG And Not (SN76477.DBG_A_D)
        'et on le set si necessaire
        If AttackDecayToolStripMenuItem.Checked Then
            SN76477.DBG = SN76477.DBG + SN76477.DBG_A_D
        End If
        'on affiche le tout
        Affiche_Debug_SN()
    End Sub
    Private Sub MixerToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles MixerToolStripMenuItem.Click
        'on inverse la selection demandée
        MixerToolStripMenuItem.Checked = Not (MixerToolStripMenuItem.Checked)
        'Masquage du flag
        SN76477.DBG = SN76477.DBG And Not (SN76477.DBG_MIX)
        'et on le set si necessaire
        If MixerToolStripMenuItem.Checked Then
            SN76477.DBG = SN76477.DBG + SN76477.DBG_MIX
        End If
        'on affiche le tout
        Affiche_Debug_SN()
    End Sub

    Private Sub ButtonP100_Click(sender As Object, e As EventArgs) Handles ButtonP100.Click
        ' Et on lance le dump
        AdresseBaseDump += &H100
        If AdresseBaseDump > &HFF00 Then
            AdresseBaseDump = &HFF00
        End If

        Dump()
        Affichage_Debug(False)

    End Sub

    Private Sub ButtonM100_Click(sender As Object, e As EventArgs) Handles ButtonM100.Click
        ' Et on lance le dump
        AdresseBaseDump -= &H100
        If AdresseBaseDump < &H0 Then
            AdresseBaseDump = &H0
        End If

        Dump()
        Affichage_Debug(False)

    End Sub

    ' Gestion de la vitesse d'exécution du Z80 d'Hector
    Private Sub Uncheck_Speed()
        ToolStripMenuItem_1.Checked = False
        ToolStripMenuItem_10.Checked = False
        ToolStripMenuItem_80.Checked = False
        ToolStripMenuItem_90.Checked = False
        ToolStripMenuItem_100.Checked = False
        ToolStripMenuItem_110.Checked = False
        ToolStripMenuItem_120.Checked = False
        ToolStripMenuItem_150.Checked = False
        ToolStripMenuItem_200.Checked = False
    End Sub
    Private Sub ToolStripMenuItem_100_Click(sender As Object, e As EventArgs) Handles ToolStripMenuItem_100.Click
        SpeedBR = 45000
        SpeedHR = 100000

        'Gestion de l'affichage
        Uncheck_Speed()
        ToolStripMenuItem_100.Checked = True
    End Sub
    Private Sub ToolStripMenuItem_90_Click(sender As Object, e As EventArgs) Handles ToolStripMenuItem_90.Click
        SpeedBR = 45000 * 0.9
        SpeedHR = 100000 * 0.9

        'Gestion de l'affichage
        Uncheck_Speed()
        ToolStripMenuItem_90.Checked = True

    End Sub
    Private Sub ToolStripMenuItem_80_Click(sender As Object, e As EventArgs) Handles ToolStripMenuItem_80.Click
        SpeedBR = 45000 * 0.8
        SpeedHR = 100000 * 0.8

        'Gestion de l'affichage
        Uncheck_Speed()
        ToolStripMenuItem_80.Checked = True

    End Sub
    Private Sub ToolStripMenuItem_10_Click(sender As Object, e As EventArgs) Handles ToolStripMenuItem_10.Click
        SpeedBR = 45000 * 0.1
        SpeedHR = 100000 * 0.1

        'Gestion de l'affichage
        Uncheck_Speed()
        ToolStripMenuItem_10.Checked = True

    End Sub
    Private Sub ToolStripMenuItem_1_Click(sender As Object, e As EventArgs) Handles ToolStripMenuItem_1.Click
        SpeedBR = 45000 * 0.01
        SpeedHR = 100000 * 0.01

        'Gestion de l'affichage
        Uncheck_Speed()
        ToolStripMenuItem_1.Checked = True

    End Sub
    Private Sub ToolStripMenuItem_110_Click(sender As Object, e As EventArgs) Handles ToolStripMenuItem_110.Click
        SpeedBR = 45000 * 1.1
        SpeedHR = 100000 * 1.1

        'Gestion de l'affichage
        Uncheck_Speed()
        ToolStripMenuItem_110.Checked = True

    End Sub
    Private Sub ToolStripMenuItem_120_Click(sender As Object, e As EventArgs) Handles ToolStripMenuItem_120.Click
        SpeedBR = 45000 * 1.2
        SpeedHR = 100000 * 1.2

        'Gestion de l'affichage
        Uncheck_Speed()
        ToolStripMenuItem_120.Checked = True

    End Sub
    Private Sub ToolStripMenuItem_150_Click(sender As Object, e As EventArgs) Handles ToolStripMenuItem_150.Click
        SpeedBR = 45000 * 1.5
        SpeedHR = 100000 * 1.5

        'Gestion de l'affichage
        Uncheck_Speed()
        ToolStripMenuItem_150.Checked = True

    End Sub
    Private Sub ToolStripMenuItem_200_Click(sender As Object, e As EventArgs) Handles ToolStripMenuItem_200.Click
        SpeedBR = 45000 * 2
        SpeedHR = 100000 * 2

        'Gestion de l'affichage
        Uncheck_Speed()
        ToolStripMenuItem_200.Checked = True

    End Sub

    Private Sub DebugAY8912ToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles DebugAY8912ToolStripMenuItem.Click
        DebugAY8912ToolStripMenuItem.Checked = Not (DebugAY8912ToolStripMenuItem.Checked)
        Debug_AY = DebugAY8912ToolStripMenuItem.Checked
        If DebugAY8912ToolStripMenuItem.Checked Then
            Me.Height = Grande_Fenetre_H_ay
            Me.Width = Grande_Fenetre_W_ay
            Affiche_Debug_AY()
        Else
            Me.Height = Grande_Fenetre_H
            Me.Width = Grande_Fenetre_W
        End If
    End Sub


    Public Sub Affiche_Debug_AY()
        Dim Taille As Integer
        Dim Strg As String

        'init string
        TB_AY_nfo.Text = ""

        For i = 0 To 14
            Strg = "R(" & Caractere_Dec(i) & ")=" & Caractere_hex(AYPSG.Regs(i)).ToString  'Caractere_hex(R(i)) & vbTab)"
            'Calcul de la tabulation
            Taille = 10 - Strg.Length
            'Mise en place
            TB_AY_nfo.AppendText(Strg + Space(Taille))

            'ajout retour à la ligne
            If i = 7 Then
                TB_AY_nfo.AppendText(vbCrLf)
            End If
        Next
        My.Application.DoEvents()

    End Sub

    Private Sub TB_AY_nfo_Click(sender As Object, e As EventArgs) Handles TB_AY_nfo.Click
        Dim ff As New Registre_AY

        ff.ShowDialog()

        Dim val As Integer
        Dim adr As Integer
        adr = Microsoft.VisualBasic.Val(ff.Tb_Num_reg.Text)
        val = Microsoft.VisualBasic.Val(ff.Tb_Val.Text)

        AYWriteReg(adr, val)
        'On affiche le tout !
        Affiche_Debug_AY()

    End Sub

    Private Sub ToolStripMenuBin2K7_Click(sender As Object, e As EventArgs) Handles ToolStripMenuBin2K7.Click
        Dim F As New Bin2K7
        __Son(False) '   _secondaryBuffer.Stop()

        F.Show()

        __Son(True) '   _secondaryBuffer.Start()
    End Sub

    Private Sub CopieÉcranHREnBinaireToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles CopieÉcranHREnBinaireToolStripMenuItem.Click
        'Copie d'écran pour générer des fichier BIN pour les cassettes !
        ' c'est plus sympa que des gribouillis

        'HR
        Dim Ecr((64 * 224) - 1) As Byte

        'On copie l'écran dans un buffer,
        For I = 0 To (64 * 224) - 1
            Ecr(I) = Hector.mem_H(&HC000 + I)
        Next

        ' On demande ou le ranger
        Dim F As New SaveFileDialog
        Dim Res As Microsoft.VisualBasic.MsgBoxResult

        F.Filter = "Fichier à sauvegarder (*.BIN)|*.BIN"
        F.Title = "Choisir un nom de fichier pour enregistrer le fichier binaire de l'écran HR"
        Res = F.ShowDialog()
        If (Res = vbCancel) Then
            Exit Sub
        End If

        If (File.Exists(F.FileName)) Then
            File.Delete(F.FileName)
        End If

        'Sauvegarde du fichier
        My.Computer.FileSystem.WriteAllBytes(F.FileName, Ecr, False)

    End Sub

    Private Sub CopieÉcranBREnBinaireToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles CopieÉcranBREnBinaireToolStripMenuItem.Click
        'Copie d'écran pour générer des fichier BIN pour les cassettes !
        ' c'est plus sympa que des gribouillis

        'BR
        Dim Ecr((32 * 77) - 1) As Byte

        'On copie l'écran dans un buffer,
        For I = 0 To (32 * 77) - 1
            Ecr(I) = Hector.mem_P0(&H4000 + I)
        Next

        ' On demande ou le ranger
        Dim F As New SaveFileDialog
        Dim Res As Microsoft.VisualBasic.MsgBoxResult

        F.Filter = "Fichier à sauvegarder (*.BIN)|*.BIN"
        F.Title = "Choisir un nom de fichier pour enregistrer le fichier binaire de l'écran BR"
        Res = F.ShowDialog()
        If (Res = vbCancel) Then
            Exit Sub
        End If

        If (File.Exists(F.FileName)) Then
            File.Delete(F.FileName)
        End If

        'Sauvegarde du fichier
        My.Computer.FileSystem.WriteAllBytes(F.FileName, Ecr, False)


    End Sub

    Private Sub SauvegardeZoneMémoireToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles SauvegardeZoneMémoireToolStripMenuItem.Click
        'Copie d'écran pour générer des fichier BIN pour les cassettes !
        ' c'est plus sympa que des gribouillis
        Dim A As New Plage_Adr

        A.ShowDialog()

        'Si annul => exit !
        If A.Valid = False Then
            Exit Sub
        End If

        If (A.Adr_Fin - A.Adr_chg) <= 0 Then
            MsgBox("Plage non cohérente => recommencez !", MsgBoxStyle.Critical + MsgBoxStyle.OkOnly, "Erreur de saisie")
        End If
        'Reservation place necessaire
        Dim Area(A.Adr_Fin - A.Adr_chg) As Byte

        'On copie l'écran dans un buffer,
        For I = A.Adr_chg To A.Adr_Fin
            If A.Flag_Video Then
                Area(I - A.Adr_chg) = Hector.mem_H(I)
            Else
                Area(I - A.Adr_chg) = Hector.mem_P0(I)
            End If
        Next

        ' On demande ou le ranger
        Dim F As New SaveFileDialog
        Dim Res As Microsoft.VisualBasic.MsgBoxResult

        F.Filter = "Fichier à sauvegarder (*.BIN)|*.BIN"
        F.Title = "Choisir un nom de fichier pour enregistrer le fichier binaire"
        Res = F.ShowDialog()
        If (Res = vbCancel) Then
            Exit Sub
        End If

        If (File.Exists(F.FileName)) Then
            File.Delete(F.FileName)
        End If

        'Sauvegarde du fichier
        My.Computer.FileSystem.WriteAllBytes(F.FileName, Area, False)


    End Sub

    Private Sub TailleAffichageÉcranToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles TailleAffichageÉcranToolStripMenuItem.Click
        ' On change la taille demandée !
        TailleAffichageÉcranToolStripMenuItem.Checked = Not (TailleAffichageÉcranToolStripMenuItem.Checked)
        Changement_Taille()
    End Sub

    Private Sub Changement_Taille()

        If TailleAffichageÉcranToolStripMenuItem.Checked Then
            ' Grande Taille
            Taille = 3

            'Déplacement panel son (en dessous)
            PanelSon.Left = 157
            PanelSon.Top = 704

            'Déplacement panel debug
            PanelDebug.Left = 738 + 10
            PanelDebug.Top = 11

            'Debug sn76477 741; 611
            GroupSN76477.Left = 750
            GroupSN76477.Top = 611

            'Taille de la fenetre
            Grande_Fenetre_W = 1550 ' 1280
            Grande_Fenetre_H = 835 ' 840
            Grande_Fenetre_W_ay = 1550 ' 1280
            Grande_Fenetre_H_ay = 835 ' 840
            Petite_Fenetre_W = 758 ' 527
            Petite_Fenetre_H = 818 ' 630

            If GroupChoix.Visible = True Then
                GroupChoix.Top = 702
                GroupChoix.Left = 17
            End If
            If Debuggage Then
                Me.Width = Grande_Fenetre_W
                Me.Height = Grande_Fenetre_H
            Else
                Me.Width = Petite_Fenetre_W
                Me.Height = Petite_Fenetre_H
            End If

            'Grande taille : 702; 658  new one 716; 671
            PictureBoxLancement.Width = 716
            PictureBoxLancement.Height = 671

        Else
            ' Petite Taille
            Taille = 2

            'Déplacement panel son (en dessous)
            PanelSon.Left = 55
            PanelSon.Top = 475

            'Déplacement panel debug
            PanelDebug.Left = 738 - 240 + 10
            PanelDebug.Top = 11

            'Debug sn76477
            GroupSN76477.Left = 4
            GroupSN76477.Top = 533 + 7

            'Taille de la fenetre
            Grande_Fenetre_W = 1267 ' 1280
            Grande_Fenetre_H = 570  ' 840
            Grande_Fenetre_W_ay = 1327  ' 1280
            Grande_Fenetre_H_ay = 748 + 10  ' 840
            Petite_Fenetre_W = 520  ' 527
            Petite_Fenetre_H = 570  ' 630

            If GroupChoix.Visible = True Then
                GroupChoix.Top = 475
                GroupChoix.Left = 15
            End If

            If Debuggage Then
                Me.Width = Grande_Fenetre_W
                Me.Height = Grande_Fenetre_H
            Else
                Me.Width = Petite_Fenetre_W
                Me.Height = Petite_Fenetre_H
            End If

            'Grande taille : 702; 658 new :716; 671
            PictureBoxLancement.Width = 476 '468
            PictureBoxLancement.Height = 446 ' 438

        End If

        'Mise en place taille de l'écran 
        hectorDisplay.Width = 240 * Taille
        hectorDisplay.Height = 225 * Taille

    End Sub

    Private Sub ToolStripMenuClavier_Click(sender As Object, e As EventArgs) Handles ToolStripMenuClavier.Click
        Dim A As New Keyboard
        __Son(False)
        ' Ouverture de la boite de dialogue pour le convertisseur
        A.ShowDialog()
        __Son(True)

    End Sub

    Private Sub HardResetToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles HardResetToolStripMenuItem.Click
        Hard_Reset()
        '        Z80_Lance_Hector = False
        Reset_Hector()
        Quitting = True
        PictureBoxLancement.Visible = True
        PictureBoxLancement.Enabled = True
        '    StartHectorToolStripMenuItem.Enabled = True
        PanelLancement.Visible = True
        GroupChoix.Visible = True
    End Sub

    Private Sub ToolStripMenuItemImprimante_Click(sender As Object, e As EventArgs) Handles ToolStripMenuItemImprimante.Click
        Dim b As New Imprimante
        __Son(False)

        b.ShowDialog()
        __Son(True)

    End Sub

    Private Sub AscenseurSurFrameToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles AscenseurSurFrameToolStripMenuItem.Click

        'changement de l'état des ascenseurs
        AscenseurSurFrameToolStripMenuItem.Checked = Not AscenseurSurFrameToolStripMenuItem.Checked
        ' Mise en place des ascenseurs (ou suppression...)
        Me.AutoScroll = AscenseurSurFrameToolStripMenuItem.Checked

        '  centrage sur le picture box
        Me.ScrollControlIntoView(hectorDisplay)
    End Sub

    Private Sub HelpToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles HelpToolStripMenuItem.Click
        Dim F As New DialogHelp

        F.ShowDialog()

    End Sub
End Class