﻿
'Copyright © 2016 Jean-Jacques STACINO
' author mail : jj.stac @ aliceadsl.fr


'This program is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    This program is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with this program.  If not, see <http://www.gnu.org/licenses/>.


' This file is part of VBHector.

'    VBHector is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    Foobar is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with VBHector.  If not, see <http://www.gnu.org/licenses/>.

' Several part such as modZ80, modAY8912 are from GPL project (VBSpec)
'   Tranlation from VB6 to VBNet and much more had been made.
'   Thanks' to them authors (Chris Cowley, Xavier) 
'   Note that the original files from Chris Cowley are joined to this project (Directory "Sources Licences" . 
' Emulation of the MEA8000 is from A.Mine, that I want to thank here for him's agreement.

Imports System.Windows.Forms

Public Class Bin2K7_Helper
    Public Adr_Ch As String
    Public Nb As String
    Public Oct As String


    Private Sub OK_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Me.DialogResult = System.Windows.Forms.DialogResult.OK
        Me.Close()
    End Sub

    Private Sub Cancel_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Cancel_Button.Click
        Me.DialogResult = System.Windows.Forms.DialogResult.Cancel
        Me.Close()
    End Sub

    Private Sub Set_Leave(ByVal Adr As String, ByVal Value As String, ByVal Lgt As String)
        Adr_Ch = Adr
        Oct = Value
        Nb = Lgt
        Me.DialogResult = System.Windows.Forms.DialogResult.OK
        Me.Close()

    End Sub

    Private Sub Button_HR_P_Click(sender As Object, e As EventArgs) Handles Button_HR_P.Click
        '0x808 => base page, HR
        Set_Leave("0808", "1", "1")
    
    End Sub

    Private Sub Button_HR_V_Click(sender As Object, e As EventArgs) Handles Button_HR_V.Click
        '  0x800 => video page, HR
        Set_Leave("0800", "1", "1")
    End Sub

    Private Sub Button_BR_P_Click(sender As Object, e As EventArgs) Handles Button_BR_P.Click
        '0x80c => base page, BR
        Set_Leave("080C", "1", "1")
    End Sub

    Private Sub Button_BR_V_Click(sender As Object, e As EventArgs) Handles Button_BR_V.Click
        ' 0x804 => video page, BR
        Set_Leave("0804", "1", "1")
    End Sub

    Private Sub Button_C0C2_Click(sender As Object, e As EventArgs) Handles Button_C0C2.Click
        Dim Val As Byte

        Val = (ComboBoxC0.SelectedIndex And &H7) + ((ComboBoxC2.SelectedIndex And &H7) << 3)
   
        Set_Leave("1000", Val.ToString, "1")

    End Sub

    Private Sub ButtonC1C3_Click(sender As Object, e As EventArgs) Handles ButtonC1C3.Click
        Dim Val As Byte

        Val = (ComboBoxC1.SelectedIndex And &H7) + ((ComboBoxC3.SelectedIndex And &H7) << 3)
        If CheckBoxHT.Checked Then
            Val += &H40
        End If
        Set_Leave("1800", Val.ToString, "1")

    End Sub

    Private Sub ButtonBandH_Click(sender As Object, e As EventArgs) Handles ButtonBandH.Click
        Set_Leave("C000", "11", "1900")
    End Sub

    Private Sub ButtonDecoB_Click(sender As Object, e As EventArgs) Handles ButtonDecoB.Click
        ' F800h - 100*64 (1900h) 

        Set_Leave("DF00", "22", "1900")

    End Sub

    Private Sub ButtonCls_Click(sender As Object, e As EventArgs) Handles ButtonCls.Click
        Set_Leave("C000", "0", "3800")
    End Sub
End Class
