﻿
'Copyright © 2016 Jean-Jacques STACINO
' author mail : jj.stac @ aliceadsl.fr


'This program is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    This program is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with this program.  If not, see <http://www.gnu.org/licenses/>.


' This file is part of VBHector.

'    VBHector is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    Foobar is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with VBHector.  If not, see <http://www.gnu.org/licenses/>.

' Several part such as modZ80, modAY8912 are from GPL project (VBSpec)
'   Tranlation from VB6 to VBNet and much more had been made.
'   Thanks' to them authors (Chris Cowley, Xavier) 
'   Note that the original files from Chris Cowley are joined to this project (Directory "Sources Licences" . 
' Emulation of the MEA8000 is from A.Mine, that I want to thank here for him's agreement.

Option Explicit On

Imports System.Drawing.Imaging
Imports System.Runtime.InteropServices
Imports System.IO

Imports Microsoft.VisualBasic


Public Class Convertisseur

    ' Réalisé en 2015 - 2016
    '
    'Pour le son
    Dim Name_Hec As String = ""

    'Pour les bit map
    Dim WidthBmp As Integer  'multiple de 4...
    Dim HeightBmp As Integer ' ..et en corelation
    Dim offset As Integer = WidthBmp Mod 4
    Dim stride As Integer = WidthBmp * 3 + offset
    Dim Taille As Long = stride * HeightBmp - 1
    Dim Pixel(Taille) As Byte
    Dim Grey(4) As Integer
    Dim Palette(3) As Coul ' Palette en cours 

    Dim Gamma As Integer
    Dim X_Old As Integer = 0
    Dim Y_Old As Integer = 0

    Const CH = "C:\Users\jj\Desktop\"
    Dim Chemin As String = CH '"C:\Users\jj\Desktop\ffmpeg\"
    Dim CheminFFMPEG As String = CH '"C:\Users\jj\Desktop\ffmpeg"
    Dim CheminListBMP As String = CH
    Dim CheminSon As String = CH '"C:\Users\jj\Desktop\VB\SoundHector\Echantillons\"
    Dim CheminDest As String = CH '"C:\Users\jj\Desktop\VB\VB_HectorSD_2.3\bin\Release\Video"

    'Recupération de la bande son !
    Dim FichierSon As IO.FileStream
    Dim OctetSon(1023) As Byte               ' pour le ... son 
    Dim IndexSon As Integer

    'Pour le buffer ecran
    '    Dim Buffer2(210000) As Byte ' Buffer pour prendre en charge l'ensemble des données d'un écran !
    Dim Buffer((64 * 255 * 4) + 1000) As Byte ' tableau de ce que l'on devra envoyer dans le fichier 

    Dim Index_Buff As Integer = 0

    Structure Coul
        Public R As Byte
        Public V As Byte
        Public B As Byte
        Public Shared Operator <>(ByVal h1 As Coul,
                         ByVal h2 As Coul) As Boolean
            Dim RET As Boolean
            RET = (h1.R <> h2.R) Or (h1.V <> h2.V) Or (h1.B <> h2.B)
            Return RET
        End Operator
        Public Shared Operator =(ByVal h1 As Coul,
                         ByVal h2 As Coul) As Boolean
            Dim RET As Boolean
            RET = Not ((h1.R <> h2.R) Or (h1.V <> h2.V) Or (h1.B <> h2.B))
            Return RET
        End Operator
    End Structure

    Public Function Niv(ByVal h1 As Coul,
                        ByVal h2 As Coul) As Byte
        Dim RET As Byte
        RET = If((h1.R = h2.R), 1, 0) + If((h1.V = h2.V), 1, 0) + If((h1.B = h2.B), 1, 0) ' sortie de 0 à 3 selon le niveau d'égalité !
        Return RET
    End Function

    Private Sub BPExit_Click(sender As Object, e As EventArgs) Handles BPExit.Click
        MAJ_Param()
        Me.Visible = False
    End Sub

    Private Function Pop_Son_Video() As Byte
        Dim Octet1, Octet2 As Byte

        ' Gestion du son, travail sur Buffer
        If FichierSon.CanRead And IndexSon > 1023 Then
            FichierSon.Read(OctetSon, 0, 1024)
        End If
        If IndexSon > 1023 Then ' des fois que l'on déborde de la taille du SND...
            IndexSon = 0
        End If

        Octet1 = OctetSon(IndexSon)     '  X7 
        IndexSon += 1

        'Par paquet de 2 ca marche forcément !
        Octet2 = OctetSon(IndexSon) / 2  ' X6
        IndexSon += 1

        Pop_Son_Video = Octet1 + Octet2

    End Function

    Private Sub Push_Buffer(ByRef Octet As Byte)
        Buffer(Index_Buff) = Octet
        Index_Buff += 1
    End Sub

    Private Sub Button1_Click(sender As Object, e As EventArgs) Handles Button1.Click

        ' BR si ...BR !
        Dim BR As Boolean = CheckBR.Checked

        Dim Position As Integer
        Dim Position_final As Integer

        Dim nom As String
        Dim ImgData As BitmapData
        Dim Imag As Bitmap
        ' Les Hauteur et largueur on déjà été calculées !
        Dim Old_Img(WidthBmp, HeightBmp) As Integer
        Dim Tmp_Img(WidthBmp, HeightBmp) As Integer
        Dim TBuffer As Integer  ' Taille du buffer !
        Dim Nombre As Integer
        Dim NB_modif As Integer
        Dim X, Y As Integer 'coordonnées de l'image 

        Dim Val(3) As Byte
        Dim Adr, Adr_Old, Offset_Hector As Integer
        Dim Premier As Boolean

        Dim Paire As Integer = 1

        Dim PixelC As Coul
        Dim PaletteOld(3) As Coul
        Dim Nb_Color As Integer

        'pour garantir le frame rate
        Dim NFrag As Integer
        Dim NRemp As Integer

        If Name_Hec = "" Then
            MsgBox("Chargez un fichier son d'abord !")
            Exit Sub
        End If

        Trace.Text = ""

        ' Fichier son !
        FichierSon = New IO.FileStream(Name_Hec, IO.FileMode.Open)
        FichierSon.Position = 0

        IndexSon = 0

        'On raz le label !
        Label10.Visible = False

        ' On recalcul l'ensemble des index pour aller chercher les pixels ! 
        offset = WidthBmp Mod 4
        stride = WidthBmp * 3 + offset
        Taille = stride * HeightBmp - 1
        ReDim Pixel(Taille)

        Position = NumericStart.Value
        If NumericNombre.Value <> 0 Then
            Position_final = Position + NumericNombre.Value
        Else
            Position_final = 0
        End If

        ' Création fichier pour Hectrduino 
        Dim FileHector As System.IO.FileStream

        'ouverture du fichier en remplacement
        FileHector = New System.IO.FileStream(CheminDest & "/" & TNomFile.Text & "." & TNomExt.Text, System.IO.FileMode.Create)

        ' On ajoute à l'entête le passage en BR si necessaire 
        If BR Then

            'passage en BR
            Adr = &H804

            'Mie en place dans la structure pour HectorDuino
            Val(0) = 0
            Val(1) = (Adr And &HFF00) >> 8
            Val(2) = (Adr And &HFF)
            'Valeur bidon pour écriture 
            Val(3) = 1

            ' écriture de la structure dans le FileHector
            Buffer(TBuffer) = Val(0)
            TBuffer += 1
            Buffer(TBuffer) = Val(1)
            TBuffer += 1
            Buffer(TBuffer) = Val(2)
            TBuffer += 1
            Buffer(TBuffer) = Val(3)
            TBuffer += 1

            ' Maintenant on peut envoyer la table des modif dans le fichier 
            FileHector.Write(Buffer, 0, TBuffer)

            'ON raz le buffer
            TBuffer = 0
        End If

        ' Mise en place data frame rate
        NFrag = NumericFrag.Value
        NRemp = NumericRemp.Value

        'Flag de détection de la 1ere image
        Premier = True

        For i = 0 To 3
            Palette(i).R = 0 ' mémorisation de l'ancienne palette 
            Palette(i).V = 0 ' mémorisation de l'ancienne palette 
            Palette(i).B = 0 ' mémorisation de l'ancienne palette 
        Next

        '***********************************
        ' Boucle pour l'ensemble des images
        '***********************************
        Do

            ' Position dans le dessin
            Position += 1

            'Nom du fichier 
            nom = "img" + Microsoft.VisualBasic.Right("00000" + Position.ToString, 5) + ".bmp"
            '            nom = """" + CheminListBMP + "\" + nom + """"
            nom = CheminListBMP + "\" + nom

            ' Charge la nouvelle image
            Imag = Image.FromFile(nom)


            ' Copy dans le Bitmap data
            ImgData = Imag.LockBits(New Rectangle(0, 0, WidthBmp, HeightBmp) _
                , System.Drawing.Imaging.ImageLockMode.ReadWrite, PixelFormat.Format24bppRgb)

            ' Maintenant on recupere les pixels dans des tableaux de byte !
            Marshal.Copy(ImgData.Scan0, Pixel, 0, Pixel.Length)

            'on relache la zone
            Imag.UnlockBits(ImgData)

            'L'affiche sur l'ecran
            PictureBox1.Image = Imag

            'Laisse respirer Windows, ce qui permet d'afficher tout
            System.Windows.Forms.Application.DoEvents()


            ' On saute tout si pas besoin de calculer la palette 
            If CheckNb.Checked Then GoTo No_Color

            Nb_Color = 0 ' Nombre de couleur trouvée sur l'image courante

            For i = 0 To 3
                PaletteOld(i).R = Palette(i).R  ' mémorisation de l'ancienne palette 
                PaletteOld(i).V = Palette(i).V  ' mémorisation de l'ancienne palette 
                PaletteOld(i).B = Palette(i).B  ' mémorisation de l'ancienne palette 
            Next

            ' Sur l'ensemble du bitmap  ******************** passe 0 recherche de la palette utilisée
            For Y = 0 To HeightBmp - 1
                For X = 0 To WidthBmp - 1

                    'Recupération de la couleur du pixel pointé
                    PixelC = ExtractColor(X, Y, Pixel)

                    Select Case Nb_Color
                        Case 0
                            ' Pas de couleur déjà en mémoie => on la prend !
                            Palette(0).R = PixelC.R
                            Palette(0).V = PixelC.V
                            Palette(0).B = PixelC.B
                            Nb_Color = 1
                            Exit Select
                        Case 1
                            If (Palette(0) <> PixelC) Then
                                ' Pas de couleur déjà en mémoie => on la prend !
                                Palette(1).R = PixelC.R
                                Palette(1).V = PixelC.V
                                Palette(1).B = PixelC.B
                                Nb_Color = 2
                                Exit Select
                            End If
                        Case 2
                            If ((Palette(0) <> PixelC) And
                                (Palette(1) <> PixelC)) Then
                                ' Pas de couleur déjà en mémoie => on la prend !
                                Palette(2).R = PixelC.R
                                Palette(2).V = PixelC.V
                                Palette(2).B = PixelC.B
                                Nb_Color = 3
                            End If
                            Exit Select
                        Case 3
                            If Palette(0) <> PixelC And Palette(1) <> PixelC And Palette(2) <> PixelC Then
                                ' Pas de couleur déjà en mémoie => on la prend !
                                Palette(3).R = PixelC.R
                                Palette(3).V = PixelC.V
                                Palette(3).B = PixelC.B
                                Nb_Color = 4
                                Exit Select
                            End If
                        Case Is >= 4
                            If Palette(0) <> PixelC And Palette(1) <> PixelC And Palette(2) <> PixelC And Palette(3) <> PixelC Then
                                ' Pas de couleur déjà en mémoie => on la prend !

                                Nb_Color += 1
                                Trace.AppendText("erreur de +4 couleurs !" + vbCr)
                                If MsgBoxResult.No = MsgBox("On continu ?", MsgBoxStyle.YesNo, "Erreur plus de 4 couleurs sur image !") Then
                                    'on ferme tout
                                    FichierSon.Close()
                                    FileHector.Close()
                                    Exit Sub
                                End If

                                Exit Select
                            End If
                            'c'est fini !
                            'Y = HeightBmp
                            'X = WidthBmp
                    End Select
                Next X
            Next Y

            'creation des affectations
            Dim Matrice(3, 3)
            ' On documente la matrice d'égalité
            For i = 0 To 3
                For j = 0 To 3
                    Matrice(i, j) = Niv(Palette(i), PaletteOld(j))
                Next
            Next

            ' Maintenant on cherche les couleurs 
            Dim Niveau As Integer

            ' prenons un exemple à 3 couleurs
            ' Cold0  = rouge
            ' Cold1  = noir
            ' Cold2  = jaune (Vert+Rouge)

            '********************
            ' cas 1 meme couleurs
            '********************
            '
            ' nombre = 3 
            ' C0 = noir                 => si noir  alos Hector aura la couleur 0
            ' C1 = rouge                => si rouge alos Hector aura la couleur 1
            ' C2 = jaune (Vert+Rouge)   => si jaune alos Hector aura la couleur 2

            ' matrice
            ' new,old
            '   0.0 = 2    composantes égales
            '   0.1 = 3
            '   0.2 = 1
            '   1.0 = 3
            '   1.1 = 2
            '   1.2 = 2
            '   2.0 = 2
            '   2.1 = 1
            '   2.2 = 3

            ' cela donne 
            'poids(0) = 1
            ' MAtrice = 3 => COld reste ! C0 = COLD1 => noir 
            'poids(1) = 0
            ' MAtrice = 3 => COld reste ! C1 = COLD0 => rouge
            'poids(2) = 2
            ' MAtrice = 3 => COld reste ! C2 = COLD2 => jaune

            'donc si je trouve un noir  (C0) je mettrais la couleur 0 
            'donc si je trouve un rouge (C1) je mettrais la couleur 1 
            'donc si je trouve un jaune (C2) je mettrais la couleur 2 

            '********************
            ' cas 2 : 1 couleur change
            '********************
            '
            ' Cold0  = rouge
            ' Cold1  = noir
            ' Cold2  = jaune (Vert+Rouge)

            ' nombre = 3 
            ' C0 = noir                 => si noir  alos Hector aura la couleur 0
            ' C1 = rouge                => si rouge alos Hector aura la couleur 1
            ' C2 = vert                 => si vert  alos Hector aura la couleur 2

            ' matrice
            ' new,old
            '   0.0 = 2    composantes égales
            '   0.1 = 3
            '   0.2 = 2
            '   1.0 = 3
            '   1.1 = 2
            '   1.2 = 2
            '   2.0 = 1
            '   2.1 = 2
            '   2.2 = 2

            ' cela donne 
            'poids(0) = 1
            ' MAtrice = 3 => COld reste ! C0 = COLD1 => noir 
            'poids(1) = 0
            ' MAtrice = 3 => COld reste ! C1 = COLD0 => rouge
            'poids(2) = 2 (car 0 et 1 dejà pris alors qu'il sont == dans la matrice avec des poids + fort (3!))
            ' comme le Matrice est <> de 3 on change la valeur de Cold: 
            ' Ici comme matrice <> 3 on remplace Cold:
            ' donc: COLD2 = C2 (poids= 2) = VERT ! 

            '********************
            ' cas 3 : 1 couleur change+change de place
            '********************
            '
            ' Cold0  = rouge
            ' Cold1  = noir
            ' Cold2  = jaune (Vert+Rouge)

            ' nombre = 3 
            ' C0 = vert                 => si noir  alos Hector aura la couleur 0
            ' C1 = rouge                => si rouge alos Hector aura la couleur 1
            ' C2 = noir                 => si vert  alos Hector aura la couleur 2

            ' matrice
            ' new,old
            '   0.0 = 1    composantes égales
            '   0.1 = 2
            '   0.2 = 2
            '   1.0 = 3
            '   1.1 = 2
            '   1.2 = 2
            '   2.0 = 2
            '   2.1 = 3
            '   2.2 = 1

            ' cela donne 
            ' poids(1) = 0
            ' C1 <= COLD0 => rouge 
            ' poids(2) = 1
            ' C2 <= COLD1 => noir

            'poids(0) = 2 ' Les 1 et 2 étaient possible (Mat=2) mais 1 était pris au tour 3 par 2.1=3 
            ' C0 reste => vert 
            ' de plus comme nombre <> 3 on setera la palette
            ' soit C0 avec la nouvelle couleur (le vert defini) = VERT 
            '      C1 avec la          couleur (celle de COLD0) = ROUGE
            '      C2 avec la          couleur (celle de COLD1) = NOIR
            ' 
            ' Et là j'ai foutu le bordel dans la pallete !!!!
            ' (à comparer avec celle d'origine :
            ' Cold0  = rouge
            ' Cold1  = noir
            ' Cold2  = jaune (Vert+Rouge)
            ' )

            ' En introduisant ue nouvelle pallette :
            ' Disons PaletteNew(3).
            '
            ' Alors 
            ' Si Mat = 3 pour une ligne
            '          On met => PaletteNew(i) = Palletteold(i)
            ' Si Mat <>3 
            '          On met => PaletteNew(i) = Pallette(j) (La même chose ?)

            ' On essaye de remprendre l'exemple
            '
            ' Cold0  = rouge
            ' Cold1  = noir
            ' Cold2  = jaune (Vert+Rouge)

            ' nombre = 3 
            ' C0 = vert                 => si noir  alos Hector aura la couleur 0
            ' C1 = rouge                => si rouge alos Hector aura la couleur 1
            ' C2 = noir                 => si vert  alos Hector aura la couleur 2

            ' matrice
            ' new,old
            '   0.0 = 1    composantes égales
            '   0.1 = 2
            '   0.2 = 2
            '   1.0 = 3
            '   1.1 = 2
            '   1.2 = 2
            '   2.0 = 2
            '   2.1 = 3
            '   2.2 = 1


            ' Passe =3
            ' PaletteNew(0)=Pallette(1) = rouge
            ' PaletteNew(1)=Pallette(2) = noir

            ' Passe =2  (1 et 2 sont pris)
            ' PaletteNew(2)=Pallette(0) = vert

            ' Oooohhhh la belle pallette remise à jour !

            ' for niv = 3 to 0 pour chaque niveau
            '    for i = 0 to 3  Pour chaque couleur de la palette d'Hector
            '       for j = 0 to 3 On cherche la plus proche dans la nouvelle palette
            '
            '
            '      Si niv=mat(j,i) and pas dejà pris !
            '             PaletteNew(i)=Palette(j)
            '             Mat(J,I) = 255  pour tracer la prise ! 
            '             if niv = 3 Nombre +=1 ' changement de palette si à la fin <>4

            ' comme le poids est <> de 3 on laisse la valeur 
            ' non : C2 = COLD2 => jaune
            ' mais: C2 = VERT ! 

            ' et on mets en place la palette de "Cold" en place.

            'A ce moment là on index la couleur d'hector selon
            ' l'index de la palette (plus de poids)


            Nombre = 0
            For Niveau = 3 To 0 Step -1 ' 
                For i = 0 To 3 ' Pour chaque couleur de la palette d'Hector
                    'On sauvegarde le poids
                    For j = 0 To 3 ' pour chaque ancienne couleur
                        If (Matrice(j, i) = Niveau) Then
                            Matrice(j, 0) = 255
                            Matrice(j, 1) = 255
                            Matrice(j, 2) = 255
                            Matrice(j, 3) = 255
                            'et on met le nouveau poids
                            PaletteOld(i).R = Palette(j).R
                            PaletteOld(i).V = Palette(j).V
                            PaletteOld(i).B = Palette(j).B

                            If Niveau = 3 Then
                                ' on compte le nombre de non changement de palette !
                                Nombre += 1
                            End If
                        End If
                    Next
                Next
            Next

            'Pas de changement de palette ? => on remet les couleurs à leurs place.
            If Nombre = 4 Then
                For i = 0 To 3
                    Palette(i).R = PaletteOld(i).R
                    Palette(i).V = PaletteOld(i).V
                    Palette(i).B = PaletteOld(i).B
                Next
            Else

                ' Mise en place de la palette si nécéssaire
                ' les couleurs ont changées
                ' il faut les mettre en place

                ' couleur d'Hector : 
                ' 0 : Noir
                ' 1 : Rouge
                ' 2 : Vert
                ' 3 : Jaune
                ' 4 : Bleu
                ' 5 : Magenta
                ' 6 : Cyan
                ' 7 : Blanc
                '
                ' X0 => Rouge
                ' X1 => Vert
                ' X2 => Bleu

                Dim ListeCoul() As String = {"Noir", "Rouge", "Vert", "Jaune", "Bleu", "Magneta", "Cyan", "Blanc"}
                Dim C0, C1, C2, C3 As Byte
                C0 = 0
                C1 = 0
                C2 = 0
                C3 = 0

                'Calcul des 2 couleurs
                Val(3) = 0
                If Palette(0).R <> 0 Then
                    C0 += 1
                End If
                If Palette(0).V <> 0 Then
                    C0 += 2
                End If
                If Palette(0).B <> 0 Then
                    C0 += 4
                End If

                If Palette(1).R <> 0 Then
                    C1 += 1
                End If
                If Palette(1).V <> 0 Then
                    C1 += 2
                End If
                If Palette(1).B <> 0 Then
                    C1 += 4
                End If
                ' Couleur 2/3
                'Calcul des 2 couleurs
                If Palette(2).R <> 0 Then
                    C2 += 1
                End If
                If Palette(2).V <> 0 Then
                    C2 += 2
                End If
                If Palette(2).B <> 0 Then
                    C2 += 4
                End If

                If Palette(3).R <> 0 Then
                    C3 += 1
                End If
                If Palette(3).V <> 0 Then
                    C3 += 2
                End If
                If Palette(3).B <> 0 Then
                    C3 += 4
                End If


                ' couleur 0/1
                Push_Buffer(0) ' le son viendra plus tard ! 
                Adr = &H1000
                Adr_Old = Adr
                Push_Buffer((Adr And &HFF00) >> 8)
                Push_Buffer(Adr And &HFF)
                Push_Buffer(C0 + C2 * 8)

                Push_Buffer(0)
                Adr = &H1800
                Adr_Old = Adr
                Push_Buffer((Adr And &HFF00) >> 8)
                Push_Buffer((Adr And &HFF))
                Push_Buffer(C1 + C3 * 8)

                'Pour trace des couleur dans le textbox ! 
                Dim Phrase As String
                If False Then
                    Phrase = "Couleur =" + ListeCoul(C0) + " " + ListeCoul(C1) + " " + ListeCoul(C2) + " " + ListeCoul(C3) + " "
                    Trace.AppendText(Phrase + vbLf)
                End If
                'Laisse respirer Windows, ce qui permet d'afficher tout
                System.Windows.Forms.Application.DoEvents()

            End If
No_Color:
            'Maintenant on va contrôler l'ensemble de l'image courante par rapport à la précédente
            Nombre = 0

            'Init du buffer
            Taille = 0
            TBuffer = 0
            Adr_Old = &H5FFFF ' completement hors champs pour le 1er 

            ' Sur l'ensemble du bitmap  ********************1ere passe          
            For Y = Y_Old To HeightBmp - 1
                For X = 0 To WidthBmp - 4 Step 4
                    ' on mets en gris les 4 pixels courant
                    'Passage en gris des pixels 
                    Grey(0) = Color(X + 0, Y, Pixel)
                    Grey(1) = Color(X + 1, Y, Pixel)
                    Grey(2) = Color(X + 2, Y, Pixel)
                    Grey(3) = Color(X + 3, Y, Pixel)

                    ' Détection de changement
                    If (Old_Img(X, Y) <> Grey(0)) Or (Old_Img(X + 1, Y) <> Grey(1)) Or (Old_Img(X + 2, Y) <> Grey(2)) Or (Old_Img(X + 3, Y) <> Grey(3) Or Premier) Then

                        ' on a trouvé une difference entre les 2 images !!!
                        Nombre += 1
                        ' on remets les anciennes valeurs au chaud
                        Old_Img(X + 0, Y) = Grey(0)
                        Old_Img(X + 1, Y) = Grey(1)
                        Old_Img(X + 2, Y) = Grey(2)
                        Old_Img(X + 3, Y) = Grey(3)

                        'Calcul de l'adresse mémoire Hector
                        If BR Then
                            ' &H4000 To &H49A0 Step 32
                            Adr = &H4000 + (X / 4) + (Y) * 32
                        Else
                            ' En HR C000
                            Adr = &HC000 + (X / 4) + (Y) * 64
                        End If

                        'Calcul du pas entre l'adresse précédante et la nouvelle
                        Offset_Hector = Adr - Adr_Old

                        ' écriture de la structure dans le FileHector
                        'ici on change le pas !
                        If Offset_Hector < 64 And Offset_Hector > 0 Then  ' Limitation de l'offset à 128 pour laisser de la place pour le son
                            'On est en offset !

                            ' mise en place dans le buffer de la somme de l'offset et des 2 bits son ! 
                            Push_Buffer(Offset_Hector) ' plus de son, cela viendra après ! + Pop_Son_Video()

                            ' Mise en place du 1er octet
                            Push_Buffer((Grey(3) << 6) Or (Grey(2) << 4) Or (Grey(1) << 2) Or (Grey(0)))


                            Dim KK As Integer
                            Dim XX0 As Integer
                            XX0 = X
                            For KK = 1 To 2 ' on va mettre 3*4 pixels de plus dans la même trame
                                ' Calcul un point plus loin
                                X += 4
                                XX0 += 4
                                ' Mise en place de l'adresse old !
                                If BR Then
                                    ' &H4000 To &H49A0 Step 32
                                    Adr_Old = &H4000 + (XX0 / 4) + (Y) * 32
                                Else
                                    ' En HR C000
                                    Adr_Old = &HC000 + (XX0 / 4) + (Y) * 64
                                End If

                                If XX0 <= WidthBmp - 4 Then
                                    ' on est pas au bout du bitmap 
                                    'on peut aller voir le suivant


                                    ' on mets en gris les 4 pixels suivant
                                    'Passage en gris des pixels
                                    Grey(0) = Color(X + 0, Y, Pixel)
                                    Grey(1) = Color(X + 1, Y, Pixel)
                                    Grey(2) = Color(X + 2, Y, Pixel)
                                    Grey(3) = Color(X + 3, Y, Pixel)
                                    ' on remets les anciennes valeurs au chaud
                                    Old_Img(X + 0, Y) = Grey(0)
                                    Old_Img(X + 1, Y) = Grey(1)
                                    Old_Img(X + 2, Y) = Grey(2)
                                    Old_Img(X + 3, Y) = Grey(3)

                                    Push_Buffer((Grey(3) << 6) Or (Grey(2) << 4) Or (Grey(1) << 2) Or (Grey(0)))
                                Else
                                    ' on est au bout du bitmap 
                                    ' on retourne en arriere 
                                    X -= 4 ' on revient en arriere pour avancer correctement

                                    ' Mise en place du 2eme octet, nul car rien derriere sur cette ligne
                                    Push_Buffer(0)
                                End If

                            Next KK

                        Else
                            ' Offset est supérieur à 255 => on met en absolu !

                            'On mets en place le ZERO avec les bits son !
                            Push_Buffer(0) ' sans son ! Pop_Son_Video()

                            'Calcul de l'adresse mémoire Hector
                            If BR Then
                                ' &H4000 To &H49A0 Step 32
                                Adr = &H4000 + (X / 4) + (Y) * 32
                            Else
                                ' En HR C000
                                Adr = &HC000 + (X / 4) + (Y) * 64
                            End If

                            Push_Buffer((Adr And &HFF00) >> 8)
                            Push_Buffer(Adr And &HFF)
                            ' Mise en place du Seul octet 
                            Push_Buffer((Grey(3) << 6) Or (Grey(2) << 4) Or (Grey(1) << 2) Or (Grey(0)))
                            Adr_Old = Adr
                        End If
                    End If
                Next  ' on boucle sur tous les pixels de la ligne courante

                'ici on a fini un ligne
                ' on verifie si on déborde le nombre de modif possible par trame

                ' On vérifie que le nombre de modif n'est pas trop grand,
                ' Si oui on suspends le calcul pour terminer au tour suivant
                If Nombre >= NFrag Then
                    ' Nota : On pourrait baisser le Nb_Modif s'il et positif pour ne pas arriver dans ce cas.
                    ' Les débordements seraient alors décalés d'autant
                    If Nombre > 0 Then
                        ' Ici on est dans le cas ou l'image précédente avait du gras
                        ' on lui retire le gras pour essayer d'y glisser notre FRAME !
                        Nombre -= 1

                    Else
                        ' ON peut plus car la précédente n'avait plus de gras ... on suspend donc !
                        ' on suspend !
                        Y_Old = Y
                        Trace.AppendText("Image trop chargée à Y=" & Y.ToString & vbLf)
                        Y = HeightBmp + 4 ' pour que le next sorte de la boucle !
                    End If

                End If
            Next ' boucle sur les lignes !

            If Nombre < NFrag Then
                'sinon on remet à 0
                Y_Old = 0
            End If

            ' On rempli de blanc le remplissage precedent !
            ' Sauf : 1ere image et 
            ' Sauf si on n'arrive pas à tout tracer sur cette image !
            Do While (NB_modif < NRemp) And Not (Premier) And (Y_Old = 0)

                'Ici NB_modif c'est le nombre de changement réalisé au frame précédent 
                '    Nombre c'est le nombre de changement du frame en cours
                '    NRemp : c'est la valeur de remplissage demandé 
                '    NFrag : c'est le seuil de fragmentation (avant que l'on fragmente une image)
                '            Y_Old contiendra alors de Y de là ou on c'est arrêté à l'image !

                ' Nota : On pourrait baisser le Nb_Modif s'il et positif pour ne pas arriver dans ce cas.
                ' Les débordements seraient alors décalés d'autant
                ' 

                NB_modif += 1
                Push_Buffer(0)
                Adr = &HBFFF
                Adr_Old = Adr
                Push_Buffer((Adr And &HFF00) >> 8)
                Push_Buffer(Adr And &HFF)
                'Calcul des 4 pixels à afficher
                Push_Buffer(0)

            Loop
            Dim toto As Byte
            For i = 0 To Index_Buff - 4 Step 4
                toto = Buffer(i)
                Buffer(i) += Pop_Son_Video()  ' Mise en place en 1 fois des octets sons lorsque tout est calculé pour ne pas en perdre lorsque 
                'l'on revient en arrirere sur le nombre de bloc de remplissage !
            Next

            ' On a envoyé la 1ere image
            Premier = False

            ' On garde le nombre de modif pour affichage
            NB_modif = Nombre



            ' Maintenant on peut envoyer la table des modif dans le fichier 
            FileHector.Write(Buffer, 0, Index_Buff)

            Index_Buff = 0
            'Laisse respirer Windows, ce qui permet d'afficher tout
            System.Windows.Forms.Application.DoEvents()

            ' Pour vérification fichier suivant 
            '  nom = "cat" + Microsoft.VisualBasic.Right("0000" + (Position + 1).ToString, 4) + ".bmp"
            nom = "img" + Microsoft.VisualBasic.Right("00000" + (Position + 1).ToString, 5) + ".bmp"



        Loop Until Not (FileIO.FileSystem.FileExists(CheminListBMP + "\" + nom)) Or Position = Position_final

        'ON raz le buffer
        TBuffer = 0

        ' Fin de fichier !
        ' écriture de la structure dans le FileHector avec Offset=0 et @ = 0101
        Buffer(TBuffer) = 0 'offset
        TBuffer += 1
        Buffer(TBuffer) = 1 '@
        TBuffer += 1
        Buffer(TBuffer) = 1 '@
        TBuffer += 1
        Buffer(TBuffer) = 0 'Valeur
        TBuffer += 1

        ' pour sortir on ne donne pas d'octet de data !
        ' Maintenant on peut envoyer la table des modif dans le fichier 
        FileHector.Write(Buffer, 0, TBuffer)

        'ON raz le buffer
        TBuffer = 0

        ' Fermeture du fichier !
        FileHector.Close()
        ' et son
        FichierSon.Close()

        'on l'affiche !
        Label10.Visible = True
        ' C'est fini !!!!
    End Sub

    Function Gris(ByVal xg As Integer, ByVal yg As Integer, ByRef Tbl_Pixel() As Byte) As Byte
        Dim rouge, vert, bleu As Integer

        ' on mets en gris le pixel courant
        bleu = Tbl_Pixel((xg * 3) + yg * stride)
        vert = Tbl_Pixel((xg * 3) + 1 + yg * stride)
        rouge = Tbl_Pixel((xg * 3) + 2 + yg * stride)

        '      GoTo Couleur
        'Passage en gris de l'image
        Gris = (76 * bleu + 151 * vert + 28 * rouge) >> 8

        '2 niveaux me suffisent !
        If Gris > Gamma Then
            Gris = 2  '3 jaune,1 rouge 2 blanc

        Else
            Gris = 0
        End If

        Exit Function
Couleur:
        Gris = 0  ' Noir

        If bleu > Gamma And rouge > Gamma And vert > Gamma Then
            Gris = 1 'Blanc
        End If

        If rouge > Gamma And vert > Gamma And Gris = 0 Then
            Gris = 2 'Jaune
        End If
        If rouge > Gamma And Gris = 0 Then
            Gris = 3 'Rouge
        End If

    End Function

    Function Color(ByVal xg As Integer, ByVal yg As Integer, ByRef Tbl_Pixel() As Byte) As Byte

        If CheckNb.Checked Then
            Color = Gris(xg, yg, Tbl_Pixel)
        Else
            Color = Color_Search(xg, yg, Tbl_Pixel)
        End If

    End Function
    Function Color_Search(ByVal xg As Integer, ByVal yg As Integer, ByRef Tbl_Pixel() As Byte) As Byte

        Dim Ret, I As Byte
        Dim Cc As Coul
        ' on mets en gris le pixel courant
        Cc.B = Tbl_Pixel((xg * 3) + yg * stride)
        Cc.V = Tbl_Pixel((xg * 3) + 1 + yg * stride)
        Cc.R = Tbl_Pixel((xg * 3) + 2 + yg * stride)
        Ret = 254

        For I = 0 To 3
            If Cc.R = Palette(I).R And Cc.V = Palette(I).V And Cc.B = Palette(I).B Then
                Ret = I
            End If
        Next I
        If Ret > 4 Then
            '    MsgBox("erreur de couleur !" & Microsoft.VisualBasic.vbCrLf & "Rouge=" & Cc.R & "Vert =" & Cc.V & "Bleu =" & Cc.B, MsgBoxStyle.OkOnly)
            Trace.AppendText(".")
            Ret = 0
        End If
        Return Ret
    End Function

    Function ExtractColor(ByVal xg As Integer, ByVal yg As Integer, ByRef Tbl_Pixel() As Byte) As Coul
        Dim Ret As Coul
        ' on mets en gris le pixel courant
        Ret.B = Tbl_Pixel((xg * 3) + yg * stride)
        Ret.V = Tbl_Pixel((xg * 3) + 1 + yg * stride)
        Ret.R = Tbl_Pixel((xg * 3) + 2 + yg * stride)

        Return Ret
    End Function

    Private Sub Calcul_Resolution()
        WidthBmp = 4 * Resol_H.Value
        HeightBmp = WidthBmp * 3 / 4

        If WidthBmp = 112 Then
            HeightBmp = 77
        End If

        LLarg.Text = WidthBmp.ToString
        LLong.Text = HeightBmp.ToString

    End Sub

    Private Sub Resol_H_ValueChanged(sender As Object, e As EventArgs) Handles Resol_H.ValueChanged
        Calcul_Resolution()
    End Sub

    ' Gestion des parametres application
    Private Sub MAJ_Param()


        My.Settings.Repertoire_FFMPEG = LabelFFMPEG.Text
        My.Settings.Repertoire_VBH = LabelPath.Text
        My.Settings.Repertoire_ListBMP = LabelListBMP.Text

        My.Settings.Save()

    End Sub
    Private Sub Lect_Param()
        My.Application.SaveMySettingsOnExit = True

        If File.Exists(My.Settings.Repertoire_FFMPEG) Then
            CheminFFMPEG = My.Settings.Repertoire_FFMPEG
        Else
            CheminFFMPEG = CurDir$() & "\" & "ffmpeg"   ' zmac.exe  "
            My.Settings.Repertoire_FFMPEG = CheminFFMPEG
        End If
        LabelFFMPEG.Text = CheminFFMPEG

        If System.IO.Directory.Exists(My.Settings.Repertoire_VBH) Then
            CheminDest = My.Settings.Repertoire_VBH
        Else
            CheminDest = "Définissez le répertoire !"
        End If
        LabelPath.Text = CheminDest

        If System.IO.Directory.Exists(My.Settings.Repertoire_ListBMP) Then
            CheminListBMP = My.Settings.Repertoire_ListBMP
        Else
            CheminListBMP = "Définissez le répertoire !"
        End If
        LabelListBMP.Text = CheminListBMP

        '   qrggrqerg()

        LabelHec.Text = Name_Hec
        LabelHec2.Text = Name_Hec
        My.Settings.Fichier_SND = Name_Hec
        Flag_Hec = True



    End Sub

    ' Chagement/Déchargement application
    Private Sub Convertisseur_FormClosing(sender As Object, e As FormClosingEventArgs) Handles Me.FormClosing
        MAJ_Param()
    End Sub
    Private Sub Convertisseur_Load(sender As Object, e As EventArgs) Handles Me.Load

        'Mise en place des ascenseurs
        Me.AutoScroll = MainForm.AscenseurSurFrameToolStripMenuItem.Checked

        'Lecture des répertoires déjà initialisés
        Lect_Param()

        Calcul_Resolution()
        Gamma = TrackGamma.Value
        LGamma.Text = Gamma.ToString

        RichTB.Text = My.Resources.Hlp_son

        ' RichTB.Text = "Le fichier WAV doit être 8bits, mono et la frequence doit être mise manuellement ci contre." + vbCrLf
        ' RichTB.Text += "La frequence a créer doit être de 16.000 Hz pour les vidéo et de 59169Hz pour le son seul. Pour VBHector c'est 66000Hz !" + vbCrLf
        ' RichTB.Text += "GoldWave permet de 'resampler' les WAV." + vbCrLf + vbCrLf
        ' RichTB.Text += "Avant de lancer un traitement, selectionnez <1-Charge WAV> : le fichier WAV source et ensuite <2-Sauve HEC> le fichier son produit" + vbCrLf + vbCrLf
        ' RichTB.Text += "Ensuite pour effectuer la conversion, cliquez sur <3-Traitement>." + vbCrLf + vbCrLf
        ' RichTB.Text += "Attention : la fréquence source DOIT être supérieure à celle produite pour Hector !" + vbCrLf

        Trace.Text = My.Resources.HLP_Video

    End Sub


    Private Sub TrackGamma_Scroll(sender As Object, e As EventArgs) Handles TrackGamma.Scroll
        Gamma = TrackGamma.Value
        LGamma.Text = Gamma.ToString
    End Sub

    Private Sub BClear_Click(sender As Object, e As EventArgs) Handles BClear.Click

        MessageBox.Show("Attention operation qui dure quelques secondes..." & vbCrLf & " Attendez le message de reussite! ", "Attention", MessageBoxButtons.OK, MessageBoxIcon.Hand)
        Dim MonFichierSupp As Object

        MonFichierSupp = CreateObject("Scripting.FileSystemObject")
        MonFichierSupp.DeleteFile(CheminListBMP + "/*.*")

        MessageBox.Show("C'et bon ! Les fichiers sont effacés..." & vbCrLf, "Pas trop long ?", MessageBoxButtons.OK, MessageBoxIcon.Hand)

    End Sub

    Private Sub Bffmpeg_Click(sender As Object, e As EventArgs) Handles Bffmpeg.Click
        Dim ListOption As String
        Dim OFD As New OpenFileDialog

        OFD.Filter = "Film |*.MP4;*.AVI"
        OFD.InitialDirectory = LabelPath.Text
        OFD.Multiselect = False
        OFD.CheckFileExists = False

        If OFD.ShowDialog <> DialogResult.OK Then
            Exit Sub
        End If

        '   LabelPath.Text = OFD.FileName

        ListOption = "-i """ + OFD.FileName + """ -r 10 -vframes 5000 -s " + WidthBmp.ToString + "x" + HeightBmp.ToString + " -f image2 "

        ' on mets dans le repertoire les images
        ListOption = ListOption + """" + CheminListBMP + "/img%05d.bmp"""

        '     ffmpeg -i foo.avi -r 1 -s WxH -f image2 foo-%03d.jpeg
        'MyUtilities.RunCommandCom("ffmpeg", ListOption, False, Chemin)

        Dim Strg As String
        Strg = "C:\Windows\System32\cmd.exe /K " + CheminFFMPEG + " " + ListOption
        Shell(Strg, AppWinStyle.NormalFocus, True)
        '  Shell(Chemin + "bin/ffmpeg " + ListOption)



        '"C:\Windows\System32\cmd.exe /K "C:\Users\APILOG\Desktop\new_conv\ffmpeg\bin\ffmpeg " -i "C:\Users\APILOG\Downloads\Jac.mp4" -r 10 -vframes 5000 -s 204x153 -f image2 C:\Users\APILOG\Desktop\new_conv\ffmpeg\ListBMP/img%05d.bmp"



    End Sub

    Private Sub ButtonSon_Click(sender As Object, e As EventArgs) Handles ButtonSon.Click
        Dim OFD As New OpenFileDialog

        OFD.Filter = "Sound Hector Files|*.snd"
        If LabelHec2.Text <> "..." Then
            CheminSon = LabelHec2.Text
        End If
        OFD.InitialDirectory = CheminSon  '"C:\Users\jj\Desktop\VB\VB_HectorSD_2.3\bin\Release\Video\"
        OFD.Multiselect = False
        OFD.CheckFileExists = False

        If OFD.ShowDialog = DialogResult.OK Then
            Name_Hec = OFD.FileName
            LabelHec.Text = Name_Hec
            LabelHec2.Text = Name_Hec
            My.Settings.Fichier_SND = Name_Hec
            Flag_Hec = True

        End If

    End Sub

    Private Sub ButtonDest_Click(sender As Object, e As EventArgs) Handles ButtonDest.Click
        Dim folderDlg As New FolderBrowserDialog

        'ShowDialog method displays the FolderBrowserDialog.

        folderDlg.SelectedPath = CheminDest

        If folderDlg.ShowDialog = DialogResult.OK Then
            CheminDest = folderDlg.SelectedPath
            LabelPath.Text = CheminDest
        End If


    End Sub

    Private Sub CheckNb_CheckedChanged(sender As Object, e As EventArgs) Handles CheckNb.CheckedChanged
        TrackGamma.Visible = CheckNb.Checked
        LGamma.Visible = CheckNb.Checked
        Label2.Visible = CheckNb.Checked
    End Sub




    '*******************************************************************************************************
    '*****************************************   SON     ***************************************************
    '*******************************************************************************************************

    Dim Donnee_Source As Byte()

    Dim Name_Wav As String
    Dim Name_HecSon As String

    'Recupération de la bande son !
    Dim FichierSonSon As IO.FileStream
    Dim OctetSonSon(1023) As Byte               ' pour le ... son 

    'Export de la bande son pour Hector!
    Dim FichierHec As IO.FileStream
    Dim SW As StreamWriter
    Dim OctetHec(1023) As Byte               ' pour le ... son 
    Dim IndexHec As Integer
    Dim Flag_Wav As Boolean = False
    Dim Flag_Hec As Boolean = False
    Dim COCO As Byte = &H0

    Private Function Pop_Son() As Byte
        ' Gestion du son, travail sur Buffer
        If FichierSonSon.CanRead And IndexSon > 1023 Then
            FichierSonSon.Read(OctetSonSon, 0, 1024)
            IndexSon = 0
        End If
        If IndexSon > 1023 Then
            IndexSon = 0
        End If

        Pop_Son = OctetSonSon(IndexSon)
        IndexSon += 1
    End Function

    Private Sub Push_Hec(ByVal Octet As Byte)
        ' Gestion du son, travail sur Buffer
        OctetHec(IndexHec) = Octet 'CByte(IndexHec And 255) '
        IndexHec += 1

        If IndexHec > 1023 Then
            FichierHec.Write(OctetHec, 0, 1024)
            IndexHec = 0

        End If
    End Sub

    Private Sub ButtonWav_Click(sender As Object, e As EventArgs) Handles ButtonWav.Click
        Dim OFD As New OpenFileDialog

        OFD.Filter = "Wave Files|*.wav"
        OFD.InitialDirectory = "C:\Users\jj\Desktop\VB\SoundHector"
        OFD.Multiselect = False

        If OFD.ShowDialog = DialogResult.OK Then
            Name_Wav = OFD.FileName
            LabelWav.Text = Name_Wav
            Flag_Wav = True
        End If

    End Sub

    Private Sub ButtonSav_Click(sender As Object, e As EventArgs) Handles ButtonSav.Click
        Dim OFD As New SaveFileDialog

        OFD.Filter = "Sound Hector Files|*.snd"
        OFD.InitialDirectory = "C:\Users\jj\Desktop\VB\VB_HectorSD_2.3\bin\Release\Video\"
        '  OFD.Multiselect = False
        OFD.CheckFileExists = False

        If OFD.ShowDialog = DialogResult.OK Then
            Name_HecSon = OFD.FileName
            LabelHec2.Text = Name_HecSon
            LabelHec.Text = Name_HecSon
            My.Settings.Fichier_SND = Name_HecSon
            Flag_Hec = True
        End If

    End Sub

    Private Sub ButtonTrait_Click(sender As Object, e As EventArgs) Handles ButtonTrait.Click
        Dim Koef As Double
        Dim Byte_Hector As Byte
        Dim Sample, Echant, d1, d2, Sortie As Integer
        Dim Directory As String = "C:\Users\jj\Desktop\VB\VB_HectorSD_2.3\bin\Release\Video"
        Dim v, o As Byte
        Dim ee As Integer
        Dim Taux_Dither As Double

        Dim Nb_Wav As Double
        Dim Counter As Integer
        Dim Defil As Long = 0
        Dim LongMax As Long = 0
        Dim Temps, Temps_Max As Integer
        Dim Count_Temps As Integer

        'Quelque remarques :
        If Flag_Wav = False Then
            MsgBox("Chargez un WAV d'abord !")
            Exit Sub
        End If
        If Flag_Hec = False Then
            MsgBox("Sélectionnez un fichier à écrire d'abord !")
            Exit Sub
        End If

        Koef = Freq_Out.Value / CInt(NumericSource.Value)

        If Koef > 1.0 Then
            MsgBox("La fréquence source DOIT être supérieure à la fréquence à produire (désolé !) ")
            Exit Sub
        End If

        ' Fichier son WAVE !
        FichierSonSon = New IO.FileStream(Name_Wav, IO.FileMode.Open)
        LongMax = FichierSonSon.Length
        ProgressBar1.Maximum = CInt(LongMax / 100)
        FichierSonSon.Position = 60 ' On saute l'entête WAV !
        IndexSon = 0

        ' Fichier son Hector !
        FichierHec = New IO.FileStream(Name_HecSon, IO.FileMode.Create, FileAccess.Write, FileShare.None)
        FichierHec.Position = 60
        IndexHec = 0

        ' Taux de Dither
        Taux_Dither = TrackDi.Value / 100

        ProgressBar1.Maximum = CInt(FichierSonSon.Length / 100)

        'Calcul du temps maxi d'enregistrement en secondes !
        Temps_Max = CInt(NumericTemps.Value)

        While (Defil < LongMax) And (Temps < Temps_Max)

            ' Version sam :
            'v = echantillon_audio_unsigned()  // (0..255)
            'o = v>=e ? 255: 0
            'e = e + (o - v);
            'sortir(o)

            'On moyenne le flux d'entrée selon le coef flux de sortie !
            Sample = 0
            Counter = 0
            While (Nb_Wav < 1.0) Or (Counter > 50)
                Sample += Pop_Son() ' (0..255)
                Nb_Wav += Koef
                Counter += 1
            End While

            Count_Temps += Counter
            If Count_Temps > NumericSource.Value Then 'si on est à 44100 Hz sur le source alors tous les 44100 échantillons on a une seconde ! 
                Count_Temps -= NumericSource.Value
                Temps += 1
            End If

            v = CByte(Sample / Counter)
            Nb_Wav = Nb_Wav - 1.0

            If Not (CheckDith.Checked) Then
                '  1ere version meilleur !
                If v >= ee Then
                    Byte_Hector = &H80 'mise en place du bit son
                    o = &HFF
                Else
                    Byte_Hector = &H0  'mise en place du bit son
                    o = 0
                End If

                ee = ee + (CInt(o) - CInt(v))

            Else
                'script de base :
                'my $v = &echantillon_audio();
                '$v += $d2*-1;
                '$v += $d1*2;
                '$Byte_Hector = $v>0?$lvl:-$lvl;
                '$d2 = $d1; # retard
                '$d1 = $v - $Byte_Hector; # retard


                ' V est en unsigned => 
                '   signal à -1  => V=00h
                '   signal à 0   => V=80h
                '   signal à +1  => V=FFh

                ' Echant (ainsi que d2 et d1)  sont SIGNE 32 bits !
                Echant = v - &H80                   '  passage en signé
                Echant -= Taux_Dither * d2          '  Recupération de l'erreur n-2
                Echant += (1 + Taux_Dither) * d1    '  Recupération de l'erreur n-1

                If Echant > 0 Then
                    Byte_Hector = &H80 'mise en place du bit son
                    Sortie = 127   ' valeur son à prendre en compte
                Else
                    Byte_Hector = &H0  'mise en place du bit son
                    Sortie = -128  ' valeur son à prendre en compte
                End If

                d2 = d1                  ' Déplacement de l'erreur
                d1 = (Echant - Sortie)   ' Calcul nouvelle erreur !

                ' Saturation de l'erreur ?
                'If d1 > 255 Then d1 = 255
                'If d1 < -255 Then d1 = -255

            End If

            Push_Hec(Byte_Hector)

            ' Gestion de la barre de progression
            Defil += 1
            If (Defil Mod 100) = 0 Then

                ProgressBar1.Value = CInt(Defil / 100)
                Application.DoEvents()
            End If

        End While

        'Indicateur de fin !
        For i = 0 To 1023
            Push_Hec(1)
        Next i

        FichierHec.Close()
        FichierSonSon.Close()

        MsgBox("Fini !")

    End Sub

    'Pré-remplissage des fréquences usuelles
    Private Sub Button16k_Click(sender As Object, e As EventArgs) Handles Button16k.Click
        Freq_Out.Value = 16000
    End Sub
    Private Sub Button44_Click(sender As Object, e As EventArgs) Handles Button44.Click
        NumericSource.Value = 44100
    End Sub
    Private Sub Button66_Click(sender As Object, e As EventArgs) Handles Button66.Click
        NumericSource.Value = 66666
        Freq_Out.Value = 66666
    End Sub
    Private Sub Button285_Click(sender As Object, e As EventArgs) Handles Button285.Click
        Freq_Out.Value = 28500
    End Sub
    Private Sub ButtonChange_Click(sender As Object, e As EventArgs) Handles ButtonChange.Click
        Dim F As New OpenFileDialog

        F.FileName = CheminFFMPEG
        F.ShowDialog()

        If File.Exists(F.FileName) Then
            CheminFFMPEG = F.FileName
            LabelFFMPEG.Text = CheminFFMPEG
        End If
    End Sub

    Private Sub CheckDith_CheckedChanged(sender As Object, e As EventArgs) Handles CheckDith.CheckedChanged
        LabelDi.Visible = CheckDith.Checked
        TrackDi.Visible = CheckDith.Checked
        LabelDi.Text = TrackDi.Value & " %"
    End Sub

    Private Sub TrackDi_Scroll(sender As Object, e As EventArgs) Handles TrackDi.Scroll
        LabelDi.Text = TrackDi.Value & " %"
    End Sub

    Private Sub Button2_Click(sender As Object, e As EventArgs) Handles Button2.Click
        Dim folderDlg As New FolderBrowserDialog

        folderDlg.SelectedPath = CheminListBMP

        If folderDlg.ShowDialog = DialogResult.OK Then
            CheminListBMP = folderDlg.SelectedPath
            LabelListBMP.Text = CheminListBMP
        End If

    End Sub

End Class


Public Class MyUtilities
    Shared Sub RunCommandCom(command As String, arguments As String, permanent As Boolean, directory As String)
        Dim p As Process = New Process()
        Dim pi As ProcessStartInfo = New ProcessStartInfo()
        pi.Arguments = " " + If(permanent = True, "/K", "/C") + " " + command + " " + arguments
        pi.WorkingDirectory = directory
        pi.FileName = "cmd.exe"
        p.StartInfo = pi
        p.Start()
    End Sub
End Class

