﻿
'Copyright © 2016 Jean-Jacques STACINO
' author mail : jj.stac @ aliceadsl.fr


'This program is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    This program is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with this program.  If not, see <http://www.gnu.org/licenses/>.


' This file is part of VBHector.

'    VBHector is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    Foobar is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with VBHector.  If not, see <http://www.gnu.org/licenses/>.

' Several part such as modZ80, modAY8912 are from GPL project (VBSpec)
'   Tranlation from VB6 to VBNet and much more had been made.
'   Thanks' to them authors (Chris Cowley, Xavier) 
'   Note that the original files from Chris Cowley are joined to this project (Directory "Sources Licences" . 
' Emulation of the MEA8000 is from A.Mine, that I want to thank here for him's agreement.

Option Explicit On
Option Strict On

' Passage à Strict 01/11/13 

Public Class K7
    ' Yo_fr (jj.stac @ aliceadsl.fr)
    ' Le 20/12/2012 !
    ' Ce code est libre d'utilisation et de diffusion (under GPL V3 licence), néanmoins si vous utilisez mon code,
    ' merci de m'envoyer un petit mail !
    ' Si vous améliorez / corrigez des bug, merci de me le renvoyer la correction !

    ' This code is free to use and distribute (under GP V3 licence), however if you use my code thank you send me a mail!
    ' If you improve / correct the bug, thank you for returning it to me!


    ' Gestion du magnétophone
    ' Réalisé à Bursa 26/10/2012
    ' Never forget : Entre chaque bloc il faut mettre 4 cycles de synchro !!!!
    ' (ce n'est pas qu'après des bloc FE...)
    ' Repris à Cordoba 18/01/2016 pour :
    '    * détection entre un bloc de TOL et un sous bloc de données avec une longueur TOL =5 ET le bloc précedent terminé !
    '        (bloc précédent avec le calcul du nombre d'octets restant à chaque bloc de données)
    '    * Chargement meilleur avec un READALLBYTE lors du chargement de la K7
    '    * Reprise de l'init K7 permet de chargement correcte après un rembobinage

    ' Variable 
    Public MotorON As Boolean 'Etat du moteur (ON/OFF)
    Dim bK7(10) As Byte ' 20166 ineger Buffer pour les données de la K7
    Dim LenghtK7 As Integer
    Public Nb_Bloc As Integer = 0
    Public Liste_Bloc As String = ""
    Dim Attente As Integer = 0

    Dim Taille_Bloc_Init As Integer = 0 ' Taille du bloc en cours de lecture
    Dim Code_TOL, Adresse, Longueur As Integer

    Dim Pointeur_Octet As Integer ' Donne la position courante de l'octet dans le buffer de Cassette
    Dim Pointeur_Bit As Integer   ' Donne le bit en cours d'envoi dans l'octet courant
    Public EtatK7 As Integer ' Etat de la cassette
    Public CK_signal As Integer 'Compteur de pulses à 15625 Hz 
    Dim Flip_Flop As Integer = &H80
    Dim Forth As Boolean = False ' indique le type de cassette (Classic ou Forth)

    Public Sub Init_Cassette(ByVal Name_File As String)
    
        'Chargement de la K7 souhaitée.
        If Dir$(Name_File) = "" Then
            EtatK7 = 0 'Cassette déchargée !
            MsgBox("Erreur: fichier K7 introuvable" & Name_File & ".", vbOKOnly Or vbCritical, "Hector")
            Exit Sub
        End If

        LenghtK7 = CInt(FileLen(Name_File)) ' Longueur
        ReDim bK7(LenghtK7)

        'chargement de la K7!
        bK7 = My.Computer.FileSystem.ReadAllBytes(Name_File)

        'Initialisation des pointeurs de lecture K7
        Pointeur_Bit = 0
        Pointeur_Octet = 0 'si si on commence à 0 ... !
        EtatK7 = 1 'Cassette chargée !

        ' Le type de fichier indique le type de synchro à mettre en place !
        If Right(Name_File, 3).ToUpper = "FOR" Then
            Forth = True
        Else
            Forth = False
        End If
        'init du nombre de bloc lu
        Rembobine()
    End Sub

    Public Sub Rembobine()
        'Initialisation des pointeurs de lecture K7
        Pointeur_Bit = 0
        Pointeur_Octet = 0 'si si on commence à 0 ... !
        EtatK7 = 1 'Cassette chargée !
        'init du nombre debloc lu
        Nb_Bloc = 0
        Code_TOL = 0
        Adresse = 0
        Longueur = 0
        Taille_Bloc_Init = 0
    End Sub

    Public Function Lecture_Port() As Integer
        'Lecture du port 3000 d'Hector pour la cassette.
        'On mets ici à dispo les données de cassettes...
        Static Dim Octet As Integer
        Static Dim Start_TOL As Boolean = False 'Flag indiquannt que le bloc a été débuté
        Static Dim Taille_Bloc As Integer = 0 ' Taille du bloc en cours de lecture

        'Définition des frequences des bits Synchro / 1 et 0.
        Const Tps_Synchro As Integer = &H20 '&H20 ' entre 15 et 21
        ' 0D bascule 0/1
        Const Tps_Ba1 As Integer = &H13    ' superieur à 0D =>1
        Const Tps_Ba0 As Integer = &H9     ' inferieur à 0D =>0 

        ' Le compteur CK_Signal compte de 0 à 7F à la fréquence de 15625Hz 
        ' Le bit X7 du mot lu change d'état selon la fréquence de la cassette
        ' Ce n'est pas son état qui est intéressant, c'est juste son changement d'état 
        ' ainsi que la différence entre les valeurs de compteur en relatif au moment
        ' des changements de ce bit qui font les valeurs de 0 / 1 et de synchro...

        ' Ce qui fait que selon l'état du bit à envoyer, il suffit de positionner le compteur à
        ' la bonne valeur...

        ' Neamoins, il faut laisser Hector respirer avec des bits de synchro entre chaque bloc
        ' Bloc de TOL, comme bloc de données...4 synchro aprèes une TOL, plus en cas de données

        'Si ce n'est pas pour lire la cassette on ne passe pas ici... déjà filtré lors de l'appel !

        'Etat_K7 permet de mettre en place des cycles de synchro pour Hector.
        ' si la variable est :
        '  =0    => pas de cassette en cours
        '  <600  => Cycle de synchro
        '  =600  => dernier cycle de synchro
        '  >600  => usuellement 601, cycle d'envoi de bits de données à Hector


        ' C'est assez simple : Les octets sont regroupés en blocs, un bloc commence par la longueur de l'entête, puis les datas.
        ' Il existe 2 famille de bloc : 
        ' Le bloc d'entête (TOL) : C'est le 1er bloc rencontré et il y en a plusieurs sur un chargement de logiciel du commerce. On y trouve donc en 1er octet la longueur puis les paramètres et enfin le code du bloc.
        ' Suite à ce bloc d'entête il peut, dans certain cas, être suivi d'un bloc de données, par exemple dans le cas d'un bloc de remplissage ou d'un bloc de données.


        ' 200h cycles de synchro mini..
        If EtatK7 < 600 And EtatK7 > 0 Then
            'On est encore dans la phase amorce 

            'mise en place compteur pour les synchro      
            CK_signal = CK_signal + Tps_Synchro
            ' on avance d'un cran l'état cassette
            EtatK7 = EtatK7 + 1
        End If

        If EtatK7 > 600 Then
            'Ca y est : on peut envoyer des données, la synchro est terminée

            'Calcul du passage des blocs
            If Not (Start_TOL) And Not (Forth) Then
                'Nouveau Block => init compteur d'octets

                ' Les codes de TOL sont les suivants (Doc MONITRIX) :
                ' code FF => bloc de données en page PROG,
                '              Programmation : FF, destination, longueur, source
                '                    exemple : FF, 7000, 1000, 6000   Prendre 1000H octets en 6000 et les replacer en 7000.

                ' code FB => bloc de données en page VIDEO

                ' Bloc FD => Fin de fichier !
                '              PRogrammation : FD,départ, pile, 0
                '                    exemple : FD, 7000, 9000, 0  Fin avec saut (7000) et pile (9000)

                ' code FE = remplissage d'une zone avec une constante :
                '             Programmation :  FE, adresse, longueur,valeur 
                '                    exemple : FE,6000,1000,0055 : Remplir la zone 6000 - 6FFF avec la constante 55
                '
                ' Sur la cassette c'est idem, on retrouve les codes de TOL :
                ' En fait les 5 premiers octets c'est la longueur des data de la TOL, ainsi que l'adresse :
                ' longueur BLOC = Data(Pointeur_octet + 0) 'usuellement une TOL fait 5 octets
                '          Adr0 = Data(Pointeur_octet + 1)
                '          Adr1 = Data(Pointeur_octet + 2)
                '          Lon0 = Data(Pointeur_octet + 3)
                '          Lon1 = Data(Pointeur_octet + 4)
                '      code_TOL = Data(Pointeur_octet + 5)

                ' Suite à la lecture des octets 1+5 octets décrivant la TOL, viennent les bloc de données :
                '         Taille data = Data(Pointeur_octet + 0) => donne le nombre de données devant arriver : 
                '              data 1 = Data(Pointeur_octet + 1)
                '              data 2 = Data(Pointeur_octet + 2)...
                '              data n = Data(Pointeur_octet + n)
                '     
                'Si la taille du bloc de données = 1 => 1 octet à lire, 2 => 2 octets à lire ... 
                ' 255 => 255 octets à lire et 0 ... => 256 octets à lire ... oui oui, on est bien sur un système 8 bits !

                ' ce qui donne, par exemple, en début de cassette FORMULE1 : 
                ' 05 00 40 A0 09 FE 01 00 05 DB 5F 02 00 FF…
                ' => 3 blocs : 
                ' Le premier avec L= 05, code FE (à la fin) : fait un remplissage de l’écran (4000 @ écran BR, 9A0 : taille écran BR) avec l'octet du
                ' bloc de données suivant :
                ' Le 2eme Bloc L=01 paramètre = 00 (1 octet de donnée :0) est l'octet à mettre dans l'écran réclamé par le bloc FE...

                ' Le troisième bloc : avec le code de données (FF à la fin) sur 5 octets : à l'adresse 5FDB longueur de 0002 octets qui sera suivi d'un
                ' bloc de data d'une longueur de 2 !... Si la longueur était plus grande (supérieur à 256 octets) il y aura alors plusieurs bloc
                ' de données de 256 puis le dernier avec le modulo nécessaire.. 

                ' c'est donc entre le 2eme et le 3eme bloc qu'il faut ajouter des synchros de façon à ce qu'hector puisse faire le remplissage de la
                ' mémoire écran sur une longueur de 9A0 octets. Il me semble (de mémoire) que j'ajoutais 400 cycles de synchro.
                If Pointeur_Octet + 5 >= bK7.Length Then
                    MsgBox("La cassette a été entirement lue ! " & vbCrLf & " Veuillez rembobiner.", vbOKOnly And MsgBoxStyle.Critical, "K7 au bout ! ")
                    EtatK7 = 0
                    Return -1
                End If

                ' on récupére la longueur du bloc courant
                If bK7(Pointeur_Octet) <> 0 Then
                    Taille_Bloc = bK7(Pointeur_Octet) + 1
                Else
                    Taille_Bloc = 257
                End If

                'pour mémooire en debug sur Hector :
                ' Pour suivre les octets : breakpoint = 02FE sur Hector
                ' pour suivre les bit : breakpoint = 02C5 sur Hector

                ' Si la longueur de la TOL = 5, c'est surement un bloc de commande, mais c'est certain si le bloc précédent est fini !
                If bK7(Pointeur_Octet) = 5 And Longueur = 0 Then
                    ' Récupération des info de la TOL
                    If bK7.Length > Pointeur_Octet + 5 Then
                        Code_TOL = bK7(Pointeur_Octet + 5)
                    Else
                        Code_TOL = 0
                    End If

                    Adresse = bK7(Pointeur_Octet + 2) * 256 + bK7(Pointeur_Octet + 1)
                    Longueur = bK7(Pointeur_Octet + 4) * 256 + bK7(Pointeur_Octet + 3)
                    'Pour debug Affichage des données de bloc
                    Liste_Bloc = Liste_Bloc + vbCrLf + "Code TOL :" + Hex(Code_TOL) + " Adresse =" + Hex(Adresse) + " Longueur =" + Hex(Longueur) + vbCrLf
                Else
                    'Sinon c'est des data...
                    Liste_Bloc = Liste_Bloc + " Data L:" + Hex(bK7(Pointeur_Octet))

                    ' Calcul du restant à charger en données
                    Select Case Code_TOL
                        Case &HFF, &HFB
                            If bK7(Pointeur_Octet) > 0 Then
                                Longueur = Longueur - bK7(Pointeur_Octet)
                            Else
                                Longueur = Longueur - 256
                            End If
                        Case &HFE, &HFD
                            Longueur = 0
                        Case Else
                            ' si il y a des code TOL que j'oubli, c'est pas grave !
                            Longueur = 0
                    End Select
                End If

                ' Récupération des info de la TOL
                Taille_Bloc_Init = Taille_Bloc

                'Pour debug Affichage des données de bloc
                Start_TOL = True
            End If  'Not start_tol dans le cas des k7 classiques!

            'Calcul du passage des bloc en cas de cassette FORTH
            If Not (Start_TOL) And Forth Then
                'Nouveau Block => init compteur d'octets

                ' Ici c'est beaucoup plus simple :
                ' Les blocs font 822 octets de longueur
                ' et c'est fixe !
                Taille_Bloc = 822

                'Taille d'un screen 21 * 38 = 798 octets
                '                                 + commentaire ! 

                'Pour debug Affichage des données de bloc
                Liste_Bloc = Liste_Bloc + vbCrLf + "Ecran N°" + (Nb_Bloc + 1).ToString + " Longueur = 822 octets"

                ' Récupération des info de la TOL
                Taille_Bloc_Init = Taille_Bloc

                'Suppression des null dans les fichiers FORTH...
                Do While bK7(Pointeur_Octet) = 0
                    Pointeur_Octet += 1
                    If Pointeur_Octet >= bK7.Length Then
                        MsgBox("La cassette a été entirement lue ! ", vbOKOnly And MsgBoxStyle.Critical, "K7 au bout ! ")
                        EtatK7 = 0
                        Return -1
                    End If
                Loop

                Start_TOL = True
            End If  'Not start_tol, cas du FORTH !

            ' **************************************
            ' Lancement de l'expédition des bits...
            ' **************************************
            'recupération octet courant, seulement pour le 1er bit à envoyer
            If Pointeur_Bit = 0 Then
                Octet = bK7(Pointeur_Octet)
            End If

            'récupération du bit courant... dans l'octet courant !
            If ((Octet And &H1) <> 0) Then
                '    Calcul du temps de bit à 1 :
                CK_signal = CK_signal + Tps_Ba1
            Else
                'Calcul du temps de bit à 0 :
                CK_signal = CK_signal + Tps_Ba0
            End If

            'Pour la suite : 
            Octet = (Octet >> 1)         ' décalage octet courant

            ' Nouvelle version : on détruit plus la K7 lors de la lecture pour pouvoir rembobiner !
            '  bK7(Pointeur_Octet) = Octet  ' Mise en place octet courant décalé !

            Pointeur_Bit += 1            ' comptage des bits déjà passé

            If Pointeur_Bit >= 8 Then
                Pointeur_Bit = 0
                Pointeur_Octet += 1
                Taille_Bloc -= 1

                If Taille_Bloc <= 0 Then
                    'Fin du bloc courant
                    Start_TOL = False
                    Nb_Bloc += 1

                    'Insertion de Synchro entre les blocs
                    If Code_TOL <> &HFE Then
                        EtatK7 = 596 '4 Synchro suffisent si début TOL
                    Else
                        EtatK7 = 520 ' Dans les autres cas, un peu plus
                    End If

                    ' cas spécifique du FORTH, dans tous les cas il faut bien de la synchro  
                    If Taille_Bloc_Init = 822 Then
                        EtatK7 = 10 ' Spécifique pour le FORTH, ici les blocs ont besoin d'une reel synchro!
                    End If

                End If
            End If

            If Pointeur_Octet >= LenghtK7 Then
                'C'est fini !
                EtatK7 = 0
                Liste_Bloc = Liste_Bloc + vbCrLf + vbCrLf + "Nombre de bloc de donnés lus :" + (Nb_Bloc + 1).ToString
            End If
        End If

        If EtatK7 = 600 Then
            'Fin des cycles de synchro
            EtatK7 = EtatK7 + 1 ''Hé merde ...faillait pas l'oublier !
            Pointeur_Bit = 0
            Start_TOL = False
        End If

        ' ...FLip flop du bit X7 !
        If Flip_Flop = 0 Then
            Flip_Flop = &H80
        Else
            Flip_Flop = 0
        End If

        'Limitation du compteur à 7F
        CK_signal = CK_signal And &H7F

        'mise en place résultat ! OUF !
        Lecture_Port = CK_signal + Flip_Flop

    End Function

End Class
