﻿
'Copyright © 2016 Jean-Jacques STACINO
' author mail : jj.stac @ aliceadsl.fr


'This program is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    This program is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with this program.  If not, see <http://www.gnu.org/licenses/>.


' This file is part of VBHector.

'    VBHector is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    Foobar is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with VBHector.  If not, see <http://www.gnu.org/licenses/>.

' Several part such as modZ80, modAY8912 are from GPL project (VBSpec)
'   Tranlation from VB6 to VBNet and much more had been made.
'   Thanks' to them authors (Chris Cowley, Xavier) 
'   Note that the original files from Chris Cowley are joined to this project (Directory "Sources Licences" . 
' Emulation of the MEA8000 is from A.Mine, that I want to thank here for him's agreement.



Option Explicit On
Option Strict On

'Passage au Strict le 01/11/2013
' Fin Write Track (pour Format) 3/11/2013
Public Module WD1793

    ' Création du WD1793, contrôleur de disquette pour le 
    ' lecteur Mini disque
    ' Débuté le 9/10/2013 (création du squelette)
    ' 1er CATALOGUE l3/10, 1er lancement de BASIC3X et FORMULE1 : 20/10/2013.
    ' Il est encore necessaire d'améliorer le code, notement la gestion des flags status...


    ' Données d'une disquette 
    Public Fd(2 * 69 * 10 * 512) As Byte ' 2 faces,80 pistes, 10 secteurs, 512 octets/secteur au maxi

    'Registre
    Dim Status As Byte

    'Décalage pour les info STATUS  commande type I
    Dim NOT_READY As Byte = 7
    Dim PROTECT As Byte = 6
    Dim HEAD_LOADED As Byte = 5
    Dim SEEK_ERROR As Byte = 4
    Dim CRC_ERROR As Byte = 3
    Dim TRACK_00 As Byte = 2
    Dim INDEX As Byte = 1
    Dim BUSY As Byte = 0

    'Décalage pour les info STATUS Commande type II & III
    '  Dim Not_Ready As Byte = 7
    Dim WRITE_PPROTECT As Byte = 6
    Dim RECORD_TYPE As Byte = 5
    Dim WRITE_FAULT As Byte = 5
    Dim RECORD_NOT_FOUND As Byte = 4
    '  Dim CRC_Error As Byte = 3
    Dim LOST_DATA As Byte = 2
    Dim DRQ As Byte = 1
    '  Dim Busy As Byte = 0

    ' Pour le debug
    Public Strg_FdC1793 As String = "Test FdC WD1793" & vbCrLf

    'Liste des commandes disponibles
    Dim _ERROR As Byte = 0
    Dim _RESTORE As Byte = 1
    Dim _SEEK As Byte = 2
    Dim _STEP As Byte = 3
    Dim _STEPIN As Byte = 4
    Dim _STEPOUT As Byte = 5
    Dim _READSECTOR As Byte = 6
    Dim _WRITESECTOR As Byte = 7
    Dim _READADR As Byte = 8
    Dim _READTRACK As Byte = 9
    Dim _WRITETRACK As Byte = 10
    Dim _FORCEINT As Byte = 11


    ' Etat du WD
    Dim Actual_Face As Byte
    Dim Octet As Integer
    Dim Actual_Commande As Byte
    Dim Actual_Step_Direction As Boolean 'true si inc
    Dim Track_Status As Byte ' Permet d'aiguiller dans les phases de travail des Write / Read Track

    'Registre du WD
    Dim R_Data As Byte
    Dim R_Track As Byte
    Dim R_Sector As Byte


    Private Function Adresse(ByRef Face As Byte, ByRef Piste As Byte, ByRef Secteur As Byte, ByRef octet As Integer) As Integer

        ' Ici on fixe la structure une bonne fois pour toutes: 

        ' pour les disquettes HMD (confirmé par la doc mini-drive)
        ' Face = 0 ou 1 
        ' Piste = 0 à 68 pour Hector
        ' Secteur = 1 à 9 pour Hector (c'est comme cela !)
        ' Octet = 0 à 511 

        ' 1 piste contient = 4 608 octets (512*9)
        ' 1 face contient =  317 952  octets (4 608 * 69)
        ' 2 faces contiennent = 635 904 octets

        Adresse = Face * 4608 + Piste * 9216 + (Secteur - 1) * 512 + octet
    End Function

    Private Function Is_Bit(ByRef Octet As Byte, ByVal Rang As Byte) As Boolean
        'Helper function : is bit set ?
        Dim Temp As Byte
        Temp = Octet >> Rang
        If ((Temp And 1) = 1) Then
            Is_Bit = True
        Else
            Is_Bit = False
        End If

    End Function
    Private Sub Put_Bit(ByRef Octet As Byte, ByVal Rang As Byte, ByVal State As Boolean)
        ' Helper Sub : SET / RESET Bit
        Dim Temp As Byte

        Temp = CByte(1 << Rang)
        If State Then
            Octet = Octet Or Temp
        Else
            Temp = Not (Temp)
            Octet = Octet And Temp
        End If
    End Sub
    Public Sub Init_WD()
        ' Etat du uPD init
        ' Actual_Face = 0
        R_Track = 0
        R_Sector = 1
        R_Data = 0
        R_Track = 0
        R_Sector = 1
        Octet = 0
        Actual_Commande = _ERROR
        Actual_Step_Direction = True ' il faut bien commencer...
    End Sub

    ' Sub d'écriture dans les ports du WD1793 (par le Z80)
    Public Sub wd17xx_command_w(ByVal Cmd As Byte)

        If Demande_Trace_FD Then Strg_FdC1793 += "Commande = " & MainForm.Caractere_hex(CInt(Cmd)) & vbCrLf

        'Decorticage de la fonction demandée...
        If (Cmd And &HF0) = &HD0 Then
            ' Commande FORCE INTERRUPT, la seule cmmande sans necessaire de voir le BUSY
            Actual_Commande = _FORCEINT

        End If

        'Sortie de la procédure si me WD n'est pas ok pour recevoir des commandes
        If Is_Bit(Status, BUSY) Then Exit Sub

        If (Cmd And &HF0) = &H0 Then
            ' Commande restore
            Actual_Commande = _RESTORE
            RestoreCmd()
            If Demande_Trace_FD Then Strg_FdC1793 += "RESTORE => Octet " & Octet & ", Track " & R_Track & ", Sector " & R_Sector & vbCrLf

        End If

        If (Cmd And &HF0) = &H10 Then
            Actual_Commande = _SEEK
            Seek()
        End If

        If (Cmd And &HE0) = &H20 Then
            Actual_Commande = _STEP
            StepCmd(Cmd)
        End If

        If (Cmd And &HE0) = &H40 Then
            Actual_Commande = _STEPIN
            StepSens(1) ' vers track 76
            '       MsgBox("Commande non implanté : Step IN", MsgBoxStyle.Critical & MsgBoxResult.Abort, "Oups...")
            ' ReadCmd(Cmd)
        End If

        If (Cmd And &HE0) = &H60 Then
            Actual_Commande = _STEPOUT
            StepSens(0) ' vers track 00
        End If

        If (Cmd And &HE0) = &H80 Then
            Actual_Commande = _READSECTOR
            ReadCmd(Cmd)
        End If

        If (Cmd And &HE0) = &HA0 Then
            Actual_Commande = _WRITESECTOR
            WriteCmd(Cmd)
        End If

        If (Cmd And &HE0) = &HC0 Then
            Actual_Commande = _READADR
            MsgBox("Commande non implanté : Read Adress", CType(MsgBoxStyle.Critical And MsgBoxResult.Abort, MsgBoxStyle), "Oups...")
        End If

        If (Cmd And &HF0) = &HE0 Then
            Actual_Commande = _READTRACK
            MsgBox("Commande non implanté : Read Track", CType(MsgBoxStyle.Critical And MsgBoxResult.Abort, MsgBoxStyle), "Oups...")
        End If

        If (Cmd And &HF0) = &HF0 Then
            Actual_Commande = _WRITETRACK
            WriteTrack()
        End If

    End Sub

    Public Sub wd17xx_Side_Select(ByVal Face As Byte)
        Actual_Face = Face
    End Sub

    ' Exécution des commandes recues dans le registre
    Private Sub WriteTrack()
        'Commande Write track : ecrit tous les secteurs d'une piste donnée dans les paramétres à suivre...
        Track_Status = 0
        Octet = 0
        Status = 0
        Put_Bit(Status, BUSY, True)
        Put_Bit(Status, DRQ, True)

        Put_Bit(Status, HEAD_LOADED, True)
        If (R_Track = 0) Then
            Put_Bit(Status, TRACK_00, True)
        Else
            Put_Bit(Status, TRACK_00, False)
        End If
    End Sub
    Private Sub WriteCmd(ByRef Cmd As Byte)
        Octet = 0
        R_Sector = R_Sector
        R_Track = R_Track

        Status = 0
        Put_Bit(Status, BUSY, True)
        Put_Bit(Status, DRQ, True)

        Put_Bit(Status, HEAD_LOADED, True)
        If (R_Track = 0) Then
            Put_Bit(Status, TRACK_00, True)
        Else
            Put_Bit(Status, TRACK_00, False)
        End If
    End Sub
    Private Sub ReadCmd(ByRef Cmd As Byte)
        Octet = 0
        R_Sector = R_Sector
        R_Track = R_Track

        Status = 0
        Put_Bit(Status, BUSY, True)
        Put_Bit(Status, DRQ, True)

        Put_Bit(Status, HEAD_LOADED, True)
        If (R_Track = 0) Then
            Put_Bit(Status, TRACK_00, True)
        Else
            Put_Bit(Status, TRACK_00, False)
        End If
    End Sub
    Private Sub RestoreCmd()
        Init_WD()
        Status = 0
        Octet = 0
        Put_Bit(Status, DRQ, True)

        'Fin de la commande
        Actual_Commande = _ERROR
    End Sub
    Private Sub Seek()
        'Mise en place de la piste demandée si ok
        R_Track = R_Data
        If R_Track < 69 Then
            Actual_Step_Direction = R_Track < R_Track 'true si inc 
            R_Track = R_Track
            Status = 0
            Put_Bit(Status, TRACK_00, R_Track = 0)
            Put_Bit(Status, DRQ, True)
        Else
            Actual_Commande = 0
            Status = 0
            Put_Bit(Status, SEEK_ERROR, True)
            Put_Bit(Status, DRQ, True)
        End If
        'Fin de la commande
        Actual_Commande = _ERROR
    End Sub
    Private Sub StepSens(ByVal Sens As Byte)
        'Implantation de stein et stepout !

        'Mise en place de la piste demandée si ok
        If Sens = 1 Then
            'Sens INCREMENTATION
            R_Track = CByte(R_Track + 1)
            If R_Track < 69 Then
                Actual_Step_Direction = R_Track < R_Track 'true si inc 
                R_Track = R_Track
                Status = 0
                Put_Bit(Status, TRACK_00, R_Track = 0)
                Put_Bit(Status, DRQ, True)
            Else
                Actual_Commande = 0
                Status = 0
                Put_Bit(Status, SEEK_ERROR, True)
                Put_Bit(Status, DRQ, True)
            End If


        Else
            'Sens DECREMENTATION
            R_Track = CByte(R_Track - 1)
            If R_Track > 0 Then
                Actual_Step_Direction = R_Track < R_Track 'true si inc 
                R_Track = R_Track
                Status = 0
                Put_Bit(Status, TRACK_00, R_Track = 0)
                Put_Bit(Status, DRQ, True)
            Else
                Actual_Commande = 0
                Status = 0
                Put_Bit(Status, SEEK_ERROR, True)
                Put_Bit(Status, DRQ, True)
            End If

        End If
        If Demande_Trace_FD Then Strg_FdC1793 += "Step IN/OUT " & Sens & " (1= vers 68, 0 vers 0), ->Track :" & R_Track & vbCrLf

        'Fin de la commande
        Actual_Commande = _ERROR
    End Sub
    Private Sub StepCmd(ByVal Cmd As Byte)
        Dim Seek_Err As Boolean = False

        'Mise en place de la piste demandée si ok
        If Actual_Step_Direction Then
            'on est en incrémentation
            If R_Track + 1 < 69 Then
                R_Track = CByte(R_Track + 1)
                Seek_Err = False
            Else
                Actual_Commande = 0
                Seek_Err = True
            End If

        Else
            'On est en décrementation
            If R_Track - 1 >= 0 Then
                R_Track = CByte(R_Track - 1)
                Seek_Err = False
            Else
                Actual_Commande = 0
                Seek_Err = True
            End If
        End If

        If (Cmd And &H10) = &H10 Then
            'T demande de mise à jour registre
            R_Track = R_Track
        End If

        ' Mise en place du STATUS
        Status = 0
        Put_Bit(Status, TRACK_00, R_Track = 0)
        Put_Bit(Status, SEEK_ERROR, Seek_Err)
        Put_Bit(Status, DRQ, True)
        'Fin de la commande
        Actual_Commande = _ERROR
    End Sub
    Public Sub wd17xx_track_w(ByVal Value As Byte)

        If Demande_Trace_FD Then Strg_FdC1793 += "Set Track = " & Value & vbCrLf

        R_Track = Value
    End Sub
    Public Sub wd17xx_sector_w(ByVal Value As Byte)

        If Demande_Trace_FD Then Strg_FdC1793 += "Set Sector = " & Value & vbCrLf

        R_Sector = Value
    End Sub
    Public Sub wd17xx_data_w(ByVal Value As Byte)
        Static Current_octet_Sector As Integer
        Static Current_Sector As Integer

        'Mémorisation au cas ou il s'agirait d'un futur SEEK
        R_Data = Value

        'selon état de la commande en cours, on a des reponses différentes !

        If Actual_Commande = _WRITESECTOR Then
            ' On est en commande WRITE SECTOR
            Fd(Adresse(Actual_Face, R_Track, R_Sector, Octet)) = Value
            'On écrit l'octet courant (même si c'était le dernier)
            If Demande_Trace_FD Then Strg_FdC1793 += "Ecriture data " & Octet & " = " & MainForm.Caractere_hex(CInt(Value)) & vbCrLf
            Octet = Octet + 1
            ' On est en commande WRITE SECTOR
        End If

        If Actual_Commande = _WRITETRACK Then
            ' On est en commande WRITE TRACK

            ' Phase 2 : Ecritures de données recues dans le secteur prédéterminé
            If Track_Status = 2 Then
                If Current_octet_Sector < 512 Then
                    Fd(Adresse(Actual_Face, R_Track, R_Sector, Current_octet_Sector)) = Value   'Mise en place !

                    If (Demande_Trace_FD And Current_octet_Sector = 0) Then Strg_FdC1793 += "@ " & Current_octet_Sector & " => dans disquette! F=" & Actual_Face & " T=" & R_Track & " S=" & R_Sector & " v=" & Value & vbCrLf
                End If

                Current_octet_Sector += 1

                If Current_octet_Sector >= 512 + 54 + 1 Then  'Terminaison 1 octet + 54 synchro 4E!
                    Current_Sector = Current_Sector + 1
                    Octet = -1
                    ' Auto Debug
                    '         If Current_Sector = 3 Then
                    '  MainForm.Debuggage = True
                    '  End If
                    'Si on a terminer la piste en cours => phase 4 pour le status
                    If Current_Sector > 9 Then
                        Track_Status = 4
                    Else
                        'Sinon on recommence la phase 1...
                        Track_Status = 1
                    End If
                End If
            End If

            ' Phase 1 : Lecture du TRK_9 pour déterminer que quelle secteur on écrit
            If Track_Status = 1 Then

                ' On est dans la phase ou le hote (Z80) envoi
                ' les données structurant la piste...
                ' on y trouve la piste, le nombre de secteur.
                ' Ici  je simplifie de façon à ne formater qu'un 
                ' seul type de disquettes.
                ' Pas de hack possible...
                ' Suppression des préambules et postambules

                If Octet = 18 Then
                    ' ici c'est le secteur qui est donné.On le memorise pour l'écriture du secteur
                    R_Sector = Value
                End If

                If Octet >= 58 Then
                    'Fin du TRK_9 => phase suivante : écriture de la piste !
                    Track_Status = 2
                    Current_octet_Sector = 0
                    Octet = 0
                    ' Fin du TRK 9
                    ' Fin de la commande !
                End If
            End If

            ' Initialisation de la commande avec le TRK_FIL
            If Track_Status = 0 Then
                ' On est dans la phase ou le hote (Z80) envoi
                ' Les données structurant la piste...
                ' on y trouve la densité, le nombre de secteur.
                ' Ici  je simplifie de façon à ne formater qu'un 
                ' seul type de disquettes.
                ' Pas de hack possible...

                If Octet >= 146 Then
                    'Fin du TRKFIL !
                    Track_Status = 1
                    Octet = 0
                    Current_Sector = 1 ' 1er secteur en cours
                End If
                ' On est en commande WRITE TRACK
            End If

            Octet = Octet + 1
        End If

    End Sub

    ' Fonction de lecture des ports du WD1793 (par le Z80)

    Public Function wd17xx_status_r(ByVal Value As Integer) As Byte
        ' Lecture Status WD     
        If ((Actual_Commande = _READSECTOR) Or (Actual_Commande = _WRITESECTOR)) Then
            'On est en cours de lecture
            If Octet > 511 Then
                'Tiens c'est la fin de la lecture
                'On rend la main
                Actual_Commande = _ERROR
                Status = 0
            End If
        End If

        If (Actual_Commande = _WRITETRACK) Then
            If (Track_Status = 4) Then
                'fin de la commande ! 
                'On rend la main
                Actual_Commande = _ERROR
                Status = 0
            End If
        End If
        '     If Demande_Trace_FD Then Strg_FdC1793 += "Lecture status = " & MainForm.Caractere_hex(CInt(Status)) & vbCrLf

        'Retour de la valeur !
        wd17xx_status_r = Status

    End Function
    Public Function wd17xx_track_r(ByVal Value As Integer) As Byte
        wd17xx_track_r = R_Track
    End Function
    Public Function wd17xx_sector_r(ByVal Value As Integer) As Byte
        wd17xx_sector_r = R_Sector
    End Function
    Public Function wd17xx_data_r(ByVal Value As Integer) As Byte
        wd17xx_data_r = 0

        'selon état de la commande en cours
        If Actual_Commande = _READSECTOR Then
            'On est en cours de lecture
            wd17xx_data_r = Fd(Adresse(Actual_Face, R_Track, R_Sector, Octet))
            'On renvoie l'octet courant (même si c'était le dernier)

            'On est en cours de lecture
        End If

        If Demande_Trace_FD Then Strg_FdC1793 += "Lecture data " & Octet & " = " & MainForm.Caractere_hex(CInt(wd17xx_data_r)) & vbCrLf
        Octet = Octet + 1

    End Function

End Module
