﻿
'Copyright © 2016 Jean-Jacques STACINO
' author mail : jj.stac @ aliceadsl.fr


'This program is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    This program is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with this program.  If not, see <http://www.gnu.org/licenses/>.


' This file is part of VBHector.

'    VBHector is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    Foobar is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with VBHector.  If not, see <http://www.gnu.org/licenses/>.

' Several part such as modZ80, modAY8912 are from GPL project (VBSpec)
'   Tranlation from VB6 to VBNet and much more had been made.
'   Thanks' to them authors (Chris Cowley, Xavier) 
'   Note that the original files from Chris Cowley are joined to this project (Directory "Sources Licences" . 
' Emulation of the MEA8000 is from A.Mine, that I want to thank here for him's agreement.

Imports System.IO

Public Class hmd_Main

    Dim hmd_name As String
    Dim Entire_File(2 * 9 * 512 * 70 - 1) As Byte   'Fichier HMD
    Dim K7(2 * 9 * 512 * 71) As Byte                'Fichier K7
    Dim longueurFichierK7 As Long                   'Nb byte dans le fichier K7
    Dim data(256) As Byte                           'Tampon lecture bloc K7
    Dim index_k7 As Integer                         'Pointeur sur le fichier K7
    Dim Long_Bloc As Integer                        'Longueur du bloc K7 courant
    Dim Dol(65536) As Byte                          'Chaine de DOL pour fichier K7 en cours, format disque !
    Dim Data_Disc(65536 * 5) As Byte                'Chaine pour Données fichier K7 en cours, format disque !
    Dim Pt_DOL As Integer                           ' pointeur courant de la DOL
    Dim Pt_DATA As Integer                          ' pointeur courant des DATA en cours 
    Dim Face_C, Piste_C, Sector_C, Offset_C As Integer  'position courante
    Dim NumFil As Byte                              ' N° du fichier courant
    Dim Nom_Fic As String                           'Nom du fichier à créer
    Dim Flag_video As Boolean                       ' donne l'état d'Hector (page prog / page vidéo) en cours sur la cassette

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonQuit.Click
        Me.Visible = False
    End Sub

    Private Function Position(ByRef Face As Integer, ByRef Piste As Integer, ByRef Sector As Integer, ByRef Octet As Integer)
        'transforme un position en offset dans fichier
        Position = Face * 512 * 9 + Piste * 512 * 9 * 2 + (Sector - 1) * 512 + Octet
    End Function

    Private Sub Affiche_data()
        Dim I, J, Face, Valeur, X As Integer
        Dim Ligne_hex, Ligne_asc As String

        LblFicHMD.Text = hmd_name

        'Gestion du Rich box d'affichage d'un secteur
        RichTextBox1.Clear()

        J = 0
        Ligne_hex = ""
        Ligne_asc = ""

        For I = Position(Val(TextBoxFace.Text), Val(TextBoxPiste.Text), Val(TextBoxSector.Text), 0) To Position(Val(TextBoxFace.Text), Val(TextBoxPiste.Text), Val(TextBoxSector.Text), 511)
            Ligne_hex = Ligne_hex + Caractere_hex(Entire_File(I)) + " "
            Ligne_asc = Ligne_asc + Caractere_char(Entire_File(I))
            J = J + 1

            If J = 16 Then
                RichTextBox1.Text = RichTextBox1.Text + Caractere_hex(I / 16 - 1) + "-" + Ligne_hex + " " + Ligne_asc + vbCrLf
                J = 0
                Ligne_hex = ""
                Ligne_asc = ""
            End If
        Next I


        'Affichage Directory
        RichTextBox2.Clear()

        For Face = 0 To 1
            If Face = 0 Then
                Add_Com(vbCrLf & "Directory disquette Face 0 :")
            Else
                Add_Com(vbCrLf & "Directory disquette Face 1 :")
            End If

            'Affichage nom de la face
            Add_Com(vbCrLf + "Nom disque: ")

            For J = 0 To 7
                RichTextBox2.Text = RichTextBox2.Text + Caractere_char(Entire_File(Position(Face, 0, 2, &H180 + J)))
            Next J
            Add_Com(vbCrLf)

            'affichage des noms de fichiers ainsi que de leurs longueurs sur disque
            For I = 0 To 52
                ' Calcul offset dans le secteur
                Valeur = I * 12
                If Valeur < &H100 Then
                    X = Entire_File(Position(Face, 0, 1, I * 12))
                Else
                    X = Entire_File(Position(Face, 0, 2, I * 12 - &H100))
                End If
                If X <> 0 Then
                    For J = 0 To 10
                        Valeur = I * 12 + J

                        If Valeur < &H100 Then
                            RichTextBox2.Text = RichTextBox2.Text + Caractere_char(Entire_File(Position(Face, 0, 1, I * 12 + J)))
                        Else
                            RichTextBox2.Text = RichTextBox2.Text + Caractere_char(Entire_File(Position(Face, 0, 2, I * 12 + J - &H100)))
                        End If

                        If J = 7 Then
                            RichTextBox2.Text = RichTextBox2.Text + "."
                        End If
                    Next J

                    RichTextBox2.Text = RichTextBox2.Text + " -> " + Str(512 * Taille(Face, &H35 - I)) + " octets" + vbLf
                End If
            Next


        Next Face

    End Sub

    Private Function Taille(ByVal Fac As Integer, ByRef Numfill As Byte) As Integer
        Dim i, Compte, value As Integer

        Compte = 0
        For i = 0 To 69 * 9 - 1
            value = Entire_File(Position(Fac, 0, 2, i + &H190))
            If value = Numfill Then
                Compte = Compte + 1
            End If
        Next i
        Taille = Compte
    End Function

    Private Sub ButtonOpen_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonOpen.Click

        openFileDialogueHMD.Filter = "Fichier disquette| *.hmd"
        openFileDialogueHMD.ShowDialog()
        hmd_name = openFileDialogueHMD.FileName

        FileOpen(1, hmd_name, OpenMode.Binary, OpenAccess.Read)

        Dim longu As Long
        longu = FileLen(hmd_name)
        ReDim Entire_File(longu - 1)
        FileGet(1, Entire_File)                 ' Lire entirement le fichier HMD
        FileClose(1)

        Affiche_data()

    End Sub

    Private Function Caractere_char(ByRef A As Byte) As String
        If A > 32 And A < Asc("z") Then
            Caractere_char = Chr(A)
        Else
            Caractere_char = "."
        End If
    End Function
    Private Function Caractere_hex(ByRef A As String) As String
        Caractere_hex = Microsoft.VisualBasic.Right("00" + Hex(A), 2)
    End Function
    Private Function Caractere_hex4(ByRef A As String) As String
        Caractere_hex4 = Microsoft.VisualBasic.Right("0000" + Hex(A), 4)
    End Function

    Private Sub Lecture_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Lecture.Click

        Dim Adr As Integer

        Adr = Position(Val(TextBoxFace.Text), Val(TextBoxPiste.Text), Val(TextBoxSector.Text), Val(TextBoxOffset.Text))
        Resultat.Text = Hex(Adr)
        Value.Text = Hex(Entire_File(Adr))
        Affiche_data()
    End Sub

    Private Sub ButtonK7_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonK7.Click
        Dim I, J As Integer
        Dim Ligne_hex, Ligne_asc As String
        Dim Message As String

        openFileDialogueHMD.Filter = "Fichier cassette| *.k7"
        openFileDialogueHMD.FileName = "basic3x_hrx.k7"
        If openFileDialogueHMD.ShowDialog() <> vbOK Then Exit Sub


        Dim fi As New FileInfo(openFileDialogueHMD.FileName)
        longueurFichierK7 = fi.Length

        ReDim K7(longueurFichierK7 - 1)

        FileOpen(1, openFileDialogueHMD.FileName, OpenMode.Binary, OpenAccess.Read)
        FileGet(1, K7)                            ' Lire entirement le fichier K7
        FileClose(1) ' Fermer.

        'Affichage contenu cassette
        RichTextBox3.Clear()

        'Init des variables
        J = 0
        Ligne_hex = ""
        Ligne_asc = ""
        Message = ""

        If longueurFichierK7 <> 0 Then
            For I = 0 To longueurFichierK7 - 1
                Ligne_hex = Ligne_hex + Caractere_hex(K7(I)) + " "
                Ligne_asc = Ligne_asc + Caractere_char(K7(I))
                J = J + 1

                If J = 16 Then
                    Message = Message + Caractere_hex4(I - 15) + "-" + Ligne_hex + vbCrLf '  + " " + Ligne_asc + vbCrLf
                    J = 0
                    Ligne_hex = ""
                    Ligne_asc = ""
                End If
            Next I
            If J <> 0 Then 'Affichage dernniere ligne si pas rond !
                Message = Message + Caractere_hex4(I - 15) + "-" + Ligne_hex + vbCrLf '  + " " + Ligne_asc + vbCrLf
            End If
            RichTextBox3.Text = Message
        End If
    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonNewHMD.Click
        Dim AA As New hmd_DialogNewDisc

        If AA.ShowDialog() <> vbOK Then Exit Sub

        'création d'une disquette vierge !
        For i = 0 To (2 * 9 * 512 * 70) - 1

            If (i < Position(0, 0, 3, &H200)) Or ((i >= Position(1, 0, 1, 0)) And (i <= Position(1, 0, 3, &H200))) Then
                'Null si data la zone systeme face 0 ou Face 1
                Entire_File(i) = 0
            Else
                'Format dans le cas contraire
                Entire_File(i) = &HE5
            End If
        Next

        'Décors planté !
        ' On met en place le systeme dans la FAT -- FACE 0
        Entire_File(Position(0, 0, 2, &H190)) = &H7F
        Entire_File(Position(0, 0, 2, &H191)) = &H7F
        Entire_File(Position(0, 0, 2, &H192)) = &H7F

        'Mise en place nom du disque
        For i = 1 To 8
            If i <= Len(AA.TextBoxF0.Text) Then
                Entire_File(Position(0, 0, 2, &H17F + i)) = Asc(Microsoft.VisualBasic.Mid(AA.TextBoxF0.Text, i, 1))
            End If
        Next

        ' On met en place le systeme dans la FAT -- FACE 1
        Entire_File(Position(1, 0, 2, &H190)) = &H7F
        Entire_File(Position(1, 0, 2, &H191)) = &H7F
        Entire_File(Position(1, 0, 2, &H192)) = &H7F

        'Mise en place nom du disque
        For i = 1 To 8
            If i <= Len(AA.TextBoxF1.Text) Then
                Entire_File(Position(1, 0, 2, &H17F + i)) = Asc(Microsoft.VisualBasic.Mid(AA.TextBoxF1.Text, i, 1))
            End If
        Next

        Affiche_data()

    End Sub

    Private Sub Button1_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        SaveFileDialogHMD.Filter = "Fichier disquette| *.hmd"
        SaveFileDialogHMD.FileName = openFileDialogueHMD.FileName

        If SaveFileDialogHMD.ShowDialog() <> vbOK Then Exit Sub

        FileOpen(1, SaveFileDialogHMD.FileName, OpenMode.Binary, OpenAccess.Write)
        FilePut(1, Entire_File)
        FileClose(1)
    End Sub

    Private Function Prend_Octet_K7() As Byte
        Prend_Octet_K7 = K7(index_k7)
        index_k7 = index_k7 + 1
    End Function

    Private Sub Lit_Bloc_K7()
        'Le premier octet c'est la longueur
        Long_Bloc = Prend_Octet_K7()
        If Long_Bloc = 0 Then Long_Bloc = 256
        For i = 1 To Long_Bloc
            data(i) = Prend_Octet_K7()
        Next
    End Sub

    Private Sub Ecrit_DOL(ByVal Code As Byte, ByVal ADR0 As Byte, ByVal ADR1 As Byte, ByVal LON0 As Byte, ByVal LON1 As Byte, ByVal VAL0 As Byte, ByVal FIN As Byte)
        'Mise en place code DOL
        Dol(Pt_DOL) = Code
        Pt_DOL = Pt_DOL + 1
        'Mise en place adresse
        Dol(Pt_DOL) = ADR0
        Pt_DOL = Pt_DOL + 1
        Dol(Pt_DOL) = ADR1
        Pt_DOL = Pt_DOL + 1
        'Mise en place longeur
        Dol(Pt_DOL) = LON0
        Pt_DOL = Pt_DOL + 1
        Dol(Pt_DOL) = LON1
        Pt_DOL = Pt_DOL + 1
        'Mise en place valeur
        Dol(Pt_DOL) = VAL0
        Pt_DOL = Pt_DOL + 1
        'Mise en place octet nul (généralement)
        Dol(Pt_DOL) = FIN
        Pt_DOL = Pt_DOL + 1
    End Sub

    Private Sub Ecrit_DATA(ByVal Taille As Integer, ByRef Bloc() As Byte)
        'sur la taille donnée, rangement du bloc transmis dans la zone DATA 
        For i = 1 To Taille
            Data_Disc(Pt_DATA) = Bloc(i)
            Pt_DATA = Pt_DATA + 1
        Next
    End Sub

    Private Sub Add_Com(ByVal Chaine As String)
        RichTextBox2.Text = RichTextBox2.Text + Chaine
    End Sub

    Private Sub Lit_K7()
        Dim Adr0, Adr1, Lon0, Lon1, Val0, Extra As Byte
        Dim Adresse As Integer
        Dim LData As Integer
        Dim Flag_change As Boolean

        Flag_change = False
        Flag_video = False

        ' Si on veux mettre en BR la machine au chargement => création d'une DOL en plus
        If CheckHector1.Checked Then
            Ecrit_DOL(&HF9, &H4, &H8, &H1, &H0, 1, 1) '  0x80c => base page, BR
        End If

        Do
            'Lecture d'un bloc de DOL
            Lit_Bloc_K7()

            If (index_k7 = 0) Then
                Add_Com("TOL Cassette :")
            End If
            Add_Com(vbCrLf)

            Add_Com(Caractere_hex4(index_k7 - 6))
            Add_Com("  ")
            Add_Com(Caractere_hex(data(Long_Bloc)))

            'Selon le code de la TOL, on met en place les données de la zone
            'dans les tableaux de DOL et DATA qui seront plus tard mis en place
            ' dans les secteurs de la disquette.
            If data(Long_Bloc) = &HFE Then
                ' code FE = remplissage d'une zone avec une constante
                Adr0 = data(1)
                Adr1 = data(2)
                Lon0 = data(3)
                Lon1 = data(4)

                'Bloc de remplissage classic ! 
                'on lit le bloc suivant qui va nous donner la valeur de remplissage (longueur = 1)
                Lit_Bloc_K7()
                If Long_Bloc <> 1 Then
                    'Si c'est pas le cas s'est une erreur !
                    MsgBox("Erreur 1")
                    Exit Sub
                End If
                Val0 = data(1)
                Extra = 0
                'Calcul adresse destination
                Adresse = Adr0 + 256 * Adr1

                'Si l'adresse de remplissage est dans la zone de changement de page VIDEO/PROGRAMME
                'il ne faut pas ecrire cela sur la DOL disquette mais mémoriser la page souhaitée 
                'pour ensuite demander avec des codes différents soit le remplissage ou le transfert
                'de données dans la bonne page (à l'aide de codes différents dans la DOL) chose que ne permettait
                'pas la TOL de la cassette !
                If Adresse = &H800 Then 'changement de page => vidéo
                    Flag_video = True
                    Flag_change = True
                End If

                If Adresse = &H808 Then 'changement de page => programme
                    Flag_video = False
                    Flag_change = True
                End If

                ' F9 constante programme , F7 constante video
                If Not (Flag_video) And Not (Flag_change) Then         ' zone programme
                    Ecrit_DOL(&HF9, Adr0, Adr1, Lon0, Lon1, Val0, 0)
                End If

                'Ecriture de constante zone vidéo (uniquement si > 0x0C000) 
                If (Flag_video) And Not (Flag_change) Then
                    If Adresse >= &HC000 Then
                        Ecrit_DOL(&HF7, Adr0, Adr1, Lon0, Lon1, Val0, 0) 'zone vidéo uniquement si necessaire
                    Else
                        Ecrit_DOL(&HF9, Adr0, Adr1, Lon0, Lon1, Val0, 0) 'sinon zone programme
                    End If
                End If

                ' pas d'écriture de DOL si c'est pour écrire en zone de changement de page. 
                'La prochaine fois le Flag_vidéo indiquera la page à utiliser !
                Flag_change = False

            ElseIf data(Long_Bloc) = &HFD Then
                'Bloc FD => Fin de fichier ! 
                Adr0 = data(1)
                Adr1 = data(2)
                Lon0 = data(3)
                Lon1 = data(4)

                If (Adr0 <> 0) Or (Adr1 <> 0) Then  'S'il existe une adresse de lancement, place AUTORUN Flag !
                    Val0 = 1 'autorun...
                Else
                    Val0 = 0
                End If

                'Création de la DOL associée (le code FA de la TOL devient FA dans la DOL)
                Ecrit_DOL(&HFA, Lon0, Lon1, Adr0, Adr1, Val0, 0)


            ElseIf data(Long_Bloc) = &HFF Then
                ' code FF => bloc de données
                Adr0 = data(1)
                Adr1 = data(2)
                Lon0 = data(3)
                Lon1 = data(4)
                LData = Lon0 + 256 * Lon1
                Val0 = 0

                'Calcul adresse destination
                Adresse = Adr0 + 256 * Adr1

                Add_Com(Caractere_hex4(LData))

                ' F8 => Bloc vidéo,  FC => Bloc programme
                If Not (Flag_video) Then                        ' zone programme
                    Ecrit_DOL(&HFC, Adr0, Adr1, Lon0, Lon1, Val0, 0)
                End If
                If (Flag_video) Then                            ' zone video

                    If Adresse >= &HC000 Then
                        Ecrit_DOL(&HF8, Adr0, Adr1, Lon0, Lon1, Val0, 0) 'zone vidéo uniquement si necessaire
                    Else
                        Ecrit_DOL(&HFC, Adr0, Adr1, Lon0, Lon1, Val0, 0) 'sinon zone programme
                    End If

                End If

                'Après avoir lu la TOL, maintenant c'est au tour des bloc de
                'données dont la longeur total à charger est donnée dans la TOL
                Do
                    'Lecture d'un bloc de donnée
                    Lit_Bloc_K7()

                    If Long_Bloc = 0 Then
                        Long_Bloc = 256 'hector compte en octet, alors on triche !
                    End If

                    'Affichage des blocs dans le TextBox
                    Add_Com("-") ' longueur bloc de données en cours
                    Add_Com(Caractere_hex(Long_Bloc))

                    'Calcul du restant 
                    LData = LData - Long_Bloc

                    'mise en place en zone de données Disc
                    Ecrit_DATA(Long_Bloc, data)

                    'on boucle tant que l'ensemble des données n'a pas été chargé !
                Loop While (LData > 0)

            Else
                'code inconnu ! 

            End If

            'et on boucle sur l'ensemble du fichier
        Loop While (longueurFichierK7 > index_k7)
    End Sub

    Private Sub cherche_secteur()
        'On cherche le secteur suivant disponible dans la table d'allocation
        'et dés que l'on a trouvé on le reserve et on laisse les pointeurs 
        'Sector_C, Piste_C remis à jour
        Do
            'Secteur suivant
            Sector_C = Sector_C + 1
            If Sector_C > 9 Then
                'Saut de piste
                Sector_C = 1
                Piste_C = Piste_C + 1
                If Piste_C > 69 Then
                    'Aie, toutes les pistes ont été vues => disquette pleine
                    MsgBox("Plus de place dans la disquette ! ")
                    End
                End If
            End If
            'Test de disponibilité du secteur
        Loop Until Entire_File(Position(Face_C, 0, 2, Piste_C * 9 + Sector_C + &H18F)) = 0
        'reservation du secteur !
        Entire_File(Position(Face_C, 0, 2, Piste_C * 9 + Sector_C + &H18F)) = NumFil
    End Sub

    Private Sub Ecrit_octet(ByVal Value As Byte)

        'Mise en place valeur courante
        Entire_File(Position(Face_C, Piste_C, Sector_C, Offset_C)) = Value

        Offset_C = Offset_C + 1 'pointeur octet suivant
        If Offset_C >= &H200 Then
            'Si le secteur est plein, on va chercher le suivant
            Offset_C = 0
            cherche_secteur() 'cherche prochain secteur dispo
        End If

    End Sub

    Private Sub Met_Nom()
        Dim I, J As Integer
        Dim Num As Byte
        Dim Off As Integer
        Dim Valeur As Byte

        'Recherche une place dispo dans la zone de nom dans la FAT
        I = -1

        Do
            I = I + 1
            Off = I * 12
            If Off < &H100 Then
                Num = Entire_File(Position(Face_C, 0, 1, Off))  ' attention sur 2 secteurs 
            Else
                Num = Entire_File(Position(Face_C, 0, 2, Off - &H100))  ' attention sur 2 secteurs 
            End If
        Loop Until (I >= 52 Or Num = 0)

        If Num <> 0 Then
            MsgBox("pas de place pour un nom sur cette face ")
            End
        End If

        'Calcul de l'index du fichier
        NumFil = &H35 - I

        'mise en place du nom dans la FAT
        For J = 0 To 10
            Off = I * 12 + J

            'Valeur a y mettre : Nom du fichier entre 1 et 11 et NULL sur 12eme octet !
            If J <> 11 Then
                Valeur = Asc(Microsoft.VisualBasic.Mid(Nom_Fic, J + 1, 1))
                If Valeur = 32 Then Valeur = 0

            Else
                Valeur = 0
            End If
            If Off < &H100 Then

                Entire_File(Position(Face_C, 0, 1, Off)) = Valeur
            Else
                Entire_File(Position(Face_C, 0, 2, Off - &H100)) = Valeur
            End If
        Next

    End Sub

    Private Sub Ecrit_Disc()
        'INIT des pointeurs de FAT pour mise en place fichier
        Piste_C = 0
        Sector_C = 0
        Offset_C = 0

        cherche_secteur()

        'Ecriture de la DOL
        For i = 0 To Pt_DOL - 2
            Ecrit_octet(Dol(i))
        Next

        'Ecriture des DATA
        For i = 0 To Pt_DATA
            Ecrit_octet(Data_Disc(i))
        Next

    End Sub

    Private Sub ButtonMEP_K7_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonMEP_K7.Click
        'Mise en place d'un fichier K7 dans la disquette
        Dim AA As New hmd_DialogMEPK7

        If AA.ShowDialog() <> vbOK Then Exit Sub

        If AA.RadioFace0.Checked Then
            Face_C = 0
        Else
            Face_C = 1
        End If

        Nom_Fic = Microsoft.VisualBasic.Left(AA.TextNom.Text + "        ", 8)
        Nom_Fic = Nom_Fic + Microsoft.VisualBasic.Left(AA.TextExt.Text + "   ", 3)

        NumFil = 0 ' pour l'instant on RAZ
        index_k7 = 0 ' tous les index
        Pt_DOL = 0
        Pt_DATA = 0


        Met_Nom()

        Lit_K7()
        Ecrit_Disc()
    End Sub

    Private Sub hmd_Main_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        'Mise en place des ascenseurs
        Me.AutoScroll = MainForm.AscenseurSurFrameToolStripMenuItem.Checked

    End Sub
End Class
