
'Copyright  2016 Jean-Jacques STACINO
' author mail : jj.stac @ aliceadsl.fr


'This program is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    This program is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with this program.  If not, see <http://www.gnu.org/licenses/>.


' This file is part of VBHector.

'    VBHector is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    Foobar is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with VBHector.  If not, see <http://www.gnu.org/licenses/>.

' Several part such as modZ80, modAY8912 are from GPL project (VBSpec)
'   Tranlation from VB6 to VBNet and much more had been made.
'   Thanks' to them authors (Chris Cowley, Xavier) 
'   Note that the original files from Chris Cowley are joined to this project (Directory "Sources Licences" . 
' Emulation of the MEA8000 is from A.Mine, that I want to thank here for him's agreement.

Option Explicit On
'Option Strict On

Imports System
Imports System.Runtime.InteropServices


' Yo_fr (jj.stac @ aliceadsl.fr)
' Le 20/12/2012 !
' Ce code est libre d'utilisation et de diffusion (sous licence GPL V3), nanmoins si vous utilisez mon code,
' merci de m'envoyer un petit mail !
' Si vous amliorez / corrigez des bug, merci de me le renvoyer la correction !

' This code is free to use and distribute (under GPL V3 licence), however if you use my code thank you send me a mail!
' If you improve / correct the bug, thank you for returning it to me!



Public Module Hector
 
    'Implantation des fonctions lies  Hector :
    '  * Gestion mmoire,
    '  * Gestion des ports
    '  * Gestions des banks mmoires
    '  * Gestion de l'affichage
    ' Yo_fr  JJ.stac@aliceadsl.fr

    ' Juin 2016 : Mise en place d'une muation du AY8912, qui aurait t ncessaire  Hector plutot que du SN76477...
    '             Utilisation des ports 2 (N de registre  accder) et 0 (data pour le registre). 

    '  Memoire
    ' Les emplacements de la RAM et des 3 ROM du MX40 / MX80
    Public mem_P0(65535) As Byte 'Integer
    Public mem_P1(16384) As Byte 'Integer
    Public mem_P2(16384) As Byte 'Integer

    ' La mmoire Vido
    Public mem_H(65535) As Byte 'Integer 'HRX et suprieur

    ' Gestion des Bank mmoires (ROM et VIDEO)
    Public ActivRomPage As Integer
    Public ActivVideoPage As Integer

    'Port du 8255 
    Public PortA_8255 As Byte
    Public PortB_8255 As Byte
    Public PortCl_8255 As Byte
    Public PortCh_8255 As Byte

    ' Imprimante
    Public Taille_Imp As Long = 1000
    Public Imp(Taille_Imp) As Char
    Public Pt_Imp As Long  'pointeur sur le fichier de l'imprimante

    ' Keyboard memory
    Public keyboard(8) As Integer
    Public State3000 As Integer 'Registre gnral d'I/O (son, K7,Joystick)

    ' Cassette enregistre
    Public WAVEOUT(100000000) As Short  ' En esprant que cela soit suffisant !
    Public K7OUT(100000000) As Byte ' En esprant que cela soit suffisant !

    Public Enregistre_WAV As Boolean = False
    Public Enregistre_K7 As Boolean = False
    Dim Enregistre_en_cours As Boolean = False
    Dim Position_Enregistre As Integer
    Public Son_K7 As Integer = 0

    Const Phase_ON As Short = 16300  ' Valeurs dans le wave 
    Const Phase_OFF As Short = -16300
    Public SON_WAVEOUT As Short      ' pour le HP
  
    'AY Stuff
    Public AYSoundRegister As Long  ' // Contains currently indexed AY-3-8912 sound register

    ' Video Stuff
    Public Structure RGBColor
        Dim R As Byte
        Dim G As Byte
        Dim B As Byte
    End Structure

    ' Gestion des couleurs
    Dim Palette As System.Drawing.Imaging.ColorPalette
    Dim Base_Color(16) As RGBColor
    Public colors(4) As RGBColor 'Tableau des Teintes
    Public Half_Tone As Boolean 'Demi teinte sur C2
    Public colors_0_2 As Integer

    ' Stuff d'cran
    Public Screen As Bitmap  'BMP pour affichage
    Public Resolution As Integer
    Public gcBufferBits(225 * 240 * 2) As Byte 'contient les bits de l'cran, jusqu' la trs haute rsolution

    ' Pour le son sn76477
    '  Dim SN76477 As _sn76477_state 'Fonctions d'acce  la mmoire d'Hector
    Public Table_Pin_Value(29, 1) As Double
    Public m_AU(17) As Boolean
    Public m_ValMixer As Integer
    Dim m_CK_signal As Byte = 0

    Public m_Pot0, m_Pot1 As Byte


    Public Function MemR(ByRef Adr As Integer) As Integer
        Dim Value, State As Integer

        If (Adr >= &H10000) Or (Adr < 0) Then
            ' Bug...
            ' on relance alors la machine !
            MainForm.Proc.regPC = 0
            Adr = 0
        End If

        'De base on met la mmoire Page 0, ensuite on rcrit si ncessaire...
        MemR = mem_P0(Adr)
        If Adr < &H4000 Then
            ' Attention on est dans la ROM
            'Il faut choisir la bonne et aiguiller selon les points d'E/S d'Hector

            If ((Adr >= &H3800) And (Adr <= &H3807)) Then
                ' IO Machine...
                ' Seul keyboard est document et donc on quitte !
                MemR = keyboard(Adr - &H3800)
                Exit Function
            End If

            If (Adr = &H3000) Then
                ' Gestion du mot compteur HARD en 3000
                m_CK_signal += 1
                If m_CK_signal > &H7F Then m_CK_signal = 0


                ' IO Machine...Lecture cassette vs lecture port  et fire !
                State = Hector.State3000 And &H38
                If ((State) <> &H38) Then ' Or (EtatK7 = 0)
                    'Selon l'tat de State3000 prcdement crit par Hector, on repond :
                    Select Case State

                        Case &H8
                            'Cas du bouton FIRE 1 !
                            If (MainForm.m_Action And 1) <> 0 Then
                                Value = 0
                            Else
                                Value = &H80
                            End If
                            Exit Select
                        Case &H10
                            Value = m_pot0

                        Case &H20
                            'Cas du bouton FIRE 0 !
                            If (MainForm.m_Action And 2) <> 0 Then
                                Value = 0
                            Else
                                Value = &H80
                            End If
                            Exit Select
                        Case &H28
                            Value = m_pot1
                        Case Else
                            'Autre,improbable, cas (vu : &h10 18 28 30) 18 et 30 inconnu ! 
                            Value = 0
                    End Select

                    'On range la rponse
                    MemR = Value
                    Exit Function 'puis sortie !
                Else
                    'Gestion de la K7 !
                    'Deux cas : on enregistre ou on lit ! j'ai pas trouv mieux que de demande  l'oprateur...
                    If Not (Enregistre_WAV Or Enregistre_K7) Then
                        MemR = MainForm.Magneto.Lecture_Port()
                        Son_K7 = MemR
                    Else
                        MemR = m_CK_signal
                    End If
                End If
                Exit Function 'puis sortie !
            End If  'Fin du 3000

            'Dans les autres cas (pas IO Machine...) on re root les ROM selon la page courante
            If ActivRomPage = 1 Then
                MemR = mem_P1(Adr)
            ElseIf ActivRomPage = 2 Then
                MemR = mem_P2(Adr)
            End If
        End If
        If Adr >= &HC000 Then
            ' L c'est la RAM Vido qui est pagine !
            If ActivVideoPage = 1 Then
                MemR = mem_H(Adr)
            End If
        End If

    End Function

    Public Sub MemW(ByRef Adr As Integer, ByRef Value As Byte)

        If Adr < &H4000 Then
            ' Attention on est dans la ROM
            ' On essaye d'crire en ROM 
            ' C'est donc la gestion des I/O !
            IO_Machine(Adr, Value)
            'Dans tous les cas pas de modification de la ROM !
            Exit Sub
        End If

        If (Adr >= &HC000) And (ActivVideoPage = 1) Then
            'L c'est la RAM Pagine !
            mem_H(Adr) = Value
        Else
            mem_P0(Adr) = Value
        End If

    End Sub

    'Gestion des ports
    Sub IO_Machine(ByRef Adr As Integer, ByRef Value As Byte)
        Static Old_Value As Byte = 0
        Static m_CK_old As Byte = 0

        Select Case Adr
            ' Analyse du 11/2016
            '  0x800 => video page, HR
            '  0x804 => video page, HR
            '  0x808 => video page, HR
            '  0x80C => video page, HR

            Case &H800
                '  0x800 => video page, HR
                ActivVideoPage = 1
                If MainForm.Choix <> MainForm.MX80 Then
                    '     Resolution = 1
                End If
                Exit Select
            Case &H0
                '  0x800 et 0x000=> video page
                ActivVideoPage = 1
                If MainForm.Choix <> MainForm.MX80 Then
                    ' Je ne trouve plus le fondement de cette mise en HR lors d'une criture sur 0000
                    ' Par contre sur un jeu BR a plantait car il passait en HR et le jeu se deroulait (son audible)
                    ' Jeu : sous marin !
                    '  Resolution = 1
                End If
                Exit Select
            Case &H804
                ' 0x804 => video page, BR
                ActivVideoPage = 1
                If MainForm.Choix <> MainForm.MX80 Then
                    Resolution = 0
                End If
                Exit Select
            Case &H808
                '0x808 => base page, HR
                ActivVideoPage = 0
                If MainForm.Choix <> MainForm.MX80 Then
                    Resolution = 1
                End If
                Exit Select
            Case &H80C
                '0x80c => base page, BR
                ActivVideoPage = 0
                If MainForm.Choix <> MainForm.MX80 Then
                    Resolution = 0
                End If
                Exit Select
            Case &H1000
                ' Color C0/C1 
                'Mmorisation de la valeur des couleurs pour la gestion Half tone
                colors_0_2 = Value

                If Half_Tone Then ' choix selon la Halft tone de la couleur dans les tables pres documentes
                    colors(2) = Base_Color(((colors_0_2 >> 3) And &H7) + 8)
                Else
                    colors(2) = Base_Color(((colors_0_2 >> 3) And &H7))
                End If

                'Pour la couleur 0, pas de Half tone.
                colors(0) = Base_Color(Value And &H7)

                'Etat du moteur du magntophone
                MainForm.Magneto.MotorON = (Value And &H40) <> 0

                ' Si arrt du moteur K7 alors que l'on enregistrait => c'est donc la fin !
                If (((Value And &H40) = 0) And Enregistre_en_cours) Then
                    ' Fin d'un enregistrement !
                    'On raz tout
                    Enregistre_en_cours = False
                    If Enregistre_WAV Then
                        'Et on sauve le WAVE...
                        Enregistrement_Wave()
                    Else
                        Enregistrement_K7()
                    End If
                End If

                ' Si marche du moteur K7 et que l'on est en enregistrement et qu'il n'est pas encore lanc !
                If (((Value And &H40) <> 0) And (Enregistre_WAV Or Enregistre_K7) And Not (Enregistre_en_cours)) Then
                    ' debut d'un enregistrement !
                    'On raz tout
                    Enregistre_en_cours = True
                    Position_Enregistre = 0
                    If Enregistre_WAV Then
                        ReDim WAVEOUT(100000000)
                    Else
                        ReDim K7OUT(100000000)
                    End If

                End If

                ' Bit 7 : Bit d'criture de la cassette
                If (Value And &H80) <> (Old_Value And &H80) Then
                    Dim Time As Integer

                    ' Le bit de cassette  chang !
                    If (m_CK_signal < m_CK_old) Then
                        Time = &H7F - m_CK_old + m_CK_signal
                    Else
                        Time = m_CK_signal - m_CK_old
                    End If

                    ' Pour le prochain coup
                    m_CK_old = m_CK_signal 'cela nous donnera le temps de flip/flop

                    ' Mise place valeur courante
                    ' Deux cas WAV ou K7 ?
                    If Enregistre_WAV Then
                        Remplir_bit_WAVE((Value And &H80) <> 0, Time) 'on sauve l'tat.
                    Else
                        Remplir_bit_K7((Value And &H80) <> 0, Time)
                    End If
                End If
                Old_Value = Value ' pour le prochain coup

            Case &H1800
                ' Color C2/C3
                colors(3) = Base_Color((Value >> 3) And &H7)
                colors(1) = Base_Color(Value And &H7)
                'Gestion de la demi luminosit sur la couleur 2
                If (Value And &H40) <> 0 Then
                    Half_Tone = True
                Else
                    Half_Tone = False
                End If
                'Remise en place couleur 2 (si on a changer le BRIGHT)
                If Half_Tone Then
                    colors(2) = Base_Color(((colors_0_2 >> 3) And &H7) + 8)
                Else
                    colors(2) = Base_Color(((colors_0_2 >> 3) And &H7))
                End If
                ' Gestion du son
                MainForm.Bit_Son = (Value And &H80) = 0

            Case &H2000 To &H2003
                ' => Ecriture buffer sound
                Mise_A_Jour_Etat(Adr, Value)
                Exit Sub
            Case &H2800 To &H2803
                ' => Ecriture buffer sound
                Mise_A_Jour_Etat(Adr, Value)
                Exit Sub
            Case &H3000
                '0x3000 => Ecriture cassette et general info (potentio-metre et fire)
                State3000 = Value And &HF8 '  except bit 0 to 2
                Mise_A_Jour_Etat(Adr, CByte((Value And 7)))
                Exit Sub
            Case &H3800 To &H3807
                '0x3000 => Ecriture buffer clavier
                ' Ici ce n'est pas necessaire pour faire fonctionner la
                ' matrice  diode du clavier
                '     RowClavier = Adr
                Exit Sub
            Case Else
                'Rien de plus ?
                ' Non, vraiment rien de plus !
        End Select

    End Sub

    'Gestion des critures de cassettes (Soit au format WAV soit en format binaire K7)
    Private Sub Remplir_bit_WAVE(ByVal State As Boolean, ByVal Time As Integer)
        Dim i, NBLoop As Integer
        Dim Tail As Long
        ' Time est bas sur le nombre de m_CK_Signal 
        ' qui lui est en 15765 hz
        ' Le wave est en 44100 hz
        ' soit 44100 / 15765 chantillons pour 1 pulse => 2,797335870599429 chantillons
        Tail = Time * 2.7973358705994289
        NBLoop = Tail ' Transformation Temps processeur => nombre d'enregistrement dans le WAVE
        If State Then
            SON_WAVEOUT = Phase_ON    ' phase etat ON
        Else
            SON_WAVEOUT = Phase_OFF   ' phase etat OFF
        End If

        For i = 1 To NBLoop
            WAVEOUT(Position_Enregistre) = SON_WAVEOUT
            'on monte le pointeur courant dans les donnes du WAV
            Position_Enregistre += 1
        Next
    End Sub
    Private Sub Remplir_bit_K7(ByVal State As Boolean, ByVal Time As Integer)
        
        Static Pointeur_Bit As Byte = 0
        Static Octet_courant As Byte = 0
        Static flag_once As Boolean = False

        Dim octet As Byte = 0
        Dim Flag As Boolean = False


        ' Time est bas sur le nombre de m_CK_Signal 
        ' qui lui est en 15765 hz
        ' Le wave est en 44100 hz
        ' soit 44100 / 15765 chantillons pour 1 pulse => 2,797335870599429 chantillons
        If Not (State) Then

            ' Selon le timming, on effectue la travail
            Select Case Time
                Case Is > 15
                    ' Rien  faire c'est du synchro !
                    Exit Select
                Case Is > 10
                    ' C'est un 1
                    Flag = True
                    octet = 2 ^ (Pointeur_Bit)
                    Exit Select
                Case Is > 2
                    ' c'est un 0
                    Flag = True
                    octet = 0
                    Exit Select
                Case Else
                    'Thoriquement rien ici !
            End Select

            'Uniquement si on a quelque chose  ecrire !
            If Flag And flag_once Then
                Octet_courant = Octet_courant Or octet
                Pointeur_Bit += 1

                If Pointeur_Bit > 7 Then
                    K7OUT(Position_Enregistre) = Octet_courant
                    'Et on relance la machine !
                    Octet_courant = 0
                    Pointeur_Bit = 0

                    'on monte le pointeur courant dans les donnes du K7
                    Position_Enregistre += 1
                End If
            End If
            flag_once = True
        End If
    End Sub

    ' Fonction d'enregistrement de cassettes
    Sub Enregistrement_Wave()
        Dim a As New SaveFileDialog

        a.Title = "Choisisez un fichier pour l'enregistrement du WAVE"
        a.Filter = "WAV File|*.wav"
        a.ShowDialog()

        If a.FileName = "" Then Exit Sub 'Pas de sauvegarde !

        ' WAVE !
        '13 champs a remplir
        Dim F1 As String = "RIFF"     ' RIFF-BlockIdentifyer
        Dim F2 As Integer             ' RIFF-BlockLength = Total Bytes minus 8
        Dim F3 As String = "WAVE"     ' identifyer
        Dim F4 As String = "fmt "     ' fmtBlock-identifyer
        Dim F5 As Integer = 16        ' fmtBlock-length , 16 voor PCMformat
        Dim F6 As Short = 1           ' 1 for PCM classic not compressed
        Dim F7 As Short               ' Number of channels (1=mono  2=stereo)
        Dim F8 As Integer             ' SamplingFreq
        Dim F9 As Integer             ' Bytes per second = BytesPerSample * SampleRate
        Dim F10 As Short              ' Bytes by sample = MS * BitR / 8
        Dim F11 As Short              ' bitResolution 
        Dim F12 As String = "data"    ' dataBlock-identifyer
        Dim F13 As Integer            ' dataBlock-length, inclusief de laste NUL-char. 

        Dim SRate As Integer = 44100 ' sample frequence
        Dim BitR As Short = 16       ' resolution en bits
        Dim MS As Short = 1          ' nombre de canaux (1=mono, 2=stereo)

        Dim dFile As String
        Dim No_D As Integer

        dFile = a.FileName

        '-----prepare headerfields --------
        F1 = "RIFF"
        F2 = F2                      ' not set yet 
        F3 = F3                      ' already set
        F4 = F4                      ' already set  
        F5 = 16                      ' fmtBlockLength
        F6 = 1                       ' 1=PCM classic, not compressed
        F7 = MS                      ' 1=mono, 2=stereo  
        F8 = SRate                   ' samplingRate(Frequency)
        F9 = MS * SRate * (BitR / 8) ' total number of bytes per sec
        F10 = MS * (BitR / 8)        ' BlockAlign
        F11 = BitR                   ' bits per sample ( resolution )
        F12 = "data"                 ' "data"
        F13 = MS * (Position_Enregistre + 5) * 2 ' dataBlock-length 
        F2 = F13 + 44 - 8            ' RiffBlock-length

        If Dir(dFile) <> "" Then Kill(dFile)
        No_D = FreeFile()
        FileOpen(No_D, dFile, OpenMode.Binary)


        ' sauvegarde du header fichier RIFF
        FilePut(No_D, F1)    '  4 bytes
        FilePut(No_D, F2)    '  4 b
        FilePut(No_D, F3)    '  4 b
        FilePut(No_D, F4)    '  4 b
        FilePut(No_D, F5)    '  4 b
        FilePut(No_D, F6)    '  2 b
        FilePut(No_D, F7)    '  2 b
        FilePut(No_D, F8)    '  4 b
        FilePut(No_D, F9)    '  4 b
        FilePut(No_D, F10)   '  2 b
        FilePut(No_D, F11)   '  2 b
        FilePut(No_D, F12)   '  4 b
        FilePut(No_D, F13)   '  4 b 

        'On rajuste la taille du buffer au juste necessaire
        ReDim Preserve WAVEOUT(Position_Enregistre + 10)

        'sauvegarde des donnes chunck
        FilePut(No_D, WAVEOUT)

        'On libre le fichier...
        FileClose(No_D)

    End Sub
    Sub Enregistrement_K7()
        Dim a As New SaveFileDialog
 
        a.Title = "Choisisez un fichier pour l'enregistrement du fichier K7"
        a.Filter = "Cassette classique|*.K7|Cassette FORTH|*.FOR"

        a.ShowDialog() 'choix du fichier

        If a.FileName = "" Then Exit Sub 'Pas de sauvegarde !

        ' K7 !
        Dim dFile As String
        Dim No_D As Integer

        dFile = a.FileName

        If Dir(dFile) <> "" Then Kill(dFile)
        No_D = FreeFile()
        FileOpen(No_D, dFile, OpenMode.Binary)


        ' pas de sauvegarde du header fichier dans le K7 !
        'On rajuste la taille du buffer au juste necessaire (necessaire pour MESS)
        ReDim Preserve K7OUT(Position_Enregistre - 1)

         FilePut(No_D, K7OUT)

        'On libre le fichier...
        FileClose(No_D)

    End Sub

    Sub outb(ByVal Port As Integer, ByVal outbyte As Byte, Optional ByVal tstates As Integer = 0)
        'On masque le port qui de toutes faon est en 8 bits...
        Port = Port And &HFF
        If Port < 240 Then
            Port = Port

        End If
        Select Case Port

            'pour le AY8912
            Case 0
                AYWriteReg(AYSoundRegister, outbyte)
                If MainForm.Debug_AY Then
                    MainForm.Affiche_Debug_AY()
                End If

                Exit Select
            Case 2
                AYSoundRegister = outbyte And &HF
                If MainForm.Debug_AY Then
                    MainForm.Affiche_Debug_AY()
                End If

                Exit Select
                ' minidisc floppy disc interface
            Case &H4
                If MainForm.Choix = MainForm.MD Then
                    wd17xx_command_w(outbyte)
                End If
                Exit Select
            Case &H5
                If MainForm.Choix = MainForm.MD Then
                    wd17xx_track_w(outbyte)
                End If
                Exit Select
            Case &H6
                If MainForm.Choix = MainForm.MD Then
                    wd17xx_sector_w(outbyte)
                End If
                Exit Select
            Case &H7
                If MainForm.Choix = MainForm.MD Then
                    '	write into command register
                    wd17xx_data_w(outbyte)
                End If
                Exit Select


            Case &H8
                If MainForm.Choix = MainForm.MD Then

                    '	General purpose port (0x08) for the minidisk I/O */
                    If ((outbyte And 32) = 32) Then
                        ' Rom page bank switching  
                        ActivRomPage = 0
                    Else
                        ActivRomPage = 1
                    End If

                    If ((outbyte And 16) = 16) Then
                        ' Rom page bank switching  
                        wd17xx_Side_Select(1)
                    Else
                        wd17xx_Side_Select(0)
                    End If
                End If
                Exit Select

            Case &H40
                'Passage en Page 0
                ActivRomPage = 0
                Exit Select
            Case &H41
                'Passage en Page 1
                ActivRomPage = 1
                Resolution = 1
                Exit Select
            Case &H42
                If MainForm.Choix = MainForm.MX80 Then
                    'Passage en Page 1
                    ActivRomPage = 2
                End If
                Exit Select
            Case &H44
                If MainForm.Choix = MainForm.MX40 Or MainForm.Choix = MainForm.ARD Then
                    'Passage en Page 2
                    ActivRomPage = 2 ' uniquement sur le MX80 !
                End If
                Exit Select
            Case &H49, &H4B
                'Passage en Page 2
                If MainForm.Choix = MainForm.MX80 Then
                    Resolution = 2 ' Pour le 80c uniquement !
                End If
                Exit Select

            Case &HE0
                ' Envoi de donnes au MEA8000
                mea8000_w(outbyte, 0)
                Exit Select
            Case &HE1
                ' Envoi de donnes au MEA8000
                mea8000_w(outbyte, 1)
                Exit Select
                ' Gestion du 8255
                ' ici j'ai simplifi : Le 8255 est paramtrable port A/B en octet entre ou en sortie,
                ' port C en quartet en entre ou en sortie,
                ' Dans Hector le 8255 n'est programm que en mode 0 avec :
                ' Port A (port F0) : Sortie,
                ' Port B (port F1) : entre,
                ' Port C (port F2) poids fort : entre
                ' Port C (port F2) poids faible : sortie
                ' Port de commande ((port F3) : paramtrage du 8255.
                ' 
                ' L'ensembles des fonctionnalites du 8255 ne sont pas programmes, seul le paramtrage de base du 8255 est utile.
                ' en mode 0 :
                ' Mot de controle : (0 : Sortie 1; : entre)
                ' D0 = C inf (0 : Sortie; 1 : entre)
                ' D1 = B (0 : Sortie; 1 : entre) 
                ' D2 = 0 
                ' D3 = C sup (0 : Sortie; 1 : entre)
                ' D4 = A (0 : Sortie; 1 : entre)
                ' D5 /D6 : Mode 0,1 ou 2 en binaire
                ' D7 = utilisation mode de controle : 0 = mot de commande, 1 : emploi particulier (?)

                ' La valeur de paramtrage du port de commande doit tre de 8A...
            Case &HF0
                ' Port A
                ' Ici on envoi une donne vers le Disc 2 ou l'imprmante,
                PortA_8255 = outbyte
                If outbyte = 48 Then
                    '     MainForm.Debuggage = True
                End If
                If MainForm.Choix <> MainForm.ARD Then
                    ' criture de la donnes thoriquement dispo dans port A
                    Disc2.Disc2_data_read = PortA_8255
                Else
                    ' criture de la donnes thoriquement dispo dans port A
                    Arduino.Disc2_data_read = PortA_8255
                End If
                Exit Select
            Case &HF1
                ' Port B
                ' Thoriquement pas d'criture dans le port B !
                PortB_8255 = outbyte
                Exit Select
            Case &HF2
                'Port C du 8255

                'Seul le port Cl est en criture 
                PortCl_8255 = CByte(outbyte And &HF)

                ' Ici les bits du port Cl permettent de lire et crire les mmoires
                ' lectroniques  base de 74 374 qui se trouvent dans le Disc2
                ' 2 bit sont cris :   
                ' PC1 : valide la lecture dans le port B dans la donne disc2_data_write (et raz le flag associ)
                ' PC2 : valide l'criture du port A dans la donne disc2_data_read (et monte le flag associ)

        
                'On valide la lecture d'un octet en provenance du Disc 2 avec PC1
                If Not ((outbyte And &H2) <> 0) Then
                    If MainForm.Choix <> MainForm.ARD Then
                        'raz du flag !
                        Disc2.Disc2_data_w_ready = False
                    Else
                        'raz du flag !
                        Arduino.Disc2_data_w_ready = False
                    End If
                End If

                'On valide l'ecriture d'un octet vers Disc 2 avec PC2
                If Not ((outbyte And &H4) <> 0) Then
                    If MainForm.Choix <> MainForm.ARD Then
                        ' criture du bit indiquant au Disc2 qu'une donne est prte !
                        Disc2.Disc2_data_r_ready = True
                    Else
                        ' criture du bit indiquant au Disc2 qu'une donne est prte !
                        Arduino.Disc2_data_r_ready = True
                    End If
                End If
                Exit Select
            Case &HF3
                ' Port de commande => 8A !

                ' et lors d'une commande vers le Disc 2 : 2 et 3 sont vu !

                ' Pas implant !

                Exit Select
            Case &HFF
                'Imprimante
                If Not ((outbyte And &H1) <> 0) Then
                    Imp(Pt_Imp) = Chr(PortA_8255)
                    Pt_Imp += 1
                    If Pt_Imp > Taille_Imp Then
                        Taille_Imp += 1000
                        ReDim Preserve Imp(Taille_Imp)
                    End If
                End If
                Exit Select
            Case Else
                Exit Select
        End Select
    End Sub
    Function inb(ByVal port As Integer) As Integer
        Dim Val As Byte = 0
        ' Nothing yet implanted !

        port = port And &HFF

        Select Case port
            ' minidisc floppy disc interface */
            Case &H4
                If MainForm.Choix = MainForm.MD Then
                    Val = wd17xx_status_r(0)
                End If
                Exit Select

            Case &H5
                If MainForm.Choix = MainForm.MD Then
                    Val = wd17xx_track_r(0)
                End If
                Exit Select

            Case &H6
                If MainForm.Choix = MainForm.MD Then
                    Val = wd17xx_sector_r(0)
                End If
                Exit Select

            Case &H7
                If MainForm.Choix = MainForm.MD Then
                    Val = wd17xx_data_r(0)
                End If
                Exit Select

                ' Gestion MEA8000 
            Case &HE0
                ' Lecture registre MEA8000
                Val = mea8000_r(0)
                Exit Select
            Case &HE1
                ' Lecture registre MEA8000
                Val = mea8000_r(1)
                Exit Select


                ' Gestion du 8255 : voir outb
            Case &HF0
                ' Lecture Port A

                'pas de lecture (thoriquement)
                ' Nanmoins on peut renvoyer le contenu du port A...
                Val = PortA_8255
                Exit Select
            Case &HF1
                ' Lecture Port B
                If MainForm.Choix <> MainForm.MD Then
                    If MainForm.Choix <> MainForm.ARD Then
                        'Lecture de l'octet en provenance du Disc2 ET raz du flag !
                        PortB_8255 = Disc2.Disc2_data_write
                        Disc2.Disc2_data_w_ready = False
                    Else
                        'Lecture de l'octet en provenance de l'ARDUINO ET raz du flag !
                        PortB_8255 = Arduino.Disc2_data_write
                        Arduino.Disc2_data_w_ready = False
                    End If

                    Val = PortB_8255 ' Disc2 => Hector
                End If
                Exit Select
            Case &HF2
                ' Lecture Port C du 8255
                Val = CByte(PortCl_8255 And &HF) 'on rcupre l'tat du poids faible

                If MainForm.Choix <> MainForm.MD Then

                    ' Ici les bits du port Ch permettent de raliser les 
                    ' lecture les infos du Disc2 : 
                    ' disc2_data_write_ready lu dans PC4 et 
                    ' disc2_data_read_ready  lu dans PC5

                    If MainForm.Choix <> MainForm.ARD Then
                        ' PC4 indique qu'une donne en provenance du Disc2 est prete a te lue
                        If (Disc2.Disc2_data_w_ready) Then
                            Val = CByte(Val + &H10) ' PC4
                        End If

                        ' PC5 indique que la donne vers disc2 a t lue ou pas
                        If (Disc2.Disc2_data_r_ready) Then
                            Val = CByte(Val + &H20) 'PC5
                        End If
                    Else
                        ' PC4 indique qu'une donne en provenance de l'ARDUINO est prete a te lue
                        If (Arduino.Disc2_data_w_ready) Then
                            Val = CByte(Val + &H10) ' PC4
                        End If

                        ' PC5 indique que la donne vers l'ARDUINO a t lue ou pas
                        If (Arduino.Disc2_data_r_ready) Then
                            Val = CByte(Val + &H20) 'PC5
                        End If
                    End If
                End If
                    Exit Select
            Case &HF3
                    'port de commande = 8A !
                    'et lors d'une commande vers le Disc 2 : 2 et 3 sont vu !
                    Val = 0
                    ' Pas implant !
            Case &HFD
                inb = AYPSG.Regs(AYSoundRegister)
                Exit Select

            Case Else
                Exit Select
        End Select
        inb = Val
    End Function

    'Gestion de l'affichage
    Public Function CopyDataToBitmap(ByVal w As Integer, ByVal h As Integer, ByRef data() As Byte, ByRef f As System.Drawing.Imaging.PixelFormat) As Bitmap

        Dim bmp As Bitmap
        bmp = New Bitmap(w, h, f)
        Dim bmpData As New System.Drawing.Imaging.BitmapData

        ' Cration d'un bitmap pour la mise en place des pixels 
        bmpData = bmp.LockBits(
                             New Rectangle(0, 0, bmp.Width, bmp.Height),
                             System.Drawing.Imaging.ImageLockMode.WriteOnly, f)

        ' On recopie dans la zone des pixels du tableau de pixels pralablement prpar 
        Marshal.Copy(data, 0, bmpData.Scan0, CInt(w * h / 2)) '2 octets par pixel 

        bmp.UnlockBits(bmpData)

        'Retour avec le bitmap calcul
        Return bmp
    End Function
    Public Sub ScreenPaint()
        Dim x, y, i As Integer

        Dim Current_Octet As Integer
        Dim Pt_Buffer As Integer
        Dim ScreenValue0, ScreenValue1 As Byte

        'Remplissage du tableau de correspondant  l'image d'Hector.
        Pt_Buffer = 0
        'Choix du programme selon la rsolution courante d'Hector
        Select Case Resolution
            Case 2
                ' ici on est en 80c
                For y = &HC000 To &HF800 Step 64  ' 224*64 + C000 = F800
                    For x = 0 To 59
                        'Lecture de l'octet courant qui correspond  8 pixels !
                        Current_Octet = mem_H(x + y)

                        For i = 0 To 3
                            ' Calcul des 1 bit courant en poids faible pour allumage de la bonne couleur
                            ScreenValue0 = CByte((Current_Octet And &H1) << 1)      ' On rcupre l'etat du bit correspondant
                            Current_Octet = (Current_Octet And &HFFFE) >> 1  ' on tourne l'octet pour le prochain pixel
                            ScreenValue1 = CByte((Current_Octet And &H1) << 1)      ' et on recupre le suivant
                            Current_Octet = (Current_Octet And &HFFFE) >> 1
                            gcBufferBits(Pt_Buffer) = CByte(ScreenValue1 + ScreenValue0 * 16)  ' Puis mise en place dans le buffer pixel de l'tat
                            'Pixel suivant dans le buffer 
                            Pt_Buffer = Pt_Buffer + 1
                        Next
                    Next
                Next
                'Mise en place des bits dans un bitmap
                Screen = CopyDataToBitmap(240 * 2, 225, gcBufferBits, System.Drawing.Imaging.PixelFormat.Format4bppIndexed)
                Exit Select
            Case 1
                ' ici on est en HR
                For y = &HC000 To &HF800 Step 64  ' 224*64 + F800
                    For x = 0 To 59
                        'Lecture de l'octet courant qui correspond  4 pixels
                        Current_Octet = mem_H(x + y)

                        ' Calcul des 2 bits courant en poids faible pour allumage de la bonne couleur
                        ScreenValue0 = CByte(Current_Octet And &H3)
                        Current_Octet = (Current_Octet And &HFFFC) >> 2
                        ScreenValue1 = CByte(Current_Octet And &H3)
                        Current_Octet = (Current_Octet And &HFFFC) >> 2

                        gcBufferBits(Pt_Buffer) = CByte(ScreenValue1 + ScreenValue0 * 16)

                        ScreenValue0 = CByte(Current_Octet And &H3)
                        Current_Octet = (Current_Octet And &HFFFC) >> 2
                        ScreenValue1 = CByte(Current_Octet And &H3)

                        gcBufferBits(Pt_Buffer + 1) = CByte(ScreenValue1 + ScreenValue0 * 16)
                        'incrmentation pixel suivant
                        Pt_Buffer = Pt_Buffer + 2
                    Next
                Next
                'Mise en place des bits dans un bitmap
                Screen = CopyDataToBitmap(240, 225, gcBufferBits, System.Drawing.Imaging.PixelFormat.Format4bppIndexed)
                Exit Select
            Case Else
                ' sinon c'est de la BR
                For y = &H4000 To &H49A0 Step 32
                    For x = 0 To 27
                        'Lecture de l'octet courant qui correspond  4 pixels
                        Current_Octet = mem_P0(x + y)

                        ' Calcul des 2 bits courant en poids faible pour allumage de la bonne couleur
                        ScreenValue0 = CByte(Current_Octet And &H3)
                        Current_Octet = (Current_Octet And &HFFFC) >> 2
                        ScreenValue1 = CByte(Current_Octet And &H3)
                        Current_Octet = (Current_Octet And &HFFFC) >> 2

                        gcBufferBits(Pt_Buffer) = CByte(ScreenValue1 + ScreenValue0 * 16)

                        ScreenValue0 = CByte(Current_Octet And &H3)
                        Current_Octet = (Current_Octet And &HFFFC) >> 2
                        ScreenValue1 = CByte(Current_Octet And &H3)

                        gcBufferBits(Pt_Buffer + 1) = CByte(ScreenValue1 + ScreenValue0 * 16)
                        'incrmentation pixel suivant
                        Pt_Buffer = Pt_Buffer + 2
                    Next
                Next
                'Mise en place des bits dans un bitmap
                Screen = CopyDataToBitmap(112, 76, gcBufferBits, System.Drawing.Imaging.PixelFormat.Format4bppIndexed)

        End Select

        ' Mise en place de la bitmap dans le PictureBox affich sur la form
        Palette = Screen.Palette
        ' Mise en place des couleurs courante 
        Palette.Entries(0) = Color.FromArgb(255, colors(0).R, colors(0).G, colors(0).B)
        Palette.Entries(1) = Color.FromArgb(255, colors(1).R, colors(1).G, colors(1).B)
        Palette.Entries(2) = Color.FromArgb(255, colors(2).R, colors(2).G, colors(2).B)
        Palette.Entries(3) = Color.FromArgb(255, colors(3).R, colors(3).G, colors(3).B)

        Screen.Palette = Palette

        ' Lance le redraw !
        ' ce qui lancera le "hectorDisplay_Paint" dans MainForm !
        MainForm.hectorDisplay.Invalidate()



        '        Dim defaultDevice As New SharpDX.Direct3D11.Device(SharpDX.Direct3D.DriverType.Hardware, _
        '                                                           d3d.DeviceCreationFlags.VideoSupport _
        '                                                          Or d3d.DeviceCreationFlags.BgraSupport _
        '                                                         Or d3d.DeviceCreationFlags.None)  ' take out the Debug flag for better performance


        ' Dim bitmapRenderTarget As SharpDX.Direct2D1.Factory


        ' SharpDX.Direct2D1.BitmapRenderTarget(m_d2dRenderTarget, CompatibleRenderTargetOptions.None, New SharpDX.Direct2D1.PixelFormat(Format.B8G8R8A8_UNorm, AlphaMode.Premultiplied))
    End Sub

    Public Sub Init_Machine()
        ' Color initialisation : full lightning
        Base_Color(0).R = 0 'Noir
        Base_Color(0).G = 0
        Base_Color(0).B = 0

        Base_Color(1).R = 255 'Rouge
        Base_Color(1).G = 0
        Base_Color(1).B = 0

        Base_Color(2).R = 0 'Vert
        Base_Color(2).G = 255
        Base_Color(2).B = 0

        Base_Color(3).R = 255 'Jaune
        Base_Color(3).G = 255
        Base_Color(3).B = 0

        Base_Color(4).R = 0 'Bleu
        Base_Color(4).G = 0
        Base_Color(4).B = 255

        Base_Color(5).R = 255 'Magneta
        Base_Color(5).G = 0
        Base_Color(5).B = 255

        Base_Color(6).R = 0 'Cyan
        Base_Color(6).G = 255
        Base_Color(6).B = 255

        Base_Color(7).R = 255 'Blanc
        Base_Color(7).G = 255
        Base_Color(7).B = 255

        ' Half ligthning
        Base_Color(8).R = 0 'Noir
        Base_Color(8).G = 0
        Base_Color(8).B = 0


        Base_Color(9).R = 128 'Rouge
        Base_Color(9).G = 0
        Base_Color(9).B = 0

        Base_Color(10).R = 0 'Vert
        Base_Color(10).G = 128
        Base_Color(10).B = 0

        Base_Color(11).R = 128 'Jaune
        Base_Color(11).G = 128
        Base_Color(11).B = 0

        Base_Color(12).R = 0 'Bleu
        Base_Color(12).G = 0
        Base_Color(12).B = 128

        Base_Color(13).R = 128 ' Magneta
        Base_Color(13).G = 0
        Base_Color(13).B = 128

        Base_Color(14).R = 0 ' Cyan
        Base_Color(14).G = 128
        Base_Color(14).B = 128

        Base_Color(15).R = 128 ' Blanc
        Base_Color(15).G = 128
        Base_Color(15).B = 128


        ' ' Set colors and initialize display
        'Couleurs initiale (temporaire, Hector sait le faire...)
        colors(3) = Base_Color(7) '3
        colors(2) = Base_Color(7) '7
        colors(1) = Base_Color(7) '1
        colors(0) = Base_Color(0) '0

        Half_Tone = False

        ' mise en place des valeurs initiales keyboard
        keyboard(&H0) = &HFF
        keyboard(&H1) = &HFF
        keyboard(&H2) = &HFF
        keyboard(&H3) = &HFF
        keyboard(&H4) = &HFF
        keyboard(&H5) = &HFF
        keyboard(&H6) = &HFF
        keyboard(&H7) = &HFF

        ' Init de la partie sn76477
        Init_Value_SN76477_Hector()

        m_AU(14) = True
        ' on inhibe le sn...
        sn76477_enable_w(m_Pin_Value(9, 0))

        'Init du MEA 8000
        mea8000_init_tables()
        DEVICE_RESET_MEA8000()

    End Sub

    '*******************************************************************************
    '     sound managment SN76477
    '*******************************************************************************

    Public Sub Init_Value_SN76477_Hector()
        ' Remplissage des valeurs de resistance et capacite d'Hector
        ' sound(1.514) suivi de sound 1.515 fait un souffle suivi d'un decay!!!! sur hector reel

        ' Decay R
        ' ici 16/2/2016
        Table_Pin_Value(7, 1) = RES_K(180) '    680K // 180k  
        Table_Pin_Value(7, 0) = RES_K(142) ' 142.325 (680 ' 180KOhm)

        ' Capa A/D
        Table_Pin_Value(8, 0) = CAP_U(0.47)  '  0.47uf
        Table_Pin_Value(8, 1) = CAP_U(1.47)  ' 1.47uF

        ' ATTACK R
        Table_Pin_Value(10, 1) = RES_K(180) * 0.9  ' 180
        Table_Pin_Value(10, 0) = RES_K(32.054)     ' 32.054 (180 // 39 KOhm)

        ' Version 3 : Ajuste pour les frequences mesurees :
        ' 4  0 SOUND 255 Hz => ajuste a l'oreille
        ' 4  4 SOUND  65 Hz => ajuste a l'oreille
        ' 4  8 SOUND  17 Hz =>  ajuste a l'oreille
        ' 4 12 SOUND 4,3 Hz =>  ajuste a l'oreille

        'SLF C        Version 7/02/2016
        Table_Pin_Value(21, 0) = CAP_U(0.035) ' 0.01 
        Table_Pin_Value(21, 1) = CAP_U(0.9)   ' 1.01        ' 

        'SLF R        Version 3
        Table_Pin_Value(20, 1) = RES_K(300.0)  '180  
        Table_Pin_Value(20, 0) = RES_K(50) '    120


        ' Capa VCO
        ' Version 3 : Ajust pour les frequences mesures :
        ' 0 0  SOUND 5,5KHz => 5,1KHz   5080            
        ' 0 16 SOUND 1,3KHz => 1,2KHz   1210            Res=1
        ' 0 32 SOUND 580Hz  => 570Hz    560  CAPA=1
        ' 0 48 SOUND 132Hz  => 120Hz    130  CAPA=1     Res=1


        ' Mise en place suite mesure des valeurs dans Hector le 7/02/2016
        Table_Pin_Value(17, 1) = CAP_N(6.4 + 53)
        Table_Pin_Value(17, 0) = CAP_N(6.4)

        ' R VCO   Version 25/02/2016
        Table_Pin_Value(18, 1) = RES_K(500)
        Table_Pin_Value(18, 0) = RES_K(115)

        ' VCO Controle
        Table_Pin_Value(16, 0) = 0.33  ' Volts
        Table_Pin_Value(16, 1) = 1.48 ' 1.48  (2 =  10/15eme de 5V)

        ' Pitch
        Table_Pin_Value(19, 0) = 0.0   'Volts 
        Table_Pin_Value(19, 1) = 1.48

        Table_Pin_Value(22, 0) = 0 ' TOR 
        Table_Pin_Value(22, 1) = 1

        ' R OneShot - pin 24 not connected

        ' Capa OneShot - pin connected to tension 
        Table_Pin_Value(23, 0) = 0.0
        Table_Pin_Value(23, 1) = 5.0  ' Valeur reelle en volt car sur Hector c'est une mise au 5Volts sans capa

        ' Enabled
        Table_Pin_Value(9, 0) = 1
        Table_Pin_Value(9, 1) = 0

        ' Volume
        Table_Pin_Value(11, 0) = RES_K(100) ' Rapport 50% et 100%  128
        Table_Pin_Value(11, 1) = RES_K(75) '                      255

        ' Noise filter
        Table_Pin_Value(6, 0) = CAP_U(0.39)
        Table_Pin_Value(6, 1) = CAP_U(0.6)

        ' Valeur corrige par rapport au schema :
        Table_Pin_Value(5, 1) = RES_K(3.3)
        Table_Pin_Value(5, 0) = RES_K(1.76)

        ' Noise pas commande par le bus audio !
        ' Seule la valeur (0) est documentee !
        Table_Pin_Value(4, 0) = RES_K(47)        ' 47 K ohm
        Table_Pin_Value(12, 0) = RES_K(100)      ' 100K ohm
        Table_Pin_Value(3, 0) = 0                ' NC

        ' Gestion du type d'enveloppe
        Table_Pin_Value(1, 0) = 0
        Table_Pin_Value(1, 1) = 1

        Table_Pin_Value(28, 0) = 0
        Table_Pin_Value(28, 1) = 1

        ' Initialisation a 0 des pin du SN
        m_AU(0) = False
        m_AU(1) = False
        m_AU(2) = False
        m_AU(3) = False
        m_AU(4) = False
        m_AU(5) = False
        m_AU(6) = False
        m_AU(7) = False
        m_AU(8) = False
        m_AU(9) = False
        m_AU(10) = False
        m_AU(11) = False
        m_AU(12) = False
        m_AU(13) = False
        m_AU(14) = False
        m_AU(15) = False
        m_ValMixer = 0

        'Initialisation des paramtres du SN...
        SN76477.sample_rate = MainForm.SampleRate
        'Voltage pour le SLF => interne ! (avec capa et rsistance)
        sn76477_slf_cap_voltage_w(-1.0) ' disconnected => innternal avec la capacit !
        'Voltage pour le A/D => interne ! (avec capa et rsistance)
        sn76477_attack_decay_cap_voltage_w(-1.0) ' disconnected => internal avec la capacit !

        ' on inhibe le sn...
        sn76477_enable_w(m_Pin_Value(9, False))
    End Sub

    'Permet de lire la Table_Pin_Value avec un boolean 
    Function m_Pin_Value(ByRef Pin_Number As Integer, ByVal State As Boolean)
        If (State) Then
            m_Pin_Value = Table_Pin_Value(Pin_Number, 1)
        Else
            m_Pin_Value = Table_Pin_Value(Pin_Number, 0)
        End If
    End Function

    Public Sub Update_Sound()

        ' MIXER
        sn76477_mixer_a_w((m_ValMixer And 4) >> 2)
        sn76477_mixer_b_w((m_ValMixer And 1))
        sn76477_mixer_c_w((m_ValMixer And 2) >> 1) ' Revu selon mesure electronique sur HRX

        ' VCO oscillateur
        If (m_AU(12)) Then
            sn76477_vco_res_w(m_Pin_Value(18, m_AU(10))) ' en non AU11
        Else
            sn76477_vco_res_w(m_Pin_Value(18, m_AU(10))) ' en non AU11
        End If
        ' info VCO
        sn76477_vco_cap_w(m_Pin_Value(17, m_AU(2)))
        sn76477_pitch_voltage_w(m_Pin_Value(19, m_AU(15)))
        sn76477_vco_voltage_w(m_Pin_Value(16, m_AU(15)))
        sn76477_vco_w(CUInt(m_Pin_Value(22, m_AU(12)))) ' VCO Select Ext/SLF

        ' info SLF
        sn76477_slf_res_w(m_Pin_Value(20, m_AU(9))) 'AU10
        sn76477_slf_cap_w(m_Pin_Value(21, m_AU(1)))

        ' info One Shot
        sn76477_one_shot_cap_voltage_w(m_Pin_Value(23, m_AU(13))) ' disconnected VS internal avec la capacit => ici c'est disconnected et on pilote directement la tension !

        ' Ampli value
        sn76477_amplitude_res_w(m_Pin_Value(11, m_AU(5)))

        ' Attack / Decay
        sn76477_attack_res_w(m_Pin_Value(10, m_AU(8)))
        sn76477_decay_res_w(m_Pin_Value(7, m_AU(11))) 'AU9
        sn76477_attack_decay_cap_w(m_Pin_Value(8, m_AU(0)))

        ' Filtre
        sn76477_noise_filter_res_w(m_Pin_Value(5, m_AU(4)))
        sn76477_noise_filter_cap_w(m_Pin_Value(6, m_AU(3)))

        ' Clock Extern Noise
        sn76477_noise_clock_res_w(m_Pin_Value(4, False))    ' fix
        sn76477_feedback_res_w(m_Pin_Value(12, False))      'fix

        '  Envelope
        sn76477_envelope_1_w(m_Pin_Value(1, m_AU(6)))
        sn76477_envelope_2_w(m_Pin_Value(28, m_AU(7)))

        ' En dernier on lance (ou pas !)
        sn76477_enable_w(m_Pin_Value(9, m_AU(14)))

    End Sub

    Public Sub Mise_A_Jour_Etat(ByRef Adresse As Integer, ByRef Value As Byte)

        ' Adjust value depending on I/O main CPU request
        Select Case (Adresse)

            Case &H2000
                ' Modification AU0 / AU8
                ' AU0
                m_AU(0) = (Value And &H80) = &H80
                ' AU8
                m_AU(8) = (Value And &H40) = &H40
                Aff_AU()

            Case &H2001
                ' Modification AU1 / AU9
                ' AU1
                m_AU(1) = (Value And &H80) = &H80
                ' AU9
                m_AU(9) = (Value And &H40) = &H40
                Aff_AU()

            Case &H2002
                ' Modification AU2 / AU10
                ' AU2
                m_AU(2) = (Value And &H80) = &H80
                ' AU10
                m_AU(10) = (Value And &H40) = &H40
                Aff_AU()

            Case &H2003
                ' Modification AU3 / AU11
                ' AU3
                m_AU(3) = (Value And &H80) = &H80
                ' AU11
                m_AU(11) = (Value And &H40) = &H40
                Aff_AU()

            Case &H2800
                ' Modification AU4 / AU12
                ' AU4
                m_AU(4) = (Value And &H80) = &H80
                ' AU12
                m_AU(12) = (Value And &H40) = &H40
                Aff_AU()

            Case &H2801
                ' Modification AU5 / AU13
                ' AU5
                m_AU(5) = (Value And &H80) = &H80
                ' AU13
                m_AU(13) = (Value And &H40) = &H40 ' ici bug !
                Aff_AU()

            Case &H2802
                ' Modification AU6 / AU14
                ' AU6
                m_AU(6) = (Value And &H80) = &H80
                ' AU14
                m_AU(14) = (Value And &H40) = &H40
                Aff_AU()

            Case &H2803
                ' Modification AU7 / AU15
                ' AU7
                m_AU(7) = (Value And &H80) = &H80
                ' AU15
                m_AU(15) = (Value And &H40) = &H40
                '
                Aff_AU()

            Case &H3000
                ' Mixer modification
                If Not (MainForm.CheckForceMixer.Checked) Then
                    'Si on n'est pas en mode debug sur le MIXER on rcuprer les infos d'Hector
                    m_ValMixer = (Value And 7)
                End If
                Aff_AU()
            Case Else
        End Select
        Update_Sound()
    End Sub

    Private Sub Aff_AU()
        If MainForm.Debug_SN Then
            'UNiquement si demand !
            MainForm.CheckAU0.Checked = m_AU(0)
            MainForm.CheckAU1.Checked = m_AU(1)
            MainForm.CheckAU2.Checked = m_AU(2)
            MainForm.CheckAU3.Checked = m_AU(3)
            MainForm.CheckAU4.Checked = m_AU(4)
            MainForm.CheckAU5.Checked = m_AU(5)
            MainForm.CheckAU6.Checked = m_AU(6)
            MainForm.CheckAU7.Checked = m_AU(7)
            MainForm.CheckAU8.Checked = m_AU(8)
            MainForm.CheckAU9.Checked = m_AU(9)
            MainForm.CheckAU10.Checked = m_AU(10)
            MainForm.CheckAU11.Checked = m_AU(11)
            MainForm.CheckAU12.Checked = m_AU(12)
            MainForm.CheckAU13.Checked = m_AU(13)
            MainForm.CheckAU14.Checked = m_AU(14)
            MainForm.CheckAU15.Checked = m_AU(15)
            MainForm.CheckAU1.Checked = m_AU(1)
            MainForm.CheckAU1.Checked = m_AU(1)
            MainForm.CheckAU1.Checked = m_AU(1)
            MainForm.CheckAU1.Checked = m_AU(1)

            MainForm.NumericMixer.Value = m_ValMixer
            MainForm.NumericEnveloppe.Value = SN76477.envelope_mode

        End If
    End Sub
    Public Function Son_Sn76477() As Short
        Son_Sn76477 = STREAM_UPDATE()
    End Function

End Module