﻿
'Copyright © 2016 Jean-Jacques STACINO
' author mail : jj.stac @ aliceadsl.fr


'This program is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    This program is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with this program.  If not, see <http://www.gnu.org/licenses/>.


' This file is part of VBHector.

'    VBHector is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    Foobar is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with VBHector.  If not, see <http://www.gnu.org/licenses/>.

' Several part such as modZ80, modAY8912 are from GPL project (VBSpec)
'   Tranlation from VB6 to VBNet and much more had been made.
'   Thanks' to them authors (Chris Cowley, Xavier) 
'   Note that the original files from Chris Cowley are joined to this project (Directory "Sources Licences" . 
' Emulation of the MEA8000 is from A.Mine, that I want to thank here for him's agreement.


Option Explicit On
Option Strict On

' Passage à Strict 01/11/13 


Public Module uPD765
    ' Yo_fr (jj.stac @ aliceadsl.fr)
    ' Le 20/12/2012 !
    ' Ce code est libre d'utilisation et de diffusion, néanmoins si vous utilisez mon code,
    ' merci de m'envoyer un petit mail !
    ' Si vous améliorez / corrigez des bug, merci de me le renvoyer la correction !

    ' This code is free to use and distribute, however if you use my code thank you send me a mail!
    ' If you improve / correct the bug, thank you for returning it to me!

    'Données d'une disquette 
    Public Fd0(2 * 80 * 10 * 512) As Byte ' 2 faces,80 pistes, 10 secteurs, 512 octets/secteur au maxi
    Public Fd1(2 * 80 * 10 * 512) As Byte ' 2 faces,80 pistes, 10 secteurs, 512 octets/secteur au maxi
    '  Public Fd2(2 * 80 * 10 * 512) As Byte ' 2 faces,80 pistes, 10 secteurs, 512 octets/secteur
    '  Public Fd3(2 * 80 * 10 * 512) As Byte ' 2 faces,80 pistes, 10 secteurs, 512 octets/secteur
    ' Type de disquette inserée
    Enum Type_Disk
        HE2 = 1
        HE8 = 2
        HE7 = 3
        HMD = 4 'pour le mini disque
    End Enum
    Public DiskA_type As Type_Disk
    Public DiskB_type As Type_Disk

    ' Liste des commandes et resultat du uPD selon les phases de fonctionnement du uPD
    Dim Command(9) As Byte ' Structure de la commande recu par le uPD
    Dim Nb_cmd As Byte     ' Nombre d'octets déjà recu dans la commande depuis le Z80
    Dim Result(9) As Byte  ' Structure du resultat à expédier par le uPD
    Dim Nb_Resu As Byte    ' Nombre d'octets déjà transmit par le uPD au Z80
    Dim Pointeur_ecriture As Byte

    'Registres internes du uPD
    Dim ST0, ST1, ST2, ST3 As Byte

    'Définir une structure par disquette 
    Dim PCN(4) As Byte   ' Le secteur courant et fonction du lecteur !
    Dim NCN, EQT, GPL, STP, HLT, ND, HUT, SRT, DTL, SC, D As Byte
    Dim US As Byte ' regroupe US0 et US1, ce qui donne le n° de lecteur en cours

    Dim C, H, R, N As Byte  ' position actuelle du lecteur !
    Dim Main As Byte ' Registre MAIN du registre STATUS
    Dim Octet_Courant As Integer = 0 'Pointeur sur les données d'un secteur
    Public Strg_FdC765 As String = "Test FdC" & vbCrLf
    Public Strg_SN As String = "Suivi SN76477" & vbCrLf & "Attention, Fréquences approximatives." & vbCrLf

    'Valide les traces de debuggage
    Public Demande_Trace_FD As Boolean = False
    Public Demande_Trace_MEA As Boolean = False

    'Type de commande en cours !
    Dim Cmd As Byte = 0

    ' Etat du uPD 
    Enum State_uPD
        Commande = 1
        Execute = 2
        Resultat = 3
    End Enum
    Dim Status_uPD As State_uPD

    ' Timer pour interruption et NMI
    Dim Tempo_INT As New Timer
    Dim Tempo_NMI As New Timer

    ' Defini la longeur des commandes et resultat selon le type de commande
    '                             0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
    Dim Longueur_Cmd() As Byte = {1, 1, 9, 3, 2, 9, 9, 2, 1, 9, 2, 1, 9, 6, 1, 3, _
                                  1, 9, 1, 1, 1, 1, 9, 1, 1, 9, 1, 1, 1, 9, 1, 1}
    'Liste des commandes possible du uPD765 :
    '	Commande :  2:	 read a track
    '*	Commande :  3:	 Specify
    '*	Commande :  4:	 Sense Drive Status
    '*	Commande :  5:	 write data
    '*	Commande :  6:	 read data
    '*	Commande :  7:	 recalibrate
    '*	Commande :  8:	 Sense interrupt status
    '	Commande :  9:	 write deleted data
    '	Commande :  10 ( A):	 read id
    '	Commande :  12 ( C):	 read deleted data
    '*	Commande :  13 ( D):	 format at track
    '*	Commande :  15 ( F):	 Seek
    '	Commande :  17 (11):	 scan equal
    '	Commande :  25 (19):	 scan low or equal
    '	Commande :  29 (1D):	 scan high or equal
    ' Seules les commandes précédées d'un "*" sont utilisées sur le Disc2 d'HECTOR et donc seules celles-ci sont émulées.

    Private Function Adresse(ByRef Face As Byte, ByRef Piste As Byte, ByRef Secteur As Byte, ByRef octet As Integer, ByVal TypeDsk As Type_Disk) As Integer

        '  For the 200Ko disk :
        '     512 bytes per sectors,
        '     10  sector per track,
        '     From sector =0 to sector 9
        '     40 tracks,
        '     1  Head

        ' For the 720Ko disk :
        '     512 bytes per sectors,
        '     9  sector per track,
        '     From sector =0 to sector 8
        '     80 tracks,
        '     2 Heads

        ' For the 800Ko disk :
        '     512 bytes per sectors,
        '     10  sector per track,
        '     From sector =0 to sector 9,
        '     80  tracks,
        '     2  Heads



        ' Ici on fixe la structure une bonne fois pour toutes: 

        ' pour les disquettes HE8
        ' Face = 0 ou 1 
        ' Piste = 0 à 79 pour Hector
        ' Secteur = 0 à 9 pour Hector (c'est comme cela !)
        ' Octet = 0 à 511 

        ' 1 piste contient = 5 120 octets (512*10)
        ' 1 face contient =  409 600  octets (5120*80)
        ' 2 faces contiennent = 819 200 octets

        ' pour les disquettes HE2
        ' Face = 0 
        ' Piste = 0 à 39 pour Hector
        ' Secteur = 0 à 9 pour Hector (c'est comme cela !)
        ' Octet = 0 à 511 

        ' 1 piste contient = 5120 octets (512*10)
        ' 1 face contient =  204 800 octets (5120*40)
        ' 1 disquette contient =  204 800 octets !
        ' Nota : le calcul est le même il faut juste que le disc2 ne demande pas une 2eme face sur un SD !

        ' pour les disquettes HE7
        ' Face = 0 ou 1 
        ' Piste = 0 à 79 pour Hector
        ' Secteur = 0 à 8 pour Hector (c'est comme cela !)
        ' Octet = 0 à 511 

        ' 1 piste contient = 4608 octets (512*9)
        ' 1 face contient =  368640 octets (4608*80)
        ' 1 disquette contient =  737280 octets !


        If TypeDsk = Type_Disk.HE2 Then
            Adresse = Piste * 5120 + Secteur * 512 + octet
        ElseIf TypeDsk = Type_Disk.HE8 Then
            Adresse = Face * 5120 + Piste * 5120 * 2 + Secteur * 512 + octet
        Else
            'Type HE7...
            Adresse = Face * 4608 + Piste * 4608 * 2 + Secteur * 512 + octet
        End If
    End Function

    '**********************************
    ' Fonctions d'interface avec le Z80
    '**********************************
    Public Sub Init_uPD()

        ' Etat du uPD init
        Status_uPD = State_uPD.Commande

        ' Init des pointeurs 
        Nb_cmd = 0
        Nb_Resu = 0

        'Init divers
        Cmd = 0

        ' RAZ des registres uPD
        NCN = 0
        EQT = 0
        GPL = 0
        STP = 0
        HLT = 0
        ND = 0
        HUT = 0
        SRT = 0
        DTL = 0
        SC = 0
        D = 0
        PCN(0) = 0
        PCN(1) = 0
        PCN(2) = 0
        PCN(3) = 0
        ST0 = 0
        ST1 = 0
        ST2 = 0
        ST3 = 0
        C = 0
        H = 0
        R = 0
        N = 0
        Octet_Courant = 0
        'Regitre STATUS
        Main = &H80

        'RAz des demandes d'interruption
        Disc2_NMI = False
        Disc2_INT = False

    End Sub

    Sub Lance_interrup_uPD()
        ' Lancement interrup 
        If Demande_Trace_FD Then Strg_FdC765 += " INT Demandée par le uPD ! " + vbCrLf
        Disc2_INT = True
    End Sub

    Sub Lance_NMI_uPD(ByRef Wait_Time As Long)
        ' Lancement Non Maskable Interrup 
        Disc2_NMI = True
        Wait_Time_NMI = Wait_Time
    End Sub

    Public Function Lecture_Registre() As Byte
        ' ici il s'agit de retourner au Z80 le tableau de resultat
        ' suite à une commande

        'Si on n'est pas dans la bonne phase => out !
        If Status_uPD <> State_uPD.Resultat Then
            Lecture_Registre = 0
            Exit Function
        End If

        'On met en place la réponse
        Lecture_Registre = Result(Pointeur_ecriture)
        ' On prépare pour le suivant
        Pointeur_ecriture = CByte(Pointeur_ecriture + 1)

        ' On test la fin de la phase de lecture du resultat
        If (Pointeur_ecriture) >= Nb_Resu Then
            ' Mise à jour de la phase du uPD si fini
            Status_uPD = State_uPD.Commande

            ' On peut re accpeter des écritures du registre ! 
            Main = &H80
        End If

        ' trace 
        If Demande_Trace_FD Then Strg_FdC765 += "<- " + MainForm.Caractere_hex(CInt(Lecture_Registre)) + vbCrLf
    End Function

    Public Function Lecture_Status() As Byte
        ' Lecutre du registre d'état du uPD765 par le Z80
        ' ici on indique l'état général du uPD 
        ' D0 à D3 (D0B à D3B) = FDD 0 à 3 en cours de SEEK commande => pas dispo pour faire autre chose

        ' D4 = CB, une commande est en cours d'execution (read ou write) => pas d'autre commande possible
        ' D5 = EXM : =1 lors d'un transfert non DMA, remis à 0 à la fin
        ' D6 = DIO : =1 data transfert uPD => Z80; 0 Z80 => uPD
        ' D7 = RQM : data register ready

        'ici on retourne simplement le Status calculé au fur et à mesure.
        Lecture_Status = Main

    End Function

    Public Sub Ecriture_DMA(ByRef Octet As Byte)
        ' Suite à une demande DMA du uPD, le Z80 vient écrire la donnée ici !

        'Si on n'est pas dans la bonne phase => out !
        If Status_uPD <> State_uPD.Execute Then
            Exit Sub
        End If

        'Recupération de la donnée suivante
        If US = 0 Then ' selon la disquette en cours de traitement (A: ou B:)
            Fd0(Adresse(H, C, R, Octet_Courant, DiskA_type)) = Octet  ' on retourne l'octet en cours de la Disquette A:
        Else
            Fd1(Adresse(H, C, R, Octet_Courant, DiskB_type)) = Octet    ' on retourne l'octet en cours de la Disquette B:
        End If

        ' On prépare la suite
        Octet_Courant += 1

        ' As-t-on terminé la lecture du secteur courant ?
        ' Ici on ne tiens pas en compte que l'on peut éventuellement faire 
        ' des lectures de plus d'un secteur (READ TRACK), car notre lecteur
        ' n'utilise pas ces fonctions...
        If Octet_Courant >= 256 * N Then
            'On est arrivé au bout du secteur (512 octets !)
            ' On prepare donc à la lecture du résultat
            Octet_Courant = 0
            Status_uPD = State_uPD.Resultat

            ' Main
            Main = &H80 + &H40 'autorisation lecture registre

            ' Et on prévient le Z80 de la fin
            ' en lancant l'interruption INT
            Lance_interrup_uPD()

        Else
            ' On a pas fini :
            ' On relance une DMA à la suite !
            Lance_NMI_uPD(20) ' tempo 70 cycles : Chargement 1er secteur sans int à la fin
        End If


    End Sub

    Public Function Lecture_DMA() As Byte
        ' Suite à une demande DMA du uPD, le Z80 vient lire la donnée ici !
        'Si on n'est pas dans la bonne phase => out !
        If Status_uPD <> State_uPD.Execute Then
            Lecture_DMA = 0
            Exit Function
        End If
        If Demande_Trace_FD Then Strg_FdC765 += "NMI "
        'Recupération de la donnée suivante
        If US = 0 Then ' selon la disquette en cours de traitement (A: ou B:)
            Lecture_DMA = Fd0(Adresse(H, C, R, Octet_Courant, DiskA_type))   ' on retourne l'octet en cours de la Disquette A:
        Else
            Lecture_DMA = Fd1(Adresse(H, C, R, Octet_Courant, DiskB_type))   ' on retourne l'octet en cours de la Disquette B:
        End If

        ' On prépare la suite
        Octet_Courant += 1

        ' As-t-on terminé la lecture du secteur courant ?
        ' Ici on ne tiens pas en compte que l'on peut éventuellement faire 
        ' des lectures de plus d'un secteur (READ TRACK), car notre lecteur
        ' n'utilise pas ces fonctions...
        If Octet_Courant >= 256 * N Then
            'On est arrivé au bout du secteur (512 octets !)
            ' On prepare donc à la lecture du résultat
            Octet_Courant = 0
            Status_uPD = State_uPD.Resultat

            ' Main
            Main = &H80 + &H40 'autorisation lecture registre

            ' Et on prévient le Z80 de la fin
            ' en lancant l'interruption INT
            Lance_interrup_uPD()

        Else
            ' On a pas fini :
            ' On relance une DMA à la suite !
            Lance_NMI_uPD(20) ' tempo 13 cycles : Chargement 1er secteur sans int à la fin
        End If


    End Function

    Public Sub Ecrit_Registre(ByRef Valeur As Byte)

        ' Le Z80 nous envoi une donnée dans le registre

        ' Si on n'est pas en contidion => on sort !
        If Status_uPD <> State_uPD.Commande Then Exit Sub

        Command(Nb_cmd) = Valeur

        ' Extraction N° de commande
        ' Il s'agit du 1er octet reçu masqué
        Cmd = CByte(Command(0) And &HF)

        ' Pour affichage
        If Demande_Trace_FD Then Strg_FdC765 += MainForm.Caractere_hex(CInt(Valeur)) + " "

        'Test si fin de commande 
        If Longueur_Cmd(Cmd) = Nb_cmd + 1 Then
            Status_uPD = State_uPD.Execute
            ' On lance l'execution de la commande demandée !
            Execution_Cmde()
        Else
            Nb_cmd = CByte(Nb_cmd + 1)
        End If

    End Sub

    '*******************************
    'Exécution des commandes passées 
    '*******************************
    Sub Specify()

        ' extraction des info de la commande
        HUT = CByte(Command(1) And &HF)
        SRT = CByte((Command(1) >> 4) And &HF)
        HLT = CByte((Command(2) >> 1) And &H7F)
        ND = CByte(Command(2) And &H1)

        ' Comme il n'y a pas de retour => ras !

        'Mise à jour du Status 
        Main = &H80

        'Ainsi que des registres !
        ST3 = &H20

        ' Mise à jour phase du uPD
        Status_uPD = State_uPD.Commande

        'Relance commande 
        Nb_cmd = 0

    End Sub

    Sub Sense_interrupt_status()
        'Pas de données à lire de la commande :
        ' Il s'agit juste de lire le regitre ST0

        ' Main
        Main = &H40 + &H80

        'Recupération des info pour la réponse
        Result(0) = ST0
        Result(1) = PCN(US)

        'Longueur du resultat 
        Nb_Resu = 2
        'init du pointeur
        Pointeur_ecriture = 0

        ' Mise à jour du Status
        Status_uPD = State_uPD.Resultat

        ' Fin d'un seek ?
        ST0 = CByte(ST0 And Not (&H2)) 'RAZ SEEK
        ST3 = &H28

        'Relance commande 
        Nb_cmd = 0

    End Sub

    Sub Sense_Drive_Status()
        ' Pas de données à lire de la commande : 
        ' Il s'agit juste de lire le regitre ST3

        ' Main
        Main = &H40 + &H80 'Dispo et lecture donnée

        'Recupération des info pour la réponse : ST3 !
        Result(0) = ST3


        'Longueur du resultat 
        Nb_Resu = 1
        'init du pointeur
        Pointeur_ecriture = 0

        ' Mise à jour du Status
        Status_uPD = State_uPD.Resultat

        'Relance commande 
        Nb_cmd = 0


        ST0 = 0
        SC = 0

    End Sub

    Sub Read_data()

        ' extraction des info de la commande
        US = CByte(Command(1) And &H3)
        '  HD = (Command(1) >> 4) And &HF déjà dans les données CHRN !

        ' Voir pour récupérer les info Multi Track, MFM , SK ...
        C = Command(2)
        H = Command(3)
        R = Command(4)
        N = Command(5)
        EQT = Command(6)
        GPL = Command(7)
        DTL = Command(8)

        'Mise à jour des registres

        If (PCN(US) = C) Then
            Main = 0 ' &H40 + &H80 'Dispo et lecture donnée
            'Registres 
            ST0 = &H0
            ST1 = &H0
            ST2 = &H0
            ST3 = &H28

            'Recupération des info pour la réponse :
            Result(0) = ST0
            Result(1) = ST1
            Result(2) = ST2
            Result(3) = C
            Result(4) = H
            Result(5) = R
            Result(6) = N

            ' Pointeur dans le secteur réinitialisé 
            Octet_Courant = 0
            ' 
            'Longueur du resultat 
            Nb_Resu = 7
            'init du pointeur
            Pointeur_ecriture = 0

            ' Mise à jour du Status
            Status_uPD = State_uPD.Execute

            'Relance commande 
            Nb_cmd = 0

            'On lannce l'interruption NMI
            Lance_NMI_uPD(160)    ' tempo 160 cycles : Chargement 1er secteur sans int à la fin
        Else

            'Secteur courant n'est le secteur demandé....
            'Error !
            Main = &H80 + &H40  'Dispo et lecture donnée
            'Registres 
            ST0 = &HFF 'Error
            ST1 = &H4
            ST2 = &H0
            ST3 = &H28

            'Recupération des info pour la réponse :
            Result(0) = ST0
            Result(1) = ST1
            Result(2) = ST2
            Result(3) = C
            Result(4) = H
            Result(5) = R
            Result(6) = N

            ' 
            'Longueur du resultat 
            Nb_Resu = 7
            'init du pointeur
            Pointeur_ecriture = 0

            ' Mise à jour du Status
            Status_uPD = State_uPD.Resultat

            'Relance commande 
            Nb_cmd = 0

            ' Et on prévient le Z80 de la fin (le code d'erreur est dans ST0)
            ' en lancant l'interruption INT
            Lance_interrup_uPD()
        End If
    End Sub

    Sub Write_data()

        ' extraction des info de la commande
        US = CByte(Command(1) And &H3)
        '  HD = (Command(1) >> 4) And &HF déjà dans les données CHRN !

        ' Voir pour récupérer les info Multi Track, MFM , SK ...
        C = Command(2)
        H = Command(3)
        R = Command(4)
        N = Command(5)
        EQT = Command(6)
        GPL = Command(7)
        DTL = Command(8)

        'Mise à jour des registres
        ' Main
        Main = 0 ' &H40 + &H80 'Dispo et lecture donnée
        'Registres 
        ST0 = &H0
        ST1 = &H0
        ST2 = &H0
        ST3 = &H28

        'Recupération des info pour la réponse :
        Result(0) = ST0
        Result(1) = ST1
        Result(2) = ST2
        Result(3) = C
        Result(4) = H
        Result(5) = R
        Result(6) = N

        ' Pointeur dans le secteur réinitialisé 
        Octet_Courant = 0
        ' 
        'Longueur du resultat 
        Nb_Resu = 7
        'init du pointeur
        Pointeur_ecriture = 0

        ' Mise à jour du Status
        Status_uPD = State_uPD.Execute

        'Relance commande 
        Nb_cmd = 0

        'On lannce l'interruption NMI
        Lance_NMI_uPD(160)    ' tempo 160 cycles : Chargement 1er secteur sans int à la fin

    End Sub

    Sub Seek_Head()
        'Décorticage de la commande passée
        US = CByte(Command(1) And &H3)
        '  HD = (Command(1) >> 4) And &HF déjà dans les données CHRN !

        ' Voir pour récupérer les info Multi Track, MFM , SK ...
        NCN = Command(2)

        'On fait le déplacement de la tête 
        PCN(US) = NCN

        'Main 
        Main = &H80 ' + &H40
        ' 
        'Longueur du resultat 
        Nb_Resu = 0
        'init du pointeur
        Pointeur_ecriture = 0

        ST0 = &H2
        ST1 = &H0
        ST2 = &H0
        ST3 = &H0

        ' Mise à jour du Status
        Status_uPD = State_uPD.Commande

        'Relance commande 
        Nb_cmd = 0

        ' Et on prévient le Z80 de la fin (le code de fin seek dans ST0)
        ' en lancant l'interruption INT
        Lance_interrup_uPD()

    End Sub

    Sub Recalibrate()
        ' extraction des info de la commande
        US = CByte(Command(1) And &H3) ' N° de lecteur

        'execution de la commande : retour en track 00 !
        C = 0
        PCN(US) = 0

        ' Comme il n'y a pas de retour => ras !

        'Mise à jour du registre Status 
        Main = &H80  ' commande  ok !

        ' Mise à jour registres internes 
        ST0 = &H20
        ST1 = 0
        ST2 = 0
        ST3 = &H20

        ' Mise à jour phase du uPD
        Status_uPD = State_uPD.Commande

        'Relance commande 
        Nb_cmd = 0

        ' Simulation interrupt 
        Lance_interrup_uPD()

    End Sub

    Sub Format_Track()  ' **************************************************************Reste à traiter ************************
        ' Commande de formattage d'une piste 

        ' extraction des info de la commande
        US = CByte(Command(1) And &H3)
        '  HD = (Command(1) >> 4) And &HF déjà dans les données CHRN !

        ' Voir pour récupérer les info Multi Track, MFM , SK ...
        N = Command(2)   'Byte per sector
        SC = Command(3)  'SC Sector/Track
        GPL = Command(4) ' GAP 3
        D = Command(5)   ' Filter byte (e5)

        'Mise à jour des registres
        ' Main
        Main = 0 ' &H40 + &H80 'Dispo et lecture donnée
        'Registres 
        ST0 = &H0
        ST1 = &H0
        ST2 = &H0
        ST3 = &H28

        'Recupération des info pour la réponse :
        Result(0) = ST0
        Result(1) = ST1
        Result(2) = ST2
        Result(3) = C
        Result(4) = H
        Result(5) = R
        Result(6) = N

        ' Pointeur dans le secteur réinitialisé 
        Octet_Courant = 0
        ' 
        'Longueur du resultat 
        Nb_Resu = 7
        'init du pointeur
        Pointeur_ecriture = 0

        ' Mise à jour du Status
        Status_uPD = State_uPD.Execute

        'Relance commande 
        Nb_cmd = 0

        'On lannce l'interruption NMI
        Lance_NMI_uPD(160)    ' tempo 160 cycles : Chargement 1er secteur sans int à la fin
        ' Attention : ici il faut travailler :
        ' Pour chaque secteur les valeurs CHRN sont demandées au Z80 qui lui les fournit d
        ' dans cette ordre à l'aide des fonction DMA
        ' ...
    End Sub

    Sub Execution_Cmde()
        If Demande_Trace_FD Then Strg_FdC765 += vbCrLf + "   => "
        Select Case Cmd
            Case 2
                '	Commande :  2:	 read a track
                If Demande_Trace_FD Then Strg_FdC765 += "Read a track" + vbCrLf
                Exit Select
            Case 3
                '	Commande :  3:	 Specify
                If Demande_Trace_FD Then Strg_FdC765 += "Specify" + vbCrLf
                Specify()

                Exit Select
            Case 4
                '	Commande :  4:	 Sense Drive Status
                If Demande_Trace_FD Then Strg_FdC765 += "Sense Drive Status" + vbCrLf
                Sense_Drive_Status()
                Exit Select
            Case 5
                '	Commande :  5:	 write data
                If Demande_Trace_FD Then Strg_FdC765 += "Write data" + vbCrLf
                Write_data()
                Exit Select
            Case 6
                '	Commande :  6:	 read data
                If Demande_Trace_FD Then Strg_FdC765 += "Read data" + vbCrLf
                Read_data()
                Exit Select
            Case 7
                '	Commande :  7:	 recalibrate
                If Demande_Trace_FD Then Strg_FdC765 += "Recalibrate" + vbCrLf
                Recalibrate()
                Exit Select
            Case 8
                '	Commande :  8:	 Sense interrupt status
                If Demande_Trace_FD Then Strg_FdC765 += "Sense interrupt status" + vbCrLf
                Sense_interrupt_status()
                Exit Select
            Case 9
                '	Commande :  9:	 write deleted data
                If Demande_Trace_FD Then Strg_FdC765 += "Write deleted data" + vbCrLf
                Exit Select
            Case 10
                '	Commande :  10 ( A):	 read id
                If Demande_Trace_FD Then Strg_FdC765 += "read ID" + vbCrLf
                Exit Select
            Case 12
                '	Commande :  12 ( C):	 read deleted data
                If Demande_Trace_FD Then Strg_FdC765 += "Read deleted data" + vbCrLf
                Exit Select
            Case 13
                '	Commande :  13 ( D):	 format at track
                If Demande_Trace_FD Then Strg_FdC765 += "Format a track" + vbCrLf
                Format_Track()
                Exit Select
            Case 15
                '	Commande :  15 ( F):	 Seek
                If Demande_Trace_FD Then Strg_FdC765 += "Seek" + vbCrLf
                Seek_Head()
                Exit Select
            Case 17
                '	Commande :  17 (11):	 scan equal
                If Demande_Trace_FD Then Strg_FdC765 += "Scan equal" + vbCrLf
                Exit Select
            Case 25
                '	Commande :  25 (19):	 scan low or equal
                If Demande_Trace_FD Then Strg_FdC765 += "Scan low or equal" + vbCrLf
                Exit Select
            Case 29
                '	Commande :  29 (1D):	 scan high or equal
                If Demande_Trace_FD Then Strg_FdC765 += "Scan high or equal" + vbCrLf
                Exit Select
            Case Else
                'Erreur sur la commande passée !
                If Demande_Trace_FD Then Strg_FdC765 += "Erreur sur commande passée !" + vbCrLf
                ST0 = &H80

                ' Mise à jour phase du uPD
                Status_uPD = State_uPD.Execute

                ' Mise en place du resultat
                Result(0) = ST0
                Nb_Resu = 1
        End Select
    End Sub
End Module
