Attribute VB_Name = "modZX81"

' /*******************************************************************************
'   modZX81.bas within vb81.vbp
'
'   Routines for emulating the ZX81 hardware; displaying the
'   video memory (reads DFILE directory), reading the keyboard (port
'   0xFE), and loading and saving from 'tape' (*.P files)
'
'   Author: Chris Cowley <ccowley@grok.co.uk>
'
'   Copyright (C)2000-2002  Grok Developments Ltd.
'   http://www.grok.co.uk/
'
'   This program is free software; you can redistribute it and/or
'   modify it under the terms of the GNU General Public License
'   as published by the Free Software Foundation; either version 2
'   of the License, or (at your option) any later version.
'   This program is distributed in the hope that it will be useful,
'   but WITHOUT ANY WARRANTY; without even the implied warranty of
'   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'   GNU General Public License for more details.
'
'   You should have received a copy of the GNU General Public License
'   along with this program; if not, write to the Free Software
'   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'
' *******************************************************************************/

Option Explicit

Function doKey(down As Boolean, ascii As Integer, mods As Integer) As Boolean
    Dim CAPS As Boolean
      
    CAPS = mods And 1

    If CAPS Then keyCAPS_V = (keyCAPS_V And (Not 1&)) Else keyCAPS_V = (keyCAPS_V Or 1&)
    
    Select Case ascii
    Case 8 ' Backspace
        If down Then
            key6_0 = (key6_0 And (Not 1&))
            keyCAPS_V = (keyCAPS_V And (Not 1&))
        Else
            key6_0 = (key6_0 Or 1&)
            If Not CAPS Then
                keyCAPS_V = (keyCAPS_V Or 1&)
            End If
        End If
    Case 16 ' SHIFT
        If down Then keyCAPS_V = (keyCAPS_V And (Not 1&)) Else keyCAPS_V = (keyCAPS_V Or 1&)
    Case 65 ' A
        If down Then keyA_G = (keyA_G And (Not 1&)) Else keyA_G = (keyA_G Or 1&)
    Case 66 ' B
        If down Then keyB_SPC = (keyB_SPC And (Not 16&)) Else keyB_SPC = (keyB_SPC Or 16&)
    Case 67 ' C
        If down Then keyCAPS_V = (keyCAPS_V And (Not 8&)) Else keyCAPS_V = (keyCAPS_V Or 8&)
    Case 68 ' D
        If down Then keyA_G = (keyA_G And (Not 4&)) Else keyA_G = (keyA_G Or 4&)
    Case 69 ' E
        If down Then keyQ_T = (keyQ_T And (Not 4&)) Else keyQ_T = (keyQ_T Or 4&)
    Case 70 ' F
        If down Then keyA_G = (keyA_G And (Not 8&)) Else keyA_G = (keyA_G Or 8&)
    Case 71 ' G
        If down Then keyA_G = (keyA_G And (Not 16&)) Else keyA_G = (keyA_G Or 16&)
    Case 72 ' H
        If down Then keyH_ENT = (keyH_ENT And (Not 16&)) Else keyH_ENT = (keyH_ENT Or 16&)
    Case 73 ' I
        If down Then keyY_P = (keyY_P And (Not 4&)) Else keyY_P = (keyH_ENT Or 4&)
    Case 74 ' J
        If down Then keyH_ENT = (keyH_ENT And (Not 8&)) Else keyH_ENT = (keyH_ENT Or 8&)
    Case 75 ' K
        If down Then keyH_ENT = (keyH_ENT And (Not 4&)) Else keyH_ENT = (keyH_ENT Or 4&)
    Case 76 ' L
        If down Then keyH_ENT = (keyH_ENT And (Not 2&)) Else keyH_ENT = (keyH_ENT Or 2&)
    Case 77 ' M
        If down Then keyB_SPC = (keyB_SPC And (Not 4&)) Else keyB_SPC = (keyB_SPC Or 4&)
    Case 78 ' N
        If down Then keyB_SPC = (keyB_SPC And (Not 8&)) Else keyB_SPC = (keyB_SPC Or 8&)
    Case 79 ' O
        If down Then keyY_P = (keyY_P And (Not 2&)) Else keyY_P = (keyY_P Or 2&)
    Case 80 ' P
        If down Then keyY_P = (keyY_P And (Not 1&)) Else keyY_P = (keyY_P Or 1&)
    Case 81 ' Q
        If down Then keyQ_T = (keyQ_T And (Not 1&)) Else keyQ_T = (keyQ_T Or 1&)
    Case 82 ' R
        If down Then keyQ_T = (keyQ_T And (Not 8&)) Else keyQ_T = (keyQ_T Or 8&)
    Case 83 ' S
        If down Then keyA_G = (keyA_G And (Not 2&)) Else keyA_G = (keyA_G Or 2&)
    Case 84 ' T
        If down Then keyQ_T = (keyQ_T And (Not 16&)) Else keyQ_T = (keyQ_T Or 16&)
    Case 85 ' U
        If down Then keyY_P = (keyY_P And (Not 8&)) Else keyY_P = (keyY_P Or 8&)
    Case 86 ' V
        If down Then keyCAPS_V = (keyCAPS_V And (Not 16&)) Else keyCAPS_V = (keyCAPS_V Or 16&)
    Case 87 ' W
        If down Then keyQ_T = (keyQ_T And (Not 2&)) Else keyQ_T = (keyQ_T Or 2&)
    Case 88 ' X
        If down Then keyCAPS_V = (keyCAPS_V And (Not 4&)) Else keyCAPS_V = (keyCAPS_V Or 4&)
    Case 89 ' Y
        If down Then keyY_P = (keyY_P And (Not 16&)) Else keyY_P = (keyY_P Or 16&)
    Case 90 ' Z
        If down Then keyCAPS_V = (keyCAPS_V And (Not 2&)) Else keyCAPS_V = (keyCAPS_V Or 2&)
    Case 48 ' 0
        If down Then key6_0 = (key6_0 And (Not 1&)) Else key6_0 = (key6_0 Or 1&)
    Case 49 ' 1
        If down Then key1_5 = (key1_5 And (Not 1&)) Else key1_5 = (key1_5 Or 1&)
    Case 50 ' 2
        If down Then key1_5 = (key1_5 And (Not 2&)) Else key1_5 = (key1_5 Or 2&)
    Case 51 ' 3
        If down Then key1_5 = (key1_5 And (Not 4&)) Else key1_5 = (key1_5 Or 4&)
    Case 52 ' 4
        If down Then key1_5 = (key1_5 And (Not 8&)) Else key1_5 = (key1_5 Or 8&)
    Case 53 ' 5
        If down Then key1_5 = (key1_5 And (Not 16&)) Else key1_5 = (key1_5 Or 16&)
    Case 54 ' 6
        If down Then key6_0 = (key6_0 And (Not 16&)) Else key6_0 = (key6_0 Or 16&)
    Case 55 ' 7
        If down Then key6_0 = (key6_0 And (Not 8&)) Else key6_0 = (key6_0 Or 8&)
    Case 56 ' 8
        If down Then key6_0 = (key6_0 And (Not 4&)) Else key6_0 = (key6_0 Or 4&)
    Case 57 ' 9
        If down Then key6_0 = (key6_0 And (Not 2&)) Else key6_0 = (key6_0 Or 2&)
    Case 96 ' Keypad 0
        If down Then key6_0 = (key6_0 And (Not 1&)) Else key6_0 = (key6_0 Or 1&)
    Case 97 ' Keypad 1
        If down Then key1_5 = (key1_5 And (Not 1&)) Else key1_5 = (key1_5 Or 1&)
    Case 98 ' Keypad 2
        If down Then key1_5 = (key1_5 And (Not 2&)) Else key1_5 = (key1_5 Or 2&)
    Case 99 ' Keypad 3
        If down Then key1_5 = (key1_5 And (Not 4&)) Else key1_5 = (key1_5 Or 4&)
    Case 100 ' Keypad 4
        If down Then key1_5 = (key1_5 And (Not 8&)) Else key1_5 = (key1_5 Or 8&)
    Case 101 ' Keypad 5
        If down Then key1_5 = (key1_5 And (Not 16&)) Else key1_5 = (key1_5 Or 16&)
    Case 102 ' Keypad 6
        If down Then key6_0 = (key6_0 And (Not 16&)) Else key6_0 = (key6_0 Or 16&)
    Case 103 ' Keypad 7
        If down Then key6_0 = (key6_0 And (Not 8&)) Else key6_0 = (key6_0 Or 8&)
    Case 104 ' Keypad 8
        If down Then key6_0 = (key6_0 And (Not 4&)) Else key6_0 = (key6_0 Or 4&)
    Case 105 ' Keypad 9
        If down Then key6_0 = (key6_0 And (Not 2&)) Else key6_0 = (key6_0 Or 2&)
    Case 106 ' Keypad *
        If down Then
            keyB_SPC = (keyB_SPC And (Not 16&))
            keyCAPS_V = (keyCAPS_V And (Not 1&))
        Else
            keyB_SPC = (keyB_SPC Or 16&)
            If Not CAPS Then
                keyCAPS_V = (keyCAPS_V Or 1&)
            End If
        End If
    Case 107 ' Keypad +
        If down Then
            keyH_ENT = (keyH_ENT And (Not 4&))
            keyCAPS_V = (keyCAPS_V And (Not 1&))
        Else
            keyH_ENT = (keyH_ENT Or 4&)
            If Not CAPS Then
                keyCAPS_V = (keyCAPS_V Or 1&)
            End If
        End If
    Case 109 ' Keypad -
        If down Then
            keyH_ENT = (keyH_ENT And (Not 8&))
            keyCAPS_V = (keyCAPS_V And (Not 1&))
        Else
            keyH_ENT = (keyH_ENT Or 8&)
            If Not CAPS Then
                keyCAPS_V = (keyCAPS_V Or 1&)
            End If
        End If
    Case 110 ' Keypad .
        If down Then keyB_SPC = (keyB_SPC And (Not 2&)) Else keyB_SPC = (keyB_SPC Or 2&)
    Case 111 ' Keypad /
        If down Then
            keyCAPS_V = (keyCAPS_V And (Not 17&))
        Else
            If Not CAPS Then
                keyCAPS_V = (keyCAPS_V Or 17&)
            Else
                keyCAPS_V = (keyCAPS_V Or 16&)
            End If
        End If
    Case 37 ' Left
        If down Then
            key1_5 = (key1_5 And (Not 16&))
            keyCAPS_V = (keyCAPS_V And (Not 1&))
        Else
            key1_5 = (key1_5 Or 16&)
            If Not CAPS Then
                keyCAPS_V = (keyCAPS_V Or 1&)
            End If
        End If
    Case 38 ' Up
        If down Then
            key6_0 = (key6_0 And (Not 8&))
            keyCAPS_V = (keyCAPS_V And (Not 1&))
        Else
            key6_0 = (key6_0 Or 8&)
            If Not CAPS Then
                keyCAPS_V = (keyCAPS_V Or 1&)
            End If
        End If
    Case 39 ' Right
        If down Then
            key6_0 = (key6_0 And (Not 4&))
            keyCAPS_V = (keyCAPS_V And (Not 1&))
        Else
            key6_0 = (key6_0 Or 4&)
            If Not CAPS Then
                keyCAPS_V = (keyCAPS_V Or 1&)
            End If
        End If
    Case 40 ' Down
        If down Then
            key6_0 = (key6_0 And (Not 16&))
            keyCAPS_V = (keyCAPS_V And (Not 1&))
        Else
            key6_0 = (key6_0 Or 16&)
            If Not CAPS Then
                keyCAPS_V = (keyCAPS_V Or 1&)
            End If
        End If
    Case 13 ' RETURN
        If down Then keyH_ENT = (keyH_ENT And (Not 1&)) Else keyH_ENT = (keyH_ENT Or 1&)
    Case 32 ' SPACE BAR
        If down Then keyB_SPC = (keyB_SPC And (Not 1&)) Else keyB_SPC = (keyB_SPC Or 1&)
    Case 190 ' .
        If down Then keyB_SPC = (keyB_SPC And (Not 2&)) Else keyB_SPC = (keyB_SPC Or 2&)
    Case Else
        doKey = False
    End Select
          
    doKey = True
End Function



Public Sub HiresScreenPaint()
    Dim x As Long, y As Long
    Dim c As Long
    
    Dim lTopMost As Long, lBottomMost As Long, lLeftMost As Long, lRightMost As Long
    Dim bUpdated As Long
    
    lTopMost = 191
    lBottomMost = 0
    lLeftMost = 31
    lRightMost = 0
    
    gpicDisplay.Visible = False
        
    For y = 0 To 191
        For x = 0 To 31
            c = (mem(lHiresLoc + x + y * 33) And &HBF&) ' strip bit 6

            If c <> cLastHiResScreen(y, x) Then
                If y < lTopMost Then lTopMost = y
                If y > lBottomMost Then lBottomMost = y
                If x < lLeftMost Then lLeftMost = x
                If x > lRightMost Then lRightMost = x
                bUpdated = True
                If (c And 128) <> 0 Then
                    ' // Inverse video
                    gcBufferBits(y * 32 + x) = mem((intI * 256) + (c And 63) * 8) Xor 255
                Else
                    ' // Normal video
                    gcBufferBits(y * 32 + x) = mem((intI * 256) + c * 8)
                End If
                cLastHiResScreen(y, x) = c
            End If
        Next x
    Next y
    lLeftMost = lLeftMost * 8
    lRightMost = lRightMost * 8
    If bUpdated Then StretchDIBits gpicDisplay.hdc, lLeftMost * glDisplayXMultiplier, (lBottomMost + 1) * glDisplayYMultiplier - 1, (lRightMost - lLeftMost + 8) * glDisplayXMultiplier, -(lBottomMost - lTopMost + 1) * glDisplayYMultiplier, lLeftMost, lTopMost, (lRightMost - lLeftMost) + 8, lBottomMost - lTopMost + 1, gcBufferBits(0), bmiBuffer, DIB_RGB_COLORS, SRCCOPY
    
    gpicDisplay.Visible = True
End Sub

Function inb(ByVal port As Long) As Long
    Dim res As Long
    
    res = &HFF&
    If (port And 1) = 0 Then
        port = glMemAddrDiv256(port And &HFF00&)
        If (port And 1) = 0 Then res = res And keyCAPS_V
        If (port And 2) = 0 Then res = res And keyA_G
        If (port And 4) = 0 Then res = res And keyQ_T
        If (port And 8) = 0 Then res = res And key1_5
        If (port And 16) = 0 Then res = res And key6_0
        If (port And 32) = 0 Then res = res And keyY_P
        If (port And 64) = 0 Then res = res And keyH_ENT
        If (port And 128) = 0 Then res = res And keyB_SPC
        ' // Bit7 of the port FE is always 0 on the zx81 (or so it appears)
        res = res And 127
    End If
    
'    If res <> 255 Then Stop
    
    inb = res
End Function

Sub outb(port As Long, outbyte As Long, Optional tstates As Long = 0)
    If port = 253 Then
        ' SLOW Mode
        regAF_ = regAF_ Or 32768
    ElseIf port = 254 Then
        ' FAST Mode
        regAF_ = regAF_ And (Not 32768)
    ElseIf port = 0 Then
        bInputWait = True
        bBooting = False
        ShowDisplay True, True
    ElseIf port = 1 Then
        bInputWait = False
        bBooting = False
        If mem(16443) And 128 Then
            ShowDisplay True, True
        Else
            ShowDisplay False, False
        End If
    End If
End Sub


Public Sub ReInitHiresScreen()
    Dim y As Long, x As Long
    
    For y = 0 To 191
        For x = 0 To 31
            cLastHiResScreen(y, x) = 0
            gcBufferBits(y * 32 + x) = 0
        Next x
    Next y
End Sub


Sub screenPaint()
    Dim ptr As Long, x As Long, y As Long
    Dim c As Long
    Dim lChar As Long, lRow As Long
    
    Dim lTopMost As Long, lBottomMost As Long, lLeftMost As Long, lRightMost As Long
    Dim bUpdated As Long
    
    lTopMost = 191
    lBottomMost = 0
    lLeftMost = 31
    lRightMost = 0
       
    ptr = mem(16396) + 256 * mem(16397) + 1 ' // D_FILE (+1 to skip the initial HALT)
    
    ' // don't bother if D_FILE is uninitialised
    If ptr = 0 Then Exit Sub
    
    gpicDisplay.Visible = False
    
    
    ' // Build the video memory map in sScreen
    For y = 0 To 23
        For x = 0 To 31
            If mem(ptr) = &H76& Then
                lChar = y * 32 + x
                c = 0 ' // space
                ptr = ptr - 1
            Else
                lChar = y * 32 + x
                c = (mem(ptr) And &HBF&) ' strip bit 6
            End If
                
            If c <> sLastScreen(lChar) Then
                ' // If this character has changed since we last painted
                ' // the screen, repaint it
                If y * 8 < lTopMost Then lTopMost = y * 8
                If y * 8 + 7 > lBottomMost Then lBottomMost = y * 8 + 7
                If x < lLeftMost Then lLeftMost = x
                If x > lRightMost Then lRightMost = x
                bUpdated = True
                If (c And 128) Then
                    For lRow = 0 To 7
                        gcBufferBits(y * 256 + x + lRow * 32) = mem((intI * 256) + ((c And 63) * 8) + lRow) Xor 255
                    Next lRow
                Else
                    For lRow = 0 To 7
                        gcBufferBits(y * 256 + x + lRow * 32) = mem((intI * 256) + (c * 8) + lRow)
                    Next lRow
                End If
                sLastScreen(lChar) = c
            End If
                
            ptr = ptr + 1
        Next x
        ptr = ptr + 1
    Next y
    
    lLeftMost = lLeftMost * 8
    lRightMost = lRightMost * 8
    If bUpdated Then StretchDIBits gpicDisplay.hdc, lLeftMost * glDisplayXMultiplier, (lBottomMost + 1) * glDisplayYMultiplier - 1, (lRightMost - lLeftMost + 8) * glDisplayXMultiplier, -(lBottomMost - lTopMost + 1) * glDisplayYMultiplier, lLeftMost, lTopMost, (lRightMost - lLeftMost) + 8, lBottomMost - lTopMost + 1, gcBufferBits(0), bmiBuffer, DIB_RGB_COLORS, SRCCOPY
    
    gpicDisplay.Visible = True
End Sub


Public Function SearchHiresScreen() As Long
    Dim lCounter As Long, v As Byte, FoundHiRes As Long
    Dim lCounter2 As Long
    
    For lCounter = (32767 - 6336) To 8192 Step -1
        v = mem(lCounter + 32)
        If (v And 64) <> 0 Then
            FoundHiRes = True
            For lCounter2 = 0 To 191
                If (mem(lCounter + 33 * lCounter2) And 64) Or (mem(lCounter + 32 + 33 * lCounter2) <> v) Then
                    FoundHiRes = 0
                    Exit For
                End If
            Next lCounter2
        End If
        If FoundHiRes Then
            SearchHiresScreen = lCounter
            Exit For
        End If
    Next lCounter
End Function

Public Sub TapeLoad(ByVal FileNamePtr As Long)
    Dim sFileName As String, i As Long, ln As Long
    Dim hFile As Long
    
    If FileNamePtr >= 32768 Then
        ' // LOAD ""
        Exit Sub
    Else
        ' // LOAD "filename"
        FileNamePtr = FileNamePtr And 32767
        ' // FileNamePtr points to the filename in the ZX81 character set
        If mem(FileNamePtr) = 227 Then
            End
        End If
        
        Do While mem(FileNamePtr) < 127
            sFileName = sFileName + ZXCharToASCII(mem(FileNamePtr))
            FileNamePtr = FileNamePtr + 1
        Loop
        sFileName = Trim$(sFileName & ZXCharToASCII(mem(FileNamePtr))) & ".P"
    End If
    
    If Dir$(sFileName) = "" Then Exit Sub

    hFile = FreeFile
    Open sFileName For Binary As hFile
    ln = LOF(hFile)
    sFileName = Input$(ln, #hFile)
    For i = 0 To ln - 1
        mem(&H4009 + i) = Asc(Mid$(sFileName, i + 1, 1))
    Next i
    Close #hFile
    bInputWait = True
    ShowDisplay True, True
End Sub

Public Sub TapeSave(ByVal FileNamePtr As Long)
    Dim sFileName As String, i As Long, ln As Long
    Dim hFile As Long
    
    If FileNamePtr >= 32768 Then
        ' // SAVE ""
        Exit Sub
    Else
        ' // SAVE "filename"
        FileNamePtr = FileNamePtr And 32767
        ' // FileNamePtr points to the filename in the ZX81 character set
        Do While mem(FileNamePtr) < 127
            sFileName = sFileName + ZXCharToASCII(mem(FileNamePtr))
            FileNamePtr = FileNamePtr + 1
        Loop
        sFileName = Trim$(sFileName & ZXCharToASCII(mem(FileNamePtr))) & ".P"
    End If
    
    Err.Clear
    hFile = FreeFile
    Open sFileName For Output As hFile
    If Err.Number <> 0 Then
        MsgBox "Error: Unable to open output file:" & vbCrLf & vbCrLf & "   " & CurDir$ & "\" & sFileName, vbOKOnly Or vbExclamation, "vb81"
        Exit Sub
    End If
        
    For i = &H4009 To peekw(16404)
        Print #hFile, Chr$(mem(i));
    Next i
    
    If Err.Number <> 0 Then
        MsgBox "Error: Unable to write to output file:" & vbCrLf & vbCrLf & "   " & CurDir$ & "\" & sFileName, vbOKOnly Or vbExclamation, "vb81"
    End If
    
    Close #hFile
    bInputWait = True
    ShowDisplay True, True
End Sub


Public Sub update_kybd()
    Dim f As Long
    Dim oldLastK1 As Long, oldLastK2 As Long
    Dim LastK1 As Long, LastK2 As Long
    
    
    oldLastK1 = mem(16421)
    oldLastK2 = mem(16422)
       
    If (mem(16443) And 128) = 0 Then
        ' // FAST mode is 3.25MHz
        glTstatesPerInterrupt = 65000
    Else
        ' // SLOW mode is 0.8MHz
        glTstatesPerInterrupt = 16000
        
        ' // Decrement FRAMES when in SLOW mode
        f = (mem(16436) Or (mem((16437)) * 256&)) And 32767
        If f > 0 Then f = f - 1 Else f = 32767
        pokew 16436, ((mem(16436) Or (mem((16437)) * 256&)) And 32768) Or f
    End If
        
    
    If bBooting Then Exit Sub
        
    If oldLastK1 = 0 And oldLastK2 = 0 Then
        mem(16421) = 255
        mem(16422) = 255
        Exit Sub
    End If
    
    ' A
    If (keyA_G And &H1) = 0 Then
        LastK1 = 253
        LastK2 = 253
    End If

    ' S
    If (keyA_G And &H2) = 0 Then
        LastK1 = 253
        LastK2 = 251
    End If

    ' D
    If (keyA_G And &H4) = 0 Then
        LastK1 = 253
        LastK2 = 247
    End If

    ' F
    If (keyA_G And &H8) = 0 Then
        LastK1 = 253
        LastK2 = 239
    End If

    ' G
    If (keyA_G And &H10) = 0 Then
        LastK1 = 253
        LastK2 = 223
    End If

    ' H
    If (keyH_ENT And &H10) = 0 Then
        LastK1 = 191
        LastK2 = 223
    End If

    ' J
    If (keyH_ENT And &H8) = 0 Then
        LastK1 = 191
        LastK2 = 239
    End If

    ' K
    If (keyH_ENT And &H4) = 0 Then
        LastK1 = 191
        LastK2 = 247
    End If

    ' L
    If (keyH_ENT And &H2) = 0 Then
        LastK1 = 191
        LastK2 = 251
    End If

    ' ENTER
    If (keyH_ENT And &H1) = 0 Then
        LastK1 = 191
        LastK2 = 253
    End If

    ' 1
    If (key1_5 And &H1) = 0 Then
        LastK1 = 247
        LastK2 = 253
    End If
    ' 2
    If (key1_5 And &H2) = 0 Then
        LastK1 = 247
        LastK2 = 251
    End If
    ' 3
    If (key1_5 And &H4) = 0 Then
        LastK1 = 247
        LastK2 = 247
    End If
    ' 4
    If (key1_5 And &H8) = 0 Then
        LastK1 = 247
        LastK2 = 239
    End If
    ' 5
    If (key1_5 And &H10) = 0 Then
        LastK1 = 247
        LastK2 = 223
    End If
    ' 6
    If (key6_0 And &H10) = 0 Then
        LastK1 = 239
        LastK2 = 223
    End If
    ' 7
    If (key6_0 And &H8) = 0 Then
        LastK1 = 239
        LastK2 = 239
    End If
    ' 8
    If (key6_0 And &H4) = 0 Then
        LastK1 = 239
        LastK2 = 247
    End If
    ' 9
    If (key6_0 And &H2) = 0 Then
        LastK1 = 239
        LastK2 = 251
    End If
    ' 0
    If (key6_0 And &H1) = 0 Then
        LastK1 = 239
        LastK2 = 253
    End If

    ' Q
    If (keyQ_T And &H1) = 0 Then
        LastK1 = 251
        LastK2 = 253
    End If
    ' W
    If (keyQ_T And &H2) = 0 Then
        LastK1 = 251
        LastK2 = 251
    End If
    ' E
    If (keyQ_T And &H4) = 0 Then
        LastK1 = 251
        LastK2 = 247
    End If
    ' R
    If (keyQ_T And &H8) = 0 Then
        LastK1 = 251
        LastK2 = 239
    End If
    ' T
    If (keyQ_T And &H10) = 0 Then
        LastK1 = 251
        LastK2 = 223
    End If
    ' Y
    If (keyY_P And &H10) = 0 Then
        LastK1 = 223
        LastK2 = 223
    End If
    ' U
    If (keyY_P And &H8) = 0 Then
        LastK1 = 223
        LastK2 = 239
    End If
    ' I
    If (keyY_P And &H4) = 0 Then
        LastK1 = 223
        LastK2 = 247
    End If
    ' O
    If (keyY_P And &H2) = 0 Then
        LastK1 = 223
        LastK2 = 251
    End If
    ' P
    If (keyY_P And &H1) = 0 Then
        LastK1 = 223
        LastK2 = 253
    End If

    ' Z
    If (keyCAPS_V And &H2) = 0 Then
        LastK1 = 254
        LastK2 = 251
    End If
    ' X
    If (keyCAPS_V And &H4) = 0 Then
        LastK1 = 254
        LastK2 = 247
    End If
    ' C
    If (keyCAPS_V And &H8) = 0 Then
        LastK1 = 254
        LastK2 = 239
    End If
    ' V
    If (keyCAPS_V And &H10) = 0 Then
        LastK1 = 254
        LastK2 = 223
    End If
    ' B
    If (keyB_SPC And &H10) = 0 Then
        LastK1 = 127
        LastK2 = 223
    End If
    ' N
    If (keyB_SPC And &H8) = 0 Then
        LastK1 = 127
        LastK2 = 239
    End If
    ' M
    If (keyB_SPC And &H4) = 0 Then
        LastK1 = 127
        LastK2 = 247
    End If
    ' .
    If (keyB_SPC And &H2) = 0 Then
        LastK1 = 127
        LastK2 = 251
    End If
    ' SPACE
    If (keyB_SPC And &H1) = 0 Then
        LastK1 = 127
        LastK2 = 253
    End If

    ' SHIFT
    If (keyCAPS_V And &H1) = 0 Then
        LastK2 = LastK2 And (Not 1&)
    End If
    
    If LastK1 = 0 Then
        mem(16421) = 255
        If (keyCAPS_V And &H1) = 0 Then
             mem(16422) = 254
        Else
            mem(16422) = 255
        End If
        Exit Sub
    End If

    mem(16421) = LastK1
    mem(16422) = LastK2

    If bInputWait = False Then Exit Sub
    
    ' // Set FRAMES
    mem(16424) = 55
    
    If mem(&H4027) = 255 Then
        mem(&H4027) = 15
    Else
        If ((mem(16421) <> oldLastK1) Or ((mem(16422) And &HFE) <> (oldLastK2 And &HFE))) And _
            (mem(16421) <> 255 And mem(16422) <> 255) Then
            mem(16443) = mem(16443) Or 1
        End If
    End If
End Sub


Private Function ZXCharToASCII(ByVal cZX As Byte) As String
    If (cZX And 128) = 128 Then cZX = cZX And 63
    
    Select Case cZX
    Case 0 ' // SPACE
        ZXCharToASCII = " "
    Case 11 To 13
        ' 11 = 34   "
        ' 12 = 35  /#
        ' 13 = 36  $
        ZXCharToASCII = Chr$(cZX + 23)
    Case 14 To 21
        ' 14 = :
        ' 15 = ?
        ' 16 = (
        ' 17 = )
        ' 18 = >
        ' 19 = <
        ' 20 = =
        ' 21 = +
        ZXCharToASCII = "_"
    Case 22
        ' 22 = -
        ZXCharToASCII = "-"
    Case 23 To 26
        ' 23 = *
        ' 24 = /
        ' 25 = ;
        ' 26 = ,
        ZXCharToASCII = "_"
    Case 27
        ' 27 = .
        ZXCharToASCII = "."
    Case 28 To 37
        ZXCharToASCII = Chr$(cZX + 20)
    Case 38 To 63
        ZXCharToASCII = Chr$(cZX + 27)
    Case Else
        ZXCharToASCII = "_"
    End Select
End Function


