/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.flavors;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.AbstractRegexObject;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.charset.ImmutableSortedListOfRanges;
import com.oracle.truffle.regex.charset.Range;
import com.oracle.truffle.regex.charset.UnicodeProperties;
import com.oracle.truffle.regex.errors.RbErrorMessages;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.flavors.RegexFlavorProcessor;
import com.oracle.truffle.regex.tregex.parser.flavors.RubyFlags;
import com.oracle.truffle.regex.tregex.string.Encodings;
import com.oracle.truffle.regex.util.TBitSet;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RubyFlavorProcessor
implements RegexFlavorProcessor {
    private static final TBitSet SYNTAX_CHARACTERS = TBitSet.valueOf(36, 40, 41, 42, 43, 46, 63, 91, 92, 93, 94, 123, 124, 125);
    private static final TBitSet CHAR_CLASS_SYNTAX_CHARACTERS = TBitSet.valueOf(45, 92, 93, 94);
    private static final Map<Character, CodePointSet> UNICODE_CHAR_CLASSES;
    private static final Map<Character, CodePointSet> ASCII_CHAR_CLASSES;
    private static final Map<String, CodePointSet> UNICODE_POSIX_CHAR_CLASSES;
    private static final Map<String, CodePointSet> ASCII_POSIX_CHAR_CLASSES;
    public static final Pattern WORD_CHARS_PATTERN;
    public static final String WORD_BOUNDARY = "(?:(?:^|(?<=\\W))(?=\\w)|(?<=\\w)(?:(?=\\W)|$))";
    public static final String WORD_NON_BOUNDARY = "(?:(?:^|(?<=\\W))(?:(?=\\W)|$)|(?<=\\w)(?=\\w))";
    private static final TBitSet WHITESPACE;
    private final RegexSource inSource;
    private final String inPattern;
    private final String inFlags;
    private boolean silent;
    private int position;
    private final StringBuilder outPattern;
    private final RubyFlags globalFlags;
    private final Deque<RubyFlags> flagsStack;
    private int lookbehindDepth;
    private final Deque<Group> groupStack;
    private Map<String, Integer> namedCaptureGroups;
    private int groupIndex;
    private int numberOfCaptureGroups;
    private TermCategory lastTerm;
    private int lastTermOutPosition;
    private CodePointSetAccumulator curCharClass = new CodePointSetAccumulator();
    private CodePointSetAccumulator charClassTmp = new CodePointSetAccumulator();
    private final List<CodePointSetAccumulator> charClassPool = new ArrayList<CodePointSetAccumulator>();

    @CompilerDirectives.TruffleBoundary
    public RubyFlavorProcessor(RegexSource source) {
        this.inSource = source;
        this.inPattern = source.getPattern();
        this.inFlags = source.getFlags();
        this.position = 0;
        this.outPattern = new StringBuilder(this.inPattern.length());
        this.globalFlags = new RubyFlags(this.inFlags);
        this.flagsStack = new LinkedList<RubyFlags>();
        this.lookbehindDepth = 0;
        this.groupStack = new ArrayDeque<Group>();
        this.namedCaptureGroups = null;
        this.groupIndex = 0;
        this.lastTerm = TermCategory.None;
        this.lastTermOutPosition = -1;
    }

    @Override
    public int getNumberOfCaptureGroups() {
        return this.numberOfCaptureGroups + 1;
    }

    @Override
    public Map<String, Integer> getNamedCaptureGroups() {
        return this.namedCaptureGroups;
    }

    @Override
    public AbstractRegexObject getFlags() {
        return this.globalFlags;
    }

    @Override
    public boolean isUnicodePattern() {
        return true;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void validate() throws RegexSyntaxException {
        this.silent = true;
        this.parse();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public RegexSource toECMAScriptRegex() throws RegexSyntaxException, UnsupportedRegexException {
        this.silent = false;
        this.parse();
        return new RegexSource(this.outPattern.toString(), this.globalFlags.isSticky() ? "suy" : "su", this.inSource.getOptions(), this.inSource.getSource());
    }

    private RubyFlags getLocalFlags() {
        return this.flagsStack.peek();
    }

    private void setLocalFlags(RubyFlags newLocalFlags) {
        this.flagsStack.pop();
        this.flagsStack.push(newLocalFlags);
    }

    private int curChar() {
        return this.inPattern.codePointAt(this.position);
    }

    private int consumeChar() {
        int c = this.curChar();
        this.advance();
        return c;
    }

    private String getMany(Predicate<Integer> pred) {
        StringBuilder out = new StringBuilder();
        while (!this.atEnd() && pred.test(this.curChar())) {
            out.appendCodePoint(this.consumeChar());
        }
        return out.toString();
    }

    private String getUpTo(int count, Predicate<Integer> pred) {
        StringBuilder out = new StringBuilder();
        for (int found = 0; found < count && !this.atEnd() && pred.test(this.curChar()); ++found) {
            out.appendCodePoint(this.consumeChar());
        }
        return out.toString();
    }

    private void advance() {
        if (this.atEnd()) {
            throw this.syntaxErrorAtEnd("unexpected end of pattern");
        }
        this.advance(1);
    }

    private void retreat() {
        this.advance(-1);
    }

    private void advance(int len) {
        this.position = this.inPattern.offsetByCodePoints(this.position, len);
    }

    private boolean match(String next) {
        if (this.inPattern.regionMatches(this.position, next, 0, next.length())) {
            this.position += next.length();
            return true;
        }
        return false;
    }

    private void mustMatch(String next) {
        assert ("}".equals(next) || ")".equals(next));
        if (!this.match(next)) {
            throw this.syntaxErrorHere("}".equals(next) ? "expected }" : "expected )");
        }
    }

    private boolean atEnd() {
        return this.position >= this.inPattern.length();
    }

    private void bailOut(String reason) throws UnsupportedRegexException {
        if (!this.silent) {
            throw new UnsupportedRegexException(reason);
        }
    }

    private void emitSnippet(CharSequence snippet) {
        if (!this.silent) {
            this.outPattern.append(snippet);
        }
    }

    private void emitRawCodepoint(int codepoint) {
        if (!this.silent) {
            this.outPattern.appendCodePoint(codepoint);
        }
    }

    private void emitCharNoCasing(int codepoint, boolean inCharClass) {
        if (!this.silent) {
            TBitSet syntaxChars;
            TBitSet tBitSet = syntaxChars = inCharClass ? CHAR_CLASS_SYNTAX_CHARACTERS : SYNTAX_CHARACTERS;
            if (syntaxChars.get(codepoint)) {
                this.emitSnippet("\\");
            }
            this.emitRawCodepoint(codepoint);
        }
    }

    private void emitChar(int codepoint) {
        if (!this.silent) {
            if (this.getLocalFlags().isIgnoreCase()) {
                this.emitCharSet(CodePointSet.create(codepoint, codepoint));
            } else {
                this.emitCharNoCasing(codepoint, false);
            }
        }
    }

    private void emitString(String string) {
        if (!this.silent) {
            int i = 0;
            while (i < string.length()) {
                int outPosition = this.outPattern.length();
                this.emitChar(string.codePointAt(i));
                this.lastTerm = TermCategory.Atom;
                this.lastTermOutPosition = outPosition;
                i = string.offsetByCodePoints(i, 1);
            }
        }
    }

    private void emitCharSet() {
        if (!this.silent) {
            this.caseFold();
            if (this.curCharClass.matchesSingleChar()) {
                this.emitCharNoCasing(this.curCharClass.get().getLo(0), false);
            } else {
                this.emitSnippet("[");
                for (Range r : this.curCharClass) {
                    if (r.isSingle()) {
                        this.emitCharNoCasing(r.lo, true);
                        continue;
                    }
                    this.emitCharNoCasing(r.lo, true);
                    this.emitSnippet("-");
                    this.emitCharNoCasing(r.hi, true);
                }
                this.emitSnippet("]");
            }
        }
    }

    private void emitCharSet(CodePointSet charSet) {
        if (!this.silent) {
            this.curCharClass.clear();
            this.curCharClass.addSet(charSet);
            this.emitCharSet();
        }
    }

    private void caseFold() {
        if (!this.getLocalFlags().isIgnoreCase()) {
            return;
        }
        this.bailOut("Ruby-style case folding is not supported");
    }

    private void negateCharClass() {
        this.charClassTmp.clear();
        this.curCharClass.invert(this.charClassTmp, this.inSource.getEncoding());
        CodePointSetAccumulator swap = this.curCharClass;
        this.curCharClass = this.charClassTmp;
        this.charClassTmp = swap;
    }

    private RegexSyntaxException syntaxErrorAtEnd(String message) {
        return RegexSyntaxException.createPattern(this.inSource, message, this.inPattern.length() - 1);
    }

    private RegexSyntaxException syntaxErrorHere(String message) {
        return RegexSyntaxException.createPattern(this.inSource, message, this.position);
    }

    private RegexSyntaxException syntaxErrorAt(String message, int pos) {
        return RegexSyntaxException.createPattern(this.inSource, message, pos);
    }

    private static boolean isOctDigit(int c) {
        return c >= 48 && c <= 55;
    }

    private static boolean isDecDigit(int c) {
        return c >= 48 && c <= 57;
    }

    private static boolean isHexDigit(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70;
    }

    /*
     * Unable to fully structure code
     */
    private void scanForCaptureGroups() {
        restorePosition = this.position;
        this.numberOfCaptureGroups = 0;
        charClassDepth = 0;
        block10: while (!this.atEnd()) {
            switch (this.consumeChar()) lbl-1000:
            // 2 sources

            {
                case 92: {
                    do {
                        if (this.match("c")) ** GOTO lbl-1000
                    } while (this.match("C-") || this.match("M-"));
                    c = this.consumeChar();
                    switch (c) {
                        case 103: 
                        case 107: {
                            if (!this.match("<")) break;
                            this.parseGroupReference('>', true, true, c == 107, true);
                        }
                    }
                    continue block10;
                }
                case 91: {
                    ++charClassDepth;
                    if (this.match("]")) continue block10;
                    this.match("^]");
                    continue block10;
                }
                case 93: {
                    --charClassDepth;
                    continue block10;
                }
                case 40: {
                    if (charClassDepth != 0) continue block10;
                    if (this.match("?")) {
                        if (this.match("<") && this.curChar() != 61 && this.curChar() != 33) {
                            groupName = this.parseGroupName('>');
                            if (this.namedCaptureGroups == null) {
                                this.namedCaptureGroups = new HashMap<String, Integer>();
                                this.numberOfCaptureGroups = 0;
                            }
                            if (this.namedCaptureGroups.containsKey(groupName)) {
                                this.bailOut("different capture groups with the same name are not supported");
                            }
                            ++this.numberOfCaptureGroups;
                            this.namedCaptureGroups.put(groupName, this.numberOfCaptureGroups);
                            continue block10;
                        }
                        if (!this.match("(")) continue block10;
                        if (this.match("<")) {
                            this.parseGroupReference('>', true, true, true, true);
                            continue block10;
                        }
                        if (this.match("'")) {
                            this.parseGroupReference('\'', true, true, true, true);
                            continue block10;
                        }
                        if (!RubyFlavorProcessor.isDecDigit(this.curChar())) continue block10;
                        this.parseGroupReference(')', true, false, true, true);
                        continue block10;
                    }
                    if (this.namedCaptureGroups != null) continue block10;
                    ++this.numberOfCaptureGroups;
                    continue block10;
                }
                case 35: {
                    if (!this.globalFlags.isExtended()) continue block10;
                    endOfLine = this.inPattern.indexOf(10, this.position);
                    if (endOfLine >= 0) {
                        this.position = endOfLine + 1;
                        continue block10;
                    }
                    this.position = this.inPattern.length();
                    continue block10;
                }
            }
        }
        this.position = restorePosition;
    }

    private int numberOfCaptureGroups() {
        return this.numberOfCaptureGroups;
    }

    private boolean containsNamedCaptureGroups() {
        return this.namedCaptureGroups != null;
    }

    private void parse() {
        this.scanForCaptureGroups();
        this.flagsStack.push(this.globalFlags);
        this.disjunction();
        this.flagsStack.pop();
        if (!this.atEnd()) {
            assert (this.curChar() == 41);
            throw this.syntaxErrorHere("unbalanced parenthesis");
        }
    }

    private void disjunction() {
        while (true) {
            this.alternative();
            if (!this.match("|")) break;
            this.emitSnippet("|");
            this.lastTerm = TermCategory.None;
            this.lastTermOutPosition = -1;
        }
    }

    private void alternative() {
        this.flagsStack.push(this.getLocalFlags());
        while (!this.atEnd() && this.curChar() != 124 && this.curChar() != 41) {
            this.term();
        }
        this.flagsStack.pop();
    }

    private void term() {
        int outPosition = this.outPattern.length();
        int ch = this.consumeChar();
        if (this.getLocalFlags().isExtended()) {
            if (WHITESPACE.get(ch)) {
                return;
            }
            if (ch == 35) {
                this.comment();
                return;
            }
        }
        switch (ch) {
            case 92: {
                this.escape();
                break;
            }
            case 91: {
                this.characterClass();
                this.lastTerm = TermCategory.Atom;
                this.lastTermOutPosition = outPosition;
                break;
            }
            case 42: 
            case 43: 
            case 63: 
            case 123: {
                this.quantifier(ch);
                break;
            }
            case 46: {
                if (this.getLocalFlags().isMultiline()) {
                    this.emitSnippet(".");
                } else {
                    this.emitSnippet("[^\n]");
                }
                this.lastTerm = TermCategory.Atom;
                this.lastTermOutPosition = outPosition;
                break;
            }
            case 40: {
                this.parens();
                break;
            }
            case 94: {
                this.emitSnippet("(?:^|(?<=[\\n])(?=.))");
                this.lastTerm = TermCategory.OtherAssertion;
                this.lastTermOutPosition = outPosition;
                break;
            }
            case 36: {
                this.emitSnippet("(?:$|(?=[\\n]))");
                this.lastTerm = TermCategory.OtherAssertion;
                this.lastTermOutPosition = outPosition;
                break;
            }
            default: {
                this.emitChar(ch);
                this.lastTerm = TermCategory.Atom;
                this.lastTermOutPosition = outPosition;
            }
        }
    }

    private void comment() {
        while (!this.atEnd()) {
            int ch = this.consumeChar();
            if (ch == 92 && !this.atEnd()) {
                this.advance();
                continue;
            }
            if (ch != 10) continue;
            break;
        }
    }

    private void escape() {
        int outPosition = this.outPattern.length();
        if (this.assertionEscape()) {
            this.lastTerm = TermCategory.OtherAssertion;
        } else if (this.categoryEscape(false)) {
            this.lastTerm = TermCategory.Atom;
        } else if (this.backreference()) {
            this.lastTerm = TermCategory.Atom;
        } else if (this.namedBackreference()) {
            this.lastTerm = TermCategory.Atom;
        } else if (this.lineBreak()) {
            this.lastTerm = TermCategory.Atom;
        } else if (this.extendedGraphemeCluster()) {
            this.lastTerm = TermCategory.Atom;
        } else if (this.keepCommand()) {
            this.lastTerm = TermCategory.OtherAssertion;
        } else if (this.subexpressionCall()) {
            this.lastTerm = TermCategory.Atom;
        } else if (this.stringEscape()) {
            this.lastTerm = TermCategory.Atom;
        } else {
            this.characterEscape();
            this.lastTerm = TermCategory.Atom;
        }
        this.lastTermOutPosition = outPosition;
    }

    private boolean assertionEscape() {
        int restorePosition = this.position;
        switch (this.consumeChar()) {
            case 65: {
                this.emitSnippet("(?:^)");
                return true;
            }
            case 90: {
                this.emitSnippet("(?:$|(?=[\\r\\n]$))");
                return true;
            }
            case 122: {
                this.emitSnippet("(?:$)");
                return true;
            }
            case 71: {
                this.bailOut("\\G escape sequence is not supported");
                return true;
            }
            case 98: {
                if (this.getLocalFlags().isAscii()) {
                    this.emitWordBoundaryAssertion(WORD_BOUNDARY, ASCII_CHAR_CLASSES.get(Character.valueOf('w')), ASCII_CHAR_CLASSES.get(Character.valueOf('W')));
                } else {
                    this.emitWordBoundaryAssertion(WORD_BOUNDARY, UNICODE_CHAR_CLASSES.get(Character.valueOf('w')), UNICODE_CHAR_CLASSES.get(Character.valueOf('W')));
                }
                return true;
            }
            case 66: {
                if (this.getLocalFlags().isAscii()) {
                    this.emitWordBoundaryAssertion(WORD_NON_BOUNDARY, ASCII_CHAR_CLASSES.get(Character.valueOf('w')), ASCII_CHAR_CLASSES.get(Character.valueOf('W')));
                } else {
                    this.emitWordBoundaryAssertion(WORD_NON_BOUNDARY, UNICODE_CHAR_CLASSES.get(Character.valueOf('w')), UNICODE_CHAR_CLASSES.get(Character.valueOf('W')));
                }
                return true;
            }
        }
        this.position = restorePosition;
        return false;
    }

    private void emitWordBoundaryAssertion(String snippetTemplate, CodePointSet wordChars, CodePointSet nonWordChars) {
        Matcher matcher = WORD_CHARS_PATTERN.matcher(snippetTemplate);
        int lastAppendPosition = 0;
        while (matcher.find()) {
            this.emitSnippet(snippetTemplate.substring(lastAppendPosition, matcher.start()));
            if (matcher.group().equals("\\w")) {
                this.emitCharSet(wordChars);
            } else {
                assert (matcher.group().equals("\\W"));
                this.emitCharSet(nonWordChars);
            }
            lastAppendPosition = matcher.end();
        }
        this.emitSnippet(snippetTemplate.substring(lastAppendPosition));
    }

    private boolean categoryEscape(boolean inCharClass) {
        int restorePosition = this.position;
        switch (this.curChar()) {
            case 68: 
            case 72: 
            case 83: 
            case 87: 
            case 100: 
            case 104: 
            case 115: 
            case 119: {
                CodePointSet charSet;
                char className = (char)this.curChar();
                this.advance();
                if (this.getLocalFlags().isAscii() || this.getLocalFlags().isDefault()) {
                    charSet = ASCII_CHAR_CLASSES.get(Character.valueOf(className));
                } else {
                    assert (this.getLocalFlags().isUnicode());
                    charSet = UNICODE_CHAR_CLASSES.get(Character.valueOf(className));
                }
                if (inCharClass) {
                    this.curCharClass.addSet(charSet);
                } else {
                    this.emitCharSet(charSet);
                }
                return true;
            }
            case 80: 
            case 112: {
                boolean capitalP = this.curChar() == 80;
                this.advance();
                if (this.match("{")) {
                    CodePointSet property;
                    boolean negative;
                    String propertySpec = this.getMany(c -> c != 125);
                    if (this.atEnd()) {
                        this.position = restorePosition;
                        return false;
                    }
                    this.advance();
                    boolean caret = propertySpec.startsWith("^");
                    boolean bl = negative = !(!capitalP && !caret || capitalP && caret);
                    if (caret) {
                        propertySpec = propertySpec.substring(1);
                    }
                    if (UNICODE_POSIX_CHAR_CLASSES.containsKey(propertySpec.toLowerCase())) {
                        property = UNICODE_POSIX_CHAR_CLASSES.get(propertySpec.toLowerCase());
                    } else if (UnicodeProperties.isSupportedGeneralCategory(propertySpec, true)) {
                        property = UnicodeProperties.getProperty("General_Category=" + propertySpec, true);
                    } else if (UnicodeProperties.isSupportedScript(propertySpec, true)) {
                        property = UnicodeProperties.getProperty("Script=" + propertySpec, true);
                    } else if (UnicodeProperties.isSupportedProperty(propertySpec, true)) {
                        property = UnicodeProperties.getProperty(propertySpec, true);
                    } else {
                        this.bailOut("unsupported Unicode property " + propertySpec);
                        property = CodePointSet.getEmpty();
                    }
                    if (negative) {
                        property = property.createInverse(Encodings.UTF_32);
                    }
                    if (inCharClass) {
                        this.curCharClass.addSet(property);
                    } else {
                        this.emitCharSet(property);
                    }
                    return true;
                }
                this.position = restorePosition;
                return false;
            }
        }
        return false;
    }

    private boolean backreference() {
        int restorePosition = this.position;
        if (this.curChar() >= 49 && this.curChar() <= 57) {
            String number = this.getUpTo(4, RubyFlavorProcessor::isDecDigit);
            int groupNumber = Integer.parseInt(number);
            if (groupNumber > 1000) {
                this.position = restorePosition;
                return false;
            }
            if (this.containsNamedCaptureGroups()) {
                throw this.syntaxErrorAt("numbered backref/call is not allowed. (use name)", restorePosition);
            }
            if (groupNumber > this.numberOfCaptureGroups()) {
                throw this.syntaxErrorAt(RbErrorMessages.invalidGroupReference(number), restorePosition);
            }
            if (this.lookbehindDepth > 0) {
                throw this.syntaxErrorAt("invalid pattern in look-behind", restorePosition);
            }
            if (groupNumber > this.groupIndex && groupNumber >= 10) {
                this.position = restorePosition;
                return false;
            }
            this.emitBackreference(groupNumber);
            return true;
        }
        return false;
    }

    private boolean namedBackreference() {
        if (this.match("k<")) {
            int groupNumber = this.parseGroupReference('>', true, true, true, false);
            this.emitBackreference(groupNumber);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int parseGroupReference(char terminator, boolean allowNumeric, boolean allowNamed, boolean allowLevels, boolean ignoreUnresolved) {
        int groupNumber;
        int beginPos = this.position;
        if (this.curChar() == 45 || RubyFlavorProcessor.isDecDigit(this.curChar())) {
            if (!allowNumeric) {
                throw this.syntaxErrorHere("invalid group name");
            }
            int sign = this.match("-") ? -1 : 1;
            String groupName = this.getMany(RubyFlavorProcessor::isDecDigit);
            try {
                groupNumber = sign * Integer.parseInt(groupName);
                if (groupNumber < 0) {
                    groupNumber = this.numberOfCaptureGroups() + 1 + groupNumber;
                }
            }
            catch (NumberFormatException e) {
                throw this.syntaxErrorAt("invalid group name", beginPos);
            }
            if (this.containsNamedCaptureGroups()) {
                throw this.syntaxErrorAt("numbered backref/call is not allowed. (use name)", beginPos);
            }
            if (!(ignoreUnresolved || groupNumber > 0 && groupNumber <= this.numberOfCaptureGroups())) {
                throw this.syntaxErrorAt(RbErrorMessages.invalidGroupReference(groupName), beginPos);
            }
        } else {
            if (!allowNamed) {
                throw this.syntaxErrorAt("invalid group name", beginPos);
            }
            String groupName = this.getMany(c -> {
                if (allowLevels) {
                    return c != terminator && c != 43 && c != 45;
                }
                return c != terminator;
            });
            if (groupName.isEmpty()) {
                throw this.syntaxErrorAt("missing group name", beginPos);
            }
            if (this.namedCaptureGroups == null || !this.namedCaptureGroups.containsKey(groupName)) {
                if (!ignoreUnresolved) throw this.syntaxErrorAt(RbErrorMessages.unknownGroupName(groupName), beginPos);
                groupNumber = -1;
            } else {
                groupNumber = this.namedCaptureGroups.get(groupName);
            }
        }
        if (allowLevels && (this.curChar() == 43 || this.curChar() == 45)) {
            this.advance();
            String level = this.getMany(RubyFlavorProcessor::isDecDigit);
            if (level.isEmpty()) {
                throw this.syntaxErrorAt("invalid group name", beginPos);
            }
            this.bailOut("backreferences to other levels are not supported");
        }
        if (!this.match(Character.toString(terminator))) {
            throw this.syntaxErrorAt("invalid group name", beginPos);
        }
        if (this.lookbehindDepth <= 0) return groupNumber;
        throw this.syntaxErrorAt("invalid pattern in look-behind", beginPos);
    }

    private void emitBackreference(int groupNumber) {
        if (this.isCaptureGroupOpen(groupNumber)) {
            this.emitSnippet("[]");
        } else if (this.getLocalFlags().isIgnoreCase()) {
            this.bailOut("case insensitive backreferences not supported");
        } else {
            this.emitSnippet("\\" + groupNumber);
        }
    }

    private boolean isCaptureGroupOpen(int groupNumber) {
        for (Group openGroup : this.groupStack) {
            if (groupNumber != openGroup.groupNumber) continue;
            return true;
        }
        return false;
    }

    private boolean lineBreak() {
        if (this.curChar() == 82) {
            this.advance();
            this.bailOut("line break escape not supported");
            return true;
        }
        return false;
    }

    private boolean extendedGraphemeCluster() {
        if (this.curChar() == 88) {
            this.advance();
            this.bailOut("extended grapheme cluster escape not supported");
            return true;
        }
        return false;
    }

    private boolean keepCommand() {
        if (this.curChar() == 75) {
            this.advance();
            this.bailOut("keep command not supported");
            return true;
        }
        return false;
    }

    private boolean subexpressionCall() {
        if (this.match("g<")) {
            this.parseGroupReference('>', true, true, false, false);
            this.bailOut("subexpression calls not supported");
            return true;
        }
        return false;
    }

    private boolean stringEscape() {
        int beginPos = this.position - 1;
        if (this.match("u{")) {
            this.getMany(c -> ASCII_POSIX_CHAR_CLASSES.get("space").contains((int)c));
            while (!this.match("}")) {
                String code = this.getMany(RubyFlavorProcessor::isHexDigit);
                try {
                    int codePoint = Integer.parseInt(code, 16);
                    if (codePoint > 0x10FFFF) {
                        throw this.syntaxErrorAt(RbErrorMessages.invalidUnicodeEscape(code), beginPos);
                    }
                    this.emitChar(codePoint);
                }
                catch (NumberFormatException e) {
                    throw this.syntaxErrorAt(RbErrorMessages.badEscape(code), beginPos);
                }
                this.getMany(c -> WHITESPACE.get((int)c));
            }
            return true;
        }
        return false;
    }

    private void characterEscape() {
        this.emitChar(this.silentCharacterEscape());
    }

    private int silentCharacterEscape() {
        int beginPos = this.position;
        int ch = this.consumeChar();
        switch (ch) {
            case 97: {
                return 7;
            }
            case 98: {
                return 8;
            }
            case 101: {
                return 27;
            }
            case 102: {
                return 12;
            }
            case 110: {
                return 10;
            }
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            case 118: {
                return 11;
            }
            case 67: 
            case 99: {
                if (this.atEnd()) {
                    throw this.syntaxErrorAt("end pattern at control", beginPos);
                }
                if (ch == 67 && !this.match("-")) {
                    throw this.syntaxErrorAt("invalid control-code syntax", beginPos);
                }
                int c = this.consumeChar();
                if (c == 63) {
                    return 127;
                }
                if (c == 92) {
                    c = this.silentCharacterEscape();
                }
                return c & 0x9F;
            }
            case 77: {
                if (this.atEnd()) {
                    throw this.syntaxErrorAt("end pattern at meta", beginPos);
                }
                if (!this.match("-")) {
                    throw this.syntaxErrorAt("invalid meta-code syntax", beginPos);
                }
                if (this.atEnd()) {
                    throw this.syntaxErrorAt("end pattern at meta", beginPos);
                }
                int c = this.consumeChar();
                if (c == 92) {
                    c = this.silentCharacterEscape();
                }
                return c & 0xFF | 0x80;
            }
            case 120: {
                String code = this.getUpTo(2, RubyFlavorProcessor::isHexDigit);
                int byteValue = Integer.parseInt(code, 16);
                if (byteValue > 127) {
                    this.bailOut("unsupported multibyte escape");
                }
                return byteValue;
            }
            case 117: {
                String code;
                if (this.match("{")) {
                    code = this.getMany(RubyFlavorProcessor::isHexDigit);
                    this.mustMatch("}");
                } else {
                    code = this.getUpTo(4, RubyFlavorProcessor::isHexDigit);
                    if (code.length() < 4) {
                        throw this.syntaxErrorAt(RbErrorMessages.incompleteEscape(code), beginPos);
                    }
                }
                try {
                    int codePoint = Integer.parseInt(code, 16);
                    if (codePoint > 0x10FFFF) {
                        throw this.syntaxErrorAt(RbErrorMessages.invalidUnicodeEscape(code), beginPos);
                    }
                    return codePoint;
                }
                catch (NumberFormatException e) {
                    throw this.syntaxErrorAt(RbErrorMessages.badEscape(code), beginPos);
                }
            }
        }
        if (RubyFlavorProcessor.isOctDigit(ch)) {
            this.retreat();
            String code = this.getUpTo(3, RubyFlavorProcessor::isOctDigit);
            int codePoint = Integer.parseInt(code, 8);
            if (codePoint > 255) {
                throw this.syntaxErrorAt("too big number", beginPos);
            }
            return codePoint;
        }
        return ch;
    }

    private void characterClass() {
        this.curCharClass.clear();
        this.collectCharClass();
        this.emitCharSet();
    }

    private void collectCharClass() {
        boolean negated = false;
        if (this.match("^")) {
            negated = true;
        }
        int beginPos = this.position - 1;
        int firstPosInside = this.position;
        block12: while (true) {
            Optional<Integer> lowerBound;
            if (this.atEnd()) {
                throw this.syntaxErrorAt("unterminated character set", beginPos);
            }
            int rangeStart = this.position;
            boolean wasNestedCharClass = false;
            int ch = this.consumeChar();
            switch (ch) {
                case 93: {
                    if (this.position != firstPosInside + 1) break block12;
                    throw this.syntaxErrorAt("empty char-class", beginPos);
                }
                case 92: {
                    lowerBound = this.classEscape();
                    break;
                }
                case 91: {
                    if (this.nestedCharClass()) {
                        wasNestedCharClass = true;
                        lowerBound = Optional.empty();
                        break;
                    }
                    lowerBound = Optional.of(ch);
                    break;
                }
                case 38: {
                    if (this.match("&")) {
                        CodePointSetAccumulator curCharClassBackup = this.curCharClass;
                        this.curCharClass = this.acquireCodePointSetAccumulator();
                        this.collectCharClass();
                        curCharClassBackup.intersectWith(this.curCharClass.get());
                        this.curCharClass = curCharClassBackup;
                        break block12;
                    }
                    lowerBound = Optional.of(ch);
                    break;
                }
                default: {
                    lowerBound = Optional.of(ch);
                }
            }
            if (!wasNestedCharClass && this.match("-")) {
                Optional<Integer> upperBound;
                if (this.atEnd()) {
                    throw this.syntaxErrorAt("unterminated character set", beginPos);
                }
                ch = this.consumeChar();
                switch (ch) {
                    case 93: {
                        if (lowerBound.isPresent()) {
                            this.curCharClass.addCodePoint(lowerBound.get());
                        }
                        this.curCharClass.addCodePoint(45);
                        break block12;
                    }
                    case 92: {
                        upperBound = this.classEscape();
                        break;
                    }
                    case 91: {
                        if (this.nestedCharClass()) {
                            wasNestedCharClass = true;
                            upperBound = Optional.empty();
                            break;
                        }
                        upperBound = Optional.of(ch);
                        break;
                    }
                    case 38: {
                        if (this.match("&")) {
                            if (lowerBound.isPresent()) {
                                this.curCharClass.addCodePoint(lowerBound.get());
                            }
                            this.curCharClass.addCodePoint(45);
                            CodePointSetAccumulator curCharClassBackup = this.curCharClass;
                            this.curCharClass = this.acquireCodePointSetAccumulator();
                            this.collectCharClass();
                            curCharClassBackup.intersectWith(this.curCharClass.get());
                            this.curCharClass = curCharClassBackup;
                            break block12;
                        }
                        upperBound = Optional.of(ch);
                        break;
                    }
                    default: {
                        upperBound = Optional.of(ch);
                    }
                }
                if (wasNestedCharClass) continue;
                if (!lowerBound.isPresent() || !upperBound.isPresent() || upperBound.get() < lowerBound.get()) {
                    throw this.syntaxErrorAt(RbErrorMessages.badCharacterRange(this.inPattern.substring(rangeStart, this.position)), rangeStart);
                }
                this.curCharClass.addRange(lowerBound.get(), upperBound.get());
                continue;
            }
            if (!lowerBound.isPresent()) continue;
            this.curCharClass.addCodePoint(lowerBound.get());
        }
        if (negated) {
            this.negateCharClass();
        }
    }

    private CodePointSetAccumulator acquireCodePointSetAccumulator() {
        if (this.charClassPool.isEmpty()) {
            return new CodePointSetAccumulator();
        }
        CodePointSetAccumulator accumulator = this.charClassPool.remove(this.charClassPool.size() - 1);
        accumulator.clear();
        return accumulator;
    }

    private void releaseCodePointSetAccumulator(CodePointSetAccumulator accumulator) {
        this.charClassPool.add(accumulator);
    }

    private boolean nestedCharClass() {
        CodePointSetAccumulator curCharClassBackup = this.curCharClass;
        this.curCharClass = this.acquireCodePointSetAccumulator();
        PosixClassParseResult parseResult = this.collectPosixCharClass();
        if (parseResult == PosixClassParseResult.TryNestedClass) {
            this.collectCharClass();
        }
        curCharClassBackup.addSet(this.curCharClass.get());
        this.releaseCodePointSetAccumulator(this.curCharClass);
        this.curCharClass = curCharClassBackup;
        return parseResult != PosixClassParseResult.NotNestedClass;
    }

    private PosixClassParseResult collectPosixCharClass() {
        String className;
        int restorePosition = this.position;
        if (!this.match(":")) {
            return PosixClassParseResult.TryNestedClass;
        }
        boolean negated = false;
        if (this.match("^")) {
            negated = true;
        }
        if ((className = this.getMany(c -> c != 92 && c != 58 && c != 93)).length() > 20) {
            this.position = restorePosition;
            return PosixClassParseResult.NotNestedClass;
        }
        if (this.match(":]")) {
            CodePointSet charSet;
            if (!UNICODE_POSIX_CHAR_CLASSES.containsKey(className)) {
                throw this.syntaxErrorAt("invalid POSIX bracket type", restorePosition);
            }
            if (this.getLocalFlags().isAscii()) {
                charSet = ASCII_POSIX_CHAR_CLASSES.get(className);
            } else {
                assert (this.getLocalFlags().isDefault() || this.getLocalFlags().isUnicode());
                charSet = UNICODE_POSIX_CHAR_CLASSES.get(className);
            }
            charSet.appendRangesTo(this.curCharClass.get(), 0, charSet.size());
            if (negated) {
                this.negateCharClass();
            }
            return PosixClassParseResult.WasNestedPosixClass;
        }
        this.position = restorePosition;
        return PosixClassParseResult.TryNestedClass;
    }

    private Optional<Integer> classEscape() {
        if (this.categoryEscape(true)) {
            return Optional.empty();
        }
        return Optional.of(this.silentCharacterEscape());
    }

    private void quantifier(int ch) {
        Quantifier quantifier;
        int start = this.position - 1;
        if (ch == 123) {
            if (this.match("}") || this.match(",}")) {
                this.emitString(this.inPattern.substring(start, this.position));
                return;
            }
            Optional<Object> lowerBound = Optional.empty();
            Optional<Object> upperBound = Optional.empty();
            boolean canBeNonGreedy = true;
            String lower = this.getMany(RubyFlavorProcessor::isDecDigit);
            if (!lower.isEmpty()) {
                lowerBound = Optional.of(new BigInteger(lower));
            }
            if (this.match(",")) {
                String upper = this.getMany(RubyFlavorProcessor::isDecDigit);
                if (!upper.isEmpty()) {
                    upperBound = Optional.of(new BigInteger(upper));
                }
            } else {
                upperBound = lowerBound;
                canBeNonGreedy = false;
            }
            if (!this.match("}")) {
                this.emitString(this.inPattern.substring(start, this.position));
                return;
            }
            if (lowerBound.isPresent() && upperBound.isPresent() && ((BigInteger)lowerBound.get()).compareTo((BigInteger)upperBound.get()) > 0) {
                throw this.syntaxErrorAt("min repeat greater than max repeat", start);
            }
            boolean greedy = true;
            if (canBeNonGreedy && this.match("?")) {
                greedy = false;
            }
            quantifier = new Quantifier(((BigInteger)lowerBound.orElse(BigInteger.ZERO)).intValue(), ((BigInteger)upperBound.orElse(BigInteger.valueOf(-1L))).intValue(), greedy);
        } else {
            int upper;
            int lower;
            switch (ch) {
                case 42: {
                    lower = 0;
                    upper = -1;
                    break;
                }
                case 43: {
                    lower = 1;
                    upper = -1;
                    break;
                }
                case 63: {
                    lower = 0;
                    upper = 1;
                    break;
                }
                default: {
                    throw new IllegalStateException("should not reach here");
                }
            }
            boolean greedy = true;
            if (this.match("?")) {
                greedy = false;
            } else if (this.match("+")) {
                this.bailOut("possessive quantifiers not supported");
            }
            quantifier = new Quantifier(lower, upper, greedy);
        }
        switch (this.lastTerm) {
            case None: {
                throw this.syntaxErrorAt("nothing to repeat", start);
            }
            case Quantifier: {
                this.wrapLastTerm("(?:", ")" + quantifier.toString());
                break;
            }
            case LookAroundAssertion: {
                this.bailOut("quantifiers on lookaround assertions not supported");
                this.lastTerm = TermCategory.Quantifier;
                break;
            }
            case OtherAssertion: 
            case Atom: {
                this.emitSnippet(quantifier.toString());
                this.lastTerm = TermCategory.Quantifier;
            }
        }
    }

    private void wrapLastTerm(String prefix, String suffix) {
        if (!this.silent) {
            this.outPattern.insert(this.lastTermOutPosition, prefix);
            this.emitSnippet(suffix);
        }
    }

    private void parens() {
        if (this.atEnd()) {
            throw this.syntaxErrorAtEnd("missing ), unterminated subpattern");
        }
        if (this.match("?")) {
            int ch1 = this.consumeChar();
            block0 : switch (ch1) {
                case 58: {
                    this.group(false);
                    break;
                }
                case 35: {
                    this.parenComment();
                    break;
                }
                case 60: {
                    int ch2 = this.consumeChar();
                    switch (ch2) {
                        case 61: {
                            this.lookbehind(true);
                            break block0;
                        }
                        case 33: {
                            this.lookbehind(false);
                            break block0;
                        }
                    }
                    this.retreat();
                    this.parseGroupName('>');
                    this.group(true);
                    break;
                }
                case 61: {
                    this.lookahead(true);
                    break;
                }
                case 33: {
                    this.lookahead(false);
                    break;
                }
                case 62: {
                    this.bailOut("atomic groups are not supported");
                    this.group(false);
                    break;
                }
                case 40: {
                    this.conditionalBackreference();
                    break;
                }
                case 126: {
                    this.absentExpression();
                    break;
                }
                case 45: 
                case 97: 
                case 100: 
                case 105: 
                case 109: 
                case 117: 
                case 120: {
                    this.flags(ch1);
                    break;
                }
                default: {
                    throw this.syntaxErrorAt(RbErrorMessages.unknownExtension(ch1), this.position - 1);
                }
            }
        } else {
            this.group(!this.containsNamedCaptureGroups());
        }
    }

    private String parseGroupName(char terminator) {
        String groupName = this.getMany(c -> c != terminator);
        if (!this.match(Character.toString(terminator))) {
            throw this.syntaxErrorHere(RbErrorMessages.unterminatedName(terminator));
        }
        if (groupName.isEmpty()) {
            throw this.syntaxErrorHere("missing group name");
        }
        return groupName;
    }

    private void parenComment() {
        int beginPos = this.position - 2;
        while (true) {
            if (this.atEnd()) {
                throw this.syntaxErrorAt("missing ), unterminated comment", beginPos);
            }
            int ch = this.consumeChar();
            if (ch == 92 && !this.atEnd()) {
                this.advance();
                continue;
            }
            if (ch == 41) break;
        }
    }

    private void group(boolean capturing) {
        int outPosition = this.outPattern.length();
        if (capturing) {
            ++this.groupIndex;
            this.groupStack.push(new Group(this.groupIndex));
            this.emitSnippet("(");
        } else {
            this.emitSnippet("(?:");
        }
        this.disjunction();
        if (!this.match(")")) {
            throw this.syntaxErrorHere("missing ), unterminated subpattern");
        }
        this.emitSnippet(")");
        if (capturing) {
            this.groupStack.pop();
        }
        this.lastTerm = TermCategory.Atom;
        this.lastTermOutPosition = outPosition;
    }

    private void lookahead(boolean positive) {
        int outPosition = this.outPattern.length();
        if (positive) {
            this.emitSnippet("(?:(?=");
        } else {
            this.emitSnippet("(?:(?!");
        }
        this.disjunction();
        if (!this.match(")")) {
            throw this.syntaxErrorHere("missing ), unterminated subpattern");
        }
        this.emitSnippet("))");
        this.lastTerm = TermCategory.LookAroundAssertion;
        this.lastTermOutPosition = outPosition;
    }

    private void lookbehind(boolean positive) {
        int outPosition = this.outPattern.length();
        if (positive) {
            this.emitSnippet("(?:(?<=");
        } else {
            this.emitSnippet("(?:(?<!");
        }
        ++this.lookbehindDepth;
        this.disjunction();
        --this.lookbehindDepth;
        if (!this.match(")")) {
            throw this.syntaxErrorHere("missing ), unterminated subpattern");
        }
        this.emitSnippet("))");
        this.lastTerm = TermCategory.LookAroundAssertion;
        this.lastTermOutPosition = outPosition;
    }

    private void conditionalBackreference() {
        this.bailOut("conditional backreference groups not supported");
        if (this.match("<")) {
            this.parseGroupReference('>', true, true, true, false);
            this.mustMatch(")");
        } else if (this.match("'")) {
            this.parseGroupReference('\'', true, true, true, false);
            this.mustMatch(")");
        } else if (RubyFlavorProcessor.isDecDigit(this.curChar())) {
            this.parseGroupReference(')', true, false, true, false);
        } else {
            throw this.syntaxErrorHere("invalid group name");
        }
        this.disjunction();
        if (this.match("|")) {
            this.disjunction();
            if (this.curChar() == 124) {
                throw this.syntaxErrorHere("conditional backref with more than two branches");
            }
        }
        if (!this.match(")")) {
            throw this.syntaxErrorHere("missing ), unterminated subpattern");
        }
        this.lastTerm = TermCategory.Atom;
        this.lastTermOutPosition = -1;
    }

    private void absentExpression() {
        this.disjunction();
        if (!this.match(")")) {
            throw this.syntaxErrorHere("missing ), unterminated subpattern");
        }
        this.bailOut("absent expressions not supported");
        this.lastTerm = TermCategory.Atom;
        this.lastTermOutPosition = -1;
    }

    private void flags(int ch0) {
        int ch = ch0;
        RubyFlags newFlags = this.getLocalFlags();
        boolean negative = false;
        while (ch != 41 && ch != 58) {
            if (ch == 45) {
                negative = true;
            } else if (RubyFlags.isValidFlagChar(ch)) {
                if (negative) {
                    if (RubyFlags.isTypeFlag(ch)) {
                        throw this.syntaxErrorHere("undefined group option");
                    }
                    newFlags = newFlags.delFlag(ch);
                } else {
                    newFlags = newFlags.addFlag(ch);
                }
            } else {
                if (Character.isAlphabetic(ch)) {
                    throw this.syntaxErrorHere("undefined group option");
                }
                throw this.syntaxErrorHere("missing -, : or )");
            }
            if (this.atEnd()) {
                throw this.syntaxErrorAtEnd("missing flag, -, : or )");
            }
            ch = this.consumeChar();
        }
        if (ch == 41) {
            this.openEndedLocalFlags(newFlags);
        } else {
            assert (ch == 58);
            this.localFlags(newFlags);
        }
    }

    private void localFlags(RubyFlags newFlags) {
        this.flagsStack.push(newFlags);
        this.group(false);
        this.flagsStack.pop();
    }

    private void openEndedLocalFlags(RubyFlags newFlags) {
        this.setLocalFlags(newFlags);
        this.lastTerm = TermCategory.None;
        this.lastTermOutPosition = -1;
        this.emitSnippet("(?:");
        this.disjunction();
        this.emitSnippet(")");
    }

    static {
        CodePointSet asciiRange = CodePointSet.create(0, 127);
        CodePointSet nonAsciiRange = CodePointSet.create(128, 0x10FFFF);
        UNICODE_CHAR_CLASSES = new HashMap<Character, CodePointSet>(8);
        ASCII_CHAR_CLASSES = new HashMap<Character, CodePointSet>(8);
        CodePointSet alpha = UnicodeProperties.getProperty("Alphabetic");
        CodePointSet digit = UnicodeProperties.getProperty("General_Category=Decimal_Number");
        CodePointSet space = UnicodeProperties.getProperty("White_Space");
        CodePointSet xdigit = CodePointSet.create(48, 57, 65, 70, 97, 102);
        CodePointSet word = alpha.union(UnicodeProperties.getProperty("General_Category=Mark")).union(digit).union(UnicodeProperties.getProperty("General_Category=Connector_Punctuation")).union(UnicodeProperties.getProperty("Join_Control"));
        UNICODE_CHAR_CLASSES.put(Character.valueOf('d'), digit);
        UNICODE_CHAR_CLASSES.put(Character.valueOf('h'), xdigit);
        UNICODE_CHAR_CLASSES.put(Character.valueOf('s'), space);
        UNICODE_CHAR_CLASSES.put(Character.valueOf('w'), word);
        Character[] characterArray = new Character[]{Character.valueOf('d'), Character.valueOf('h'), Character.valueOf('s'), Character.valueOf('w')};
        int n = characterArray.length;
        for (int i = 0; i < n; ++i) {
            char ctypeChar = characterArray[i].charValue();
            CodePointSet charSet = UNICODE_CHAR_CLASSES.get(Character.valueOf(ctypeChar));
            char complementCTypeChar = Character.toUpperCase(ctypeChar);
            CodePointSet complementCharSet = charSet.createInverse(Encodings.UTF_32);
            UNICODE_CHAR_CLASSES.put(Character.valueOf(complementCTypeChar), complementCharSet);
            ASCII_CHAR_CLASSES.put(Character.valueOf(ctypeChar), asciiRange.createIntersectionSingleRange(charSet));
            ASCII_CHAR_CLASSES.put(Character.valueOf(complementCTypeChar), complementCharSet.union(nonAsciiRange));
        }
        UNICODE_POSIX_CHAR_CLASSES = new HashMap<String, CodePointSet>(14);
        ASCII_POSIX_CHAR_CLASSES = new HashMap<String, CodePointSet>(14);
        CompilationBuffer buffer = new CompilationBuffer(Encodings.UTF_32);
        CodePointSet blank = UnicodeProperties.getProperty("General_Category=Space_Separator").union(CodePointSet.create(9, 9));
        CodePointSet cntrl = UnicodeProperties.getProperty("General_Category=Control");
        CodePointSet graph = space.union(UnicodeProperties.getProperty("General_Category=Control")).union(UnicodeProperties.getProperty("General_Category=Surrogate")).union(UnicodeProperties.getProperty("General_Category=Unassigned")).createInverse(Encodings.UTF_32);
        UNICODE_POSIX_CHAR_CLASSES.put("alpha", alpha);
        UNICODE_POSIX_CHAR_CLASSES.put("alnum", alpha.union(digit));
        UNICODE_POSIX_CHAR_CLASSES.put("blank", blank);
        UNICODE_POSIX_CHAR_CLASSES.put("cntrl", cntrl);
        UNICODE_POSIX_CHAR_CLASSES.put("digit", digit);
        UNICODE_POSIX_CHAR_CLASSES.put("graph", graph);
        UNICODE_POSIX_CHAR_CLASSES.put("lower", UnicodeProperties.getProperty("Lowercase"));
        UNICODE_POSIX_CHAR_CLASSES.put("print", graph.union(blank).subtract(cntrl, buffer));
        UNICODE_POSIX_CHAR_CLASSES.put("punct", (CodePointSet)UnicodeProperties.getProperty("General_Category=Punctuation").union((ImmutableSortedListOfRanges)UnicodeProperties.getProperty("General_Category=Symbol").subtract(alpha, buffer)));
        UNICODE_POSIX_CHAR_CLASSES.put("space", space);
        UNICODE_POSIX_CHAR_CLASSES.put("upper", UnicodeProperties.getProperty("Uppercase"));
        UNICODE_POSIX_CHAR_CLASSES.put("xdigit", xdigit);
        UNICODE_POSIX_CHAR_CLASSES.put("word", word);
        UNICODE_POSIX_CHAR_CLASSES.put("ascii", UnicodeProperties.getProperty("ASCII"));
        for (Map.Entry<String, CodePointSet> entry : UNICODE_POSIX_CHAR_CLASSES.entrySet()) {
            ASCII_POSIX_CHAR_CLASSES.put(entry.getKey(), (CodePointSet)asciiRange.createIntersectionSingleRange((ImmutableSortedListOfRanges)entry.getValue()));
        }
        WORD_CHARS_PATTERN = Pattern.compile("\\\\[wW]");
        WHITESPACE = TBitSet.valueOf(9, 10, 12, 13, 32);
    }

    private static enum PosixClassParseResult {
        WasNestedPosixClass,
        TryNestedClass,
        NotNestedClass;

    }

    private static final class Quantifier {
        public static final int INFINITY = -1;
        public int lower;
        public int upper;
        public boolean greedy;

        Quantifier(int lower, int upper, boolean greedy) {
            this.lower = lower;
            this.upper = upper;
            this.greedy = greedy;
        }

        public String toString() {
            StringBuilder output = new StringBuilder();
            if (this.lower == 0 && this.upper == -1) {
                output.append("*");
            } else if (this.lower == 1 && this.upper == -1) {
                output.append("+");
            } else if (this.lower == 0 && this.upper == 1) {
                output.append("?");
            } else {
                output.append("{");
                output.append(this.lower);
                output.append(",");
                if (this.upper != -1) {
                    output.append(this.upper);
                }
                output.append("}");
            }
            if (!this.greedy) {
                output.append("?");
            }
            return output.toString();
        }
    }

    private static final class Group {
        public final int groupNumber;

        Group(int groupNumber) {
            this.groupNumber = groupNumber;
        }
    }

    private static enum TermCategory {
        LookAroundAssertion,
        OtherAssertion,
        Atom,
        Quantifier,
        None;

    }
}

