/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

import de.joergjahnke.c64.core.EmulatedDevice;
import de.joergjahnke.common.vmabstraction.ResourceLoader;

public abstract class EmulatedIECBusDevice
extends EmulatedDevice {
    protected long lastActiveCycle = 0L;
    protected boolean isSleeping = false;
    protected long nextUpdate = Long.MAX_VALUE;

    public EmulatedIECBusDevice(String name, ResourceLoader resourceLoader) {
        super(name, resourceLoader);
    }

    @Override
    public void stop() {
        if (this.isRunning) {
            this.isRunning = false;
            if (this.cpu.getCycles() - this.lastActiveCycle > this.getDeactivationPeriod()) {
                this.nextUpdate = Long.MAX_VALUE;
                this.getLogger().info(String.valueOf(this.getName()) + " sleeping");
                this.isSleeping = true;
            }
        }
    }

    public void synchronizeWithDevice(EmulatedDevice device) {
        if (this.isSleeping) {
            this.getLogger().info(String.valueOf(this.getName()) + " waking up");
            this.isSleeping = false;
        }
        this.cpu.setCycles(device.getCPU().getCycles());
        this.nextUpdate = device.getCPU().getCycles();
        this.markActive();
    }

    public void markActive() {
        this.lastActiveCycle = this.cpu.getCycles();
    }

    protected abstract long getDeactivationPeriod();
}

