/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.drive;

import de.joergjahnke.c64.core.C64FileEntry;
import de.joergjahnke.c64.drive.TapeDriveHandler;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class T64DriveHandler
extends TapeDriveHandler {
    private int entries = 0;

    @Override
    public void mount(byte[] bytes) {
        this.imageType = 1;
        this.bytes = bytes;
        this.tapePosition = 0;
        byte[] buffer = null;
        buffer = this.readTapeData(32);
        if (!new String(buffer).startsWith("C64")) {
            throw new RuntimeException("Not a valid .t64 file!");
        }
        buffer = this.readTapeData(32);
        if (!(buffer[0] == 0 && buffer[1] == 1 || buffer[0] == 1 && buffer[1] == 1)) {
            throw new RuntimeException("Not a valid .t64 file!");
        }
        this.entries = Math.max(1, (buffer[4] & 0xFF) + (buffer[5] & 0xFF) * 256);
        this.label = this.readC64Filename(buffer, 8, 24);
    }

    @Override
    public Enumeration directoryElements() {
        return new Enumeration(){
            private int retrieved = 0;

            @Override
            public boolean hasMoreElements() {
                return this.retrieved < T64DriveHandler.this.entries;
            }

            public Object nextElement() {
                if (this.retrieved >= T64DriveHandler.this.entries) {
                    throw new NoSuchElementException("Tried to access past end of directory");
                }
                T64DriveHandler.this.gotoTapePosition(64 + this.retrieved * 32);
                byte[] buffer = T64DriveHandler.this.readTapeData(32);
                int tapeType = buffer[0] & 0xFF;
                int fileType = buffer[1] & 0xFF;
                int startAddress = (buffer[2] & 0xFF) + (buffer[3] & 0xFF) * 256;
                int endAddress = (buffer[4] & 0xFF) + (buffer[5] & 0xFF) * 256;
                int offset = (buffer[8] & 0xFF) + (buffer[9] & 0xFF) * 256 + ((buffer[10] & 0xFF) << 16) + ((buffer[11] & 0xFF) << 24);
                String filename = T64DriveHandler.this.readC64Filename(buffer, 16, 16);
                ++this.retrieved;
                int fileLength = endAddress - startAddress;
                int correctedEndAddress = fileLength + offset > T64DriveHandler.this.bytes.length ? T64DriveHandler.this.bytes.length - offset + startAddress : endAddress;
                return new C64FileEntry(filename, fileType, tapeType, startAddress, correctedEndAddress, offset);
            }
        };
    }
}

