/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.smalldisplays;

import de.joergjahnke.c64.core.C64;
import de.joergjahnke.c64.smalldisplays.ScalableVIC6569;
import de.joergjahnke.common.ui.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SmoothingScalableVIC6569
extends ScalableVIC6569 {
    protected boolean savedPaintLine;
    protected int fracY = 0;

    public SmoothingScalableVIC6569(C64 c64, double scaling) {
        super(c64, scaling);
    }

    @Override
    public void initScreenMemory() {
        this.pixels = new int[112000];
        this.scaledPixels = new int[this.getBorderWidth() * this.getBorderHeight()];
    }

    @Override
    protected void setYFraction(int yFraction) {
        super.setYFraction(yFraction);
        this.fracY = 1024 - this.yFraction % 1024;
    }

    @Override
    protected void setNextPixel(int color) {
        int nextPixel_ = this.nextPixel;
        int[] pixels_ = this.pixels;
        int nextScaledPixel_ = this.nextScaledPixel;
        if (this.isPaintLine && (nextScaledPixel_ + this.memInc) % 1024 < nextScaledPixel_ % 1024) {
            int abovePixelIndex = nextPixel_ - 400;
            int fracX = 1024 - nextScaledPixel_ % 1024;
            int fraction22 = fracX * this.fracY >> 10;
            int fraction21 = (1024 - fracX) * this.fracY >> 10;
            int fraction12 = fracX * (1024 - this.fracY) >> 10;
            int fraction11 = (1024 - fracX) * (1024 - this.fracY) >> 10;
            this.scaledPixels[nextScaledPixel_ >> 10] = Color.mix(pixels_[abovePixelIndex - 1], fraction11, pixels_[abovePixelIndex], fraction12, pixels_[nextPixel_ - 1], fraction21, color, fraction22);
        }
        if (color != pixels_[nextPixel_]) {
            this.lastPainted[this.paintY + 1][this.hashCol] = -1;
        }
        pixels_[nextPixel_] = color;
        this.skipPixels(1);
    }

    @Override
    protected void saveCurrentPixelPosition() {
        super.saveCurrentPixelPosition();
        this.savedPaintLine = this.isPaintLine;
    }

    @Override
    protected void restoreSavedPixelPosition() {
        this.isPaintLine = this.savedPaintLine;
        super.restoreSavedPixelPosition();
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void serialize(DataOutputStream out) throws IOException {
        super.serialize(out);
        out.writeBoolean(this.savedPaintLine);
    }

    @Override
    public void deserialize(DataInputStream in) throws IOException {
        super.deserialize(in);
        this.savedPaintLine = in.readBoolean();
    }
}

