/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.util;

import de.joergjahnke.common.util.DefaultObservable;
import de.joergjahnke.common.util.Logger;
import java.util.Vector;

public class DefaultLogger
extends DefaultObservable
implements Logger {
    private boolean isVerbose = false;
    private final int maxSize;
    private boolean storeMessages = false;
    private boolean printMessages = true;
    private final Vector log = new Vector();

    public DefaultLogger(int maxLogSize) {
        this.maxSize = maxLogSize;
        this.setStoreMessages(maxLogSize > 0);
    }

    public final void setStoreMessages(boolean store) {
        this.storeMessages = store;
    }

    public void setPrintMessages(boolean print) {
        this.printMessages = print;
    }

    public String dump(int types) {
        StringBuffer result = new StringBuffer();
        int i = this.log.size() - 1;
        while (i >= 0) {
            LogEntry logEntry = (LogEntry)this.log.elementAt(i);
            if ((types & logEntry.type) != 0) {
                result.append(logEntry);
                result.append('\n');
            }
            --i;
        }
        return result.toString();
    }

    public String dumpAll() {
        return this.dump(7);
    }

    @Override
    public void log(Object message, int type) {
        if (this.storeMessages) {
            LogEntry logEntry = new LogEntry(message, type);
            if (this.log.size() >= this.maxSize) {
                this.log.removeElementAt(0);
            }
            this.log.addElement(logEntry);
        }
        if (this.printMessages) {
            if (4 == type) {
                System.err.println(message);
            } else {
                System.out.println(message);
            }
        }
        this.setChanged(true);
        this.notifyObservers(message);
    }

    @Override
    public void info(Object message) {
        this.log(message, 1);
    }

    @Override
    public final void warning(Object message) {
        this.log(message, 2);
    }

    @Override
    public void error(Object message) {
        this.log(message, 4);
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.isVerbose = verbose;
    }

    @Override
    public boolean isVerbose() {
        return this.isVerbose;
    }

    static class LogEntry {
        public final int type;
        public final Object message;

        public LogEntry(Object message, int type) {
            this.message = message;
            this.type = type;
        }

        public final String toString() {
            return this.message.toString();
        }
    }
}

