/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

import de.joergjahnke.c64.core.EmulatedDevice;
import de.joergjahnke.c64.core.EmulatedIECBusDevice;
import de.joergjahnke.common.io.Serializable;
import de.joergjahnke.common.util.DefaultObservable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class IECBus
extends DefaultObservable
implements Serializable {
    private static final boolean DEBUG = false;
    public static final Integer ATN = new Integer(1);
    public static final Integer CLK = new Integer(2);
    public static final Integer DATA = new Integer(3);
    public static final Integer SIGNAL_ATN = new Integer(1);
    public static final Integer SIGNAL_CONTROLLER_FLAG_MODIFIED = new Integer(2);
    private final EmulatedDevice controller;
    private final Vector devices = new Vector();
    private final Vector deviceStates = new Vector();
    private final DeviceState controllerState = new DeviceState();

    public IECBus(EmulatedDevice controller) {
        this.controller = controller;
    }

    public void reset() {
        Integer[] signals = new Integer[]{ATN, CLK, DATA};
        int i = 0;
        while (i < signals.length) {
            this.controllerState.setSignal(signals[i], false);
            int j = 0;
            while (j < this.deviceStates.size()) {
                DeviceState deviceState = (DeviceState)this.deviceStates.elementAt(j);
                deviceState.setSignal(signals[j], false);
                ++j;
            }
            ++i;
        }
    }

    public EmulatedDevice getController() {
        return this.controller;
    }

    public void addDevice(EmulatedIECBusDevice device) {
        this.devices.addElement(device);
        this.deviceStates.addElement(new DeviceState());
    }

    public void removeDevice(EmulatedIECBusDevice device) {
        int index = this.devices.indexOf(device);
        this.devices.removeElementAt(index);
        this.deviceStates.removeElementAt(index);
    }

    public boolean getSignal(Object flag) {
        return this.getDevicesSignal(flag) | this.controllerState.getSignal(flag);
    }

    private boolean getDevicesSignal(Object flag) {
        Vector deviceStates_ = this.deviceStates;
        int i = 0;
        int to = deviceStates_.size();
        while (i < to) {
            if (((DeviceState)deviceStates_.elementAt(i)).getSignal(flag)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private DeviceState getState(EmulatedDevice device) {
        return device == this.controller ? this.controllerState : (DeviceState)this.deviceStates.elementAt(this.devices.indexOf(device));
    }

    public boolean getSignal(EmulatedDevice device, Object flag) {
        DeviceState deviceState = this.getState(device);
        return deviceState.getSignal(flag);
    }

    public boolean setSignal(EmulatedDevice device, Object flag, boolean state) {
        DeviceState deviceState = this.getState(device);
        boolean oldState = this.getSignal(device, flag);
        deviceState.setSignal(flag, state);
        if (state != oldState) {
            if (device == this.controller) {
                if (flag == ATN && state) {
                    int i = 0;
                    int to = this.devices.size();
                    while (i < to) {
                        EmulatedIECBusDevice attachedDevice = (EmulatedIECBusDevice)this.devices.elementAt(i);
                        if (attachedDevice.getCPU().getCycles() == 0L) {
                            attachedDevice.run();
                            attachedDevice.synchronizeWithDevice(this.controller);
                        } else if (!attachedDevice.isRunning()) {
                            attachedDevice.synchronizeWithDevice(this.controller);
                        }
                        ++i;
                    }
                    this.setChanged(true);
                    this.notifyObservers(SIGNAL_ATN);
                } else {
                    this.setChanged(true);
                    this.notifyObservers(SIGNAL_CONTROLLER_FLAG_MODIFIED);
                }
            } else if (device instanceof EmulatedIECBusDevice) {
                ((EmulatedIECBusDevice)device).markActive();
            }
            return true;
        }
        return false;
    }

    @Override
    public void serialize(DataOutputStream out) throws IOException {
        out.writeInt(this.devices.size());
        int i = 0;
        while (i < this.devices.size()) {
            EmulatedDevice device = (EmulatedDevice)this.devices.elementAt(i);
            DeviceState state = (DeviceState)this.deviceStates.elementAt(i);
            out.writeUTF(device.getName());
            state.serialize(out);
            ++i;
        }
        this.controllerState.serialize(out);
    }

    @Override
    public void deserialize(DataInputStream in) throws IOException {
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            String name = in.readUTF();
            boolean found = false;
            int j = 0;
            while (!found && j < this.devices.size()) {
                EmulatedDevice device = (EmulatedDevice)this.devices.elementAt(j);
                DeviceState state = new DeviceState();
                state.deserialize(in);
                if (device.getName().equals(name)) {
                    this.deviceStates.setElementAt(state, j);
                    found = true;
                }
                ++j;
            }
            if (!found) {
                throw new IOException("Could not read " + this.getClass().getName() + " from stream!");
            }
            ++i;
        }
        this.controllerState.deserialize(in);
    }

    class DeviceState
    implements Serializable {
        public final Vector states = new Vector();

        DeviceState() {
        }

        public boolean getSignal(Object flag) {
            return this.states.contains(flag);
        }

        public void setSignal(Object flag, boolean state) {
            if (state) {
                if (!this.getSignal(flag)) {
                    this.states.addElement(flag);
                }
            } else {
                this.states.removeElement(flag);
            }
        }

        @Override
        public void serialize(DataOutputStream out) throws IOException {
            out.writeInt(this.states.size());
            int i = 0;
            while (i < this.states.size()) {
                out.writeInt((Integer)this.states.elementAt(i));
                ++i;
            }
        }

        @Override
        public void deserialize(DataInputStream in) throws IOException {
            int size = in.readInt();
            this.states.removeAllElements();
            int i = 0;
            while (i < size) {
                int state = in.readInt();
                if (state == ATN) {
                    this.states.addElement(ATN);
                } else if (state == CLK) {
                    this.states.addElement(CLK);
                } else if (state == DATA) {
                    this.states.addElement(DATA);
                } else {
                    throw new IOException("Could not read " + this.getClass().getName() + " from stream!");
                }
                ++i;
            }
        }
    }
}

