/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

import de.joergjahnke.c64.core.C64;
import de.joergjahnke.c64.core.IOChip;
import de.joergjahnke.c64.core.SID6581Voice;
import de.joergjahnke.common.emulation.FrequencyDataProducer;
import de.joergjahnke.common.emulation.FrequencyDataProducerOwner;
import de.joergjahnke.common.emulation.WaveDataProducer;
import de.joergjahnke.common.io.Serializable;
import de.joergjahnke.common.io.SerializationUtils;
import de.joergjahnke.common.util.DefaultObservable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SID6581
extends DefaultObservable
implements IOChip,
WaveDataProducer,
Serializable,
FrequencyDataProducerOwner {
    private static final int FILTER_CUTOFF_FREQ_LOW = 21;
    private static final int FILTER_CUTOFF_FREQ_HIGH = 22;
    private static final int FILTER_RESONANCE_VOICEINPUT_CONTROL = 23;
    private static final int FILTER_MODE_VOLUME = 24;
    private static final int PADDLE1 = 25;
    private static final int PADDLE2 = 26;
    private static final int RANDOM_GENERATOR = 27;
    private static final int ENVELOPE3_OUTPUT = 28;
    public static final int CHANNELS = 1;
    public static final int BYTES_PER_SAMPLE = 2;
    private final SID6581Voice[] voices;
    private final int sampleRate;
    protected final C64 c64;
    protected final int[] registers = new int[32];
    private int lastWritten = 0;
    private final byte[] buffer = new byte[2];

    public SID6581(C64 c64, int sampleRate) {
        this.c64 = c64;
        this.sampleRate = sampleRate;
        this.voices = new SID6581Voice[3];
        int i = 0;
        while (i < this.voices.length) {
            this.voices[i] = new SID6581Voice(this, i * 7);
            ++i;
        }
        this.voices[0].setSyncSource(this.voices[2]);
        this.voices[1].setSyncSource(this.voices[0]);
        this.voices[2].setSyncSource(this.voices[1]);
    }

    public final int getUpdateRate() {
        return 985248 / this.sampleRate;
    }

    private int getCutOffFrequency() {
        int cutoff = this.registers[21] & 7 + (this.registers[22] << 3);
        return (int)(30.0 + (double)cutoff * 5.8182);
    }

    private int getResonance() {
        return this.registers[23] >> 4;
    }

    private boolean isFilterActive(int voice) {
        int filters = this.registers[23] & 0xF;
        return (filters & 1 << voice) != 0;
    }

    private boolean isFilterActive() {
        int filters = this.registers[23] & 0xF;
        return filters > 0;
    }

    protected int getVolume() {
        return this.registers[24] & 0xF;
    }

    private boolean isLowPassFilterActive() {
        return (this.registers[24] & 0x10) != 0;
    }

    private boolean isBandPassFilterActive() {
        return (this.registers[24] & 0x20) != 0;
    }

    private boolean isHighPassFilterActive() {
        return (this.registers[24] & 0x40) != 0;
    }

    private boolean isDisconnectOscillator3() {
        return (this.registers[24] & 0x80) != 0;
    }

    @Override
    public void reset() {
        this.lastWritten = 0;
        int i = 0;
        while (i < this.voices.length) {
            this.voices[i].reset();
            ++i;
        }
    }

    @Override
    public final int readRegister(int register) {
        switch (register) {
            case 25: 
            case 26: {
                return 0;
            }
            case 27: {
                return this.voices[2].getOscillatorOutput();
            }
            case 28: {
                return this.voices[2].getEnvelopeOutput();
            }
        }
        return this.lastWritten;
    }

    @Override
    public final void writeRegister(int register, int data) {
        this.lastWritten = data;
        if (register < 21) {
            this.voices[register / 7].writeRegister(register % 7, data);
        } else {
            this.registers[register] = data;
        }
    }

    @Override
    public final long getNextUpdate() {
        return this.voices[0].getNextUpdate();
    }

    @Override
    public void update(long cycles) {
        SID6581Voice[] voices_ = this.voices;
        int i = 0;
        int to = voices_.length;
        while (i < to) {
            voices_[i].update(cycles);
            ++i;
        }
        if (voices_[0].hasNewOutput()) {
            int filterSamples = 0;
            int directSamples = 0;
            int i2 = 0;
            int to2 = voices_.length;
            while (i2 < to2) {
                int output = voices_[i2].getOutput();
                if (this.isFilterActive(i2)) {
                    filterSamples += output >> 2;
                } else if (i2 != 2 || !this.isDisconnectOscillator3()) {
                    directSamples += output >> 2;
                }
                ++i2;
            }
            int sample = filterSamples;
            sample += directSamples;
            sample *= this.getVolume();
            this.buffer[0] = (byte)((sample >>= 3) & 0xFF);
            this.buffer[1] = (byte)(sample >> 8);
            this.setChanged(true);
            this.notifyObservers(this.buffer);
        }
    }

    @Override
    public final int getSampleRate() {
        return this.sampleRate;
    }

    @Override
    public final int getBitsPerSample() {
        return 16;
    }

    @Override
    public final int getChannels() {
        return 1;
    }

    @Override
    public int getFrequencyDataProducerCount() {
        return this.voices.length;
    }

    @Override
    public FrequencyDataProducer getFrequencyDataProducers(int n) {
        return this.voices[n];
    }

    @Override
    public void serialize(DataOutputStream out) throws IOException {
        out.writeInt(this.sampleRate);
        out.writeInt(this.lastWritten);
        SerializationUtils.serialize(out, this.registers);
        SerializationUtils.serialize(out, this.buffer);
        SerializationUtils.serialize(out, this.voices);
    }

    @Override
    public void deserialize(DataInputStream in) throws IOException {
        if (this.sampleRate != in.readInt()) {
            throw new IllegalStateException("Sample rate of the emulator does not match the saved sample rate!");
        }
        this.lastWritten = in.readInt();
        SerializationUtils.deserialize(in, this.registers);
        SerializationUtils.deserialize(in, this.buffer);
        SerializationUtils.deserialize(in, this.voices);
    }
}

