/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

import de.joergjahnke.c64.core.C1541;
import de.joergjahnke.c64.core.EmulatedDevice;
import de.joergjahnke.c64.core.IECBus;
import de.joergjahnke.c64.core.VIA6522;
import de.joergjahnke.common.util.Observer;

public class VIA6522_BC
extends VIA6522
implements Observer {
    private static final int SB_DATA_IN = 1;
    public static final int SB_DATA_OUT = 2;
    private static final int SB_CLK_IN = 4;
    public static final int SB_CLK_OUT = 8;
    public static final int SB_ATN_OUT = 16;
    public static final int SB_ATN_IN = 128;
    private final IECBus iecBus;

    public VIA6522_BC(C1541 c1541, IECBus iecBus) {
        super(c1541);
        this.iecBus = iecBus;
    }

    private void updateDataLine() {
        EmulatedDevice controller = this.iecBus.getController();
        boolean isData = this.iecBus.getSignal(this.c1541, IECBus.DATA);
        this.iecBus.setSignal(this.c1541, IECBus.DATA, isData |= this.iecBus.getSignal(controller, IECBus.ATN) ^ (super.readRegister(0) & 0x10) != 0);
    }

    @Override
    public int readRegister(int register) {
        switch (register) {
            case 0: {
                return super.readRegister(register) & 0x1A | this.c1541.getID() << 5 | (this.iecBus.getSignal(IECBus.ATN) ? 128 : 0) | (this.iecBus.getSignal(IECBus.CLK) ? 4 : 0) | (this.iecBus.getSignal(IECBus.DATA) ? 1 : 0);
            }
            case 15: {
                return 255;
            }
        }
        return super.readRegister(register);
    }

    @Override
    public void writeRegister(int register, int data) {
        super.writeRegister(register, data);
        switch (register) {
            case 0: 
            case 2: {
                this.iecBus.setSignal(this.c1541, IECBus.CLK, (super.readRegister(0) & 8) != 0);
                this.iecBus.setSignal(this.c1541, IECBus.DATA, (super.readRegister(0) & 2) != 0);
                this.updateDataLine();
            }
        }
    }

    @Override
    public void update(Object observed, Object arg) {
        if (observed == this.iecBus) {
            if (IECBus.SIGNAL_ATN == arg) {
                this.registers[13] = this.registers[13] | 2;
                this.registers[0] = this.registers[0] | 2;
                this.checkInterrupts();
            }
            if (IECBus.SIGNAL_ATN == arg || IECBus.SIGNAL_CONTROLLER_FLAG_MODIFIED == arg) {
                this.updateDataLine();
            }
        }
    }
}

