/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.drive;

import de.joergjahnke.c64.core.C64FileEntry;
import de.joergjahnke.c64.drive.TapeDriveHandler;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class PRGDriveHandler
extends TapeDriveHandler {
    @Override
    public void mount(byte[] bytes) {
        this.imageType = 1;
        this.bytes = bytes;
        this.tapePosition = 0;
        this.label = ".PRG FILE";
    }

    @Override
    public Enumeration directoryElements() {
        return new Enumeration(){
            private int retrieved = 0;

            @Override
            public boolean hasMoreElements() {
                return this.retrieved < 1;
            }

            public Object nextElement() {
                if (this.retrieved > 0) {
                    throw new NoSuchElementException("Tried to access past end of directory");
                }
                PRGDriveHandler.this.gotoTapePosition(0);
                byte[] buffer = PRGDriveHandler.this.readTapeData(2);
                int fileType = 130;
                int startAddress = (buffer[0] & 0xFF) + (buffer[1] & 0xFF) * 256;
                int offset = PRGDriveHandler.this.tapePosition;
                String filename = "FILE";
                ++this.retrieved;
                return new C64FileEntry("FILE", 130, startAddress, offset);
            }
        };
    }
}

