/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.smalldisplays;

import de.joergjahnke.c64.core.C64;
import de.joergjahnke.c64.core.VIC6569;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ScalableVIC6569
extends VIC6569 {
    protected static final int MULTIPLIER_BITS = 10;
    protected static final int MULTIPLIER = 1024;
    private final double scaling;
    protected int memInc;
    private int borderWidth;
    protected int[] scaledPixels = null;
    protected int nextScaledPixel = 0;
    protected int yFraction;
    protected boolean isPaintLine = true;
    protected int savedScaledPosition;
    protected int savedYFraction;
    protected final boolean isScaledUp;
    protected final int pixelsPerPaint;

    public ScalableVIC6569(C64 c64, double scaling) {
        super(c64);
        if (scaling <= 0.0) {
            throw new IllegalArgumentException("Scaling factor must be >0!");
        }
        this.scaling = Math.floor(scaling * 8.0) / 8.0;
        this.determineBorderWidth();
        this.memInc = (int)(this.getScaling() * 1024.0);
        this.pixelsPerPaint = (int)Math.floor(scaling + 0.99);
        this.isScaledUp = this.pixelsPerPaint >= 2;
    }

    @Override
    public void initScreenMemory() {
        this.pixels = new int[this.getBorderWidth() * this.getBorderHeight()];
        this.scaledPixels = this.pixels;
    }

    public final double getScaling() {
        return this.scaling;
    }

    @Override
    public int getDisplayWidth() {
        return (int)((double)super.getDisplayWidth() * this.getScaling());
    }

    @Override
    public int getDisplayHeight() {
        return (int)((double)super.getDisplayHeight() * this.getScaling());
    }

    @Override
    public final int getBorderWidth() {
        return this.borderWidth;
    }

    @Override
    public final int getBorderHeight() {
        return (int)((double)super.getBorderHeight() * this.getScaling());
    }

    private void determineBorderWidth() {
        this.borderWidth = (int)((double)super.getBorderWidth() * this.getScaling());
    }

    protected void setYFraction(int yFraction) {
        this.yFraction = yFraction;
    }

    @Override
    public void gotoPixel(int x, int y) {
        this.nextScaledPixel = (int)((Math.floor((double)y * this.getScaling()) * (double)this.getBorderWidth() + (double)x * this.getScaling()) * 1024.0);
        this.setYFraction((int)((double)y * this.getScaling() * 1024.0) % 1024);
        this.isPaintLine = (double)(y + 1) * this.getScaling() % 1.0 < this.getScaling();
        super.gotoPixel(x, y);
    }

    @Override
    protected boolean isValidPixel() {
        return this.nextScaledPixel >= 0 && this.nextScaledPixel >> 10 < this.scaledPixels.length;
    }

    @Override
    public int getNextPixel() {
        return this.nextScaledPixel >> 10;
    }

    @Override
    protected void setNextPixel(int color) {
        if (this.isPaintLine) {
            if (this.isScaledUp) {
                int pixelsPerPaint_ = this.pixelsPerPaint;
                int borderWidth_ = this.borderWidth;
                int[] scaledPixels_ = this.scaledPixels;
                int pos = this.nextScaledPixel >> 10;
                int y = 0;
                int yy = 0;
                while (y < pixelsPerPaint_) {
                    int x = 0;
                    while (x < pixelsPerPaint_) {
                        scaledPixels_[pos + x + yy] = color;
                        ++x;
                    }
                    ++y;
                    yy += borderWidth_;
                }
            } else {
                this.scaledPixels[this.nextScaledPixel >> 10] = color;
            }
        }
        this.skipPixels(1);
    }

    @Override
    protected void skipPixels(int n) {
        this.nextScaledPixel += n * this.memInc;
        super.skipPixels(n);
    }

    @Override
    protected void saveCurrentPixelPosition() {
        super.saveCurrentPixelPosition();
        this.savedScaledPosition = this.nextScaledPixel;
        this.savedYFraction = this.yFraction;
    }

    @Override
    protected void restoreSavedPixelPosition() {
        this.setYFraction(this.savedYFraction);
        this.nextScaledPixel = this.savedScaledPosition;
        super.restoreSavedPixelPosition();
    }

    @Override
    public int[] getRGBData() {
        return this.scaledPixels;
    }

    @Override
    public void reset() {
        if (this.scaledPixels != this.pixels) {
            int i = 0;
            while (i < this.scaledPixels.length) {
                this.scaledPixels[i] = 0;
                ++i;
            }
        }
        super.reset();
    }

    @Override
    public void serialize(DataOutputStream out) throws IOException {
        super.serialize(out);
        out.writeBoolean(this.isPaintLine);
        out.writeInt(this.memInc);
        out.writeInt(this.borderWidth);
        out.writeInt(this.nextScaledPixel);
        out.writeInt(this.yFraction);
        out.writeInt(this.savedScaledPosition);
        out.writeInt(this.savedYFraction);
    }

    @Override
    public void deserialize(DataInputStream in) throws IOException {
        super.deserialize(in);
        this.isPaintLine = in.readBoolean();
        this.memInc = in.readInt();
        this.borderWidth = in.readInt();
        this.nextScaledPixel = in.readInt();
        this.setYFraction(in.readInt());
        this.savedScaledPosition = in.readInt();
        this.savedYFraction = in.readInt();
    }
}

