/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

import de.joergjahnke.c64.core.C64;
import de.joergjahnke.c64.core.CIA6526_1;
import de.joergjahnke.c64.core.CIA6526_2;
import de.joergjahnke.c64.core.CPU6502;
import de.joergjahnke.c64.core.VIC6569;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class C64CPU6510
extends CPU6502 {
    private static final int RAM_SIZE = 65536;
    private static final int ROM_OFFSET = 65536;
    private static final int BASIC_ROM_SIZE = 8192;
    private static final int BASIC_ROM_ADDRESS = 40960;
    private static final int KERNAL_ROM_SIZE = 8192;
    private static final int KERNAL_ROM_ADDRESS = 57344;
    private static final int CHAR_ROM_SIZE = 4096;
    public static final int CHAR_ROM_ADDRESS = 53248;
    private static final int COLOR_RAM_SIZE = 1024;
    public static final int COLOR_RAM_ADDRESS = 55296;
    private static final int IO_AREA_SIZE = 512;
    private static final int IO_AREA_ADDRESS = 56832;
    public static final int COLOR_RAM_OFFSET = 10240;
    private static final int IO_AREA_OFFSET = 9728;
    private static final int BASIC_ROM_OFFSET = 26112;
    private static final int KERNAL_ROM_OFFSET = 17920;
    public static final int CHAR_ROM_OFFSET = 30208;
    protected boolean isBasicROMActive = true;
    protected boolean isKernalROMActive = true;
    protected boolean isCharROMActive = false;
    protected boolean isIOActive = true;
    private final C64 c64;
    private VIC6569 vic;
    private int pcAdjusted;
    private int lastPcAdjustment;

    public C64CPU6510(C64 c64) {
        super(c64, 87552);
        this.ramSize = 67072;
        this.c64 = c64;
        this.setLogger(this.c64.getLogger());
        this.installROMs();
        this.setPC(64738);
    }

    public void setVIC(VIC6569 vic) {
        this.vic = vic;
    }

    @Override
    protected final int getPC() {
        return this.pcAdjusted;
    }

    @Override
    protected final void setPC(int value) {
        if ((value & 0xF000) != (this.pc & 0xF000)) {
            this.pc = value;
            this.pcAdjusted = this.getAdjustedMemoryAddress(this.pc);
            this.lastPcAdjustment = this.pcAdjusted - this.pc;
        } else {
            this.pc = value;
            this.pcAdjusted = this.pc + this.lastPcAdjustment;
        }
    }

    @Override
    protected final void addPC(int size) {
        this.pc += size;
        this.pcAdjusted += size;
    }

    private final int getAdjustedMemoryAddress(int address) {
        switch (address & 0xF000) {
            case 40960: 
            case 45056: {
                return this.isBasicROMActive ? 26112 + address : address;
            }
            case 57344: 
            case 61440: {
                return this.isKernalROMActive ? 17920 + address : address;
            }
        }
        return address;
    }

    @Override
    protected final byte readByte(int address) {
        while (!this.vic.isBusAvailable()) {
            this.vic.update(++this.cycles);
        }
        switch (address & 0xF000) {
            case 40960: 
            case 45056: {
                return this.memory[this.isBasicROMActive ? 26112 + address : address];
            }
            case 53248: {
                if (this.isIOActive) {
                    switch (address & 0xFF00) {
                        case 53248: 
                        case 53504: 
                        case 53760: 
                        case 54016: {
                            return (byte)this.c64.getVIC().readRegister(address & 0x3F);
                        }
                        case 54272: 
                        case 54528: 
                        case 54784: 
                        case 55040: {
                            return (byte)this.c64.getSID().readRegister(address & 0x1F);
                        }
                        case 55296: 
                        case 55552: 
                        case 55808: 
                        case 56064: {
                            return this.memory[10240 + address];
                        }
                        case 56320: {
                            return (byte)this.c64.getCIA(0).readRegister(address & 0xF);
                        }
                        case 56576: {
                            return (byte)this.c64.getCIA(1).readRegister(address & 0xF);
                        }
                        case 56832: 
                        case 57088: {
                            return this.memory[9728 + address];
                        }
                    }
                } else {
                    return this.memory[this.isCharROMActive ? 30208 + address : address];
                }
            }
            case 57344: 
            case 61440: {
                return this.memory[this.isKernalROMActive ? 17920 + address : address];
            }
        }
        return this.memory[address];
    }

    @Override
    protected final void writeByte(int address, byte data) {
        switch (address & 0xF000) {
            case 0: {
                if (address <= 1) {
                    this.memory[address] = data;
                    int p = this.memory[0] ^ 0xFF | this.memory[1];
                    this.isKernalROMActive = (p & 2) == 2;
                    this.isBasicROMActive = (p & 3) == 3;
                    this.isCharROMActive = (p & 3) != 0 && (p & 4) == 0;
                    this.isIOActive = (p & 3) != 0 && (p & 4) != 0;
                    break;
                }
                this.memory[address] = data;
                break;
            }
            case 53248: {
                if (this.isIOActive) {
                    switch (address & 0xFF00) {
                        case 53248: 
                        case 53504: 
                        case 53760: 
                        case 54016: {
                            this.c64.getVIC().writeRegister(address & 0x3F, data & 0xFF);
                            break;
                        }
                        case 54272: 
                        case 54528: 
                        case 54784: 
                        case 55040: {
                            this.c64.getSID().writeRegister(address & 0x1F, data & 0xFF);
                            break;
                        }
                        case 55296: 
                        case 55552: 
                        case 55808: 
                        case 56064: {
                            this.memory[10240 + address] = data;
                            break;
                        }
                        case 56320: {
                            this.c64.getCIA(0).writeRegister(address & 0xF, data & 0xFF);
                            break;
                        }
                        case 56576: {
                            this.c64.getCIA(1).writeRegister(address & 0xF, data & 0xFF);
                            break;
                        }
                        case 56832: 
                        case 57088: {
                            this.memory[9728 + address] = data;
                        }
                    }
                    break;
                }
                this.memory[address] = data;
                break;
            }
            default: {
                this.memory[address] = data;
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        int i = 0;
        while (i < 65536) {
            this.memory[i] = 0;
            ++i;
        }
        this.writeByte(0, (byte)47);
        this.writeByte(1, (byte)55);
        this.setPC(this.getStartAddress());
    }

    protected final void installROMs() {
        this.loadROM("/roms/kernal.c64", 75264, 8192);
        this.loadROM("/roms/basic.c64", 67072, 8192);
        this.loadROM("/roms/chargen.c64", 83456, 4096);
    }

    @Override
    public void serialize(DataOutputStream out) throws IOException {
        super.serialize(out);
        out.writeBoolean(this.isBasicROMActive);
        out.writeBoolean(this.isCharROMActive);
        out.writeBoolean(this.isIOActive);
        out.writeBoolean(this.isKernalROMActive);
        out.writeInt(this.pcAdjusted);
        out.writeInt(this.lastPcAdjustment);
        out.writeInt(this.irqs.size());
        int i = 0;
        while (i < this.irqs.size()) {
            out.writeUTF(this.irqs.elementAt(i).getClass().getName());
            ++i;
        }
        out.writeInt(this.nmis.size());
        i = 0;
        while (i < this.nmis.size()) {
            out.writeUTF(this.nmis.elementAt(i).getClass().getName());
            ++i;
        }
    }

    @Override
    public void deserialize(DataInputStream in) throws IOException {
        String className;
        super.deserialize(in);
        this.isBasicROMActive = in.readBoolean();
        this.isCharROMActive = in.readBoolean();
        this.isIOActive = in.readBoolean();
        this.isKernalROMActive = in.readBoolean();
        this.pcAdjusted = in.readInt();
        this.lastPcAdjustment = in.readInt();
        int size = in.readInt();
        this.irqs.removeAllElements();
        int i = 0;
        while (i < size) {
            className = in.readUTF();
            if (VIC6569.class.getName().equals(className)) {
                this.irqs.addElement(this.c64.getVIC());
            } else if (CIA6526_1.class.getName().equals(className)) {
                this.irqs.addElement(this.c64.getCIA(0));
            } else if (CIA6526_2.class.getName().equals(className)) {
                this.irqs.addElement(this.c64.getCIA(1));
            } else {
                throw new IllegalStateException("Unsupported IRQ type for deserialization: '" + className + "'!");
            }
            ++i;
        }
        size = in.readInt();
        this.nmis.removeAllElements();
        i = 0;
        while (i < size) {
            className = in.readUTF();
            if (VIC6569.class.getName().equals(className)) {
                this.nmis.addElement(this.c64.getVIC());
            } else if (CIA6526_1.class.getName().equals(className)) {
                this.nmis.addElement(this.c64.getCIA(0));
            } else if (CIA6526_2.class.getName().equals(className)) {
                this.nmis.addElement(this.c64.getCIA(1));
            } else {
                throw new IllegalStateException("Unsupported NMI type for deserialization: '" + className + "'!");
            }
            ++i;
        }
    }
}

