/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

public class C64FileEntry {
    public static final String TYPE_DELETED = "DEL";
    public static final String TYPE_PROGRAM = "PRG";
    public static final String TYPE_SEQUENTIAL = "SEQ";
    public static final String TYPE_USER = "USR";
    public static final String TYPE_RELATIVE = "REL";
    public static final String TYPE_UNKNOWN = "   ";
    public String filename;
    public final int fileType;
    public final int fileLength;
    public final int firstTrack;
    public final int firstSector;
    public final int relTrack;
    public final int relSector;
    public final int relLength;
    public final int blocks;
    public final int tapeType;
    public final int startAddress;
    public final int endAddress;
    public final int offset;

    public C64FileEntry(String filename, int fileType, int blocks, int firstTrack, int firstSector, int relTrack, int relSector, int relLength) {
        this.filename = filename;
        this.fileType = fileType;
        this.fileLength = 0;
        this.firstTrack = firstTrack;
        this.firstSector = firstSector;
        this.relTrack = relTrack;
        this.relSector = relSector;
        this.relLength = relLength;
        this.blocks = blocks;
        this.tapeType = 0;
        this.startAddress = 0;
        this.endAddress = 0;
        this.offset = 0;
    }

    public C64FileEntry(String filename, int fileType, int tapeType, int startAddress, int endAddress, int offset) {
        this.filename = filename;
        this.fileType = fileType == 0 || fileType >= 128 ? fileType : 130;
        this.fileLength = endAddress - startAddress;
        this.firstTrack = 0;
        this.firstSector = 0;
        this.relTrack = 0;
        this.relSector = 0;
        this.relLength = 0;
        this.blocks = (this.fileLength + 2) / 254;
        this.tapeType = tapeType;
        this.startAddress = startAddress;
        this.endAddress = endAddress;
        this.offset = offset;
    }

    public C64FileEntry(String filename, int fileType, int startAddress, int offset) {
        this.filename = filename;
        this.fileType = fileType;
        this.fileLength = -1;
        this.firstTrack = 0;
        this.firstSector = 0;
        this.relTrack = 0;
        this.relSector = 0;
        this.relLength = 0;
        this.blocks = 0;
        this.tapeType = 0;
        this.startAddress = startAddress;
        this.endAddress = 0;
        this.offset = offset;
    }

    public C64FileEntry(String filename, int fileType) {
        this(filename, fileType, 0, 0);
    }

    public String getFileTypeName() {
        switch (this.fileType & 0xF) {
            case 0: {
                return TYPE_DELETED;
            }
            case 1: {
                return TYPE_SEQUENTIAL;
            }
            case 2: {
                return TYPE_PROGRAM;
            }
            case 3: {
                return TYPE_USER;
            }
            case 4: {
                return TYPE_USER;
            }
        }
        return TYPE_UNKNOWN;
    }

    public String toString() {
        return String.valueOf(this.filename) + "," + this.getFileTypeName();
    }
}

