/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

import de.joergjahnke.c64.core.C64;
import de.joergjahnke.c64.core.CIA6526;
import de.joergjahnke.c64.core.CIA6526_2;
import de.joergjahnke.c64.core.CPU6502;
import de.joergjahnke.c64.core.IOChip;
import de.joergjahnke.c64.core.Sprite;
import de.joergjahnke.common.io.Serializable;
import de.joergjahnke.common.io.SerializationUtils;
import de.joergjahnke.common.ui.Color;
import de.joergjahnke.common.util.DefaultObservable;
import de.joergjahnke.common.util.Observer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class VIC6569
extends DefaultObservable
implements IOChip,
Observer,
Serializable {
    private static final int CHAR_WIDTH = 8;
    private static final int CHAR_HEIGHT = 8;
    private static final int CHAR_COLUMNS = 40;
    private static final int CHAR_ROWS = 25;
    public static final int INNER_WIDTH = 320;
    public static final int INNER_HEIGHT = 200;
    protected static final int BORDER_COLUMNS = 5;
    private static final int BORDER_ROWS = 5;
    public static final int BORDER_WIDTH = 40;
    public static final int BORDER_HEIGHT = 40;
    public static final int TOTAL_WIDTH = 400;
    public static final int TOTAL_HEIGHT = 280;
    private static final int SPRITE_WIDTH = 24;
    private static final int SPRITES = 8;
    private static final int MAX_RASTERS = 312;
    private static final int[] VIC_COLORS = new int[]{-16777216, -1, -2080704, -10420225, -2072352, -12525504, -12566304, -192, -2056128, -6523832, -24416, -11250604, -7829368, -6226016, -6250241, -4144960};
    private static final int MODE_STANDARD_TEXT = 0;
    private static final int MODE_MULTICOLOR_TEXT = 1;
    private static final int MODE_STANDARD_BITMAP = 2;
    private static final int MODE_MULTICOLOR_BITMAP = 3;
    private static final int MODE_ECM_TEXT = 4;
    private static final int MODE_INVALID_TEXT = 5;
    private static final int MODE_INVALID_BITMAP1 = 6;
    private static final int MODE_INVALID_BITMAP2 = 7;
    private static final short COLLISION_MASK_BACKGROUND = 256;
    private static final short COLLISION_MASK_SPRITES = 255;
    private static final int ROW25_START = 51;
    private static final int ROW25_STOP = 251;
    private static final int ROW24_START = 55;
    private static final int ROW24_STOP = 247;
    private static final int COL40_START = 42;
    private static final int COL40_STOP = 362;
    private static final int COL38_START = 49;
    private static final int COL38_STOP = 353;
    private static final int FIRST_LINE = 11;
    private static final int LAST_LINE = 291;
    private static final int FIRST_DMA_LINE = 48;
    private static final int LAST_DMA_LINE = 247;
    private static final int CYCLES_PER_LINE = 63;
    private static final int IRQ_RASTER = 1;
    private static final int IRQ_SPRITE_BACKGROUND_COLLISION = 2;
    private static final int IRQ_SPRITE_SPRITE_COLLISION = 4;
    private static final int IRQ_LIGHTPEN = 8;
    private static final int COLOR_RAM_BASE = 65536;
    private final C64 c64;
    private final CPU6502 cpu;
    private final byte[] memory;
    protected final int[] registers = new int[64];
    private final CIA6526 cia;
    private int vc = 0;
    private int vcBase = 0;
    private int rc = 7;
    private boolean isBusAvailable = true;
    private boolean isDisplayActive = true;
    private boolean areBadLinesEnabled = false;
    private int lineCycle = 1;
    private int rasterY = 311;
    private Sprite[] sprites = new Sprite[8];
    private int[] colorData = new int[40];
    private int[] videoMatrixData = new int[40];
    private int graphicsData;
    private boolean showBorderMain = true;
    private boolean showBorderVertical = true;
    private int graphicsMode = 0;
    private boolean isECM = false;
    private boolean isBMM = false;
    private boolean isMCM = false;
    private int videoMemBase;
    private int videoMatrixBase;
    private int charMemBase;
    private int bitmapMemBase;
    private int[] backgroundColorCodes = new int[4];
    private int[] backgroundColors = new int[4];
    private int borderColor = VIC_COLORS[0];
    private int xscroll = 0;
    private int yscroll = 0;
    private int irqFlags = 0;
    private int irqMask = 0;
    private int rasterYIRQ = 0;
    protected int[] pixels = null;
    protected int nextPixel;
    protected int savedPosition;
    private int frameSkip = 1;
    private int frames = 0;
    private boolean isPaintFrame = true;
    private boolean isPaintBorders = true;
    private long cycles = 0L;
    private long nextUpdate = 63L;
    protected int paintY = 0;
    private int innerY = 0;
    private boolean isPaintableLine = false;
    private boolean isDisplayLine = false;
    private boolean isBadLine = false;
    protected int[][] lastPainted = new int[281][50];
    private int hashCodeBase = 0;
    private short[] collisionMask = new short[448];
    private short[][] lastBackgroundMask = new short[280][448];
    private int collisionPos = 0;
    protected int hashCol = 0;

    public VIC6569(C64 c64) {
        this.c64 = c64;
        this.cpu = c64.getCPU();
        this.cia = c64.getCIA(1);
        this.memory = this.cpu.getMemory();
        int i = 0;
        while (i < this.sprites.length) {
            this.sprites[i] = new Sprite(this);
            ++i;
        }
    }

    public void copy(VIC6569 vic) {
        System.arraycopy(vic.registers, 0, this.registers, 0, this.registers.length);
        this.vc = vic.vc;
        this.vcBase = vic.vcBase;
        this.rc = vic.rc;
        this.isBusAvailable = vic.isBusAvailable;
        this.isDisplayActive = vic.isDisplayActive;
        this.areBadLinesEnabled = vic.areBadLinesEnabled;
        this.lineCycle = vic.lineCycle;
        this.rasterY = vic.rasterY;
        this.sprites = vic.sprites;
        this.colorData = vic.colorData;
        this.videoMatrixData = vic.videoMatrixData;
        this.graphicsData = vic.graphicsData;
        this.showBorderMain = vic.showBorderMain;
        this.showBorderVertical = vic.showBorderVertical;
        this.graphicsMode = vic.graphicsMode;
        this.isECM = vic.isECM;
        this.isBMM = vic.isBMM;
        this.isMCM = vic.isMCM;
        this.videoMemBase = vic.videoMemBase;
        this.videoMatrixBase = vic.videoMatrixBase;
        this.charMemBase = vic.charMemBase;
        this.bitmapMemBase = vic.bitmapMemBase;
        this.backgroundColorCodes = vic.backgroundColorCodes;
        this.backgroundColors = vic.backgroundColors;
        this.borderColor = vic.borderColor;
        this.xscroll = vic.xscroll;
        this.yscroll = vic.yscroll;
        this.irqFlags = vic.irqFlags;
        this.irqMask = vic.irqMask;
        this.rasterYIRQ = vic.rasterYIRQ;
        this.gotoPixel(0, this.paintY);
        this.frameSkip = vic.frameSkip;
        this.frames = vic.frames;
        this.isPaintFrame = vic.isPaintFrame;
        this.isPaintBorders = vic.isPaintBorders;
        this.cycles = vic.cycles;
        this.nextUpdate = vic.nextUpdate;
        this.paintY = vic.paintY;
        this.innerY = vic.innerY;
        this.isPaintableLine = vic.isPaintableLine;
        this.isDisplayLine = vic.isDisplayLine;
        this.isBadLine = vic.isBadLine;
        this.hashCodeBase = vic.hashCodeBase;
        this.collisionMask = vic.collisionMask;
        this.lastBackgroundMask = vic.lastBackgroundMask;
        this.collisionPos = vic.collisionPos;
        this.hashCol = vic.hashCol;
    }

    public void destroy() {
        this.pixels = null;
        this.lastPainted = null;
        this.lastBackgroundMask = null;
        this.collisionMask = null;
        this.sprites = null;
    }

    public final boolean isBusAvailable() {
        return this.isBusAvailable;
    }

    public int getDisplayWidth() {
        return 320;
    }

    public int getDisplayHeight() {
        return 200;
    }

    public int getBorderWidth() {
        return 400;
    }

    public int getBorderHeight() {
        return 280;
    }

    public int[] getRGBData() {
        return this.pixels;
    }

    public void initScreenMemory() {
        this.pixels = new int[112000];
    }

    public void repaint() {
        int i = 0;
        while (i < this.pixels.length) {
            this.pixels[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.lastPainted.length) {
            int j = 0;
            while (j < this.lastPainted[i].length) {
                this.lastPainted[i][j] = -1;
                ++j;
            }
            ++i;
        }
    }

    public void gotoPixel(int x, int y) {
        this.nextPixel = y * 400 + x;
    }

    protected boolean isValidPixel() {
        return this.nextPixel >= 0 && this.nextPixel < this.pixels.length;
    }

    public int getNextPixel() {
        return this.nextPixel;
    }

    protected void setNextPixel(int color) {
        this.pixels[this.nextPixel++] = color;
    }

    protected void skipPixels(int n) {
        this.nextPixel += n;
    }

    protected void saveCurrentPixelPosition() {
        this.savedPosition = this.nextPixel;
    }

    protected void restoreSavedPixelPosition() {
        this.nextPixel = this.savedPosition;
    }

    public final int getFrameSkip() {
        return this.frameSkip;
    }

    public final void setFrameSkip(int frameSkip) {
        if (frameSkip < 1) {
            throw new IllegalArgumentException("Frameskip cannot be set to values < 1!");
        }
        if (frameSkip != this.frameSkip && this.c64.getLogger() != null) {
            this.c64.getLogger().info("Setting frameskip to " + frameSkip);
        }
        this.frameSkip = frameSkip;
    }

    public final boolean isSmallScreen() {
        return !this.isPaintBorders;
    }

    public final void setSmallScreen(boolean isSmallScreen) {
        this.isPaintBorders = !isSmallScreen;
    }

    private int readSpriteXCoordinate(int spriteNo) {
        return this.registers[0 + (spriteNo << 1)] + ((this.registers[16] & 1 << spriteNo) != 0 ? 256 : 0);
    }

    private int readSpriteYCoordinate(int spriteNo) {
        return this.registers[1 + (spriteNo << 1)];
    }

    private int readXScroll() {
        return this.registers[22] & 7;
    }

    private int readYScroll() {
        return this.registers[17] & 7;
    }

    private final boolean readRSEL() {
        return (this.registers[17] & 8) != 0;
    }

    private final boolean readCSEL() {
        return (this.registers[22] & 8) != 0;
    }

    private final boolean readIsDisplayEnabled() {
        return (this.registers[17] & 0x10) != 0;
    }

    private final boolean readIsBitmapMode() {
        return (this.registers[17] & 0x20) != 0;
    }

    private final boolean readIsExtendedColorMode() {
        return (this.registers[17] & 0x40) != 0;
    }

    private final boolean readIsMulticolorMode() {
        return (this.registers[22] & 0x10) != 0;
    }

    private int readRasterLineIRQ() {
        return this.registers[18] + ((this.registers[17] & 0x80) << 1);
    }

    private int readLightPenX() {
        return this.registers[19];
    }

    private int readLightPenY() {
        return this.registers[20];
    }

    private final boolean readIsSpriteActivated(int spriteNo) {
        return (this.registers[21] & 1 << spriteNo) != 0;
    }

    private final boolean readIsSpriteXExpanded(int spriteNo) {
        return (this.registers[29] & 1 << spriteNo) != 0;
    }

    private final boolean readIsSpriteYExpanded(int spriteNo) {
        return (this.registers[23] & 1 << spriteNo) != 0;
    }

    private int readVideoMatrixAddress() {
        return (this.registers[24] & 0xF0) << 6;
    }

    private int readCharacterBufferAddress() {
        return (this.registers[24] & 0xE) << 10;
    }

    private int readBitmapMemoryAddress() {
        return (this.registers[24] & 8) << 10;
    }

    private final boolean readHasSpritePriority(int spriteNo) {
        return (this.registers[27] & 1 << spriteNo) != 0;
    }

    private final boolean readIsSpriteMulticolored(int spriteNo) {
        return (this.registers[28] & 1 << spriteNo) != 0;
    }

    private final void writeSpriteSpriteCollisions(short collisions) {
        this.registers[30] = this.registers[30] | collisions;
        if (this.registers[30] != 0) {
            this.activateIRQFlag(4);
        }
    }

    private final void writeSpriteBitmapCollisions(short collisions) {
        this.registers[31] = this.registers[31] | collisions;
        if (this.registers[31] != 0) {
            this.activateIRQFlag(2);
        }
    }

    private int readBorderColor() {
        return this.registers[32] & 0xF;
    }

    private int readBackgroundColor(int no) {
        return this.registers[33 + no] & 0xF;
    }

    private int readSpriteMultiColor(int no) {
        return this.registers[37 + no] & 0xF;
    }

    private int readSpriteColor(int spriteNo) {
        return this.registers[39 + spriteNo] & 0xF;
    }

    private final int getFirstX() {
        return this.readCSEL() ? 42 : 49;
    }

    private final int getLastX() {
        return this.readCSEL() ? 362 : 353;
    }

    private final int getFirstY() {
        return this.readRSEL() ? 51 : 55;
    }

    private final int getLastY() {
        return this.readRSEL() ? 251 : 247;
    }

    private final boolean determineBadLine() {
        return this.areBadLinesEnabled && this.rasterY >= 48 && this.rasterY <= 247 && (this.rasterY & 7) == this.yscroll;
    }

    private final boolean isIRQTriggered() {
        return (this.irqFlags & this.irqMask & 0xF) != 0;
    }

    private final int getSpriteDataPointer(int spriteNo) {
        return this.videoMemBase + (this.readByte(this.videoMatrixBase + 1016 + spriteNo) & 0xFF) * 64;
    }

    private void determineGraphicsMode() {
        this.isECM = this.readIsExtendedColorMode();
        this.isBMM = this.readIsBitmapMode();
        this.isMCM = this.readIsMulticolorMode();
        this.graphicsMode = (this.isECM ? 4 : 0) + (this.isBMM ? 2 : 0) + (this.isMCM ? 1 : 0);
        this.calculateHashCodeBase();
    }

    private final void determineVideoMemoryBaseAddresses() {
        this.videoMemBase = (~this.cia.readRegister(0) & 3) << 14;
        this.videoMatrixBase = this.videoMemBase + this.readVideoMatrixAddress();
        this.charMemBase = this.videoMemBase + this.readCharacterBufferAddress();
        this.bitmapMemBase = this.videoMemBase + this.readBitmapMemoryAddress();
    }

    private final void determineBadLinesEnabled() {
        if (this.rasterY == 48) {
            this.areBadLinesEnabled = this.readIsDisplayEnabled();
        }
    }

    private void calculateHashCodeBase() {
        this.hashCodeBase = this.graphicsMode << 8 ^ this.backgroundColorCodes[0] << 14 ^ this.backgroundColorCodes[1] << 16 ^ this.backgroundColorCodes[2] << 18 ^ this.backgroundColorCodes[3] << 20 ^ (this.xscroll ^ this.yscroll) << 28;
    }

    private void activateIRQFlag(int flag) {
        if ((this.irqFlags & flag) == 0) {
            this.irqFlags |= flag;
            if ((this.irqMask & flag) != 0) {
                this.irqFlags |= 0x80;
                this.cpu.setIRQ(this, true);
            }
        }
    }

    private void doVideoMatrixAccess() {
        int vmli_ = this.lineCycle - 15;
        if (this.isDisplayActive) {
            int vc_ = this.vc;
            this.videoMatrixData[vmli_] = this.readByte(this.videoMatrixBase + vc_) & 0xFF;
            this.colorData[vmli_] = this.memory[65536 + vc_] & 0xF;
        } else {
            this.videoMatrixData[vmli_] = 0;
            this.colorData[vmli_] = 0;
        }
    }

    private void doGraphicsAccess() {
        if (this.isDisplayActive) {
            int address = this.isBMM ? this.bitmapMemBase | this.vc << 3 | this.rc : this.charMemBase | this.videoMatrixData[this.lineCycle - 16] << 3 | this.rc;
            if (this.isECM) {
                address &= 0x1F9FF;
            }
            this.vc = this.vc + 1 & 0x3FF;
            this.graphicsData = this.readByte(address) & 0xFF;
        } else {
            this.graphicsData = 0;
        }
    }

    private void drawBorder(int n) {
        int[] lastPaintedY = this.lastPainted[this.paintY];
        int borderColor_ = this.borderColor;
        if (lastPaintedY[n] != -borderColor_) {
            lastPaintedY[n] = -borderColor_;
            short[] collisionMask_ = this.collisionMask;
            int i = 0;
            int collisionPos_ = this.collisionPos;
            while (i < 8) {
                this.setNextPixel(borderColor_);
                collisionMask_[collisionPos_++] = 0;
                ++i;
            }
        } else {
            this.skipPixels(8);
        }
        this.collisionPos += 8;
    }

    private void drawGraphics() {
        block22: {
            block24: {
                block23: {
                    int hashCol_;
                    int n;
                    block21: {
                        n = this.lineCycle - 17;
                        hashCol_ = this.hashCol = n + 5;
                        if (!this.showBorderMain) break block21;
                        this.drawBorder(hashCol_);
                        break block22;
                    }
                    int[] lastPaintedY = this.lastPainted[this.paintY];
                    int graphicsData_ = this.graphicsData;
                    int videoMatrixData_ = this.videoMatrixData[n];
                    int colorData_ = this.colorData[n];
                    int hashCode = this.hashCodeBase ^ graphicsData_ ^ videoMatrixData_ << 10 ^ colorData_ << 24;
                    if (lastPaintedY[hashCol_] == hashCode) break block23;
                    lastPaintedY[hashCol_] = hashCode;
                    short[] collisionMask_ = this.collisionMask;
                    int collisionPos_ = this.collisionPos;
                    switch (this.graphicsMode) {
                        case 0: {
                            int foregroundColor = VIC_COLORS[colorData_];
                            int backgroundColor = this.backgroundColors[0];
                            int mask = 128;
                            while (mask > 0) {
                                boolean isPixelSet = (graphicsData_ & mask) != 0;
                                this.setNextPixel(isPixelSet ? foregroundColor : backgroundColor);
                                collisionMask_[collisionPos_++] = isPixelSet ? 256 : 0;
                                mask >>= 1;
                            }
                            break block24;
                        }
                        case 1: {
                            int foregroundColor = VIC_COLORS[colorData_ & 7];
                            if ((colorData_ & 8) != 0) {
                                int[] colors = new int[]{this.backgroundColors[0], this.backgroundColors[1], this.backgroundColors[2], foregroundColor};
                                int i = 0;
                                int mask = 192;
                                while (i < 8) {
                                    int val = (graphicsData_ & mask) >> 6 - i;
                                    int color = colors[val];
                                    this.setNextPixel(color);
                                    this.setNextPixel(color);
                                    int n2 = val > 1 ? 256 : 0;
                                    collisionMask_[collisionPos_ + 1] = n2;
                                    collisionMask_[collisionPos_] = n2;
                                    collisionPos_ += 2;
                                    i += 2;
                                    mask >>= 2;
                                }
                            } else {
                                int backgroundColor = this.backgroundColors[0];
                                int i = 0;
                                int mask = 128;
                                while (i < 8) {
                                    boolean isPixelSet = (graphicsData_ & mask) != 0;
                                    this.setNextPixel(isPixelSet ? foregroundColor : backgroundColor);
                                    collisionMask_[collisionPos_++] = isPixelSet ? 256 : 0;
                                    ++i;
                                    mask >>= 1;
                                }
                            }
                            break block24;
                        }
                        case 2: {
                            int foregroundColor = VIC_COLORS[videoMatrixData_ >> 4];
                            int backgroundColor = VIC_COLORS[videoMatrixData_ & 0xF];
                            int mask = 128;
                            while (mask > 0) {
                                boolean isPixelSet = (graphicsData_ & mask) != 0;
                                this.setNextPixel(isPixelSet ? foregroundColor : backgroundColor);
                                collisionMask_[collisionPos_++] = isPixelSet ? 256 : 0;
                                mask >>= 1;
                            }
                            break block24;
                        }
                        case 3: {
                            int[] colors = new int[]{this.backgroundColors[0], VIC_COLORS[videoMatrixData_ >> 4], VIC_COLORS[videoMatrixData_ & 0xF], VIC_COLORS[colorData_]};
                            int i = 0;
                            int mask = 192;
                            while (i < 8) {
                                int val = (graphicsData_ & mask) >> 6 - i;
                                int color = colors[val];
                                this.setNextPixel(color);
                                this.setNextPixel(color);
                                int n3 = val > 1 ? 256 : 0;
                                collisionMask_[collisionPos_ + 1] = n3;
                                collisionMask_[collisionPos_] = n3;
                                collisionPos_ += 2;
                                i += 2;
                                mask >>= 2;
                            }
                            break block24;
                        }
                        case 4: {
                            int foregroundColor = VIC_COLORS[colorData_];
                            int backgroundColor = this.backgroundColors[videoMatrixData_ >> 6];
                            int mask = 128;
                            while (mask > 0) {
                                boolean isPixelSet = (graphicsData_ & mask) != 0;
                                this.setNextPixel(isPixelSet ? foregroundColor : backgroundColor);
                                collisionMask_[collisionPos_++] = isPixelSet ? 256 : 0;
                                mask >>= 1;
                            }
                            break block24;
                        }
                        case 5: {
                            int mask = 128;
                            while (mask > 0) {
                                boolean isPixelSet = (graphicsData_ & mask) != 0;
                                this.setNextPixel(0);
                                collisionMask_[collisionPos_++] = isPixelSet ? 256 : 0;
                                mask >>= 1;
                            }
                            break block24;
                        }
                        case 6: {
                            int mask = 128;
                            while (mask > 0) {
                                boolean isPixelSet = (graphicsData_ & mask) != 0;
                                this.setNextPixel(0);
                                collisionMask_[collisionPos_++] = isPixelSet ? 256 : 0;
                                mask >>= 1;
                            }
                            break block24;
                        }
                        case 7: {
                            int i = 0;
                            int mask = 192;
                            while (i < 8) {
                                int val = (graphicsData_ & mask) >> 6 - i;
                                this.setNextPixel(0);
                                this.setNextPixel(0);
                                int n4 = val > 1 ? 256 : 0;
                                collisionMask_[collisionPos_ + 1] = n4;
                                collisionMask_[collisionPos_] = n4;
                                collisionPos_ += 2;
                                i += 2;
                                mask >>= 2;
                            }
                            break block24;
                        }
                        default: {
                            throw new IllegalArgumentException("Illegal graphics mode: " + this.graphicsMode + "!");
                        }
                    }
                }
                this.skipPixels(8);
            }
            this.collisionPos += 8;
        }
    }

    private void doSpriteAccess(int n) {
        Sprite sprite = this.sprites[n];
        if (sprite.isPainting()) {
            sprite.setDataPointer(this.getSpriteDataPointer(n));
            if (sprite.isEnabled()) {
                this.isBusAvailable = false;
                sprite.readLineData();
            } else {
                this.isBusAvailable = true;
            }
        } else {
            this.isBusAvailable = true;
        }
    }

    private void drawSprites() {
        this.saveCurrentPixelPosition();
        int firstX = this.getFirstX();
        int lastX = this.getLastX();
        Sprite[] sprites_ = this.sprites;
        int i = sprites_.length - 1;
        int mask = 128;
        while (i >= 0) {
            int x;
            Sprite sprite = sprites_[i];
            if (sprite.isPainting() && (x = sprite.getX() + 40 - 24) <= 400) {
                this.gotoPixel(x, this.paintY);
                this.hashCol = (sprite.getX() - this.xscroll - 24 >> 3) + 5;
                while (!sprite.isLineFinished()) {
                    int colIndex = sprite.getNextPixel();
                    boolean wasPixelSet = false;
                    boolean collidesWithBackground = false;
                    if (colIndex != 0) {
                        if (this.collisionMask[x] != 0) {
                            short coll = this.collisionMask[x];
                            if ((coll & 0x100) != 0) {
                                this.writeSpriteBitmapCollisions((short)mask);
                                collidesWithBackground = true;
                            }
                            if ((coll & 0xFF) != 0) {
                                this.writeSpriteSpriteCollisions((short)(mask | coll & 0xFF));
                            }
                        }
                        int n = x;
                        this.collisionMask[n] = (short)(this.collisionMask[n] | mask);
                        if (this.isDisplayLine && x >= firstX && x < lastX && (!collidesWithBackground || sprite.hasPriority())) {
                            this.setNextPixel(sprite.getColor(colIndex));
                            wasPixelSet = true;
                            this.lastPainted[this.paintY][this.hashCol] = -1;
                        }
                    }
                    ++x;
                    if (!wasPixelSet) {
                        this.skipPixels(1);
                    }
                    if (x % 8 != 0) continue;
                    ++this.hashCol;
                }
            }
            --i;
            mask >>= 1;
        }
        this.restoreSavedPixelPosition();
    }

    protected final void invalidateCacheLine(int n) {
        System.arraycopy(this.lastPainted[280], 0, this.lastPainted[n], 0, 50);
    }

    protected final byte readByte(int adr) {
        if ((adr & 0x7000) == 4096) {
            return this.memory[83456 + (adr & 0xFFF)];
        }
        return this.memory[adr];
    }

    @Override
    public final int readRegister(int register) {
        switch (register) {
            case 17: {
                int result = this.registers[register];
                result &= 0x7F;
                return result |= (this.rasterY & 0x100) >> 1;
            }
            case 18: {
                return this.rasterY & 0xFF;
            }
            case 25: {
                return this.irqFlags | 0x70;
            }
            case 26: {
                return this.irqMask | 0xF0;
            }
            case 30: 
            case 31: {
                int result = this.registers[register];
                this.registers[register] = 0;
                return result;
            }
        }
        return register < 32 ? this.registers[register] : (register < 47 ? this.registers[register] | 0xF0 : 255);
    }

    @Override
    public final void writeRegister(int register, int data) {
        this.registers[register] = data;
        switch (register) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                int n = register >> 1;
                this.sprites[n].setX(this.readSpriteXCoordinate(n));
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                int n = register >> 1;
                this.sprites[n].setY(this.readSpriteYCoordinate(n));
                break;
            }
            case 16: {
                int i = 0;
                while (i < 8) {
                    this.sprites[i].setX(this.readSpriteXCoordinate(i));
                    ++i;
                }
                break;
            }
            case 17: {
                this.yscroll = this.readYScroll();
                this.determineGraphicsMode();
                this.calculateHashCodeBase();
                this.determineBadLinesEnabled();
                this.isBadLine = this.determineBadLine();
            }
            case 18: {
                if (this.rasterYIRQ == this.readRasterLineIRQ()) break;
                this.rasterYIRQ = this.readRasterLineIRQ();
                if (this.rasterY != this.rasterYIRQ) break;
                this.activateIRQFlag(1);
                break;
            }
            case 21: {
                int i = 0;
                int m = 1;
                while (i < 8) {
                    this.sprites[i].setEnabled((data & m) != 0);
                    ++i;
                    m <<= 1;
                }
                break;
            }
            case 22: {
                this.xscroll = this.readXScroll();
                this.determineGraphicsMode();
                this.calculateHashCodeBase();
                break;
            }
            case 23: {
                int i = 0;
                int m = 1;
                while (i < 8) {
                    this.sprites[i].setExpandY((data & m) != 0);
                    ++i;
                    m <<= 1;
                }
                break;
            }
            case 24: {
                this.determineVideoMemoryBaseAddresses();
                break;
            }
            case 25: {
                this.irqFlags &= ~((data & 0x80) != 0 ? 255 : data) & 0xF;
                if (this.isIRQTriggered()) {
                    this.irqFlags |= 0x80;
                    break;
                }
                this.cpu.setIRQ(this, false);
                break;
            }
            case 26: {
                this.irqMask = data & 0xF;
                if (this.isIRQTriggered()) {
                    this.irqFlags |= 0x80;
                    this.cpu.setIRQ(this, true);
                    break;
                }
                this.irqFlags &= 0xF;
                this.cpu.setIRQ(this, false);
                break;
            }
            case 27: {
                int i = 0;
                int m = 1;
                while (i < 8) {
                    this.sprites[i].setPriority((data & m) == 0);
                    ++i;
                    m <<= 1;
                }
                break;
            }
            case 28: {
                int i = 0;
                int m = 1;
                while (i < 8) {
                    this.sprites[i].setMulticolor((data & m) != 0);
                    ++i;
                    m <<= 1;
                }
                break;
            }
            case 29: {
                int i = 0;
                int m = 1;
                while (i < 8) {
                    this.sprites[i].setExpandX((data & m) != 0);
                    ++i;
                    m <<= 1;
                }
                break;
            }
            case 32: {
                this.borderColor = VIC_COLORS[this.readBorderColor()];
                this.setChanged(true);
                this.notifyObservers(new Color(this.borderColor));
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                int col;
                int n = register - 33;
                this.backgroundColorCodes[n] = col = data & 0xF;
                this.backgroundColors[n] = VIC_COLORS[col];
                this.calculateHashCodeBase();
                break;
            }
            case 37: {
                int i = 0;
                while (i < 8) {
                    this.sprites[i].setColor(1, VIC_COLORS[data & 0xF]);
                    ++i;
                }
                int n = register;
                this.registers[n] = this.registers[n] | 0xF0;
                break;
            }
            case 38: {
                int i = 0;
                while (i < 8) {
                    this.sprites[i].setColor(3, VIC_COLORS[data & 0xF]);
                    ++i;
                }
                int n = register;
                this.registers[n] = this.registers[n] | 0xF0;
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                int n = register - 39;
                this.sprites[n].setColor(2, VIC_COLORS[data & 0xF]);
                int n2 = register;
                this.registers[n2] = this.registers[n2] | 0xF0;
            }
        }
    }

    @Override
    public final long getNextUpdate() {
        return this.nextUpdate;
    }

    @Override
    public final void update(long cycles) {
        block18: while (this.cycles < cycles) {
            switch (this.lineCycle) {
                case 1: {
                    ++this.rasterY;
                    if (this.rasterY >= 312) {
                        this.rasterY = 0;
                        this.vcBase = 0;
                        this.setChanged(this.isPaintFrame);
                        this.notifyObservers();
                        ++this.frames;
                        this.isPaintFrame = this.frames % this.frameSkip == 0;
                        this.invalidateCacheLine(this.frames % 280);
                    }
                    if (this.rasterY == this.rasterYIRQ) {
                        this.activateIRQFlag(1);
                    }
                    this.determineBadLinesEnabled();
                    this.isBadLine = this.determineBadLine();
                    this.isDisplayActive |= this.isBadLine;
                    this.paintY = this.rasterY - 11;
                    this.innerY = this.paintY - 40;
                    boolean bl = this.isDisplayLine = this.innerY >= 0 && this.innerY < 200 && this.isPaintFrame;
                    boolean bl2 = this.isPaintBorders ? this.rasterY >= 11 && this.rasterY < 291 : (this.isPaintableLine = this.rasterY >= 51 && this.rasterY < 251);
                    if (this.isPaintableLine) {
                        this.gotoPixel(0, this.paintY);
                        this.isPaintableLine &= this.isValidPixel();
                        System.arraycopy(this.lastBackgroundMask[this.paintY], 0, this.collisionMask, 0, this.collisionMask.length);
                    }
                    this.collisionPos = 0;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    this.doSpriteAccess((this.lineCycle - 1 >> 1) + 3);
                    this.cycles += 2L;
                    this.lineCycle += 2;
                    continue block18;
                }
                case 11: {
                    if (!this.isPaintFrame) {
                        this.cycles += (long)(57 - this.lineCycle);
                        this.lineCycle += 57 - this.lineCycle;
                        continue block18;
                    }
                    this.isBusAvailable = true;
                    break;
                }
                case 12: {
                    if (!this.isBadLine) break;
                    this.isBusAvailable = false;
                    break;
                }
                case 13: {
                    if (!this.isPaintableLine) break;
                    if (this.isPaintBorders) {
                        int i = 0;
                        while (i < 5) {
                            this.drawBorder(i);
                            ++i;
                        }
                        break;
                    }
                    this.skipPixels(40);
                    break;
                }
                case 14: {
                    this.vc = this.vcBase;
                    if (!this.isBadLine) break;
                    this.rc = 0;
                    break;
                }
                case 15: {
                    if (!this.isBadLine) break;
                    this.doVideoMatrixAccess();
                    break;
                }
                case 16: {
                    if (this.isPaintableLine) {
                        this.doGraphicsAccess();
                    }
                    if (!this.isBadLine) break;
                    this.doVideoMatrixAccess();
                    break;
                }
                case 17: {
                    if (this.rasterY == this.getLastY()) {
                        this.showBorderVertical = true;
                    } else if (this.rasterY == this.getFirstY() && this.readIsDisplayEnabled()) {
                        this.showBorderVertical = false;
                    }
                    this.showBorderMain &= this.showBorderVertical;
                    if (this.isPaintableLine) {
                        int i = 0;
                        while (i < this.xscroll) {
                            this.setNextPixel(this.borderColor);
                            ++i;
                        }
                        this.collisionPos += this.xscroll;
                        this.drawGraphics();
                        if (!this.readCSEL()) {
                            this.gotoPixel(40, this.paintY);
                            this.lastPainted[this.paintY][5] = -255;
                            this.drawBorder(5);
                        }
                    } else {
                        this.cycles += 39L;
                        this.lineCycle += 39;
                        continue block18;
                    }
                    this.doGraphicsAccess();
                    if (!this.isBadLine) break;
                    this.doVideoMatrixAccess();
                    break;
                }
                case 55: {
                    if (!this.isPaintableLine) break;
                    this.drawGraphics();
                    this.doGraphicsAccess();
                    break;
                }
                case 56: {
                    if (!this.sprites[0].isEnabled()) {
                        this.isBusAvailable = true;
                    }
                    if (!this.isPaintableLine) break;
                    this.drawGraphics();
                    if (this.readCSEL()) break;
                    this.gotoPixel(352, this.paintY);
                    this.lastPainted[this.paintY][44] = -255;
                    this.drawBorder(44);
                    break;
                }
                case 57: {
                    Sprite sprite;
                    this.showBorderMain = true;
                    if (this.isPaintableLine) {
                        this.gotoPixel(360, this.paintY);
                        if (this.isPaintBorders) {
                            this.lastPainted[this.paintY][45] = -255;
                            int i = 45;
                            while (i < 50) {
                                this.drawBorder(i);
                                ++i;
                            }
                        } else {
                            this.skipPixels(40);
                        }
                        System.arraycopy(this.collisionMask, 0, this.lastBackgroundMask[this.paintY], 0, this.collisionMask.length);
                        this.drawSprites();
                    }
                    Sprite[] sprites_ = this.sprites;
                    int i = 0;
                    int to = sprites_.length;
                    while (i < to) {
                        sprite = sprites_[i];
                        if (sprite.isPainting() && sprite.isBeyondLastByte()) {
                            sprite.setPainting(false);
                        }
                        ++i;
                    }
                    break;
                }
                case 58: {
                    Sprite sprite;
                    if (this.rc == 7) {
                        this.vcBase = this.vc;
                        this.isDisplayActive = false;
                    }
                    if (this.isBadLine || this.isDisplayActive) {
                        this.rc = this.rc + 1 & 7;
                    }
                    Sprite[] sprites_ = this.sprites;
                    int i = 0;
                    int to = sprites_.length;
                    while (i < to) {
                        sprite = sprites_[i];
                        if (sprite.isEnabled() && sprite.getY() == (this.rasterY & 0xFF)) {
                            sprite.initPainting();
                        }
                        ++i;
                    }
                }
                case 60: {
                    this.doSpriteAccess(this.lineCycle - 58 >> 1);
                    this.cycles += 2L;
                    this.lineCycle += 2;
                    continue block18;
                }
                case 62: {
                    this.doSpriteAccess(this.lineCycle - 58 >> 1);
                    break;
                }
                case 63: {
                    this.nextUpdate = cycles + 63L;
                    this.lineCycle = 0;
                    break;
                }
                default: {
                    if (this.isPaintableLine) {
                        this.drawGraphics();
                        this.doGraphicsAccess();
                    }
                    if (!this.isBadLine) break;
                    this.doVideoMatrixAccess();
                }
            }
            ++this.cycles;
            ++this.lineCycle;
        }
    }

    @Override
    public void reset() {
        int i = 0;
        while (i < this.sprites.length) {
            this.sprites[i].setEnabled(false);
            ++i;
        }
        i = 0;
        while (i < this.pixels.length) {
            this.pixels[i] = 0;
            ++i;
        }
        this.cycles = this.cpu.getCycles() + 50L;
        i = 0;
        while (i < 280) {
            this.invalidateCacheLine(i);
            ++i;
        }
    }

    @Override
    public void update(Object observed, Object arg) {
        if (observed instanceof CIA6526 && CIA6526_2.ADDRESS_PRA.equals(arg)) {
            this.determineVideoMemoryBaseAddresses();
        }
    }

    @Override
    public void serialize(DataOutputStream out) throws IOException {
        SerializationUtils.serialize(out, this.registers);
        out.writeInt(this.vc);
        out.writeInt(this.vcBase);
        out.writeInt(this.rc);
        out.writeBoolean(this.isBusAvailable);
        out.writeBoolean(this.isDisplayActive);
        out.writeBoolean(this.areBadLinesEnabled);
        out.writeInt(this.lineCycle);
        out.writeInt(this.rasterY);
        SerializationUtils.serialize(out, this.sprites);
        SerializationUtils.serialize(out, this.colorData);
        SerializationUtils.serialize(out, this.videoMatrixData);
        out.writeInt(this.graphicsData);
        out.writeBoolean(this.showBorderMain);
        out.writeBoolean(this.showBorderVertical);
        out.writeInt(this.graphicsMode);
        out.writeBoolean(this.isECM);
        out.writeBoolean(this.isBMM);
        out.writeBoolean(this.isMCM);
        out.writeInt(this.videoMemBase);
        out.writeInt(this.videoMatrixBase);
        out.writeInt(this.charMemBase);
        out.writeInt(this.bitmapMemBase);
        SerializationUtils.serialize(out, this.backgroundColorCodes);
        SerializationUtils.serialize(out, this.backgroundColors);
        out.writeInt(this.borderColor);
        out.writeInt(this.xscroll);
        out.writeInt(this.yscroll);
        out.writeInt(this.irqFlags);
        out.writeInt(this.irqMask);
        out.writeInt(this.rasterYIRQ);
        out.writeInt(this.nextPixel);
        out.writeInt(this.savedPosition);
        out.writeBoolean(this.isPaintFrame);
        out.writeBoolean(this.isPaintBorders);
        out.writeLong(this.cycles);
        out.writeLong(this.nextUpdate);
        out.writeInt(this.paintY);
        out.writeInt(this.innerY);
        out.writeBoolean(this.isPaintableLine);
        out.writeBoolean(this.isDisplayLine);
        out.writeBoolean(this.isBadLine);
        out.writeInt(this.hashCodeBase);
        SerializationUtils.serialize(out, this.collisionMask);
        out.writeInt(this.collisionPos);
        out.writeInt(this.hashCol);
    }

    @Override
    public void deserialize(DataInputStream in) throws IOException {
        SerializationUtils.deserialize(in, this.registers);
        this.vc = in.readInt();
        this.vcBase = in.readInt();
        this.rc = in.readInt();
        this.isBusAvailable = in.readBoolean();
        this.isDisplayActive = in.readBoolean();
        this.areBadLinesEnabled = in.readBoolean();
        this.lineCycle = in.readInt();
        this.rasterY = in.readInt();
        SerializationUtils.deserialize(in, this.sprites);
        SerializationUtils.deserialize(in, this.colorData);
        SerializationUtils.deserialize(in, this.videoMatrixData);
        this.graphicsData = in.readInt();
        this.showBorderMain = in.readBoolean();
        this.showBorderVertical = in.readBoolean();
        this.graphicsMode = in.readInt();
        this.isECM = in.readBoolean();
        this.isBMM = in.readBoolean();
        this.isMCM = in.readBoolean();
        this.videoMemBase = in.readInt();
        this.videoMatrixBase = in.readInt();
        this.charMemBase = in.readInt();
        this.bitmapMemBase = in.readInt();
        SerializationUtils.deserialize(in, this.backgroundColorCodes);
        SerializationUtils.deserialize(in, this.backgroundColors);
        this.borderColor = in.readInt();
        this.setChanged(true);
        this.notifyObservers(new Color(this.borderColor));
        this.xscroll = in.readInt();
        this.yscroll = in.readInt();
        this.irqFlags = in.readInt();
        this.irqMask = in.readInt();
        this.rasterYIRQ = in.readInt();
        this.nextPixel = in.readInt();
        this.savedPosition = in.readInt();
        this.isPaintFrame = in.readBoolean();
        this.isPaintBorders = in.readBoolean();
        this.cycles = in.readLong();
        this.nextUpdate = in.readLong();
        this.paintY = in.readInt();
        this.innerY = in.readInt();
        this.isPaintableLine = in.readBoolean();
        this.isDisplayLine = in.readBoolean();
        this.isBadLine = in.readBoolean();
        this.hashCodeBase = in.readInt();
        SerializationUtils.deserialize(in, this.collisionMask);
        this.collisionPos = in.readInt();
        this.hashCol = in.readInt();
        this.repaint();
    }
}

