/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.drive;

import de.joergjahnke.c64.core.C1541;
import de.joergjahnke.c64.drive.ByteArrayDriveChannel;
import de.joergjahnke.c64.drive.D64DriveHandler;
import de.joergjahnke.c64.drive.DiskDriveHandler;
import de.joergjahnke.c64.drive.DriveChannel;
import de.joergjahnke.c64.drive.MultiPurposeDriveChannel;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class DriveCommandChannel
extends ByteArrayDriveChannel {
    public static final String OK = "00,OK,00,00";
    public static final String FILES_SCRATCHED = "01,FILES SCRATCHED,01,00";
    public static final String WRITE_ERROR = "25,WRITE ERROR,00,00";
    public static final String WRITE_PROTECT_ON_ERROR = "26,WRITE PROTECT ON,00,00";
    public static final String SYNTAX_ERROR = "30,SYNTAX ERROR,00,00";
    public static final String FILE_NOT_FOUND_ERROR = "62,FILE NOT FOUND,00,00";
    public static final String FILE_EXISTS_ERROR = "63,FILE EXISTS,00,00";
    public static final String NO_BLOCK_ERROR = "65,NO_BLOCK";
    public static final String INIT_MESSAGE = "73,CBM DOS V2.6 1541,00,00";
    private final DriveChannel[] channels;
    private String lastMessage;

    public DriveCommandChannel(C1541 c1541, DriveChannel[] channels) {
        super(c1541);
        this.channels = channels;
        this.setMessage(INIT_MESSAGE);
    }

    protected final void setMessage(String message) {
        this.in = new ByteArrayInputStream(message.getBytes());
        this.lastMessage = message;
    }

    @Override
    public void commit() throws IOException {
        String command = this.out.toString();
        if (command.length() == 0) {
            this.setMessage(OK);
        } else {
            switch (command.charAt(0)) {
                case 'I': {
                    this.c1541.initialize();
                    this.setMessage(OK);
                    break;
                }
                case 'C': {
                    int from = command.indexOf(58) + 1;
                    int to = command.indexOf(61);
                    String newFileName = command.substring(from, to);
                    int from2 = to + 1;
                    int to2 = command.length() - 1;
                    String oldFileName = command.substring(from2, to2);
                    DiskDriveHandler handler = this.c1541.getDriveHandler();
                    byte[] bytes = handler.readFile(oldFileName);
                    handler.writeFile(newFileName, bytes);
                    break;
                }
                case 'V': {
                    if (this.c1541.getDriveHandler() instanceof D64DriveHandler) {
                        ((D64DriveHandler)this.c1541.getDriveHandler()).validate();
                    }
                    this.setMessage(OK);
                    break;
                }
                case 'N': {
                    if (this.c1541.getDriveHandler() instanceof D64DriveHandler) {
                        int from = command.indexOf(58) + 1;
                        int to = command.indexOf(44) < 0 ? command.length() - 1 : command.indexOf(44);
                        String fileName = command.substring(from, to);
                        int id = -1;
                        try {
                            int from2 = to + 1;
                            int to2 = command.length() - 1;
                            id = Integer.parseInt(command.substring(from2, to2));
                        }
                        catch (Exception from2) {
                            // empty catch block
                        }
                        ((D64DriveHandler)this.c1541.getDriveHandler()).format(fileName, id);
                        this.setMessage(OK);
                        break;
                    }
                    this.setMessage(WRITE_PROTECT_ON_ERROR);
                    break;
                }
                case 'S': {
                    int from = command.indexOf(58) + 1;
                    int to = command.length() - 1;
                    String filename = command.substring(from, to);
                    this.c1541.getDriveHandler().deleteFile(filename);
                    this.setMessage(FILES_SCRATCHED);
                    break;
                }
                case 'R': {
                    int from = command.indexOf(58) + 1;
                    int to = command.indexOf(61);
                    String newFileName = command.substring(from, to);
                    int from2 = to + 1;
                    int to2 = command.length() - 1;
                    String oldFileName = command.substring(from2, to2);
                    try {
                        this.c1541.getDriveHandler().renameFile(newFileName, oldFileName);
                        this.setMessage(OK);
                    }
                    catch (IOException e) {
                        this.setMessage(FILE_EXISTS_ERROR);
                    }
                    break;
                }
                case 'B': {
                    if (this.c1541.getDriveHandler() instanceof D64DriveHandler) {
                        this.executeBlockCommand(command);
                        break;
                    }
                    this.setMessage(SYNTAX_ERROR);
                    break;
                }
                case 'U': {
                    if (!(this.c1541.getDriveHandler() instanceof D64DriveHandler)) break;
                    if (command.startsWith("U1:")) {
                        this.executeReadBlockCommand(command.substring(3), true);
                        break;
                    }
                    if (command.startsWith("U2:")) {
                        this.executeWriteBlockCommand(command.substring(3), true);
                        break;
                    }
                    this.setMessage(SYNTAX_ERROR);
                    break;
                }
                default: {
                    this.setMessage(SYNTAX_ERROR);
                }
            }
        }
        this.out.reset();
    }

    private void executeBlockCommand(String command) {
        if (command.length() < 4 || command.charAt(1) != '-' || command.charAt(3) != ':') {
            this.setMessage(SYNTAX_ERROR);
        } else {
            try {
                switch (command.charAt(2)) {
                    case 'R': {
                        String parameters = command.substring(4);
                        this.executeReadBlockCommand(parameters, false);
                        break;
                    }
                    case 'W': {
                        String parameters = command.substring(4);
                        this.executeWriteBlockCommand(parameters, false);
                        break;
                    }
                    case 'P': {
                        int[] params = this.parseBlockCommandParameters(command.substring(4), 2);
                        int channelNo = params[0];
                        int skip = params[1];
                        ByteArrayDriveChannel channel = (ByteArrayDriveChannel)this.channels[channelNo];
                        byte[] skipped = channel.skip(skip);
                        channel.write(skipped, 0, skipped.length);
                        if (channel instanceof MultiPurposeDriveChannel) {
                            ((MultiPurposeDriveChannel)channel).setBlockMode(true);
                        }
                        break;
                    }
                    case 'A': {
                        int[] params = this.parseBlockCommandParameters(command.substring(4), 3);
                        int track = params[1];
                        int sector = params[2];
                        D64DriveHandler diskHandler = (D64DriveHandler)this.c1541.getDriveHandler();
                        diskHandler.allocateBlock(track, sector);
                        break;
                    }
                    case 'F': {
                        int[] params = this.parseBlockCommandParameters(command.substring(4), 3);
                        int track = params[1];
                        int sector = params[2];
                        D64DriveHandler diskHandler = (D64DriveHandler)this.c1541.getDriveHandler();
                        diskHandler.freeBlock(track, sector);
                        break;
                    }
                    default: {
                        this.setMessage(SYNTAX_ERROR);
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.setMessage(SYNTAX_ERROR);
            }
        }
    }

    private void executeReadBlockCommand(String parameters, boolean readFullBlock) throws IOException {
        int[] params = this.parseBlockCommandParameters(parameters, 4);
        int channelNo = params[0];
        int track = params[2];
        int sector = params[3];
        D64DriveHandler diskHandler = (D64DriveHandler)this.c1541.getDriveHandler();
        DriveChannel channel = this.channels[channelNo];
        diskHandler.gotoBlock(track, sector);
        byte[] blockBytes = diskHandler.readBlock();
        if (readFullBlock) {
            ((ByteArrayDriveChannel)channel).fill(blockBytes, 0, 256);
        } else {
            byte numBytes = blockBytes[0];
            ((ByteArrayDriveChannel)channel).fill(blockBytes, 1, numBytes);
        }
        if (channel instanceof MultiPurposeDriveChannel) {
            ((MultiPurposeDriveChannel)channel).setBlockMode(true);
        }
        this.setMessage(OK);
    }

    private void executeWriteBlockCommand(String parameters, boolean writeFullBlock) throws IOException {
        int[] params = this.parseBlockCommandParameters(parameters, 4);
        int channelNo = params[0];
        int track = params[2];
        int sector = params[3];
        D64DriveHandler diskHandler = (D64DriveHandler)this.c1541.getDriveHandler();
        ByteArrayDriveChannel channel = (ByteArrayDriveChannel)this.channels[channelNo];
        diskHandler.gotoBlock(track, sector);
        byte[] blockBytes = diskHandler.readBlock();
        if (writeFullBlock) {
            System.arraycopy(channel.out.toByteArray(), 0, blockBytes, 0, 256);
        } else {
            blockBytes[0] = (byte)channel.out.size();
            System.arraycopy(channel.out.toByteArray(), 0, blockBytes, 1, Math.min(255, channel.out.size()));
        }
        diskHandler.writeBlock(blockBytes);
        channel.out.reset();
        this.setMessage(OK);
    }

    private int[] parseBlockCommandParameters(String parameters, int count) {
        int[] result = new int[count];
        StringBuffer param = new StringBuffer();
        int i = 0;
        int n = 0;
        while (n < count && i < parameters.length()) {
            char c = parameters.charAt(i);
            if (c >= '0' && c <= '9') {
                param.append(c);
            } else if (param.length() > 0) {
                result[n++] = Integer.parseInt(param.toString());
                param = new StringBuffer();
            }
            ++i;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.setMessage(this.lastMessage);
        int i = 0;
        while (i < this.channels.length - 1) {
            if (this.channels[i] != null) {
                this.channels[i].close();
            }
            ++i;
        }
    }
}

