/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.drive;

import de.joergjahnke.c64.core.C64FileEntry;
import de.joergjahnke.common.util.DefaultObservable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

public abstract class DriveHandler
extends DefaultObservable {
    public static final int SEQUENTIAL = 1;
    public static final int RANDOM = 2;
    protected byte[] bytes = null;
    protected int imageType = 0;
    protected String label = "";
    protected int freeBlocks = 0;
    protected boolean wasModified = false;

    public void destroy() {
        this.bytes = null;
        this.label = "";
    }

    public String getLabel() {
        return this.label;
    }

    public boolean wasModified() {
        return this.wasModified;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] readFile(String filename, String fileType) throws IOException {
        C64FileEntry entry = null;
        boolean matchFound = false;
        Enumeration en = this.directoryElements();
        while (!matchFound && en.hasMoreElements()) {
            entry = (C64FileEntry)en.nextElement();
            matchFound = DriveHandler.matches(entry, filename, fileType);
        }
        byte[] result = null;
        if (matchFound) return this.readFile(entry);
        if (!"$".equals(filename.trim())) throw new IOException("File not found: '" + filename.trim() + "'!");
        return this.readDirectory();
    }

    public byte[] readFile(String filename) throws IOException {
        return this.readFile(filename, null);
    }

    public static boolean matches(C64FileEntry entry, String filename, String fileType) {
        boolean isFileTypeOK;
        boolean bl = isFileTypeOK = fileType == null || entry.getFileTypeName().equalsIgnoreCase(fileType);
        if (filename.indexOf(42) < 0 && filename.indexOf(63) < 0) {
            return entry.filename.trim().equals(filename.trim()) && isFileTypeOK;
        }
        int compareLength = filename.indexOf(42) < 0 ? entry.filename.length() : filename.indexOf(42);
        StringBuffer entryFN = new StringBuffer(entry.filename.substring(0, compareLength));
        boolean matches = isFileTypeOK;
        int i = 0;
        while (matches && i < entryFN.length()) {
            matches &= entryFN.charAt(i) == filename.charAt(i) || filename.charAt(i) == '?';
            ++i;
        }
        return matches;
    }

    public byte[] createDelta(InputStream in) throws IOException {
        int b;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        int lastIndex = 0;
        while (i < this.bytes.length && (b = in.read()) >= 0) {
            if ((byte)b != this.bytes[i]) {
                int n;
                int offset;
                out.write(offset % 128 | ((offset = i - lastIndex) >= 128 ? 128 : 0));
                if (offset >= 128) {
                    out.write((offset >> 7) % 128 | (offset >= 16384 ? 128 : 0));
                    if (offset >= 16384) {
                        out.write((offset >> 14) % 256);
                    }
                }
                lastIndex = i;
                ByteArrayOutputStream newBytes = new ByteArrayOutputStream();
                newBytes.write(this.bytes[i]);
                ++i;
                while (i < this.bytes.length && (b = in.read()) >= 0 && (byte)b != this.bytes[i]) {
                    newBytes.write(this.bytes[i]);
                    ++i;
                }
                out.write(n % 128 | ((n = newBytes.size()) >= 128 ? 128 : 0));
                if (n >= 128) {
                    out.write((n >> 7) % 128 | (n >= 16384 ? 128 : 0));
                    if (n >= 16384) {
                        out.write((n >> 14) % 256);
                    }
                }
                out.write(newBytes.toByteArray(), 0, n);
            }
            ++i;
        }
        return out.toByteArray();
    }

    public void applyDelta(InputStream in) throws IOException {
        int b;
        int lastIndex = 0;
        while ((b = in.read()) >= 0) {
            int index;
            int offset = b;
            if (offset >= 128) {
                offset &= 0x7F;
                if ((offset += in.read() << 7) >= 16384) {
                    offset &= 0x3FFF;
                    offset += in.read() << 14;
                }
            }
            lastIndex = index = lastIndex + offset;
            int n = in.read();
            if (n >= 128) {
                n &= 0x7F;
                if ((n += in.read() << 7) >= 16384) {
                    n &= 0x3FFF;
                    n += in.read() << 14;
                }
            }
            int i = 0;
            while (i < n) {
                this.bytes[index + i] = (byte)in.read();
                ++i;
            }
        }
    }

    public void writeFile(String filename, byte[] bytes) throws IOException {
        throw new RuntimeException("Writing to files not yet implemented for " + this.getClass().getName());
    }

    public void deleteFile(String filename) throws IOException {
        throw new IOException("Deleting files not yet implemented for " + this.getClass().getName());
    }

    public void renameFile(String oldFilename, String newFilename) throws IOException {
        throw new IOException("Renaming files not yet implemented for " + this.getClass().getName());
    }

    public byte[] readDirectory() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(1);
        out.write(4);
        out.write(1);
        out.write(1);
        out.write(0);
        out.write(0);
        out.write(18);
        out.write(34);
        int i = 0;
        while (i < this.label.length() && i < 23) {
            out.write(this.label.charAt(i));
            ++i;
        }
        i = this.label.length();
        while (i < 23) {
            out.write(32);
            ++i;
        }
        out.write(34);
        out.write(0);
        Enumeration en = this.directoryElements();
        while (en.hasMoreElements()) {
            C64FileEntry entry = (C64FileEntry)en.nextElement();
            String name = entry.filename.trim();
            out.write(1);
            out.write(1);
            int blocks = entry.blocks;
            out.write(blocks & 0xFF);
            out.write(blocks >> 8);
            out.write(32);
            if (blocks < 100) {
                out.write(32);
            }
            if (blocks < 10) {
                out.write(32);
            }
            out.write(34);
            int j = 0;
            while (j < name.length()) {
                out.write(name.charAt(j));
                ++j;
            }
            out.write(34);
            j = name.length();
            while (j < 16) {
                out.write(32);
                ++j;
            }
            out.write((entry.fileType & 0x80) != 0 ? 32 : 42);
            String fileTypeName = entry.getFileTypeName();
            out.write(fileTypeName.charAt(0));
            out.write(fileTypeName.charAt(1));
            out.write(fileTypeName.charAt(2));
            out.write((entry.fileType & 0x40) != 0 ? 60 : 32);
            out.write(0);
        }
        String blocksFree = "BLOCKS FREE.             ";
        out.write(1);
        out.write(1);
        out.write(this.freeBlocks & 0xFF);
        out.write(this.freeBlocks / 256);
        int i2 = 0;
        while (i2 < "BLOCKS FREE.             ".length()) {
            out.write("BLOCKS FREE.             ".charAt(i2));
            ++i2;
        }
        out.write(0);
        out.write(0);
        out.write(0);
        return out.toByteArray();
    }

    protected String readC64Filename(byte[] buffer, int offset, int length) {
        StringBuffer filename = new StringBuffer();
        int i = offset;
        while (i < offset + length) {
            if (buffer[i] == -96) {
                filename.append(' ');
            } else {
                filename.append((char)buffer[i]);
            }
            ++i;
        }
        return filename.toString();
    }

    protected void writeC64Filename(byte[] buffer, int offset, int length, String filename) {
        int i = 0;
        while (i < length) {
            buffer[i + offset] = (byte)(i >= filename.length() ? 160 : (int)filename.charAt(i));
            ++i;
        }
    }

    public abstract byte[] readFile(C64FileEntry var1);

    public abstract void mount(byte[] var1);

    public abstract Enumeration directoryElements();
}

