/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.swing;

import de.joergjahnke.c64.core.C1541;
import de.joergjahnke.c64.core.C64;
import de.joergjahnke.c64.drive.DriveHandler;
import de.joergjahnke.c64.extendeddevices.EmulatorUtils;
import de.joergjahnke.c64.swing.C64Canvas;
import de.joergjahnke.common.extendeddevices.WavePlayer;
import de.joergjahnke.common.util.Observer;
import de.joergjahnke.common.vmabstraction.sunvm.SunVMResourceLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class C64Frame
extends JFrame
implements Observer {
    private static final String VERSION = "1.10.2a";
    private static final String URL_ONLINE_HELP = "http://jmec64.wiki.sourceforge.net/JSwingC64+online+help";
    private static final String PROJECT_PAGE_URL = "https://sourceforge.net/projects/jmec64/";
    private static final String PROPERTIES_NAME = "JSwingC64.properties.xml";
    private static final String SUSPENDFILE_NAME = "JSwingC64.suspend";
    private static final String ICON_NAME = "/res/jme/J64_sm.png";
    private static final String SETTING_WINDOW_SCALING = "WindowScaling";
    private static final String SETTING_MOUSE_USAGE = "MouseUsage";
    private static final String SETTING_JOYSTICK_PORT = "JoystickPort";
    private static final String SETTING_IMAGE_DIRECTORY = "ImageDirectory";
    private static final String SETTING_DRIVE_MODE = "DriveMode";
    private static final String SETTING_FRAMESKIP = "FrameSkip";
    private static final int CLEAR_DRIVE_STATE_TIME = 1000;
    private final C64Canvas canvas;
    private C64 c64 = null;
    private File lastFile = null;
    private Timer statusMessageTimer = null;
    private Timer driveStateTimer = null;
    private TimerTask driveInactiveTask = null;
    private Integer currentDriveState = null;
    private final Properties settings = new Properties();
    private boolean automaticTurboMode = true;
    private final Hashtable attachedImages = new Hashtable();
    private final ResourceBundle resources = ResourceBundle.getBundle("res/l10n/c64EmulatorMessages");
    public static String imageFilename = "";
    private ButtonGroup buttonGroupDriveModes;
    private ButtonGroup buttonGroupFrameSkipSelections;
    private ButtonGroup buttonGroupJoystickPorts;
    private ButtonGroup buttonGroupMouseEmulation;
    private ButtonGroup buttonGroupScreenSizes;
    private ButtonGroup buttonGroupTurboModes;
    private JLabel jLabelDrives;
    private JLabel jLabelMessages;
    private JLabel jLabelPerformance;
    private JLabel jLabelTrackSector;
    private JMenu jMenuAutoStart;
    private JMenuBar jMenuBar;
    private JMenu jMenuDriveMode;
    private JMenu jMenuEmulation;
    private JMenu jMenuFile;
    private JMenu jMenuFrameskip;
    private JMenu jMenuHelp;
    private JMenuItem jMenuItemAbout;
    private JMenuItem jMenuItemAttachImage;
    private JMenuItem jMenuItemAutoStart;
    private JRadioButtonMenuItem jMenuItemBalancedC1541;
    private JRadioButtonMenuItem jMenuItemCompatibleC1541;
    private JMenuItem jMenuItemContents;
    private JMenuItem jMenuItemDetachImages;
    private JMenuItem jMenuItemExit;
    private JMenuItem jMenuItemFastAutoStart;
    private JRadioButtonMenuItem jMenuItemFastC1541;
    private JMenuItem jMenuItemFastLoadProgram;
    private JRadioButtonMenuItem jMenuItemFrameSkip1;
    private JRadioButtonMenuItem jMenuItemFrameSkip2;
    private JRadioButtonMenuItem jMenuItemFrameSkip3;
    private JRadioButtonMenuItem jMenuItemFrameSkip4;
    private JRadioButtonMenuItem jMenuItemFrameSkipAuto;
    private JMenuItem jMenuItemLoadProgram;
    private JMenuItem jMenuItemReset;
    private JMenuItem jMenuItemRun;
    private JMenuItem jMenuItemShowLog;
    private JRadioButtonMenuItem jMenuItemSizeX1;
    private JRadioButtonMenuItem jMenuItemSizeX2;
    private JRadioButtonMenuItem jMenuItemSizeX3;
    private JMenuItem jMenuItemSpecialKey;
    private JMenuItem jMenuItemSuspend;
    private JMenuItem jMenuItemTypeText;
    private JMenu jMenuJoystick;
    private JMenu jMenuJoystickPort;
    private JMenu jMenuLoadProgram;
    private JMenu jMenuMouseAsJoystick;
    private JMenu jMenuSelectDrive;
    private JMenu jMenuSize;
    private JMenu jMenuTurboMode;
    private JPanel jPanelDrive;
    private JPanel jPanelStatus;
    private JRadioButtonMenuItem jRadioButtonMenuItemJoystickPort1;
    private JRadioButtonMenuItem jRadioButtonMenuItemJoystickPort2;
    private JRadioButtonMenuItem jRadioButtonMenuItemMouseFireButtonEmulation;
    private JRadioButtonMenuItem jRadioButtonMenuItemNoMouseJoystickEmulation;
    private JRadioButtonMenuItem jRadioButtonMenuItemTurboModeAuto;
    private JRadioButtonMenuItem jRadioButtonMenuItemTurboModeOff;
    private JRadioButtonMenuItem jRadioButtonMenuItemTurboModeOn;
    private JRadioButtonMenuItem jRadioButtonMenuItemVirtualJoystick;
    private JSeparator jSeparatorEmulationMenu1;
    private JSeparator jSeparatorEmulationMenu2;
    private JSeparator jSeparatorFileMenu1;
    private JSeparator jSeparatorFileMenu2;
    private JRadioButtonMenuItem[] jCheckBoxMenuItemSelectedDrives;

    public C64Frame() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.settings.loadFromXML(new FileInputStream(new File(PROPERTIES_NAME)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initComponents();
        this.jCheckBoxMenuItemSelectedDrives = new JRadioButtonMenuItem[4];
        int i22 = 0;
        while (i22 < 4) {
            this.jCheckBoxMenuItemSelectedDrives[i22] = new JRadioButtonMenuItem(String.valueOf(i22) + " (#" + (i22 + 8) + ")");
            this.jCheckBoxMenuItemSelectedDrives[i22].setSelected(i22 == 0);
            this.jCheckBoxMenuItemSelectedDrives[i22].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    C64Frame.this.jCheckBoxMenuItemSelectDriveItemStateChanged(evt);
                }
            });
            this.jMenuSelectDrive.add(this.jCheckBoxMenuItemSelectedDrives[i22]);
            ++i22;
        }
        try {
            this.setIconImage(this.getToolkit().getImage(this.getClass().getResource(ICON_NAME)));
        }
        catch (SecurityException i22) {
            // empty catch block
        }
        this.canvas = new C64Canvas();
        try {
            this.c64 = new C64(new SunVMResourceLoader());
            this.canvas.setC64(this.c64);
            int frameskip = Integer.parseInt(this.settings.getProperty(SETTING_FRAMESKIP, "0"));
            switch (frameskip) {
                case 1: {
                    this.jMenuItemFrameSkip1ActionPerformed(null);
                    break;
                }
                case 2: {
                    this.jMenuItemFrameSkip2ActionPerformed(null);
                    break;
                }
                case 3: {
                    this.jMenuItemFrameSkip3ActionPerformed(null);
                    break;
                }
                case 4: {
                    this.jMenuItemFrameSkip4ActionPerformed(null);
                    break;
                }
                default: {
                    this.jMenuItemFrameSkipAutoActionPerformed(null);
                }
            }
            this.c64.getSID().addObserver(new WavePlayer(this.c64.getSID()));
            this.getContentPane().add((Component)this.canvas, "Center");
            int scaling = Integer.parseInt(this.settings.getProperty(SETTING_WINDOW_SCALING, "1"));
            switch (scaling) {
                case 1: {
                    this.jMenuItemSizeX1ActionPerformed(null);
                    break;
                }
                case 2: {
                    this.jMenuItemSizeX2ActionPerformed(null);
                    break;
                }
                case 3: {
                    this.jMenuItemSizeX3ActionPerformed(null);
                }
            }
            int level = Integer.parseInt(this.settings.getProperty(SETTING_DRIVE_MODE, Integer.toString(50)));
            switch (level) {
                case 0: {
                    this.jMenuItemFastC1541ActionPerformed(null);
                    break;
                }
                case 50: {
                    this.jMenuItemBalancedC1541ActionPerformed(null);
                    break;
                }
                case 100: {
                    this.jMenuItemCompatibleC1541ActionPerformed(null);
                }
            }
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
            this.setResizable(false);
            this.c64.getLogger().addObserver(this);
            int i = 0;
            while (i < 4) {
                this.c64.getDrive(i).addObserver(this);
                ++i;
            }
            this.c64.addObserver(this);
            this.resume();
            new Thread(this.c64).start();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(String.valueOf(this.resources.getString("CouldNotInitialize")) + e);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                try {
                    C64Frame.this.settings.storeToXML(new FileOutputStream(new File(C64Frame.PROPERTIES_NAME)), "Properties for JSwingC64");
                    C64Frame.this.c64.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        switch (Integer.parseInt(this.settings.getProperty(SETTING_MOUSE_USAGE, Integer.toString(1)))) {
            case 2: {
                this.jRadioButtonMenuItemVirtualJoystickActionPerformed(null);
                break;
            }
            case 1: {
                this.jRadioButtonMenuItemMouseFireButtonEmulationActionPerformed(null);
                break;
            }
            case 0: {
                this.jRadioButtonMenuItemNoMouseJoystickEmulationActionPerformed(null);
            }
        }
        switch (Integer.parseInt(this.settings.getProperty(SETTING_JOYSTICK_PORT, "0"))) {
            case 0: {
                this.jRadioButtonMenuItemJoystickPort1ActionPerformed(null);
                break;
            }
            case 1: {
                this.jRadioButtonMenuItemJoystickPort2ActionPerformed(null);
            }
        }
    }

    private void attachImage(int driveNo, String program) {
        try {
            this.lastFile = EmulatorUtils.attachImage(this.c64, this.c64.getActiveDrive(), program);
            this.attachedImages.put(new Integer(driveNo), program);
            this.jMenuLoadProgram.setEnabled(true);
            this.jMenuItemDetachImages.setEnabled(true);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, String.valueOf(this.resources.getString("CouldNotLoadFile")) + ": " + program + "!\n" + e, this.resources.getString("CouldNotLoadFile"), 0);
        }
    }

    private void detachImages() {
        int i = 0;
        while (i < 4) {
            this.c64.getDrive(i).detachImage();
            ++i;
        }
        this.attachedImages.clear();
        this.jMenuLoadProgram.setEnabled(false);
        this.jMenuItemDetachImages.setEnabled(false);
    }

    private void runProgram() {
        this.c64.getKeyboard().textTyped("run");
        this.c64.getKeyboard().keyTyped("ENTER");
    }

    private boolean selectImage() {
        JFileChooser fileChooser = new JFileChooser(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".d64") || f.getName().toLowerCase().endsWith(".t64") || f.getName().toLowerCase().endsWith(".prg") || f.getName().toLowerCase().endsWith(".p00") || f.getName().toLowerCase().endsWith(".gzd") || f.isDirectory();
            }
        };
        if (this.lastFile != null) {
            fileChooser.setCurrentDirectory(this.lastFile.getParentFile());
        } else if (this.settings.getProperty(SETTING_IMAGE_DIRECTORY) != null) {
            fileChooser.setCurrentDirectory(new File(this.settings.getProperty(SETTING_IMAGE_DIRECTORY)));
        }
        if (fileChooser.showOpenDialog(this) == 0) {
            this.attachImage(this.c64.getActiveDrive(), fileChooser.getSelectedFile().getAbsolutePath());
            this.settings.setProperty(SETTING_IMAGE_DIRECTORY, this.lastFile.getParentFile().getAbsolutePath());
            return true;
        }
        return false;
    }

    private void suspend() {
        this.c64.pause();
        boolean reallyExit = true;
        File suspend = new File(SUSPENDFILE_NAME);
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(suspend)));
            out.writeInt(this.attachedImages.size());
            Enumeration en = this.attachedImages.keys();
            while (en.hasMoreElements()) {
                Integer driveNo = (Integer)en.nextElement();
                out.writeInt(driveNo);
                out.writeUTF(this.attachedImages.get(driveNo).toString());
            }
            this.c64.serialize(out);
            out.close();
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this, String.valueOf(this.resources.getString("FailedToStoreState")) + "\n" + t, this.resources.getString("SuspendFailed"), 2);
            t.printStackTrace();
            try {
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            suspend.delete();
            reallyExit = false;
            this.c64.resume();
        }
        if (reallyExit) {
            this.setVisible(false);
            System.exit(0);
        }
    }

    private void resume() {
        block16: {
            this.c64.pause();
            boolean hasSuspendData = false;
            File suspend = new File(SUSPENDFILE_NAME);
            try {
                try {
                    DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(suspend)));
                    hasSuspendData = true;
                    int size = in.readInt();
                    int i = 0;
                    while (i < size) {
                        int driveNo = in.readInt();
                        String program = in.readUTF();
                        this.attachImage(driveNo, program);
                        ++i;
                    }
                    this.c64.deserialize(in);
                    in.close();
                    suspend.delete();
                }
                catch (Throwable t) {
                    if (hasSuspendData) {
                        JOptionPane.showMessageDialog(this, String.valueOf(this.resources.getString("FailedToRestoreState")) + "\n" + t, this.resources.getString("Resume failed"), 0);
                        t.printStackTrace();
                    }
                    if (hasSuspendData) {
                        try {
                            suspend.delete();
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(this, String.valueOf(this.resources.getString("CouldNotRemoveSuspendDataRemoveManually")) + SUSPENDFILE_NAME + "'.", this.resources.getString("CouldNotRemoveSuspendData"), 0);
                            e.printStackTrace();
                        }
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (hasSuspendData) {
                    try {
                        suspend.delete();
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this, String.valueOf(this.resources.getString("CouldNotRemoveSuspendDataRemoveManually")) + SUSPENDFILE_NAME + "'.", this.resources.getString("CouldNotRemoveSuspendData"), 0);
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (hasSuspendData) {
                try {
                    suspend.delete();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, String.valueOf(this.resources.getString("CouldNotRemoveSuspendDataRemoveManually")) + SUSPENDFILE_NAME + "'.", this.resources.getString("CouldNotRemoveSuspendData"), 0);
                    e.printStackTrace();
                }
            }
        }
        this.c64.resume();
    }

    private void initComponents() {
        this.buttonGroupTurboModes = new ButtonGroup();
        this.buttonGroupDriveModes = new ButtonGroup();
        this.buttonGroupScreenSizes = new ButtonGroup();
        this.buttonGroupFrameSkipSelections = new ButtonGroup();
        this.buttonGroupJoystickPorts = new ButtonGroup();
        this.buttonGroupMouseEmulation = new ButtonGroup();
        this.jPanelStatus = new JPanel();
        this.jLabelPerformance = new JLabel();
        this.jLabelMessages = new JLabel();
        this.jPanelDrive = new JPanel();
        this.jLabelTrackSector = new JLabel();
        this.jLabelDrives = new JLabel();
        this.jMenuBar = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuAutoStart = new JMenu();
        this.jMenuItemAutoStart = new JMenuItem();
        this.jMenuItemFastAutoStart = new JMenuItem();
        this.jSeparatorFileMenu1 = new JSeparator();
        this.jMenuItemAttachImage = new JMenuItem();
        this.jMenuItemDetachImages = new JMenuItem();
        this.jMenuLoadProgram = new JMenu();
        this.jMenuItemLoadProgram = new JMenuItem();
        this.jMenuItemFastLoadProgram = new JMenuItem();
        this.jMenuSelectDrive = new JMenu();
        this.jSeparatorFileMenu2 = new JSeparator();
        this.jMenuItemExit = new JMenuItem();
        this.jMenuItemSuspend = new JMenuItem();
        this.jMenuEmulation = new JMenu();
        this.jMenuItemTypeText = new JMenuItem();
        this.jMenuItemSpecialKey = new JMenuItem();
        this.jMenuItemRun = new JMenuItem();
        this.jSeparatorEmulationMenu1 = new JSeparator();
        this.jMenuJoystick = new JMenu();
        this.jMenuJoystickPort = new JMenu();
        this.jRadioButtonMenuItemJoystickPort1 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemJoystickPort2 = new JRadioButtonMenuItem();
        this.jMenuMouseAsJoystick = new JMenu();
        this.jRadioButtonMenuItemNoMouseJoystickEmulation = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemMouseFireButtonEmulation = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemVirtualJoystick = new JRadioButtonMenuItem();
        this.jMenuDriveMode = new JMenu();
        this.jMenuItemFastC1541 = new JRadioButtonMenuItem();
        this.jMenuItemBalancedC1541 = new JRadioButtonMenuItem();
        this.jMenuItemCompatibleC1541 = new JRadioButtonMenuItem();
        this.jMenuSize = new JMenu();
        this.jMenuItemSizeX1 = new JRadioButtonMenuItem();
        this.jMenuItemSizeX2 = new JRadioButtonMenuItem();
        this.jMenuItemSizeX3 = new JRadioButtonMenuItem();
        this.jMenuFrameskip = new JMenu();
        this.jMenuItemFrameSkipAuto = new JRadioButtonMenuItem();
        this.jMenuItemFrameSkip1 = new JRadioButtonMenuItem();
        this.jMenuItemFrameSkip2 = new JRadioButtonMenuItem();
        this.jMenuItemFrameSkip3 = new JRadioButtonMenuItem();
        this.jMenuItemFrameSkip4 = new JRadioButtonMenuItem();
        this.jMenuTurboMode = new JMenu();
        this.jRadioButtonMenuItemTurboModeAuto = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemTurboModeOn = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemTurboModeOff = new JRadioButtonMenuItem();
        this.jSeparatorEmulationMenu2 = new JSeparator();
        this.jMenuItemReset = new JMenuItem();
        this.jMenuItemShowLog = new JMenuItem();
        this.jMenuHelp = new JMenu();
        this.jMenuItemAbout = new JMenuItem();
        this.jMenuItemContents = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("JSwingC64");
        this.setResizable(false);
        this.jPanelStatus.setLayout(new BorderLayout());
        this.jLabelPerformance.setFont(new Font("Arial", 0, 10));
        this.jLabelPerformance.setHorizontalAlignment(0);
        this.jLabelPerformance.setText("      ");
        ResourceBundle bundle = ResourceBundle.getBundle("res/l10n/c64EmulatorMessages");
        this.jLabelPerformance.setToolTipText(bundle.getString("PerformancePanelTooltip"));
        this.jLabelPerformance.setBorder(BorderFactory.createEtchedBorder());
        this.jLabelPerformance.setOpaque(true);
        this.jLabelPerformance.setPreferredSize(new Dimension(45, 17));
        this.jPanelStatus.add((Component)this.jLabelPerformance, "West");
        this.jLabelMessages.setFont(new Font("Arial", 0, 10));
        this.jLabelMessages.setHorizontalAlignment(2);
        this.jLabelMessages.setToolTipText(bundle.getString("MessagePanelTooltip"));
        this.jLabelMessages.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelStatus.add((Component)this.jLabelMessages, "Center");
        this.jPanelDrive.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelDrive.setMinimumSize(new Dimension(30, 18));
        this.jPanelDrive.setPreferredSize(new Dimension(50, 18));
        this.jPanelDrive.setLayout(new BorderLayout());
        this.jLabelTrackSector.setFont(new Font("Arial", 0, 10));
        this.jLabelTrackSector.setHorizontalAlignment(0);
        this.jLabelTrackSector.setToolTipText(bundle.getString("TrackSectorPanelTooltip"));
        this.jPanelDrive.add((Component)this.jLabelTrackSector, "Center");
        this.jLabelDrives.setIcon(new ImageIcon(this.getClass().getResource("/res/swing/LED_inactive.gif")));
        this.jLabelDrives.setToolTipText(bundle.getString("DriveIsInactive"));
        this.jPanelDrive.add((Component)this.jLabelDrives, "East");
        this.jPanelStatus.add((Component)this.jPanelDrive, "East");
        this.getContentPane().add((Component)this.jPanelStatus, "South");
        ResourceBundle bundle1 = ResourceBundle.getBundle("res/l10n/commonMessages");
        this.jMenuFile.setText(bundle1.getString("File"));
        this.jMenuAutoStart.setText(bundle.getString("AutoStart2"));
        this.jMenuAutoStart.setToolTipText(bundle.getString("AutoStart2Tooltip"));
        this.jMenuItemAutoStart.setAccelerator(KeyStroke.getKeyStroke(65, 10));
        this.jMenuItemAutoStart.setText(bundle.getString("AutoStart"));
        this.jMenuItemAutoStart.setToolTipText(bundle.getString("AutoStartToolTip"));
        this.jMenuItemAutoStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemAutoStartActionPerformed(evt);
            }
        });
        this.jMenuAutoStart.add(this.jMenuItemAutoStart);
        this.jMenuItemFastAutoStart.setAccelerator(KeyStroke.getKeyStroke(70, 10));
        this.jMenuItemFastAutoStart.setText(bundle.getString("FastAutoStart"));
        this.jMenuItemFastAutoStart.setToolTipText(bundle.getString("FastAutoStartToolTip"));
        this.jMenuItemFastAutoStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemFastAutoStartActionPerformed(evt);
            }
        });
        this.jMenuAutoStart.add(this.jMenuItemFastAutoStart);
        this.jMenuFile.add(this.jMenuAutoStart);
        this.jMenuFile.add(this.jSeparatorFileMenu1);
        this.jMenuItemAttachImage.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        this.jMenuItemAttachImage.setText(bundle.getString("AttachImage"));
        this.jMenuItemAttachImage.setToolTipText(bundle.getString("AttachImageTooltip"));
        this.jMenuItemAttachImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemAttachImageActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemAttachImage);
        this.jMenuItemDetachImages.setAccelerator(KeyStroke.getKeyStroke(68, 8));
        this.jMenuItemDetachImages.setText(bundle.getString("DetachAll"));
        this.jMenuItemDetachImages.setToolTipText(bundle.getString("DetachAllTooltip"));
        this.jMenuItemDetachImages.setEnabled(false);
        this.jMenuItemDetachImages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemDetachImagesActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemDetachImages);
        this.jMenuLoadProgram.setText(bundle.getString("LoadProgram"));
        this.jMenuLoadProgram.setToolTipText(bundle.getString("LoadProgramTooltip"));
        this.jMenuLoadProgram.setEnabled(false);
        this.jMenuItemLoadProgram.setAccelerator(KeyStroke.getKeyStroke(76, 8));
        this.jMenuItemLoadProgram.setText(bundle.getString("Load"));
        this.jMenuItemLoadProgram.setToolTipText(bundle.getString("LoadProgramTooltip"));
        this.jMenuItemLoadProgram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemLoadProgramActionPerformed(evt);
            }
        });
        this.jMenuLoadProgram.add(this.jMenuItemLoadProgram);
        this.jMenuItemFastLoadProgram.setAccelerator(KeyStroke.getKeyStroke(70, 8));
        this.jMenuItemFastLoadProgram.setText(bundle.getString("FastLoad"));
        this.jMenuItemFastLoadProgram.setToolTipText(bundle.getString("FastLoadProgramTooltip"));
        this.jMenuItemFastLoadProgram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemLoadProgramActionPerformed(evt);
            }
        });
        this.jMenuLoadProgram.add(this.jMenuItemFastLoadProgram);
        this.jMenuFile.add(this.jMenuLoadProgram);
        this.jMenuSelectDrive.setText(bundle.getString("SelectDrive"));
        this.jMenuSelectDrive.setToolTipText(bundle.getString("SelectDriveTooltip"));
        this.jMenuFile.add(this.jMenuSelectDrive);
        this.jMenuFile.add(this.jSeparatorFileMenu2);
        this.jMenuItemExit.setText(bundle1.getString("Exit"));
        this.jMenuItemExit.setToolTipText(bundle1.getString("ExitTooltip"));
        this.jMenuItemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemExitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemExit);
        this.jMenuItemSuspend.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        this.jMenuItemSuspend.setText(bundle1.getString("Suspend"));
        this.jMenuItemSuspend.setToolTipText(bundle1.getString("SuspendTooltip"));
        this.jMenuItemSuspend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemSuspendActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemSuspend);
        this.jMenuBar.add(this.jMenuFile);
        this.jMenuEmulation.setText(bundle1.getString("Emulation"));
        this.jMenuItemTypeText.setAccelerator(KeyStroke.getKeyStroke(84, 8));
        this.jMenuItemTypeText.setText(bundle.getString("TypeText2"));
        this.jMenuItemTypeText.setToolTipText(bundle.getString("TypeText2Tooltip"));
        this.jMenuItemTypeText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemTypeTextActionPerformed(evt);
            }
        });
        this.jMenuEmulation.add(this.jMenuItemTypeText);
        this.jMenuItemSpecialKey.setAccelerator(KeyStroke.getKeyStroke(75, 8));
        this.jMenuItemSpecialKey.setText(bundle.getString("SpecialKeys2"));
        this.jMenuItemSpecialKey.setToolTipText(bundle.getString("SpecialKeys2Tooltip"));
        this.jMenuItemSpecialKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemSpecialKeyActionPerformed(evt);
            }
        });
        this.jMenuEmulation.add(this.jMenuItemSpecialKey);
        this.jMenuItemRun.setAccelerator(KeyStroke.getKeyStroke(82, 8));
        this.jMenuItemRun.setText(bundle.getString("RunCurrent"));
        this.jMenuItemRun.setToolTipText(bundle.getString("RunCurrentTooltip"));
        this.jMenuItemRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemRunActionPerformed(evt);
            }
        });
        this.jMenuEmulation.add(this.jMenuItemRun);
        this.jMenuEmulation.add(this.jSeparatorEmulationMenu1);
        this.jMenuJoystick.setText(bundle.getString("Joystick"));
        this.jMenuJoystick.setToolTipText(bundle.getString("JoystickTooltip"));
        this.jMenuJoystickPort.setText(bundle.getString("Port"));
        this.jRadioButtonMenuItemJoystickPort1.setAccelerator(KeyStroke.getKeyStroke(49, 8));
        this.buttonGroupJoystickPorts.add(this.jRadioButtonMenuItemJoystickPort1);
        this.jRadioButtonMenuItemJoystickPort1.setSelected(true);
        this.jRadioButtonMenuItemJoystickPort1.setText("1");
        this.jRadioButtonMenuItemJoystickPort1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jRadioButtonMenuItemJoystickPort1ActionPerformed(evt);
            }
        });
        this.jMenuJoystickPort.add(this.jRadioButtonMenuItemJoystickPort1);
        this.jRadioButtonMenuItemJoystickPort2.setAccelerator(KeyStroke.getKeyStroke(50, 8));
        this.buttonGroupJoystickPorts.add(this.jRadioButtonMenuItemJoystickPort2);
        this.jRadioButtonMenuItemJoystickPort2.setText("2");
        this.jRadioButtonMenuItemJoystickPort2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jRadioButtonMenuItemJoystickPort2ActionPerformed(evt);
            }
        });
        this.jMenuJoystickPort.add(this.jRadioButtonMenuItemJoystickPort2);
        this.jMenuJoystick.add(this.jMenuJoystickPort);
        this.jMenuMouseAsJoystick.setText(bundle.getString("EmulationViaMouse"));
        this.buttonGroupMouseEmulation.add(this.jRadioButtonMenuItemNoMouseJoystickEmulation);
        this.jRadioButtonMenuItemNoMouseJoystickEmulation.setText(bundle.getString("EmulationViaMouseNone"));
        this.jRadioButtonMenuItemNoMouseJoystickEmulation.setToolTipText(bundle.getString("EmulationViaMouseNoneTooltip"));
        this.jRadioButtonMenuItemNoMouseJoystickEmulation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jRadioButtonMenuItemNoMouseJoystickEmulationActionPerformed(evt);
            }
        });
        this.jMenuMouseAsJoystick.add(this.jRadioButtonMenuItemNoMouseJoystickEmulation);
        this.buttonGroupMouseEmulation.add(this.jRadioButtonMenuItemMouseFireButtonEmulation);
        this.jRadioButtonMenuItemMouseFireButtonEmulation.setSelected(true);
        this.jRadioButtonMenuItemMouseFireButtonEmulation.setText(bundle.getString("EmulationViaMouseButtonOnly"));
        this.jRadioButtonMenuItemMouseFireButtonEmulation.setToolTipText(bundle.getString("EmulationViaMouseButtonOnlyTooltip"));
        this.jRadioButtonMenuItemMouseFireButtonEmulation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jRadioButtonMenuItemMouseFireButtonEmulationActionPerformed(evt);
            }
        });
        this.jMenuMouseAsJoystick.add(this.jRadioButtonMenuItemMouseFireButtonEmulation);
        this.buttonGroupMouseEmulation.add(this.jRadioButtonMenuItemVirtualJoystick);
        this.jRadioButtonMenuItemVirtualJoystick.setText(bundle.getString("EmulationViaMouseFull"));
        this.jRadioButtonMenuItemVirtualJoystick.setToolTipText(bundle.getString("EmulationViaMouseFullTooltip"));
        this.jRadioButtonMenuItemVirtualJoystick.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jRadioButtonMenuItemVirtualJoystickActionPerformed(evt);
            }
        });
        this.jMenuMouseAsJoystick.add(this.jRadioButtonMenuItemVirtualJoystick);
        this.jMenuJoystick.add(this.jMenuMouseAsJoystick);
        this.jMenuEmulation.add(this.jMenuJoystick);
        this.jMenuDriveMode.setText(bundle.getString("C1541Mode"));
        this.jMenuDriveMode.setToolTipText(bundle.getString("C1541ModeTooltip"));
        this.buttonGroupDriveModes.add(this.jMenuItemFastC1541);
        this.jMenuItemFastC1541.setText(bundle.getString("Fast"));
        this.jMenuItemFastC1541.setToolTipText(bundle.getString("FastTooltip"));
        this.jMenuItemFastC1541.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemFastC1541ActionPerformed(evt);
            }
        });
        this.jMenuDriveMode.add(this.jMenuItemFastC1541);
        this.buttonGroupDriveModes.add(this.jMenuItemBalancedC1541);
        this.jMenuItemBalancedC1541.setText(bundle.getString("Balanced"));
        this.jMenuItemBalancedC1541.setToolTipText(bundle.getString("BalancedTooltip"));
        this.jMenuItemBalancedC1541.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemBalancedC1541ActionPerformed(evt);
            }
        });
        this.jMenuDriveMode.add(this.jMenuItemBalancedC1541);
        this.buttonGroupDriveModes.add(this.jMenuItemCompatibleC1541);
        this.jMenuItemCompatibleC1541.setText(bundle.getString("Compatible"));
        this.jMenuItemCompatibleC1541.setToolTipText(bundle.getString("CompatibleTooltip"));
        this.jMenuItemCompatibleC1541.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemCompatibleC1541ActionPerformed(evt);
            }
        });
        this.jMenuDriveMode.add(this.jMenuItemCompatibleC1541);
        this.jMenuEmulation.add(this.jMenuDriveMode);
        this.jMenuSize.setText(bundle1.getString("Size"));
        this.jMenuSize.setToolTipText(bundle1.getString("SizeTooltip"));
        this.jMenuItemSizeX1.setAccelerator(KeyStroke.getKeyStroke(49, 9));
        this.buttonGroupScreenSizes.add(this.jMenuItemSizeX1);
        this.jMenuItemSizeX1.setText("100%");
        this.jMenuItemSizeX1.setToolTipText(bundle.getString("Size100Tooltip"));
        this.jMenuItemSizeX1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemSizeX1ActionPerformed(evt);
            }
        });
        this.jMenuSize.add(this.jMenuItemSizeX1);
        this.jMenuItemSizeX2.setAccelerator(KeyStroke.getKeyStroke(50, 9));
        this.buttonGroupScreenSizes.add(this.jMenuItemSizeX2);
        this.jMenuItemSizeX2.setText("200%");
        this.jMenuItemSizeX2.setToolTipText(bundle.getString("Size200Tooltip"));
        this.jMenuItemSizeX2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemSizeX2ActionPerformed(evt);
            }
        });
        this.jMenuSize.add(this.jMenuItemSizeX2);
        this.jMenuItemSizeX3.setAccelerator(KeyStroke.getKeyStroke(51, 9));
        this.buttonGroupScreenSizes.add(this.jMenuItemSizeX3);
        this.jMenuItemSizeX3.setText("300%");
        this.jMenuItemSizeX3.setToolTipText(bundle.getString("Size300Tooltip"));
        this.jMenuItemSizeX3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemSizeX3ActionPerformed(evt);
            }
        });
        this.jMenuSize.add(this.jMenuItemSizeX3);
        this.jMenuEmulation.add(this.jMenuSize);
        this.jMenuFrameskip.setText(bundle1.getString("SkipFrames"));
        this.jMenuFrameskip.setToolTipText(bundle1.getString("SkipFramesTooltip"));
        this.buttonGroupFrameSkipSelections.add(this.jMenuItemFrameSkipAuto);
        this.jMenuItemFrameSkipAuto.setText(bundle.getString("Automatic"));
        this.jMenuItemFrameSkipAuto.setToolTipText(bundle.getString("AutomaticTooltip"));
        this.jMenuItemFrameSkipAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemFrameSkipAutoActionPerformed(evt);
            }
        });
        this.jMenuFrameskip.add(this.jMenuItemFrameSkipAuto);
        this.buttonGroupFrameSkipSelections.add(this.jMenuItemFrameSkip1);
        this.jMenuItemFrameSkip1.setText("1");
        this.jMenuItemFrameSkip1.setToolTipText(bundle1.getString("SkipFrames1Tooltip"));
        this.jMenuItemFrameSkip1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemFrameSkip1ActionPerformed(evt);
            }
        });
        this.jMenuFrameskip.add(this.jMenuItemFrameSkip1);
        this.buttonGroupFrameSkipSelections.add(this.jMenuItemFrameSkip2);
        this.jMenuItemFrameSkip2.setText("2");
        this.jMenuItemFrameSkip2.setToolTipText(bundle1.getString("SkipFrames2Tooltip"));
        this.jMenuItemFrameSkip2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemFrameSkip2ActionPerformed(evt);
            }
        });
        this.jMenuFrameskip.add(this.jMenuItemFrameSkip2);
        this.buttonGroupFrameSkipSelections.add(this.jMenuItemFrameSkip3);
        this.jMenuItemFrameSkip3.setText("3");
        this.jMenuItemFrameSkip3.setToolTipText(bundle1.getString("SkipFrames3Tooltip"));
        this.jMenuItemFrameSkip3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemFrameSkip3ActionPerformed(evt);
            }
        });
        this.jMenuFrameskip.add(this.jMenuItemFrameSkip3);
        this.buttonGroupFrameSkipSelections.add(this.jMenuItemFrameSkip4);
        this.jMenuItemFrameSkip4.setText("4");
        this.jMenuItemFrameSkip4.setToolTipText(bundle1.getString("SkipFrames4Tooltip"));
        this.jMenuItemFrameSkip4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemFrameSkip4ActionPerformed(evt);
            }
        });
        this.jMenuFrameskip.add(this.jMenuItemFrameSkip4);
        this.jMenuEmulation.add(this.jMenuFrameskip);
        this.jMenuTurboMode.setText(bundle.getString("TurboMode"));
        this.jMenuTurboMode.setToolTipText(bundle.getString("TurboModeTooltip"));
        this.jRadioButtonMenuItemTurboModeAuto.setAccelerator(KeyStroke.getKeyStroke(520, 8));
        this.buttonGroupTurboModes.add(this.jRadioButtonMenuItemTurboModeAuto);
        this.jRadioButtonMenuItemTurboModeAuto.setSelected(true);
        this.jRadioButtonMenuItemTurboModeAuto.setText(bundle.getString("Automatic"));
        this.jRadioButtonMenuItemTurboModeAuto.setToolTipText(bundle.getString("TurboModeAutoTooltip"));
        this.jRadioButtonMenuItemTurboModeAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jRadioButtonMenuItemTurboModeAutoActionPerformed(evt);
            }
        });
        this.jMenuTurboMode.add(this.jRadioButtonMenuItemTurboModeAuto);
        this.jRadioButtonMenuItemTurboModeOn.setAccelerator(KeyStroke.getKeyStroke(521, 8));
        this.buttonGroupTurboModes.add(this.jRadioButtonMenuItemTurboModeOn);
        this.jRadioButtonMenuItemTurboModeOn.setText(bundle1.getString("On"));
        this.jRadioButtonMenuItemTurboModeOn.setToolTipText(bundle.getString("TurboModeOnTooltip"));
        this.jRadioButtonMenuItemTurboModeOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jRadioButtonMenuItemTurboModeOnActionPerformed(evt);
            }
        });
        this.jMenuTurboMode.add(this.jRadioButtonMenuItemTurboModeOn);
        this.jRadioButtonMenuItemTurboModeOff.setAccelerator(KeyStroke.getKeyStroke(45, 8));
        this.buttonGroupTurboModes.add(this.jRadioButtonMenuItemTurboModeOff);
        this.jRadioButtonMenuItemTurboModeOff.setText(bundle1.getString("Off"));
        this.jRadioButtonMenuItemTurboModeOff.setToolTipText(bundle.getString("TurboModeOffTooltip"));
        this.jRadioButtonMenuItemTurboModeOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jRadioButtonMenuItemTurboModeOffActionPerformed(evt);
            }
        });
        this.jMenuTurboMode.add(this.jRadioButtonMenuItemTurboModeOff);
        this.jMenuEmulation.add(this.jMenuTurboMode);
        this.jMenuEmulation.add(this.jSeparatorEmulationMenu2);
        this.jMenuItemReset.setText(bundle.getString("ResetC64"));
        this.jMenuItemReset.setToolTipText(bundle.getString("ResetC64Tooltip"));
        this.jMenuItemReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemResetActionPerformed(evt);
            }
        });
        this.jMenuEmulation.add(this.jMenuItemReset);
        this.jMenuItemShowLog.setText(bundle1.getString("ShowLog"));
        this.jMenuItemShowLog.setToolTipText(bundle1.getString("ShowLogTooltip"));
        this.jMenuItemShowLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemShowLogActionPerformed(evt);
            }
        });
        this.jMenuEmulation.add(this.jMenuItemShowLog);
        this.jMenuBar.add(this.jMenuEmulation);
        this.jMenuHelp.setText(bundle1.getString("Help"));
        this.jMenuItemAbout.setText(bundle1.getString("About"));
        this.jMenuItemAbout.setToolTipText(bundle1.getString("AboutTooltip"));
        this.jMenuItemAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemAboutActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemAbout);
        this.jMenuItemContents.setAccelerator(KeyStroke.getKeyStroke(112, 8));
        this.jMenuItemContents.setText(bundle1.getString("Contents"));
        this.jMenuItemContents.setToolTipText(bundle1.getString("ContentsTooltip"));
        this.jMenuItemContents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                C64Frame.this.jMenuItemContentsActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemContents);
        this.jMenuBar.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar);
        this.pack();
    }

    private void jRadioButtonMenuItemVirtualJoystickActionPerformed(ActionEvent evt) {
        this.canvas.setMouseUsage(2);
        this.settings.setProperty(SETTING_MOUSE_USAGE, Integer.toString(2));
        this.jRadioButtonMenuItemVirtualJoystick.setSelected(true);
    }

    private void jRadioButtonMenuItemMouseFireButtonEmulationActionPerformed(ActionEvent evt) {
        this.canvas.setMouseUsage(1);
        this.settings.setProperty(SETTING_MOUSE_USAGE, Integer.toString(1));
        this.jRadioButtonMenuItemMouseFireButtonEmulation.setSelected(true);
    }

    private void jRadioButtonMenuItemNoMouseJoystickEmulationActionPerformed(ActionEvent evt) {
        this.canvas.setMouseUsage(0);
        this.settings.setProperty(SETTING_MOUSE_USAGE, Integer.toString(0));
        this.jRadioButtonMenuItemNoMouseJoystickEmulation.setSelected(true);
    }

    private void jMenuItemShowLogActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, this.c64.getLogger().dumpAll(), this.resources.getString("LogMessages"), 1);
    }

    private void jMenuItemContentsActionPerformed(ActionEvent evt) {
        try {
            Desktop.getDesktop().browse(new URI(URL_ONLINE_HELP));
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this, String.valueOf(this.resources.getString("CouldNotStartBrowser")) + " '" + URL_ONLINE_HELP + "'", this.resources.getString("CouldNotDisplayOnlineHelp"), 0);
        }
    }

    private void jRadioButtonMenuItemJoystickPort2ActionPerformed(ActionEvent evt) {
        this.c64.setActiveJoystick(1);
        this.settings.setProperty(SETTING_JOYSTICK_PORT, "1");
        this.jRadioButtonMenuItemJoystickPort2.setSelected(true);
    }

    private void jRadioButtonMenuItemJoystickPort1ActionPerformed(ActionEvent evt) {
        this.c64.setActiveJoystick(0);
        this.settings.setProperty(SETTING_JOYSTICK_PORT, "0");
        this.jRadioButtonMenuItemJoystickPort1.setSelected(true);
    }

    private void jMenuItemSizeX1ActionPerformed(ActionEvent evt) {
        this.canvas.setScaling(1);
        this.settings.setProperty(SETTING_WINDOW_SCALING, "1");
        this.pack();
        this.jMenuItemSizeX1.setSelected(true);
    }

    private void jMenuItemSizeX2ActionPerformed(ActionEvent evt) {
        this.canvas.setScaling(2);
        this.settings.setProperty(SETTING_WINDOW_SCALING, "2");
        this.pack();
        this.jMenuItemSizeX2.setSelected(true);
    }

    private void jMenuItemSizeX3ActionPerformed(ActionEvent evt) {
        this.canvas.setScaling(3);
        this.settings.setProperty(SETTING_WINDOW_SCALING, "3");
        this.pack();
        this.jMenuItemSizeX3.setSelected(true);
    }

    private void jMenuItemAboutActionPerformed(ActionEvent evt) {
        String text = String.valueOf(this.resources.getString("AboutText1")) + VERSION + this.resources.getString("AboutText2") + this.resources.getString("AboutText3") + this.resources.getString("AboutText4");
        text = text.replaceAll("\\n", "<br>");
        text = text.replaceAll("\\#PROJECTPAGE\\#", "\\<a href\\=\\'https://sourceforge.net/projects/jmec64/\\'\\>https://sourceforge.net/projects/jmec64/\\<\\/a\\>");
        text = "<html><body>" + text + "</body></html>";
        JEditorPane messagePane = new JEditorPane("text/html", text);
        messagePane.setBackground(this.getBackground());
        messagePane.setEditable(false);
        messagePane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        Desktop.getDesktop().browse(evt.getURL().toURI());
                    }
                    catch (Throwable t) {
                        System.err.println("Could not browse to page " + evt.getURL());
                    }
                }
            }
        });
        JOptionPane.showMessageDialog(this, messagePane);
    }

    private void jMenuItemSpecialKeyActionPerformed(ActionEvent evt) {
        Object[] specialKeys = new String[]{"Run", "Break", "Commodore", "Pound"};
        Object key = JOptionPane.showInputDialog(this, this.resources.getString("SelectKey"), this.resources.getString("SpecialKeys"), -1, null, specialKeys, null);
        if (key != null) {
            this.c64.getKeyboard().keyTyped(key.toString().toUpperCase());
        }
    }

    private void jMenuItemTypeTextActionPerformed(ActionEvent evt) {
        JOptionPane pane = new JOptionPane(this.resources.getString("TextToEnter"), 3, 2);
        JComboBox combobox = new JComboBox(this.c64.getKeyboard().getTypedTexts());
        combobox.setEditable(true);
        combobox.setSelectedIndex(-1);
        pane.add((Component)combobox, 1);
        JDialog dialog = pane.createDialog(this, this.resources.getString("TypeText"));
        combobox.requestFocusInWindow();
        dialog.setVisible(true);
        Object text = combobox.getSelectedItem();
        if (pane.getValue() instanceof Integer && (Integer)pane.getValue() == 0 && text != null) {
            this.c64.getKeyboard().textTyped(text.toString());
        }
    }

    private void jMenuItemLoadProgramActionPerformed(ActionEvent evt) {
        Vector programs = this.c64.getDrive(this.c64.getActiveDrive()).getFilenames();
        if (programs.isEmpty()) {
            JOptionPane.showMessageDialog(this, this.resources.getString("PleaseAttachImageBefore"), this.resources.getString("NoProgramsToLoad"), 2);
        } else {
            Object program = JOptionPane.showInputDialog(this, this.resources.getString("SelectProgram"), this.resources.getString("LoadProgram"), -1, null, programs.toArray(), programs.elementAt(0));
            if (program != null) {
                if (evt.getActionCommand().indexOf(this.resources.getString("FastLoadProgram")) < 0) {
                    this.c64.loadFile(program.toString());
                } else {
                    try {
                        this.c64.fastLoadFile(program.toString(), -1);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(this, String.valueOf(this.resources.getString("CouldNotLoadFile")) + ": " + program.toString() + "!\n" + e, this.resources.getString("CouldNotLoadFile"), 2);
                    }
                }
            }
        }
    }

    private void jMenuItemRunActionPerformed(ActionEvent evt) {
        this.runProgram();
    }

    private void jMenuItemResetActionPerformed(ActionEvent evt) {
        this.c64.reset();
    }

    private void jMenuItemExitActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        System.exit(0);
    }

    private void jMenuItemAttachImageActionPerformed(ActionEvent evt) {
        this.selectImage();
    }

    private void jMenuItemDetachImagesActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this, this.resources.getString("ReallyDetach")) == 0) {
            this.detachImages();
        }
    }

    private void jMenuItemFastC1541ActionPerformed(ActionEvent evt) {
        int i = 0;
        while (i < 4) {
            this.c64.getDrive(i).setEmulationLevel(0);
            ++i;
        }
        this.settings.setProperty(SETTING_DRIVE_MODE, Integer.toString(0));
        this.jMenuItemFastC1541.setSelected(true);
    }

    private void jMenuItemBalancedC1541ActionPerformed(ActionEvent evt) {
        int i = 0;
        while (i < 4) {
            this.c64.getDrive(i).setEmulationLevel(50);
            ++i;
        }
        this.settings.setProperty(SETTING_DRIVE_MODE, Integer.toString(50));
        this.jMenuItemBalancedC1541.setSelected(true);
    }

    private void jMenuItemCompatibleC1541ActionPerformed(ActionEvent evt) {
        int i = 0;
        while (i < 4) {
            this.c64.getDrive(i).setEmulationLevel(100);
            ++i;
        }
        this.settings.setProperty(SETTING_DRIVE_MODE, Integer.toString(100));
        this.jMenuItemCompatibleC1541.setSelected(true);
    }

    private void jMenuItemFrameSkipAutoActionPerformed(ActionEvent evt) {
        this.c64.setDoAutoAdjustFrameskip(true);
        this.settings.setProperty(SETTING_FRAMESKIP, "0");
        this.jMenuItemFrameSkipAuto.setSelected(true);
    }

    private void jMenuItemFrameSkip1ActionPerformed(ActionEvent evt) {
        this.c64.setDoAutoAdjustFrameskip(false);
        this.c64.getVIC().setFrameSkip(1);
        this.settings.setProperty(SETTING_FRAMESKIP, "1");
        this.jMenuItemFrameSkip1.setSelected(true);
    }

    private void jMenuItemFrameSkip2ActionPerformed(ActionEvent evt) {
        this.c64.setDoAutoAdjustFrameskip(false);
        this.c64.getVIC().setFrameSkip(2);
        this.settings.setProperty(SETTING_FRAMESKIP, "2");
        this.jMenuItemFrameSkip2.setSelected(true);
    }

    private void jMenuItemFrameSkip3ActionPerformed(ActionEvent evt) {
        this.c64.setDoAutoAdjustFrameskip(false);
        this.c64.getVIC().setFrameSkip(3);
        this.settings.setProperty(SETTING_FRAMESKIP, "3");
        this.jMenuItemFrameSkip3.setSelected(true);
    }

    private void jMenuItemFrameSkip4ActionPerformed(ActionEvent evt) {
        this.c64.setDoAutoAdjustFrameskip(false);
        this.c64.getVIC().setFrameSkip(4);
        this.settings.setProperty(SETTING_FRAMESKIP, "4");
        this.jMenuItemFrameSkip4.setSelected(true);
    }

    private void jRadioButtonMenuItemTurboModeAutoActionPerformed(ActionEvent evt) {
        this.c64.setThrottlingEnabled(true);
        this.automaticTurboMode = true;
    }

    private void jRadioButtonMenuItemTurboModeOnActionPerformed(ActionEvent evt) {
        this.c64.setThrottlingEnabled(false);
        this.automaticTurboMode = false;
    }

    private void jRadioButtonMenuItemTurboModeOffActionPerformed(ActionEvent evt) {
        this.c64.setThrottlingEnabled(true);
        this.automaticTurboMode = false;
    }

    private void jMenuItemSuspendActionPerformed(ActionEvent evt) {
        this.suspend();
    }

    private void jMenuItemAutoStartActionPerformed(ActionEvent evt) {
        if (this.selectImage()) {
            this.c64.getKeyboard().textTyped("load \"*\",8,1");
            this.c64.getKeyboard().keyTyped("ENTER");
            this.runProgram();
        }
    }

    private void jMenuItemFastAutoStartActionPerformed(ActionEvent evt) {
        if (this.selectImage()) {
            try {
                this.c64.fastLoadFile("*", -1);
                this.runProgram();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, String.valueOf(this.resources.getString("CouldNotLoadFile")) + "'*'!\n" + e, this.resources.getString("CouldNotLoadFile"), 2);
            }
        }
    }

    private void fastAutoStartImage(String imageFilename) {
        try {
            this.attachImage(this.c64.getActiveDrive(), new File(imageFilename).getAbsolutePath());
            this.c64.fastLoadFile("*", -1);
            this.runProgram();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, String.valueOf(this.resources.getString("CouldNotLoadFile")) + "'*'!\n" + e, this.resources.getString("CouldNotLoadFile"), 2);
        }
    }

    private void jCheckBoxMenuItemSelectDriveItemStateChanged(ItemEvent evt) {
        JRadioButtonMenuItem item = (JRadioButtonMenuItem)evt.getItem();
        if (item.isSelected()) {
            this.c64.setActiveDrive(item.getText().charAt(0) - 48);
            boolean hasDisk = this.c64.getDrive(this.c64.getActiveDrive()).getDriveHandler() != null;
            this.jMenuLoadProgram.setEnabled(hasDisk);
        }
        int i = 0;
        while (i < this.jCheckBoxMenuItemSelectedDrives.length) {
            this.jCheckBoxMenuItemSelectedDrives[i].setSelected(i == this.c64.getActiveDrive());
            ++i;
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            imageFilename = args[0];
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                C64Frame me = new C64Frame();
                me.setVisible(true);
                while (!me.c64.isReady()) {
                    System.out.print(".");
                }
                if (!imageFilename.isEmpty()) {
                    me.fastAutoStartImage(imageFilename);
                }
            }
        });
    }

    @Override
    public void update(Object observed, Object arg) {
        if (observed == this.c64.getLogger()) {
            String message = arg.toString();
            if (!message.startsWith("Emulator working at ") || message.indexOf("performance") <= 0) {
                this.jLabelMessages.setText(message);
                if (this.statusMessageTimer != null) {
                    this.statusMessageTimer.cancel();
                }
                this.statusMessageTimer = new Timer();
                this.statusMessageTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        C64Frame.this.jLabelMessages.setText("");
                        C64Frame.this.statusMessageTimer = null;
                    }
                }, 5000L);
            }
        } else if (observed instanceof C1541) {
            if (arg instanceof Integer) {
                this.showDriveIcon((Integer)arg);
            } else if (arg instanceof DriveHandler) {
                try {
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.lastFile));
                    byte[] delta = ((DriveHandler)arg).createDelta(in);
                    if (delta.length > 0) {
                        File deltaFile = EmulatorUtils.saveDeltaFile(this.lastFile.getAbsolutePath(), delta);
                        this.c64.getLogger().info(String.valueOf(this.resources.getString("SavedChangesToFile")) + "'" + deltaFile + "'.");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.c64.getLogger().warning(String.valueOf(this.resources.getString("CouldNotSaveChanges")) + "'" + this.lastFile + "'!");
                }
            } else if (arg instanceof String) {
                this.jLabelTrackSector.setText(arg.toString());
                this.startDriveStateTimer();
            }
        } else if (observed == this.c64) {
            int performance = this.c64.getPerformance();
            Color background = performance >= 120 ? Color.CYAN : (performance >= 90 ? Color.GREEN : (performance >= 80 ? Color.YELLOW : Color.RED));
            String performanceText = "   " + performance + "% ";
            this.jLabelPerformance.setBackground(background);
            this.jLabelPerformance.setText(performanceText.substring(performanceText.length() - 6, performanceText.length()));
        }
    }

    private void startDriveStateTimer() {
        if (this.driveStateTimer != null) {
            this.driveStateTimer.cancel();
        }
        this.driveStateTimer = new Timer();
        this.driveInactiveTask = new TimerTask(){

            @Override
            public void run() {
                C64Frame.this.jLabelTrackSector.setText("");
                C64Frame.this.driveStateTimer = null;
                C64Frame.this.showDriveIcon(null);
            }
        };
        this.driveStateTimer.schedule(this.driveInactiveTask, 1000L);
    }

    protected void showDriveIcon(Integer state) {
        if (this.driveStateTimer == null || !state.equals(this.currentDriveState) || this.driveInactiveTask.scheduledExecutionTime() - new Date().getTime() < 200L) {
            String icon = "/res/swing/LED_" + (C1541.READING == state ? "reading" : (C1541.WRITING == state ? "writing" : "inactive")) + ".gif";
            String tooltip = C1541.READING == state ? this.resources.getString("DriveIsReadingData") : (C1541.WRITING == state ? this.resources.getString("DriveIsWritingData") : this.resources.getString("DriveIsInactive"));
            this.jLabelDrives.setIcon(new ImageIcon(this.getClass().getResource(icon)));
            this.jLabelDrives.setToolTipText(tooltip);
            this.currentDriveState = state;
            this.startDriveStateTimer();
        }
        if (this.automaticTurboMode) {
            if (state != null) {
                if (this.driveStateTimer != null) {
                    this.c64.setThrottlingEnabled(false);
                }
            } else {
                this.c64.setThrottlingEnabled(true);
            }
        }
    }
}

