/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.io;

import de.joergjahnke.common.io.Serializable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SerializationUtils {
    public static void setMarker(DataOutputStream out) throws IOException {
        out.writeInt(Integer.MAX_VALUE);
    }

    public static void verifyMarker(DataInputStream in) throws IOException {
        if (in.readInt() != Integer.MAX_VALUE) {
            throw new IOException("Serialization marked not found!");
        }
    }

    public static void serialize(DataOutputStream out, byte[] data) throws IOException {
        out.writeInt(data.length);
        int i = 0;
        while (i < data.length) {
            out.writeByte(data[i]);
            ++i;
        }
    }

    public static void deserialize(DataInputStream in, byte[] data) throws IOException {
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            data[i] = in.readByte();
            ++i;
        }
    }

    public static void serialize(DataOutputStream out, short[] data) throws IOException {
        out.writeInt(data.length);
        int i = 0;
        while (i < data.length) {
            out.writeShort(data[i]);
            ++i;
        }
    }

    public static void deserialize(DataInputStream in, short[] data) throws IOException {
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            data[i] = in.readShort();
            ++i;
        }
    }

    public static void serialize(DataOutputStream out, int[] data) throws IOException {
        out.writeInt(data.length);
        int i = 0;
        while (i < data.length) {
            out.writeInt(data[i]);
            ++i;
        }
    }

    public static void deserialize(DataInputStream in, int[] data) throws IOException {
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            data[i] = in.readInt();
            ++i;
        }
    }

    public static void serialize(DataOutputStream out, long[] data) throws IOException {
        out.writeInt(data.length);
        int i = 0;
        while (i < data.length) {
            out.writeLong(data[i]);
            ++i;
        }
    }

    public static void deserialize(DataInputStream in, long[] data) throws IOException {
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            data[i] = in.readLong();
            ++i;
        }
    }

    public static void serialize(DataOutputStream out, boolean[] data) throws IOException {
        out.writeInt(data.length);
        int i = 0;
        while (i < data.length) {
            out.writeBoolean(data[i]);
            ++i;
        }
    }

    public static void deserialize(DataInputStream in, boolean[] data) throws IOException {
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            data[i] = in.readBoolean();
            ++i;
        }
    }

    public static void serialize(DataOutputStream out, String[] data) throws IOException {
        out.writeInt(data.length);
        int i = 0;
        while (i < data.length) {
            out.writeUTF(data[i]);
            ++i;
        }
    }

    public static void deserialize(DataInputStream in, String[] data) throws IOException {
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            data[i] = in.readUTF();
            ++i;
        }
    }

    public static void serialize(DataOutputStream out, Serializable[] data) throws IOException {
        out.writeInt(data.length);
        int i = 0;
        while (i < data.length) {
            data[i].serialize(out);
            ++i;
        }
    }

    public static void deserialize(DataInputStream in, Serializable[] data) throws IOException {
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            data[i].deserialize(in);
            ++i;
        }
    }
}

