/*
 * Decompiled with CFR 0.152.
 */
package jgamebase;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import jgamebase.Const;
import jgamebase.db.Db;
import jgamebase.db.model.Item;
import jgamebase.gui.DatabaseSelectionDialog;
import jgamebase.gui.Gui;
import jgamebase.gui.ToolboxGui;
import jgamebase.model.Database;
import jgamebase.model.Databases;
import jgamebase.model.Emulators;
import jgamebase.model.Overlays;
import jgamebase.model.Paths;
import jgamebase.model.Plugins;
import jgamebase.tools.SystemTools;
import jgamebase.tools.TempDir;

public class JGameBase {
    private static Gui gui = null;
    protected static boolean option_help;
    protected static boolean option_usage;
    protected static boolean option_releaseDatabase;
    public static boolean option_debug;
    public static boolean option_dangerous;
    public static boolean nogui;

    static {
        nogui = false;
    }

    protected static String[] parseOptions(String[] args) {
        ArrayList<String> options = new ArrayList<String>(Arrays.asList(args));
        Iterator iter = options.iterator();
        while (iter.hasNext()) {
            String option = (String)iter.next();
            if (!option.startsWith("-")) continue;
            option = option.substring(1).toLowerCase();
            iter.remove();
            if ("?".equals(option) || "h".equalsIgnoreCase(option) || "help".equalsIgnoreCase(option) || "-help".equalsIgnoreCase(option)) {
                option_help = true;
                continue;
            }
            if ("usage".equalsIgnoreCase(option) || "-usage".equalsIgnoreCase(option)) {
                option_usage = true;
                continue;
            }
            if ("releasedb".equalsIgnoreCase(option) || "-releasedb".equalsIgnoreCase(option)) {
                option_releaseDatabase = true;
                continue;
            }
            if ("debug".equalsIgnoreCase(option) || "-debug".equalsIgnoreCase(option)) {
                option_debug = true;
                continue;
            }
            if ("dangerous".equalsIgnoreCase(option) || "-dangerous".equalsIgnoreCase(option)) {
                option_dangerous = true;
                continue;
            }
            JGameBase.displayError("Unknown option '" + option + "'.");
            option_usage = true;
        }
        return options.toArray(new String[options.size()]);
    }

    public static void main(String[] args) {
        try {
            Const.log.info((Object)"jGameBase V0.71-4 (2023-11-24)");
            Const.log.info((Object)"GNU General Public License version 3.");
            Const.log.info((Object)"Copyright \u00a9 2006-2023 by Frank Gerbig.");
            Const.log.info((Object)"Thanks to James Burrows.");
            Const.log.info((Object)"");
            Const.log.info((Object)("Program directory = \"" + Const.GBDIR_RO + "\""));
            Const.log.info((Object)("Database directory = \"" + Const.GBDIR_RW + "\""));
            Const.log.info((Object)("Lock file = \"" + Const.LOCKFILE + "\""));
            Const.log.info((Object)"");
            Const.log.info((Object)("Writing log to \"" + new File(Const.GBDIR_RW, String.valueOf(Const.NAME_JGAMEBASE_LC) + ".log").getAbsolutePath() + "\""));
            Const.log.info((Object)"");
            Gui.setLookAndFeel();
            if (Const.FONT_SIZE_MULTIPLIER > 1.0f) {
                Gui.scaleFontSize(Const.FONT_SIZE_MULTIPLIER);
            }
            if (SystemTools.isOtherInstanceRunning()) {
                Gui.displayErrorDialog("It seems there is already an instance of jGamebase running.\nExiting...");
                System.exit(1);
            }
            args = JGameBase.parseOptions(args);
            if (option_help) {
                JGameBase.displayHelp();
            } else if (option_usage) {
                JGameBase.displayUsage();
            }
            if (option_debug) {
                System.err.println("DEBUG MODE ACTIVATED.");
            }
            if (option_dangerous) {
                System.err.println("DANGEROUS MODE ACTIVATED.");
            }
            if (option_releaseDatabase) {
                System.err.println("DATABASE RELEASE MODE ACTIVATED.");
            }
            System.err.println();
            switch (args.length) {
                case 0: {
                    JGameBase.startup("", "");
                    break;
                }
                case 1: {
                    if ("toolbox".equalsIgnoreCase(args[0])) {
                        Const.log.info((Object)"jToolBox V0.71-4 (2023-11-24)");
                        Const.log.info((Object)"Copyright \u00a9 2006-2023 by Frank Gerbig.");
                        Const.log.info((Object)"");
                        new ToolboxGui();
                        break;
                    }
                    JGameBase.startup(args[0], "");
                    break;
                }
                case 2: {
                    JGameBase.startup(args[0], args[1]);
                    break;
                }
                default: {
                    JGameBase.displayError("Too many arguments.");
                    JGameBase.displayUsage();
                    break;
                }
            }
        }
        catch (Throwable e) {
            SystemTools.handleFatalError(e);
            try {
                Databases.getCurrent().hideSplashscreen();
            }
            catch (RuntimeException runtimeException) {}
            System.exit(1);
        }
    }

    private static void startup(String dbName, String itemId) throws IOException {
        if (!dbName.isEmpty()) {
            Const.log.info((Object)("dbName = " + dbName));
        }
        if (!itemId.isEmpty()) {
            itemId = itemId.toUpperCase();
            Const.log.info((Object)("itemId = " + itemId + " (itemId specified, deactivating GUI)"));
            nogui = true;
        }
        Plugins.initExtractorPlugins();
        Const.log.info((Object)"");
        Databases.init();
        Overlays.init();
        if (Databases.getList().size() == 0) {
            Gui.displayWarningDialog("No database could be found.\nPlease get a (j)GameBase database (e.g. 'C64lite' from '" + Const.URI_DOWNLOAD_JDB + "')\n" + "and extract it into a subdirectory under '" + Const.GBDIR_RW + "'.\n" + "Then start jGamebase again.\n\nYour web browser will now be openend with the download location.");
            if (!nogui) {
                SystemTools.open(Const.URI_DOWNLOAD_JDB);
            }
            JGameBase.quit();
        }
        if (option_releaseDatabase) {
            int i = 1;
            for (Database database : Databases.getList()) {
                System.out.println("\n\n" + i++ + "/" + Databases.getList().size() + ": Preparing database '" + database.getDisplayName() + "' for release:");
                Databases.setCurrent(database);
                System.out.println("  clearing preferences...");
                database.getPreferences().set("about_since", "");
                database.getPreferences().set("about_games_played", 0);
                database.getPreferences().set("about_music_played", 0);
                System.out.println("  reseting usage information...");
                Db.resetGamesPlayedInformation();
                System.out.println("  reorganizing database...");
                Db.reorganize();
                Db.close();
                System.out.println("  closed database'" + database.getDisplayName() + "'.");
            }
            JGameBase.quit();
        }
        Database database = null;
        while (database == null) {
            if (Databases.getList().size() > 1) {
                DatabaseSelectionDialog selectDialog;
                if (!dbName.isEmpty()) {
                    for (Database possibleDatabase : Databases.getList()) {
                        if (!dbName.equalsIgnoreCase(possibleDatabase.getDisplayName()) && !dbName.equalsIgnoreCase(possibleDatabase.getName())) continue;
                        database = possibleDatabase;
                    }
                    if (database == null) {
                        for (Database possibleDatabase : Databases.getList()) {
                            if (!possibleDatabase.getDisplayName().toLowerCase().startsWith(dbName.toLowerCase()) && !possibleDatabase.getName().toLowerCase().startsWith(dbName.toLowerCase())) continue;
                            database = possibleDatabase;
                        }
                    }
                }
                if (database != null) continue;
                if (nogui) {
                    Const.log.error((Object)("Specified database '" + dbName + "' not found.\nExiting..."));
                    JGameBase.quit();
                }
                if ((selectDialog = new DatabaseSelectionDialog((Frame)JGameBase.getGui(), Databases.getList(), false)).getCloseAction() == Const.CloseAction.CANCEL) {
                    Const.log.error((Object)"No database selected.\nExiting...");
                    JGameBase.quit();
                }
                database = (Database)selectDialog.getSelected().get(0);
                continue;
            }
            database = Databases.getList().get(0);
        }
        if (!nogui) {
            database.showSplashscreen();
        }
        Databases.setCurrent(database);
        if (!nogui) {
            int installedOverlayVersion;
            Overlays.findLatestVersion(database);
            int latestOverlayVersion = Overlays.getLatestVersion();
            if (latestOverlayVersion > 0 && latestOverlayVersion > (installedOverlayVersion = database.getPreferences().getInt("overlay_version")) && Gui.displayConfirmationDialog("Newer emulator scripts and configurations were found.\nOverwrite existing scripts and configurations?") == 0) {
                Overlays.installLatestVersion(database);
                database.getPreferences().set("overlay_version", latestOverlayVersion);
            }
        }
        Paths.readFromIniFile();
        Emulators.readFromIniFile();
        Const.log.info((Object)"");
        Plugins.initDiskInfoPlugins();
        Plugins.initMusicInfoPlugins();
        Const.log.info((Object)"");
        if (nogui) {
            if (itemId.matches("^[mMgG]\\d+$")) {
                Item item = null;
                item = Db.getItembyId(itemId);
                if (item != null) {
                    item.play();
                } else {
                    Gui.displayErrorDialog("Item with id '" + itemId + "' not found in database '" + Databases.getCurrent() + "'.\nExiting...");
                }
            } else {
                Gui.displayErrorDialog("Invalid item id '" + itemId + "' specified.\nExiting...");
            }
            JGameBase.quit();
        } else {
            SwingUtilities.invokeLater(() -> {
                gui = new Gui();
                gui.reloadCurrentView();
                Databases.getCurrent().hideSplashscreen();
                gui.setVisible(true);
                gui.initAfterVisible();
            });
        }
    }

    public static void displayHelp() {
        Const.log.info((Object)Const.HELP_MSG);
        Gui.displayHelpDialog();
        System.exit(0);
    }

    public static void displayUsage() {
        Const.log.info((Object)Const.USAGE_MSG);
        Gui.displayUsageDialog();
        System.exit(1);
    }

    public static void displayError(String s) {
        Const.log.error((Object)("ERROR: " + s + "\n"));
        Gui.displayErrorDialog(s);
    }

    public static Gui getGui() {
        return gui;
    }

    public static boolean isGuiInitialized() {
        return gui != null;
    }

    public static void quit() {
        if (JGameBase.isGuiInitialized()) {
            JGameBase.getGui().quit();
        }
        Db.shutdown();
        TempDir.cleanPath();
        Const.log.info((Object)"jGameBase finished.");
        System.exit(0);
    }
}

