/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum Table {
    CONFIG("Config", 2.5),
    CRACKERS("Crackers", 2.5),
    DIFFICULTY("Difficulty", 2.5),
    PGENRES("PGenres", 2.5),
    GENRES("Genres", 2.5),
    LANGUAGES("Languages", 2.5),
    MUSICIANS("Musicians", 2.5),
    PROGRAMMERS("Programmers", 2.5),
    PUBLISHERS("Publishers", 2.5),
    YEARS("Years", 2.5),
    MUSIC("Music", 2.5),
    VIEWDATA("ViewData", 2.5),
    VIEWFILTERS("ViewFilters", 2.5),
    ARTISTS("Artists", 2.6),
    DEVELOPERS("Developers", 2.6),
    LICENSES("Licenses", 2.6),
    RARITIES("Rarities", 2.6),
    GAMES("Games", 2.5),
    EXTRAS("Extras", 2.5);

    private final String name;
    private final double sinceVersion;
    private List<String[]> data;

    public static Table[] getValues(double version) {
        return Table.getValuesAsList(version).toArray(new Table[0]);
    }

    public static List<Table> getValuesAsList() {
        return Arrays.asList(Table.values());
    }

    public static List<Table> getValuesAsList(double version) {
        ArrayList<Table> tables = new ArrayList<Table>();
        int i = 0;
        while (i < Table.values().length) {
            if (Table.valueAt(i).isInVersion(version)) {
                tables.add(Table.valueAt(i));
            }
            ++i;
        }
        return tables;
    }

    public static List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        Table[] tableArray = Table.values();
        int n = tableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Table table = tableArray[n2];
            names.add(table.getName());
            ++n2;
        }
        return names;
    }

    public static List<String> getNames(double version) {
        ArrayList<String> names = new ArrayList<String>();
        Table[] tableArray = Table.values();
        int n = tableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Table table = tableArray[n2];
            if (table.isInVersion(version)) {
                names.add(table.getName());
            }
            ++n2;
        }
        return names;
    }

    public static int size() {
        return Table.values().length;
    }

    public static Table valueAt(int index) {
        return Table.values()[index];
    }

    public static Table getByName(String name) {
        Table[] tableArray = Table.values();
        int n = tableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Table table = tableArray[n2];
            if (table.getName().equalsIgnoreCase(name)) {
                return table;
            }
            ++n2;
        }
        return null;
    }

    public static String nameAt(int index) {
        return Table.values()[index].getName();
    }

    public static int indexOf(Table table) {
        return table.ordinal();
    }

    public static int indexOf(String name) {
        int index = 0;
        Table[] tableArray = Table.values();
        int n = tableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Table header = tableArray[n2];
            if (name.equals(header.getName())) {
                return index;
            }
            ++index;
            ++n2;
        }
        return -1;
    }

    private Table(String name, double sinceVersion) {
        this.name = name;
        this.sinceVersion = sinceVersion;
        this.data = new ArrayList<String[]>();
    }

    public String getName() {
        return this.name;
    }

    public double getSinceVersion() {
        return this.sinceVersion;
    }

    public boolean isInVersion(double version) {
        return this.getSinceVersion() <= version;
    }

    public List<String[]> getData() {
        return this.data;
    }

    public void setData(List<String[]> data) {
        this.data = data;
    }

    public String toString() {
        return this.name;
    }
}

