/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.db;

import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import jgamebase.Const;
import jgamebase.db.Table;

public final class Update {
    private static boolean isError = false;
    private static double currentVersion = 0.0;

    public static boolean updateFrom(File exportDir, double startVersion) {
        isError = false;
        currentVersion = startVersion;
        List<Table> tables = Table.getValuesAsList(startVersion);
        tables = Update.readTables(exportDir, tables);
        while (currentVersion < 2.8 && !isError) {
            tables = Update.updateTablesFrom(tables, currentVersion);
        }
        if (!isError) {
            Update.writeTables(exportDir, tables);
        }
        return isError;
    }

    private static List<Table> updateTablesFrom(List<Table> tables, double startVersion) {
        if (startVersion == 2.5) {
            return Update.update2_5To2_6(tables);
        }
        if (startVersion == 2.6) {
            return Update.update2_6To2_8(tables);
        }
        isError = true;
        return tables;
    }

    private static List<Table> update2_5To2_6(List<Table> tables) {
        Const.log.info((Object)"Updating from 2.5 to 2.6...");
        for (Table table : tables) {
            switch (table) {
                case CONFIG: {
                    table.setData(Update.transformColumns(table.getData(), String.valueOf(2), String.valueOf(6), 2, 3, 4));
                    break;
                }
                case GAMES: {
                    table.setData(Update.transformColumns(table.getData(), 0, 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 29, 31, 32, 33, 34, 35, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 3, 36, 26, 27, 28, 30, "1", "1", "1", "1", "", "", "", "", "2", "2", "2", "0"));
                    break;
                }
                case GENRES: {
                    table.setData(Update.transformColumns(table.getData(), 0, 2, 1));
                    break;
                }
                case MUSICIANS: {
                    table.setData(Update.transformColumns(table.getData(), 0, 4, 1, 2, 3));
                    break;
                }
                case VIEWDATA: {
                    table.setData(Update.transformColumns(table.getData(), 0, 1, 2, 3, 4, 5, 8, 9, 10, ""));
                    break;
                }
                case VIEWFILTERS: {
                    table.setData(Update.transformColumns(table.getData(), 0, "+", 2, 3, 4, 5, 6, 7, 8));
                }
            }
        }
        tables.add(Table.ARTISTS);
        ArrayList<Object> data = new ArrayList<String[]>();
        data.add(new String[]{"1", "(Unknown)"});
        data.add(new String[]{"2", "(None)"});
        Table.ARTISTS.setData(data);
        tables.add(Table.DEVELOPERS);
        data = new ArrayList();
        data.add(new String[]{"1", "(Unknown)"});
        data.add(new String[]{"2", "(None)"});
        Table.DEVELOPERS.setData(data);
        tables.add(Table.LICENSES);
        data = new ArrayList();
        data.add(new String[]{"1", "(Unknown)"});
        data.add(new String[]{"2", "Charityware"});
        data.add(new String[]{"3", "Commercial"});
        data.add(new String[]{"4", "Coverdisk"});
        data.add(new String[]{"5", "Game & Mini Mag"});
        data.add(new String[]{"6", "Giftware"});
        data.add(new String[]{"7", "Hidden Sub Game"});
        data.add(new String[]{"8", "Interpreted"});
        data.add(new String[]{"9", "Licenseware"});
        data.add(new String[]{"10", "Loading Sub Game"});
        data.add(new String[]{"11", "Open Source Conversion"});
        data.add(new String[]{"12", "PD/Freeware"});
        data.add(new String[]{"13", "Promotional"});
        data.add(new String[]{"14", "Reverse Engineered Modification"});
        data.add(new String[]{"15", "ShareWare"});
        Table.LICENSES.setData(data);
        tables.add(Table.RARITIES);
        data = new ArrayList();
        data.add(new String[]{"1", "(Unknown)"});
        data.add(new String[]{"2", "jgamebase.plugins.extractor.sevenzip.Common as mud"});
        data.add(new String[]{"3", "One version common, other versions rare"});
        data.add(new String[]{"4", "Rare"});
        data.add(new String[]{"5", "Extremely Rare"});
        data.add(new String[]{"6", "Finished/reviewed but not found/released"});
        Table.RARITIES.setData(data);
        currentVersion = Double.valueOf("2.6");
        Const.log.info((Object)("Update to " + currentVersion + " successfull.\n"));
        return tables;
    }

    private static List<Table> update2_6To2_8(List<Table> tables) {
        Const.log.info((Object)"Updating from 2.5 to 2.8...");
        for (Table table : tables) {
            switch (table) {
                case CONFIG: {
                    table.setData(Update.transformColumns(table.getData(), "2", "8", 2, 3, 4, "", ""));
                    break;
                }
                case EXTRAS: {
                    table.setData(Update.transformColumns(table.getData(), 0, 1, 2, 3, 4, 5, 6, 7, ""));
                    break;
                }
                case GAMES: {
                    List<String[]> newData = Update.transformColumns(table.getData(), 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, "0");
                    newData = Update.convertBooleanColumnToInteger(newData, 44);
                    newData = Update.convertBooleanColumnToInteger(newData, 45);
                    newData = Update.convertBooleanColumnToInteger(newData, 46);
                    newData = Update.convertBooleanColumnToInteger(newData, 47);
                    table.setData(newData);
                    break;
                }
                case VIEWDATA: {
                    table.setData(Update.transformColumns(table.getData(), 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, "0"));
                    break;
                }
                case VIEWFILTERS: {
                    table.setData(Update.transformColumns(table.getData(), 0, "+", 2, 3, 4, 5, 6, 7, 8));
                }
            }
        }
        currentVersion = Double.valueOf("2.8");
        Const.log.info((Object)("Update to " + currentVersion + " successfull.\n"));
        return tables;
    }

    private static List<Table> readTables(File dir, List<Table> tables) {
        Const.log.info((Object)"Starting loading of files for database...");
        for (Table table : tables) {
            File file = new File(dir, String.valueOf(table.getName()) + ".csv");
            try {
                Const.log.info((Object)("  Loading data from file '" + table.getName() + ".csv'."));
                CSVReader reader = new CSVReader((Reader)new FileReader(file), ',', '\"', '\u0010');
                List data = reader.readAll();
                table.setData(data);
                Const.log.info((Object)("  File '" + table.getName() + ".csv': " + table.getData().size() + " rows loaded.\n"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Const.log.info((Object)"Loading of database files successfully finished.\n");
        return tables;
    }

    private static void writeTables(File dir, List<Table> tables) {
        Const.log.info((Object)"Writing of upgraded files for database...");
        for (Table table : tables) {
            File file = new File(dir, String.valueOf(table.getName()) + ".csv");
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (CSVWriter writer = new CSVWriter((Writer)new FileWriter(file));){
                    Const.log.info((Object)("  Writing data to file '" + table.getName() + ".csv'."));
                    writer.writeAll(table.getData());
                    Const.log.info((Object)("  File '" + table.getName() + ".csv': " + table.getData().size() + " rows written.\n"));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Const.log.info((Object)"Writing of database files successfully finished.");
    }

    public static List<String[]> transformColumns(List<String[]> data, Object ... columnIndices) {
        if (data.size() == 0) {
            return data;
        }
        int i = 0;
        while (i < data.size()) {
            String[] row = data.get(i);
            String[] newRow = new String[columnIndices.length];
            int j = 0;
            while (j < columnIndices.length) {
                String value;
                int column;
                newRow[j] = columnIndices[j] instanceof Integer ? ((column = ((Integer)columnIndices[j]).intValue()) >= 0 ? row[column] : String.valueOf(i)) : ("+".equals(value = columnIndices[j].toString()) ? (row[j].isEmpty() ? "0" : row[j]) : value);
                data.set(i, newRow);
                ++j;
            }
            ++i;
        }
        return data;
    }

    public static List<String[]> convertBooleanColumnToInteger(List<String[]> data, int column) {
        if (data.size() == 0) {
            return data;
        }
        int i = 0;
        while (i < data.size()) {
            String[] row = data.get(i);
            row[column] = row[column].toLowerCase();
            if ("false".equals(row[column])) {
                row[column] = "0";
            } else if ("true".equals(row[column])) {
                row[column] = "1";
            }
            if (!"0".equals(row[column]) && !"1".equals(row[column])) {
                row[column] = "0";
            }
            ++i;
        }
        return data;
    }
}

