/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.db.filter;

import com.healthmarketscience.jackcess.ColumnBuilder;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.util.ImportFilter;
import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

public class DigitAsBoolean_ImportFilter
implements ImportFilter {
    private final int[] columnsToConvert;

    public DigitAsBoolean_ImportFilter(int ... columnsToConvert) {
        this.columnsToConvert = columnsToConvert;
    }

    public List<ColumnBuilder> filterColumns(List<ColumnBuilder> destColumns, ResultSetMetaData srcColumns) throws SQLException, IOException {
        int[] nArray = this.columnsToConvert;
        int n = this.columnsToConvert.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            ColumnBuilder column = destColumns.get(element);
            if (column.getType() != DataType.INT) {
                throw new RuntimeException("Column " + column.getName() + " has data type " + column.getType() + " (should be INT)!");
            }
            column.setType(DataType.BOOLEAN);
            destColumns.set(element, column);
            ++n2;
        }
        return destColumns;
    }

    public Object[] filterRow(Object[] row) throws SQLException, IOException {
        int[] nArray = this.columnsToConvert;
        int n = this.columnsToConvert.length;
        int n2 = 0;
        while (n2 < n) {
            int columnToConvert = nArray[n2];
            if (row[columnToConvert] instanceof Integer) {
                row[columnToConvert] = (Integer)row[columnToConvert] == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            ++n2;
        }
        return row;
    }
}

