/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jgamebase.Const;
import jgamebase.db.Db;
import jgamebase.db.model.Game;
import jgamebase.db.model.Item;
import jgamebase.db.model.ItemViewFilter;
import jgamebase.db.model.Language;
import jgamebase.db.model.Musician;
import jgamebase.db.model.Programmer;
import jgamebase.db.model.Publisher;
import jgamebase.db.model.Selection;
import jgamebase.gui.Gui;
import jgamebase.gui.ListListModel;
import jgamebase.gui.MusicianDialog;

public class GameInfoDialog
extends JDialog {
    private static final long serialVersionUID = 2644364686750465903L;
    List<Item> list;
    Game game;
    boolean isList;
    Publisher publisher;
    Programmer programmer;
    Musician musician;
    Language language;
    private JPanel chooseLanguagePanel;
    private JPanel chooseMusicianPanel;
    private JPanel chooseProgrammerPanel;
    private JPanel choosePublisherPanel;
    private JCheckBox commentCheckbox;
    private JTextField commentTextField;
    private JCheckBox controlCheckbox;
    private JComboBox controlComboBox;
    private JCheckBox genreCheckbox;
    private JComboBox genreComboBox;
    private JLabel jLabel9;
    private JButton languageButton;
    private JCheckBox languageCheckbox;
    private JTextField languageTextField;
    private JList languagesList;
    private JButton musicianButton;
    private JCheckBox musicianCheckbox;
    private JTextField musicianTextField;
    private JList musiciansList;
    private JCheckBox noOfPlayersCheckbox;
    private JTextField noOfPlayersMaxTextField;
    private JTextField noOfPlayersMinTextField;
    private JRadioButton noOfPlayersRadioButton;
    private JRadioButton noOfPlayersRangeRadioButton;
    private JTextField noOfPlayersTextField;
    private JButton programmerButton;
    private JCheckBox programmerCheckbox;
    private JTextField programmerTextField;
    private JList programmersList;
    private JTabbedPane propertiesPane;
    private JButton publisherButton;
    private JCheckBox publisherCheckbox;
    private JTextField publisherTextField;
    private JList publishersList;
    private JCheckBox simultaneousPlayCheckBox;
    private JCheckBox yearCheckbox;
    private JComboBox yearComboBox;

    public GameInfoDialog(Game game) {
        this.isList = false;
        this.game = game;
        this.initComponents();
        this.selectIncludes(true);
        this.propertiesPane.remove(0);
        this.yearComboBox.setModel(new DefaultComboBoxModel<Object>(new ItemViewFilter("Year", 4, 3, 0, "Years", "YE_Id", "", "").getSelections().toArray()));
        int i = 0;
        while (i < this.yearComboBox.getModel().getSize()) {
            if (((Selection)this.yearComboBox.getModel().getElementAt(i)).getValue().equals(String.valueOf(game.getYear().getId()))) {
                this.yearComboBox.setSelectedIndex(i);
            }
            ++i;
        }
        this.genreComboBox.setModel(new DefaultComboBoxModel<Object>(new ItemViewFilter("Genre", 4, 3, 0, "Genres", "GE_Id", "", "").getSelections().toArray()));
        i = 0;
        while (i < this.genreComboBox.getModel().getSize()) {
            if (((Selection)this.genreComboBox.getModel().getElementAt(i)).getValue().equals(String.valueOf(game.getGenre().getId()))) {
                this.genreComboBox.setSelectedIndex(i);
            }
            ++i;
        }
        this.controlComboBox.setModel(new DefaultComboBoxModel<String>(Const.FORDISPLAY_CONTROL));
        this.controlComboBox.setSelectedIndex(game.getControl());
        this.publisher = game.getPublisher();
        this.programmer = game.getProgrammer();
        this.musician = game.getMusician();
        this.language = game.getLanguage();
        this.publisherTextField.setText(this.publisher.getName());
        this.programmerTextField.setText(this.programmer.getName());
        this.musicianTextField.setText(this.musician.getNameForDisplay());
        this.languageTextField.setText(this.language.getName());
        if (game.getPlayersMin() == game.getPlayersMax()) {
            this.noOfPlayersRadioButton.setSelected(true);
            this.noOfPlayersTextField.setEditable(true);
            this.noOfPlayersMinTextField.setEditable(false);
            this.noOfPlayersMaxTextField.setEditable(false);
            this.noOfPlayersTextField.setText(Integer.toString(game.getPlayersMin()));
        } else {
            this.noOfPlayersRangeRadioButton.setSelected(true);
            this.noOfPlayersTextField.setEditable(false);
            this.noOfPlayersMinTextField.setEditable(true);
            this.noOfPlayersMaxTextField.setEditable(true);
            this.noOfPlayersMinTextField.setText(Integer.toString(game.getPlayersMin()));
            this.noOfPlayersMaxTextField.setText(Integer.toString(game.getPlayersMax()));
        }
        this.simultaneousPlayCheckBox.setSelected(game.getIsSimultaneouslyPlayable());
        this.commentTextField.setText(game.getComment());
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public GameInfoDialog(List<Item> list) {
        this.isList = true;
        this.list = list;
        this.initComponents();
        this.selectIncludes(false);
        this.yearComboBox.setModel(new DefaultComboBoxModel<Object>(new ItemViewFilter("Year", 4, 3, 0, "Years", "YE_Id", "", "").getSelections().toArray()));
        this.genreComboBox.setModel(new DefaultComboBoxModel<Object>(new ItemViewFilter("Genre", 4, 3, 0, "Genres", "GE_Id", "", "").getSelections().toArray()));
        this.controlComboBox.setModel(new DefaultComboBoxModel<String>(Const.FORDISPLAY_CONTROL));
        this.publisher = Db.getPublisherById(37);
        this.programmer = Db.getProgrammerById(1);
        this.musician = Db.getMusicianById(38);
        this.language = Db.getLanguageById(1);
        this.publisherTextField.setText("");
        this.programmerTextField.setText("");
        this.musicianTextField.setText("");
        this.languageTextField.setText("");
        if (this.publisher != null) {
            this.publisherTextField.setText(this.publisher.getName());
        }
        if (this.programmer != null) {
            this.programmerTextField.setText(this.programmer.getName());
        }
        if (this.musician != null) {
            this.musicianTextField.setText(this.musician.getNameForDisplay());
        }
        if (this.language != null) {
            this.languageTextField.setText(this.language.getName());
        }
        this.setVisible(true);
    }

    private void initComponents() {
        ButtonGroup noOfPlayersButtonGroup = new ButtonGroup();
        this.choosePublisherPanel = new JPanel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.publishersList = new JList();
        JButton newPublisherButton = new JButton();
        JButton editPublisherButton = new JButton();
        this.chooseProgrammerPanel = new JPanel();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.programmersList = new JList();
        JButton newProgrammerButton = new JButton();
        JButton editProgrammerButton = new JButton();
        this.chooseMusicianPanel = new JPanel();
        JScrollPane jScrollPane3 = new JScrollPane();
        this.musiciansList = new JList();
        JButton newMusicianButton = new JButton();
        JButton editMusicianButton = new JButton();
        this.chooseLanguagePanel = new JPanel();
        JScrollPane jScrollPane4 = new JScrollPane();
        this.languagesList = new JList();
        JButton newLanguageButton = new JButton();
        JButton editLanguageButton = new JButton();
        this.propertiesPane = new JTabbedPane();
        Gui.fixLookAndFeel(this.propertiesPane);
        JPanel includePanel = new JPanel();
        JPanel jPanel1 = new JPanel();
        this.yearCheckbox = new JCheckBox();
        this.genreCheckbox = new JCheckBox();
        this.publisherCheckbox = new JCheckBox();
        this.noOfPlayersCheckbox = new JCheckBox();
        this.programmerCheckbox = new JCheckBox();
        this.controlCheckbox = new JCheckBox();
        this.musicianCheckbox = new JCheckBox();
        this.commentCheckbox = new JCheckBox();
        this.languageCheckbox = new JCheckBox();
        JPanel jPanel2 = new JPanel();
        JButton includeAllButton = new JButton();
        JButton includeNoneButton = new JButton();
        JPanel fieldsPanel = new JPanel();
        JLabel publisherLabel = new JLabel();
        this.yearComboBox = new JComboBox();
        JLabel yearLabel = new JLabel();
        this.publisherTextField = new JTextField();
        this.publisherButton = new JButton();
        this.programmerTextField = new JTextField();
        this.programmerButton = new JButton();
        JLabel programmerLabel = new JLabel();
        JLabel musicianLabel = new JLabel();
        this.musicianTextField = new JTextField();
        this.musicianButton = new JButton();
        JLabel languageLabel = new JLabel();
        this.languageTextField = new JTextField();
        this.languageButton = new JButton();
        JLabel genreLabel = new JLabel();
        this.genreComboBox = new JComboBox();
        JLabel controlLabel = new JLabel();
        this.controlComboBox = new JComboBox();
        JLabel noOfPlayersLabel = new JLabel();
        JPanel jPanel3 = new JPanel();
        this.noOfPlayersRadioButton = new JRadioButton();
        this.noOfPlayersTextField = new JTextField();
        JLabel jLabel11 = new JLabel();
        this.noOfPlayersRangeRadioButton = new JRadioButton();
        this.noOfPlayersMinTextField = new JTextField();
        this.jLabel9 = new JLabel();
        this.noOfPlayersMaxTextField = new JTextField();
        this.simultaneousPlayCheckBox = new JCheckBox();
        JLabel commentLabel = new JLabel();
        this.commentTextField = new JTextField();
        JPanel OkCancelPanel = new JPanel();
        JPanel jPanel9 = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        this.choosePublisherPanel.setBorder(BorderFactory.createTitledBorder("Publishers"));
        this.choosePublisherPanel.setLayout(new GridBagLayout());
        this.publishersList.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.publishersList.setSelectionMode(0);
        jScrollPane1.setViewportView(this.publishersList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 5, 5, 5);
        this.choosePublisherPanel.add((Component)jScrollPane1, gridBagConstraints);
        newPublisherButton.setMnemonic('N');
        newPublisherButton.setText("New");
        newPublisherButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.newPublisherActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 5);
        this.choosePublisherPanel.add((Component)newPublisherButton, gridBagConstraints);
        editPublisherButton.setMnemonic('E');
        editPublisherButton.setText("Edit");
        editPublisherButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.editPublisherActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.choosePublisherPanel.add((Component)editPublisherButton, gridBagConstraints);
        this.chooseProgrammerPanel.setBorder(BorderFactory.createTitledBorder("Programmers"));
        this.chooseProgrammerPanel.setLayout(new GridBagLayout());
        this.programmersList.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.programmersList.setSelectionMode(0);
        jScrollPane2.setViewportView(this.programmersList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 5, 5, 5);
        this.chooseProgrammerPanel.add((Component)jScrollPane2, gridBagConstraints);
        newProgrammerButton.setMnemonic('N');
        newProgrammerButton.setText("New");
        newProgrammerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.newProgrammerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 5);
        this.chooseProgrammerPanel.add((Component)newProgrammerButton, gridBagConstraints);
        editProgrammerButton.setMnemonic('E');
        editProgrammerButton.setText("Edit");
        editProgrammerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.editProgrammerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.chooseProgrammerPanel.add((Component)editProgrammerButton, gridBagConstraints);
        this.chooseMusicianPanel.setBorder(BorderFactory.createTitledBorder("Musicians"));
        this.chooseMusicianPanel.setLayout(new GridBagLayout());
        this.musiciansList.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.musiciansList.setSelectionMode(0);
        jScrollPane3.setViewportView(this.musiciansList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 5, 5, 5);
        this.chooseMusicianPanel.add((Component)jScrollPane3, gridBagConstraints);
        newMusicianButton.setMnemonic('N');
        newMusicianButton.setText("New");
        newMusicianButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.newMusicianActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 5);
        this.chooseMusicianPanel.add((Component)newMusicianButton, gridBagConstraints);
        editMusicianButton.setMnemonic('E');
        editMusicianButton.setText("Edit");
        editMusicianButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.editMusicianActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.chooseMusicianPanel.add((Component)editMusicianButton, gridBagConstraints);
        this.chooseLanguagePanel.setBorder(BorderFactory.createTitledBorder("Languages"));
        this.chooseLanguagePanel.setLayout(new GridBagLayout());
        this.languagesList.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.languagesList.setSelectionMode(0);
        jScrollPane4.setViewportView(this.languagesList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 5, 5, 5);
        this.chooseLanguagePanel.add((Component)jScrollPane4, gridBagConstraints);
        newLanguageButton.setMnemonic('N');
        newLanguageButton.setText("New");
        newLanguageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.newLanguageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 5);
        this.chooseLanguagePanel.add((Component)newLanguageButton, gridBagConstraints);
        editLanguageButton.setMnemonic('E');
        editLanguageButton.setText("Edit");
        editLanguageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.editLanguageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.chooseLanguagePanel.add((Component)editLanguageButton, gridBagConstraints);
        this.setTitle("Game Info Properties...");
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GameInfoDialog.this.exitFormWindowClosing(evt);
            }
        });
        includePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        includePanel.setLayout(new GridLayout(2, 1));
        jPanel1.setBorder(BorderFactory.createTitledBorder("Fields to update"));
        jPanel1.setLayout(new GridLayout(5, 2));
        this.yearCheckbox.setMnemonic('Y');
        this.yearCheckbox.setText("Year");
        this.yearCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.yearCheckbox);
        this.genreCheckbox.setMnemonic('G');
        this.genreCheckbox.setText("Genre");
        this.genreCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.genreCheckbox);
        this.publisherCheckbox.setMnemonic('P');
        this.publisherCheckbox.setText("Publisher");
        this.publisherCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.publisherCheckbox);
        this.noOfPlayersCheckbox.setMnemonic('N');
        this.noOfPlayersCheckbox.setText("Number of Players");
        this.noOfPlayersCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.noOfPlayersCheckbox);
        this.programmerCheckbox.setMnemonic('r');
        this.programmerCheckbox.setText("Programmer");
        this.programmerCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.programmerCheckbox);
        this.controlCheckbox.setMnemonic('t');
        this.controlCheckbox.setText("Control");
        this.controlCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.controlCheckbox);
        this.musicianCheckbox.setMnemonic('M');
        this.musicianCheckbox.setText("Musician");
        this.musicianCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.musicianCheckbox);
        this.commentCheckbox.setMnemonic('e');
        this.commentCheckbox.setText("Comment");
        this.commentCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.commentCheckbox);
        this.languageCheckbox.setMnemonic('L');
        this.languageCheckbox.setText("Language");
        this.languageCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.languageCheckbox);
        includePanel.add(jPanel1);
        jPanel2.setLayout(new FlowLayout(0));
        includeAllButton.setMnemonic('A');
        includeAllButton.setText("Select All");
        includeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.selectAllIncludesActionPerformed(evt);
            }
        });
        jPanel2.add(includeAllButton);
        includeNoneButton.setMnemonic('N');
        includeNoneButton.setText("Select None");
        includeNoneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.selectNoneIncludesActionPerformed(evt);
            }
        });
        jPanel2.add(includeNoneButton);
        includePanel.add(jPanel2);
        this.propertiesPane.addTab("Include", includePanel);
        fieldsPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        fieldsPanel.setLayout(new GridBagLayout());
        publisherLabel.setDisplayedMnemonic('P');
        publisherLabel.setLabelFor(this.publisherButton);
        publisherLabel.setText("Publisher:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 1, 0);
        fieldsPanel.add((Component)publisherLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        fieldsPanel.add((Component)this.yearComboBox, gridBagConstraints);
        yearLabel.setDisplayedMnemonic('Y');
        yearLabel.setLabelFor(this.yearComboBox);
        yearLabel.setText("Year:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 1, 0);
        fieldsPanel.add((Component)yearLabel, gridBagConstraints);
        this.publisherTextField.setEditable(false);
        this.publisherTextField.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        fieldsPanel.add((Component)this.publisherTextField, gridBagConstraints);
        this.publisherButton.setText("...");
        this.publisherButton.setMargin(new Insets(0, 10, 0, 10));
        this.publisherButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.chooseOrEditPublisherActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        fieldsPanel.add((Component)this.publisherButton, gridBagConstraints);
        this.programmerTextField.setEditable(false);
        this.programmerTextField.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        fieldsPanel.add((Component)this.programmerTextField, gridBagConstraints);
        this.programmerButton.setText("...");
        this.programmerButton.setMargin(new Insets(0, 10, 0, 10));
        this.programmerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.chooseOrEditProgrammerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        fieldsPanel.add((Component)this.programmerButton, gridBagConstraints);
        programmerLabel.setDisplayedMnemonic('r');
        programmerLabel.setLabelFor(this.programmerButton);
        programmerLabel.setText("Programmer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 1, 0);
        fieldsPanel.add((Component)programmerLabel, gridBagConstraints);
        musicianLabel.setDisplayedMnemonic('M');
        musicianLabel.setLabelFor(this.musicianButton);
        musicianLabel.setText("Musician:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 1, 0);
        fieldsPanel.add((Component)musicianLabel, gridBagConstraints);
        this.musicianTextField.setEditable(false);
        this.musicianTextField.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        fieldsPanel.add((Component)this.musicianTextField, gridBagConstraints);
        this.musicianButton.setText("...");
        this.musicianButton.setMargin(new Insets(0, 10, 0, 10));
        this.musicianButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.chooseOrEditMusicianActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        fieldsPanel.add((Component)this.musicianButton, gridBagConstraints);
        languageLabel.setDisplayedMnemonic('L');
        languageLabel.setLabelFor(this.languageButton);
        languageLabel.setText("Language:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 1, 0);
        fieldsPanel.add((Component)languageLabel, gridBagConstraints);
        this.languageTextField.setEditable(false);
        this.languageTextField.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        fieldsPanel.add((Component)this.languageTextField, gridBagConstraints);
        this.languageButton.setText("...");
        this.languageButton.setMargin(new Insets(0, 10, 0, 10));
        this.languageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.chooseOrEditLanguageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        fieldsPanel.add((Component)this.languageButton, gridBagConstraints);
        genreLabel.setDisplayedMnemonic('G');
        genreLabel.setLabelFor(this.genreComboBox);
        genreLabel.setText("Genre:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 1, 0);
        fieldsPanel.add((Component)genreLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        fieldsPanel.add((Component)this.genreComboBox, gridBagConstraints);
        controlLabel.setDisplayedMnemonic('t');
        controlLabel.setLabelFor(this.controlComboBox);
        controlLabel.setText("Control:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 1, 0);
        fieldsPanel.add((Component)controlLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        fieldsPanel.add((Component)this.controlComboBox, gridBagConstraints);
        noOfPlayersLabel.setDisplayedMnemonic('N');
        noOfPlayersLabel.setLabelFor(this.noOfPlayersRadioButton);
        noOfPlayersLabel.setText("No. of Players:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 1, 0);
        fieldsPanel.add((Component)noOfPlayersLabel, gridBagConstraints);
        jPanel3.setLayout(new BoxLayout(jPanel3, 2));
        noOfPlayersButtonGroup.add(this.noOfPlayersRadioButton);
        this.noOfPlayersRadioButton.setSelected(true);
        this.noOfPlayersRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.noOfPlayersSingleValueActionPerformed(evt);
            }
        });
        jPanel3.add(this.noOfPlayersRadioButton);
        this.noOfPlayersTextField.setEditable(false);
        this.noOfPlayersTextField.setMinimumSize(new Dimension(20, 19));
        this.noOfPlayersTextField.setPreferredSize(new Dimension(20, 19));
        jPanel3.add(this.noOfPlayersTextField);
        jLabel11.setText("   ");
        jPanel3.add(jLabel11);
        noOfPlayersButtonGroup.add(this.noOfPlayersRangeRadioButton);
        this.noOfPlayersRangeRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.noOfPlayersRangeActionPerformed(evt);
            }
        });
        jPanel3.add(this.noOfPlayersRangeRadioButton);
        this.noOfPlayersMinTextField.setEditable(false);
        this.noOfPlayersMinTextField.setMinimumSize(new Dimension(20, 19));
        this.noOfPlayersMinTextField.setPreferredSize(new Dimension(20, 19));
        jPanel3.add(this.noOfPlayersMinTextField);
        this.jLabel9.setText(" - ");
        this.jLabel9.setFocusable(false);
        jPanel3.add(this.jLabel9);
        this.noOfPlayersMaxTextField.setEditable(false);
        this.noOfPlayersMaxTextField.setMinimumSize(new Dimension(20, 19));
        this.noOfPlayersMaxTextField.setPreferredSize(new Dimension(20, 19));
        jPanel3.add(this.noOfPlayersMaxTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        fieldsPanel.add((Component)jPanel3, gridBagConstraints);
        this.simultaneousPlayCheckBox.setMnemonic('S');
        this.simultaneousPlayCheckBox.setText("Simultaneous Play");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        fieldsPanel.add((Component)this.simultaneousPlayCheckBox, gridBagConstraints);
        commentLabel.setDisplayedMnemonic('e');
        commentLabel.setLabelFor(this.commentTextField);
        commentLabel.setText("Comment:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 1, 0);
        fieldsPanel.add((Component)commentLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        fieldsPanel.add((Component)this.commentTextField, gridBagConstraints);
        this.propertiesPane.addTab("Fields", fieldsPanel);
        this.getContentPane().add((Component)this.propertiesPane, "Center");
        OkCancelPanel.setLayout(new BorderLayout());
        jPanel9.setLayout(new FlowLayout(2));
        okButton.setMnemonic('O');
        okButton.setText("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.okActionPerformed(evt);
            }
        });
        jPanel9.add(okButton);
        cancelButton.setMnemonic('C');
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameInfoDialog.this.cancelActionPerformed(evt);
            }
        });
        jPanel9.add(cancelButton);
        OkCancelPanel.add((Component)jPanel9, "South");
        this.getContentPane().add((Component)OkCancelPanel, "South");
        this.pack();
    }

    private void chooseOrEditLanguageActionPerformed(ActionEvent evt) {
        this.languagesList.setModel(new ListListModel(new ItemViewFilter("Language", 2, 3, 0, "Languages", "LA_Id", "", "").getSelections()));
        int i = 0;
        while (i < this.languagesList.getModel().getSize()) {
            if (((Selection)this.languagesList.getModel().getElementAt(i)).getValue().equals(String.valueOf(this.language.getId()))) {
                this.languagesList.setSelectedIndex(i);
                this.languagesList.ensureIndexIsVisible(i);
            }
            ++i;
        }
        if (JOptionPane.showOptionDialog(this, this.chooseLanguagePanel, "Select Language...", 2, -1, null, null, null) == 0) {
            this.language = Db.getLanguageById(Integer.parseInt(((Selection)this.languagesList.getSelectedValue()).getValue()));
            this.languageTextField.setText(this.language.getName());
        }
    }

    private void chooseOrEditPublisherActionPerformed(ActionEvent evt) {
        this.publishersList.setModel(new ListListModel(new ItemViewFilter("Publisher", 2, 3, 0, "Publishers", "PU_Id", "", "").getSelections()));
        int i = 0;
        while (i < this.publishersList.getModel().getSize()) {
            if (((Selection)this.publishersList.getModel().getElementAt(i)).getValue().equals(String.valueOf(this.publisher.getId()))) {
                this.publishersList.setSelectedIndex(i);
                this.publishersList.ensureIndexIsVisible(i);
            }
            ++i;
        }
        if (JOptionPane.showOptionDialog(this, this.choosePublisherPanel, "Select Publisher...", 2, -1, null, null, null) == 0) {
            this.publisher = Db.getPublisherById(Integer.parseInt(((Selection)this.publishersList.getSelectedValue()).getValue()));
            this.publisherTextField.setText(this.publisher.getName());
        }
    }

    private void editMusicianActionPerformed(ActionEvent evt) {
        Musician newMusician = new MusicianDialog(Db.getMusicianById(Integer.parseInt(((Selection)this.musiciansList.getSelectedValue()).getValue()))).get();
        if (newMusician != null) {
            this.musician = newMusician;
            Db.saveOrUpdate(this.musician);
            this.musiciansList.setModel(new ListListModel(new ItemViewFilter("Musician", 2, 3, 0, "Musicians", "MU_Id", "Musicians", "MU_Id").getSelections()));
            int i = 0;
            while (i < this.musiciansList.getModel().getSize()) {
                if (((Selection)this.musiciansList.getModel().getElementAt(i)).getValue().equals(String.valueOf(this.musician.getId()))) {
                    this.musiciansList.setSelectedIndex(i);
                    this.musiciansList.ensureIndexIsVisible(i);
                }
                ++i;
            }
            this.musicianTextField.setText(this.musician.getName());
        }
    }

    private void newPublisherActionPerformed(ActionEvent evt) {
        String s = (String)JOptionPane.showInputDialog(this, "Name of Publisher", "New Publisher", -1, null, null, null);
        if (s != null && !s.isEmpty()) {
            this.publisher = new Publisher();
            this.publisher.setName(s);
            Db.saveOrUpdate(this.publisher);
            this.publishersList.setModel(new ListListModel(new ItemViewFilter("Publisher", 2, 3, 0, "Publishers", "PU_Id", "", "").getSelections()));
            int i = 0;
            while (i < this.publishersList.getModel().getSize()) {
                if (((Selection)this.publishersList.getModel().getElementAt(i)).getValue().equals(String.valueOf(this.publisher.getId()))) {
                    this.publishersList.setSelectedIndex(i);
                    this.publishersList.ensureIndexIsVisible(i);
                }
                ++i;
            }
            this.publisherTextField.setText(s);
        }
    }

    private void includesChangedActionPerformed(ActionEvent evt) {
        this.includesChanged();
    }

    private void newLanguageActionPerformed(ActionEvent evt) {
        String s = (String)JOptionPane.showInputDialog(this, "Name of Language", "New Language", -1, null, null, null);
        if (s != null && !s.isEmpty()) {
            this.language = new Language();
            this.language.setName(s);
            Db.saveOrUpdate(this.language);
            this.languagesList.setModel(new ListListModel(new ItemViewFilter("Language", 2, 3, 0, "Languages", "LA_Id", "", "").getSelections()));
            int i = 0;
            while (i < this.languagesList.getModel().getSize()) {
                if (((Selection)this.languagesList.getModel().getElementAt(i)).getValue().equals(String.valueOf(this.language.getId()))) {
                    this.languagesList.setSelectedIndex(i);
                    this.languagesList.ensureIndexIsVisible(i);
                }
                ++i;
            }
            this.languageTextField.setText(s);
        }
    }

    private void editProgrammerActionPerformed(ActionEvent evt) {
        Selection current = (Selection)this.programmersList.getSelectedValue();
        String s = (String)JOptionPane.showInputDialog(this, "Name of Programmer", "Edit Programmer", -1, null, null, current.getName());
        if (s != null && !s.isEmpty() && !s.equals(current.toString())) {
            this.programmer = Db.getProgrammerById(Integer.parseInt(current.getValue()));
            this.programmer.setName(s);
            Db.saveOrUpdate(this.programmer);
            this.programmersList.setModel(new ListListModel(new ItemViewFilter("Programmer", 2, 3, 0, "Programmers", "PR_Id", "", "").getSelections()));
            int i = 0;
            while (i < this.programmersList.getModel().getSize()) {
                if (((Selection)this.programmersList.getModel().getElementAt(i)).getValue().equals(String.valueOf(this.programmer.getId()))) {
                    this.programmersList.setSelectedIndex(i);
                    this.programmersList.ensureIndexIsVisible(i);
                }
                ++i;
            }
            this.programmerTextField.setText(s);
        }
    }

    private void newMusicianActionPerformed(ActionEvent evt) {
        Musician newMusician = new MusicianDialog().get();
        if (newMusician != null) {
            this.musician = newMusician;
            Db.saveOrUpdate(this.musician);
            this.musiciansList.setModel(new ListListModel(new ItemViewFilter("Musician", 2, 3, 0, "Musicians", "MU_Id", "Musicians", "MU_Id").getSelections()));
            int i = 0;
            while (i < this.musiciansList.getModel().getSize()) {
                if (((Selection)this.musiciansList.getModel().getElementAt(i)).getValue().equals(String.valueOf(this.musician.getId()))) {
                    this.musiciansList.setSelectedIndex(i);
                    this.musiciansList.ensureIndexIsVisible(i);
                }
                ++i;
            }
            this.musicianTextField.setText(this.musician.getName());
        }
    }

    private void selectNoneIncludesActionPerformed(ActionEvent evt) {
        this.selectIncludes(false);
    }

    private void noOfPlayersSingleValueActionPerformed(ActionEvent evt) {
        this.noOfPlayersTextField.setEditable(true);
        this.noOfPlayersMinTextField.setEditable(false);
        this.noOfPlayersMinTextField.setText("");
        this.noOfPlayersMaxTextField.setEditable(false);
        this.noOfPlayersMaxTextField.setText("");
    }

    private void editPublisherActionPerformed(ActionEvent evt) {
        Selection current = (Selection)this.publishersList.getSelectedValue();
        String s = (String)JOptionPane.showInputDialog(this, "Name of Publisher", "Edit Publisher", -1, null, null, current.getName());
        if (s != null && !s.isEmpty() && !s.equals(current.toString())) {
            this.publisher = Db.getPublisherById(Integer.parseInt(current.getValue()));
            this.publisher.setName(s);
            Db.saveOrUpdate(this.publisher);
            this.publishersList.setModel(new ListListModel(new ItemViewFilter("Publisher", 2, 3, 0, "Publishers", "PU_Id", "", "").getSelections()));
            int i = 0;
            while (i < this.publishersList.getModel().getSize()) {
                if (((Selection)this.publishersList.getModel().getElementAt(i)).getValue().equals(String.valueOf(this.publisher.getId()))) {
                    this.publishersList.setSelectedIndex(i);
                    this.publishersList.ensureIndexIsVisible(i);
                }
                ++i;
            }
            this.publisherTextField.setText(s);
        }
    }

    private void newProgrammerActionPerformed(ActionEvent evt) {
        String s = (String)JOptionPane.showInputDialog(this, "Name of Programmer", "New Programmer", -1, null, null, null);
        if (s != null && !s.isEmpty()) {
            this.programmer = new Programmer();
            this.programmer.setName(s);
            Db.saveOrUpdate(this.programmer);
            this.programmersList.setModel(new ListListModel(new ItemViewFilter("Programmer", 2, 3, 0, "Programmers", "PR_Id", "", "").getSelections()));
            int i = 0;
            while (i < this.programmersList.getModel().getSize()) {
                if (((Selection)this.programmersList.getModel().getElementAt(i)).getValue().equals(String.valueOf(this.programmer.getId()))) {
                    this.programmersList.setSelectedIndex(i);
                    this.programmersList.ensureIndexIsVisible(i);
                }
                ++i;
            }
            this.programmerTextField.setText(s);
        }
    }

    private void chooseOrEditMusicianActionPerformed(ActionEvent evt) {
        this.musiciansList.setModel(new ListListModel(new ItemViewFilter("Musician", 2, 3, 0, "Musicians", "MU_Id", "Musicians", "MU_Id").getSelections()));
        int i = 0;
        while (i < this.musiciansList.getModel().getSize()) {
            if (((Selection)this.musiciansList.getModel().getElementAt(i)).getValue().equals(String.valueOf(this.musician.getId()))) {
                this.musiciansList.setSelectedIndex(i);
                this.musiciansList.ensureIndexIsVisible(i);
            }
            ++i;
        }
        if (JOptionPane.showOptionDialog(this, this.chooseMusicianPanel, "Select Musician...", 2, -1, null, null, null) == 0) {
            this.musician = Db.getMusicianById(Integer.parseInt(((Selection)this.musiciansList.getSelectedValue()).getValue()));
            this.musicianTextField.setText(this.musician.getName());
        }
    }

    private void noOfPlayersRangeActionPerformed(ActionEvent evt) {
        this.noOfPlayersTextField.setEditable(false);
        this.noOfPlayersTextField.setText("");
        this.noOfPlayersMinTextField.setEditable(true);
        this.noOfPlayersMaxTextField.setEditable(true);
    }

    private void chooseOrEditProgrammerActionPerformed(ActionEvent evt) {
        this.programmersList.setModel(new ListListModel(new ItemViewFilter("Programmer", 2, 3, 0, "Programmers", "PR_Id", "", "").getSelections()));
        int i = 0;
        while (i < this.programmersList.getModel().getSize()) {
            if (((Selection)this.programmersList.getModel().getElementAt(i)).getValue().equals(String.valueOf(this.programmer.getId()))) {
                this.programmersList.setSelectedIndex(i);
                this.programmersList.ensureIndexIsVisible(i);
            }
            ++i;
        }
        if (JOptionPane.showOptionDialog(this, this.chooseProgrammerPanel, "Select Programmer...", 2, -1, null, null, null) == 0) {
            this.programmer = Db.getProgrammerById(Integer.parseInt(((Selection)this.programmersList.getSelectedValue()).getValue()));
            this.programmerTextField.setText(this.programmer.getName());
        }
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void selectAllIncludesActionPerformed(ActionEvent evt) {
        this.selectIncludes(true);
    }

    private void editLanguageActionPerformed(ActionEvent evt) {
        Selection current = (Selection)this.languagesList.getSelectedValue();
        String s = (String)JOptionPane.showInputDialog(this, "Name of Language", "Edit Language", -1, null, null, current.getName());
        if (s != null && !s.isEmpty() && !s.equals(current.toString())) {
            this.language = Db.getLanguageById(Integer.parseInt(current.getValue()));
            this.language.setName(s);
            Db.saveOrUpdate(this.language);
            this.languagesList.setModel(new ListListModel(new ItemViewFilter("Language", 2, 3, 0, "Languages", "LA_Id", "", "").getSelections()));
            int i = 0;
            while (i < this.languagesList.getModel().getSize()) {
                if (((Selection)this.languagesList.getModel().getElementAt(i)).getValue().equals(String.valueOf(this.language.getId()))) {
                    this.languagesList.setSelectedIndex(i);
                    this.languagesList.ensureIndexIsVisible(i);
                }
                ++i;
            }
            this.languageTextField.setText(s);
        }
    }

    private void selectIncludes(boolean b) {
        this.yearCheckbox.setSelected(b);
        this.genreCheckbox.setSelected(b);
        this.publisherCheckbox.setSelected(b);
        this.noOfPlayersCheckbox.setSelected(b);
        this.programmerCheckbox.setSelected(b);
        this.controlCheckbox.setSelected(b);
        this.musicianCheckbox.setSelected(b);
        this.commentCheckbox.setSelected(b);
        this.languageCheckbox.setSelected(b);
        this.includesChanged();
    }

    private void includesChanged() {
        this.yearComboBox.setEnabled(this.yearCheckbox.isSelected());
        this.publisherTextField.setEnabled(this.publisherCheckbox.isSelected());
        this.publisherButton.setEnabled(this.publisherCheckbox.isSelected());
        this.publisherTextField.setBackground(Color.BLUE);
        this.publisherTextField.updateUI();
        this.programmerTextField.setEnabled(this.programmerCheckbox.isSelected());
        this.programmerTextField.setBackground(this.programmerCheckbox.isSelected() ? new Color(255, 255, 204) : UIManager.getDefaults().getColor("TextField.inactiveBackground"));
        this.programmerButton.setEnabled(this.programmerCheckbox.isSelected());
        this.musicianTextField.setEnabled(this.musicianCheckbox.isSelected());
        this.musicianTextField.setBackground(this.musicianCheckbox.isSelected() ? new Color(255, 255, 204) : UIManager.getDefaults().getColor("TextField.inactiveBackground"));
        this.musicianButton.setEnabled(this.musicianCheckbox.isSelected());
        this.languageTextField.setEnabled(this.languageCheckbox.isSelected());
        this.languageTextField.setBackground(this.languageCheckbox.isSelected() ? new Color(255, 255, 204) : UIManager.getDefaults().getColor("TextField.inactiveBackground"));
        this.languageButton.setEnabled(this.languageCheckbox.isSelected());
        this.genreComboBox.setEnabled(this.genreCheckbox.isSelected());
        this.controlComboBox.setEnabled(this.controlCheckbox.isSelected());
        this.noOfPlayersRadioButton.setEnabled(this.noOfPlayersCheckbox.isSelected());
        this.noOfPlayersRangeRadioButton.setEnabled(this.noOfPlayersCheckbox.isSelected());
        this.simultaneousPlayCheckBox.setEnabled(this.noOfPlayersCheckbox.isSelected());
        this.noOfPlayersTextField.setEditable(this.noOfPlayersCheckbox.isSelected() && this.noOfPlayersRadioButton.isSelected());
        this.noOfPlayersMinTextField.setEditable(this.noOfPlayersCheckbox.isSelected() && !this.noOfPlayersRadioButton.isSelected());
        this.noOfPlayersMaxTextField.setEditable(this.noOfPlayersCheckbox.isSelected() && !this.noOfPlayersRadioButton.isSelected());
        this.commentTextField.setEditable(this.commentCheckbox.isSelected());
    }

    private void okActionPerformed(ActionEvent evt) {
        if (!this.isList) {
            this.list = new ArrayList<Item>();
            this.list.add(this.game);
        }
        for (Item item : this.list) {
            if (!(item instanceof Game)) continue;
            Game game = (Game)item;
            if (this.yearCheckbox.isSelected()) {
                game.setYear(Db.getYearById(Integer.parseInt(((Selection)this.yearComboBox.getSelectedItem()).getValue())));
            }
            if (this.publisherCheckbox.isSelected()) {
                game.setPublisher(this.publisher);
            }
            if (this.programmerCheckbox.isSelected()) {
                game.setProgrammer(this.programmer);
            }
            if (this.musicianCheckbox.isSelected()) {
                game.setMusician(this.musician);
            }
            if (this.languageCheckbox.isSelected()) {
                game.setLanguage(this.language);
            }
            if (this.genreCheckbox.isSelected()) {
                game.setGenre(Db.getGenreById(Integer.parseInt(((Selection)this.genreComboBox.getSelectedItem()).getValue())));
            }
            if (this.controlCheckbox.isSelected()) {
                game.setControl(this.controlComboBox.getSelectedIndex());
            }
            if (this.noOfPlayersCheckbox.isSelected()) {
                if (this.noOfPlayersRadioButton.isSelected()) {
                    game.setPlayersMin(Integer.parseInt(this.noOfPlayersTextField.getText()));
                    game.setPlayersMax(Integer.parseInt(this.noOfPlayersTextField.getText()));
                } else {
                    game.setPlayersMin(Integer.parseInt(this.noOfPlayersMinTextField.getText()));
                    game.setPlayersMax(Integer.parseInt(this.noOfPlayersMaxTextField.getText()));
                }
                game.setIsSimultaneouslyPlayable(this.simultaneousPlayCheckBox.isSelected());
            }
            if (this.commentCheckbox.isSelected()) {
                game.setComment(this.commentTextField.getText());
            }
            Db.saveOrUpdate(game);
        }
        this.dispose();
    }

    private void exitFormWindowClosing(WindowEvent evt) {
        this.dispose();
    }
}

