/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jgamebase.Const;
import jgamebase.JGameBase;
import jgamebase.gui.Gui;
import jgamebase.gui.ListListMethods;
import jgamebase.gui.ListListModel;
import jgamebase.model.Databases;
import jgamebase.model.Emulator;
import jgamebase.model.FileExtensions;

public class ManageEmulatorsDialog
extends JDialog {
    private static final long serialVersionUID = 2753645443925245053L;
    private Const.CloseAction closeAction = Const.CloseAction.CANCEL;
    private final String type;
    private JPanel editEmulatorPanel;
    private JTextField emulatorCommand;
    private JTextField emulatorConfigurationFile;
    private JTextField emulatorName;
    private JTextField emulatorSupportedExtensions;
    protected JList emulatorsList;

    public ManageEmulatorsDialog(List<Emulator> emulators, String type) {
        this.initComponents();
        this.emulatorsList.setModel(new ListListModel(emulators));
        this.type = type;
        this.setTitle("Manage " + type + " Emulators");
        this.setVisible(true);
    }

    private void initComponents() {
        this.editEmulatorPanel = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.emulatorName = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.emulatorSupportedExtensions = new JTextField();
        JLabel jLabel3 = new JLabel();
        this.emulatorCommand = new JTextField();
        JButton emulatorCommandPathButton = new JButton();
        JLabel jLabel4 = new JLabel();
        this.emulatorConfigurationFile = new JTextField();
        JButton emulatorConfigurationFilePathButton = new JButton();
        JPanel emulatorsPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        JButton addButton = new JButton();
        JButton removeButton = new JButton();
        JButton upButton = new JButton();
        JButton downButton = new JButton();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.emulatorsList = new JList();
        JPanel OkCancelPanel = new JPanel();
        JPanel jPanel9 = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        this.editEmulatorPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.editEmulatorPanel.setLayout(new GridBagLayout());
        jLabel1.setText("Emulator name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.editEmulatorPanel.add((Component)jLabel1, gridBagConstraints);
        this.emulatorName.setToolTipText("The name of the emulator.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.editEmulatorPanel.add((Component)this.emulatorName, gridBagConstraints);
        jLabel2.setText("Supported extensions:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.editEmulatorPanel.add((Component)jLabel2, gridBagConstraints);
        this.emulatorSupportedExtensions.setToolTipText("Enter the supported extensions as list separated by semicolons (e.g. \"d64;t64;prg\").");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.editEmulatorPanel.add((Component)this.emulatorSupportedExtensions, gridBagConstraints);
        jLabel3.setText("Command to execute:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.editEmulatorPanel.add((Component)jLabel3, gridBagConstraints);
        this.emulatorCommand.setToolTipText("The command to execute.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.editEmulatorPanel.add((Component)this.emulatorCommand, gridBagConstraints);
        emulatorCommandPathButton.setText("...");
        emulatorCommandPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setFileSelectionMode(0);
                    if (new File(ManageEmulatorsDialog.this.emulatorCommand.getText()).isAbsolute()) {
                        fileChooser.setCurrentDirectory(new File(ManageEmulatorsDialog.this.emulatorCommand.getText()));
                    } else {
                        fileChooser.setCurrentDirectory(new File(Databases.getCurrent().getPath(), "Scripts"));
                    }
                    if (fileChooser.showOpenDialog(null) == 0) {
                        if (new File(new File(Databases.getCurrent().getPath(), "Scripts"), fileChooser.getSelectedFile().getName()).exists()) {
                            ManageEmulatorsDialog.this.emulatorCommand.setText(fileChooser.getSelectedFile().getName());
                        } else {
                            ManageEmulatorsDialog.this.emulatorCommand.setText(fileChooser.getSelectedFile().getPath());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.editEmulatorPanel.add((Component)emulatorCommandPathButton, gridBagConstraints);
        jLabel4.setText("Configuration file:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.editEmulatorPanel.add((Component)jLabel4, gridBagConstraints);
        this.emulatorConfigurationFile.setToolTipText("The configuration file of this emulator. This is usefull, if the emulator is to be started as a script.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 3, 0);
        this.editEmulatorPanel.add((Component)this.emulatorConfigurationFile, gridBagConstraints);
        emulatorConfigurationFilePathButton.setText("...");
        emulatorConfigurationFilePathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setFileSelectionMode(0);
                    if (new File(ManageEmulatorsDialog.this.emulatorConfigurationFile.getText()).isAbsolute()) {
                        fileChooser.setCurrentDirectory(new File(ManageEmulatorsDialog.this.emulatorConfigurationFile.getText()));
                    } else if (new File(ManageEmulatorsDialog.this.emulatorCommand.getText()).isAbsolute()) {
                        fileChooser.setCurrentDirectory(new File(ManageEmulatorsDialog.this.emulatorCommand.getText()));
                    } else {
                        fileChooser.setCurrentDirectory(new File(Databases.getCurrent().getPath(), "Scripts"));
                    }
                    if (fileChooser.showOpenDialog(null) == 0) {
                        if (new File(new File(Databases.getCurrent().getPath(), "Scripts"), fileChooser.getSelectedFile().getName()).exists()) {
                            ManageEmulatorsDialog.this.emulatorConfigurationFile.setText(fileChooser.getSelectedFile().getName());
                        } else {
                            ManageEmulatorsDialog.this.emulatorConfigurationFile.setText(fileChooser.getSelectedFile().getPath());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.editEmulatorPanel.add((Component)emulatorConfigurationFilePathButton, gridBagConstraints);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ManageEmulatorsDialog.this.exitFormWindowClosing(evt);
            }
        });
        emulatorsPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        emulatorsPanel.setLayout(new BorderLayout());
        buttonPanel.setLayout(new FlowLayout(0));
        addButton.setIcon(Const.ICON_PATHSELECTOR_ADD);
        addButton.setToolTipText("Add a new Emulator");
        addButton.setBorder(null);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageEmulatorsDialog.this.addActionPerformed(evt);
            }
        });
        buttonPanel.add(addButton);
        removeButton.setIcon(Const.ICON_PATHSELECTOR_REMOVE);
        removeButton.setToolTipText("Remove the selected Emulator");
        removeButton.setBorder(null);
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageEmulatorsDialog.this.removeActionPerformed(evt);
            }
        });
        buttonPanel.add(removeButton);
        upButton.setIcon(Const.ICON_PATHSELECTOR_UP);
        upButton.setToolTipText("Move the selected Emulator up");
        upButton.setBorder(null);
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageEmulatorsDialog.this.upActionPerformed(evt);
            }
        });
        buttonPanel.add(upButton);
        downButton.setIcon(Const.ICON_PATHSELECTOR_DOWN);
        downButton.setToolTipText("Move the selected Emulator down");
        downButton.setBorder(null);
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageEmulatorsDialog.this.downActionPerformed(evt);
            }
        });
        buttonPanel.add(downButton);
        emulatorsPanel.add((Component)buttonPanel, "North");
        this.emulatorsList.setSelectionMode(0);
        if (this.emulatorsList.getModel().getSize() > 0) {
            this.emulatorsList.setSelectedIndex(0);
        }
        this.emulatorsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ManageEmulatorsDialog.this.emulatorsListMouseClicked(evt);
            }
        });
        jScrollPane1.setViewportView(this.emulatorsList);
        emulatorsPanel.add((Component)jScrollPane1, "Center");
        this.getContentPane().add((Component)emulatorsPanel, "Center");
        OkCancelPanel.setLayout(new BorderLayout());
        jPanel9.setLayout(new FlowLayout(2));
        okButton.setMnemonic('O');
        okButton.setText("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageEmulatorsDialog.this.okActionPerformed(evt);
            }
        });
        jPanel9.add(okButton);
        cancelButton.setMnemonic('C');
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageEmulatorsDialog.this.cancelActionPerformed(evt);
            }
        });
        jPanel9.add(cancelButton);
        OkCancelPanel.add((Component)jPanel9, "South");
        this.getContentPane().add((Component)OkCancelPanel, "South");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeAction = Const.CloseAction.CANCEL;
        this.dispose();
    }

    private void okActionPerformed(ActionEvent evt) {
        this.closeAction = Const.CloseAction.OK;
        this.dispose();
    }

    private void downActionPerformed(ActionEvent evt) {
        ListListMethods.moveSelectedDown(this.emulatorsList);
    }

    private void upActionPerformed(ActionEvent evt) {
        ListListMethods.moveSelectedUp(this.emulatorsList);
    }

    private void removeActionPerformed(ActionEvent evt) {
        ListListMethods.removeSelected(this.emulatorsList);
    }

    private void emulatorsListMouseClicked(MouseEvent evt) {
        if (Gui.doubleClick(evt)) {
            this.edit();
        }
    }

    private void edit() {
        int row = this.emulatorsList.getSelectedIndex();
        if (row >= 0 && row < this.emulatorsList.getModel().getSize()) {
            Emulator emulator = (Emulator)this.emulatorsList.getSelectedValue();
            this.emulatorName.setText(emulator.getName());
            this.emulatorSupportedExtensions.setText(emulator.getSupportedExtensions().toString());
            this.emulatorCommand.setText(emulator.getCommand());
            this.emulatorConfigurationFile.setText(emulator.getConfigurationFilename());
            if (JOptionPane.showOptionDialog(JGameBase.getGui(), this.editEmulatorPanel, "Edit " + this.type + " Emulator", 2, 3, null, null, null) == 0) {
                String title = this.emulatorName.getText();
                if (title.isEmpty()) {
                    title = "New Emulator";
                }
                emulator.setName(title);
                FileExtensions extensions = new FileExtensions(this.emulatorSupportedExtensions.getText());
                if (extensions.isEmpty()) {
                    extensions.setMatchesAll();
                }
                emulator.setSupportedExtensions(extensions);
                emulator.setCommand(this.emulatorCommand.getText());
                emulator.setConfigurationFilename(this.emulatorConfigurationFile.getText());
            }
        }
    }

    private void addActionPerformed(ActionEvent evt) {
        this.add();
    }

    private void add() {
        this.emulatorName.setText("New Emulator");
        this.emulatorSupportedExtensions.setText("");
        this.emulatorCommand.setText("");
        this.emulatorConfigurationFile.setText("");
        if (JOptionPane.showOptionDialog(JGameBase.getGui(), this.editEmulatorPanel, "Add " + this.type + " Emulator", 2, 3, null, null, null) == 0) {
            Emulator emulator = new Emulator();
            String title = this.emulatorName.getText();
            if (title.isEmpty()) {
                title = "New Emulator";
            }
            emulator.setName(title);
            FileExtensions extensions = new FileExtensions(this.emulatorSupportedExtensions.getText());
            if (extensions.isEmpty()) {
                extensions.setMatchesAll();
            }
            emulator.setSupportedExtensions(extensions);
            emulator.setCommand(this.emulatorCommand.getText());
            emulator.setConfigurationFilename(this.emulatorConfigurationFile.getText());
            ((ListListModel)this.emulatorsList.getModel()).addElement(emulator);
        }
    }

    private void exitFormWindowClosing(WindowEvent evt) {
        this.closeAction = Const.CloseAction.CANCEL;
        this.dispose();
    }

    public Const.CloseAction getCloseAction() {
        return this.closeAction;
    }

    public List<Emulator> getEmulators() {
        return ((ListListModel)this.emulatorsList.getModel()).get();
    }
}

