/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jgamebase.db.model.Musician;
import jgamebase.model.Paths;
import jgamebase.tools.ListerTools;

public class MusicianDialog
extends JDialog {
    private static final long serialVersionUID = -2325513272152901821L;
    Musician musician;
    private JTextField groupTextField;
    private JTextField nameTextField;
    private JTextField nicknameTextField;
    private JComboBox photoComboBox;

    public MusicianDialog(Musician musician) {
        this.musician = musician;
        this.initComponents();
        this.nameTextField.setText(musician.getName());
        this.groupTextField.setText(musician.getGroup());
        this.nicknameTextField.setText(musician.getNickname());
        this.initPhotoComboBox();
        int i = 0;
        while (i < this.photoComboBox.getModel().getSize()) {
            if (this.photoComboBox.getModel().getElementAt(i).equals(musician.getPhotoFilename())) {
                this.photoComboBox.setSelectedIndex(i);
            }
            ++i;
        }
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    public MusicianDialog() {
        this.musician = new Musician();
        this.initComponents();
        this.initPhotoComboBox();
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    public Musician get() {
        this.dispose();
        return this.musician;
    }

    private void initPhotoComboBox() {
        List<File> paths = Paths.getPhotoPath().getWithDefault();
        ArrayList<String> files = new ArrayList<String>();
        for (File path : paths) {
            if (!path.exists()) continue;
            files.addAll(ListerTools.list_Dirs_Files_Paths(path.toString(), false, true, false));
        }
        this.photoComboBox.setModel(new DefaultComboBoxModel<String>(files.toArray(new String[0])));
        this.photoComboBox.setEnabled(!files.isEmpty());
    }

    private void initComponents() {
        JPanel OkCancelPanel = new JPanel();
        JPanel jPanel9 = new JPanel();
        JButton saveButton = new JButton();
        JButton cancelButton = new JButton();
        JPanel fieldsPanel = new JPanel();
        JLabel groupLabel = new JLabel();
        JLabel nicknameLabel = new JLabel();
        JLabel nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.groupTextField = new JTextField();
        this.nicknameTextField = new JTextField();
        JLabel photoLabel = new JLabel();
        this.photoComboBox = new JComboBox();
        this.setTitle("Musician");
        this.setMinimumSize(new Dimension(320, 200));
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MusicianDialog.this.exitFormWindowClosing(evt);
            }
        });
        OkCancelPanel.setLayout(new BorderLayout());
        jPanel9.setLayout(new FlowLayout(2));
        saveButton.setMnemonic('S');
        saveButton.setText("Save");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MusicianDialog.this.okActionPerformed(evt);
            }
        });
        jPanel9.add(saveButton);
        cancelButton.setMnemonic('C');
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MusicianDialog.this.cancelActionPerformed(evt);
            }
        });
        jPanel9.add(cancelButton);
        OkCancelPanel.add((Component)jPanel9, "South");
        this.getContentPane().add((Component)OkCancelPanel, "South");
        fieldsPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        fieldsPanel.setLayout(new GridBagLayout());
        groupLabel.setDisplayedMnemonic('G');
        groupLabel.setLabelFor(this.groupTextField);
        groupLabel.setText("Group:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        fieldsPanel.add((Component)groupLabel, gridBagConstraints);
        nicknameLabel.setDisplayedMnemonic('i');
        nicknameLabel.setLabelFor(this.nicknameTextField);
        nicknameLabel.setText("Nick:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        fieldsPanel.add((Component)nicknameLabel, gridBagConstraints);
        nameLabel.setDisplayedMnemonic('N');
        nameLabel.setLabelFor(this.nameTextField);
        nameLabel.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        fieldsPanel.add((Component)nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        fieldsPanel.add((Component)this.nameTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 5, 3);
        fieldsPanel.add((Component)this.groupTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 3, 5, 0);
        fieldsPanel.add((Component)this.nicknameTextField, gridBagConstraints);
        photoLabel.setDisplayedMnemonic('P');
        photoLabel.setText("Photo:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        fieldsPanel.add((Component)photoLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        fieldsPanel.add((Component)this.photoComboBox, gridBagConstraints);
        this.getContentPane().add((Component)fieldsPanel, "North");
        this.pack();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.musician = null;
        this.setVisible(false);
    }

    private void okActionPerformed(ActionEvent evt) {
        this.musician.setName(this.nameTextField.getText());
        this.musician.setGroup(this.groupTextField.getText());
        this.musician.setNickname(this.nicknameTextField.getText());
        String photoFilename = (String)this.photoComboBox.getSelectedItem();
        if (photoFilename != null && !photoFilename.isEmpty()) {
            this.musician.setPhotoFilename(photoFilename);
        }
        this.setVisible(false);
    }

    private void exitFormWindowClosing(WindowEvent evt) {
        this.musician = null;
        this.setVisible(false);
    }
}

