/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jgamebase.Const;
import jgamebase.gui.Gui;
import jgamebase.model.Databases;

public class OptionsDialog
extends JDialog {
    private static final long serialVersionUID = -4640109064892570658L;
    protected int current_font_size_percent = 100;
    private JCheckBox extraDisplayFilenames;
    private JTextField extraOpenDocumentCmd;
    private JTextField extraOpenImageCmd;
    JSlider fontSizeSlider;
    private JCheckBox gameStopRunning;

    public OptionsDialog() {
        this.initComponents();
        this.current_font_size_percent = Integer.parseInt(Const.global.get("FONT", "PERCENT"));
        this.fontSizeSlider.setValue(this.current_font_size_percent);
        this.gameStopRunning.setSelected(Databases.getCurrent().getPreferences().is("game_stop_running"));
        this.extraOpenDocumentCmd.setText(Databases.getCurrent().getPreferences().get("extra_open_document_cmd"));
        this.extraOpenImageCmd.setText(Databases.getCurrent().getPreferences().get("extra_open_image_cmd"));
        this.extraDisplayFilenames.setSelected(Databases.getCurrent().getPreferences().is("extras_show_filenames"));
        this.setVisible(true);
    }

    private void initComponents() {
        JTabbedPane mainTabbedPane = new JTabbedPane();
        Gui.fixLookAndFeel(mainTabbedPane);
        JPanel generalOptionsPanel = new JPanel();
        JPanel FontSizeOptionsPanel = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.fontSizeSlider = new JSlider();
        JPanel fillPanel = new JPanel();
        JPanel databaseOptionsPanel = new JPanel();
        JPanel GameOptionsPanel = new JPanel();
        this.gameStopRunning = new JCheckBox();
        JPanel ExtraOptionsPanel = new JPanel();
        JLabel extraOpenDocumentCmdLabel = new JLabel();
        this.extraOpenDocumentCmd = new JTextField();
        JLabel extraOpenImageCmdLabel = new JLabel();
        this.extraOpenImageCmd = new JTextField();
        this.extraDisplayFilenames = new JCheckBox();
        JPanel fillPanel1 = new JPanel();
        JPanel OkCancelPanel = new JPanel();
        JPanel jPanel9 = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        this.setTitle("jGameBase Options");
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                OptionsDialog.this.exitFormWindowClosing(evt);
            }
        });
        generalOptionsPanel.setLayout(new BorderLayout());
        FontSizeOptionsPanel.setBorder(BorderFactory.createTitledBorder("Font Options"));
        FontSizeOptionsPanel.setLayout(new BorderLayout());
        jLabel1.setFont(jLabel1.getFont().deriveFont((float)jLabel1.getFont().getSize() + 2.0f));
        jLabel1.setHorizontalAlignment(0);
        jLabel1.setLabelFor(this.fontSizeSlider);
        jLabel1.setText("Font size in percent [%]");
        FontSizeOptionsPanel.add((Component)jLabel1, "North");
        this.fontSizeSlider.setMajorTickSpacing(25);
        this.fontSizeSlider.setMaximum(200);
        this.fontSizeSlider.setMinimum(100);
        this.fontSizeSlider.setMinorTickSpacing(5);
        this.fontSizeSlider.setPaintLabels(true);
        this.fontSizeSlider.setPaintTicks(true);
        this.fontSizeSlider.setSnapToTicks(true);
        this.fontSizeSlider.setToolTipText("Needs restart of application.");
        FontSizeOptionsPanel.add((Component)this.fontSizeSlider, "Center");
        generalOptionsPanel.add((Component)FontSizeOptionsPanel, "North");
        generalOptionsPanel.add((Component)fillPanel, "Center");
        mainTabbedPane.addTab("General", generalOptionsPanel);
        databaseOptionsPanel.setLayout(new BoxLayout(databaseOptionsPanel, 1));
        GameOptionsPanel.setBorder(BorderFactory.createTitledBorder("Game Options"));
        GameOptionsPanel.setToolTipText("<html>\nOptions affecting the infomation displayed.\n</html>");
        GameOptionsPanel.setLayout(new FlowLayout(0));
        this.gameStopRunning.setText("Stop running games when starting a new game");
        this.gameStopRunning.setToolTipText("<html>\nIf this is unchecked multiple games can be running in parallel.\n</html>");
        GameOptionsPanel.add(this.gameStopRunning);
        databaseOptionsPanel.add(GameOptionsPanel);
        ExtraOptionsPanel.setBorder(BorderFactory.createTitledBorder("Extra Options"));
        ExtraOptionsPanel.setToolTipText("<html>\nThe commands used to open specific files, e.g. extras or the html help.<br>\nOn most linux distributions simply use &quot;xdg-open&quot;.\n</html>");
        ExtraOptionsPanel.setLayout(new GridBagLayout());
        extraOpenDocumentCmdLabel.setText("Program to open documents:");
        extraOpenDocumentCmdLabel.setToolTipText("<html>\nThe command used to open documents, e.g. extras or the html help.<br>\nOn most linux distributions simply use &quot;xdg-open&quot;.\n</html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.33;
        gridBagConstraints.insets = new Insets(1, 5, 1, 4);
        ExtraOptionsPanel.add((Component)extraOpenDocumentCmdLabel, gridBagConstraints);
        this.extraOpenDocumentCmd.setToolTipText("<html>\nThe command used to open documents, e.g. extras or the html help.<br>\nOn most linux distributions simply use &quot;xdg-open&quot;.\n</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.33;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        ExtraOptionsPanel.add((Component)this.extraOpenDocumentCmd, gridBagConstraints);
        extraOpenImageCmdLabel.setText("Program to open images:");
        extraOpenImageCmdLabel.setToolTipText("<html>\nThe command used to open pictures, e.g. screenshots or advertisements.<br>\nLeave empty to use internal viewer.<br>\nOn most linux distributions you can use &quot;xdg-open&quot;.\n</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.33;
        gridBagConstraints.insets = new Insets(1, 5, 1, 4);
        ExtraOptionsPanel.add((Component)extraOpenImageCmdLabel, gridBagConstraints);
        this.extraOpenImageCmd.setToolTipText("<html>\nThe command used to open pictures, e.g. screenshots or advertisements.<br>\nLeave empty to use internal viewer.<br>\nOn most linux distributions you can use &quot;xdg-open&quot;.\n</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.33;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        ExtraOptionsPanel.add((Component)this.extraOpenImageCmd, gridBagConstraints);
        this.extraDisplayFilenames.setText("Display file names in tooltips");
        this.extraDisplayFilenames.setToolTipText("<html>\nWhether the tool tip for Extras contains only the name of the Extra or the name and the file name.\n</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weighty = 0.33;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        ExtraOptionsPanel.add((Component)this.extraDisplayFilenames, gridBagConstraints);
        databaseOptionsPanel.add(ExtraOptionsPanel);
        databaseOptionsPanel.add(fillPanel1);
        mainTabbedPane.addTab("Database", databaseOptionsPanel);
        this.getContentPane().add((Component)mainTabbedPane, "Center");
        OkCancelPanel.setLayout(new BorderLayout());
        jPanel9.setLayout(new FlowLayout(2));
        okButton.setMnemonic('O');
        okButton.setText("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.okActionPerformed(evt);
            }
        });
        jPanel9.add(okButton);
        cancelButton.setMnemonic('C');
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.cancelActionPerformed(evt);
            }
        });
        jPanel9.add(cancelButton);
        OkCancelPanel.add((Component)jPanel9, "East");
        this.getContentPane().add((Component)OkCancelPanel, "South");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okActionPerformed(ActionEvent evt) {
        boolean restart_needed = false;
        int new_font_size_percent = this.fontSizeSlider.getValue();
        if (this.current_font_size_percent != new_font_size_percent) {
            try {
                Const.global.set("FONT", "PERCENT", String.valueOf(new_font_size_percent));
                Const.global.save();
                restart_needed = true;
            }
            catch (IOException iOException) {}
        }
        Databases.getCurrent().getPreferences().set("game_stop_running", this.gameStopRunning.isSelected());
        Databases.getCurrent().getPreferences().set("extra_open_document_cmd", this.extraOpenDocumentCmd.getText());
        Databases.getCurrent().getPreferences().set("extra_open_image_cmd", this.extraOpenImageCmd.getText());
        Databases.getCurrent().getPreferences().set("extras_show_filenames", this.extraDisplayFilenames.isSelected());
        if (restart_needed) {
            Gui.displayInformationDialog("You must restart the application for the changes to take effect.");
        }
        this.dispose();
    }

    private void exitFormWindowClosing(WindowEvent evt) {
        this.dispose();
    }
}

