/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import jgamebase.db.Db;
import jgamebase.db.model.Game;

public class SetGameLinkDialog
extends JDialog {
    private static final long serialVersionUID = -8916252578988996460L;
    Game selectedGame;
    Game linkGame;
    private JCheckBox bidirectionalLink;
    private JPanel mainPanel;
    private JRadioButton prequel;
    private JRadioButton related;
    private JRadioButton sequel;

    public SetGameLinkDialog(Game selectedGame, Game linkGame) {
        this.selectedGame = selectedGame;
        this.linkGame = linkGame;
        this.initComponents();
        this.mainPanel.setBorder(new TitledBorder(linkGame.getName()));
        this.prequel.setText("is Precursor to " + selectedGame.getName());
        this.sequel.setText("is Sequel to " + selectedGame.getName());
        this.related.setText("is Related Game to " + selectedGame.getName());
        this.setSize(320, 160);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initComponents() {
        ButtonGroup buttonGroup1 = new ButtonGroup();
        JPanel emulatorsPanel = new JPanel();
        this.mainPanel = new JPanel();
        this.prequel = new JRadioButton();
        this.sequel = new JRadioButton();
        this.related = new JRadioButton();
        JPanel OkCancelPanel = new JPanel();
        JPanel jPanel9 = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        this.bidirectionalLink = new JCheckBox();
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SetGameLinkDialog.this.exitFormWindowClosing(evt);
            }
        });
        emulatorsPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        emulatorsPanel.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new GridLayout(3, 1));
        buttonGroup1.add(this.prequel);
        this.prequel.setMnemonic('P');
        this.prequel.setSelected(true);
        this.mainPanel.add(this.prequel);
        buttonGroup1.add(this.sequel);
        this.sequel.setMnemonic('S');
        this.mainPanel.add(this.sequel);
        buttonGroup1.add(this.related);
        this.related.setMnemonic('R');
        this.mainPanel.add(this.related);
        emulatorsPanel.add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)emulatorsPanel, "Center");
        OkCancelPanel.setLayout(new BorderLayout());
        jPanel9.setLayout(new FlowLayout(2));
        okButton.setMnemonic('O');
        okButton.setText("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetGameLinkDialog.this.okActionPerformed(evt);
            }
        });
        jPanel9.add(okButton);
        cancelButton.setMnemonic('C');
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetGameLinkDialog.this.cancelActionPerformed(evt);
            }
        });
        jPanel9.add(cancelButton);
        OkCancelPanel.add((Component)jPanel9, "East");
        this.bidirectionalLink.setMnemonic('M');
        this.bidirectionalLink.setText("Set bidirectional Link");
        OkCancelPanel.add((Component)this.bidirectionalLink, "West");
        this.getContentPane().add((Component)OkCancelPanel, "South");
        this.pack();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okActionPerformed(ActionEvent evt) {
        if (this.prequel.isSelected()) {
            this.selectedGame.setPrequelId(this.linkGame.getId());
            if (this.bidirectionalLink.isSelected()) {
                this.linkGame.setSequelId(this.selectedGame.getId());
            }
        } else if (this.sequel.isSelected()) {
            this.selectedGame.setSequelId(this.linkGame.getId());
            if (this.bidirectionalLink.isSelected()) {
                this.linkGame.setPrequelId(this.selectedGame.getId());
            }
        } else {
            this.selectedGame.setRelatedId(this.linkGame.getId());
            if (this.bidirectionalLink.isSelected()) {
                this.linkGame.setRelatedId(this.selectedGame.getId());
            }
        }
        this.dispose();
        Db.saveOrUpdate(this.selectedGame);
        Db.saveOrUpdate(this.linkGame);
    }

    private void exitFormWindowClosing(WindowEvent evt) {
        this.dispose();
    }
}

