/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jgamebase.Const;
import jgamebase.db.model.Extra;

public class UrlDialog
extends JDialog {
    private Const.CloseAction closeAction = Const.CloseAction.CANCEL;
    private JComboBox categoryCombobox;
    private JPanel mainPanel;
    private JTextField urlTextField;

    public UrlDialog() {
        this(Extra.Category.values()[0].getDir(), "");
    }

    public UrlDialog(String categoryDir, String url) {
        this.initComponents();
        this.setSize(640, 140);
        this.setMinimumSize(new Dimension(320, 140));
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 140));
        this.categoryCombobox.setSelectedItem(categoryDir);
        this.urlTextField.setText(url);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initComponents() {
        JPanel emulatorsPanel = new JPanel();
        this.mainPanel = new JPanel();
        JLabel categoryLabel = new JLabel();
        this.categoryCombobox = new JComboBox();
        JLabel urlLabel = new JLabel();
        this.urlTextField = new JTextField();
        JPanel OkCancelPanel = new JPanel();
        JPanel jPanel9 = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                UrlDialog.this.exitFormWindowClosing(evt);
            }
        });
        emulatorsPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        emulatorsPanel.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        categoryLabel.setText("Category:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        this.mainPanel.add((Component)categoryLabel, gridBagConstraints);
        this.categoryCombobox.setModel(new DefaultComboBoxModel<String>(Const.ADDEXTRAS_SUBDIRS));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.mainPanel.add((Component)this.categoryCombobox, gridBagConstraints);
        urlLabel.setText("URL:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.mainPanel.add((Component)urlLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.urlTextField, gridBagConstraints);
        emulatorsPanel.add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)emulatorsPanel, "Center");
        OkCancelPanel.setLayout(new BorderLayout());
        jPanel9.setLayout(new FlowLayout(2));
        okButton.setMnemonic('O');
        okButton.setText("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UrlDialog.this.okActionPerformed(evt);
            }
        });
        jPanel9.add(okButton);
        cancelButton.setMnemonic('C');
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UrlDialog.this.cancelActionPerformed(evt);
            }
        });
        jPanel9.add(cancelButton);
        OkCancelPanel.add((Component)jPanel9, "East");
        this.getContentPane().add((Component)OkCancelPanel, "South");
        this.setSize(new Dimension(650, 150));
        this.setLocationRelativeTo(null);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeAction = Const.CloseAction.CANCEL;
        this.setVisible(false);
    }

    private void okActionPerformed(ActionEvent evt) {
        this.closeAction = Const.CloseAction.OK;
        this.setVisible(false);
    }

    private void exitFormWindowClosing(WindowEvent evt) {
        this.closeAction = Const.CloseAction.CANCEL;
        this.setVisible(false);
    }

    public Const.CloseAction getCloseAction() {
        return this.closeAction;
    }

    public String getCategoryDir() {
        return (String)this.categoryCombobox.getSelectedItem();
    }

    public String getUrl() {
        return this.urlTextField.getText();
    }
}

