/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui.widgets;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import jgamebase.Const;
import jgamebase.gui.Gui;
import jgamebase.model.Databases;
import jgamebase.tools.FileTools;

public class JScalingAnimation
extends JComponent {
    private static final long serialVersionUID = 1L;
    Image image;
    float aspect;
    int width = -1;

    public JScalingAnimation(final String filename, String tooltip) throws Exception {
        if (filename == null) {
            throw new NullPointerException("Filename must not be null!");
        }
        if (filename.isEmpty()) {
            throw new IllegalArgumentException("Filename must not be empty!");
        }
        if (!new File(filename).exists()) {
            throw new FileNotFoundException(filename);
        }
        String ext = FileTools.getExtension(filename);
        if (ext == null || ext.isEmpty()) {
            throw new IOException("Could not determine extension of filename '" + filename + "'");
        }
        this.image = new ImageIcon(filename).getImage();
        this.aspect = (float)this.image.getHeight(this) / (float)this.image.getWidth(this);
        this.setToolTipText(tooltip);
        this.setAlignmentX(0.0f);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (JScalingAnimation.this.image == null) {
                    return;
                }
                String externalViewerCommand = Databases.getCurrent().getPreferences().get("extra_open_image_cmd");
                boolean cantUseInternalViewer = false;
                if (externalViewerCommand.isEmpty()) {
                    cantUseInternalViewer = true;
                } else {
                    Object[] command = new String[]{externalViewerCommand, filename};
                    Const.log.info((Object)("Executing viewer: " + Arrays.toString(command)));
                    try {
                        ProcessBuilder builder = new ProcessBuilder((String[])command);
                        builder.start();
                    }
                    catch (IOException iOException) {
                        Const.log.info((Object)("Warning: error while executing command '" + Arrays.toString(command) + "'."));
                        cantUseInternalViewer = true;
                    }
                }
                if (cantUseInternalViewer) {
                    Gui.displayWarningDialog("Could not open picture viewer '" + externalViewerCommand + "'.\n" + "Please configure the picture viewer (Menu 'Tools => Options...').");
                }
            }
        });
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        this.calculateWidth();
        return super.imageUpdate(img, infoflags, x, y, w, h);
    }

    @Override
    public void paint(Graphics g) {
        this.calculateWidth();
        this.revalidate();
        g.drawImage(this.image, 0, 0, this.width, (int)((float)this.width * this.aspect), this);
    }

    private void calculateWidth() {
        if (this.getParent() != null && this.getParent().getParent() != null && this.getParent().getParent().getWidth() != this.width) {
            this.width = this.getParent().getParent().getWidth();
            Dimension d = new Dimension(this.width, (int)((float)this.width * this.aspect));
            this.setSize(d);
            this.setPreferredSize(d);
            this.setMinimumSize(d);
            this.setMaximumSize(d);
        }
    }
}

