/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.stream.Collectors;
import jgamebase.model.Paths;

public class FileExtensions
extends TreeSet<String> {
    private static final long serialVersionUID = 7817389464880291560L;
    private static final String DELIMITER = ";";
    private static final String MATCHES_ALL = "*";

    public FileExtensions() {
    }

    public FileExtensions(String extensionsAsString) {
        this();
        this.fromString(extensionsAsString);
    }

    public void fromString(String extensionsAsString) {
        extensionsAsString = extensionsAsString == null ? "" : extensionsAsString.toLowerCase();
        boolean starFound = false;
        super.clear();
        StringTokenizer st = new StringTokenizer(extensionsAsString, DELIMITER);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(MATCHES_ALL)) {
                starFound = true;
            }
            if (token.startsWith(MATCHES_ALL)) {
                token = token.substring(1);
            }
            if (token.startsWith(".")) {
                token = token.substring(1);
            }
            if (token.isEmpty()) continue;
            super.add(token);
        }
        if (starFound) {
            this.setMatchesAll();
        }
    }

    @Override
    public boolean add(FileExtensions e) {
        if (!this.matchesAll()) {
            if (e.matchesAll()) {
                this.setMatchesAll();
            } else {
                super.addAll(e);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean add(String otherExtensionsAsString) {
        if (new FileExtensions(otherExtensionsAsString).isEmpty()) {
            return false;
        }
        FileExtensions e = new FileExtensions(String.valueOf(this.toString()) + DELIMITER + otherExtensionsAsString);
        super.clear();
        super.addAll(e);
        return true;
    }

    public void setMatchesAll() {
        super.clear();
        super.add(MATCHES_ALL);
    }

    public boolean matchesAll() {
        return this.toString().equals(MATCHES_ALL);
    }

    public boolean matches(File file) {
        if (file == null) {
            throw new NullPointerException("File may not be null");
        }
        return this.matches(file.getName());
    }

    public boolean matchesAsPrefix(File file) {
        if (file == null) {
            throw new NullPointerException("File may not be null");
        }
        return this.matchesAsPrefix(file.getName());
    }

    public boolean matches(String filename) {
        if (this.matchesAll()) {
            return true;
        }
        boolean matches = false;
        Iterator iter = super.iterator();
        while (iter.hasNext()) {
            String extension = (String)iter.next();
            if (!filename.toLowerCase().endsWith("." + extension.toLowerCase())) continue;
            matches = true;
        }
        return matches;
    }

    public boolean matchesAsPrefix(String filename) {
        if (this.matchesAll()) {
            return true;
        }
        boolean matches = false;
        Iterator iter = super.iterator();
        while (iter.hasNext()) {
            String extension = (String)iter.next();
            if (!Paths.removePath(filename).toLowerCase().startsWith(String.valueOf(extension.toLowerCase()) + ".")) continue;
            matches = true;
        }
        return matches;
    }

    public List<String> getMatching(List<String> filenames) {
        ArrayList<String> matchingFilenames = new ArrayList<String>();
        matchingFilenames.addAll(filenames.stream().filter(this::matches).collect(Collectors.toList()));
        return matchingFilenames;
    }

    public List<String> getMatchingAsPrefix(List<String> filenames) {
        ArrayList<String> matchingFilenames = new ArrayList<String>();
        matchingFilenames.addAll(filenames.stream().filter(this::matchesAsPrefix).collect(Collectors.toList()));
        return matchingFilenames;
    }

    @Override
    public boolean contains(Object o) {
        if (this.matchesAll()) {
            return true;
        }
        if (!(o instanceof String)) {
            throw new IllegalArgumentException("FileExceptions can only be of type String ");
        }
        Iterator e = new FileExtensions((String)o).iterator();
        while (e.hasNext()) {
            String next = ((String)e.next()).toLowerCase();
            if (super.contains(next) && !next.equals(MATCHES_ALL)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder extensionsString = new StringBuilder();
        Iterator iter = super.iterator();
        while (iter.hasNext()) {
            extensionsString.append((String)iter.next());
            if (!iter.hasNext()) continue;
            extensionsString.append(DELIMITER);
        }
        return extensionsString.toString();
    }
}

