/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.plugins.diskinfo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jgamebase.Const;
import jgamebase.plugins.DiskInfo;

public class D64
implements DiskInfo {
    private static final String[] supportedExtensions = new String[]{"d64"};
    private static final int[] trackOffset;
    private static final int[] cbmToAscii;
    private static final int lastTrack = 35;
    private byte[] cbmDisk;
    private String header;
    private String footer;
    private List<CbmFile> cbmFiles;

    static {
        int[] nArray = new int[41];
        nArray[2] = 5376;
        nArray[3] = 10752;
        nArray[4] = 16128;
        nArray[5] = 21504;
        nArray[6] = 26880;
        nArray[7] = 32256;
        nArray[8] = 37632;
        nArray[9] = 43008;
        nArray[10] = 48384;
        nArray[11] = 53760;
        nArray[12] = 59136;
        nArray[13] = 64512;
        nArray[14] = 69888;
        nArray[15] = 75264;
        nArray[16] = 80640;
        nArray[17] = 86016;
        nArray[18] = 91392;
        nArray[19] = 96256;
        nArray[20] = 101120;
        nArray[21] = 105984;
        nArray[22] = 110848;
        nArray[23] = 115712;
        nArray[24] = 120576;
        nArray[25] = 125440;
        nArray[26] = 130048;
        nArray[27] = 134656;
        nArray[28] = 139264;
        nArray[29] = 143872;
        nArray[30] = 148480;
        nArray[31] = 153088;
        nArray[32] = 157440;
        nArray[33] = 161792;
        nArray[34] = 166144;
        nArray[35] = 170496;
        nArray[36] = 174848;
        nArray[37] = 179200;
        nArray[38] = 183552;
        nArray[39] = 187904;
        nArray[40] = 192256;
        trackOffset = nArray;
        cbmToAscii = new int[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 32, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 126};
    }

    public D64() {
        Const.log.info((Object)"Loaded plugin: disk info 'D64'.");
    }

    @Override
    public void load(String filename) throws IOException {
        File file = new File(filename);
        int filesize = (int)file.length();
        this.cbmDisk = new byte[filesize];
        this.header = "";
        this.footer = "";
        this.cbmFiles = new ArrayList<CbmFile>();
        if (!file.exists()) {
            throw new FileNotFoundException(filename);
        }
        FileInputStream input = new FileInputStream(filename);
        input.read(this.cbmDisk);
        input.close();
        int track = 18;
        int sector = 1;
        StringBuilder headerSb = new StringBuilder("0 \"");
        int i = 0;
        while (i <= 15) {
            headerSb.append(Character.valueOf((char)cbmToAscii[this.getCbmDiskValue(trackOffset[track] + 144 + i)]));
            ++i;
        }
        headerSb.append("\" ");
        i = 0;
        while (i <= 4) {
            headerSb.append(Character.valueOf((char)cbmToAscii[this.getCbmDiskValue(trackOffset[track] + 162 + i)]));
            ++i;
        }
        this.header = headerSb.toString();
        int blocksFree = 0;
        int i2 = 1;
        while (i2 <= 35) {
            if (i2 != 18) {
                blocksFree += (byte)this.getCbmDiskValue(trackOffset[18] + i2 * 4);
            }
            ++i2;
        }
        this.footer = String.valueOf(blocksFree) + " BLOCKS FREE.";
        do {
            i2 = 0;
            while (i2 <= 7) {
                CbmFile cbmFile = this.readDirectoryEntry(trackOffset[track] + 256 * sector + i2 * 32);
                if (!cbmFile.isScratched()) {
                    this.cbmFiles.add(cbmFile);
                }
                ++i2;
            }
            track = this.getCbmDiskValue(trackOffset[track] + 256 * sector + 0);
            sector = this.getCbmDiskValue(trackOffset[track] + 256 * sector + 1);
        } while (track != 0);
    }

    @Override
    public String[] getSupportedExtensions() {
        return supportedExtensions;
    }

    @Override
    public boolean supportsExtension(String extensionToFind) {
        extensionToFind = extensionToFind.toLowerCase();
        String[] stringArray = supportedExtensions;
        int n = supportedExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String supportedExtension = stringArray[n2];
            String extension = supportedExtension.toLowerCase();
            if (extension.equals(extensionToFind)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private CbmFile readDirectoryEntry(int dataPosition) {
        CbmFile file = new CbmFile();
        file.setScratched(this.getCbmDiskValue(dataPosition + 2) == 0);
        file.setType(this.getCbmDiskValue(dataPosition + 2) & 7);
        file.setLocked((this.getCbmDiskValue(dataPosition + 2) & 0x40) != 0);
        file.setClosed((this.getCbmDiskValue(dataPosition + 2) & 0x80) != 0);
        int position = 0;
        while (position <= 15) {
            if (this.getCbmDiskValue(dataPosition + 5 + position) != 160) {
                file.setNativeName(String.valueOf(file.getNativeName()) + (char)this.getCbmDiskValue(dataPosition + 5 + position));
                file.setName(String.valueOf(file.getName()) + (char)cbmToAscii[this.getCbmDiskValue(dataPosition + 5 + position)]);
            }
            ++position;
        }
        String nativeName = file.getNativeName().toLowerCase();
        nativeName = this.replaceAll(nativeName, '[', '{');
        nativeName = this.replaceAll(nativeName, ']', '}');
        file.setNativeName(nativeName);
        file.setSize((char)(this.getCbmDiskValue(dataPosition + 30) + this.getCbmDiskValue(dataPosition + 31) * 256));
        return file;
    }

    private String replaceAll(String s, char what, char withWhat) {
        while (s.indexOf(what) != -1) {
            s = s.replace(what, withWhat);
        }
        return s;
    }

    private int getCbmDiskValue(int position) {
        return this.cbmDisk[position] & 0xFF;
    }

    @Override
    public String[] getDirectory() {
        String[] entries = new String[this.cbmFiles.size()];
        int i = 0;
        for (CbmFile cbmFile : this.cbmFiles) {
            entries[i++] = cbmFile.toString();
        }
        return entries;
    }

    @Override
    public String getFilenameAt(int pos) {
        return this.cbmFiles.get(pos).getName();
    }

    @Override
    public String getNativeFilenameAt(int pos) {
        return this.cbmFiles.get(pos).getNativeName();
    }

    @Override
    public String getHeader() {
        return this.header;
    }

    @Override
    public String getFooter() {
        return this.footer;
    }

    @Override
    public boolean isBootable() {
        return false;
    }

    static class CbmFile {
        private boolean scratched = true;
        private int type = 0;
        private boolean locked = false;
        private boolean closed = false;
        private String name = "";
        private String nativeName = "";
        private int size = 0;
        private final String[] types = new String[]{"DEL", "SEQ", "PRG", "USR", "REL"};

        public boolean isClosed() {
            return this.closed;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public boolean isScratched() {
            return this.scratched;
        }

        public int getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getNativeName() {
            return this.nativeName;
        }

        public void setClosed(boolean b) {
            this.closed = b;
        }

        public void setLocked(boolean b) {
            this.locked = b;
        }

        public void setScratched(boolean b) {
            this.scratched = b;
        }

        public void setType(int b) {
            this.type = b;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setNativeName(String string) {
            this.nativeName = string;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int i) {
            this.size = i;
        }

        public String getFileType(int type) {
            return this.types[type];
        }

        public String toString() {
            String flags = "";
            flags = String.valueOf(flags) + (this.isLocked() ? "<" : "");
            flags = String.valueOf(flags) + (this.isClosed() ? "" : "*");
            Object[] param = new Object[]{this.size, "\"" + this.name + "\"", String.valueOf(this.types[this.type]) + flags};
            return String.format("%1$-4s %2$-18s %3$s", param);
        }
    }
}

