/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jgamebase.Const;

public class IniFileManager {
    private static final Line BLANK_LINE = new Line(){

        @Override
        public String toString() {
            return "";
        }
    };
    private final File file;
    private final Map<String, Section> sections;
    private final List<String> sectionOrder;
    private OptionFormat optionFormat;

    public IniFileManager(File file) throws IOException {
        this.file = file;
        this.sections = new HashMap<String, Section>();
        this.sectionOrder = new LinkedList<String>();
        this.optionFormat = new OptionFormat("%s%s%s");
        if (file.exists()) {
            this.load();
        } else {
            file.createNewFile();
        }
    }

    public IniFileManager(String filename) throws IOException {
        this(new File(filename));
    }

    public void setOptionFormatString(String formatString) {
        this.optionFormat = new OptionFormat(formatString);
    }

    public String get(String section, String option) {
        Section sect;
        if (this.hasSection(section) && (sect = this.getSection(section)).hasOption(option)) {
            return sect.get(option);
        }
        return null;
    }

    public void set(String section, String option, String value) {
        if (!this.hasSection(section)) {
            this.addSection(section);
        }
        this.getSection(section).set(option, value);
    }

    public boolean remove(String section, String option) {
        if (this.hasSection(section)) {
            return this.getSection(section).remove(option);
        }
        throw new NoSuchSectionException(section);
    }

    public boolean hasOption(String section, String option) {
        return this.hasSection(section) && this.getSection(section).hasOption(option);
    }

    public boolean hasSection(String name) {
        return this.sections.containsKey(this.normSection(name));
    }

    public boolean addSection(String name) {
        String normName = this.normSection(name);
        if (!this.hasSection(normName)) {
            Section section = new Section(normName);
            section.setOptionFormat(this.optionFormat);
            this.sections.put(normName, section);
            this.sectionOrder.add(normName);
            return true;
        }
        return false;
    }

    public boolean removeSection(String name) {
        String normName = this.normSection(name);
        if (this.hasSection(normName)) {
            this.sections.remove(normName);
            this.sectionOrder.remove(normName);
            return true;
        }
        return false;
    }

    public void removeAllSections() {
        List<String> sectionNames = this.getSectionNames();
        sectionNames.forEach(this::removeSection);
    }

    public boolean clearSection(String section) {
        String normSection = this.normSection(section);
        if (this.hasSection(normSection)) {
            this.getSection(normSection).clear();
            return true;
        }
        return false;
    }

    public void setList(String section, List<String> values) {
        if (!this.hasSection(section)) {
            this.addSection(section);
        }
        this.getSection(section).clear();
        int i = 0;
        for (String value : values) {
            this.getSection(section).set(Integer.toString(i + 1), value.toString());
            ++i;
        }
    }

    public List<String> getList(String section) {
        ArrayList<String> values = new ArrayList<String>();
        if (this.hasSection(section)) {
            int i = 1;
            while (this.get(section, Integer.toString(i)) != null) {
                String value = this.get(section, Integer.toString(i));
                if (!value.isEmpty()) {
                    values.add(value);
                }
                ++i;
            }
        }
        return values;
    }

    public List<String> getSectionNames() {
        return new ArrayList<String>(this.sectionOrder);
    }

    public List<String> optionNames(String section) {
        if (this.hasSection(section)) {
            return this.getSection(section).optionNames();
        }
        throw new NoSuchSectionException(section);
    }

    public void addComment(String section, String comment) {
        if (!this.hasSection(section)) {
            throw new NoSuchSectionException(section);
        }
        this.getSection(section).addComment(comment);
    }

    public void save() throws IOException {
        FileOutputStream out = new FileOutputStream(this.file);
        PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(out), true);
        for (String aSectionOrder : this.sectionOrder) {
            Section sect = this.getSection(aSectionOrder);
            writer.println(sect.header());
            sect.save(writer);
        }
        ((OutputStream)out).close();
    }

    private void load() throws IOException {
        FileInputStream in = new FileInputStream(this.file);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String curSection = null;
        String line = null;
        while (reader.ready()) {
            int endIndex;
            line = reader.readLine();
            if (line == null) continue;
            if ((line = line.trim()).length() > 0 && line.charAt(0) == '[' && (endIndex = line.indexOf(93)) >= 0) {
                curSection = line.substring(1, endIndex);
                this.addSection(curSection);
            }
            if (curSection == null) continue;
            Section sect = this.getSection(curSection);
            sect.load(reader);
        }
        ((InputStream)in).close();
    }

    private Section getSection(String name) {
        return this.sections.get(this.normSection(name));
    }

    private String normSection(String name) {
        return name.trim();
    }

    private static class Comment
    implements Line {
        private final String comment;
        private final char delimiter;

        public Comment(String comment, char delimiter) {
            this.comment = comment.trim();
            this.delimiter = delimiter;
        }

        @Override
        public String toString() {
            return String.valueOf(this.delimiter) + " " + this.comment;
        }
    }

    private static interface Line {
        public String toString();
    }

    public static class NoSuchSectionException
    extends RuntimeException {
        private static final long serialVersionUID = -3010340995171651162L;

        public NoSuchSectionException() {
        }

        public NoSuchSectionException(String msg) {
            super(msg);
        }
    }

    private static class Option
    implements Line {
        private static final String ILLEGAL_VALUE_CHARS = "\n\r";
        private final String name;
        private String value;
        private final char separator;
        private final OptionFormat format;

        public Option(String name, String value, char separator, OptionFormat format) {
            if (!Option.validName(name, separator)) {
                throw new IllegalArgumentException("Illegal option name:" + name);
            }
            this.name = name;
            this.separator = separator;
            this.format = format;
            this.set(value);
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public void set(String value) {
            if (value == null) {
                this.value = "";
            } else {
                StringTokenizer st = new StringTokenizer(value.trim(), ILLEGAL_VALUE_CHARS);
                StringBuilder sb = new StringBuilder();
                while (st.hasMoreTokens()) {
                    sb.append(st.nextToken());
                }
                this.value = sb.toString();
            }
        }

        @Override
        public String toString() {
            return this.format.format(this.name, this.value, this.separator);
        }

        private static boolean validName(String name, char separator) {
            if (name.trim().isEmpty()) {
                return false;
            }
            return name.indexOf(separator) < 0;
        }
    }

    private static class OptionFormat {
        private static final int EXPECTED_TOKENS = 4;
        private final String[] formatTokens;

        public OptionFormat(String formatString) {
            this.formatTokens = this.compileFormat(formatString);
        }

        public String format(String name, String value, char separator) {
            String[] t = this.formatTokens;
            return String.valueOf(t[0]) + name + t[1] + separator + t[2] + value + t[3];
        }

        private String[] compileFormat(String formatString) {
            String[] tokens = new String[]{"", "", "", ""};
            int tokenCount = 0;
            boolean seenPercent = false;
            StringBuilder token = new StringBuilder();
            int i = 0;
            while (i < formatString.length()) {
                switch (formatString.charAt(i)) {
                    case '%': {
                        if (seenPercent) {
                            token.append("%");
                            seenPercent = false;
                            break;
                        }
                        seenPercent = true;
                        break;
                    }
                    case 's': {
                        if (seenPercent) {
                            if (tokenCount >= 4) {
                                throw new IllegalArgumentException("Illegal option format. Too many %s placeholders.");
                            }
                            tokens[tokenCount] = token.toString();
                            ++tokenCount;
                            token = new StringBuilder();
                            seenPercent = false;
                            break;
                        }
                        token.append("s");
                        break;
                    }
                    default: {
                        if (seenPercent) {
                            throw new IllegalArgumentException("Illegal option format. Unknown format specifier.");
                        }
                        token.append(formatString.charAt(i));
                    }
                }
                ++i;
            }
            if (tokenCount != 3) {
                throw new IllegalArgumentException("Illegal option format. Not enough %s placeholders.");
            }
            tokens[tokenCount] = token.toString();
            return tokens;
        }
    }

    public static class Section {
        private static final char[] DEFAULT_OPTION_DELIMS = new char[]{'='};
        private static final char[] DEFAULT_COMMENT_DELIMS = new char[]{'#', ';'};
        private static final char[] OPTION_DELIMS_WHITESPACE = new char[]{' ', '\t'};
        public static final String DEFAULT_OPTION_FORMAT = "%s%s%s";
        public static final char HEADER_START = '[';
        public static final char HEADER_END = ']';
        private static final int NAME_MAXLENGTH = 8192;
        private static final char[] INVALID_NAME_CHARS = new char[]{'[', ']'};
        private final String name;
        private Map<String, Option> options;
        private List<Line> lines;
        private final char[] optionDelims;
        private final char[] optionDelimsSorted;
        private final char[] commentDelims;
        private final char[] commentDelimsSorted;
        private OptionFormat optionFormat;

        public Section(String name) {
            this(name, null);
        }

        public Section(String name, char[] delims) {
            if (!Section.validName(name)) {
                throw new IllegalArgumentException("Illegal section name:" + name);
            }
            this.name = name;
            this.options = new HashMap<String, Option>();
            this.lines = new LinkedList<Line>();
            this.optionDelims = DEFAULT_OPTION_DELIMS;
            this.commentDelims = delims == null ? DEFAULT_COMMENT_DELIMS : delims;
            this.optionFormat = new OptionFormat(DEFAULT_OPTION_FORMAT);
            this.optionDelimsSorted = new char[this.optionDelims.length];
            System.arraycopy(this.optionDelims, 0, this.optionDelimsSorted, 0, this.optionDelims.length);
            this.commentDelimsSorted = new char[this.commentDelims.length];
            System.arraycopy(this.commentDelims, 0, this.commentDelimsSorted, 0, this.commentDelims.length);
            Arrays.sort(this.optionDelimsSorted);
            Arrays.sort(this.commentDelimsSorted);
        }

        public void clear() {
            this.options = new HashMap<String, Option>();
            this.lines = new LinkedList<Line>();
        }

        public void setOptionFormatString(String formatString) {
            this.setOptionFormat(new OptionFormat(formatString));
        }

        public void setOptionFormat(OptionFormat format) {
            this.optionFormat = format;
        }

        public List<String> optionNames() {
            LinkedList<String> optNames = new LinkedList<String>();
            this.lines.stream().filter(line -> line instanceof Option).forEach(line -> {
                boolean bl = optNames.add(((Option)line).name());
            });
            return optNames;
        }

        public boolean hasOption(String name) {
            return this.options.containsKey(this.normOption(name));
        }

        public String get(String option) {
            String normed = this.normOption(option);
            if (this.hasOption(normed)) {
                return this.getOption(normed).value();
            }
            return null;
        }

        public void set(String option, String value) {
            this.set(option, value, this.optionDelims[0]);
        }

        public void set(String option, String value, char delim) {
            String normed = this.normOption(option);
            if (this.hasOption(normed)) {
                this.getOption(normed).set(value);
            } else {
                Option opt = new Option(normed, value, delim, this.optionFormat);
                this.options.put(normed, opt);
                this.lines.add(opt);
            }
        }

        public boolean remove(String option) {
            String normed = this.normOption(option);
            if (this.hasOption(normed)) {
                this.lines.remove(this.getOption(normed));
                this.options.remove(normed);
                return true;
            }
            return false;
        }

        public void addComment(String comment) {
            this.addComment(comment, this.commentDelims[0]);
        }

        public void addComment(String comment, char delim) {
            StringTokenizer st = new StringTokenizer(comment.trim(), Const.LINE_SEPARATOR);
            while (st.hasMoreTokens()) {
                this.lines.add(new Comment(st.nextToken(), delim));
            }
        }

        public void addBlankLine() {
            this.lines.add(BLANK_LINE);
        }

        public void load(BufferedReader reader) throws IOException {
            while (reader.ready()) {
                reader.mark(8192);
                String line = reader.readLine();
                if (line == null) continue;
                if ((line = line.trim()).length() > 0 && line.charAt(0) == '[') {
                    reader.reset();
                    return;
                }
                int delimIndex = -1;
                if (line.isEmpty()) {
                    this.addBlankLine();
                    continue;
                }
                delimIndex = Arrays.binarySearch(this.commentDelimsSorted, line.charAt(0));
                if (delimIndex >= 0) {
                    this.addComment(line.substring(1), this.commentDelimsSorted[delimIndex]);
                    continue;
                }
                delimIndex = -1;
                int delimNum = -1;
                int lastSpaceIndex = -1;
                int i = 0;
                int l = line.length();
                while (i < l && delimIndex < 0) {
                    delimNum = Arrays.binarySearch(this.optionDelimsSorted, line.charAt(i));
                    if (delimNum >= 0) {
                        delimIndex = i;
                    } else {
                        boolean isSpace;
                        boolean bl = isSpace = Arrays.binarySearch(OPTION_DELIMS_WHITESPACE, line.charAt(i)) >= 0;
                        if (!isSpace && lastSpaceIndex >= 0) break;
                        if (isSpace) {
                            lastSpaceIndex = i;
                        }
                    }
                    ++i;
                }
                if (delimIndex == 0) continue;
                if (delimIndex < 0) {
                    if (lastSpaceIndex < 0) {
                        this.set(line, "");
                        continue;
                    }
                    this.set(line.substring(0, lastSpaceIndex), line.substring(lastSpaceIndex + 1));
                    continue;
                }
                this.set(line.substring(0, delimIndex), line.substring(delimIndex + 1), line.charAt(delimIndex));
            }
        }

        public void save(PrintWriter writer) throws IOException {
            this.lines.forEach(line -> writer.println(line.toString()));
            if (writer.checkError()) {
                throw new IOException();
            }
        }

        private Option getOption(String name) {
            return this.options.get(name);
        }

        private String header() {
            return String.valueOf('[') + this.name + ']';
        }

        private static boolean validName(String name) {
            if (name.trim().isEmpty()) {
                return false;
            }
            char[] cArray = INVALID_NAME_CHARS;
            int n = INVALID_NAME_CHARS.length;
            int n2 = 0;
            while (n2 < n) {
                char element = cArray[n2];
                if (name.indexOf(element) >= 0) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        private String normOption(String name) {
            return name.trim();
        }
    }
}

