/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.db.model;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.Icon;
import jgamebase.Const;
import jgamebase.db.Db;
import jgamebase.db.model.Artist;
import jgamebase.db.model.Cracker;
import jgamebase.db.model.Developer;
import jgamebase.db.model.Difficulty;
import jgamebase.db.model.Extra;
import jgamebase.db.model.Genre;
import jgamebase.db.model.Item;
import jgamebase.db.model.Language;
import jgamebase.db.model.License;
import jgamebase.db.model.Musician;
import jgamebase.db.model.Programmer;
import jgamebase.db.model.Publisher;
import jgamebase.db.model.Rarity;
import jgamebase.db.model.Year;
import jgamebase.gui.Gui;
import jgamebase.model.Databases;
import jgamebase.model.Emulator;
import jgamebase.model.Emulators;
import jgamebase.model.FileExtensions;
import jgamebase.model.Paths;
import jgamebase.tools.FileTools;
import jgamebase.tools.ListerTools;
import jgamebase.tools.StringTools;
import jgamebase.tools.TempDir;

public class Game
implements Item {
    private static final long serialVersionUID = -6900055147697075607L;
    public static final int CCODE_NOTSET = 0;
    public static final int CCODE_GAMEMUSIC = 1;
    public static final int CCODE_GAME = 2;
    public static final int CCODE_MUSIC = 3;
    public static final int CCODE_NOTHING = 4;
    private int id;
    private String name = "";
    private Year year = new Year(1);
    private String comment = "";
    private String filename = "";
    private String fileToRun = "";
    private int filenameIndex;
    private String screenshotFilename = "";
    private Musician musician = new Musician(38);
    private Genre genre = new Genre(1);
    private Publisher publisher = new Publisher(37);
    private Difficulty difficulty = new Difficulty(8);
    private Cracker cracker = new Cracker(7);
    private String musicFilename = "";
    private String dateLastPlayed = "";
    private int timesPlayed;
    private String highscore = "";
    private boolean gameFileExists;
    private boolean musicFileExists;
    private boolean isFavourite;
    private Programmer programmer = new Programmer(1);
    private Language language = new Language(1);
    private boolean hasExtras;
    private boolean isClassic;
    private int rating = 0;
    private int _hasLoadingScreen;
    private int _hasHighscoreSaver;
    private int _hasIncludedDocs;
    private int PalNtsc = 3;
    private int _needsTruedriveEmu;
    private int length;
    private int trainer;
    private int playersMin = 1;
    private int playersMax = 1;
    private boolean isSimultaneouslyPlayable;
    private String versionComment = "";
    private boolean isAdult;
    private String note = "";
    private int prequelId;
    private int sequelId;
    private int relatedId;
    private int control = 0;
    private String crc = "";
    private int filesize;
    private int version;
    private String keyValuePairs = "";
    private int lengthType = 19;
    private Artist artist = new Artist(1);
    private Developer developer = new Developer(1);
    private License license = new License(1);
    private Rarity rarity = new Rarity(1);
    private String webLinkName;
    private String webLinkUrl;
    private String vWebLinkName;
    private String vWebLinkUrl;
    private int hasTitleScreen;
    private int isPlayable;
    private int isOriginal;
    private int cloneOf;
    private int reviewRating;
    private List<Extra> extras = new ArrayList<Extra>();

    public Game() {
    }

    public Game(String name, String filename, String fileToRun, int filenameIndex) {
        this.name = name;
        this.setFilename(filename);
        this.setFileToRun(fileToRun);
        this.filenameIndex = filenameIndex;
        this.year = Db.getYearById(1);
        this.musician = Db.getMusicianById(38);
        this.genre = Db.getGenreById(1);
        this.publisher = Db.getPublisherById(37);
        this.difficulty = Db.getDifficultyById(8);
        this.cracker = Db.getCrackerById(7);
        this.programmer = Db.getProgrammerById(1);
        this.language = Db.getLanguageById(1);
        this.gameFileExists = true;
    }

    public Game(int id) {
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getStringId() {
        return "G" + this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name == null ? "" : this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Year getYear() {
        if (this.year == null) {
            this.year = new Year(1);
        }
        return this.year;
    }

    public void setYear(Year year) {
        this.year = year;
    }

    public String getComment() {
        return this.comment == null ? "" : this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getFilename() {
        return Paths.backslashToSlash(this.filename);
    }

    public void setFilename(String filename) {
        this.filename = Paths.slashToBackslash(filename);
    }

    public String getFileToRun() {
        return Paths.backslashToSlash(this.fileToRun);
    }

    public void setFileToRun(String fileToRun) {
        this.fileToRun = Paths.slashToBackslash(fileToRun);
    }

    public int getFilenameIndex() {
        return this.filenameIndex;
    }

    public void setFilenameIndex(int filenameIndex) {
        this.filenameIndex = filenameIndex;
    }

    public String getScreenshotFilename() {
        return Paths.backslashToSlash(this.screenshotFilename);
    }

    public void setScreenshotFilename(String screenshotFilename) {
        this.screenshotFilename = Paths.slashToBackslash(screenshotFilename);
    }

    public int getScreenshotCount() {
        if (this.getScreenshotFilename() == null || this.getScreenshotFilename().isEmpty()) {
            return 0;
        }
        int number = 0;
        while (Paths.getScreenshotPath().exists(new File(FileTools.insertBeforeFileextension(this.getScreenshotFilename(), number == 0 ? "" : "_" + number)))) {
            ++number;
        }
        return number;
    }

    public List<String> getScreenshotFilenames() {
        ArrayList<String> filenames = new ArrayList<String>();
        int count = this.getScreenshotCount();
        if (count == 0) {
            return filenames;
        }
        int i = 0;
        while (i < count) {
            String filename = FileTools.insertBeforeFileextension(Paths.getScreenshotPath().find(new File(this.getScreenshotFilename())).getPath(), i == 0 ? "" : "_" + i);
            filenames.add(filename);
            ++i;
        }
        return filenames;
    }

    @Override
    public Musician getMusician() {
        if (this.musician == null) {
            this.musician = new Musician(38);
        }
        return this.musician;
    }

    public void setMusician(Musician musician) {
        this.musician = musician;
    }

    public Genre getGenre() {
        if (this.genre == null) {
            this.genre = new Genre(1);
        }
        return this.genre;
    }

    public void setGenre(Genre genre) {
        this.genre = genre;
    }

    public String getGenreForDisplay() {
        if (this.getGenre().getId() == 1 || this.getGenre().getParentGenre() == null || this.getGenre().getParentGenre().getName().isEmpty()) {
            return this.getGenre().getName();
        }
        return String.valueOf(this.getGenre().getParentGenre().getName()) + " - " + this.getGenre().getName();
    }

    public Publisher getPublisher() {
        if (this.publisher == null) {
            this.publisher = new Publisher(37);
        }
        return this.publisher;
    }

    public void setPublisher(Publisher publisher) {
        this.publisher = publisher;
    }

    public Difficulty getDifficulty() {
        if (this.difficulty == null) {
            this.difficulty = new Difficulty(8);
        }
        return this.difficulty;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    public Cracker getCracker() {
        if (this.cracker == null) {
            this.cracker = new Cracker(7);
        }
        return this.cracker;
    }

    public void setCracker(Cracker cracker) {
        this.cracker = cracker;
    }

    public String getMusicFilename() {
        return Paths.backslashToSlash(this.musicFilename);
    }

    public void setMusicFilename(String musicFilename) {
        this.musicFilename = Paths.slashToBackslash(musicFilename);
    }

    public String getDateLastPlayed() {
        return this.dateLastPlayed == null ? "" : this.dateLastPlayed;
    }

    public void setDateLastPlayed(String dateLastPlayed) {
        this.dateLastPlayed = dateLastPlayed;
    }

    public String getDateLastPlayedForDisplay() {
        return this.getDateLastPlayed().isEmpty() ? "Never" : this.getDateLastPlayed();
    }

    public int getTimesPlayed() {
        return this.timesPlayed;
    }

    public void setTimesPlayed(int timesPlayed) {
        this.timesPlayed = timesPlayed;
    }

    public String getTimesPlayedForDisplay() {
        return Integer.toString(this.getTimesPlayed());
    }

    private int get_ccode() {
        return 0;
    }

    private void set_ccode(int _ccode) {
    }

    private int getCcode() {
        boolean musicPathSpecified;
        boolean gamePathSpecified = !this.getFilename().isEmpty();
        boolean bl = musicPathSpecified = !this.getMusicFilename().isEmpty();
        if (gamePathSpecified && musicPathSpecified) {
            return 1;
        }
        if (gamePathSpecified && !musicPathSpecified) {
            return 2;
        }
        if (!gamePathSpecified && musicPathSpecified) {
            return 3;
        }
        if (!gamePathSpecified && !musicPathSpecified) {
            return 4;
        }
        return 0;
    }

    public String getHighscore() {
        return this.highscore == null ? "" : this.highscore;
    }

    public void setHighscore(String highscore) {
        this.highscore = highscore;
    }

    public String getHighscoreForDisplay() {
        return this.getHighscore().isEmpty() ? "Not Entered" : this.getHighscore();
    }

    public boolean getGameFileExists() {
        return this.gameFileExists;
    }

    public void setGameFileExists(boolean fileExists) {
        this.gameFileExists = fileExists;
    }

    public boolean getMusicFileExists() {
        return this.musicFileExists;
    }

    public void setMusicFileExists(boolean musicFileExists) {
        this.musicFileExists = musicFileExists;
    }

    @Override
    public boolean getIsFavourite() {
        return this.isFavourite;
    }

    @Override
    public void setIsFavourite(boolean isFavourite) {
        this.isFavourite = isFavourite;
    }

    public Programmer getProgrammer() {
        if (this.programmer == null) {
            this.programmer = new Programmer(1);
        }
        return this.programmer;
    }

    public void setProgrammer(Programmer programmer) {
        this.programmer = programmer;
    }

    public Language getLanguage() {
        if (this.language == null) {
            this.language = new Language(1);
        }
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public boolean getHasExtras() {
        this.hasExtras = this.getExtras() != null && this.getExtras().size() > 0;
        return this.hasExtras;
    }

    public void setHasExtras(boolean hasExtras) {
        this.hasExtras = hasExtras;
    }

    public boolean getIsClassic() {
        return this.isClassic;
    }

    public void setIsClassic(boolean isClassic) {
        this.isClassic = isClassic;
    }

    public int getRating() {
        if (this.getIsClassic()) {
            return 6;
        }
        return this.rating;
    }

    public void setRating(int rating) {
        this.rating = rating;
    }

    public String getRatingForDisplay() {
        String rating = "";
        if (this.getRating() >= 0 && this.getRating() < Const.FORDISPLAY_RATING.length) {
            rating = Const.FORDISPLAY_RATING[this.getRating()];
        }
        if (this.getIsClassic()) {
            rating = "Classic!";
        }
        return rating;
    }

    private int get_hasLoadingScreen() {
        return this._hasLoadingScreen;
    }

    private void set_hasLoadingScreen(int _hasLoadingScreen) {
        this._hasLoadingScreen = _hasLoadingScreen;
    }

    public boolean getHasLoadingScreen() {
        return Game.intToBoolean(this.get_hasLoadingScreen());
    }

    public void setHasLoadingScreen(boolean hasLoadingScreen) {
        this.set_hasLoadingScreen(Game.booleanToInt(hasLoadingScreen));
    }

    public String getHasLoadingScreenForDisplay() {
        return this.getHasLoadingScreen() ? "Yes" : "No";
    }

    private int get_hasHighscoreSaver() {
        return this._hasHighscoreSaver;
    }

    private void set_hasHighscoreSaver(int _hasHighscoreSaver) {
        this._hasHighscoreSaver = _hasHighscoreSaver;
    }

    public boolean getHasHighscoreSaver() {
        return Game.intToBoolean(this.get_hasHighscoreSaver());
    }

    public void setHasHighscoreSaver(boolean hasHighscoreSaver) {
        this.set_hasHighscoreSaver(Game.booleanToInt(hasHighscoreSaver));
    }

    public String getHasHighscoreSaverForDisplay() {
        return this.getHasHighscoreSaver() ? "Yes" : "No";
    }

    private int get_hasIncludedDocs() {
        return this._hasIncludedDocs;
    }

    private void set_hasIncludedDocs(int _hasIncludedDocs) {
        this._hasIncludedDocs = _hasIncludedDocs;
    }

    public boolean getHasIncludedDocs() {
        return Game.intToBoolean(this.get_hasIncludedDocs());
    }

    public void setHasIncludedDocs(boolean hasIncludedDocs) {
        this.set_hasIncludedDocs(Game.booleanToInt(hasIncludedDocs));
    }

    public String getHasIncludedDocsForDisplay() {
        return this.getHasIncludedDocs() ? "Yes" : "No";
    }

    public int getPalNtsc() {
        return this.PalNtsc;
    }

    public void setPalNtsc(int PalNtsc) {
        this.PalNtsc = PalNtsc;
    }

    public String getPalNtscForDisplay() {
        String palNtsc = "";
        if (this.getPalNtsc() >= 0 && this.getPalNtsc() < Const.FORDISPLAY_PALNTSC.length) {
            palNtsc = Const.FORDISPLAY_PALNTSC[this.getPalNtsc()];
        }
        return palNtsc;
    }

    public boolean isRunsOnPal() {
        return this.getPalNtsc() != 2;
    }

    public boolean isRunsOnNtsc() {
        return this.getPalNtsc() == 1 || this.getPalNtsc() == 2;
    }

    private int get_needsTruedriveEmu() {
        return this._needsTruedriveEmu;
    }

    public void set_needsTruedriveEmu(int _needsTruedriveEmu) {
        this._needsTruedriveEmu = _needsTruedriveEmu;
    }

    public boolean getNeedsTruedriveEmu() {
        return Game.intToBoolean(this.get_needsTruedriveEmu());
    }

    public void setNeedsTruedriveEmu(boolean needsTruedriveEmu) {
        this.set_needsTruedriveEmu(Game.booleanToInt(needsTruedriveEmu));
    }

    public String getNeedsTruedriveEmuForDisplay() {
        return this.getNeedsTruedriveEmu() ? "Yes" : "No";
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getLengthForDisplay() {
        String length = String.valueOf(Math.abs(this.getLength())) + " ";
        if (this.getLengthType() >= 0 && this.getLengthType() < Const.FORDISPLAY_LENGTHTYPE.length) {
            length = String.valueOf(length) + Const.FORDISPLAY_LENGTHTYPE[this.getLengthType()];
        }
        return length;
    }

    public int getTrainer() {
        return this.trainer;
    }

    public void setTrainer(int trainer) {
        this.trainer = trainer;
    }

    public String getTrainerForDisplay() {
        if (this.getTrainer() == -1) {
            return "(Unknown)";
        }
        return Integer.toString(this.getTrainer());
    }

    public int getPlayersMin() {
        return this.playersMin;
    }

    public void setPlayersMin(int playersMin) {
        this.playersMin = playersMin;
    }

    public int getPlayersMax() {
        return this.playersMax;
    }

    public void setPlayersMax(int playersMax) {
        this.playersMax = playersMax;
    }

    public String getPlayersForDisplay() {
        String players = "";
        players = this.getPlayersMin() == this.getPlayersMax() ? String.valueOf(this.getPlayersMin()) + "P Only" : String.valueOf(this.getPlayersMin()) + " - " + this.getPlayersMax();
        if (this.getIsSimultaneouslyPlayable()) {
            players = String.valueOf(players) + " (Simultaneous)";
        }
        return players;
    }

    public boolean getIsSimultaneouslyPlayable() {
        return this.isSimultaneouslyPlayable;
    }

    public void setIsSimultaneouslyPlayable(boolean isSimultaneouslyPlayable) {
        this.isSimultaneouslyPlayable = isSimultaneouslyPlayable;
    }

    public String getVersionComment() {
        return this.versionComment == null ? "" : this.versionComment;
    }

    public void setVersionComment(String versionComment) {
        this.versionComment = versionComment;
    }

    @Override
    public boolean getIsAdult() {
        return this.isAdult;
    }

    public void setIsAdult(boolean isAdult) {
        this.isAdult = isAdult;
    }

    public String getNote() {
        return this.note == null ? "" : this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public int getPrequelId() {
        return this.prequelId;
    }

    public boolean hasPrequel() {
        return this.getPrequelId() > 0;
    }

    public void setPrequelId(int prequel) {
        this.prequelId = prequel;
    }

    public int getSequelId() {
        return this.sequelId;
    }

    public boolean hasSequel() {
        return this.getSequelId() > 0;
    }

    public void setSequelId(int sequel) {
        this.sequelId = sequel;
    }

    public int getRelatedId() {
        return this.relatedId;
    }

    public boolean hasRelated() {
        return this.getRelatedId() > 0;
    }

    public void setRelatedId(int related) {
        this.relatedId = related;
    }

    public int getControl() {
        return this.control;
    }

    public void setControl(int control) {
        this.control = control;
    }

    public String getControlForDisplay() {
        String control = "";
        if (this.getControl() >= 0 && this.getControl() < Const.FORDISPLAY_CONTROL.length) {
            control = Const.FORDISPLAY_CONTROL[this.getControl()];
        }
        return control;
    }

    public String getCrc() {
        return this.crc == null ? "" : this.crc;
    }

    public void setCrc(String crc) {
        this.crc = crc;
    }

    public int getFilesize() {
        return this.filesize;
    }

    public void setFilesize(int filesize) {
        this.filesize = filesize;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getKeyValuePairs() {
        return this.keyValuePairs == null ? "" : this.keyValuePairs;
    }

    public void setKeyValuePairs(String gemus) {
        this.keyValuePairs = gemus;
    }

    public int getLengthType() {
        return this.lengthType;
    }

    public void setLengthType(int lengthType) {
        this.lengthType = lengthType;
    }

    public List<Extra> getExtras() {
        return this.extras;
    }

    public void setExtras(List<Extra> extras) {
        extras.removeAll(Collections.singleton(null));
        extras.forEach(extra -> extra.setGameId(this.id));
        Collections.sort(extras, new Comparator<Extra>(){

            @Override
            public int compare(Extra e1, Extra e2) {
                return e1.getDisplayOrder() - e2.getDisplayOrder();
            }
        });
        this.extras = extras;
    }

    @Override
    public Icon getIcon() {
        switch (this.getCcode()) {
            case 1: {
                return Const.ICON_LIST_GAMEANDSID;
            }
            case 2: {
                return Const.ICON_LIST_JUSTGAME;
            }
            case 3: {
                return Const.ICON_LIST_JUSTSID;
            }
        }
        return Const.ICON_LIST_NONE;
    }

    public Artist getArtist() {
        if (this.artist == null) {
            this.artist = new Artist(1);
        }
        return this.artist;
    }

    public void setArtist(Artist artist) {
        this.artist = artist;
    }

    public Developer getDeveloper() {
        if (this.developer == null) {
            this.developer = new Developer(1);
        }
        return this.developer;
    }

    public void setDeveloper(Developer developer) {
        this.developer = developer;
    }

    public License getLicense() {
        if (this.license == null) {
            this.license = new License(1);
        }
        return this.license;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    public Rarity getRarity() {
        if (this.rarity == null) {
            this.rarity = new Rarity(1);
        }
        return this.rarity;
    }

    public void setRarity(Rarity rarity) {
        this.rarity = rarity;
    }

    public String getWebLinkName() {
        return this.webLinkName == null ? "" : this.webLinkName;
    }

    public void setWebLinkName(String webLinkName) {
        this.webLinkName = webLinkName;
    }

    public String getWebLinkUrl() {
        return this.webLinkUrl == null ? "" : this.webLinkUrl;
    }

    public void setWebLinkUrl(String webLinkUrl) {
        this.webLinkUrl = webLinkUrl;
    }

    public String getvWebLinkName() {
        return this.vWebLinkName == null ? "" : this.vWebLinkName;
    }

    public void setvWebLinkName(String vWebLinkName) {
        this.vWebLinkName = vWebLinkName;
    }

    public String getvWebLinkUrl() {
        return this.vWebLinkUrl == null ? "" : this.vWebLinkUrl;
    }

    public void setvWebLinkUrl(String vWebLinkUrl) {
        this.vWebLinkUrl = vWebLinkUrl;
    }

    public int getHasTitleScreen() {
        return this.hasTitleScreen;
    }

    public void setHasTitleScreen(int hasTitleScreen) {
        this.hasTitleScreen = hasTitleScreen;
    }

    public int getIsPlayable() {
        return this.isPlayable;
    }

    public void setIsPlayable(int isPlayable) {
        this.isPlayable = isPlayable;
    }

    public int getIsOriginal() {
        return this.isOriginal;
    }

    public void setIsOriginal(int isOriginal) {
        this.isOriginal = isOriginal;
    }

    public int getCloneOf() {
        return this.cloneOf;
    }

    public void setCloneOf(int cloneOf) {
        this.cloneOf = cloneOf;
    }

    public int getReviewRating() {
        return this.reviewRating;
    }

    public void setReviewRating(int reviewRating) {
        this.reviewRating = reviewRating;
    }

    @Override
    public void play() throws IOException {
        Game.play(this, null, false);
    }

    public void play(boolean isAlreadyExtracted) throws IOException {
        Game.play(this, null, isAlreadyExtracted);
    }

    public void play(Emulator emulator) throws IOException {
        Game.play(this, emulator, false);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void play(Game game, Emulator emulator, boolean isAlreadyExtracted) throws IOException {
        filename = "";
        filenameIndex = game.getFilenameIndex();
        tempDir = null;
        Databases.getCurrent().getPreferences().inc("about_games_played");
        game.setDateLastPlayed(new SimpleDateFormat("dd.MM.yyyy").format(new Date()));
        game.setTimesPlayed(game.getTimesPlayed() + 1);
        Db.saveOrUpdate(game);
        if (isAlreadyExtracted) {
            fileToRun = game.getFileToRun();
            namesOfSupportedFiles = new ArrayList<String>();
            namesOfSupportedFiles.add(fileToRun);
            namesOfSupportedFiles.addAll(ListerTools.list_Dirs_Files_Paths(new File(fileToRun).getParent(), false, true, true));
        } else {
            filename = Paths.getGamePath().findAndWarn(new File(game.getFilename())) != null ? Paths.getGamePath().find(new File(game.getFilename())).getPath() : "";
            fileToRun = "";
            tempDir = new TempDir();
            namesOfSupportedFiles = FileTools.copyOrExtractToDir(filename, tempDir.toString());
            if (!game.getFileToRun().isEmpty()) {
                for (String var8_9 : namesOfSupportedFiles) {
                    possibleFileToRun = new File(var8_9).getName();
                    if (!possibleFileToRun.equalsIgnoreCase(game.getFileToRun())) continue;
                    fileToRun = var8_9;
                    break;
                }
            }
            if (fileToRun.isEmpty() && namesOfSupportedFiles.size() > 0) {
                fileToRun = (String)namesOfSupportedFiles.get(0);
            }
        }
        Const.log.info((Object)("FileToRun: '" + fileToRun + "'."));
        var8_10 = StringTools.nextMedium(filename);
        nextMediumFile = new File(var8_10);
        while (nextMediumFile.exists()) {
            Const.log.info((Object)("next medium '" + (String)var8_11 + "'"));
            namesOfSupportedFiles.addAll(FileTools.copyOrExtractToDir((String)var8_11, tempDir.toString()));
            var8_12 = StringTools.nextMedium((String)var8_11);
            nextMediumFile = new File(var8_12);
        }
        if (emulator == null) {
            emulator = Emulators.findGameEmulatorForExtension(FileTools.getExtension(fileToRun));
        }
        if (emulator != null) {
            Const.log.info((Object)("Using Emulator: '" + emulator.getName() + "'."));
            namesOfSupportedFiles = emulator.getSupportedExtensions().getMatching(namesOfSupportedFiles);
            script = new File(new File(Databases.getCurrent().getPath(), "Scripts"), emulator.getCommand());
            if (script.exists()) {
                manager = new ScriptEngineManager();
                engine = manager.getEngineByExtension(FileTools.getExtension(emulator.getCommand()));
                if (engine == null) {
                    Const.log.info((Object)"Execution mode: BATCHSCRIPT");
                    script.setExecutable(true, false);
                    Emulators.executeGame(new String[]{script.getAbsolutePath(), fileToRun}, Emulators.setupEnvironment(game, fileToRun, filenameIndex, emulator, namesOfSupportedFiles, tempDir), tempDir);
                    return;
                }
                Const.log.info((Object)"Execution mode: SCRIPT");
                Const.log.info((Object)(String.valueOf(engine.getFactory().getLanguageName()) + " executed by " + engine.getFactory().getEngineName() + " " + engine.getFactory().getEngineVersion()));
                includesFilename = "includes." + FileTools.getExtension(emulator.getCommand());
                includesAsString = "";
                includesPathAndFilename = "";
                try {
                    bindings = engine.getBindings(100);
                    bindings.putAll((Map<? extends String, ? extends Object>)Emulators.setupEnvironment(game, fileToRun, filenameIndex, emulator, namesOfSupportedFiles, tempDir));
                    engine.setBindings(bindings, 100);
                    includesPathAndFilename = new File(new File(Const.GBDIR_RO, "Includes"), includesFilename).getAbsolutePath();
                    if (new File(includesPathAndFilename).exists()) {
                        Const.log.info((Object)("Loading includes '" + includesPathAndFilename + "'."));
                        includesAsString = FileTools.readFileAsString(includesPathAndFilename);
                    }
                    if (!includesAsString.isEmpty()) {
                        includesAsString = String.valueOf(includesAsString) + Const.LINE_SEPARATOR;
                    }
                    scriptAsString = FileTools.readFileAsString(script.getAbsolutePath());
                    Const.log.info((Object)("Executing script '" + script.getAbsolutePath() + "'..."));
                    engine.eval(String.valueOf(includesAsString) + scriptAsString);
                    return;
                }
                catch (IOException v0) {
                    Const.log.error((Object)("The script '" + script.getAbsolutePath() + "' could not be loaded."));
                    return;
                }
                catch (ScriptException se) {
                    if (includesAsString.isEmpty()) return;
                    scanner = new Scanner(includesAsString);
                    scanner.useDelimiter("\r\n|[\n\r\u2028\u2029\u0085]");
                    includedLines = 0;
                    ** while (scanner.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    ++includedLines;
                    scanner.next();
                    continue;
                }
lbl87:
                // 1 sources

                Const.log.error((Object)se.getMessage());
                lineNumber = se.getLineNumber();
                if (lineNumber < 0 || lineNumber >= 32767) return;
                Const.log.error((Object)("IMPORTANT: When locating the error please bear in mind that an include of " + includedLines + " lines was added before your script:"));
                if (lineNumber <= includedLines) {
                    Const.log.error((Object)("So the error really occured at line " + lineNumber + " in the include '" + includesPathAndFilename + "' ."));
                } else {
                    Const.log.error((Object)("So the error really occured at line " + (lineNumber - includedLines) + " in the script '" + script.getAbsolutePath() + "' ."));
                }
                Const.log.error((Object)"");
                return;
            }
            Const.log.info((Object)"Execution mode: EXECUTABLE");
            Emulators.executeGame(new String[]{emulator.getCommand(), fileToRun}, Emulators.setupEnvironment(game, fileToRun, filenameIndex, emulator, namesOfSupportedFiles, tempDir), tempDir);
            return;
        }
        Gui.displayErrorDialog("No Game Emulator found for game '" + game.getName() + "'!\n" + (fileToRun.isEmpty() != false ? "" : "The requested file extension was '" + FileTools.getExtension(fileToRun) + "'.\n") + "\n" + "Please check your Game Emulator configuration:\n" + "The supported extensions must be specified as a semicolon\n" + "separated list of file extensions (e.g. 'd64;t64;tap;crt').");
    }

    public void syncAdditionalExtras(boolean enqueue) {
        Game.syncAdditionalExtras(this, enqueue);
    }

    private static void syncAdditionalExtras(Game game, boolean enqueue) {
        Paths.createAdditionalExtraDirectories(game.getId(), game.getName());
        ArrayList<Extra> extras = new ArrayList<Extra>(game.getExtras());
        if (extras != null) {
            extras.removeIf(extra -> extra == null || extra.isAdditional());
        }
        File dir = Paths.getAdditionalExtraPathId(game.getId());
        int displayOrder = extras.size();
        List<String> filenames = ListerTools.list_Dirs_Files_Paths(dir.toString(), false, true, false);
        for (String filename : filenames) {
            String path = new File(new File(new File("Additional", "by-id"), String.format("%05d", game.getId())), filename).toString();
            Extra extra2 = Game.createExtra(path, "");
            if (extra2 == null) continue;
            extra2.setDisplayOrder(displayOrder++);
            extras.add(extra2);
        }
        List<String> subdirs = ListerTools.list_Dirs_Files_Paths(dir.toString(), true, false, false);
        for (String subdir : subdirs) {
            filenames = ListerTools.list_Dirs_Files_Paths(new File(dir, subdir).toString(), false, true, false);
            for (String filename : filenames) {
                String path = new File(new File(new File(new File("Additional", "by-id"), String.format("%05d", game.getId())), subdir), filename).toString();
                Extra extra3 = Game.createExtra(path, subdir);
                if (extra3 == null) continue;
                extra3.setDisplayOrder(displayOrder++);
                extras.add(extra3);
            }
        }
        game.getExtras().stream().filter(extra -> !extras.contains(extra)).forEach(extra -> {
            extra.setGameId(0);
            if (enqueue) {
                Extra.enqueueForDeletion(extra);
            } else {
                Db.delete(extra);
            }
        });
        game.setExtras(extras);
        if (!enqueue) {
            Db.saveOrUpdate(game);
        }
    }

    private static Extra createExtra(String path, String subdir) {
        Extra extra = new Extra();
        String name = new File(path).getName();
        String filename = new File(Paths.getExtraPath().getDefault_rw(), path).getAbsolutePath();
        Const.log.info((Object)("creating Extra for file '" + name + "'..."));
        if (FileTools.isUrlFromFilename(filename)) {
            URL url = FileTools.getUrlFromFilename(filename);
            Const.log.info((Object)("Extra '" + name + "' is URL extra for '" + url + "'"));
            String downloadDir = new File(filename).getAbsolutePath();
            String downloadFile = new File(url.getFile()).getName();
            File downloaded = new File(downloadDir, downloadFile);
            if (downloaded.exists()) {
                Const.log.info((Object)"has already been downloaded, will not be added");
                return null;
            }
            extra.setName(String.valueOf(subdir) + (subdir.isEmpty() ? "" : " - ") + FileTools.removeExtension(downloadFile));
            extra.setFilename(url.toString());
        } else {
            Const.log.info((Object)"is normal extra");
            extra.setName(String.valueOf(subdir) + (subdir.isEmpty() ? "" : " - ") + FileTools.removeExtension(name));
            extra.setFilename(path);
        }
        return extra;
    }

    public void createScreenshots() throws IOException {
        Game.createScreenshots(this);
    }

    private static void createScreenshots(Game game) throws IOException {
        File dir = new File(Databases.getCurrent().getPath(), "Scripts");
        List<String> srcFilenames = new FileExtensions("png").getMatching(ListerTools.list_Dirs_Files_Paths(dir.getAbsolutePath(), false, true, false));
        if (game.getScreenshotCount() == 0 || (game.getScreenshotFilename() == null || game.getScreenshotFilename().isEmpty()) && !game.getName().isEmpty()) {
            String work = String.valueOf(StringTools.sanitize(game.getName())) + ".png";
            game.setScreenshotFilename(new File(work.substring(0, 1).toUpperCase(), work).getPath());
            Db.saveOrUpdate(game);
        }
        String dstFilename = "";
        for (String srcFilename : srcFilenames) {
            int j = game.getScreenshotCount();
            dstFilename = new File(Paths.getScreenshotPath().getDefault_rw(), FileTools.insertBeforeFileextension(game.getScreenshotFilename(), j == 0 ? "" : "_" + j)).getAbsolutePath();
            File srcFile = new File(dir, srcFilename);
            Const.log.info((Object)("Screenshot:" + srcFile.getAbsolutePath() + " => " + dstFilename));
            FileTools.copyFile(srcFile, new File(dstFilename));
            srcFile.delete();
        }
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String createId() {
        return String.valueOf(this.getName().toLowerCase()) + this.getId() + this.getClass();
    }

    @Override
    public int compareTo(Item other) {
        return this.createId().compareTo(other.createId());
    }

    public boolean equals(Object other) {
        if (other instanceof Game) {
            return this.createId().equals(((Game)other).createId());
        }
        return false;
    }

    public int hashCode() {
        return this.createId().hashCode();
    }

    private static int booleanToInt(boolean b) {
        if (b) {
            return 1;
        }
        return 0;
    }

    private static boolean intToBoolean(int i) {
        return i != 0;
    }
}

