/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.db.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Scanner;
import java.util.StringTokenizer;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.Icon;
import jgamebase.Const;
import jgamebase.db.Db;
import jgamebase.db.model.Item;
import jgamebase.db.model.Musician;
import jgamebase.gui.Gui;
import jgamebase.model.Databases;
import jgamebase.model.Emulator;
import jgamebase.model.Emulators;
import jgamebase.model.Paths;
import jgamebase.model.Plugins;
import jgamebase.plugins.MusicInfo;
import jgamebase.tools.FileTools;
import jgamebase.tools.ListerTools;
import jgamebase.tools.TempDir;

public class Music
implements Item {
    private static final long serialVersionUID = -9041851476859838451L;
    static boolean allowReadingInfoFromFile = false;
    private int id;
    private String filename;
    private String name;
    private Musician musician;
    private boolean isFavourite;
    private boolean fileExists;
    private boolean isAdult;
    private String publisherForDisplay = null;
    private String yearForDisplay = null;
    private String musicianForDisplay = null;

    public Music() {
    }

    public Music(String name, String filename) {
        this.setName(name);
        this.setFilename(filename);
        this.musician = Db.getMusicianById(38);
        this.fileExists = true;
    }

    public Music(int id) {
        this.id = id;
    }

    public static synchronized void setAllowReadingInfoFromFile(boolean allowReadingInfoFromFile) {
        Music.allowReadingInfoFromFile = allowReadingInfoFromFile;
    }

    @Override
    public String getFilename() {
        return Paths.backslashToSlash(this.filename);
    }

    public void setFilename(String filename) {
        this.filename = Paths.slashToBackslash(filename);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getStringId() {
        return "M" + this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public synchronized Musician getMusician() {
        return this.musician;
    }

    public synchronized void setMusician(Musician musician) {
        this.musician = musician;
        this.musicianForDisplay = null;
    }

    @Override
    public boolean getIsFavourite() {
        return this.isFavourite;
    }

    @Override
    public void setIsFavourite(boolean isFavourite) {
        this.isFavourite = isFavourite;
    }

    public boolean getFileExists() {
        return this.fileExists;
    }

    public void setFileExists(boolean fileExists) {
        this.fileExists = fileExists;
    }

    @Override
    public boolean getIsAdult() {
        return this.isAdult;
    }

    public void setIsAdult(boolean isAdult) {
        this.isAdult = isAdult;
    }

    @Override
    public Icon getIcon() {
        return Const.ICON_LIST_SIDONLY;
    }

    public String getPublisherForDisplay() {
        if (this.publisherForDisplay == null && allowReadingInfoFromFile) {
            this.tryToDetermineInfoFromFile();
        }
        if (this.publisherForDisplay == null || this.publisherForDisplay.isEmpty()) {
            return "(Unknown)";
        }
        return this.publisherForDisplay;
    }

    public String getYearForDisplay() {
        if (this.yearForDisplay == null && allowReadingInfoFromFile) {
            this.tryToDetermineInfoFromFile();
        }
        if (this.yearForDisplay == null || this.yearForDisplay.isEmpty()) {
            return "????";
        }
        return this.yearForDisplay;
    }

    public synchronized String getMusicianForDisplay() {
        if (this.musicianForDisplay != null && !this.musicianForDisplay.isEmpty()) {
            return this.musicianForDisplay;
        }
        if (this.musician != null && this.musician.getName() != null && !this.musician.getName().isEmpty() && this.musician.getId() != 38) {
            this.musicianForDisplay = this.musician.getName();
            if (!this.musician.getNickname().isEmpty()) {
                this.musicianForDisplay = String.valueOf(this.musicianForDisplay) + " '" + this.musician.getNickname() + "'";
            }
            if (!this.musician.getGroup().isEmpty()) {
                this.musicianForDisplay = String.valueOf(this.musicianForDisplay) + " of " + this.musician.getGroup();
            }
        }
        if (this.musicianForDisplay == null && allowReadingInfoFromFile) {
            this.tryToDetermineInfoFromFile();
        }
        if (this.musicianForDisplay == null || this.musicianForDisplay.isEmpty()) {
            return "(Unknown)";
        }
        return this.musicianForDisplay;
    }

    public void tryToDetermineInfoFromFile() {
        MusicInfo musicInfo = null;
        this.yearForDisplay = "";
        this.publisherForDisplay = "";
        this.musicianForDisplay = "";
        try {
            if (Plugins.existsMusicInfoForExtension(FileTools.getExtension(this.getFilename())) && (musicInfo = Plugins.getMusicInfoForExtension(FileTools.getExtension(this.getFilename()))) != null) {
                musicInfo.load(Paths.getMusicPath().find(new File(this.getFilename())));
                String copyright = musicInfo.getCopyright() == null ? "" : musicInfo.getCopyright().trim();
                String year = "";
                StringBuilder publisher = new StringBuilder();
                StringTokenizer st = new StringTokenizer(copyright);
                if (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    if (Character.isDigit(s.length() > 0 ? s.charAt(0) : (char)' ')) {
                        year = s;
                    } else {
                        publisher.append(s);
                    }
                }
                while (st.hasMoreTokens()) {
                    publisher.append(" ").append(st.nextToken());
                }
                this.publisherForDisplay = publisher.toString().trim();
                this.yearForDisplay = year.trim();
                if (this.musician == null || this.musician.getName() == null || this.musician.getName().isEmpty() || this.musician.getId() == 38) {
                    this.musicianForDisplay = musicInfo.getAuthor() == null ? "" : musicInfo.getAuthor().trim();
                }
            }
        }
        catch (IOException iOException) {}
    }

    @Override
    public void play() {
        Music.play(this, null, false);
    }

    public void play(boolean isAlreadyExtracted) {
        Music.play(this, null, isAlreadyExtracted);
    }

    public void play(Emulator emulator) {
        Music.play(this, emulator, false);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void play(Music music, Emulator emulator, boolean isAlreadyExtracted) {
        usePrefix = false;
        Const.log.info((Object)("PLAY MUSIC: " + music.getName() + " !"));
        namesOfSupportedFiles = new ArrayList<E>();
        fileToRun = filename = Paths.getMusicPath().findAndWarn(new File(music.getFilename())) != null ? Paths.getMusicPath().findAndWarn(new File(music.getFilename())).getPath() : "";
        if (Plugins.existsExtractorForExtension(FileTools.getExtension(filename))) {
            filename1 = filename;
            TempDir.cleanPath();
            FileTools.copyOrExtractToTempDir(filename1);
            extensions = emulator == null ? Emulators.getSupportedMusicExtensions() : emulator.getSupportedExtensions();
            namesOfSupportedFiles = extensions.getMatching(ListerTools.list_Dirs_Files_Paths(TempDir.getPath().getAbsolutePath(), false, true, true));
            if (namesOfSupportedFiles.isEmpty()) {
                namesOfSupportedFiles = extensions.getMatchingAsPrefix(ListerTools.list_Dirs_Files_Paths(TempDir.getPath().getAbsolutePath(), false, true, true));
                usePrefix = true;
            }
            if (namesOfSupportedFiles.isEmpty()) {
                Gui.displayErrorDialog("No playable file found for music '" + music.getName() + "'!");
                return;
            }
            fileToRun = (String)namesOfSupportedFiles.get(0);
        }
        Const.log.info((Object)("FileToRun: '" + fileToRun + "'."));
        if (fileToRun == null || fileToRun.isEmpty()) return;
        if (emulator == null && (emulator = Emulators.findMusicEmulatorForExtension(FileTools.getExtension(fileToRun))) == null) {
            emulator = Emulators.findMusicEmulatorForExtension(FileTools.getPrefix(fileToRun));
            usePrefix = true;
        }
        if (emulator != null) {
            Const.log.info((Object)("Using Emulator: '" + emulator.getName() + "'."));
            Databases.getCurrent().getPreferences().inc("about_music_played");
            namesOfSupportedFiles = usePrefix != false ? emulator.getSupportedExtensions().getMatchingAsPrefix(namesOfSupportedFiles) : emulator.getSupportedExtensions().getMatching(namesOfSupportedFiles);
            script = new File(new File(Databases.getCurrent().getPath(), "Scripts"), emulator.getCommand());
            if (script.exists()) {
                manager = new ScriptEngineManager();
                engine = manager.getEngineByExtension(FileTools.getExtension(emulator.getCommand()));
                if (engine == null) {
                    Const.log.info((Object)"Execution mode: BATCHSCRIPT");
                    script.setExecutable(true, false);
                    Emulators.executeMusic(new String[]{script.getAbsolutePath(), fileToRun});
                    return;
                }
                Const.log.info((Object)"Execution mode: SCRIPT");
                Const.log.info((Object)(String.valueOf(engine.getFactory().getLanguageName()) + " executed by " + engine.getFactory().getEngineName() + " " + engine.getFactory().getEngineVersion()));
                includesFilename = "includes." + FileTools.getExtension(emulator.getCommand());
                includesAsString = "";
                includesPathAndFilename = "";
                try {
                    bindings = engine.getBindings(100);
                    bindings.putAll((Map<? extends String, ? extends Object>)Emulators.setupEnvironment(music, fileToRun, 0, emulator, namesOfSupportedFiles, null));
                    engine.setBindings(bindings, 100);
                    includesPathAndFilename = new File(new File(Const.GBDIR_RO, "Includes"), includesFilename).getAbsolutePath();
                    if (new File(includesPathAndFilename).exists()) {
                        Const.log.info((Object)("Loading includes '" + includesPathAndFilename + "'."));
                        includesAsString = FileTools.readFileAsString(includesPathAndFilename);
                    }
                    if (!includesAsString.isEmpty()) {
                        includesAsString = String.valueOf(includesAsString) + Const.LINE_SEPARATOR;
                    }
                    scriptAsString = FileTools.readFileAsString(script.getAbsolutePath());
                    Const.log.info((Object)("Executing script '" + script.getAbsolutePath() + "'..."));
                    engine.eval(String.valueOf(includesAsString) + scriptAsString);
                    return;
                }
                catch (IOException v0) {
                    Const.log.error((Object)("The script '" + script.getAbsolutePath() + "' could not be loaded."));
                    return;
                }
                catch (ScriptException se) {
                    if (includesAsString.isEmpty()) return;
                    scanner = new Scanner(includesAsString);
                    scanner.useDelimiter("\r\n|[\n\r\u2028\u2029\u0085]");
                    includedLines = 0;
                    ** while (scanner.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    ++includedLines;
                    scanner.next();
                    continue;
                }
lbl72:
                // 1 sources

                Const.log.error((Object)se.getMessage());
                Const.log.error((Object)("IMPORTANT: When locating the error please bear in mind that an include of " + includedLines + " lines was added before your script:"));
                if (se.getLineNumber() <= includedLines) {
                    Const.log.error((Object)("So the error really occured at line " + se.getLineNumber() + " in the include '" + includesPathAndFilename + "' ."));
                } else {
                    Const.log.error((Object)("So the error really occured at line " + (se.getLineNumber() - includedLines) + " in the script '" + script.getAbsolutePath() + "' ."));
                }
                Const.log.error((Object)"");
                return;
            }
            Const.log.info((Object)"Execution mode: EXECUTABLE");
            Emulators.executeMusic(new String[]{emulator.getCommand(), fileToRun});
            return;
        }
        Gui.displayErrorDialog("No Music Emulator found for " + (usePrefix != false ? "prefix '" + FileTools.getPrefix(fileToRun) : "extension '" + FileTools.getExtension(fileToRun)) + "'.");
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String createId() {
        return String.valueOf(this.getName().toLowerCase()) + this.getId() + this.getClass();
    }

    @Override
    public int compareTo(Item other) {
        return this.createId().compareTo(other.createId());
    }

    public boolean equals(Object other) {
        if (other instanceof Music) {
            return this.createId().equals(((Music)other).createId());
        }
        return false;
    }

    public int hashCode() {
        return this.createId().hashCode();
    }
}

