/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;
import jgamebase.Const;
import jgamebase.gui.ColumnHeader;
import jgamebase.gui.ListListMethods;
import jgamebase.gui.ListListModel;

public class ColumnsDialog
extends JDialog {
    private static final long serialVersionUID = 3242124579733208443L;
    private Const.CloseAction closeAction = Const.CloseAction.CANCEL;
    private JList hiddenColumnsList;
    private JList visibleColumnsList;

    public ColumnsDialog(List<TableColumn> visibleTableColumns) {
        this.initComponents();
        List<String> visibleColumnNames = this.getVisibleColumnNames(visibleTableColumns);
        this.visibleColumnsList.setModel(new ListListModel(visibleColumnNames));
        this.hiddenColumnsList.setModel(new ListListModel(this.getHiddenColumnNames(visibleColumnNames)));
        ListListMethods.sort(this.hiddenColumnsList);
        this.setSize(320, 480);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public List<String> getVisibleColumnNames(List<TableColumn> visibleTableColumns) {
        ArrayList<String> visibleColumnNames = new ArrayList<String>();
        visibleTableColumns.forEach(column -> {
            boolean bl = visibleColumnNames.add((String)column.getHeaderValue());
        });
        return visibleColumnNames;
    }

    private List<String> getHiddenColumnNames(List<String> visibleColumnNames) {
        List<String> hiddenColumnNames = ColumnHeader.getNames();
        hiddenColumnNames.removeAll(visibleColumnNames);
        return hiddenColumnNames;
    }

    private void initComponents() {
        JPanel mainPanel = new JPanel();
        JLabel visibleColumnsLabel = new JLabel();
        JScrollPane visibleColumnsScrollPane = new JScrollPane();
        this.visibleColumnsList = new JList();
        JButton selectedVisibleColumnDownButton = new JButton();
        JButton selectedVisibleColumnUpButton = new JButton();
        JButton showSelectedColumnButton = new JButton();
        JButton showAllColumnsButton = new JButton();
        JButton hideAllColumnsButton = new JButton();
        JButton hideSelectedColumnButton = new JButton();
        JLabel hiddenColumnsLabel = new JLabel();
        JScrollPane hiddenColumnsScrollPane = new JScrollPane();
        this.hiddenColumnsList = new JList();
        JPanel OkCancelPanel = new JPanel();
        JPanel jPanel9 = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        this.setTitle("Configure Table Columns");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ColumnsDialog.this.exitFormWindowClosing(evt);
            }
        });
        mainPanel.setLayout(new GridBagLayout());
        visibleColumnsLabel.setText("Visible Columns");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        mainPanel.add((Component)visibleColumnsLabel, gridBagConstraints);
        visibleColumnsScrollPane.setHorizontalScrollBarPolicy(31);
        this.visibleColumnsList.setSelectionMode(0);
        this.visibleColumnsList.setPreferredSize(new Dimension(140, 425));
        visibleColumnsScrollPane.setViewportView(this.visibleColumnsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        mainPanel.add((Component)visibleColumnsScrollPane, gridBagConstraints);
        selectedVisibleColumnDownButton.setText("\u25bc");
        selectedVisibleColumnDownButton.setMargin(new Insets(2, 2, 2, 2));
        selectedVisibleColumnDownButton.setMaximumSize(new Dimension(32, 32));
        selectedVisibleColumnDownButton.setMinimumSize(new Dimension(32, 32));
        selectedVisibleColumnDownButton.setPreferredSize(new Dimension(32, 32));
        selectedVisibleColumnDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnsDialog.this.selectedVisibleColumnDown_ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 0, 5, 10);
        mainPanel.add((Component)selectedVisibleColumnDownButton, gridBagConstraints);
        selectedVisibleColumnUpButton.setText("\u25b2");
        selectedVisibleColumnUpButton.setMargin(new Insets(2, 2, 2, 2));
        selectedVisibleColumnUpButton.setMaximumSize(new Dimension(32, 32));
        selectedVisibleColumnUpButton.setMinimumSize(new Dimension(32, 32));
        selectedVisibleColumnUpButton.setPreferredSize(new Dimension(32, 32));
        selectedVisibleColumnUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnsDialog.this.selectedVisibleColumnUp_ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        mainPanel.add((Component)selectedVisibleColumnUpButton, gridBagConstraints);
        showSelectedColumnButton.setText("\u25c0");
        showSelectedColumnButton.setMargin(new Insets(2, 2, 2, 2));
        showSelectedColumnButton.setMaximumSize(new Dimension(36, 36));
        showSelectedColumnButton.setMinimumSize(new Dimension(36, 36));
        showSelectedColumnButton.setPreferredSize(new Dimension(36, 36));
        showSelectedColumnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnsDialog.this.showSelectedColumn_ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        mainPanel.add((Component)showSelectedColumnButton, gridBagConstraints);
        showAllColumnsButton.setText("\u25c0\u25c0");
        showAllColumnsButton.setMargin(new Insets(2, 2, 2, 2));
        showAllColumnsButton.setMaximumSize(new Dimension(36, 36));
        showAllColumnsButton.setMinimumSize(new Dimension(36, 36));
        showAllColumnsButton.setPreferredSize(new Dimension(36, 36));
        showAllColumnsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnsDialog.this.showAllColumns_ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.insets = new Insets(10, 5, 25, 5);
        mainPanel.add((Component)showAllColumnsButton, gridBagConstraints);
        hideAllColumnsButton.setText("\u25b6\u25b6");
        hideAllColumnsButton.setMargin(new Insets(2, 2, 2, 2));
        hideAllColumnsButton.setMaximumSize(new Dimension(36, 36));
        hideAllColumnsButton.setMinimumSize(new Dimension(36, 36));
        hideAllColumnsButton.setPreferredSize(new Dimension(36, 36));
        hideAllColumnsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnsDialog.this.hideAllColumns_ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.insets = new Insets(25, 5, 10, 5);
        mainPanel.add((Component)hideAllColumnsButton, gridBagConstraints);
        hideSelectedColumnButton.setText("\u25b6");
        hideSelectedColumnButton.setMargin(new Insets(2, 2, 2, 2));
        hideSelectedColumnButton.setMaximumSize(new Dimension(36, 36));
        hideSelectedColumnButton.setMinimumSize(new Dimension(36, 36));
        hideSelectedColumnButton.setPreferredSize(new Dimension(36, 36));
        hideSelectedColumnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnsDialog.this.hideSelectedColumn_ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        mainPanel.add((Component)hideSelectedColumnButton, gridBagConstraints);
        hiddenColumnsLabel.setText("Hidden Columns");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        mainPanel.add((Component)hiddenColumnsLabel, gridBagConstraints);
        hiddenColumnsScrollPane.setHorizontalScrollBarPolicy(31);
        this.hiddenColumnsList.setSelectionMode(0);
        this.hiddenColumnsList.setPreferredSize(new Dimension(140, 640));
        hiddenColumnsScrollPane.setViewportView(this.hiddenColumnsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        mainPanel.add((Component)hiddenColumnsScrollPane, gridBagConstraints);
        this.getContentPane().add((Component)mainPanel, "Center");
        OkCancelPanel.setLayout(new BorderLayout());
        jPanel9.setLayout(new FlowLayout(2));
        okButton.setMnemonic('O');
        okButton.setText("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnsDialog.this.okActionPerformed(evt);
            }
        });
        jPanel9.add(okButton);
        cancelButton.setMnemonic('C');
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnsDialog.this.cancelActionPerformed(evt);
            }
        });
        jPanel9.add(cancelButton);
        OkCancelPanel.add((Component)jPanel9, "South");
        this.getContentPane().add((Component)OkCancelPanel, "South");
        this.pack();
    }

    private void hideSelectedColumn_ActionPerformed(ActionEvent evt) {
        ListListMethods.moveSelected(this.visibleColumnsList, this.hiddenColumnsList);
        ListListMethods.sort(this.hiddenColumnsList);
    }

    private void hideAllColumns_ActionPerformed(ActionEvent evt) {
        ListListMethods.moveAll(this.visibleColumnsList, this.hiddenColumnsList);
        ListListMethods.sort(this.hiddenColumnsList);
    }

    private void showAllColumns_ActionPerformed(ActionEvent evt) {
        ListListMethods.moveAll(this.hiddenColumnsList, this.visibleColumnsList);
    }

    private void showSelectedColumn_ActionPerformed(ActionEvent evt) {
        ListListMethods.moveSelected(this.hiddenColumnsList, this.visibleColumnsList);
    }

    private void selectedVisibleColumnUp_ActionPerformed(ActionEvent evt) {
        ListListMethods.moveSelectedUp(this.visibleColumnsList);
    }

    private void selectedVisibleColumnDown_ActionPerformed(ActionEvent evt) {
        ListListMethods.moveSelectedDown(this.visibleColumnsList);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeAction = Const.CloseAction.CANCEL;
        this.setVisible(false);
    }

    private void okActionPerformed(ActionEvent evt) {
        this.closeAction = Const.CloseAction.OK;
        this.setVisible(false);
    }

    private void exitFormWindowClosing(WindowEvent evt) {
        this.closeAction = Const.CloseAction.CANCEL;
        this.setVisible(false);
    }

    public Const.CloseAction getCloseAction() {
        return this.closeAction;
    }

    public List<String> getVisibleColumns() {
        return ListListModel.get(this.visibleColumnsList);
    }
}

