/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jgamebase.Const;
import jgamebase.JGameBase;
import jgamebase.gui.Gui;
import jgamebase.gui.ListListMethods;
import jgamebase.gui.ListListModel;
import jgamebase.model.Paths;
import jgamebase.tools.ListerTools;
import jgamebase.tools.StringTools;

public class PathsDialog
extends JDialog {
    private static final long serialVersionUID = 4374804155028317874L;
    protected JList extraPathsList;
    protected JList gamePathsList;
    protected JList musicPathsList;
    protected JTextField pathField;
    protected JLabel pathLabel;
    protected JPanel pathPanel;
    protected JList photoPathsList;
    protected JList screenshotPathsList;

    public PathsDialog() {
        this.initComponents();
        this.setVisible(true);
    }

    private void initComponents() {
        this.pathPanel = new JPanel();
        this.pathLabel = new JLabel();
        this.pathField = new JTextField();
        JButton pathButton = new JButton();
        JTabbedPane pathPane = new JTabbedPane();
        Gui.fixLookAndFeel(pathPane);
        JPanel gamePaths = new JPanel();
        JPanel gamePathsPanel = new JPanel();
        JButton gamePathsAddButton = new JButton();
        JButton gamePathsRemoveButton = new JButton();
        JButton gamePathsUpButton = new JButton();
        JButton gamePathsDownButton = new JButton();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.gamePathsList = new JList();
        JPanel gameDefaultPanel = new JPanel();
        JLabel gamePathsDefaultRWLabel = new JLabel();
        JLabel gamePathsDefaultROLabel = new JLabel();
        JPanel musicPaths = new JPanel();
        JPanel musicPathsPanel = new JPanel();
        JButton musicPathsAddButton = new JButton();
        JButton musicPathsRemoveButton = new JButton();
        JButton musicPathsUpButton = new JButton();
        JButton musicPathsDownButton = new JButton();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.musicPathsList = new JList();
        JPanel musicDefaultPanel = new JPanel();
        JLabel musicPathsDefaultRWLabel = new JLabel();
        JLabel musicPathsDefaultROLabel = new JLabel();
        JPanel screenshotPaths = new JPanel();
        JPanel screenshotPathsPanel = new JPanel();
        JButton screenshotPathsAddButton = new JButton();
        JButton screenshotPathsRemoveButton = new JButton();
        JButton screenshotPathsUpButton = new JButton();
        JButton screenshotPathsDownButton = new JButton();
        JScrollPane jScrollPane3 = new JScrollPane();
        this.screenshotPathsList = new JList();
        JPanel screenshotDefaultPanel = new JPanel();
        JLabel screenshotPathsDefaultRWLabel = new JLabel();
        JLabel screenshotPathsDefaultROLabel = new JLabel();
        JPanel extraPaths = new JPanel();
        JPanel extraPathsPanel = new JPanel();
        JButton extraPathsAddButton = new JButton();
        JButton extraPathsRemoveButton = new JButton();
        JButton extraPathsUpButton = new JButton();
        JButton extraPathsDownButton = new JButton();
        JScrollPane jScrollPane4 = new JScrollPane();
        this.extraPathsList = new JList();
        JPanel extraDefaultPanel = new JPanel();
        JLabel extraPathsDefaultRWLabel = new JLabel();
        JLabel extraPathsDefaultROLabel = new JLabel();
        JPanel photoPaths = new JPanel();
        JPanel photoPathsPanel = new JPanel();
        JButton photoPathsAddButton = new JButton();
        JButton photoPathsRemoveButton = new JButton();
        JButton photoPathsUpButton = new JButton();
        JButton photoPathsDownButton = new JButton();
        JScrollPane jScrollPane5 = new JScrollPane();
        this.photoPathsList = new JList();
        JPanel photoDefaultPanel = new JPanel();
        JLabel photoPathsDefaultRWLabel = new JLabel();
        JLabel photoPathsDefaultROLabel = new JLabel();
        JPanel OkCancelPanel = new JPanel();
        JPanel jPanel9 = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        this.pathPanel.setLayout(new GridBagLayout());
        this.pathLabel.setText("Path:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.5;
        this.pathPanel.add((Component)this.pathLabel, gridBagConstraints);
        this.pathField.setMinimumSize(new Dimension(320, 20));
        this.pathField.setPreferredSize(new Dimension(320, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.pathPanel.add((Component)this.pathField, gridBagConstraints);
        pathButton.setText("...");
        pathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setFileSelectionMode(1);
                    if (!PathsDialog.this.pathField.getText().equals("")) {
                        fileChooser.setCurrentDirectory(new File(PathsDialog.this.pathField.getText()));
                    }
                    if (fileChooser.showOpenDialog(null) == 0) {
                        PathsDialog.this.pathField.setText(fileChooser.getSelectedFile().getPath());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.pathPanel.add((Component)pathButton, gridBagConstraints);
        this.setTitle("Paths");
        this.setMinimumSize(new Dimension(400, 280));
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PathsDialog.this.exitFormWindowClosing(evt);
            }
        });
        gamePaths.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        gamePaths.setLayout(new BorderLayout());
        gamePathsPanel.setLayout(new FlowLayout(0));
        gamePathsAddButton.setToolTipText("Add new path.");
        gamePathsAddButton.setBorder(null);
        gamePathsAddButton.setIcon(Const.ICON_PATHSELECTOR_ADD);
        gamePathsAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsDialog.this.gamePathsAddActionPerformed(evt);
            }
        });
        gamePathsPanel.add(gamePathsAddButton);
        gamePathsRemoveButton.setToolTipText("Remove selected path.");
        gamePathsRemoveButton.setBorder(null);
        gamePathsRemoveButton.setIcon(Const.ICON_PATHSELECTOR_REMOVE);
        gamePathsRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsDialog.this.gamePathsRemoveActionPerformed(evt);
            }
        });
        gamePathsPanel.add(gamePathsRemoveButton);
        gamePathsUpButton.setToolTipText("Move selected path up.");
        gamePathsUpButton.setBorder(null);
        gamePathsUpButton.setIcon(Const.ICON_PATHSELECTOR_UP);
        gamePathsUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsDialog.this.gamePathsUpActionPerformed(evt);
            }
        });
        gamePathsPanel.add(gamePathsUpButton);
        gamePathsDownButton.setToolTipText("Move selected path down.");
        gamePathsDownButton.setBorder(null);
        gamePathsDownButton.setIcon(Const.ICON_PATHSELECTOR_DOWN);
        gamePathsDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsDialog.this.gamePathsDownActionPerformed(evt);
            }
        });
        gamePathsPanel.add(gamePathsDownButton);
        gamePaths.add((Component)gamePathsPanel, "North");
        this.gamePathsList.setModel(new ListListModel(ListerTools.fileListToStringList(Paths.getGamePath().get())));
        this.gamePathsList.setSelectionMode(0);
        if (this.gamePathsList.getModel().getSize() > 0) {
            this.gamePathsList.setSelectedIndex(0);
        }
        this.gamePathsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PathsDialog.this.gamePathsListMouseClicked(evt);
            }
        });
        jScrollPane1.setViewportView(this.gamePathsList);
        gamePaths.add((Component)jScrollPane1, "Center");
        gameDefaultPanel.setLayout(new GridLayout(2, 1));
        if (Const.FHS) {
            gamePathsDefaultRWLabel.setToolTipText("The writable default path.");
        } else {
            gamePathsDefaultRWLabel.setToolTipText("The default path.");
        }
        gamePathsDefaultRWLabel.setText(Paths.getGamePath().getDefault_rw().toString());
        gameDefaultPanel.add(gamePathsDefaultRWLabel);
        if (Const.FHS) {
            gamePathsDefaultROLabel.setToolTipText("The read-only default path.");
            gamePathsDefaultROLabel.setText(Paths.getGamePath().getDefault_ro().toString());
        }
        gameDefaultPanel.add(gamePathsDefaultROLabel);
        gamePaths.add((Component)gameDefaultPanel, "South");
        pathPane.addTab("Games", gamePaths);
        musicPaths.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        musicPaths.setLayout(new BorderLayout());
        musicPathsPanel.setLayout(new FlowLayout(0));
        musicPathsAddButton.setToolTipText("Add new path.");
        musicPathsAddButton.setBorder(null);
        musicPathsAddButton.setIcon(Const.ICON_PATHSELECTOR_ADD);
        musicPathsAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsDialog.this.musicPathsAddActionPerformed(evt);
            }
        });
        musicPathsPanel.add(musicPathsAddButton);
        musicPathsRemoveButton.setToolTipText("Remove selected path.");
        musicPathsRemoveButton.setBorder(null);
        musicPathsRemoveButton.setIcon(Const.ICON_PATHSELECTOR_REMOVE);
        musicPathsRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsDialog.this.musicPathsRemoveActionPerformed(evt);
            }
        });
        musicPathsPanel.add(musicPathsRemoveButton);
        musicPathsUpButton.setToolTipText("Move selected path up.");
        musicPathsUpButton.setBorder(null);
        musicPathsUpButton.setIcon(Const.ICON_PATHSELECTOR_UP);
        musicPathsUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsDialog.this.musicPathsUpActionPerformed(evt);
            }
        });
        musicPathsPanel.add(musicPathsUpButton);
        musicPathsDownButton.setToolTipText("Move selected path down.");
        musicPathsDownButton.setBorder(null);
        musicPathsDownButton.setIcon(Const.ICON_PATHSELECTOR_DOWN);
        musicPathsDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsDialog.this.musicPathsDownActionPerformed(evt);
            }
        });
        musicPathsPanel.add(musicPathsDownButton);
        musicPaths.add((Component)musicPathsPanel, "North");
        this.musicPathsList.setModel(new ListListModel(ListerTools.fileListToStringList(Paths.getMusicPath().get())));
        this.musicPathsList.setSelectionMode(0);
        if (this.musicPathsList.getModel().getSize() > 0) {
            this.musicPathsList.setSelectedIndex(0);
        }
        this.musicPathsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PathsDialog.this.musicPathsListMouseClicked(evt);
            }
        });
        jScrollPane2.setViewportView(this.musicPathsList);
        musicPaths.add((Component)jScrollPane2, "Center");
        musicDefaultPanel.setLayout(new GridLayout(2, 1));
        if (Const.FHS) {
            musicPathsDefaultRWLabel.setToolTipText("The writable default path.");
        } else {
            musicPathsDefaultRWLabel.setToolTipText("The default path.");
        }
        musicPathsDefaultRWLabel.setText(Paths.getMusicPath().getDefault_rw().toString());
        musicDefaultPanel.add(musicPathsDefaultRWLabel);
        if (Const.FHS) {
            musicPathsDefaultROLabel.setToolTipText("The read-only default path.");
            musicPathsDefaultROLabel.setText(Paths.getMusicPath().getDefault_ro().toString());
        }
        musicDefaultPanel.add(musicPathsDefaultROLabel);
        musicPaths.add((Component)musicDefaultPanel, "South");
        pathPane.addTab("Music", musicPaths);
        screenshotPaths.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        screenshotPaths.setLayout(new BorderLayout());
        screenshotPathsPanel.setLayout(new FlowLayout(0));
        screenshotPathsAddButton.setToolTipText("Add new path.");
        screenshotPathsAddButton.setBorder(null);
        screenshotPathsAddButton.setIcon(Const.ICON_PATHSELECTOR_ADD);
        screenshotPathsAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsDialog.this.screenshotPathsAddActionPerformed(evt);
            }
        });
        screenshotPathsPanel.add(screenshotPathsAddButton);
        screenshotPathsRemoveButton.setToolTipText("Remove selected path.");
        screenshotPathsRemoveButton.setBorder(null);
        screenshotPathsRemoveButton.setIcon(Const.ICON_PATHSELECTOR_REMOVE);
        screenshotPathsRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsDialog.this.screenshotPathsRemoveActionPerformed(evt);
            }
        });
        screenshotPathsPanel.add(screenshotPathsRemoveButton);
        screenshotPathsUpButton.setToolTipText("Move selected path up.");
        screenshotPathsUpButton.setBorder(null);
        screenshotPathsUpButton.setIcon(Const.ICON_PATHSELECTOR_UP);
        screenshotPathsUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsDialog.this.screenshotPathsUpActionPerformed(evt);
            }
        });
        screenshotPathsPanel.add(screenshotPathsUpButton);
        screenshotPathsDownButton.setToolTipText("Move selected path down.");
        screenshotPathsDownButton.setBorder(null);
        screenshotPathsDownButton.setIcon(Const.ICON_PATHSELECTOR_DOWN);
        screenshotPathsDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsDialog.this.screenshotPathsDownActionPerformed(evt);
            }
        });
        screenshotPathsPanel.add(screenshotPathsDownButton);
        screenshotPaths.add((Component)screenshotPathsPanel, "North");
        this.screenshotPathsList.setModel(new ListListModel(ListerTools.fileListToStringList(Paths.getScreenshotPath().get())));
        this.screenshotPathsList.setSelectionMode(0);
        this.screenshotPathsList.setMinimumSize(new Dimension(400, 100));
        if (this.screenshotPathsList.getModel().getSize() > 0) {
            this.screenshotPathsList.setSelectedIndex(0);
        }
        this.screenshotPathsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PathsDialog.this.screenshotPathsListMouseClicked(evt);
            }
        });
        jScrollPane3.setViewportView(this.screenshotPathsList);
        screenshotPaths.add((Component)jScrollPane3, "Center");
        screenshotDefaultPanel.setLayout(new GridLayout(2, 1));
        if (Const.FHS) {
            screenshotPathsDefaultRWLabel.setToolTipText("The writable default path.");
        } else {
            screenshotPathsDefaultRWLabel.setToolTipText("The default path.");
        }
        screenshotPathsDefaultRWLabel.setText(Paths.getScreenshotPath().getDefault_rw().toString());
        screenshotDefaultPanel.add(screenshotPathsDefaultRWLabel);
        if (Const.FHS) {
            screenshotPathsDefaultROLabel.setToolTipText("The read-only default path.");
            screenshotPathsDefaultROLabel.setText(Paths.getScreenshotPath().getDefault_ro().toString());
        }
        screenshotDefaultPanel.add(screenshotPathsDefaultROLabel);
        screenshotPaths.add((Component)screenshotDefaultPanel, "South");
        pathPane.addTab("Screenshots", screenshotPaths);
        extraPaths.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        extraPaths.setLayout(new BorderLayout());
        extraPathsPanel.setLayout(new FlowLayout(0));
        extraPathsAddButton.setToolTipText("Add new path.");
        extraPathsAddButton.setBorder(null);
        extraPathsAddButton.setIcon(Const.ICON_PATHSELECTOR_ADD);
        extraPathsAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsDialog.this.extraPathsAddActionPerformed(evt);
            }
        });
        extraPathsPanel.add(extraPathsAddButton);
        extraPathsRemoveButton.setIcon(Const.ICON_PATHSELECTOR_REMOVE);
        extraPathsRemoveButton.setToolTipText("Remove selected path.");
        extraPathsRemoveButton.setBorder(null);
        extraPathsRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsDialog.this.extraPathsRemoveActionPerformed(evt);
            }
        });
        extraPathsPanel.add(extraPathsRemoveButton);
        extraPathsUpButton.setToolTipText("Move selected path up.");
        extraPathsUpButton.setBorder(null);
        extraPathsUpButton.setIcon(Const.ICON_PATHSELECTOR_UP);
        extraPathsUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsDialog.this.extraPathsUpActionPerformed(evt);
            }
        });
        extraPathsPanel.add(extraPathsUpButton);
        extraPathsDownButton.setToolTipText("Move selected path down.");
        extraPathsDownButton.setBorder(null);
        extraPathsDownButton.setIcon(Const.ICON_PATHSELECTOR_DOWN);
        extraPathsDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsDialog.this.extraPathsDownActionPerformed(evt);
            }
        });
        extraPathsPanel.add(extraPathsDownButton);
        extraPaths.add((Component)extraPathsPanel, "North");
        this.extraPathsList.setModel(new ListListModel(ListerTools.fileListToStringList(Paths.getExtraPath().get())));
        this.extraPathsList.setSelectionMode(0);
        if (this.extraPathsList.getModel().getSize() > 0) {
            this.extraPathsList.setSelectedIndex(0);
        }
        this.extraPathsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PathsDialog.this.extraPathsListMouseClicked(evt);
            }
        });
        jScrollPane4.setViewportView(this.extraPathsList);
        extraPaths.add((Component)jScrollPane4, "Center");
        extraDefaultPanel.setLayout(new GridLayout(2, 1));
        if (Const.FHS) {
            extraPathsDefaultRWLabel.setToolTipText("The writable default path.");
        } else {
            extraPathsDefaultRWLabel.setToolTipText("The default path.");
        }
        extraPathsDefaultRWLabel.setText(Paths.getExtraPath().getDefault_rw().toString());
        extraDefaultPanel.add(extraPathsDefaultRWLabel);
        if (Const.FHS) {
            extraPathsDefaultROLabel.setToolTipText("The read-only default path.");
            extraPathsDefaultROLabel.setText(Paths.getExtraPath().getDefault_ro().toString());
        }
        extraDefaultPanel.add(extraPathsDefaultROLabel);
        extraPaths.add((Component)extraDefaultPanel, "South");
        pathPane.addTab("Extras", extraPaths);
        photoPaths.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        photoPaths.setLayout(new BorderLayout());
        photoPathsPanel.setLayout(new FlowLayout(0));
        photoPathsAddButton.setToolTipText("Add new path.");
        photoPathsAddButton.setBorder(null);
        photoPathsAddButton.setIcon(Const.ICON_PATHSELECTOR_ADD);
        photoPathsAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsDialog.this.photoPathsAddActionPerformed(evt);
            }
        });
        photoPathsPanel.add(photoPathsAddButton);
        photoPathsRemoveButton.setToolTipText("Remove selected path.");
        photoPathsRemoveButton.setBorder(null);
        photoPathsRemoveButton.setIcon(Const.ICON_PATHSELECTOR_REMOVE);
        photoPathsRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsDialog.this.photoPathsRemoveActionPerformed(evt);
            }
        });
        photoPathsPanel.add(photoPathsRemoveButton);
        photoPathsUpButton.setToolTipText("Move selected path up.");
        photoPathsUpButton.setBorder(null);
        photoPathsUpButton.setIcon(Const.ICON_PATHSELECTOR_UP);
        photoPathsUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsDialog.this.photoPathsUpActionPerformed(evt);
            }
        });
        photoPathsPanel.add(photoPathsUpButton);
        photoPathsDownButton.setToolTipText("Move selected path down.");
        photoPathsDownButton.setBorder(null);
        photoPathsDownButton.setIcon(Const.ICON_PATHSELECTOR_DOWN);
        photoPathsDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsDialog.this.photoPathsDownActionPerformed(evt);
            }
        });
        photoPathsPanel.add(photoPathsDownButton);
        photoPaths.add((Component)photoPathsPanel, "North");
        this.photoPathsList.setModel(new ListListModel(ListerTools.fileListToStringList(Paths.getPhotoPath().get())));
        this.photoPathsList.setSelectionMode(0);
        if (this.photoPathsList.getModel().getSize() > 0) {
            this.photoPathsList.setSelectedIndex(0);
        }
        this.photoPathsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PathsDialog.this.photoPathsListMouseClicked(evt);
            }
        });
        jScrollPane5.setViewportView(this.photoPathsList);
        photoPaths.add((Component)jScrollPane5, "Center");
        photoDefaultPanel.setLayout(new GridLayout(2, 1));
        if (Const.FHS) {
            photoPathsDefaultRWLabel.setToolTipText("The writable default path.");
        } else {
            photoPathsDefaultRWLabel.setToolTipText("The default path.");
        }
        photoPathsDefaultRWLabel.setText(Paths.getPhotoPath().getDefault_rw().toString());
        photoDefaultPanel.add(photoPathsDefaultRWLabel);
        if (Const.FHS) {
            photoPathsDefaultROLabel.setToolTipText("The read-only default path.");
            photoPathsDefaultROLabel.setText(Paths.getPhotoPath().getDefault_ro().toString());
        }
        photoDefaultPanel.add(photoPathsDefaultROLabel);
        photoPaths.add((Component)photoDefaultPanel, "South");
        pathPane.addTab("Photos", photoPaths);
        this.getContentPane().add((Component)pathPane, "Center");
        OkCancelPanel.setLayout(new BorderLayout());
        jPanel9.setLayout(new FlowLayout(2));
        okButton.setMnemonic('O');
        okButton.setText("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsDialog.this.okActionPerformed(evt);
            }
        });
        jPanel9.add(okButton);
        cancelButton.setMnemonic('C');
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathsDialog.this.cancelActionPerformed(evt);
            }
        });
        jPanel9.add(cancelButton);
        OkCancelPanel.add((Component)jPanel9, "South");
        this.getContentPane().add((Component)OkCancelPanel, "South");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void musicPathsAddActionPerformed(ActionEvent evt) {
        this.addPath(this.musicPathsList, "music");
    }

    private void musicPathsRemoveActionPerformed(ActionEvent evt) {
        ListListMethods.removeSelected(this.musicPathsList);
    }

    private void musicPathsUpActionPerformed(ActionEvent evt) {
        ListListMethods.moveSelectedUp(this.musicPathsList);
    }

    private void musicPathsDownActionPerformed(ActionEvent evt) {
        ListListMethods.moveSelectedDown(this.musicPathsList);
    }

    private void musicPathsListMouseClicked(MouseEvent evt) {
        if (Gui.doubleClick(evt)) {
            this.editPath(this.musicPathsList, "music");
        }
    }

    private void photoPathsAddActionPerformed(ActionEvent evt) {
        this.addPath(this.photoPathsList, "photo");
    }

    private void photoPathsRemoveActionPerformed(ActionEvent evt) {
        ListListMethods.removeSelected(this.photoPathsList);
    }

    private void photoPathsUpActionPerformed(ActionEvent evt) {
        ListListMethods.moveSelectedUp(this.photoPathsList);
    }

    private void photoPathsDownActionPerformed(ActionEvent evt) {
        ListListMethods.moveSelectedDown(this.photoPathsList);
    }

    private void photoPathsListMouseClicked(MouseEvent evt) {
        if (Gui.doubleClick(evt)) {
            this.editPath(this.photoPathsList, "photo");
        }
    }

    private void extraPathsListMouseClicked(MouseEvent evt) {
        if (Gui.doubleClick(evt)) {
            this.editPath(this.extraPathsList, "extra");
        }
    }

    private void extraPathsDownActionPerformed(ActionEvent evt) {
        ListListMethods.moveSelectedDown(this.extraPathsList);
    }

    private void extraPathsUpActionPerformed(ActionEvent evt) {
        ListListMethods.moveSelectedUp(this.extraPathsList);
    }

    private void extraPathsRemoveActionPerformed(ActionEvent evt) {
        ListListMethods.removeSelected(this.extraPathsList);
    }

    private void extraPathsAddActionPerformed(ActionEvent evt) {
        this.addPath(this.extraPathsList, "extra");
    }

    private void screenshotPathsListMouseClicked(MouseEvent evt) {
        if (Gui.doubleClick(evt)) {
            this.editPath(this.screenshotPathsList, "screenshot");
        }
    }

    private void screenshotPathsDownActionPerformed(ActionEvent evt) {
        ListListMethods.moveSelectedDown(this.screenshotPathsList);
    }

    private void screenshotPathsUpActionPerformed(ActionEvent evt) {
        ListListMethods.moveSelectedUp(this.screenshotPathsList);
    }

    private void screenshotPathsRemoveActionPerformed(ActionEvent evt) {
        ListListMethods.removeSelected(this.screenshotPathsList);
    }

    private void screenshotPathsAddActionPerformed(ActionEvent evt) {
        this.addPath(this.screenshotPathsList, "screenshot");
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okActionPerformed(ActionEvent evt) {
        Paths.getGamePath().set(ListerTools.stringListToFileList(((ListListModel)this.gamePathsList.getModel()).get()));
        Paths.getMusicPath().set(ListerTools.stringListToFileList(((ListListModel)this.musicPathsList.getModel()).get()));
        Paths.getScreenshotPath().set(ListerTools.stringListToFileList(((ListListModel)this.screenshotPathsList.getModel()).get()));
        Paths.getExtraPath().set(ListerTools.stringListToFileList(((ListListModel)this.extraPathsList.getModel()).get()));
        Paths.getPhotoPath().set(ListerTools.stringListToFileList(((ListListModel)this.photoPathsList.getModel()).get()));
        Paths.writeToIniFile();
        this.dispose();
    }

    private void gamePathsDownActionPerformed(ActionEvent evt) {
        ListListMethods.moveSelectedDown(this.gamePathsList);
    }

    private void gamePathsUpActionPerformed(ActionEvent evt) {
        ListListMethods.moveSelectedUp(this.gamePathsList);
    }

    private void gamePathsRemoveActionPerformed(ActionEvent evt) {
        ListListMethods.removeSelected(this.gamePathsList);
    }

    private void gamePathsListMouseClicked(MouseEvent evt) {
        if (Gui.doubleClick(evt)) {
            this.editPath(this.gamePathsList, "game");
        }
    }

    private void editPath(JList list, String name) {
        int row = list.getSelectedIndex();
        if (row >= 0 && row < list.getModel().getSize()) {
            this.pathLabel.setText(String.valueOf(StringTools.startWithUpperCase(name)) + " path:");
            this.pathField.setText((String)list.getSelectedValue());
            if (JOptionPane.showOptionDialog(JGameBase.getGui(), this.pathPanel, "Edit " + name + " path", 2, 3, null, null, null) == 0) {
                ((ListListModel)list.getModel()).set(row, this.pathField.getText());
            }
        }
    }

    private void gamePathsAddActionPerformed(ActionEvent evt) {
        this.addPath(this.gamePathsList, "game");
    }

    private void addPath(JList list, String name) {
        this.pathLabel.setText(String.valueOf(StringTools.startWithUpperCase(name)) + " path:");
        this.pathField.setText("");
        if (JOptionPane.showOptionDialog(JGameBase.getGui(), this.pathPanel, "Add " + name + " path", 2, 3, null, null, null) == 0) {
            ((ListListModel)list.getModel()).addElement(this.pathField.getText());
        }
    }

    private void exitFormWindowClosing(WindowEvent evt) {
        this.dispose();
    }
}

