/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jgamebase.Const;
import jgamebase.db.Db;
import jgamebase.db.model.Game;
import jgamebase.db.model.Item;
import jgamebase.db.model.ItemViewFilter;
import jgamebase.db.model.Selection;
import jgamebase.gui.Gui;

public class PersonalInfoDialog
extends JDialog {
    private static final long serialVersionUID = 2138642841415232777L;
    List<Item> list;
    Game game;
    boolean isList;
    private JCheckBox adultGameCheckbox;
    private JCheckBox dateLastPlayedCheckbox;
    private JComboBox difficultyComboBox;
    private JCheckBox favouriteGameCheckbox;
    private JTextField highScoreTextField;
    private JCheckBox includeAdultGameCheckbox;
    private JCheckBox includeDateLastPlayedCheckbox;
    private JCheckBox includeDifficultyCheckbox;
    private JCheckBox includeFavouriteGameCheckbox;
    private JCheckBox includeHighScoreCheckbox;
    private JCheckBox includeNotesCheckbox;
    private JCheckBox includeRatingCheckbox;
    private JCheckBox includeTimesPlayedCheckbox;
    private JTextArea notesTextArea;
    private JTabbedPane propertiesPane;
    private JComboBox ratingComboBox;
    private JLabel ratingIconLabel;
    private JCheckBox timesPlayedCheckbox;

    public PersonalInfoDialog(Game game) {
        this.isList = false;
        this.game = game;
        this.initComponents();
        this.selectIncludes(true);
        this.propertiesPane.remove(0);
        this.highScoreTextField.setText(game.getHighscore());
        this.difficultyComboBox.setModel(new DefaultComboBoxModel<Object>(new ItemViewFilter("Difficulty", 2, 3, 0, "Difficulty", "DI_Id", "", "").getSelections().toArray()));
        int i = 0;
        while (i < this.difficultyComboBox.getModel().getSize()) {
            if (((Selection)this.difficultyComboBox.getModel().getElementAt(i)).getValue().equals(String.valueOf(game.getDifficulty().getId()))) {
                this.difficultyComboBox.setSelectedIndex(i);
            }
            ++i;
        }
        this.ratingComboBox.setModel(new DefaultComboBoxModel<String>(Const.FORDISPLAY_RATING));
        this.ratingComboBox.setSelectedIndex(game.getRating());
        this.ratingIconLabel.setIcon(Const.LARGEICONS_GAMEINFO_RATING[this.ratingComboBox.getSelectedIndex()]);
        this.adultGameCheckbox.setSelected(game.getIsAdult());
        this.favouriteGameCheckbox.setSelected(game.getIsFavourite());
        this.notesTextArea.setText(game.getNote());
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public PersonalInfoDialog(List<Item> list) {
        this.isList = true;
        this.list = list;
        this.initComponents();
        this.selectIncludes(false);
        this.difficultyComboBox.setModel(new DefaultComboBoxModel<Object>(new ItemViewFilter("Difficulty", 2, 3, 0, "Difficulty", "DI_Id", "", "").getSelections().toArray()));
        this.difficultyComboBox.setSelectedIndex(7);
        this.ratingComboBox.setModel(new DefaultComboBoxModel<String>(Const.FORDISPLAY_RATING));
        this.ratingIconLabel.setIcon(Const.LARGEICONS_GAMEINFO_RATING[this.ratingComboBox.getSelectedIndex()]);
        this.setVisible(true);
    }

    private void initComponents() {
        this.propertiesPane = new JTabbedPane();
        Gui.fixLookAndFeel(this.propertiesPane);
        JPanel includePanel = new JPanel();
        JPanel jPanel1 = new JPanel();
        this.includeHighScoreCheckbox = new JCheckBox();
        this.includeAdultGameCheckbox = new JCheckBox();
        this.includeDifficultyCheckbox = new JCheckBox();
        this.includeFavouriteGameCheckbox = new JCheckBox();
        this.includeRatingCheckbox = new JCheckBox();
        this.includeNotesCheckbox = new JCheckBox();
        this.includeTimesPlayedCheckbox = new JCheckBox();
        JPanel jPanel3 = new JPanel();
        this.includeDateLastPlayedCheckbox = new JCheckBox();
        JPanel jPanel2 = new JPanel();
        JButton includeAllButton = new JButton();
        JButton includeNoneButton = new JButton();
        JPanel fieldsPanel = new JPanel();
        JLabel crackerLabel = new JLabel();
        this.difficultyComboBox = new JComboBox();
        JLabel noOfTrainersLabel = new JLabel();
        this.highScoreTextField = new JTextField();
        JLabel palNtscLabel = new JLabel();
        this.ratingComboBox = new JComboBox();
        this.timesPlayedCheckbox = new JCheckBox();
        JLabel notesLabel = new JLabel();
        this.dateLastPlayedCheckbox = new JCheckBox();
        this.adultGameCheckbox = new JCheckBox();
        this.favouriteGameCheckbox = new JCheckBox();
        this.ratingIconLabel = new JLabel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.notesTextArea = new JTextArea();
        JPanel OkCancelPanel = new JPanel();
        JPanel jPanel9 = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        this.setTitle("Personal Info Properties...");
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PersonalInfoDialog.this.exitFormWindowClosing(evt);
            }
        });
        includePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        includePanel.setLayout(new GridLayout(2, 1));
        jPanel1.setBorder(BorderFactory.createTitledBorder("Fields to update"));
        jPanel1.setLayout(new GridLayout(5, 2));
        this.includeHighScoreCheckbox.setMnemonic('H');
        this.includeHighScoreCheckbox.setText("High Score");
        this.includeHighScoreCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonalInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.includeHighScoreCheckbox);
        this.includeAdultGameCheckbox.setMnemonic('u');
        this.includeAdultGameCheckbox.setText("Adult Game");
        this.includeAdultGameCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonalInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.includeAdultGameCheckbox);
        this.includeDifficultyCheckbox.setMnemonic('D');
        this.includeDifficultyCheckbox.setText("Difficulty");
        this.includeDifficultyCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonalInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.includeDifficultyCheckbox);
        this.includeFavouriteGameCheckbox.setMnemonic('v');
        this.includeFavouriteGameCheckbox.setText("Favourite Game");
        this.includeFavouriteGameCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonalInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.includeFavouriteGameCheckbox);
        this.includeRatingCheckbox.setMnemonic('R');
        this.includeRatingCheckbox.setText("Rating");
        this.includeRatingCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonalInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.includeRatingCheckbox);
        this.includeNotesCheckbox.setMnemonic('e');
        this.includeNotesCheckbox.setText("Notes");
        this.includeNotesCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonalInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.includeNotesCheckbox);
        this.includeTimesPlayedCheckbox.setMnemonic('T');
        this.includeTimesPlayedCheckbox.setText("Times Played");
        this.includeTimesPlayedCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonalInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.includeTimesPlayedCheckbox);
        jPanel1.add(jPanel3);
        this.includeDateLastPlayedCheckbox.setMnemonic('L');
        this.includeDateLastPlayedCheckbox.setText("Date Last Played");
        this.includeDateLastPlayedCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonalInfoDialog.this.includesChangedActionPerformed(evt);
            }
        });
        jPanel1.add(this.includeDateLastPlayedCheckbox);
        includePanel.add(jPanel1);
        jPanel2.setLayout(new FlowLayout(0));
        includeAllButton.setMnemonic('A');
        includeAllButton.setText("Select All");
        includeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonalInfoDialog.this.selectAllIncludesActionPerformed(evt);
            }
        });
        jPanel2.add(includeAllButton);
        includeNoneButton.setMnemonic('N');
        includeNoneButton.setText("Select None");
        includeNoneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonalInfoDialog.this.selectNoneIncludesActionPerformed(evt);
            }
        });
        jPanel2.add(includeNoneButton);
        includePanel.add(jPanel2);
        this.propertiesPane.addTab("Include", includePanel);
        fieldsPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        fieldsPanel.setLayout(new GridBagLayout());
        crackerLabel.setDisplayedMnemonic('H');
        crackerLabel.setLabelFor(this.highScoreTextField);
        crackerLabel.setText("High Score:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        fieldsPanel.add((Component)crackerLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 15, 5);
        fieldsPanel.add((Component)this.difficultyComboBox, gridBagConstraints);
        noOfTrainersLabel.setDisplayedMnemonic('D');
        noOfTrainersLabel.setLabelFor(this.difficultyComboBox);
        noOfTrainersLabel.setText("Difficulty:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        fieldsPanel.add((Component)noOfTrainersLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        fieldsPanel.add((Component)this.highScoreTextField, gridBagConstraints);
        palNtscLabel.setDisplayedMnemonic('R');
        palNtscLabel.setLabelFor(this.ratingComboBox);
        palNtscLabel.setText("Rating:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        fieldsPanel.add((Component)palNtscLabel, gridBagConstraints);
        this.ratingComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonalInfoDialog.this.ratingChangedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        fieldsPanel.add((Component)this.ratingComboBox, gridBagConstraints);
        this.timesPlayedCheckbox.setMnemonic('T');
        this.timesPlayedCheckbox.setText("Reset Times Played");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        fieldsPanel.add((Component)this.timesPlayedCheckbox, gridBagConstraints);
        notesLabel.setDisplayedMnemonic('e');
        notesLabel.setLabelFor(this.notesTextArea);
        notesLabel.setText("Notes:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        fieldsPanel.add((Component)notesLabel, gridBagConstraints);
        this.dateLastPlayedCheckbox.setMnemonic('L');
        this.dateLastPlayedCheckbox.setText("Reset Date Last Played ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        fieldsPanel.add((Component)this.dateLastPlayedCheckbox, gridBagConstraints);
        this.adultGameCheckbox.setMnemonic('u');
        this.adultGameCheckbox.setText("Adult Game");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        fieldsPanel.add((Component)this.adultGameCheckbox, gridBagConstraints);
        this.favouriteGameCheckbox.setMnemonic('v');
        this.favouriteGameCheckbox.setText("Favourite Game");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        fieldsPanel.add((Component)this.favouriteGameCheckbox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 15, 0);
        fieldsPanel.add((Component)this.ratingIconLabel, gridBagConstraints);
        jScrollPane1.setVerticalScrollBarPolicy(22);
        this.notesTextArea.setLineWrap(true);
        jScrollPane1.setViewportView(this.notesTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        fieldsPanel.add((Component)jScrollPane1, gridBagConstraints);
        this.propertiesPane.addTab("Fields", fieldsPanel);
        this.getContentPane().add((Component)this.propertiesPane, "Center");
        OkCancelPanel.setLayout(new BorderLayout());
        jPanel9.setLayout(new FlowLayout(2));
        okButton.setMnemonic('O');
        okButton.setText("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonalInfoDialog.this.okActionPerformed(evt);
            }
        });
        jPanel9.add(okButton);
        cancelButton.setMnemonic('C');
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonalInfoDialog.this.cancelActionPerformed(evt);
            }
        });
        jPanel9.add(cancelButton);
        OkCancelPanel.add((Component)jPanel9, "South");
        this.getContentPane().add((Component)OkCancelPanel, "South");
        this.pack();
    }

    private void ratingChangedActionPerformed(ActionEvent evt) {
        this.ratingIconLabel.setIcon(Const.LARGEICONS_GAMEINFO_RATING[this.ratingComboBox.getSelectedIndex()]);
    }

    private void includesChangedActionPerformed(ActionEvent evt) {
        this.includesChanged();
    }

    private void selectNoneIncludesActionPerformed(ActionEvent evt) {
        this.selectIncludes(false);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void selectAllIncludesActionPerformed(ActionEvent evt) {
        this.selectIncludes(true);
    }

    private void selectIncludes(boolean b) {
        this.includeHighScoreCheckbox.setSelected(b);
        this.includeDifficultyCheckbox.setSelected(b);
        this.includeRatingCheckbox.setSelected(b);
        this.includeTimesPlayedCheckbox.setSelected(b);
        this.includeDateLastPlayedCheckbox.setSelected(b);
        this.includeAdultGameCheckbox.setSelected(b);
        this.includeFavouriteGameCheckbox.setSelected(b);
        this.includeNotesCheckbox.setSelected(b);
        this.includesChanged();
    }

    private void includesChanged() {
        this.highScoreTextField.setEnabled(this.includeHighScoreCheckbox.isSelected());
        this.difficultyComboBox.setEnabled(this.includeDifficultyCheckbox.isSelected());
        this.ratingComboBox.setEnabled(this.includeRatingCheckbox.isSelected());
        this.timesPlayedCheckbox.setEnabled(this.includeTimesPlayedCheckbox.isSelected());
        this.dateLastPlayedCheckbox.setEnabled(this.includeDateLastPlayedCheckbox.isSelected());
        this.adultGameCheckbox.setEnabled(this.includeAdultGameCheckbox.isSelected());
        this.favouriteGameCheckbox.setEnabled(this.includeFavouriteGameCheckbox.isSelected());
        this.notesTextArea.setEnabled(this.includeNotesCheckbox.isSelected());
    }

    private void okActionPerformed(ActionEvent evt) {
        if (!this.isList) {
            this.list = new ArrayList<Item>();
            this.list.add(this.game);
        }
        for (Item item : this.list) {
            if (!(item instanceof Game)) continue;
            Game game = (Game)item;
            if (this.includeHighScoreCheckbox.isSelected()) {
                game.setHighscore(this.highScoreTextField.getText().trim());
            }
            if (this.includeDifficultyCheckbox.isSelected()) {
                game.setDifficulty(Db.getDifficultyById(Integer.parseInt(((Selection)this.difficultyComboBox.getSelectedItem()).getValue())));
            }
            if (this.includeRatingCheckbox.isSelected()) {
                game.setRating(this.ratingComboBox.getSelectedIndex());
            }
            if (this.includeTimesPlayedCheckbox.isSelected()) {
                game.setTimesPlayed(0);
            }
            if (this.includeDateLastPlayedCheckbox.isSelected()) {
                game.setDateLastPlayed("");
            }
            if (this.includeAdultGameCheckbox.isSelected()) {
                game.setIsAdult(this.adultGameCheckbox.isSelected());
            }
            if (this.includeFavouriteGameCheckbox.isSelected()) {
                game.setIsFavourite(this.favouriteGameCheckbox.isSelected());
            }
            if (this.includeNotesCheckbox.isSelected()) {
                game.setNote(this.notesTextArea.getText().trim());
            }
            Db.saveOrUpdate(game);
        }
        this.dispose();
    }

    private void exitFormWindowClosing(WindowEvent evt) {
        this.dispose();
    }
}

