/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jgamebase.Const;
import jgamebase.db.model.Game;
import jgamebase.gui.Gui;
import jgamebase.gui.ListListModel;
import jgamebase.gui.PathsDialog;
import jgamebase.model.FileExtensions;
import jgamebase.model.Paths;
import jgamebase.tools.FileTools;
import jgamebase.tools.ListerTools;

public class ScreenshotChooserDialog
extends JDialog {
    private static final long serialVersionUID = 3397467278697607752L;
    private String path;
    private boolean pathAdjusting = false;
    private Const.CloseAction closeAction = Const.CloseAction.CANCEL;
    private final Object[] fileFilters = new Object[]{new FileFilter("All files", "*"), new FileFilter("Only graphic files", "jpg;png;gif;tif;bmp")};
    private JComboBox fileFilterComboBox;
    private JTable fileSelectionTable;
    private JComboBox pathSelectionComboBox;
    private JList pathSelectionList;
    private JLabel preview;
    protected String selectedFilename = "";

    public ScreenshotChooserDialog(Game game) {
        this.init();
        if (Paths.getScreenshotPath().exists(new File(game.getScreenshotFilename()))) {
            String filename = game.getScreenshotFilename();
            this.path = Paths.getScreenshotPath().findAndWarn(new File(filename)) != null ? Paths.getScreenshotPath().findAndWarn(new File(filename)).getPath() : "";
            this.selectedFilename = Paths.removePath(game.getScreenshotFilename());
            this.path = this.path.substring(0, this.path.length() - this.selectedFilename.length());
            Object[] basePaths = ListerTools.fileListToStringList(Paths.getScreenshotPath().getWithDefault()).toArray();
            String basePath = Paths.getScreenshotPath().whichBasePath(new File(game.getScreenshotFilename())).getPath();
            int i = 0;
            while (i < basePaths.length) {
                if (basePath.equals(Paths.pathEndingWithSeparator((String)basePaths[i]))) {
                    this.pathAdjusting = true;
                    this.pathSelectionComboBox.setSelectedIndex(i);
                    this.pathAdjusting = false;
                }
                ++i;
            }
        }
        this.fillPathSelectionList();
        this.fillFileSelectionTable();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void init() {
        this.initComponents();
        this.pathSelectionComboBox.setModel(new DefaultComboBoxModel<Object>(ListerTools.fileListToStringList(Paths.getScreenshotPath().getWithDefault()).toArray()));
        this.pathSelectionList.setCellRenderer(new PathSelectionRenderer());
        this.pathSelectionList.setModel(new ListListModel());
        this.path = "";
        if (this.pathSelectionComboBox.getSelectedItem() != null && this.pathSelectionComboBox.getSelectedItem() instanceof String) {
            this.path = (String)this.pathSelectionComboBox.getSelectedItem();
        }
        this.fillPathSelectionList();
        this.fileFilterComboBox.setModel(new DefaultComboBoxModel<Object>(this.fileFilters));
        this.fileSelectionTable.setDefaultRenderer(Object.class, new FileSelectionRenderer());
        this.fillFileSelectionTable();
        Gui.fixLookAndFeel(this.fileSelectionTable);
        this.pack();
    }

    private String getBasePath() {
        if (this.pathSelectionComboBox.getSelectedItem() != null && this.pathSelectionComboBox.getSelectedItem() instanceof String) {
            return Paths.pathEndingWithSeparator((String)this.pathSelectionComboBox.getSelectedItem());
        }
        return "";
    }

    private String getPathWithoutBasePath() {
        if (this.getBasePath().isEmpty() || this.path.isEmpty() || this.getBasePath().length() >= this.path.length()) {
            return "";
        }
        return this.path.substring(this.getBasePath().length());
    }

    private void fillPathSelectionList() {
        ArrayList<PathSelection> paths = new ArrayList<PathSelection>();
        int indentation = 0;
        this.pathAdjusting = true;
        paths.add(new PathSelection(0, this.getBasePath()));
        ++indentation;
        String dirPath = "";
        StringTokenizer st = new StringTokenizer(this.getPathWithoutBasePath(), File.separator);
        while (st.hasMoreTokens()) {
            dirPath = String.valueOf(dirPath) + Paths.pathEndingWithSeparator(st.nextToken());
            if (!new File(String.valueOf(this.getBasePath()) + dirPath).isDirectory()) continue;
            paths.add(new PathSelection(++indentation, String.valueOf(this.getBasePath()) + Paths.pathStartingWithoutSeparator(dirPath)));
        }
        ++indentation;
        List<String> dirs = ListerTools.list_Dirs_Files_Paths(this.path, true, false, true);
        Collections.sort(dirs, new Comparator(){

            public int compare(Object o1, Object o2) {
                return FileTools.removeExtension(Paths.removePath(((String)o1).toLowerCase())).compareTo(FileTools.removeExtension(Paths.removePath(((String)o2).toLowerCase())));
            }
        });
        for (String dir : dirs) {
            paths.add(new PathSelection(indentation, dir));
        }
        ((ListListModel)this.pathSelectionList.getModel()).set(paths);
        int i = 0;
        while (i < paths.size()) {
            if (this.path.startsWith(((PathSelection)this.pathSelectionList.getModel().getElementAt(i)).getPath())) {
                this.pathSelectionList.setSelectedIndex(i);
            }
            ++i;
        }
        this.pathSelectionList.setSelectedValue(this.pathSelectionList.getSelectedValue(), true);
        this.pathAdjusting = false;
    }

    private void fillFileSelectionTable() {
        List<String> files = new FileExtensions(((FileFilter)this.fileFilterComboBox.getSelectedItem()).getExtensions()).getMatching(ListerTools.list_Dirs_Files_Paths(this.path, false, true, false));
        Collections.sort(files, new Comparator(){

            public int compare(Object o1, Object o2) {
                return FileTools.removeExtension(Paths.removePath(((String)o1).toLowerCase())).compareTo(FileTools.removeExtension(Paths.removePath(((String)o2).toLowerCase())));
            }
        });
        Vector<String> headings = new Vector<String>();
        headings.addElement("Filename");
        Vector data = new Vector();
        files.stream().map(element -> element).forEach(filename -> {
            Vector<String> row = new Vector<String>();
            row.addElement((String)filename);
            data.addElement(row);
        });
        ((DefaultTableModel)this.fileSelectionTable.getModel()).setDataVector(data, headings);
        int row = 0;
        while (row < this.fileSelectionTable.getRowCount()) {
            String filenameFromTable = (String)this.fileSelectionTable.getValueAt(row, 0);
            if (this.selectedFilename.equals(filenameFromTable)) {
                ListSelectionModel rowSM = this.fileSelectionTable.getSelectionModel();
                rowSM.setSelectionInterval(row, row);
                this.fileSelectionTable.scrollRectToVisible(this.fileSelectionTable.getCellRect(row, 0, true));
            }
            ++row;
        }
    }

    private void initComponents() {
        JPanel mainPanel = new JPanel();
        JPanel pathSelectionPanel = new JPanel();
        this.pathSelectionComboBox = new JComboBox();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.pathSelectionList = new JList();
        JButton jButton2 = new JButton();
        JPanel fileSelectionPanel = new JPanel();
        this.fileFilterComboBox = new JComboBox();
        JButton fileSelectionButton = new JButton();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.fileSelectionTable = new JTable();
        JLabel jLabel1 = new JLabel();
        JPanel previewPanel = new JPanel();
        this.preview = new JLabel();
        JPanel OkCancelPanel = new JPanel();
        JPanel jPanel9 = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        this.setTitle("Screenshot Selector");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ScreenshotChooserDialog.this.exitFormWindowClosing(evt);
            }
        });
        mainPanel.setLayout(new GridBagLayout());
        pathSelectionPanel.setBorder(BorderFactory.createTitledBorder("1. Select Path"));
        pathSelectionPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 3, 2);
        pathSelectionPanel.add((Component)this.pathSelectionComboBox, gridBagConstraints);
        this.pathSelectionList.setSelectionMode(0);
        this.pathSelectionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ScreenshotChooserDialog.this.pathSelected_ValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(this.pathSelectionList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        pathSelectionPanel.add((Component)jScrollPane1, gridBagConstraints);
        jButton2.setMnemonic('E');
        jButton2.setText("Edit");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScreenshotChooserDialog.this.editPaths_ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 2, 3, 5);
        pathSelectionPanel.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        mainPanel.add((Component)pathSelectionPanel, gridBagConstraints);
        fileSelectionPanel.setBorder(BorderFactory.createTitledBorder("2. Select File"));
        fileSelectionPanel.setLayout(new GridBagLayout());
        this.fileFilterComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScreenshotChooserDialog.this.fileFilterSelected_ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 3, 2);
        fileSelectionPanel.add((Component)this.fileFilterComboBox, gridBagConstraints);
        fileSelectionButton.setMnemonic('R');
        fileSelectionButton.setText("Refresh");
        fileSelectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScreenshotChooserDialog.this.refreshFiles_ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 3, 5);
        fileSelectionPanel.add((Component)fileSelectionButton, gridBagConstraints);
        this.fileSelectionTable.setAutoCreateRowSorter(true);
        this.fileSelectionTable.setToolTipText("Edit to rename file.");
        this.fileSelectionTable.setFillsViewportHeight(true);
        this.fileSelectionTable.setShowHorizontalLines(false);
        this.fileSelectionTable.setShowVerticalLines(false);
        ListSelectionModel rowSM = this.fileSelectionTable.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedRow = lsm.getMinSelectionIndex();
                    ScreenshotChooserDialog.this.fileSelected(selectedRow);
                }
            }
        });
        TableCellEditor editor = this.fileSelectionTable.getDefaultEditor(Object.class);
        editor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                ScreenshotChooserDialog.this.fileRenamed();
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        jScrollPane2.setViewportView(this.fileSelectionTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.9;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        fileSelectionPanel.add((Component)jScrollPane2, gridBagConstraints);
        jLabel1.setText("Filter:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 3, 2);
        fileSelectionPanel.add((Component)jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        mainPanel.add((Component)fileSelectionPanel, gridBagConstraints);
        previewPanel.setBorder(BorderFactory.createTitledBorder("Preview"));
        previewPanel.setLayout(new GridBagLayout());
        this.preview.setMaximumSize(new Dimension(320, 200));
        this.preview.setMinimumSize(new Dimension(320, 200));
        this.preview.setPreferredSize(new Dimension(320, 200));
        previewPanel.add((Component)this.preview, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        mainPanel.add((Component)previewPanel, gridBagConstraints);
        this.getContentPane().add((Component)mainPanel, "Center");
        OkCancelPanel.setLayout(new BorderLayout());
        jPanel9.setLayout(new FlowLayout(2));
        okButton.setMnemonic('O');
        okButton.setText("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScreenshotChooserDialog.this.okActionPerformed(evt);
            }
        });
        jPanel9.add(okButton);
        cancelButton.setMnemonic('C');
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScreenshotChooserDialog.this.cancelActionPerformed(evt);
            }
        });
        jPanel9.add(cancelButton);
        OkCancelPanel.add((Component)jPanel9, "South");
        this.getContentPane().add((Component)OkCancelPanel, "South");
    }

    private void fileFilterSelected_ActionPerformed(ActionEvent evt) {
        this.fillFileSelectionTable();
    }

    private void okActionPerformed(ActionEvent evt) {
        this.closeAction = Const.CloseAction.OK;
        this.dispose();
    }

    protected String getFilename() {
        int selectedRow = this.fileSelectionTable.getSelectedRow();
        if (this.fileSelectionTable.getValueAt(selectedRow, 0) != null && this.fileSelectionTable.getValueAt(selectedRow, 0) instanceof String) {
            return Paths.pathStartingWithoutSeparator(String.valueOf(Paths.pathEndingWithSeparator(this.getPathWithoutBasePath())) + this.fileSelectionTable.getValueAt(selectedRow, 0));
        }
        return "";
    }

    private void pathSelected_ValueChanged(ListSelectionEvent evt) {
        if (this.pathAdjusting) {
            return;
        }
        if (this.pathSelectionList.getSelectedValue() != null && this.pathSelectionList.getSelectedValue() instanceof PathSelection) {
            this.path = ((PathSelection)this.pathSelectionList.getSelectedValue()).getPath();
        }
        this.fillPathSelectionList();
        this.fillFileSelectionTable();
    }

    private void refreshFiles_ActionPerformed(ActionEvent evt) {
        this.fillFileSelectionTable();
    }

    private void exitFormWindowClosing(WindowEvent evt) {
        this.closeAction = Const.CloseAction.CANCEL;
        this.dispose();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeAction = Const.CloseAction.CANCEL;
        this.dispose();
    }

    private void editPaths_ActionPerformed(ActionEvent evt) {
        new PathsDialog();
        this.pathSelectionComboBox.setModel(new DefaultComboBoxModel<Object>(ListerTools.fileListToStringList(Paths.getScreenshotPath().getWithDefault()).toArray()));
        this.fillPathSelectionList();
        this.fillFileSelectionTable();
    }

    public Const.CloseAction getCloseAction() {
        return this.closeAction;
    }

    private void fileSelected(int selectedRow) {
        if (this.fileSelectionTable.getValueAt(selectedRow, 0) != null && this.fileSelectionTable.getValueAt(selectedRow, 0) instanceof String) {
            this.selectedFilename = (String)this.fileSelectionTable.getValueAt(selectedRow, 0);
            this.preview.setIcon(new ImageIcon(String.valueOf(this.path) + this.selectedFilename));
        }
    }

    private void fileRenamed() {
        int selectedRow = this.fileSelectionTable.getSelectedRow();
        if (this.fileSelectionTable.getValueAt(selectedRow, 0) != null && this.fileSelectionTable.getValueAt(selectedRow, 0) instanceof String) {
            String newFilename = (String)this.fileSelectionTable.getValueAt(selectedRow, 0);
            File oldFile = new File(String.valueOf(this.path) + this.selectedFilename);
            File newFile = new File(String.valueOf(this.path) + newFilename);
            oldFile.renameTo(newFile);
            this.selectedFilename = newFilename;
            Const.log.info((Object)(String.valueOf(this.selectedFilename) + "=>" + newFilename));
            this.fillFileSelectionTable();
        }
    }

    static class FileFilter {
        private final String name;
        private final String extensions;

        public FileFilter(String name, String extensions) {
            this.name = name;
            this.extensions = extensions;
        }

        public String getExtensions() {
            return this.extensions;
        }

        public String toString() {
            return this.name;
        }
    }

    static class FileSelectionRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 96832660663632311L;
        private static final String graphicExtensions = "jpg;png;gif;tif;bmp";

        public FileSelectionRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected || hasFocus) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setFont(table.getFont());
            if (value instanceof String) {
                char c;
                this.setIcon(Const.ICON_GS_FILE);
                String filename = (String)value;
                String extension = FileTools.getExtension(filename);
                String filenameWithoutExtension = FileTools.removeExtension(filename);
                if (graphicExtensions.contains(extension.toLowerCase())) {
                    this.setIcon(Const.ICON_GS_GRAPHIC);
                }
                this.setFont(this.getFont().deriveFont(1));
                if (filename.contains("_") && filename.lastIndexOf("_") == filenameWithoutExtension.length() - 2 && ((c = filenameWithoutExtension.charAt(filenameWithoutExtension.length() - 1)) == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9')) {
                    this.setFont(this.getFont().deriveFont(0));
                }
                if ((filename = Paths.pathEndingWithoutSeparator(filename)).contains(File.separator)) {
                    filename = filename.substring(filename.lastIndexOf(File.separator), filename.length());
                }
                filename = Paths.pathStartingWithoutSeparator(filename);
                this.setText(filename);
            }
            return this;
        }
    }

    static class PathSelection {
        private final int indentation;
        private final String path;

        public PathSelection(int indentation, String path) {
            this.indentation = indentation;
            this.path = Paths.pathEndingWithSeparator(path);
        }

        public int getIndentation() {
            return this.indentation;
        }

        public String getPath() {
            return this.path;
        }
    }

    static class PathSelectionRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -1237522124336543453L;

        public PathSelectionRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected || cellHasFocus) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            if (value instanceof PathSelection) {
                if (isSelected || cellHasFocus) {
                    this.setIcon(Const.ICON_GS_FOLDER_OPEN);
                } else {
                    this.setIcon(Const.ICON_GS_FOLDER);
                }
                PathSelection selection = (PathSelection)value;
                String pathName = selection.getPath();
                int indentation = selection.getIndentation();
                pathName = pathName.substring(0, pathName.length() - 1);
                if (pathName.contains(File.separator)) {
                    pathName = pathName.substring(pathName.lastIndexOf(File.separator), pathName.length());
                }
                pathName = Paths.pathStartingWithoutSeparator(pathName);
                this.setText(pathName);
                this.setBorder(new EmptyBorder(new Insets(0, indentation * 10, 0, 0)));
            }
            return this;
        }
    }
}

