/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.model;

import java.util.Enumeration;
import java.util.Hashtable;
import jgamebase.model.Plugin;
import jgamebase.plugins.DiskInfo;
import jgamebase.plugins.Extractor;
import jgamebase.plugins.MusicInfo;
import jgamebase.plugins.diskinfo.ADF;
import jgamebase.plugins.diskinfo.CRT;
import jgamebase.plugins.diskinfo.D64;
import jgamebase.plugins.diskinfo.T64;
import jgamebase.plugins.extractor.Zip;
import jgamebase.plugins.musicinfo.SID;

public class Plugins {
    private static Hashtable<String, Plugin> diskInfo;
    private static Hashtable<String, Plugin> musicInfo;
    private static Hashtable<String, Plugin> extractor;

    private Plugins() {
    }

    public static void initExtractorPlugins() {
        extractor = new Hashtable();
        extractor = Plugins.addPlugin(extractor, new Zip());
    }

    public static void initDiskInfoPlugins() {
        diskInfo = new Hashtable();
        diskInfo = Plugins.addPlugin(diskInfo, new ADF());
        diskInfo = Plugins.addPlugin(diskInfo, new CRT());
        diskInfo = Plugins.addPlugin(diskInfo, new D64());
        diskInfo = Plugins.addPlugin(diskInfo, new T64());
    }

    public static void initMusicInfoPlugins() {
        musicInfo = new Hashtable();
        musicInfo = Plugins.addPlugin(musicInfo, new SID());
    }

    private static Hashtable<String, Plugin> addPlugin(Hashtable<String, Plugin> plugins, Plugin plugin) {
        String[] supportedExtensions;
        String[] stringArray = supportedExtensions = plugin.getSupportedExtensions();
        int n = supportedExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String supportedExtension = stringArray[n2];
            plugins.put(supportedExtension, plugin);
            ++n2;
        }
        return plugins;
    }

    public static DiskInfo getDiskInfoForExtension(String extension) {
        if (Plugins.existsDiskInfoForExtension(extension) && diskInfo.get(extension) instanceof DiskInfo) {
            return (DiskInfo)diskInfo.get(extension);
        }
        return null;
    }

    public static boolean existsDiskInfoForExtension(String extension) {
        return diskInfo.containsKey(extension);
    }

    public static String getSupportedDiskInfoExtension() {
        StringBuilder supportedExtensions = new StringBuilder();
        Enumeration<String> enumeration = diskInfo.keys();
        while (enumeration.hasMoreElements()) {
            String extension = enumeration.nextElement();
            supportedExtensions.append(extension);
            if (!enumeration.hasMoreElements()) continue;
            supportedExtensions.append(";");
        }
        return supportedExtensions.toString();
    }

    public static MusicInfo getMusicInfoForExtension(String extension) {
        if (Plugins.existsMusicInfoForExtension(extension) && musicInfo.get(extension) instanceof MusicInfo) {
            return (MusicInfo)musicInfo.get(extension);
        }
        return null;
    }

    public static boolean existsMusicInfoForExtension(String extension) {
        return musicInfo.containsKey(extension);
    }

    public static String getSupportedMusicInfoExtension() {
        StringBuilder supportedExtensions = new StringBuilder();
        Enumeration<String> enumeration = musicInfo.keys();
        while (enumeration.hasMoreElements()) {
            String extension = enumeration.nextElement();
            supportedExtensions.append(extension);
            if (!enumeration.hasMoreElements()) continue;
            supportedExtensions.append(";");
        }
        return supportedExtensions.toString();
    }

    public static Extractor getExtractorForExtension(String extension) {
        if (Plugins.existsExtractorForExtension(extension) && extractor.get(extension) instanceof Extractor) {
            return (Extractor)extractor.get(extension);
        }
        return null;
    }

    public static boolean existsExtractorForExtension(String extension) {
        return extractor.containsKey(extension);
    }

    public static String getSupportedExtractorExtension() {
        StringBuilder supportedExtensions = new StringBuilder();
        Enumeration<String> enumeration = extractor.keys();
        while (enumeration.hasMoreElements()) {
            String extension = enumeration.nextElement();
            supportedExtensions.append(extension);
            if (!enumeration.hasMoreElements()) continue;
            supportedExtensions.append(";");
        }
        return supportedExtensions.toString();
    }
}

